/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.RevokedSecurityGroupRule;
import software.amazon.awssdk.services.ec2.model.RevokedSecurityGroupRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeSecurityGroupIngressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RevokeSecurityGroupIngressResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(RevokeSecurityGroupIngressResponse.getter(RevokeSecurityGroupIngressResponse::returnValue)).setter(RevokeSecurityGroupIngressResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<List<IpPermission>> UNKNOWN_IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnknownIpPermissions").getter(RevokeSecurityGroupIngressResponse.getter(RevokeSecurityGroupIngressResponse::unknownIpPermissions)).setter(RevokeSecurityGroupIngressResponse.setter(Builder::unknownIpPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownIpPermissionSet").unmarshallLocationName("unknownIpPermissionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<RevokedSecurityGroupRule>> REVOKED_SECURITY_GROUP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevokedSecurityGroupRules").getter(RevokeSecurityGroupIngressResponse.getter(RevokeSecurityGroupIngressResponse::revokedSecurityGroupRules)).setter(RevokeSecurityGroupIngressResponse.setter(Builder::revokedSecurityGroupRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedSecurityGroupRuleSet").unmarshallLocationName("revokedSecurityGroupRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevokedSecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, UNKNOWN_IP_PERMISSIONS_FIELD, REVOKED_SECURITY_GROUP_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeSecurityGroupIngressResponse.memberNameToFieldInitializer();
    private final Boolean returnValue;
    private final List<IpPermission> unknownIpPermissions;
    private final List<RevokedSecurityGroupRule> revokedSecurityGroupRules;

    private RevokeSecurityGroupIngressResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.unknownIpPermissions = builder.unknownIpPermissions;
        this.revokedSecurityGroupRules = builder.revokedSecurityGroupRules;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final boolean hasUnknownIpPermissions() {
        return this.unknownIpPermissions != null && !(this.unknownIpPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> unknownIpPermissions() {
        return this.unknownIpPermissions;
    }

    public final boolean hasRevokedSecurityGroupRules() {
        return this.revokedSecurityGroupRules != null && !(this.revokedSecurityGroupRules instanceof SdkAutoConstructList);
    }

    public final List<RevokedSecurityGroupRule> revokedSecurityGroupRules() {
        return this.revokedSecurityGroupRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnknownIpPermissions() ? this.unknownIpPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokedSecurityGroupRules() ? this.revokedSecurityGroupRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupIngressResponse)) {
            return false;
        }
        RevokeSecurityGroupIngressResponse other = (RevokeSecurityGroupIngressResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && this.hasUnknownIpPermissions() == other.hasUnknownIpPermissions() && Objects.equals(this.unknownIpPermissions(), other.unknownIpPermissions()) && this.hasRevokedSecurityGroupRules() == other.hasRevokedSecurityGroupRules() && Objects.equals(this.revokedSecurityGroupRules(), other.revokedSecurityGroupRules());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeSecurityGroupIngressResponse").add("Return", (Object)this.returnValue()).add("UnknownIpPermissions", this.hasUnknownIpPermissions() ? this.unknownIpPermissions() : null).add("RevokedSecurityGroupRules", this.hasRevokedSecurityGroupRules() ? this.revokedSecurityGroupRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "UnknownIpPermissions": {
                return Optional.ofNullable(clazz.cast(this.unknownIpPermissions()));
            }
            case "RevokedSecurityGroupRules": {
                return Optional.ofNullable(clazz.cast(this.revokedSecurityGroupRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Return", RETURN_FIELD);
        map.put("UnknownIpPermissionSet", UNKNOWN_IP_PERMISSIONS_FIELD);
        map.put("RevokedSecurityGroupRuleSet", REVOKED_SECURITY_GROUP_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupIngressResponse, T> g) {
        return obj -> g.apply((RevokeSecurityGroupIngressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private List<IpPermission> unknownIpPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<RevokedSecurityGroupRule> revokedSecurityGroupRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupIngressResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.unknownIpPermissions(model.unknownIpPermissions);
            this.revokedSecurityGroupRules(model.revokedSecurityGroupRules);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<IpPermission.Builder> getUnknownIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.unknownIpPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnknownIpPermissions(Collection<IpPermission.BuilderImpl> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copyFromBuilder(unknownIpPermissions);
        }

        @Override
        public final Builder unknownIpPermissions(Collection<IpPermission> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copy(unknownIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unknownIpPermissions(IpPermission ... unknownIpPermissions) {
            this.unknownIpPermissions(Arrays.asList(unknownIpPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unknownIpPermissions(Consumer<IpPermission.Builder> ... unknownIpPermissions) {
            this.unknownIpPermissions(Stream.of(unknownIpPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RevokedSecurityGroupRule.Builder> getRevokedSecurityGroupRules() {
            List<RevokedSecurityGroupRule.Builder> result = RevokedSecurityGroupRuleListCopier.copyToBuilder(this.revokedSecurityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokedSecurityGroupRules(Collection<RevokedSecurityGroupRule.BuilderImpl> revokedSecurityGroupRules) {
            this.revokedSecurityGroupRules = RevokedSecurityGroupRuleListCopier.copyFromBuilder(revokedSecurityGroupRules);
        }

        @Override
        public final Builder revokedSecurityGroupRules(Collection<RevokedSecurityGroupRule> revokedSecurityGroupRules) {
            this.revokedSecurityGroupRules = RevokedSecurityGroupRuleListCopier.copy(revokedSecurityGroupRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokedSecurityGroupRules(RevokedSecurityGroupRule ... revokedSecurityGroupRules) {
            this.revokedSecurityGroupRules(Arrays.asList(revokedSecurityGroupRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokedSecurityGroupRules(Consumer<RevokedSecurityGroupRule.Builder> ... revokedSecurityGroupRules) {
            this.revokedSecurityGroupRules(Stream.of(revokedSecurityGroupRules).map(c -> (RevokedSecurityGroupRule)((RevokedSecurityGroupRule.Builder)RevokedSecurityGroupRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RevokeSecurityGroupIngressResponse build() {
            return new RevokeSecurityGroupIngressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeSecurityGroupIngressResponse> {
        public Builder returnValue(Boolean var1);

        public Builder unknownIpPermissions(Collection<IpPermission> var1);

        public Builder unknownIpPermissions(IpPermission ... var1);

        public Builder unknownIpPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder revokedSecurityGroupRules(Collection<RevokedSecurityGroupRule> var1);

        public Builder revokedSecurityGroupRules(RevokedSecurityGroupRule ... var1);

        public Builder revokedSecurityGroupRules(Consumer<RevokedSecurityGroupRule.Builder> ... var1);
    }
}

