/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameContainer;
import com.sun.star.deployment.XPackage;
import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XTransientDocumentsDocumentContentFactory;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.browse.DialogFactory;
import com.sun.star.script.framework.browse.ProviderBrowseNode;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.container.UnoPkgContainer;
import com.sun.star.script.framework.container.XMLParserFactory;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.script.provider.XScriptProvider;
import com.sun.star.sdbc.XRow;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.UniversalContentBroker;
import com.sun.star.ucb.XCommandEnvironment;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XContent;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.ucb.XUniversalContentBroker;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XMacroExpander;

public abstract class ScriptProvider
implements XScriptProvider,
XBrowseNode,
XPropertySet,
XInvocation,
XInitialization,
XTypeProvider,
XServiceInfo,
XNameContainer {
    private final String[] __serviceNames = new String[]{"com.sun.star.script.provider.ScriptProviderFor", "com.sun.star.script.provider.LanguageScriptProvider", "com.sun.star.script.browse.BrowseNode", "com.sun.star.script.provider.ScriptProvider"};
    protected String language;
    protected XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    protected XModel m_xModel;
    protected XScriptInvocationContext m_xInvocContext;
    private ParcelContainer m_container;
    private XPropertySet m_xPropertySetProxy;
    private XInvocation m_xInvocationProxy;
    private XBrowseNode m_xBrowseNodeProxy;
    private XScriptContext m_xScriptContext;

    public ScriptProvider(XComponentContext xComponentContext, String string) {
        this.language = string;
        this.__serviceNames[0] = this.__serviceNames[0] + string;
        LogUtils.DEBUG("ScriptProvider: constructor - start. " + string);
        this.m_xContext = xComponentContext;
        DialogFactory.createDialogFactory(this.m_xContext);
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
            if (this.m_xMultiComponentFactory == null) {
                throw new com.sun.star.uno.Exception("Error could not obtain a multicomponent factory - rethrowing Exception.");
            }
            Object object = this.m_xContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander");
            XMacroExpander xMacroExpander = (XMacroExpander)AnyConverter.toObject((Type)new Type(XMacroExpander.class), (Object)object);
            XMLParserFactory.setOfficeDTDURL(xMacroExpander.expandMacros("$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR/dtd/officedocument/1_0/"));
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG(LogUtils.getTrace((Exception)((Object)exception)));
            throw new RuntimeException((Throwable)exception, "Error constructing  ScriptProvider: " + (Object)((Object)exception));
        }
        LogUtils.DEBUG("ScriptProvider: constructor - finished.");
    }

    public synchronized XScriptContext getScriptingContext() {
        if (this.m_xScriptContext == null) {
            this.m_xScriptContext = ScriptContext.createContext(this.m_xModel, this.m_xInvocContext, this.m_xContext, this.m_xMultiComponentFactory);
        }
        return this.m_xScriptContext;
    }

    public void initialize(Object[] objectArray) throws com.sun.star.uno.Exception {
        LogUtils.DEBUG("entering XInit for language " + this.language);
        boolean bl = false;
        if (objectArray.length == 1) {
            String string = null;
            if (AnyConverter.getType((Object)objectArray[0]).getTypeClass().equals(TypeClass.INTERFACE)) {
                this.m_xInvocContext = (XScriptInvocationContext)UnoRuntime.queryInterface(XScriptInvocationContext.class, (Object)objectArray[0]);
                this.m_xModel = this.m_xInvocContext != null ? (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.m_xInvocContext.getScriptContainer()) : (XModel)UnoRuntime.queryInterface(XModel.class, (Object)objectArray[0]);
                if (this.m_xModel == null) {
                    throw new com.sun.star.uno.Exception("ScriptProvider argument must be either a string, a valid XScriptInvocationContext, or an XModel", (Object)this);
                }
                string = this.getDocUrlFromModel(this.m_xModel);
                this.m_container = new ParcelContainer(this.m_xContext, string, this.language);
            } else if (AnyConverter.isString((Object)objectArray[0])) {
                String string2 = AnyConverter.toString((Object)objectArray[0]);
                LogUtils.DEBUG("creating Application, path: " + string2);
                string = string2;
                if (string2.startsWith("vnd.sun.star.tdoc")) {
                    this.m_container = new ParcelContainer(this.m_xContext, string, this.language);
                    this.m_xModel = this.getModelFromDocUrl(string2);
                } else {
                    String string3 = "vnd.sun.star.expand:${$BRAND_INI_DIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                    String string4 = null;
                    if (string2.startsWith("bundled")) {
                        string = "vnd.sun.star.expand:$BUNDLED_EXTENSIONS";
                        string4 = "bundled";
                    } else if (string2.startsWith("share")) {
                        string = "vnd.sun.star.expand:$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR";
                        string4 = "shared";
                    } else if (string2.startsWith("user")) {
                        string = "vnd.sun.star.expand:${$BRAND_INI_DIR/" + PathUtils.BOOTSTRAP_NAME + "::UserInstallation}/user";
                        string4 = "user";
                    }
                    if (string2.endsWith("uno_packages")) {
                        bl = true;
                        if (!string2.equals(string) && string4 != null && !string4.equals("bundled")) {
                            string = PathUtils.make_url(string, "uno_packages");
                        }
                    }
                    this.m_container = bl ? new UnoPkgContainer(this.m_xContext, string, string3, string4, this.language) : new ParcelContainer(this.m_xContext, string, this.language);
                }
            } else {
                throw new RuntimeException("ScriptProvider created with invalid argument");
            }
            LogUtils.DEBUG("Modified Application path is: " + string);
            LogUtils.DEBUG("isPkgProvider is: " + bl);
            this.m_xBrowseNodeProxy = new ProviderBrowseNode(this, this.m_container, this.m_xContext);
            this.m_xInvocationProxy = (XInvocation)UnoRuntime.queryInterface(XInvocation.class, (Object)this.m_xBrowseNodeProxy);
            this.m_xPropertySetProxy = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xBrowseNodeProxy);
        } else {
            LogUtils.DEBUG("ScriptProviderFor" + this.language + " initialized without a context");
        }
        LogUtils.DEBUG("leaving XInit");
    }

    public Type[] getTypes() {
        Type[] typeArray = new Type[]{new Type(XScriptProvider.class), new Type(XBrowseNode.class), new Type(XInitialization.class), new Type(XTypeProvider.class), new Type(XServiceInfo.class), new Type(XPropertySet.class), new Type(XInvocation.class), new Type(XNameContainer.class)};
        return typeArray;
    }

    public byte[] getImplementationId() {
        return new byte[0];
    }

    public String getImplementationName() {
        return this.getClass().getName();
    }

    public boolean supportsService(String string) {
        int n = this.__serviceNames.length;
        while (n-- > 0) {
            if (!string.equals(this.__serviceNames[n])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return this.__serviceNames;
    }

    public abstract XScript getScript(String var1) throws RuntimeException, ScriptFrameworkErrorException;

    public abstract boolean hasScriptEditor();

    public abstract ScriptEditor getScriptEditor();

    public ScriptMetaData getScriptData(String string) throws ScriptFrameworkErrorException {
        try {
            ParsedScriptUri parsedScriptUri = this.m_container.parseScriptUri(string);
            try {
                ScriptMetaData scriptMetaData = this.m_container.findScript(parsedScriptUri);
                if (scriptMetaData == null) {
                    throw new ScriptFrameworkErrorException(parsedScriptUri.function + " does not exist", null, parsedScriptUri.function, this.language, 2);
                }
                return scriptMetaData;
            }
            catch (NoSuchElementException noSuchElementException) {
                ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(noSuchElementException.getMessage(), null, parsedScriptUri.function, this.language, 2);
                scriptFrameworkErrorException.initCause((Throwable)noSuchElementException);
                throw scriptFrameworkErrorException;
            }
            catch (WrappedTargetException wrappedTargetException) {
                Exception exception = (Exception)wrappedTargetException.TargetException;
                String string2 = wrappedTargetException.getMessage();
                if (exception != null) {
                    string2 = exception.getMessage();
                }
                ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(string2, null, parsedScriptUri.function, this.language, 0);
                scriptFrameworkErrorException.initCause((Throwable)wrappedTargetException);
                throw scriptFrameworkErrorException;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ScriptFrameworkErrorException scriptFrameworkErrorException = new ScriptFrameworkErrorException(illegalArgumentException.getMessage(), null, string, this.language, 0);
            scriptFrameworkErrorException.initCause((Throwable)illegalArgumentException);
            throw scriptFrameworkErrorException;
        }
    }

    public String getName() {
        return this.language;
    }

    public XBrowseNode[] getChildNodes() {
        if (this.m_xBrowseNodeProxy == null) {
            LogUtils.DEBUG("No Nodes available ");
            return new XBrowseNode[0];
        }
        return this.m_xBrowseNodeProxy.getChildNodes();
    }

    public boolean hasChildNodes() {
        if (this.m_xBrowseNodeProxy == null) {
            LogUtils.DEBUG("No Nodes available ");
            return false;
        }
        return this.m_xBrowseNodeProxy.hasChildNodes();
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return this.getName();
    }

    public XIntrospectionAccess getIntrospection() {
        return this.m_xInvocationProxy.getIntrospection();
    }

    public Object invoke(String string, Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        return this.m_xInvocationProxy.invoke(string, objectArray, sArray, objectArray2);
    }

    public void setValue(String string, Object object) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
        this.m_xInvocationProxy.setValue(string, object);
    }

    public Object getValue(String string) throws UnknownPropertyException {
        return this.m_xInvocationProxy.getValue(string);
    }

    public boolean hasMethod(String string) {
        return this.m_xInvocationProxy.hasMethod(string);
    }

    public boolean hasProperty(String string) {
        return this.m_xInvocationProxy.hasProperty(string);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_xPropertySetProxy.getPropertySetInfo();
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_xPropertySetProxy.setPropertyValue(string, object);
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.m_xPropertySetProxy.getPropertyValue(string);
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.addPropertyChangeListener(string, xPropertyChangeListener);
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.removePropertyChangeListener(string, xPropertyChangeListener);
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.addVetoableChangeListener(string, xVetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_xPropertySetProxy.removeVetoableChangeListener(string, xVetoableChangeListener);
    }

    public Object getByName(String string) throws NoSuchElementException, WrappedTargetException {
        throw new RuntimeException("getByName not implemented");
    }

    public String[] getElementNames() {
        throw new RuntimeException("getElementNames not implemented");
    }

    public boolean hasByName(String string) {
        return ((UnoPkgContainer)this.m_container).hasRegisteredUnoPkgContainer(string);
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        throw new RuntimeException("hasElements not implemented");
    }

    public void replaceByName(String string, Object object) throws IllegalArgumentException, NoSuchElementException, WrappedTargetException {
        throw new RuntimeException("replaceByName not implemented");
    }

    public void insertByName(String string, Object object) throws IllegalArgumentException, ElementExistException, WrappedTargetException {
        LogUtils.DEBUG("Provider for " + this.language + " received register for package " + string);
        XPackage xPackage = (XPackage)UnoRuntime.queryInterface(XPackage.class, (Object)object);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Empty name");
        }
        if (xPackage == null) {
            throw new IllegalArgumentException("No package supplied");
        }
        ((UnoPkgContainer)this.m_container).processUnoPackage(xPackage, this.language);
    }

    public void removeByName(String string) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG("In ScriptProvider.removeByName() for " + string + " this provider = " + this.language);
        ParcelContainer parcelContainer = ((UnoPkgContainer)this.m_container).getRegisteredUnoPkgContainer(string);
        if (parcelContainer != null) {
            String string2;
            if (string.endsWith("/")) {
                String string3 = string.substring(0, string.lastIndexOf(47));
                string2 = string3.substring(string3.lastIndexOf(47) + 1);
            } else {
                string2 = string.substring(string.lastIndexOf(47) + 1);
            }
            LogUtils.DEBUG("Deregistering library " + string2);
            if (!parcelContainer.removeParcel(string2)) {
                throw new NoSuchElementException(string2 + " cannot be removed from container.");
            }
        } else {
            throw new NoSuchElementException(string + " doesn't exist for " + this.language);
        }
        ((UnoPkgContainer)this.m_container).deRegisterPackageContainer(string);
    }

    private String getDocUrlFromModel(XModel xModel) {
        XTransientDocumentsDocumentContentFactory xTransientDocumentsDocumentContentFactory = null;
        try {
            xTransientDocumentsDocumentContentFactory = (XTransientDocumentsDocumentContentFactory)UnoRuntime.queryInterface(XTransientDocumentsDocumentContentFactory.class, (Object)this.m_xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.TransientDocumentsDocumentContentFactory", this.m_xContext));
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        if (xTransientDocumentsDocumentContentFactory == null) {
            throw new RuntimeException("ScriptProvider: unable to create a TDOC context factory.", (Object)this);
        }
        try {
            XContent xContent = xTransientDocumentsDocumentContentFactory.createDocumentContent(xModel);
            return xContent.getIdentifier().getContentIdentifier();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtils.DEBUG("unable to determine the model's TDOC URL");
            return "";
        }
    }

    private XModel getModelFromDocUrl(String string) {
        LogUtils.DEBUG("getModelFromDocUrl - searching for match for ->" + string + "<-");
        XModel xModel = null;
        try {
            XUniversalContentBroker xUniversalContentBroker = UniversalContentBroker.create((XComponentContext)this.m_xContext);
            XContentIdentifier xContentIdentifier = xUniversalContentBroker.createContentIdentifier(string);
            XContent xContent = xUniversalContentBroker.queryContent(xContentIdentifier);
            XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)xContent);
            Property[] propertyArray = new Property[]{new Property()};
            propertyArray[0].Name = "DocumentModel";
            propertyArray[0].Handle = -1;
            Command command = new Command();
            command.Handle = -1;
            command.Name = "getPropertyValues";
            command.Argument = propertyArray;
            XCommandEnvironment xCommandEnvironment = null;
            Object object = xCommandProcessor.execute(command, 0, xCommandEnvironment);
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)object);
            xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xRow.getObject(1, null));
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG("Failed to get model exception " + (Object)((Object)exception));
        }
        return xModel;
    }
}

