/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.content.Content;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.IdeVcsLogManager;
import com.intellij.vcs.log.impl.IdeVcsProjectLog;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import java.awt.Component;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "ContentMainUiHolder", "VcsLogVisibilityPredicate", "DisplayNameSupplier", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogContentProvider.kt\ncom/intellij/vcs/log/impl/VcsLogContentProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n24#2:62\n*S KotlinDebug\n*F\n+ 1 VcsLogContentProvider.kt\ncom/intellij/vcs/log/impl/VcsLogContentProvider\n*L\n27#1:62\n*E\n"})
public final class VcsLogContentProvider
implements ChangesViewContentProvider {
    @NotNull
    private final Project project;

    public VcsLogContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VcsProjectLog vcsProjectLog = VcsProjectLog.Companion.getInstance(this.project);
        IdeVcsProjectLog ideVcsProjectLog = vcsProjectLog instanceof IdeVcsProjectLog ? (IdeVcsProjectLog)vcsProjectLog : null;
        if (ideVcsProjectLog == null) {
            return;
        }
        IdeVcsProjectLog projectLog = ideVcsProjectLog;
        if (projectLog.isDisposing()) {
            return;
        }
        VcsLogContentProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(VcsLogContentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Adding main Log ui container to the content for " + this.project.getName());
        content.setComponent((JComponent)AsyncProcessIcon.createBig((String)"VCS Log initializing"));
        content.setTabName("Log");
        projectLog.initAsync(true);
        projectLog.setMainUiHolder(new ContentMainUiHolder(content));
        content.setDisposer(() -> VcsLogContentProvider.initTabContent$lambda$0(projectLog));
    }

    private static final void initTabContent$lambda$0(IdeVcsProjectLog $projectLog) {
        $projectLog.setMainUiHolder(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$ContentMainUiHolder;", "Lcom/intellij/vcs/log/impl/IdeVcsProjectLog$MainUiHolder;", "content", "Lcom/intellij/ui/content/Content;", "<init>", "(Lcom/intellij/ui/content/Content;)V", "installMainUi", "", "manager", "Lcom/intellij/vcs/log/impl/IdeVcsLogManager;", "ui", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "intellij.platform.vcs.log.impl"})
    private static final class ContentMainUiHolder
    implements IdeVcsProjectLog.MainUiHolder {
        @NotNull
        private final Content content;

        public ContentMainUiHolder(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
        }

        @Override
        public void installMainUi(@NotNull IdeVcsLogManager manager, @NotNull MainVcsLogUi ui) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
            this.content.setDisplayName(VcsLogTabsUtil.generateDisplayName(ui));
            VcsLogTabsManager.Companion.onDisplayNameChange(ui, (Function0<Unit>)((Function0)() -> ContentMainUiHolder.installMainUi$lambda$0(this, ui)));
            VcsLogPanel panel = new VcsLogPanel(manager, ui);
            this.content.setComponent((JComponent)((Object)panel));
            IJSwingUtilities.updateComponentTreeUI((Component)((Component)((Object)panel)));
        }

        private static final Unit installMainUi$lambda$0(ContentMainUiHolder this$0, MainVcsLogUi $ui) {
            this$0.content.setDisplayName(VcsLogTabsUtil.generateDisplayName($ui));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "<init>", "()V", "get", "intellij.platform.vcs.log.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string = VcsLogBundle.message("vcs.log.tab.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "test", "", "project", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogVisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return VcsProjectLog.Companion.isAvailable(project);
        }
    }
}

