/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.cookie;

import org.jetbrains.kotlin.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.jetbrains.kotlin.org.apache.http.cookie.Cookie;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.org.apache.http.cookie.SetCookie;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

