/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;

public final class FSOperations {
    private static final Logger LOG = Logger.getInstance(FSOperations.class);
    public static final GlobalContextKey<Set<Path>> ALL_OUTPUTS_KEY = GlobalContextKey.create("_all_project_output_dirs_");
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGETS_COMPLETELY_MARKED_DIRTY = GlobalContextKey.create("_targets_completely_marked_dirty_");

    public static boolean isMarkedDirty(CompileContext context, CompilationRound round, Path file) {
        JavaSourceRootDescriptor rootDescriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file.toFile());
        if (rootDescriptor == null) {
            return false;
        }
        return context.getProjectDescriptor().fsState.isMarkedForRecompilation(context, round, rootDescriptor, file);
    }

    @Deprecated(forRemoval=true)
    public static void markDirty(CompileContext context, File file) throws IOException {
        FSOperations.markDirty(context, CompilationRound.NEXT, file);
    }

    public static void markDirty(@NotNull CompileContext context, @NotNull CompilationRound round, @NotNull File file) throws IOException {
        JavaSourceRootDescriptor rootDescriptor;
        if (context == null) {
            FSOperations.$$$reportNull$$$0(0);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FSOperations.$$$reportNull$$$0(2);
        }
        if ((rootDescriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file)) != null) {
            ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
            projectDescriptor.fsState.markDirty(context, round, file.toPath(), (BuildRootDescriptor)rootDescriptor, projectDescriptor.dataManager.getFileStampStorage(rootDescriptor.target), false);
        }
    }

    public static void markDirtyIfNotDeleted(@NotNull CompileContext context, @NotNull CompilationRound round, @NotNull Path file) throws IOException {
        JavaSourceRootDescriptor rootDescriptor;
        if (context == null) {
            FSOperations.$$$reportNull$$$0(3);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FSOperations.$$$reportNull$$$0(5);
        }
        if ((rootDescriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file.toFile())) != null) {
            ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
            projectDescriptor.fsState.markDirtyIfNotDeleted(context, round, file, rootDescriptor, projectDescriptor.dataManager.getFileStampStorage(rootDescriptor.target));
        }
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> DirtyFilesHolderBuilder<R, T> createDirtyFilesHolderBuilder(final CompileContext context, final CompilationRound round) {
        return new DirtyFilesHolderBuilder<R, T>(){
            private final Map<T, Map<R, Set<File>>> dirtyFiles = new HashMap();

            @Override
            public DirtyFilesHolderBuilder<R, T> markDirtyFile(T target, @NotNull File file) throws IOException {
                ProjectDescriptor projectDescriptor;
                Object rootDescriptor;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((rootDescriptor = (projectDescriptor = context.getProjectDescriptor()).getBuildRootIndex().findParentDescriptor(file, List.of(((BuildTarget)target).getTargetType()), context)) == null) {
                    return this;
                }
                Path nioPath = file.toPath();
                if (projectDescriptor.fsState.markDirtyIfNotDeleted(context, round, nioPath, (BuildRootDescriptor)rootDescriptor, projectDescriptor.dataManager.getFileStampStorage((BuildTarget<?>)target)) || projectDescriptor.fsState.isMarkedForRecompilation(context, round, (BuildRootDescriptor)rootDescriptor, nioPath)) {
                    Set rootFiles;
                    Map targetFiles = this.dirtyFiles.get(target);
                    if (targetFiles == null) {
                        targetFiles = new HashMap();
                        this.dirtyFiles.put(target, targetFiles);
                    }
                    if ((rootFiles = targetFiles.get(rootDescriptor)) == null) {
                        rootFiles = FileCollectionFactory.createCanonicalFileSet();
                        targetFiles.put(rootDescriptor, rootFiles);
                    }
                    rootFiles.add(file);
                }
                return this;
            }

            @Override
            public DirtyFilesHolder<R, T> create() {
                return new DirtyFilesHolder<R, T>(){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                        if (processor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (Map.Entry entry : dirtyFiles.entrySet()) {
                            BuildTarget target = (BuildTarget)entry.getKey();
                            for (Map.Entry targetEntry : entry.getValue().entrySet()) {
                                BuildRootDescriptor rd = (BuildRootDescriptor)targetEntry.getKey();
                                for (File file : targetEntry.getValue()) {
                                    processor.apply(target, file, rd);
                                }
                            }
                        }
                    }

                    @Override
                    public boolean hasDirtyFiles() {
                        return !dirtyFiles.isEmpty();
                    }

                    @Override
                    public boolean hasRemovedFiles() {
                        return false;
                    }

                    @Override
                    @NotNull
                    public Collection<String> getRemovedFiles(@NotNull T target) {
                        if (target == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        List<String> list = List.of();
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    @Override
                    @NotNull
                    public @NotNull @Unmodifiable Collection<@NotNull Path> getRemoved(@NotNull T target) {
                        if (target == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        List<Path> list = List.of();
                        if (list == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: 
                            case 4: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: 
                            case 4: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processor";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "target";
                                break;
                            }
                            case 2: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/jps/incremental/FSOperations$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/jps/incremental/FSOperations$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRemovedFiles";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRemoved";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "processDirtyFiles";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getRemovedFiles";
                                break;
                            }
                            case 2: 
                            case 4: {
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "getRemoved";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: 
                            case 4: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/FSOperations$1", "markDirtyFile"));
            }
        };
    }

    public static void markDeleted(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rootDescriptor = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rootDescriptor != null) {
            ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
            projectDescriptor.fsState.registerDeleted(context, rootDescriptor.target, file.toPath(), projectDescriptor.dataManager.getFileStampStorage(rootDescriptor.target));
        }
    }

    public static void markDirty(@NotNull CompileContext context, @NotNull CompilationRound round, @NotNull ModuleChunk chunk, @Nullable FileFilter filter) throws IOException {
        if (context == null) {
            FSOperations.$$$reportNull$$$0(6);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(7);
        }
        if (chunk == null) {
            FSOperations.$$$reportNull$$$0(8);
        }
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.markDirty(context, round, target, filter);
        }
    }

    public static void markDirty(@NotNull CompileContext context, @NotNull CompilationRound round, @NotNull ModuleBuildTarget target, @Nullable FileFilter filter) throws IOException {
        if (context == null) {
            FSOperations.$$$reportNull$$$0(9);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(10);
        }
        if (target == null) {
            FSOperations.$$$reportNull$$$0(11);
        }
        FSOperations.markDirtyFiles(context, target, round, context.getProjectDescriptor().dataManager.getFileStampStorage(target), true, null, filter);
    }

    public static void markDirtyRecursively(CompileContext context, CompilationRound round, ModuleChunk chunk) throws IOException {
        FSOperations.markDirtyRecursively(context, round, chunk, null);
    }

    public static void markDirtyRecursively(CompileContext context, CompilationRound round, ModuleChunk chunk, @Nullable FileFilter filter) throws IOException {
        Set<JpsModule> modules = chunk.getModules();
        Set<ModuleBuildTarget> targets = chunk.getTargets();
        HashSet<ModuleBuildTarget> dirtyTargets = new HashSet<ModuleBuildTarget>(targets);
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)chunk.containsTests());
        boolean found = false;
        block0: for (BuildTargetChunk targetChunk : context.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(context)) {
            if (!found) {
                if (!targetChunk.getTargets().equals(chunk.getTargets())) continue;
                found = true;
                continue;
            }
            for (BuildTarget<?> target : targetChunk.getTargets()) {
                Set<JpsModule> deps;
                if (!(target instanceof ModuleBuildTarget) || !ContainerUtil.intersects(deps = FSOperations.getDependentModulesRecursively(((ModuleBuildTarget)target).getModule(), classpathKind), modules)) continue;
                for (BuildTarget<?> buildTarget : targetChunk.getTargets()) {
                    if (!(buildTarget instanceof ModuleBuildTarget)) continue;
                    dirtyTargets.add((ModuleBuildTarget)buildTarget);
                }
                continue block0;
            }
        }
        if (JavaBuilderUtil.isCompileJavaIncrementally(context)) {
            for (ModuleBuildTarget target : targets) {
                if (FSOperations.isMarkedDirty(context, target)) continue;
                context.markNonIncremental(target);
            }
        }
        FSOperations.removeTargetsAlreadyMarkedDirty(context, dirtyTargets);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        for (ModuleBuildTarget target : dirtyTargets) {
            StampsStorage<?> stampStorage = dataManager.getFileStampStorage(target);
            FSOperations.markDirtyFiles(context, target, round, stampStorage, true, null, filter);
        }
    }

    private static Set<JpsModule> getDependentModulesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        return JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly().getModules();
    }

    public static void processFilesToRecompile(CompileContext context, ModuleChunk chunk, FileProcessor<JavaSourceRootDescriptor, ? super ModuleBuildTarget> processor) throws IOException {
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.processFilesToRecompile(context, target, processor);
        }
    }

    public static void processFilesToRecompile(CompileContext context, @NotNull ModuleBuildTarget target, FileProcessor<JavaSourceRootDescriptor, ? super ModuleBuildTarget> processor) throws IOException {
        if (target == null) {
            FSOperations.$$$reportNull$$$0(12);
        }
        context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
    }

    static void markDirtyFiles(@NotNull CompileContext context, @NotNull BuildTarget<?> target, @NotNull CompilationRound round, @Nullable StampsStorage<?> stampStorage, boolean forceMarkDirty, @Nullable Set<? super Path> currentFiles, @Nullable FileFilter filter) throws IOException {
        if (context == null) {
            FSOperations.$$$reportNull$$$0(13);
        }
        if (target == null) {
            FSOperations.$$$reportNull$$$0(14);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(15);
        }
        boolean completelyMarkedDirty = true;
        for (BuildRootDescriptor rootDescriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
            if (!rootDescriptor.getRootFile().exists() || rootDescriptor instanceof JavaSourceRootDescriptor && ((JavaSourceRootDescriptor)rootDescriptor).isTemp) continue;
            if (filter == null) {
                context.getProjectDescriptor().fsState.clearRecompile(rootDescriptor);
            }
            completelyMarkedDirty &= FSOperations.traverseRecursively(context, rootDescriptor, round, rootDescriptor.getRootFile(), stampStorage, forceMarkDirty, currentFiles, filter);
        }
        if (completelyMarkedDirty) {
            FSOperations.addCompletelyMarkedDirtyTarget(context, target);
        }
    }

    private static boolean traverseRecursively(final @NotNull CompileContext context, final @NotNull BuildRootDescriptor rootDescriptor, final @NotNull CompilationRound round, @NotNull File file, final @Nullable StampsStorage<?> stampStorage, final boolean forceDirty, final @Nullable Set<? super Path> currentFiles, final @Nullable FileFilter filter) throws IOException {
        if (context == null) {
            FSOperations.$$$reportNull$$$0(16);
        }
        if (rootDescriptor == null) {
            FSOperations.$$$reportNull$$$0(17);
        }
        if (round == null) {
            FSOperations.$$$reportNull$$$0(18);
        }
        if (file == null) {
            FSOperations.$$$reportNull$$$0(19);
        }
        var fileConsumer = new BiConsumer<Path, BasicFileAttributes>(){
            boolean allFilesMarked = true;

            @Override
            public void accept(@NotNull Path file, @Nullable BasicFileAttributes attrs) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (filter != null && filter != FileFilters.EVERYTHING && !filter.accept(file.toFile())) {
                    this.allFilesMarked = false;
                    return;
                }
                boolean markDirty = forceDirty;
                if (!markDirty) {
                    try {
                        markDirty = stampStorage == null || stampStorage.getCurrentStampIfUpToDate(file, rootDescriptor.getTarget(), attrs) == null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (markDirty) {
                    StampsStorage marker = JavaBuilderUtil.isForcedRecompilationAllJavaModules(context) ? null : stampStorage;
                    try {
                        context.getProjectDescriptor().fsState.markDirty(context, round, file, rootDescriptor, marker, false);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (currentFiles != null) {
                    currentFiles.add(file);
                }
                if (!markDirty) {
                    this.allFilesMarked = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/FSOperations$2", "accept"));
            }
        };
        BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        FSOperations.traverseRecursively(file.toPath(), f -> rootIndex.isDirectoryAccepted((Path)f, rootDescriptor), f -> rootIndex.isFileAccepted((Path)f, rootDescriptor), fileConsumer);
        return fileConsumer.allFilesMarked;
    }

    private static void traverseRecursively(@NotNull Path fromFile, final @NotNull Predicate<Path> dirFilter, final @NotNull Predicate<Path> fileFilter, final @NotNull BiConsumer<Path, BasicFileAttributes> processor) throws IOException {
        if (fromFile == null) {
            FSOperations.$$$reportNull$$$0(20);
        }
        if (dirFilter == null) {
            FSOperations.$$$reportNull$$$0(21);
        }
        if (fileFilter == null) {
            FSOperations.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            FSOperations.$$$reportNull$$$0(23);
        }
        Files.walkFileTree(fromFile, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                if (e instanceof NoSuchFileException) {
                    return FileVisitResult.TERMINATE;
                }
                if (e instanceof FileSystemLoopException) {
                    LOG.info((Throwable)e);
                    FSOperations.traverseRecursivelyIO(file.toFile(), dirFilter, fileFilter, processor);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.visitFileFailed(file, e);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return dirFilter.test(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                if (fileFilter.test(f)) {
                    processor.accept(f, attrs);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void traverseRecursivelyIO(@NotNull File fromFile, @NotNull Predicate<Path> dirFilter, @NotNull Predicate<Path> fileFilter, @NotNull BiConsumer<Path, BasicFileAttributes> processor) throws IOException {
        File[] children;
        if (fromFile == null) {
            FSOperations.$$$reportNull$$$0(24);
        }
        if (dirFilter == null) {
            FSOperations.$$$reportNull$$$0(25);
        }
        if (fileFilter == null) {
            FSOperations.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            FSOperations.$$$reportNull$$$0(27);
        }
        if ((children = fromFile.listFiles()) == null) {
            if (fileFilter.test(fromFile.toPath())) {
                processor.accept(fromFile.toPath(), null);
            }
        } else if (children.length > 0 && dirFilter.test(fromFile.toPath())) {
            for (File child : children) {
                FSOperations.traverseRecursivelyIO(child, dirFilter, fileFilter, processor);
            }
        }
    }

    public static void pruneEmptyDirs(@NotNull CompileContext context, @Unmodifiable @Nullable Set<Path> dirsToDelete) {
        if (context == null) {
            FSOperations.$$$reportNull$$$0(28);
        }
        if (dirsToDelete == null || dirsToDelete.isEmpty()) {
            return;
        }
        Set doNotDelete = (Set)ALL_OUTPUTS_KEY.get(context);
        if (doNotDelete == null) {
            doNotDelete = FileCollectionFactory.createCanonicalPathSet();
            for (BuildTarget<?> target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets()) {
                for (File root : target.getOutputRoots(context)) {
                    doNotDelete.add(root.toPath());
                }
            }
            ALL_OUTPUTS_KEY.set(context, doNotDelete);
        }
        Set additionalDirs = null;
        Set<Path> toDelete = dirsToDelete;
        while (toDelete != null) {
            for (Path file : toDelete) {
                Path parentFile;
                boolean deleted;
                try {
                    deleted = !doNotDelete.contains(file) && Files.deleteIfExists(file);
                }
                catch (IOException e) {
                    deleted = false;
                }
                if (!deleted || (parentFile = file.getParent()) == null) continue;
                if (additionalDirs == null) {
                    additionalDirs = FileCollectionFactory.createCanonicalPathSet();
                }
                additionalDirs.add(parentFile);
            }
            toDelete = additionalDirs;
            additionalDirs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMarkedDirty(CompileContext context, ModuleChunk chunk) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            return marked != null && marked.containsAll(chunk.getTargets());
        }
    }

    public static long lastModified(@NotNull File file) {
        if (file == null) {
            FSOperations.$$$reportNull$$$0(29);
        }
        return FSOperations.lastModified(file.toPath());
    }

    @ApiStatus.Internal
    public static long lastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return 0L;
    }

    @ApiStatus.Internal
    public static long lastModified(Path path, BasicFileAttributes attribs) {
        return attribs != null && attribs.isRegularFile() ? attribs.lastModifiedTime().toMillis() : FSOperations.lastModified(path);
    }

    @ApiStatus.Internal
    public static BasicFileAttributes getAttributes(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    public static void copy(File fromFile, File toFile) throws IOException {
        block7: {
            Path from = fromFile.toPath();
            Path to = toFile.toPath();
            try {
                try {
                    Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (AccessDeniedException e) {
                    if (!Files.isWritable(to) && toFile.setWritable(true)) {
                        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        break block7;
                    }
                    throw e;
                }
                catch (NoSuchFileException e) {
                    File parent = toFile.getParentFile();
                    if (parent != null && parent.mkdirs()) {
                        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        break block7;
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                LOG.info("Error copying " + fromFile.getPath() + " to " + toFile.getPath() + " with NIO API", (Throwable)e);
                FileUtil.copyContent((File)fromFile, (File)toFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMarkedDirty(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            return marked != null && marked.contains(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void addCompletelyMarkedDirtyTarget(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            HashSet marked = (HashSet)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            if (marked == null) {
                marked = new HashSet();
                TARGETS_COMPLETELY_MARKED_DIRTY.set(context, marked);
            }
            marked.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTargetsAlreadyMarkedDirty(CompileContext context, Set<ModuleBuildTarget> targetsSetToFilter) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            if (marked != null) {
                targetsSetToFilter.removeAll(marked);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "round";
                break;
            }
            case 2: 
            case 5: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFilter";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/FSOperations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markDirty";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "markDirtyIfNotDeleted";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processFilesToRecompile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "markDirtyFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseRecursively";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseRecursivelyIO";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "pruneEmptyDirs";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "lastModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface FileConsumer {
        public void consume(@NotNull File var1, @Nullable BasicFileAttributes var2) throws IOException;
    }

    public static interface DirtyFilesHolderBuilder<R extends BuildRootDescriptor, T extends BuildTarget<R>> {
        public DirtyFilesHolderBuilder<R, T> markDirtyFile(T var1, @NotNull File var2) throws IOException;

        default public DirtyFilesHolderBuilder<R, T> markDirtyFile(T target, @NotNull Path file) throws IOException {
            if (file == null) {
                DirtyFilesHolderBuilder.$$$reportNull$$$0(0);
            }
            return this.markDirtyFile(target, file.toFile());
        }

        public DirtyFilesHolder<R, T> create();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/FSOperations$DirtyFilesHolderBuilder", "markDirtyFile"));
        }
    }
}

