/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.BytePredicate;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.W;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ae;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.c;

public class ByteArrayList
extends c
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353130L;
    protected transient byte[] a;
    protected int size;

    private static final byte[] a(byte[] byArray, int n2) {
        if (n2 == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(byArray, n2);
    }

    /*
     * WARNING - void declaration
     */
    protected ByteArrayList(byte[] a2, boolean wrapped) {
        void var1_1;
        this.a = var1_1;
    }

    public ByteArrayList() {
        this.a = ByteArrays.DEFAULT_EMPTY_ARRAY;
    }

    private void f(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != ByteArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        this.a = ByteArrays.forceCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, byte k2) {
        void var2_2;
        this.a(index);
        ByteArrayList byteArrayList = this;
        byteArrayList.f(byteArrayList.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[var1_1] = var2_2;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(byte k2) {
        void var1_1;
        ByteArrayList byteArrayList = this;
        byteArrayList.f(byteArrayList.size + 1);
        this.a[this.size++] = var1_1;
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(int index) {
        void var1_1;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[var1_1];
    }

    @Override
    public int indexOf(byte k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte k2) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (k2 != this.a[n2]) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte removeByte(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte by = this.a[index];
        --this.size;
        if (index != this.size) {
            void var1_1;
            System.arraycopy(this.a, index + 1, this.a, index, this.size - var1_1);
        }
        assert (this.size <= this.a.length);
        return by;
    }

    @Override
    public boolean rem(byte k2) {
        int n2;
        if ((n2 = ((c)this).indexOf((byte)n2)) == -1) {
            return false;
        }
        ((c)this).removeByte(n2);
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte set(int index, byte k2) {
        void var2_2;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte by = this.a[index];
        this.a[var1_1] = var2_2;
        return by;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteList subList(int from2, int to) {
        void var2_2;
        void var1_1;
        if (from2 == 0 && to == this.size()) {
            return this;
        }
        this.a(from2);
        this.a(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new b((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getElements(int from2, byte[] a2, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, (int)var1_1, var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeElements(int from2, int to) {
        void var1_1;
        void var2_2;
        Arrays.ensureFromTo(this.size, from2, to);
        System.arraycopy(this.a, to, this.a, from2, this.size - to);
        this.size -= var2_2 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setElements(int index, byte[] a2, int offset, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(index);
        ByteArrays.ensureOffsetLength(a2, offset, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(var2_2, (int)var3_3, this.a, (int)var1_1, length);
    }

    @Override
    public void forEach(ByteConsumer action) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            action.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int index, ByteCollection c2) {
        ByteIterator byteIterator;
        if (c2 instanceof ByteList) {
            return this.addAll(index, (ByteList)c2);
        }
        this.a(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        ByteArrayList byteArrayList = this;
        byteArrayList.f(byteArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        byteIterator = byteIterator.iterator();
        this.size += n2;
        while (n2-- != 0) {
            this.a[index++] = byteIterator.c_();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAll(int index, ByteList l2) {
        void var1_1;
        void var2_2;
        this.a(index);
        int n2 = l2.size();
        if (n2 == 0) {
            return false;
        }
        ByteArrayList byteArrayList = this;
        byteArrayList.f(byteArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        var2_2.getElements(0, this.a, (int)var1_1, n2);
        this.size += n2;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(ByteCollection c2) {
        int n2;
        byte[] byArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (c2.contains(byArray[n2])) continue;
            byArray[n3++] = byArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public boolean removeIf(BytePredicate filter) {
        int n2;
        byte[] byArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (filter.test(byArray[n2])) continue;
            byArray[n3++] = byArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteListIterator listIterator(int index) {
        void var1_1;
        this.a(index);
        return new ByteListIterator(){
            private int a;
            private int b;
            private /* synthetic */ int c;
            private /* synthetic */ ByteArrayList d;
            {
                this.d = byteArrayList;
                this.c = n2;
                this.a = this.c;
                this.b = -1;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.d.size;
            }

            @Override
            public final boolean hasPrevious() {
                return this.a > 0;
            }

            @Override
            public final byte c_() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.b = this.a++;
                return this.d.a[this.b];
            }

            @Override
            public final byte b() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.b = --this.a;
                return this.d.a[this.a];
            }

            @Override
            public final int nextIndex() {
                return this.a;
            }

            @Override
            public final int previousIndex() {
                return this.a - 1;
            }

            @Override
            public final void a(byte by) {
                ((c)this.d).add(this.a++, by);
                this.b = -1;
            }

            @Override
            public final void b(byte by) {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((c)this.d).set(this.b, by);
            }

            @Override
            public final void remove() {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((c)this.d).removeByte(this.b);
                if (this.b < this.a) {
                    --this.a;
                }
                this.b = -1;
            }

            @Override
            public final void a(ByteConsumer byteConsumer) {
                while (this.a < this.d.size) {
                    ++this.a;
                    this.b = this.b;
                    byteConsumer.accept(this.d.a[this.b]);
                }
            }

            @Override
            public final /* synthetic */ void forEachRemaining(Object object) {
                this.a((ByteConsumer)object);
            }
        };
    }

    @Override
    public ByteSpliterator spliterator() {
        return new a(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sort(ByteComparator comp) {
        void var1_1;
        if (comp == null) {
            ByteArrays.stableSort(this.a, 0, this.size);
            return;
        }
        ByteArrays.stableSort(this.a, 0, this.size, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unstableSort(ByteComparator comp) {
        void var1_1;
        if (comp == null) {
            ByteArrays.unstableSort(this.a, 0, this.size);
            return;
        }
        ByteArrays.unstableSort(this.a, 0, this.size, (ByteComparator)var1_1);
    }

    public ByteArrayList clone() {
        ByteArrayList byteArrayList;
        if (this.getClass() == ByteArrayList.class) {
            byteArrayList = new ByteArrayList(ByteArrayList.a(this.a, this.size), false);
            new ByteArrayList(ByteArrayList.a(this.a, this.size), false).size = this.size;
        } else {
            try {
                byteArrayList = (ByteArrayList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
            byteArrayList.a = ByteArrayList.a(this.a, this.size);
        }
        return byteArrayList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(ByteArrayList l2) {
        void var1_1;
        if (l2 == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != l2.size()) {
            return false;
        }
        byte[] byArray = this.a;
        byte[] byArray2 = l2.a;
        if (byArray == byArray2 && n2 == var1_1.size()) {
            return true;
        }
        while (n2-- != 0) {
            if (byArray[n2] == byArray2[n2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o2) {
        void var1_1;
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        if (o2 instanceof ByteArrayList) {
            return this.equals((ByteArrayList)o2);
        }
        if (o2 instanceof b) {
            return ((c)((b)o2)).equals(this);
        }
        return super.equals(var1_1);
    }

    @Override
    public int compareTo(ByteArrayList l2) {
        int n2;
        byte[] byArray;
        int n3 = this.size();
        int n4 = l2.size();
        byte[] byArray2 = this.a;
        byArray = byArray.a;
        if (byArray2 == byArray && n3 == n4) {
            return 0;
        }
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = byArray2[n2];
            byte by = byArray[n2];
            if ((n5 = Byte.compare((byte)n5, by)) == 0) continue;
            return n5;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 < n3) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(List<? extends Byte> l2) {
        void var1_1;
        if (l2 instanceof ByteArrayList) {
            return this.compareTo((ByteArrayList)l2);
        }
        if (l2 instanceof b) {
            return -((c)((b)l2)).compareTo(this);
        }
        return super.compareTo((List<? extends Byte>)var1_1);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeByte(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new byte[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readByte();
        }
    }

    private final class org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b
    extends c.a {
        private static final long serialVersionUID = -3185226345314976296L;

        protected org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b(int n2, int n3) {
            super(ByteArrayList.this, n2, n3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(int i2) {
            void var1_1;
            this.b(i2);
            return ByteArrayList.this.a[var1_1 + this.b];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteListIterator listIterator(int index) {
            void var1_1;
            return new a(this, (int)var1_1);
        }

        @Override
        public final ByteSpliterator spliterator() {
            return new b(this);
        }

        private boolean a(byte[] byArray, int n2, int n3) {
            if (ByteArrayList.this.a == byArray && this.b == n2 && this.c == n3) {
                return true;
            }
            if (n3 - n2 != this.size()) {
                return false;
            }
            n3 = this.b;
            while (n3 < this.c) {
                if (ByteArrayList.this.a[n3++] == byArray[n2++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean equals(Object o2) {
            c c2;
            if (o2 == this) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof List)) {
                return false;
            }
            if (o2 instanceof ByteArrayList) {
                c2 = (ByteArrayList)c2;
                return this.a(((ByteArrayList)c2).a, 0, ((ByteArrayList)c2).size());
            }
            if (c2 instanceof org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b) {
                c2 = (org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b)c2;
                return this.a(((org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b)c2).ByteArrayList.this.a, ((c.b)c2).b, ((c.b)c2).c);
            }
            return super.equals(c2);
        }

        private int b(byte[] byArray, int n2, int n3) {
            if (ByteArrayList.this.a == byArray && this.b == n2 && this.c == n3) {
                return 0;
            }
            int n4 = this.b;
            int n5 = n2;
            while (n4 < this.c && n4 < n3) {
                n2 = ByteArrayList.this.a[n4];
                byte by = byArray[n5];
                if ((n2 = Byte.compare((byte)n2, by)) != 0) {
                    return n2;
                }
                ++n4;
                ++n5;
            }
            if (n4 < n3) {
                return -1;
            }
            if (n4 < this.c) {
                return 1;
            }
            return 0;
        }

        @Override
        public final int compareTo(List<? extends Byte> l2) {
            c c2;
            if (l2 instanceof ByteArrayList) {
                c2 = (ByteArrayList)c2;
                return this.b(((ByteArrayList)c2).a, 0, ((ByteArrayList)c2).size());
            }
            if (c2 instanceof org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b) {
                c2 = (org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b)c2;
                return this.b(((org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b)c2).ByteArrayList.this.a, ((c.b)c2).b, ((c.b)c2).c);
            }
            return super.compareTo(c2);
        }

        private final class a
        extends W.b {
            private /* synthetic */ org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b d;

            a(org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b b2, int n2) {
                this.d = b2;
                super(n2);
            }

            @Override
            protected final byte a(int n2) {
                return this.d.ByteArrayList.this.a[this.d.b + n2];
            }

            @Override
            protected final void a(int n2, byte by) {
                ((c)this.d).add(n2, by);
            }

            @Override
            protected final void b(int n2, byte by) {
                ((c)this.d).set(n2, by);
            }

            @Override
            protected final void b(int n2) {
                ((c)this.d).removeByte(n2);
            }

            @Override
            protected final int a() {
                return this.d.c - this.d.b;
            }

            @Override
            public final byte c_() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.c = this.b++;
                return this.d.ByteArrayList.this.a[this.d.b + this.c];
            }

            @Override
            public final byte b() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.c = --this.b;
                return this.d.ByteArrayList.this.a[this.d.b + this.b];
            }

            @Override
            public final void a(ByteConsumer byteConsumer) {
                int n2 = this.d.c - this.d.b;
                while (this.b < n2) {
                    ++this.b;
                    this.c = this.c;
                    byteConsumer.accept(this.d.ByteArrayList.this.a[this.d.b + this.c]);
                }
            }

            @Override
            public final /* synthetic */ void forEachRemaining(Object object) {
                ((W.a)this).a((ByteConsumer)object);
            }
        }

        private final class b
        extends ae.e {
            private /* synthetic */ org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b b;

            b(org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b b2) {
                this.b = b2;
                super(b2.b);
            }

            private b(org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrayList$b b2, int n2, int n3) {
                this.b = b2;
                super(n2, n3);
            }

            @Override
            protected final int a() {
                return this.b.c;
            }

            @Override
            protected final byte a(int n2) {
                return this.b.ByteArrayList.this.a[n2];
            }

            @Override
            public final boolean a(ByteConsumer byteConsumer) {
                if (this.a >= this.c()) {
                    return false;
                }
                byteConsumer.accept(this.b.ByteArrayList.this.a[this.a++]);
                return true;
            }

            @Override
            public final void b(ByteConsumer byteConsumer) {
                int n2 = this.c();
                while (this.a < n2) {
                    byteConsumer.accept(this.b.ByteArrayList.this.a[this.a++]);
                }
            }

            @Override
            protected final /* synthetic */ ae.e a(int n2, int n3) {
                int n4 = n3;
                n3 = n2;
                b b2 = this;
                return new b(b2.b, n3, n4);
            }

            @Override
            public final /* synthetic */ void forEachRemaining(Object object) {
                ((ae.a)this).b((ByteConsumer)object);
            }

            @Override
            public final /* synthetic */ boolean tryAdvance(Object object) {
                return ((ae.a)this).a((ByteConsumer)object);
            }
        }
    }

    private final class a
    implements ByteSpliterator {
        private boolean a = false;
        private int b;
        private int c;
        private /* synthetic */ ByteArrayList e;

        public a(ByteArrayList byteArrayList) {
            this(byteArrayList, 0, byteArrayList.size, false);
        }

        private a(ByteArrayList byteArrayList, int n2, int n3, boolean bl) {
            this.e = byteArrayList;
            assert (n2 <= n3) : "pos " + n2 + " must be <= max " + n3;
            this.b = n2;
            this.c = n3;
            this.a = bl;
        }

        private int c() {
            if (this.a) {
                return this.c;
            }
            return this.e.size;
        }

        @Override
        public final int characteristics() {
            return 16720;
        }

        @Override
        public final long estimateSize() {
            return this.c() - this.b;
        }

        @Override
        public final ByteSpliterator d_() {
            int n2 = this.c();
            int n3 = n2 - this.b >> 1;
            if (n3 <= 1) {
                return null;
            }
            this.c = n2;
            n3 = n2 = this.b + n3;
            int n4 = this.b;
            this.b = n2;
            this.a = true;
            return new a(this.e, n4, n3, true);
        }

        @Override
        public final /* synthetic */ void forEachRemaining(Object object) {
            ByteConsumer byteConsumer = (ByteConsumer)object;
            object = this;
            int n2 = ((a)object).c();
            while (((a)object).b < n2) {
                byteConsumer.accept(((a)object).e.a[((a)object).b]);
                ++((a)object).b;
            }
        }

        @Override
        public final /* synthetic */ boolean tryAdvance(Object object) {
            ByteConsumer byteConsumer = (ByteConsumer)object;
            object = this;
            if (((a)object).b >= super.c()) {
                return false;
            }
            byteConsumer.accept(((a)object).e.a[((a)object).b++]);
            return true;
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.d_();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.d_();
        }
    }
}

