/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class MapToMiniPdbMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4449;
    private String fromName;
    private String toName;

    public MapToMiniPdbMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.fromName = reader.parseString(pdb, StringParseType.StringWcharNt);
        this.toName = reader.parseString(pdb, StringParseType.StringWcharNt);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4449;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: %s -> %s\n", this.getSymbolTypeName(), this.fromName, this.toName));
    }

    @Override
    protected String getSymbolTypeName() {
        return "PDBMAP";
    }
}

