/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.symbol.PatternlessSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class VarnodeSymbol
extends PatternlessSymbol {
    private VarnodeData fix;

    public VarnodeData getFixedVarnode() {
        return this.fix;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        hand.space = this.fix.space;
        hand.offset_space = null;
        hand.offset_offset = this.fix.offset;
        hand.size = this.fix.size;
    }

    @Override
    public String print(ParserWalker walker) {
        return this.getName();
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) {
        list.add(walker.getParentHandle());
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        this.fix = new VarnodeData();
        this.fix.space = decoder.readSpace(SlaFormat.ATTRIB_SPACE);
        this.fix.offset = decoder.readUnsignedInteger(SlaFormat.ATTRIB_OFF);
        this.fix.size = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_SIZE);
        decoder.closeElement(SlaFormat.ELEM_VARNODE_SYM.id());
    }
}

