/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.options;

import docking.DockingUtils;
import generic.theme.GColor;
import ghidra.framework.options.Options;
import ghidra.graph.viewer.options.ViewRestoreOption;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class VisualGraphOptions {
    public static final String GRAPH_BACKGROUND_COLOR_KEY = "Graph Background Color";
    public static final String GRAPH_BACKGROUND_COLOR_DESCRPTION = "The graph display background color";
    public static final String SHOW_ANIMATION_OPTIONS_KEY = "Use Animation";
    public static final String SHOW_ANIMATION_DESCRIPTION = "Signals to the Function Graph to use animated transitions for certain operations, like navigation.";
    public static final String USE_MOUSE_RELATIVE_ZOOM_KEY = "Use Mouse-relative Zoom";
    public static final String USE_MOUSE_RELATIVE_ZOOM_DESCRIPTION = "When true the Function Graph will perform zoom operations relative to the mouse point.";
    public static final String USE_CONDENSED_LAYOUT_KEY = "Use Condensed Layout";
    public static final String USE_CONDENSED_LAYOUT_DESCRIPTION = "Place vertices as close together as possible.  For example, when true, the graph will use little spacing between vertices.  Each layout will handle this option differently.";
    public static final String SCROLL_WHEEL_PANS_KEY = "Scroll Wheel Pans";
    public static final String SCROLL_WHEEL_PANS_DESCRIPTION = "When enabled the mouse scroll wheel will pan the view vertically.  When not enabled, you must hold the <b>" + DockingUtils.CONTROL_KEY_NAME + "</b> key while using the mouse wheel";
    public static final String USE_STICKY_SELECTION_KEY = "Use Sticky Selection";
    public static final String USE_STICKY_SELECTION_DESCRIPTION = "When enabled Selecting code units in one vertex will not clear the selection in another.  When disabled, every new selection clears the previous selection <b>unless the Control</b>key is pressed.";
    public static final String VIEW_RESTORE_OPTIONS_KEY = "View Settings";
    public static final String VIEW_RESTORE_OPTIONS_DESCRIPTION = "Dictates how the view of new graphs and already rendered graphs are zoomed and positioned.  See the help for more details.";
    public static final GColor DEFAULT_GRAPH_BACKGROUND_COLOR = new GColor("color.bg.visualgraph");
    protected Color graphBackgroundColor = DEFAULT_GRAPH_BACKGROUND_COLOR;
    protected boolean useAnimation = true;
    protected boolean scrollWheelPans = false;
    protected boolean useMouseRelativeZoom = true;
    protected boolean useCondensedLayout = true;
    protected ViewRestoreOption viewRestoreOption = ViewRestoreOption.START_FULLY_ZOOMED_OUT;

    public Color getGraphBackgroundColor() {
        return this.graphBackgroundColor;
    }

    public boolean isDefaultBackgroundColor(Color c) {
        return DEFAULT_GRAPH_BACKGROUND_COLOR.equals((Object)c);
    }

    public boolean getScrollWheelPans() {
        return this.scrollWheelPans;
    }

    public ViewRestoreOption getViewRestoreOption() {
        return this.viewRestoreOption;
    }

    public void setUseAnimation(boolean useAnimation) {
        this.useAnimation = useAnimation;
    }

    public boolean useAnimation() {
        return this.useAnimation;
    }

    public boolean useMouseRelativeZoom() {
        return this.useMouseRelativeZoom;
    }

    public boolean useCondensedLayout() {
        return this.useCondensedLayout;
    }

    public void registerOptions(Options options, HelpLocation help) {
        options.setOptionsHelpLocation(help);
        options.registerOption(SHOW_ANIMATION_OPTIONS_KEY, (Object)this.useAnimation(), help, SHOW_ANIMATION_DESCRIPTION);
        options.registerOption(USE_MOUSE_RELATIVE_ZOOM_KEY, (Object)this.useMouseRelativeZoom(), help, USE_MOUSE_RELATIVE_ZOOM_DESCRIPTION);
        options.registerOption(USE_CONDENSED_LAYOUT_KEY, (Object)this.useCondensedLayout(), help, USE_CONDENSED_LAYOUT_DESCRIPTION);
        options.registerOption(VIEW_RESTORE_OPTIONS_KEY, (Object)ViewRestoreOption.START_FULLY_ZOOMED_OUT, help, VIEW_RESTORE_OPTIONS_DESCRIPTION);
        options.registerOption(SCROLL_WHEEL_PANS_KEY, (Object)this.getScrollWheelPans(), help, SCROLL_WHEEL_PANS_DESCRIPTION);
        options.registerThemeColorBinding(GRAPH_BACKGROUND_COLOR_KEY, DEFAULT_GRAPH_BACKGROUND_COLOR.getId(), help, GRAPH_BACKGROUND_COLOR_DESCRPTION);
    }

    public void loadOptions(Options options) {
        this.useAnimation = options.getBoolean(SHOW_ANIMATION_OPTIONS_KEY, this.useAnimation);
        this.useMouseRelativeZoom = options.getBoolean(USE_MOUSE_RELATIVE_ZOOM_KEY, this.useMouseRelativeZoom);
        this.useCondensedLayout = options.getBoolean(USE_CONDENSED_LAYOUT_KEY, this.useCondensedLayout);
        this.viewRestoreOption = (ViewRestoreOption)options.getEnum(VIEW_RESTORE_OPTIONS_KEY, (Enum)ViewRestoreOption.START_FULLY_ZOOMED_OUT);
        this.scrollWheelPans = options.getBoolean(SCROLL_WHEEL_PANS_KEY, this.scrollWheelPans);
        this.graphBackgroundColor = options.getColor(GRAPH_BACKGROUND_COLOR_KEY, (Color)DEFAULT_GRAPH_BACKGROUND_COLOR);
    }
}

