/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_InstanceVariableList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_MetaClass
implements StructConverter {
    private ObjectiveC1_State _state;
    private long _index;
    private String isa;
    private String super_class;
    private String name;
    private int version;
    private int info;
    private int instance_size;
    private ObjectiveC1_InstanceVariableList variable_list;
    private ObjectiveC1_MethodList method_list;
    private int cache;
    private ObjectiveC1_ProtocolList protocols;
    private int unknown0;
    private int unknown1;

    ObjectiveC1_MetaClass(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.isa = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.super_class = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.version = reader.readNextInt();
        this.info = reader.readNextInt();
        this.instance_size = reader.readNextInt();
        this.variable_list = new ObjectiveC1_InstanceVariableList(state, reader.clone(reader.readNextInt()));
        this.method_list = new ObjectiveC1_MethodList(state, reader.clone(reader.readNextInt()), ObjectiveC_MethodType.INSTANCE);
        this.cache = reader.readNextInt();
        this.protocols = new ObjectiveC1_ProtocolList(state, reader.clone(reader.readNextInt()));
        this.unknown0 = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
    }

    public String getISA() {
        return this.isa;
    }

    public String getSuperClass() {
        return this.super_class;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int getInfo() {
        return this.info;
    }

    public int getInstanceSize() {
        return this.instance_size;
    }

    public ObjectiveC1_InstanceVariableList getInstanceVariableList() {
        return this.variable_list;
    }

    public ObjectiveC1_MethodList getMethodList() {
        return this.method_list;
    }

    public int getCache() {
        return this.cache;
    }

    public ObjectiveC1_ProtocolList getProtocols() {
        return this.protocols;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "objc_metaclass";
        StructureDataType struct = new StructureDataType(name, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "isa", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "super_class", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "name", null);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "info", null);
        struct.add(DWORD, "instance_size", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_InstanceVariableList.toGenericDataType(), (int)this._state.pointerSize), "instance_vars", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_MethodList.toGenericDataType(this._state), (int)this._state.pointerSize), "method_lists", null);
        struct.add(DWORD, "cache", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_ProtocolList.toGenericDataType(this._state), (int)this._state.pointerSize), "protocols", null);
        struct.add(DWORD, "unknown0", null);
        struct.add(DWORD, "unknown1", null);
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
        Namespace namespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", "Meta-classes", this.name);
        this.variable_list.applyTo();
        this.method_list.applyTo(namespace);
        this.protocols.applyTo();
    }
}

