/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.widgets.table.AbstractDynamicTableColumn;
import ghidra.app.plugin.core.codebrowser.AddressRangeInfo;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AddressRangeEndpointSettingsDefinition;
import ghidra.util.table.field.ByteCountSettingsDefinition;
import ghidra.util.table.field.MemoryOffsetSettingsDefinition;
import ghidra.util.table.field.MonospacedByteRenderer;

public class AddressRangeBytesTableColumn
extends AbstractDynamicTableColumn<AddressRangeInfo, Byte[], Program> {
    private final GColumnRenderer<Byte[]> monospacedRenderer = new MonospacedByteRenderer();
    private static SettingsDefinition[] SETTINGS = new SettingsDefinition[]{ByteCountSettingsDefinition.DEF, MemoryOffsetSettingsDefinition.DEF, EndianSettingsDefinition.DEF, FormatSettingsDefinition.DEF, AddressRangeEndpointSettingsDefinition.DEF};
    private static final String COLUMN_NAME = "Bytes";

    public String getColumnName() {
        return COLUMN_NAME;
    }

    public Byte[] getValue(AddressRangeInfo rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        int choice = AddressRangeEndpointSettingsDefinition.DEF.getChoice(settings);
        Address base = choice == 0 ? rowObject.min() : rowObject.max();
        int offset = MemoryOffsetSettingsDefinition.DEF.getOffset(settings);
        int byteCount = ByteCountSettingsDefinition.DEF.getChoice(settings);
        byte[] bytes = null;
        try {
            base = base.addNoWrap((long)offset);
            if (byteCount == 0) {
                if (offset != 0) {
                    byteCount = 1;
                } else {
                    CodeUnit cu = program.getListing().getCodeUnitContaining(base);
                    if (cu == null) {
                        return new Byte[0];
                    }
                    if (cu instanceof Instruction) {
                        Instruction instr = (Instruction)cu;
                        bytes = instr.getParsedBytes();
                    } else {
                        bytes = cu.getBytes();
                    }
                }
            }
            if (bytes == null) {
                bytes = new byte[byteCount];
                program.getMemory().getBytes(base, bytes);
            }
            Byte[] bytesObj = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytesObj[i] = bytes[i];
            }
            return bytesObj;
        }
        catch (AddressOverflowException | MemoryAccessException e) {
            return new Byte[0];
        }
    }

    public GColumnRenderer<Byte[]> getColumnRenderer() {
        return this.monospacedRenderer;
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS;
    }

    public String getColumnDisplayName(Settings settings) {
        String offset;
        StringBuilder sb = new StringBuilder(AddressRangeEndpointSettingsDefinition.DEF.getValueString(settings));
        sb.append(" ").append(COLUMN_NAME);
        int byteCnt = ByteCountSettingsDefinition.DEF.getChoice(settings);
        if (byteCnt != 0) {
            sb.append("[");
            sb.append(byteCnt);
            sb.append("]");
        }
        if (!(offset = MemoryOffsetSettingsDefinition.DEF.getValueString(settings)).equals("0")) {
            sb.append(offset);
        }
        return sb.toString();
    }
}

