/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.MultiStateActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.BasicAutoReadMemorySpec;
import ghidra.app.plugin.core.debug.gui.action.DebuggerAutoReadMemoryAction;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class DebuggerReadsMemoryTrait {
    protected static final AutoConfigState.ClassHandler<DebuggerReadsMemoryTrait> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerReadsMemoryTrait.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected MultiStateDockingAction<AutoReadMemorySpec> actionAutoRead;
    protected RefreshSelectedMemoryAction actionRefreshSelected;
    private final AutoReadMemorySpec defaultAutoSpec;
    @AutoConfigStateField(codec=AutoReadMemorySpec.AutoReadMemorySpecConfigFieldCodec.class)
    protected AutoReadMemorySpec autoSpec;
    protected final PluginTool tool;
    protected final Plugin plugin;
    protected final ComponentProvider provider;
    protected final ForReadsTraceListener traceListener;
    protected final ForVisibilityListener displayListener;
    protected DebuggerCoordinates current;
    protected AddressSetView visible;
    protected final Object lock;
    protected volatile CompletableFuture<?> lastRead;

    public DebuggerReadsMemoryTrait(PluginTool tool, Plugin plugin, ComponentProvider provider) {
        this.autoSpec = this.defaultAutoSpec = BasicAutoReadMemorySpec.VIS_RO_ONCE;
        this.traceListener = new ForReadsTraceListener();
        this.displayListener = new ForVisibilityListener();
        this.current = DebuggerCoordinates.NOWHERE;
        this.lock = new Object();
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
    }

    protected boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getTarget(), b.getTarget());
    }

    protected void addNewTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().addListener((DomainObjectListener)this.traceListener);
        }
    }

    protected void removeOldTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().removeListener((DomainObjectListener)this.traceListener);
        }
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        boolean doTraceListener;
        if (this.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean bl = doTraceListener = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        if (doTraceListener) {
            this.removeOldTraceListener();
        }
        this.current = coordinates;
        if (this.actionRefreshSelected != null) {
            this.actionRefreshSelected.updateEnabled(null);
        }
        if (doTraceListener) {
            this.addNewTraceListener();
        }
        this.doAutoRead();
    }

    protected boolean isConsistent() {
        TraceProgramView view = this.current.getView();
        if (view == null || this.visible.isEmpty()) {
            return true;
        }
        AddressSpace space = this.visible.getFirstRange().getAddressSpace();
        int id = space.getSpaceID();
        return space == view.getAddressFactory().getAddressSpace(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAutoRead() {
        if (!this.isConsistent()) {
            return;
        }
        AddressSet visible = new AddressSet(this.visible);
        Object object = this.lock;
        synchronized (object) {
            this.lastRead = ((CompletableFuture)this.autoSpec.getEffective(this.current).readMemory(this.tool, this.current, (AddressSetView)visible).thenAccept(b -> {
                if (b.booleanValue()) {
                    this.memoryWasRead((AddressSetView)visible);
                }
            })).exceptionally(ex -> {
                Msg.error((Object)this, (Object)("Could not auto-read memory: " + String.valueOf(ex)));
                return null;
            });
        }
    }

    public MultiStateDockingAction<AutoReadMemorySpec> installAutoReadAction() {
        this.actionAutoRead = (MultiStateDockingAction)((MultiStateActionBuilder)DebuggerAutoReadMemoryAction.builder(this.plugin).onAction(this::activatedAutoRead)).onActionStateChanged(this::changedAutoReadMemory).buildAndInstallLocal(this.provider);
        this.actionAutoRead.setCurrentActionStateByUserData((Object)this.defaultAutoSpec);
        return this.actionAutoRead;
    }

    protected void activatedAutoRead(ActionContext ctx) {
        this.doAutoRead();
    }

    protected void changedAutoReadMemory(ActionState<AutoReadMemorySpec> newState, EventTrigger trigger) {
        this.doSetAutoRead((AutoReadMemorySpec)newState.getUserData());
    }

    protected void doSetAutoRead(AutoReadMemorySpec spec) {
        this.autoSpec = spec;
        if (this.visible != null) {
            this.doAutoRead();
        }
    }

    public DockingAction installRefreshSelectedAction() {
        this.actionRefreshSelected = new RefreshSelectedMemoryAction();
        this.provider.addLocalAction((DockingActionIf)this.actionRefreshSelected);
        return this.actionRefreshSelected;
    }

    public AddressSetDisplayListener getDisplayListener() {
        return this.displayListener;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionAutoRead.setCurrentActionStateByUserData((Object)this.autoSpec);
    }

    public void setAutoSpec(AutoReadMemorySpec autoSpec) {
        if (autoSpec == null || autoSpec.getConfigName() == null) {
            throw new IllegalArgumentException("autoSpec " + String.valueOf(autoSpec.getClass()) + "not allowed in menu. Cannot be set explicitly.");
        }
        this.actionAutoRead.setCurrentActionStateByUserData((Object)autoSpec);
    }

    public AutoReadMemorySpec getAutoSpec() {
        return this.autoSpec;
    }

    @Internal
    public AddressSetView getVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public CompletableFuture<?> getLastRead() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastRead;
        }
    }

    protected abstract AddressSetView getSelection();

    protected abstract void repaintPanel();

    protected void memoryWasRead(AddressSetView read) {
    }

    protected class ForReadsTraceListener
    extends TraceDomainObjectListener {
        public ForReadsTraceListener() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, this::objectRestored);
            this.listenFor((TraceEvent)TraceEvents.SNAPSHOT_ADDED, this::snapshotAdded);
            this.listenFor((TraceEvent)TraceEvents.BYTES_STATE_CHANGED, this::memStateChanged);
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            DebuggerReadsMemoryTrait.this.actionRefreshSelected.updateEnabled(null);
            DebuggerReadsMemoryTrait.this.doAutoRead();
        }

        private void snapshotAdded(TraceSnapshot snapshot) {
            DebuggerReadsMemoryTrait.this.actionRefreshSelected.updateEnabled(null);
        }

        private void memStateChanged(TraceAddressSnapRange range, TraceMemoryState oldIsNull, TraceMemoryState newState) {
            if (DebuggerReadsMemoryTrait.this.current.getView() == null) {
                return;
            }
            if (!range.getLifespan().contains(DebuggerReadsMemoryTrait.this.current.getSnap())) {
                return;
            }
            DebuggerReadsMemoryTrait.this.repaintPanel();
            if (newState == TraceMemoryState.UNKNOWN) {
                DebuggerReadsMemoryTrait.this.doAutoRead();
            }
        }
    }

    protected class ForVisibilityListener
    implements AddressSetDisplayListener {
        protected ForVisibilityListener() {
        }

        public void visibleAddressesChanged(AddressSetView visibleAddresses) {
            if (Objects.equals(DebuggerReadsMemoryTrait.this.visible, visibleAddresses)) {
                return;
            }
            DebuggerReadsMemoryTrait.this.visible = visibleAddresses;
            DebuggerReadsMemoryTrait.this.doAutoRead();
        }
    }

    protected class RefreshSelectedMemoryAction
    extends DebuggerResources.AbstractRefreshSelectedMemoryAction {
        public static final String GROUP = "Dbg1. General";

        public RefreshSelectedMemoryAction() {
            super(DebuggerReadsMemoryTrait.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerReadsMemoryTrait.this.current.isAliveAndReadsPresent()) {
                return;
            }
            AddressSetView selection = DebuggerReadsMemoryTrait.this.getSelection();
            if (selection == null || selection.isEmpty()) {
                selection = DebuggerReadsMemoryTrait.this.visible;
            }
            final AddressSetView sel = selection;
            final Target target = DebuggerReadsMemoryTrait.this.current.getTarget();
            TargetActionTask.executeTask(DebuggerReadsMemoryTrait.this.tool, new Task("Read Selected Memory", true, true, false){

                public void run(TaskMonitor monitor) throws CancelledException {
                    target.invalidateMemoryCaches();
                    try {
                        target.readMemoryAsync(sel, monitor).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException("Failed to read memory", e);
                    }
                    DebuggerReadsMemoryTrait.this.memoryWasRead(sel);
                }
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerReadsMemoryTrait.this.current.isAliveAndReadsPresent();
        }

        public void updateEnabled(ActionContext context) {
            this.setEnabled(this.isEnabledForContext(context));
        }
    }
}

