/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.target;

import docking.ActionContext;
import generic.theme.GIcon;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.trace.model.TraceExecutionState;
import ghidra.trace.model.target.TraceObject;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;

public record ActionName(String name, Show show, Enabler enabler, String display, Icon icon, String okText) {
    private static final Icon ICON_ATTACH = new GIcon("icon.debugger.attach");
    private static final Icon ICON_CONNECT = new GIcon("icon.debugger.connect");
    private static final Icon ICON_DETACH = new GIcon("icon.debugger.detach");
    private static final Icon ICON_INTERRUPT = new GIcon("icon.debugger.interrupt");
    private static final Icon ICON_KILL = new GIcon("icon.debugger.kill");
    private static final Icon ICON_LAUNCH = new GIcon("icon.debugger.launch");
    private static final Icon ICON_REFRESH = new GIcon("icon.debugger.refresh");
    private static final Icon ICON_RESUME = new GIcon("icon.debugger.resume");
    private static final Icon ICON_STEP_BACK = new GIcon("icon.debugger.step.back");
    private static final Icon ICON_STEP_INTO = new GIcon("icon.debugger.step.into");
    private static final Icon ICON_STEP_LAST = new GIcon("icon.debugger.step.last");
    private static final Icon ICON_STEP_OUT = new GIcon("icon.debugger.step.finish");
    private static final Icon ICON_STEP_OVER = new GIcon("icon.debugger.step.over");
    private static final Icon ICON_SKIP_OVER = new GIcon("icon.debugger.skip.over");
    private static final Icon ICON_SET_BREAKPOINT = new GIcon("icon.debugger.breakpoint.set");
    private static final Map<String, ActionName> NAMES = new HashMap<String, ActionName>();
    public static final ActionName REFRESH = ActionName.create("refresh", Show.EXTENDED, Enabler.ALWAYS, "Refresh", ICON_REFRESH, "Refresh");
    public static final ActionName ACTIVATE = ActionName.create("activate", Show.BUILTIN, Enabler.ALWAYS, "Activate", null, "Activate");
    public static final ActionName FOCUS = ActionName.create("focus", Show.BUILTIN, Enabler.ALWAYS, "Focus", null, "Focus");
    public static final ActionName TOGGLE = ActionName.create("toggle", Show.BUILTIN, Enabler.ALWAYS, "Toggle", null, "Toggle");
    public static final ActionName DELETE = ActionName.create("delete", Show.BUILTIN, Enabler.ALWAYS, "Delete", null, "Delete");
    public static final ActionName EXECUTE = ActionName.create("execute", Show.BUILTIN, Enabler.ALWAYS, "Execute", null, "Execute");
    public static final ActionName CONNECT = ActionName.create("connect", Show.EXTENDED, Enabler.ALWAYS, "Connect", ICON_CONNECT, "Connect");
    public static final ActionName ATTACH = ActionName.create("attach", Show.EXTENDED, Enabler.ALWAYS, "Attach", ICON_ATTACH, "Attach");
    public static final ActionName DETACH = ActionName.create("detach", Show.EXTENDED, Enabler.ALWAYS, "Detach", ICON_DETACH, "Detach");
    public static final ActionName LAUNCH = ActionName.create("launch", Show.EXTENDED, Enabler.ALWAYS, "Launch", ICON_LAUNCH, "Launch");
    public static final ActionName KILL = ActionName.create("kill", Show.BUILTIN, Enabler.NOT_DEAD, "Kill", ICON_KILL, "Kill");
    public static final ActionName RESUME = ActionName.create("resume", Show.BUILTIN, Enabler.NOT_RUNNING, "Resume", ICON_RESUME, "Resume");
    public static final ActionName INTERRUPT = ActionName.create("interrupt", Show.BUILTIN, Enabler.NOT_STOPPED, "Interrupt", ICON_INTERRUPT, "Interrupt");
    public static final ActionName STEP_INTO = ActionName.create("step_into", Show.BUILTIN, Enabler.NOT_RUNNING, "Step Into", ICON_STEP_INTO, "Step");
    public static final ActionName STEP_OVER = ActionName.create("step_over", Show.BUILTIN, Enabler.NOT_RUNNING, "Step Over", ICON_STEP_OVER, "Step");
    public static final ActionName STEP_OUT = ActionName.create("step_out", Show.BUILTIN, Enabler.NOT_RUNNING, "Step Out", ICON_STEP_OUT, "Step");
    public static final ActionName STEP_SKIP = ActionName.create("step_skip", Show.BUILTIN, Enabler.NOT_RUNNING, "Skip Over", ICON_SKIP_OVER, "Skip");
    public static final ActionName STEP_BACK = ActionName.create("step_back", Show.BUILTIN, Enabler.NOT_RUNNING, "Step Back", ICON_STEP_BACK, "Back");
    public static final ActionName STEP_EXT = ActionName.create("step_ext", Show.ADDRESS, Enabler.NOT_RUNNING, null, ICON_STEP_LAST, "Step");
    public static final ActionName BREAK_SW_EXECUTE = ActionName.create("break_sw_execute", Show.BUILTIN, Enabler.ALWAYS, "Set Software Breakpoint", ICON_SET_BREAKPOINT, "Set");
    public static final ActionName BREAK_HW_EXECUTE = ActionName.create("break_hw_execute", Show.BUILTIN, Enabler.ALWAYS, "Set Hardware Breakpoint", ICON_SET_BREAKPOINT, "Set");
    public static final ActionName BREAK_READ = ActionName.create("break_read", Show.BUILTIN, Enabler.ALWAYS, "Set Read Breakpoint", ICON_SET_BREAKPOINT, "Set");
    public static final ActionName BREAK_WRITE = ActionName.create("break_write", Show.BUILTIN, Enabler.ALWAYS, "Set Write Breakpoint", ICON_SET_BREAKPOINT, "Set");
    public static final ActionName BREAK_ACCESS = ActionName.create("break_access", Show.BUILTIN, Enabler.ALWAYS, "Set Access Breakpont", ICON_SET_BREAKPOINT, "Set");
    public static final ActionName BREAK_EXT = ActionName.create("break_ext", Show.BUILTIN, Enabler.ALWAYS, null, ICON_SET_BREAKPOINT, "Set");
    public static final ActionName READ_MEM = ActionName.create("read_mem", Show.BUILTIN, Enabler.ALWAYS, "Read Memory", null, "Read");
    public static final ActionName WRITE_MEM = ActionName.create("write_mem", Show.BUILTIN, Enabler.ALWAYS, "Write Memory", null, "Write");
    public static final ActionName WRITE_REG = ActionName.create("write_reg", Show.BUILTIN, Enabler.NOT_RUNNING, "Write Register", null, "Write");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionName name(String name) {
        Map<String, ActionName> map = NAMES;
        synchronized (map) {
            return NAMES.computeIfAbsent(name, n -> new ActionName((String)n, Show.EXTENDED, Enabler.ALWAYS, (String)n, null, "OK"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionName create(String name, Show show, Enabler enabler, String display, Icon icon, String okText) {
        Map<String, ActionName> map = NAMES;
        synchronized (map) {
            ActionName action = new ActionName(name, show, enabler, display, icon, okText);
            if (NAMES.put(name, action) != null) {
                throw new AssertionError();
            }
            return action;
        }
    }

    public static enum Show {
        BUILTIN{

            @Override
            boolean doIsShowing(ActionContext context) {
                return false;
            }
        }
        ,
        ADDRESS{

            @Override
            boolean doIsShowing(ActionContext context) {
                return context instanceof ProgramLocationActionContext;
            }
        }
        ,
        EXTENDED{

            @Override
            boolean doIsShowing(ActionContext context) {
                return true;
            }
        };


        public boolean isShowing(ActionContext context) {
            if (this.isOverriden(context)) {
                return true;
            }
            return this.doIsShowing(context);
        }

        abstract boolean doIsShowing(ActionContext var1);

        private boolean isOverriden(ActionContext context) {
            return (context.getEventClickModifiers() & 0x40) != 0;
        }
    }

    public static enum Enabler {
        ALWAYS{

            @Override
            public boolean isEnabled(TraceObject obj, long snap) {
                return true;
            }
        }
        ,
        NOT_RUNNING{

            @Override
            boolean doIsEnabled(TraceExecutionState state) {
                return state != null && state != TraceExecutionState.RUNNING;
            }
        }
        ,
        NOT_STOPPED{

            @Override
            boolean doIsEnabled(TraceExecutionState state) {
                return state != TraceExecutionState.STOPPED;
            }
        }
        ,
        NOT_DEAD{

            @Override
            boolean doIsEnabled(TraceExecutionState state) {
                return state != TraceExecutionState.TERMINATED;
            }
        };


        private TraceExecutionState getState(TraceObject obj, long snap) {
            try {
                return obj.getExecutionState(snap);
            }
            catch (NoSuchElementException e) {
                return TraceExecutionState.TERMINATED;
            }
        }

        boolean doIsEnabled(TraceExecutionState state) {
            return true;
        }

        public boolean isEnabled(TraceObject obj, long snap) {
            return this.doIsEnabled(this.getState(obj, snap));
        }
    }
}

