/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty;

import ghidra.framework.OperatingSystem;
import ghidra.pty.Pty;
import ghidra.pty.linux.LinuxPtyFactory;
import ghidra.pty.macos.MacosPtyFactory;
import ghidra.pty.windows.ConPtyFactory;
import java.io.IOException;

public interface PtyFactory {
    public static final short DEFAULT_COLS = 80;
    public static final short DEFAULT_ROWS = 25;

    public static PtyFactory local() {
        switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
            case MAC_OS_X: {
                return MacosPtyFactory.INSTANCE;
            }
            case LINUX: {
                return LinuxPtyFactory.INSTANCE;
            }
            case WINDOWS: {
                return ConPtyFactory.INSTANCE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public Pty openpty(short var1, short var2) throws IOException;

    default public Pty openpty() throws IOException {
        return this.openpty((short)80, (short)25);
    }

    default public Pty openpty(int cols, int rows) throws IOException {
        return this.openpty((short)cols, (short)rows);
    }

    public String getDescription();
}

