/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AnchoredLayoutHandler {
    private final LayoutModel model;
    private int viewHeight;
    private final LinkedList<AnchoredLayout> layouts = new LinkedList();

    public AnchoredLayoutHandler(LayoutModel model, int viewHeight) {
        this.model = model;
        this.viewHeight = viewHeight;
    }

    public List<AnchoredLayout> positionLayoutsAroundAnchor(BigInteger anchorIndex, int viewPosition) {
        this.layouts.clear();
        AnchoredLayout layout = this.getClosestLayout(anchorIndex, viewPosition);
        if (layout != null) {
            this.layouts.add(layout);
            this.fillOutLayouts();
        }
        return new ArrayList<AnchoredLayout>(this.layouts);
    }

    public List<AnchoredLayout> shiftViewDownOneRow() {
        if (this.layouts.isEmpty()) {
            return new ArrayList<AnchoredLayout>();
        }
        AnchoredLayout layout = this.layouts.getFirst();
        int yPos = layout.getYPos();
        int scrollAmount = layout.getScrollableUnitIncrement(-yPos, 1);
        return this.shiftView(scrollAmount);
    }

    public List<AnchoredLayout> shiftViewUpOneRow() {
        if (this.layouts.isEmpty()) {
            return new ArrayList<AnchoredLayout>();
        }
        int scrollAmount = 0;
        AnchoredLayout layout = this.layouts.getFirst();
        BigInteger index = layout.getIndex();
        int yPos = layout.getYPos();
        if (yPos == 0) {
            layout = this.getPreviousLayout(index, yPos);
            if (layout == null) {
                return new ArrayList<AnchoredLayout>(this.layouts);
            }
            this.layouts.add(0, layout);
            yPos = layout.getYPos();
        }
        scrollAmount = layout.getScrollableUnitIncrement(-yPos, -1);
        return this.shiftView(scrollAmount);
    }

    public List<AnchoredLayout> shiftViewDownOnePage() {
        if (this.layouts.isEmpty()) {
            return new ArrayList<AnchoredLayout>();
        }
        AnchoredLayout last = this.layouts.getLast();
        int diff = last.getScrollableUnitIncrement(this.viewHeight - last.getYPos(), -1);
        return this.shiftView(this.viewHeight + diff);
    }

    public List<AnchoredLayout> shiftViewUpOnePage() {
        int diff;
        if (this.layouts.isEmpty()) {
            return new ArrayList<AnchoredLayout>();
        }
        int scrollAmount = this.viewHeight;
        AnchoredLayout first = this.layouts.getFirst();
        if (first.getYPos() != 0 && (diff = first.getScrollableUnitIncrement(-first.getYPos(), 1)) < this.viewHeight) {
            scrollAmount -= diff;
        }
        this.shiftView(-scrollAmount);
        first = this.layouts.getFirst();
        if (first.getYPos() != 0) {
            return this.shiftViewDownOneRow();
        }
        return new ArrayList<AnchoredLayout>(this.layouts);
    }

    public List<AnchoredLayout> shiftView(int viewAmount) {
        this.repositionLayouts(-viewAmount);
        this.fillOutLayouts();
        return new ArrayList<AnchoredLayout>(this.layouts);
    }

    public List<AnchoredLayout> setViewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
        if (this.layouts.isEmpty()) {
            return this.positionLayoutsAroundAnchor(BigInteger.ZERO, 0);
        }
        this.fillOutLayouts();
        return new ArrayList<AnchoredLayout>(this.layouts);
    }

    private void fillOutLayouts() {
        if (this.layouts.isEmpty()) {
            return;
        }
        AnchoredLayout lastLayout = this.layouts.getLast();
        this.fillLayoutsForward(lastLayout.getIndex(), lastLayout.getYPos() + lastLayout.getHeight());
        lastLayout = this.layouts.getLast();
        if (lastLayout.getEndY() < this.viewHeight) {
            this.repositionLayouts(this.viewHeight - lastLayout.getEndY());
        }
        AnchoredLayout firstLayout = this.layouts.getFirst();
        this.fillLayoutsBack(firstLayout.getIndex(), firstLayout.getYPos());
        firstLayout = this.layouts.getFirst();
        if (firstLayout.getYPos() > 0) {
            this.repositionLayouts(-firstLayout.getYPos());
        }
        lastLayout = this.layouts.getLast();
        this.fillLayoutsForward(lastLayout.getIndex(), lastLayout.getYPos() + lastLayout.getHeight());
        this.trimLayouts();
    }

    private void repositionLayouts(int amount) {
        for (AnchoredLayout layout : this.layouts) {
            layout.setYPos(layout.getYPos() + amount);
        }
    }

    private void trimLayouts() {
        Iterator it = this.layouts.iterator();
        while (it.hasNext()) {
            int height;
            AnchoredLayout layout = (AnchoredLayout)it.next();
            int y = layout.getYPos();
            if (y + (height = layout.getHeight()) > 0 && y <= this.viewHeight) continue;
            it.remove();
        }
    }

    private void fillLayoutsForward(BigInteger existingLastIndex, int y) {
        BigInteger index = existingLastIndex;
        while (y < this.viewHeight) {
            AnchoredLayout nextLayout = this.getNextLayout(index, y);
            if (nextLayout == null) {
                return;
            }
            this.layouts.add(nextLayout);
            y += nextLayout.getHeight();
            index = nextLayout.getIndex();
        }
    }

    private void fillLayoutsBack(BigInteger existingFirstIndex, int y) {
        BigInteger index = existingFirstIndex;
        while (y > 0) {
            AnchoredLayout prevLayout = this.getPreviousLayout(index, y);
            if (prevLayout == null) {
                return;
            }
            this.layouts.addFirst(prevLayout);
            y -= prevLayout.getHeight();
            index = prevLayout.getIndex();
        }
    }

    private AnchoredLayout getPreviousLayout(BigInteger index, int yPos) {
        while ((index = this.model.getIndexBefore(index)) != null) {
            Layout layout = this.model.getLayout(index);
            if (layout == null) continue;
            return new AnchoredLayout(layout, index, yPos - layout.getHeight());
        }
        return null;
    }

    private AnchoredLayout getNextLayout(BigInteger index, int yPos) {
        while ((index = this.model.getIndexAfter(index)) != null) {
            Layout layout = this.model.getLayout(index);
            if (layout == null) continue;
            return new AnchoredLayout(layout, index, yPos);
        }
        return null;
    }

    private AnchoredLayout getClosestLayout(BigInteger index, int y) {
        Layout layout = this.model.getLayout(index);
        if (layout != null) {
            return new AnchoredLayout(layout, index, y);
        }
        AnchoredLayout nextLayout = this.getNextLayout(index, y);
        if (nextLayout != null) {
            return nextLayout;
        }
        AnchoredLayout previousLayout = this.getPreviousLayout(index, y);
        if (previousLayout != null) {
            previousLayout.setYPos(y);
            return previousLayout;
        }
        return null;
    }
}

