/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSession;
import org.jkiss.dbeaver.model.net.ssh.SSHJSessionController;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SSHJSession
extends AbstractSession {
    private static final Log log = Log.getLog(SSHJSession.class);
    private final Map<SSHPortForwardConfiguration, LocalPortListener> listeners = new ConcurrentHashMap<SSHPortForwardConfiguration, LocalPortListener>();
    private final SSHJSessionController controller;
    private SSHClient client;

    public SSHJSession(@NotNull SSHJSessionController controller) {
        this.controller = controller;
    }

    public void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        this.client = this.controller.createNewSession(monitor, configuration, destination);
    }

    public void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
        this.listeners.clear();
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            throw new DBException("Error disconnecting SSH session", (Throwable)e);
        }
    }

    @NotNull
    public SSHPortForwardConfiguration setupPortForward(@NotNull SSHPortForwardConfiguration config) throws DBException {
        try {
            LocalPortListener listener = LocalPortListener.setup(this.client, config);
            SSHPortForwardConfiguration resolved = Objects.requireNonNull(listener.resolved);
            this.listeners.put(resolved, listener);
            return resolved;
        }
        catch (Exception e) {
            throw new DBException("Error setting up port forwarding", (Throwable)e);
        }
    }

    public void removePortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
        LocalPortListener listener = this.listeners.remove(configuration);
        if (listener == null) {
            throw new DBException("No such port forward configuration: " + String.valueOf(configuration));
        }
        listener.disconnect();
    }

    public void getFile(@NotNull String src, final @NotNull OutputStream dst, @NotNull DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SFTPClient client = this.openSftpClient();){
            client.get(src, (LocalDestFile)new InMemoryDestFile(){

                public long getLength() {
                    return -1L;
                }

                public OutputStream getOutputStream() {
                    return dst;
                }

                public OutputStream getOutputStream(boolean b) {
                    return dst;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void putFile(final @NotNull InputStream src, @NotNull String dst, @NotNull DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SFTPClient client = this.openSftpClient();){
            client.put((LocalSourceFile)new InMemorySourceFile(){

                public String getName() {
                    return "memory";
                }

                public long getLength() {
                    return -1L;
                }

                public InputStream getInputStream() {
                    return src;
                }
            }, dst);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public String getClientVersion() {
        return this.client.getTransport().getClientVersion();
    }

    @NotNull
    public String getServerVersion() {
        return this.client.getTransport().getServerVersion();
    }

    @NotNull
    private SFTPClient openSftpClient() throws IOException {
        SFTPClient sftpClient = this.client.newSFTPClient();
        sftpClient.getFileTransfer().setPreserveAttributes(false);
        return sftpClient;
    }

    private static class LocalPortListener
    extends Thread {
        private final SSHClient client;
        private final SSHPortForwardConfiguration config;
        private final CountDownLatch started = new CountDownLatch(1);
        private volatile LocalPortForwarder forwarder;
        private volatile SSHPortForwardConfiguration resolved;

        public LocalPortListener(@NotNull SSHClient client, @NotNull SSHPortForwardConfiguration config) {
            this.client = client;
            this.config = config;
        }

        @NotNull
        public static LocalPortListener setup(@NotNull SSHClient client, @NotNull SSHPortForwardConfiguration config) throws InterruptedException {
            LocalPortListener listener = new LocalPortListener(client, config);
            listener.start();
            listener.await();
            return listener;
        }

        @Override
        public void run() {
            try {
                ServerSocket socket = new ServerSocket(this.config.localPort(), 0, InetAddress.getByName(this.config.localHost()));
                Parameters parameters = new Parameters(this.config.localHost(), socket.getLocalPort(), this.config.remoteHost(), this.config.remotePort());
                this.forwarder = this.client.newLocalPortForwarder(parameters, socket);
                this.resolved = new SSHPortForwardConfiguration(this.config.localHost(), socket.getLocalPort(), this.config.remoteHost(), this.config.remotePort());
                this.setName("Port forwarder listener (" + String.valueOf(this.resolved) + ")");
                this.started.countDown();
                this.forwarder.listen();
            }
            catch (IOException e) {
                log.error((Object)"Error while listening on the port forwarder", (Throwable)e);
            }
        }

        public void disconnect() {
            try {
                this.forwarder.close();
                this.forwarder = null;
            }
            catch (Exception e) {
                log.error((Object)"Error while stopping port forwarding", (Throwable)e);
            }
        }

        private void await() throws InterruptedException {
            this.started.await();
            while (!this.forwarder.isRunning()) {
                Thread.yield();
            }
        }
    }
}

