/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "CSSPaintCallback.h"
#include "IDLTypes.h"
#include "JSCallbackData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSCSSPaintCallback final : public CSSPaintCallback {
public:
    static Ref<JSCSSPaintCallback> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSCSSPaintCallback(callback, globalObject));
    }

    ScriptExecutionContext* scriptExecutionContext() const;

    ~JSCSSPaintCallback() final;
    JSCallbackData* callbackData() { return m_data; }

    // Functions
    CallbackResult<typename IDLUndefined::CallbackReturnType> invoke(typename IDLAny::ParameterType thisObject, typename IDLInterface<PaintRenderingContext2D>::ParameterType context, typename IDLInterface<CSSPaintSize>::ParameterType size, typename IDLInterface<StylePropertyMapReadOnly>::ParameterType styleMap, typename IDLSequence<IDLUSVString>::ParameterType arguments) override;
    CallbackResult<typename IDLUndefined::CallbackReturnType> invokeRethrowingException(typename IDLAny::ParameterType thisObject, typename IDLInterface<PaintRenderingContext2D>::ParameterType context, typename IDLInterface<CSSPaintSize>::ParameterType size, typename IDLInterface<StylePropertyMapReadOnly>::ParameterType styleMap, typename IDLSequence<IDLUSVString>::ParameterType arguments) override;

private:
    JSCSSPaintCallback(JSC::JSObject*, JSDOMGlobalObject*);

    bool hasCallback() const final { return m_data && m_data->callback(); }

    JSCallbackData* m_data;
};

JSC::JSValue toJS(CSSPaintCallback&);
inline JSC::JSValue toJS(CSSPaintCallback* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

template<> struct JSDOMCallbackConverterTraits<JSCSSPaintCallback> {
    using Base = CSSPaintCallback;
};
} // namespace WebCore
