// ui/display/mojom/display_constants.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_SHARED_H_
#define UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_constants.mojom-shared-internal.h"







namespace display::mojom {
class ModesetFlagsDataView;



}  // display::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::ModesetFlagsDataView> {
  using Data = ::display::mojom::internal::ModesetFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


enum class DisplayConnectionType : int32_t {
  
  DISPLAY_CONNECTION_TYPE_NONE = 0,
  
  DISPLAY_CONNECTION_TYPE_UNKNOWN = 1,
  
  DISPLAY_CONNECTION_TYPE_INTERNAL = 2,
  
  DISPLAY_CONNECTION_TYPE_VGA = 4,
  
  DISPLAY_CONNECTION_TYPE_HDMI = 8,
  
  DISPLAY_CONNECTION_TYPE_DVI = 16,
  
  DISPLAY_CONNECTION_TYPE_DISPLAYPORT = 32,
  
  DISPLAY_CONNECTION_TYPE_NETWORK = 64,
  kMinValue = 0,
  kMaxValue = 64,
};

 std::ostream& operator<<(std::ostream& os, DisplayConnectionType value);
inline bool IsKnownEnumValue(DisplayConnectionType value) {
  return internal::DisplayConnectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HDCPState : int32_t {
  
  HDCP_STATE_UNDESIRED = 0,
  
  HDCP_STATE_DESIRED = 1,
  
  HDCP_STATE_ENABLED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HDCPState value);
inline bool IsKnownEnumValue(HDCPState value) {
  return internal::HDCPState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentProtectionMethod : int32_t {
  
  CONTENT_PROTECTION_METHOD_NONE = 0,
  
  CONTENT_PROTECTION_METHOD_HDCP_TYPE_0 = 1,
  
  CONTENT_PROTECTION_METHOD_HDCP_TYPE_1 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentProtectionMethod value);
inline bool IsKnownEnumValue(ContentProtectionMethod value) {
  return internal::ContentProtectionMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PanelOrientation : int32_t {
  
  NORMAL = 0,
  
  BOTTOM_UP = 1,
  
  LEFT_UP = 2,
  
  RIGHT_UP = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PanelOrientation value);
inline bool IsKnownEnumValue(PanelOrientation value) {
  return internal::PanelOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrivacyScreenState : int32_t {
  
  DISABLED = 0,
  
  ENABLED = 1,
  
  DISABLED_LOCKED = 2,
  
  ENABLED_LOCKED = 3,
  
  NOT_SUPPORTED = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PrivacyScreenState value);
inline bool IsKnownEnumValue(PrivacyScreenState value) {
  return internal::PrivacyScreenState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VariableRefreshRateState : int32_t {
  
  kVrrDisabled = 0,
  
  kVrrEnabled = 1,
  
  kVrrNotCapable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VariableRefreshRateState value);
inline bool IsKnownEnumValue(VariableRefreshRateState value) {
  return internal::VariableRefreshRateState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ModesetFlagsDataView {
 public:
  ModesetFlagsDataView() = default;

  ModesetFlagsDataView(
      internal::ModesetFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t bitmask() const {
    return data_->bitmask;
  }
 private:
  internal::ModesetFlags_Data* data_ = nullptr;
};


}  // display::mojom

namespace std {

template <>
struct hash<::display::mojom::DisplayConnectionType>
    : public mojo::internal::EnumHashImpl<::display::mojom::DisplayConnectionType> {};

template <>
struct hash<::display::mojom::HDCPState>
    : public mojo::internal::EnumHashImpl<::display::mojom::HDCPState> {};

template <>
struct hash<::display::mojom::ContentProtectionMethod>
    : public mojo::internal::EnumHashImpl<::display::mojom::ContentProtectionMethod> {};

template <>
struct hash<::display::mojom::PanelOrientation>
    : public mojo::internal::EnumHashImpl<::display::mojom::PanelOrientation> {};

template <>
struct hash<::display::mojom::PrivacyScreenState>
    : public mojo::internal::EnumHashImpl<::display::mojom::PrivacyScreenState> {};

template <>
struct hash<::display::mojom::VariableRefreshRateState>
    : public mojo::internal::EnumHashImpl<::display::mojom::VariableRefreshRateState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::DisplayConnectionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::DisplayConnectionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::DisplayConnectionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::HDCPState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::HDCPState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::HDCPState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::ContentProtectionMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::ContentProtectionMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::ContentProtectionMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::PanelOrientation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::PanelOrientation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::PanelOrientation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::PrivacyScreenState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::PrivacyScreenState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::PrivacyScreenState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::VariableRefreshRateState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::VariableRefreshRateState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::VariableRefreshRateState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::ModesetFlagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ModesetFlagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ModesetFlags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->bitmask = Traits::bitmask(input);
  }

  static bool Deserialize(::display::mojom::internal::ModesetFlags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::ModesetFlagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace display::mojom {




}  // display::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::DisplayConnectionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::DisplayConnectionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::HDCPState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::HDCPState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::ContentProtectionMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::ContentProtectionMethod value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::PanelOrientation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::PanelOrientation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::PrivacyScreenState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::PrivacyScreenState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::VariableRefreshRateState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::VariableRefreshRateState value);
};

} // namespace perfetto

#endif  // UI_DISPLAY_MOJOM_DISPLAY_CONSTANTS_MOJOM_SHARED_H_