// services/viz/public/mojom/compositing/animation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/animation.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"







namespace viz::mojom {
class CubicBezierTimingFunctionDataView;

class StepsTimingFunctionDataView;

class LinearEasingPointDataView;

class AxisAngleDataView;

class AnimationKeyframeDataView;

class AnimationKeyframeModelDataView;

class AnimationDataView;

class AnimationTimelineDataView;

class TimingFunctionDataView;
class TransformOperationDataView;
class AnimationKeyframeValueDataView;


}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CubicBezierTimingFunctionDataView> {
  using Data = ::viz::mojom::internal::CubicBezierTimingFunction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::StepsTimingFunctionDataView> {
  using Data = ::viz::mojom::internal::StepsTimingFunction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::LinearEasingPointDataView> {
  using Data = ::viz::mojom::internal::LinearEasingPoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AxisAngleDataView> {
  using Data = ::viz::mojom::internal::AxisAngle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeModelDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframeModel_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationDataView> {
  using Data = ::viz::mojom::internal::Animation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationTimelineDataView> {
  using Data = ::viz::mojom::internal::AnimationTimeline_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TimingFunctionDataView> {
  using Data = ::viz::mojom::internal::TimingFunction_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::viz::mojom::TransformOperationDataView> {
  using Data = ::viz::mojom::internal::TransformOperation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::viz::mojom::AnimationKeyframeValueDataView> {
  using Data = ::viz::mojom::internal::AnimationKeyframeValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class TimingStepPosition : int32_t {
  
  kStart = 0,
  
  kEnd = 1,
  
  kJumpBoth = 2,
  
  kJumpEnd = 3,
  
  kJumpNone = 4,
  
  kJumpStart = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, TimingStepPosition value);
inline bool IsKnownEnumValue(TimingStepPosition value) {
  return internal::TimingStepPosition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AnimationDirection : int32_t {
  
  kNormal = 0,
  
  kReverse = 1,
  
  kAlternateNormal = 2,
  
  kAlternateReverse = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AnimationDirection value);
inline bool IsKnownEnumValue(AnimationDirection value) {
  return internal::AnimationDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AnimationFillMode : int32_t {
  
  kNone = 0,
  
  kForwards = 1,
  
  kBackwards = 2,
  
  kBoth = 3,
  
  kAuto = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, AnimationFillMode value);
inline bool IsKnownEnumValue(AnimationFillMode value) {
  return internal::AnimationFillMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CubicBezierTimingFunctionDataView {
 public:
  CubicBezierTimingFunctionDataView() = default;

  CubicBezierTimingFunctionDataView(
      internal::CubicBezierTimingFunction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double x1() const {
    return data_->x1;
  }
  double y1() const {
    return data_->y1;
  }
  double x2() const {
    return data_->x2;
  }
  double y2() const {
    return data_->y2;
  }
 private:
  internal::CubicBezierTimingFunction_Data* data_ = nullptr;
};


class StepsTimingFunctionDataView {
 public:
  StepsTimingFunctionDataView() = default;

  StepsTimingFunctionDataView(
      internal::StepsTimingFunction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t num_steps() const {
    return data_->num_steps;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStepPosition(UserType* output) const {
    auto data_value = data_->step_position;
    return mojo::internal::Deserialize<::viz::mojom::TimingStepPosition>(
        data_value, output);
  }
  TimingStepPosition step_position() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::TimingStepPosition>(data_->step_position));
  }
 private:
  internal::StepsTimingFunction_Data* data_ = nullptr;
};


class LinearEasingPointDataView {
 public:
  LinearEasingPointDataView() = default;

  LinearEasingPointDataView(
      internal::LinearEasingPoint_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double in() const {
    return data_->in;
  }
  double out() const {
    return data_->out;
  }
 private:
  internal::LinearEasingPoint_Data* data_ = nullptr;
};


class AxisAngleDataView {
 public:
  AxisAngleDataView() = default;

  AxisAngleDataView(
      internal::AxisAngle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAxisDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxis(UserType* output) {
    
    auto* pointer = data_->axis.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, message_);
  }
  float angle() const {
    return data_->angle;
  }
 private:
  internal::AxisAngle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationKeyframeDataView {
 public:
  AnimationKeyframeDataView() = default;

  AnimationKeyframeDataView(
      internal::AnimationKeyframe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      AnimationKeyframeValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::AnimationKeyframeValueDataView>(
        pointer, output, message_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTimingFunctionDataView(
      TimingFunctionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TimingFunctionDataView, UserType>(),
    "Attempting to read the optional `timing_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimingFunction` instead "
    "of `ReadTimingFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->timing_function.is_null() ? &data_->timing_function : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TimingFunctionDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationKeyframe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationKeyframeModelDataView {
 public:
  AnimationKeyframeModelDataView() = default;

  AnimationKeyframeModelDataView(
      internal::AnimationKeyframeModel_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t group_id() const {
    return data_->group_id;
  }
  int32_t target_property_type() const {
    return data_->target_property_type;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetTimingFunctionDataView(
      TimingFunctionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimingFunction(UserType* output) {
    
    auto* pointer = !data_->timing_function.is_null() ? &data_->timing_function : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TimingFunctionDataView>(
        pointer, output, message_);
  }
  inline void GetKeyframesDataView(
      mojo::ArrayDataView<AnimationKeyframeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyframes(UserType* output) {
    
    auto* pointer = data_->keyframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeDataView>>(
        pointer, output, message_);
  }
  double scaled_duration() const {
    return data_->scaled_duration;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::viz::mojom::AnimationDirection>(
        data_value, output);
  }
  AnimationDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::AnimationDirection>(data_->direction));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillMode(UserType* output) const {
    auto data_value = data_->fill_mode;
    return mojo::internal::Deserialize<::viz::mojom::AnimationFillMode>(
        data_value, output);
  }
  AnimationFillMode fill_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::AnimationFillMode>(data_->fill_mode));
  }
  double playback_rate() const {
    return data_->playback_rate;
  }
  double iterations() const {
    return data_->iterations;
  }
  double iteration_start() const {
    return data_->iteration_start;
  }
  inline void GetTimeOffsetDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeOffset(UserType* output) {
    
    auto* pointer = data_->time_offset.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationKeyframeModel_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationDataView {
 public:
  AnimationDataView() = default;

  AnimationDataView(
      internal::Animation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetElementIdDataView(
      ::cc::mojom::ElementIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::ElementIdDataView, UserType>(),
    "Attempting to read the optional `element_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadElementId` instead "
    "of `ReadElementId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->element_id.Get();
    return mojo::internal::Deserialize<::cc::mojom::ElementIdDataView>(
        pointer, output, message_);
  }
  inline void GetKeyframeModelsDataView(
      mojo::ArrayDataView<AnimationKeyframeModelDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyframeModels(UserType* output) {
    
    auto* pointer = data_->keyframe_models.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeModelDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Animation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnimationTimelineDataView {
 public:
  AnimationTimelineDataView() = default;

  AnimationTimelineDataView(
      internal::AnimationTimeline_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetNewAnimationsDataView(
      mojo::ArrayDataView<AnimationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewAnimations(UserType* output) {
    
    auto* pointer = data_->new_animations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationDataView>>(
        pointer, output, message_);
  }
  inline void GetRemovedAnimationsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedAnimations(UserType* output) {
    
    auto* pointer = data_->removed_animations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::AnimationTimeline_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TimingFunctionDataView {
 public:
  using Tag = internal::TimingFunction_Data::TimingFunction_Tag;

  TimingFunctionDataView() = default;

  TimingFunctionDataView(
      internal::TimingFunction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_cubic_bezier() const { return data_->tag == Tag::kCubicBezier; }
  inline void GetCubicBezierDataView(
      CubicBezierTimingFunctionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCubicBezier(UserType* output) const {
    
    CHECK(is_cubic_bezier());
    return mojo::internal::Deserialize<::viz::mojom::CubicBezierTimingFunctionDataView>(
        data_->data.f_cubic_bezier.Get(), output, message_);
  }
  bool is_steps() const { return data_->tag == Tag::kSteps; }
  inline void GetStepsDataView(
      StepsTimingFunctionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSteps(UserType* output) const {
    
    CHECK(is_steps());
    return mojo::internal::Deserialize<::viz::mojom::StepsTimingFunctionDataView>(
        data_->data.f_steps.Get(), output, message_);
  }
  bool is_linear() const { return data_->tag == Tag::kLinear; }
  inline void GetLinearDataView(
      mojo::ArrayDataView<LinearEasingPointDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLinear(UserType* output) const {
    
    CHECK(is_linear());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::LinearEasingPointDataView>>(
        data_->data.f_linear.Get(), output, message_);
  }

 private:
  internal::TimingFunction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TransformOperationDataView {
 public:
  using Tag = internal::TransformOperation_Data::TransformOperation_Tag;

  TransformOperationDataView() = default;

  TransformOperationDataView(
      internal::TransformOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_identity() const { return data_->tag == Tag::kIdentity; }
  bool identity() const {
    CHECK(is_identity());
    return data_->data.f_identity;
  }
  bool is_perspective_depth() const { return data_->tag == Tag::kPerspectiveDepth; }
  float perspective_depth() const {
    CHECK(is_perspective_depth());
    return data_->data.f_perspective_depth;
  }
  bool is_skew() const { return data_->tag == Tag::kSkew; }
  inline void GetSkewDataView(
      ::gfx::mojom::Vector2dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSkew(UserType* output) const {
    
    CHECK(is_skew());
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        data_->data.f_skew.Get(), output, message_);
  }
  bool is_scale() const { return data_->tag == Tag::kScale; }
  inline void GetScaleDataView(
      ::gfx::mojom::Vector3dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScale(UserType* output) const {
    
    CHECK(is_scale());
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        data_->data.f_scale.Get(), output, message_);
  }
  bool is_translate() const { return data_->tag == Tag::kTranslate; }
  inline void GetTranslateDataView(
      ::gfx::mojom::Vector3dFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTranslate(UserType* output) const {
    
    CHECK(is_translate());
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        data_->data.f_translate.Get(), output, message_);
  }
  bool is_rotate() const { return data_->tag == Tag::kRotate; }
  inline void GetRotateDataView(
      AxisAngleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRotate(UserType* output) const {
    
    CHECK(is_rotate());
    return mojo::internal::Deserialize<::viz::mojom::AxisAngleDataView>(
        data_->data.f_rotate.Get(), output, message_);
  }
  bool is_matrix() const { return data_->tag == Tag::kMatrix; }
  inline void GetMatrixDataView(
      ::gfx::mojom::TransformDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) const {
    
    CHECK(is_matrix());
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        data_->data.f_matrix.Get(), output, message_);
  }

 private:
  internal::TransformOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AnimationKeyframeValueDataView {
 public:
  using Tag = internal::AnimationKeyframeValue_Data::AnimationKeyframeValue_Tag;

  AnimationKeyframeValueDataView() = default;

  AnimationKeyframeValueDataView(
      internal::AnimationKeyframeValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_scalar() const { return data_->tag == Tag::kScalar; }
  float scalar() const {
    CHECK(is_scalar());
    return data_->data.f_scalar;
  }
  bool is_color() const { return data_->tag == Tag::kColor; }
  inline void GetColorDataView(
      ::skia::mojom::SkColorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    
    CHECK(is_color());
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        data_->data.f_color.Get(), output, message_);
  }
  bool is_size() const { return data_->tag == Tag::kSize; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeFDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) const {
    
    CHECK(is_size());
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        data_->data.f_size.Get(), output, message_);
  }
  bool is_rect() const { return data_->tag == Tag::kRect; }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) const {
    
    CHECK(is_rect());
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        data_->data.f_rect.Get(), output, message_);
  }
  bool is_transform() const { return data_->tag == Tag::kTransform; }
  inline void GetTransformDataView(
      mojo::ArrayDataView<TransformOperationDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) const {
    
    CHECK(is_transform());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransformOperationDataView>>(
        data_->data.f_transform.Get(), output, message_);
  }

 private:
  internal::AnimationKeyframeValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::TimingStepPosition>
    : public mojo::internal::EnumHashImpl<::viz::mojom::TimingStepPosition> {};

template <>
struct hash<::viz::mojom::AnimationDirection>
    : public mojo::internal::EnumHashImpl<::viz::mojom::AnimationDirection> {};

template <>
struct hash<::viz::mojom::AnimationFillMode>
    : public mojo::internal::EnumHashImpl<::viz::mojom::AnimationFillMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TimingStepPosition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::TimingStepPosition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::TimingStepPosition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::AnimationDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::AnimationDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationFillMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::AnimationFillMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::AnimationFillMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CubicBezierTimingFunctionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CubicBezierTimingFunctionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CubicBezierTimingFunction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->x1 = Traits::x1(input);
    fragment->y1 = Traits::y1(input);
    fragment->x2 = Traits::x2(input);
    fragment->y2 = Traits::y2(input);
  }

  static bool Deserialize(::viz::mojom::internal::CubicBezierTimingFunction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CubicBezierTimingFunctionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::StepsTimingFunctionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::StepsTimingFunctionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::StepsTimingFunction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->num_steps = Traits::num_steps(input);
    mojo::internal::Serialize<::viz::mojom::TimingStepPosition>(
        Traits::step_position(input), &fragment->step_position);
  }

  static bool Deserialize(::viz::mojom::internal::StepsTimingFunction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::StepsTimingFunctionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::LinearEasingPointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LinearEasingPointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::LinearEasingPoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->in = Traits::in(input);
    fragment->out = Traits::out(input);
  }

  static bool Deserialize(::viz::mojom::internal::LinearEasingPoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::LinearEasingPointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AxisAngleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AxisAngleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AxisAngle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::axis(input)) in_axis = Traits::axis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axis)::BaseType> axis_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
        in_axis, axis_fragment);
    fragment->axis.Set(
        axis_fragment.is_null() ? nullptr : axis_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->axis.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null axis in AxisAngle struct");
    fragment->angle = Traits::angle(input);
  }

  static bool Deserialize(::viz::mojom::internal::AxisAngle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AxisAngleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationKeyframeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationKeyframeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationKeyframe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    mojo::internal::Serialize<::viz::mojom::AnimationKeyframeValueDataView>(
        in_value, value_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AnimationKeyframe struct");
    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_time)::BaseType> start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_start_time, start_time_fragment);
    fragment->start_time.Set(
        start_time_fragment.is_null() ? nullptr : start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in AnimationKeyframe struct");
    decltype(Traits::timing_function(input)) in_timing_function = Traits::timing_function(input);
    mojo::internal::MessageFragment<decltype(fragment->timing_function)>
        timing_function_fragment(fragment.message());
    timing_function_fragment.Claim(&fragment->timing_function);
    mojo::internal::Serialize<::viz::mojom::TimingFunctionDataView>(
        in_timing_function, timing_function_fragment, true);
  }

  static bool Deserialize(::viz::mojom::internal::AnimationKeyframe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnimationKeyframeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationKeyframeModelDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationKeyframeModelDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationKeyframeModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->group_id = Traits::group_id(input);
    fragment->target_property_type = Traits::target_property_type(input);
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    decltype(Traits::timing_function(input)) in_timing_function = Traits::timing_function(input);
    mojo::internal::MessageFragment<decltype(fragment->timing_function)>
        timing_function_fragment(fragment.message());
    timing_function_fragment.Claim(&fragment->timing_function);
    mojo::internal::Serialize<::viz::mojom::TimingFunctionDataView>(
        in_timing_function, timing_function_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timing_function.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timing_function in AnimationKeyframeModel struct");
    decltype(Traits::keyframes(input)) in_keyframes = Traits::keyframes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyframes)::BaseType>
        keyframes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& keyframes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeDataView>>(
        in_keyframes, keyframes_fragment, &keyframes_validate_params);
    fragment->keyframes.Set(
        keyframes_fragment.is_null() ? nullptr : keyframes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->keyframes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyframes in AnimationKeyframeModel struct");
    fragment->scaled_duration = Traits::scaled_duration(input);
    mojo::internal::Serialize<::viz::mojom::AnimationDirection>(
        Traits::direction(input), &fragment->direction);
    mojo::internal::Serialize<::viz::mojom::AnimationFillMode>(
        Traits::fill_mode(input), &fragment->fill_mode);
    fragment->playback_rate = Traits::playback_rate(input);
    fragment->iterations = Traits::iterations(input);
    fragment->iteration_start = Traits::iteration_start(input);
    decltype(Traits::time_offset(input)) in_time_offset = Traits::time_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_offset)::BaseType> time_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_time_offset, time_offset_fragment);
    fragment->time_offset.Set(
        time_offset_fragment.is_null() ? nullptr : time_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->time_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_offset in AnimationKeyframeModel struct");
  }

  static bool Deserialize(::viz::mojom::internal::AnimationKeyframeModel_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnimationKeyframeModelDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Animation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_id)::BaseType> element_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::ElementIdDataView>(
        in_element_id, element_id_fragment);
    fragment->element_id.Set(
        element_id_fragment.is_null() ? nullptr : element_id_fragment.data());
    decltype(Traits::keyframe_models(input)) in_keyframe_models = Traits::keyframe_models(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyframe_models)::BaseType>
        keyframe_models_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& keyframe_models_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeModelDataView>>(
        in_keyframe_models, keyframe_models_fragment, &keyframe_models_validate_params);
    fragment->keyframe_models.Set(
        keyframe_models_fragment.is_null() ? nullptr : keyframe_models_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->keyframe_models.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyframe_models in Animation struct");
  }

  static bool Deserialize(::viz::mojom::internal::Animation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnimationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationTimelineDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationTimelineDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationTimeline_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::new_animations(input)) in_new_animations = Traits::new_animations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_animations)::BaseType>
        new_animations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& new_animations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationDataView>>(
        in_new_animations, new_animations_fragment, &new_animations_validate_params);
    fragment->new_animations.Set(
        new_animations_fragment.is_null() ? nullptr : new_animations_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_animations.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_animations in AnimationTimeline struct");
    decltype(Traits::removed_animations(input)) in_removed_animations = Traits::removed_animations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->removed_animations)::BaseType>
        removed_animations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& removed_animations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_removed_animations, removed_animations_fragment, &removed_animations_validate_params);
    fragment->removed_animations.Set(
        removed_animations_fragment.is_null() ? nullptr : removed_animations_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->removed_animations.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null removed_animations in AnimationTimeline struct");
  }

  static bool Deserialize(::viz::mojom::internal::AnimationTimeline_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnimationTimelineDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TimingFunctionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TimingFunctionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TimingFunction_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::viz::mojom::TimingFunctionDataView::Tag::kCubicBezier: {
        decltype(Traits::cubic_bezier(input))
            in_cubic_bezier = Traits::cubic_bezier(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_cubic_bezier)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::viz::mojom::CubicBezierTimingFunctionDataView>(
            in_cubic_bezier, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null cubic_bezier in TimingFunction union");
        fragment->data.f_cubic_bezier.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TimingFunctionDataView::Tag::kSteps: {
        decltype(Traits::steps(input))
            in_steps = Traits::steps(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_steps)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::viz::mojom::StepsTimingFunctionDataView>(
            in_steps, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null steps in TimingFunction union");
        fragment->data.f_steps.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TimingFunctionDataView::Tag::kLinear: {
        decltype(Traits::linear(input))
            in_linear = Traits::linear(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_linear)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& linear_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::LinearEasingPointDataView>>(
            in_linear, value_fragment, &linear_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null linear in TimingFunction union");
        fragment->data.f_linear.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::viz::mojom::internal::TimingFunction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TimingFunctionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransformOperationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TransformOperationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TransformOperation_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::viz::mojom::TransformOperationDataView::Tag::kIdentity: {
        decltype(Traits::identity(input))
            in_identity = Traits::identity(input);
        fragment->data.f_identity = in_identity;
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kPerspectiveDepth: {
        decltype(Traits::perspective_depth(input))
            in_perspective_depth = Traits::perspective_depth(input);
        fragment->data.f_perspective_depth = in_perspective_depth;
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kSkew: {
        decltype(Traits::skew(input))
            in_skew = Traits::skew(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_skew)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
            in_skew, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null skew in TransformOperation union");
        fragment->data.f_skew.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kScale: {
        decltype(Traits::scale(input))
            in_scale = Traits::scale(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_scale)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
            in_scale, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null scale in TransformOperation union");
        fragment->data.f_scale.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kTranslate: {
        decltype(Traits::translate(input))
            in_translate = Traits::translate(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_translate)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
            in_translate, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null translate in TransformOperation union");
        fragment->data.f_translate.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kRotate: {
        decltype(Traits::rotate(input))
            in_rotate = Traits::rotate(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_rotate)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::viz::mojom::AxisAngleDataView>(
            in_rotate, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null rotate in TransformOperation union");
        fragment->data.f_rotate.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TransformOperationDataView::Tag::kMatrix: {
        decltype(Traits::matrix(input))
            in_matrix = Traits::matrix(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_matrix)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
            in_matrix, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null matrix in TransformOperation union");
        fragment->data.f_matrix.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::viz::mojom::internal::TransformOperation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TransformOperationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::AnimationKeyframeValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::AnimationKeyframeValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::AnimationKeyframeValue_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kScalar: {
        decltype(Traits::scalar(input))
            in_scalar = Traits::scalar(input);
        fragment->data.f_scalar = in_scalar;
        break;
      }
      case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kColor: {
        decltype(Traits::color(input))
            in_color = Traits::color(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_color)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
            in_color, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null color in AnimationKeyframeValue union");
        fragment->data.f_color.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kSize: {
        decltype(Traits::size(input))
            in_size = Traits::size(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_size)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
            in_size, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null size in AnimationKeyframeValue union");
        fragment->data.f_size.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kRect: {
        decltype(Traits::rect(input))
            in_rect = Traits::rect(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_rect)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::RectDataView>(
            in_rect, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null rect in AnimationKeyframeValue union");
        fragment->data.f_rect.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kTransform: {
        decltype(Traits::transform(input))
            in_transform = Traits::transform(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transform)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& transform_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TransformOperationDataView>>(
            in_transform, value_fragment, &transform_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transform in AnimationKeyframeValue union");
        fragment->data.f_transform.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::viz::mojom::internal::AnimationKeyframeValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::AnimationKeyframeValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {







inline void AxisAngleDataView::GetAxisDataView(
    ::gfx::mojom::Vector3dFDataView* output) {
  auto pointer = data_->axis.Get();
  *output = ::gfx::mojom::Vector3dFDataView(pointer, message_);
}


inline void AnimationKeyframeDataView::GetValueDataView(
    AnimationKeyframeValueDataView* output) {
  auto pointer = &data_->value;
  *output = AnimationKeyframeValueDataView(pointer, message_);
}
inline void AnimationKeyframeDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void AnimationKeyframeDataView::GetTimingFunctionDataView(
    TimingFunctionDataView* output) {
  auto pointer = &data_->timing_function;
  *output = TimingFunctionDataView(pointer, message_);
}


inline void AnimationKeyframeModelDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}
inline void AnimationKeyframeModelDataView::GetTimingFunctionDataView(
    TimingFunctionDataView* output) {
  auto pointer = &data_->timing_function;
  *output = TimingFunctionDataView(pointer, message_);
}
inline void AnimationKeyframeModelDataView::GetKeyframesDataView(
    mojo::ArrayDataView<AnimationKeyframeDataView>* output) {
  auto pointer = data_->keyframes.Get();
  *output = mojo::ArrayDataView<AnimationKeyframeDataView>(pointer, message_);
}
inline void AnimationKeyframeModelDataView::GetTimeOffsetDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_offset.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void AnimationDataView::GetElementIdDataView(
    ::cc::mojom::ElementIdDataView* output) {
  auto pointer = data_->element_id.Get();
  *output = ::cc::mojom::ElementIdDataView(pointer, message_);
}
inline void AnimationDataView::GetKeyframeModelsDataView(
    mojo::ArrayDataView<AnimationKeyframeModelDataView>* output) {
  auto pointer = data_->keyframe_models.Get();
  *output = mojo::ArrayDataView<AnimationKeyframeModelDataView>(pointer, message_);
}


inline void AnimationTimelineDataView::GetNewAnimationsDataView(
    mojo::ArrayDataView<AnimationDataView>* output) {
  auto pointer = data_->new_animations.Get();
  *output = mojo::ArrayDataView<AnimationDataView>(pointer, message_);
}
inline void AnimationTimelineDataView::GetRemovedAnimationsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->removed_animations.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}


inline void TimingFunctionDataView::GetCubicBezierDataView(
    CubicBezierTimingFunctionDataView* output) const {
  CHECK(is_cubic_bezier());
  *output = CubicBezierTimingFunctionDataView(data_->data.f_cubic_bezier.Get(), message_);
}
inline void TimingFunctionDataView::GetStepsDataView(
    StepsTimingFunctionDataView* output) const {
  CHECK(is_steps());
  *output = StepsTimingFunctionDataView(data_->data.f_steps.Get(), message_);
}
inline void TimingFunctionDataView::GetLinearDataView(
    mojo::ArrayDataView<LinearEasingPointDataView>* output) const {
  CHECK(is_linear());
  *output = mojo::ArrayDataView<LinearEasingPointDataView>(data_->data.f_linear.Get(), message_);
}

inline void TransformOperationDataView::GetSkewDataView(
    ::gfx::mojom::Vector2dFDataView* output) const {
  CHECK(is_skew());
  *output = ::gfx::mojom::Vector2dFDataView(data_->data.f_skew.Get(), message_);
}
inline void TransformOperationDataView::GetScaleDataView(
    ::gfx::mojom::Vector3dFDataView* output) const {
  CHECK(is_scale());
  *output = ::gfx::mojom::Vector3dFDataView(data_->data.f_scale.Get(), message_);
}
inline void TransformOperationDataView::GetTranslateDataView(
    ::gfx::mojom::Vector3dFDataView* output) const {
  CHECK(is_translate());
  *output = ::gfx::mojom::Vector3dFDataView(data_->data.f_translate.Get(), message_);
}
inline void TransformOperationDataView::GetRotateDataView(
    AxisAngleDataView* output) const {
  CHECK(is_rotate());
  *output = AxisAngleDataView(data_->data.f_rotate.Get(), message_);
}
inline void TransformOperationDataView::GetMatrixDataView(
    ::gfx::mojom::TransformDataView* output) const {
  CHECK(is_matrix());
  *output = ::gfx::mojom::TransformDataView(data_->data.f_matrix.Get(), message_);
}

inline void AnimationKeyframeValueDataView::GetColorDataView(
    ::skia::mojom::SkColorDataView* output) const {
  CHECK(is_color());
  *output = ::skia::mojom::SkColorDataView(data_->data.f_color.Get(), message_);
}
inline void AnimationKeyframeValueDataView::GetSizeDataView(
    ::gfx::mojom::SizeFDataView* output) const {
  CHECK(is_size());
  *output = ::gfx::mojom::SizeFDataView(data_->data.f_size.Get(), message_);
}
inline void AnimationKeyframeValueDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) const {
  CHECK(is_rect());
  *output = ::gfx::mojom::RectDataView(data_->data.f_rect.Get(), message_);
}
inline void AnimationKeyframeValueDataView::GetTransformDataView(
    mojo::ArrayDataView<TransformOperationDataView>* output) const {
  CHECK(is_transform());
  *output = mojo::ArrayDataView<TransformOperationDataView>(data_->data.f_transform.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::TimingStepPosition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::TimingStepPosition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::AnimationDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::AnimationDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::AnimationFillMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::AnimationFillMode value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_H_