// services/network/public/mojom/socket_broker.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  SocketBroker_CreateTcpSocket_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t address_family;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SocketBroker_CreateTcpSocket_Params_Data>;

  SocketBroker_CreateTcpSocket_Params_Data();
  ~SocketBroker_CreateTcpSocket_Params_Data() = delete;
};
static_assert(sizeof(SocketBroker_CreateTcpSocket_Params_Data) == 16,
              "Bad sizeof(SocketBroker_CreateTcpSocket_Params_Data)");
class  SocketBroker_CreateTcpSocket_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::TransferableSocket_Data> created_socket;
  int32_t rv;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SocketBroker_CreateTcpSocket_ResponseParams_Data>;

  SocketBroker_CreateTcpSocket_ResponseParams_Data();
  ~SocketBroker_CreateTcpSocket_ResponseParams_Data() = delete;
};
static_assert(sizeof(SocketBroker_CreateTcpSocket_ResponseParams_Data) == 24,
              "Bad sizeof(SocketBroker_CreateTcpSocket_ResponseParams_Data)");
class  SocketBroker_CreateUdpSocket_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t address_family;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SocketBroker_CreateUdpSocket_Params_Data>;

  SocketBroker_CreateUdpSocket_Params_Data();
  ~SocketBroker_CreateUdpSocket_Params_Data() = delete;
};
static_assert(sizeof(SocketBroker_CreateUdpSocket_Params_Data) == 16,
              "Bad sizeof(SocketBroker_CreateUdpSocket_Params_Data)");
class  SocketBroker_CreateUdpSocket_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::TransferableSocket_Data> created_socket;
  int32_t rv;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SocketBroker_CreateUdpSocket_ResponseParams_Data>;

  SocketBroker_CreateUdpSocket_ResponseParams_Data();
  ~SocketBroker_CreateUdpSocket_ResponseParams_Data() = delete;
};
static_assert(sizeof(SocketBroker_CreateUdpSocket_ResponseParams_Data) == 24,
              "Bad sizeof(SocketBroker_CreateUdpSocket_ResponseParams_Data)");

}  // namespace internal


class SocketBroker_CreateTcpSocket_ParamsDataView {
 public:
  SocketBroker_CreateTcpSocket_ParamsDataView() = default;

  SocketBroker_CreateTcpSocket_ParamsDataView(
      internal::SocketBroker_CreateTcpSocket_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAddressFamily(UserType* output) const {
    auto data_value = data_->address_family;
    return mojo::internal::Deserialize<::network::mojom::AddressFamily>(
        data_value, output);
  }
  ::network::mojom::AddressFamily address_family() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AddressFamily>(data_->address_family));
  }
 private:
  internal::SocketBroker_CreateTcpSocket_Params_Data* data_ = nullptr;
};


class SocketBroker_CreateTcpSocket_ResponseParamsDataView {
 public:
  SocketBroker_CreateTcpSocket_ResponseParamsDataView() = default;

  SocketBroker_CreateTcpSocket_ResponseParamsDataView(
      internal::SocketBroker_CreateTcpSocket_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCreatedSocketDataView(
      ::network::mojom::TransferableSocketDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreatedSocket(UserType* output) {
    
    auto* pointer = data_->created_socket.Get();
    return mojo::internal::Deserialize<::network::mojom::TransferableSocketDataView>(
        pointer, output, message_);
  }
  int32_t rv() const {
    return data_->rv;
  }
 private:
  internal::SocketBroker_CreateTcpSocket_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SocketBroker_CreateUdpSocket_ParamsDataView {
 public:
  SocketBroker_CreateUdpSocket_ParamsDataView() = default;

  SocketBroker_CreateUdpSocket_ParamsDataView(
      internal::SocketBroker_CreateUdpSocket_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAddressFamily(UserType* output) const {
    auto data_value = data_->address_family;
    return mojo::internal::Deserialize<::network::mojom::AddressFamily>(
        data_value, output);
  }
  ::network::mojom::AddressFamily address_family() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AddressFamily>(data_->address_family));
  }
 private:
  internal::SocketBroker_CreateUdpSocket_Params_Data* data_ = nullptr;
};


class SocketBroker_CreateUdpSocket_ResponseParamsDataView {
 public:
  SocketBroker_CreateUdpSocket_ResponseParamsDataView() = default;

  SocketBroker_CreateUdpSocket_ResponseParamsDataView(
      internal::SocketBroker_CreateUdpSocket_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCreatedSocketDataView(
      ::network::mojom::TransferableSocketDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreatedSocket(UserType* output) {
    
    auto* pointer = data_->created_socket.Get();
    return mojo::internal::Deserialize<::network::mojom::TransferableSocketDataView>(
        pointer, output, message_);
  }
  int32_t rv() const {
    return data_->rv;
  }
 private:
  internal::SocketBroker_CreateUdpSocket_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void SocketBroker_CreateTcpSocket_ResponseParamsDataView::GetCreatedSocketDataView(
    ::network::mojom::TransferableSocketDataView* output) {
  auto pointer = data_->created_socket.Get();
  *output = ::network::mojom::TransferableSocketDataView(pointer, message_);
}




inline void SocketBroker_CreateUdpSocket_ResponseParamsDataView::GetCreatedSocketDataView(
    ::network::mojom::TransferableSocketDataView* output) {
  auto pointer = data_->created_socket.Get();
  *output = ::network::mojom::TransferableSocketDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SOCKET_BROKER_MOJOM_PARAMS_DATA_H_