// mojo/public/mojom/base/file.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace mojo_base::mojom {
class FileDataView;

class ReadOnlyFileDataView;



}  // mojo_base::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::FileDataView> {
  using Data = ::mojo_base::mojom::internal::File_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo_base::mojom::ReadOnlyFileDataView> {
  using Data = ::mojo_base::mojom::internal::ReadOnlyFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class FileDataView {
 public:
  FileDataView() = default;

  FileDataView(
      internal::File_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeFd() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->fd, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool async() const {
    return data_->async;
  }
 private:
  internal::File_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadOnlyFileDataView {
 public:
  ReadOnlyFileDataView() = default;

  ReadOnlyFileDataView(
      internal::ReadOnlyFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeFd() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->fd, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool async() const {
    return data_->async;
  }
 private:
  internal::ReadOnlyFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::FileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::FileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::File_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::fd(input)) in_fd = Traits::fd(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_fd, &fragment->fd, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->fd),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid fd in File struct");
    fragment->async = Traits::async(input);
  }

  static bool Deserialize(::mojo_base::mojom::internal::File_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::FileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::ReadOnlyFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::ReadOnlyFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::ReadOnlyFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::fd(input)) in_fd = Traits::fd(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_fd, &fragment->fd, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->fd),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid fd in ReadOnlyFile struct");
    fragment->async = Traits::async(input);
  }

  static bool Deserialize(::mojo_base::mojom::internal::ReadOnlyFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::ReadOnlyFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {






}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_SHARED_H_