// extensions/common/mojom/renderer_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_HOST_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/renderer_host.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/renderer_host.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/renderer_host.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class RendererHostProxy;

template <typename ImplRefTraits>
class RendererHostStub;

class RendererHostRequestValidator;
class RendererHostResponseValidator;


class RendererHost
    : public RendererHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    34933835
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererHostInterfaceBase;
  using Proxy_ = RendererHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererHostStub<ImplRefTraits>;

  using RequestValidator_ = RendererHostRequestValidator;
  using ResponseValidator_ = RendererHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddAPIActionToActivityLogMinVersion = 0,
    kAddEventToActivityLogMinVersion = 0,
    kAddDOMActionToActivityLogMinVersion = 0,
    kGetMessageBundleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddAPIActionToActivityLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddEventToActivityLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddDOMActionToActivityLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMessageBundle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererHost() = default;

  
  virtual void AddAPIActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) = 0;

  
  virtual void AddEventToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) = 0;

  
  virtual void AddDOMActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const ::GURL& url, const ::std::u16string& url_title, int32_t call_type) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetMessageBundle(const std::string& extension_id, base::flat_map<std::string, std::string>* out_message_map);

  using GetMessageBundleCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;
  
  virtual void GetMessageBundle(const std::string& extension_id, GetMessageBundleCallback callback) = 0;
};



class  RendererHostProxy
    : public RendererHost {
 public:
  using InterfaceType = RendererHost;

  explicit RendererHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddAPIActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) final;
  
  void AddEventToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) final;
  
  void AddDOMActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const ::GURL& url, const ::std::u16string& url_title, int32_t call_type) final;
  
  bool GetMessageBundle(const std::string& extension_id, base::flat_map<std::string, std::string>* out_message_map) final;
  
  void GetMessageBundle(const std::string& extension_id, GetMessageBundleCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererHostStubDispatch {
 public:
  static bool Accept(RendererHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererHost>>
class RendererHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererHostStub() = default;
  ~RendererHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_HOST_MOJOM_H_