// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace auction_worklet::mojom {
class BrowserSignalsDataView;

class AuctionWorkletPermissionsPolicyStateDataView;

class TrustedSignalsPublicKeyDataView;



}  // auction_worklet::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BrowserSignalsDataView> {
  using Data = ::auction_worklet::mojom::internal::BrowserSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView> {
  using Data = ::auction_worklet::mojom::internal::AuctionWorkletPermissionsPolicyState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView> {
  using Data = ::auction_worklet::mojom::internal::TrustedSignalsPublicKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {
// Interface base classes. They are used for type safety check.
class LoadSellerWorkletClientInterfaceBase {};

using LoadSellerWorkletClientPtrDataView =
    mojo::InterfacePtrDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientRequestDataView =
    mojo::InterfaceRequestDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LoadSellerWorkletClientInterfaceBase>;
using LoadSellerWorkletClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LoadSellerWorkletClientInterfaceBase>;
class AuctionWorkletServiceInterfaceBase {};

using AuctionWorkletServicePtrDataView =
    mojo::InterfacePtrDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceRequestDataView =
    mojo::InterfaceRequestDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AuctionWorkletServiceInterfaceBase>;
using AuctionWorkletServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AuctionWorkletServiceInterfaceBase>;


class BrowserSignalsDataView {
 public:
  BrowserSignalsDataView() = default;

  BrowserSignalsDataView(
      internal::BrowserSignals_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetSellerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeller(UserType* output) {
    
    auto* pointer = data_->seller.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::BrowserSignals_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuctionWorkletPermissionsPolicyStateDataView {
 public:
  AuctionWorkletPermissionsPolicyStateDataView() = default;

  AuctionWorkletPermissionsPolicyStateDataView(
      internal::AuctionWorkletPermissionsPolicyState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool private_aggregation_allowed() const {
    return data_->private_aggregation_allowed;
  }
  bool shared_storage_allowed() const {
    return data_->shared_storage_allowed;
  }
 private:
  internal::AuctionWorkletPermissionsPolicyState_Data* data_ = nullptr;
};


class TrustedSignalsPublicKeyDataView {
 public:
  TrustedSignalsPublicKeyDataView() = default;

  TrustedSignalsPublicKeyDataView(
      internal::TrustedSignalsPublicKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint8_t id() const {
    return data_->id;
  }
 private:
  internal::TrustedSignalsPublicKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // auction_worklet::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BrowserSignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BrowserSignalsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BrowserSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_top_frame_origin, top_frame_origin_fragment);
    fragment->top_frame_origin.Set(
        top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_frame_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_origin in BrowserSignals struct");
    decltype(Traits::seller(input)) in_seller = Traits::seller(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seller)::BaseType> seller_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_seller, seller_fragment);
    fragment->seller.Set(
        seller_fragment.is_null() ? nullptr : seller_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->seller.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seller in BrowserSignals struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BrowserSignals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BrowserSignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::AuctionWorkletPermissionsPolicyState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->private_aggregation_allowed = Traits::private_aggregation_allowed(input);
    fragment->shared_storage_allowed = Traits::shared_storage_allowed(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::AuctionWorkletPermissionsPolicyState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::TrustedSignalsPublicKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::TrustedSignalsPublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in TrustedSignalsPublicKey struct");
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::TrustedSignalsPublicKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::TrustedSignalsPublicKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void BrowserSignalsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void BrowserSignalsDataView::GetSellerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->seller.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void TrustedSignalsPublicKeyDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_SHARED_H_