// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package devices

import (
	"sync"
)

// Ensure, that DevicesMock does implement Devices.
// If this is not the case, regenerate this file with moq.
var _ Devices = &DevicesMock{}

// DevicesMock is a mock implementation of Devices.
//
//	func TestSomethingThatUsesDevices(t *testing.T) {
//
//		// make and configure a mocked Devices
//		mockedDevices := &DevicesMock{
//			CountFunc: func() int {
//				panic("mock out the Count method")
//			},
//			ExistsFunc: func(name Name) bool {
//				panic("mock out the Exists method")
//			},
//			GetFunc: func(name Name) (Major, bool) {
//				panic("mock out the Get method")
//			},
//		}
//
//		// use mockedDevices in code that requires Devices
//		// and then make assertions.
//
//	}
type DevicesMock struct {
	// CountFunc mocks the Count method.
	CountFunc func() int

	// ExistsFunc mocks the Exists method.
	ExistsFunc func(name Name) bool

	// GetFunc mocks the Get method.
	GetFunc func(name Name) (Major, bool)

	// calls tracks calls to the methods.
	calls struct {
		// Count holds details about calls to the Count method.
		Count []struct {
		}
		// Exists holds details about calls to the Exists method.
		Exists []struct {
			// Name is the name argument value.
			Name Name
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name Name
		}
	}
	lockCount  sync.RWMutex
	lockExists sync.RWMutex
	lockGet    sync.RWMutex
}

// Count calls CountFunc.
func (mock *DevicesMock) Count() int {
	callInfo := struct {
	}{}
	mock.lockCount.Lock()
	mock.calls.Count = append(mock.calls.Count, callInfo)
	mock.lockCount.Unlock()
	if mock.CountFunc == nil {
		var (
			nOut int
		)
		return nOut
	}
	return mock.CountFunc()
}

// CountCalls gets all the calls that were made to Count.
// Check the length with:
//
//	len(mockedDevices.CountCalls())
func (mock *DevicesMock) CountCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockCount.RLock()
	calls = mock.calls.Count
	mock.lockCount.RUnlock()
	return calls
}

// Exists calls ExistsFunc.
func (mock *DevicesMock) Exists(name Name) bool {
	callInfo := struct {
		Name Name
	}{
		Name: name,
	}
	mock.lockExists.Lock()
	mock.calls.Exists = append(mock.calls.Exists, callInfo)
	mock.lockExists.Unlock()
	if mock.ExistsFunc == nil {
		var (
			bOut bool
		)
		return bOut
	}
	return mock.ExistsFunc(name)
}

// ExistsCalls gets all the calls that were made to Exists.
// Check the length with:
//
//	len(mockedDevices.ExistsCalls())
func (mock *DevicesMock) ExistsCalls() []struct {
	Name Name
} {
	var calls []struct {
		Name Name
	}
	mock.lockExists.RLock()
	calls = mock.calls.Exists
	mock.lockExists.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DevicesMock) Get(name Name) (Major, bool) {
	callInfo := struct {
		Name Name
	}{
		Name: name,
	}
	mock.lockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	mock.lockGet.Unlock()
	if mock.GetFunc == nil {
		var (
			majorOut Major
			bOut     bool
		)
		return majorOut, bOut
	}
	return mock.GetFunc(name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//
//	len(mockedDevices.GetCalls())
func (mock *DevicesMock) GetCalls() []struct {
	Name Name
} {
	var calls []struct {
		Name Name
	}
	mock.lockGet.RLock()
	calls = mock.calls.Get
	mock.lockGet.RUnlock()
	return calls
}
