/* automatically generated by rust-bindgen 0.72.1 */

pub enum GrContext_Base {}
pub enum GrImageContext {}
pub enum GrImageContextPriv {}
pub enum GrContextThreadSafeProxy {}
pub enum GrContextThreadSafeProxyPriv {}
pub enum GrRecordingContextPriv {}
pub enum GrContextPriv {}
pub enum SkVerticesPriv {}
pub enum SkUnicode {}

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val { byte | mask } else { byte & !mask }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[doc = r" If Bindgen could only determine the size and alignment of a"]
#[doc = r" type, it is represented like this."]
#[derive(PartialEq, Copy, Clone, Debug, Hash)]
#[repr(C)]
pub struct __BindgenOpaqueArray<T: Copy, const N: usize>(pub [T; N]);
impl<T: Copy + Default, const N: usize> Default for __BindgenOpaqueArray<T, N> {
    fn default() -> Self {
        Self([<T as Default>::default(); N])
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_basic_string {
    pub _address: u8,
}
pub type std_basic_string__Char_alloc_type = u8;
pub type std_basic_string__Alloc_traits = u8;
pub type std_basic_string_traits_type = u8;
pub type std_basic_string_value_type = u8;
pub type std_basic_string_allocator_type = u8;
pub type std_basic_string_size_type = u8;
pub type std_basic_string_difference_type = u8;
pub type std_basic_string_reference = u8;
pub type std_basic_string_const_reference = u8;
pub type std_basic_string_pointer = u8;
pub type std_basic_string_const_pointer = u8;
pub type std_basic_string_iterator = u8;
pub type std_basic_string_const_iterator = u8;
pub type std_basic_string_const_reverse_iterator = u8;
pub type std_basic_string_reverse_iterator = u8;
pub type std_basic_string___const_iterator = u8;
pub type std_basic_string___sv_type = u8;
pub type std_basic_string__If_sv = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_basic_string___sv_wrapper {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_basic_string__Alloc_hider {
    pub _address: u8,
}
pub const std_basic_string__S_local_capacity: std_basic_string__bindgen_ty_1 =
    std_basic_string__bindgen_ty_1::_S_local_capacity;
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum std_basic_string__bindgen_ty_1 {
    _S_local_capacity = 0,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Copy, Clone)]
pub union std_basic_string__bindgen_ty_2 {
    pub _bindgen_opaque_blob: u64,
}
pub type std_integral_constant_value_type<_Tp> = _Tp;
pub type std_integral_constant_type = u8;
pub type std_true_type = u8;
pub type std_false_type = u8;
pub type std___bool_constant = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___and_ {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___not_ {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_is_empty {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_is_same {
    pub _base: std_false_type,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_remove_const {
    pub _address: u8,
}
pub type std_remove_const_type<_Tp> = _Tp;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_remove_cv {
    pub _address: u8,
}
pub type std_remove_cv_type = std_remove_const;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_make_unsigned {
    pub _address: u8,
}
pub type std_make_unsigned_type = u8;
#[repr(C)]
#[derive(Copy, Clone)]
pub union std_aligned_storage_type {
    pub __data: *mut ::core::ffi::c_uchar,
    pub __align: std_aligned_storage_type__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_aligned_storage_type__bindgen_ty_1 {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of std_aligned_storage_type"]
        [::core::mem::size_of::<std_aligned_storage_type>() - 8usize];
    ["Alignment of std_aligned_storage_type"]
        [::core::mem::align_of::<std_aligned_storage_type>() - 8usize];
};
pub type std___remove_cvref_t = std_remove_cv;
pub type std_enable_if_t = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___detector {
    pub _address: u8,
}
pub type std___detector_value_t = std_false_type;
pub type std___detector_type<_Default> = _Default;
pub type std___detected_or = std___detector;
pub type std___detected_or_t = std___detected_or;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___is_swappable {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___is_nothrow_swappable {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_in_place_t {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of std_in_place_t"][::core::mem::size_of::<std_in_place_t>() - 1usize];
    ["Alignment of std_in_place_t"][::core::mem::align_of::<std_in_place_t>() - 1usize];
};
pub type std_string = __BindgenOpaqueArray<u64, 4usize>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_iterator {
    pub _address: u8,
}
pub type std_iterator_iterator_category<_Category> = _Category;
pub type std_iterator_value_type<_Tp> = _Tp;
pub type std_iterator_difference_type<_Distance> = _Distance;
pub type std_iterator_pointer<_Pointer> = _Pointer;
pub type std_iterator_reference<_Reference> = _Reference;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___iterator_traits {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_iterator_traits {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___undefined {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___get_first_arg {
    pub _address: u8,
}
pub type std___get_first_arg_type = std___undefined;
pub type std___get_first_arg_t = std___get_first_arg;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___replace_first_arg {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_pointer_traits {
    pub _address: u8,
}
pub type std_pointer_traits___element_type = __BindgenOpaqueArray<u8, 0usize>;
pub type std_pointer_traits___difference_type = __BindgenOpaqueArray<u8, 0usize>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_pointer_traits___rebind {
    pub _address: u8,
}
pub type std_pointer_traits_pointer<_Ptr> = _Ptr;
pub type std_pointer_traits_element_type = std___detected_or_t;
pub type std_pointer_traits_difference_type = std___detected_or_t;
pub type std_pointer_traits_rebind = std_pointer_traits___rebind;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_reverse_iterator<_Iterator> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<_Iterator>>,
    pub current: _Iterator,
}
pub type std_reverse_iterator___traits_type = std_iterator_traits;
pub type std_reverse_iterator_iterator_type<_Iterator> = _Iterator;
pub type std_reverse_iterator_difference_type = std_reverse_iterator___traits_type;
pub type std_reverse_iterator_pointer = std_reverse_iterator___traits_type;
pub type std_reverse_iterator_reference = std_reverse_iterator___traits_type;
pub type std_streamoff = ::core::ffi::c_long;
#[repr(C)]
#[derive(Debug)]
pub struct std_fpos<_StateT> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<_StateT>>,
    pub _M_off: std_streamoff,
    pub _M_state: _StateT,
}
pub type std_streampos = std_fpos<__mbstate_t>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_char_traits {
    pub _address: u8,
}
pub type std___allocator_base = __gnu_cxx_new_allocator;
#[repr(C)]
#[derive(Debug)]
pub struct std_allocator {
    pub _address: u8,
}
pub type std_allocator_size_type = usize;
pub type std_allocator_difference_type = isize;
pub type std_allocator_pointer<_Tp> = *mut _Tp;
pub type std_allocator_const_pointer<_Tp> = *const _Tp;
pub type std_allocator_reference<_Tp> = *mut _Tp;
pub type std_allocator_const_reference<_Tp> = *const _Tp;
pub type std_allocator_value_type<_Tp> = _Tp;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_rebind {
    pub _address: u8,
}
pub type std_allocator_rebind_other = std_allocator;
pub type std_allocator_propagate_on_container_move_assignment = std_true_type;
pub type std_allocator_is_always_equal = std_true_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___allocator_traits_base {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___allocator_traits_base___rebind {
    pub _address: u8,
}
pub type std___allocator_traits_base___pointer = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___c_pointer = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___v_pointer = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___cv_pointer = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___pocca = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___pocma = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___pocs = __BindgenOpaqueArray<u8, 0usize>;
pub type std___allocator_traits_base___equal = __BindgenOpaqueArray<u8, 0usize>;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of std___allocator_traits_base"]
        [::core::mem::size_of::<std___allocator_traits_base>() - 1usize];
    ["Alignment of std___allocator_traits_base"]
        [::core::mem::align_of::<std___allocator_traits_base>() - 1usize];
};
pub type std___alloc_rebind = std___allocator_traits_base;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_traits {
    pub _address: u8,
}
pub type std_allocator_traits_allocator_type<_Alloc> = _Alloc;
pub type std_allocator_traits_value_type = __BindgenOpaqueArray<u8, 0usize>;
pub type std_allocator_traits_pointer = std___detected_or_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_traits__Ptr {
    pub _address: u8,
}
pub type std_allocator_traits__Ptr_type = __BindgenOpaqueArray<u8, 0usize>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_traits__Diff {
    pub _address: u8,
}
pub type std_allocator_traits__Diff_type = std_pointer_traits;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_traits__Size {
    pub _address: u8,
}
pub type std_allocator_traits_const_pointer = __BindgenOpaqueArray<u8, 0usize>;
pub type std_allocator_traits_void_pointer = std_allocator_traits__Ptr;
pub type std_allocator_traits_const_void_pointer = std_allocator_traits__Ptr;
pub type std_allocator_traits_difference_type = __BindgenOpaqueArray<u8, 0usize>;
pub type std_allocator_traits_size_type = __BindgenOpaqueArray<u8, 0usize>;
pub type std_allocator_traits_propagate_on_container_copy_assignment = std___detected_or_t;
pub type std_allocator_traits_propagate_on_container_move_assignment = std___detected_or_t;
pub type std_allocator_traits_propagate_on_container_swap = std___detected_or_t;
pub type std_allocator_traits_is_always_equal = std___detected_or_t;
pub type std_allocator_traits_rebind_alloc = std___alloc_rebind;
pub type std_allocator_traits_rebind_traits = std_allocator_traits;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_traits___construct_helper {
    pub _address: u8,
}
pub type std_allocator_traits___construct_helper_type<_Alloc> = _Alloc;
pub type std_allocator_traits___has_construct = std_allocator_traits___construct_helper;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_basic_string_view {
    pub _address: u8,
}
pub type std_basic_string_view_traits_type = u8;
pub type std_basic_string_view_value_type = u8;
pub type std_basic_string_view_pointer = u8;
pub type std_basic_string_view_const_pointer = u8;
pub type std_basic_string_view_reference = u8;
pub type std_basic_string_view_const_reference = u8;
pub type std_basic_string_view_const_iterator = u8;
pub type std_basic_string_view_iterator = u8;
pub type std_basic_string_view_const_reverse_iterator = u8;
pub type std_basic_string_view_reverse_iterator = u8;
pub type std_basic_string_view_size_type = u64;
pub type std_basic_string_view_difference_type = u64;
pub type std_string_view = __BindgenOpaqueArray<u64, 2usize>;
pub type std___array_traits__Type<_Tp> = *mut _Tp;
pub type std___array_traits__Is_swappable = std___is_swappable;
pub type std___array_traits__Is_nothrow_swappable = std___is_nothrow_swappable;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_tuple {
    pub _address: u8,
}
pub type std_tuple__Inherited = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_tuple__TC2 {
    pub _address: u8,
}
pub type std_tuple__TCC = u8;
pub type std_tuple__TMC = u8;
pub type std_tuple__TMCT = u8;
pub type std_tuple__TNTC = u8;
#[repr(C)]
pub struct std__Vector_base {
    pub _M_impl: std__Vector_base__Vector_impl,
}
pub type std__Vector_base__Tp_alloc_type = __BindgenOpaqueArray<u8, 0usize>;
pub type std__Vector_base_pointer = __BindgenOpaqueArray<u8, 0usize>;
#[repr(C)]
pub struct std__Vector_base__Vector_impl_data {
    pub _M_start: std__Vector_base_pointer,
    pub _M_finish: std__Vector_base_pointer,
    pub _M_end_of_storage: std__Vector_base_pointer,
}
#[repr(C)]
pub struct std__Vector_base__Vector_impl {
    pub _base_1: std__Vector_base__Vector_impl_data,
}
pub type std__Vector_base_allocator_type<_Alloc> = _Alloc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_default_delete {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___uniq_ptr_impl {
    pub _M_t: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std___uniq_ptr_impl__Ptr {
    pub _address: u8,
}
pub type std___uniq_ptr_impl__Ptr_type<_Up> = *mut _Up;
pub type std___uniq_ptr_impl__DeleterConstraint = u8;
pub type std___uniq_ptr_impl_pointer = std___uniq_ptr_impl__Ptr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_unique_ptr {
    pub _address: u8,
}
pub type std_unique_ptr__DeleterConstraint = std___uniq_ptr_impl;
pub type std_unique_ptr_pointer = std___uniq_ptr_impl;
pub type std_unique_ptr_element_type<_Tp> = _Tp;
pub type std_unique_ptr_deleter_type<_Dp> = _Dp;
pub type std_unique_ptr___safe_conversion_up = std___and_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_optional {
    pub _address: u8,
}
pub type std_optional__Base = u8;
pub type std_optional___not_self = std___not_;
pub type std_optional___not_tag = std___not_;
pub type std_optional__Requires = std_enable_if_t;
pub type std_optional_value_type<_Tp> = _Tp;
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum std_byte {
    __bindgen_cannot_repr_c_on_empty_enum = 0,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_atomic {
    pub _address: u8,
}
pub type std_atomic_value_type<_Tp> = _Tp;
pub type std__Base_bitset__WordT = ::core::ffi::c_ulong;
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_left_shift"]
    pub fn std__Base_bitset__M_do_left_shift(this: *mut u8, __shift: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_right_shift"]
    pub fn std__Base_bitset__M_do_right_shift(this: *mut u8, __shift: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_to_ulong"]
    pub fn std__Base_bitset__M_do_to_ulong(this: *const u8) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_to_ullong"]
    pub fn std__Base_bitset__M_do_to_ullong(this: *const u8) -> ::core::ffi::c_ulonglong;
}
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_find_first"]
    pub fn std__Base_bitset__M_do_find_first(this: *const u8, arg1: usize) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_M_do_find_next"]
    pub fn std__Base_bitset__M_do_find_next(this: *const u8, arg1: usize, arg2: usize) -> usize;
}
pub type std_bitset__Base = u8;
pub type std_bitset__WordT = ::core::ffi::c_ulong;
#[repr(C)]
#[derive(Debug)]
pub struct std_bitset_reference {
    pub _M_wp: *mut std_bitset__WordT,
    pub _M_bpos: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx___normal_iterator<_Iterator> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<_Iterator>>,
    pub _M_current: _Iterator,
}
pub type __gnu_cxx___normal_iterator___traits_type = std_iterator_traits;
pub type __gnu_cxx___normal_iterator_iterator_type<_Iterator> = _Iterator;
pub type __gnu_cxx___normal_iterator_iterator_category = __gnu_cxx___normal_iterator___traits_type;
pub type __gnu_cxx___normal_iterator_value_type = __gnu_cxx___normal_iterator___traits_type;
pub type __gnu_cxx___normal_iterator_difference_type = __gnu_cxx___normal_iterator___traits_type;
pub type __gnu_cxx___normal_iterator_reference = __gnu_cxx___normal_iterator___traits_type;
pub type __gnu_cxx___normal_iterator_pointer = __gnu_cxx___normal_iterator___traits_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx__Char_types {
    pub _address: u8,
}
pub type __gnu_cxx__Char_types_int_type = ::core::ffi::c_ulong;
pub type __gnu_cxx__Char_types_pos_type = std_streampos;
pub type __gnu_cxx__Char_types_off_type = std_streamoff;
pub type __gnu_cxx__Char_types_state_type = __mbstate_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx_char_traits {
    pub _address: u8,
}
pub type __gnu_cxx_char_traits_char_type<_CharT> = _CharT;
pub type __gnu_cxx_char_traits_int_type = __gnu_cxx__Char_types;
pub type __gnu_cxx_char_traits_pos_type = __gnu_cxx__Char_types;
pub type __gnu_cxx_char_traits_off_type = __gnu_cxx__Char_types;
pub type __gnu_cxx_char_traits_state_type = __gnu_cxx__Char_types;
#[repr(C)]
#[derive(Debug)]
pub struct __gnu_cxx_new_allocator {
    pub _address: u8,
}
pub type __gnu_cxx_new_allocator_size_type = ::core::ffi::c_ulong;
pub type __gnu_cxx_new_allocator_difference_type = ::core::ffi::c_long;
pub type __gnu_cxx_new_allocator_pointer<_Tp> = *mut _Tp;
pub type __gnu_cxx_new_allocator_const_pointer<_Tp> = *const _Tp;
pub type __gnu_cxx_new_allocator_reference<_Tp> = *mut _Tp;
pub type __gnu_cxx_new_allocator_const_reference<_Tp> = *const _Tp;
pub type __gnu_cxx_new_allocator_value_type<_Tp> = _Tp;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx_new_allocator_rebind {
    pub _address: u8,
}
pub type __gnu_cxx_new_allocator_propagate_on_container_move_assignment = std_true_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx___alloc_traits {
    pub _address: u8,
}
pub type __gnu_cxx___alloc_traits_allocator_type<_Alloc> = _Alloc;
pub type __gnu_cxx___alloc_traits__Base_type = std_allocator_traits;
pub type __gnu_cxx___alloc_traits_value_type = __gnu_cxx___alloc_traits__Base_type;
pub type __gnu_cxx___alloc_traits_pointer = __gnu_cxx___alloc_traits__Base_type;
pub type __gnu_cxx___alloc_traits_const_pointer = __gnu_cxx___alloc_traits__Base_type;
pub type __gnu_cxx___alloc_traits_size_type = __gnu_cxx___alloc_traits__Base_type;
pub type __gnu_cxx___alloc_traits_difference_type = __gnu_cxx___alloc_traits__Base_type;
pub type __gnu_cxx___alloc_traits_reference = *mut __gnu_cxx___alloc_traits_value_type;
pub type __gnu_cxx___alloc_traits_const_reference = *const __gnu_cxx___alloc_traits_value_type;
pub type __gnu_cxx___alloc_traits___is_custom_pointer = std___and_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __gnu_cxx___alloc_traits_rebind {
    pub _address: u8,
}
pub type __gnu_cxx___alloc_traits_rebind_other = __gnu_cxx___alloc_traits__Base_type;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::core::ffi::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::core::ffi::c_uint,
    pub __wchb: [::core::ffi::c_char; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __mbstate_t__bindgen_ty_1"]
        [::core::mem::size_of::<__mbstate_t__bindgen_ty_1>() - 4usize];
    ["Alignment of __mbstate_t__bindgen_ty_1"]
        [::core::mem::align_of::<__mbstate_t__bindgen_ty_1>() - 4usize];
    ["Offset of field: __mbstate_t__bindgen_ty_1::__wch"]
        [::core::mem::offset_of!(__mbstate_t__bindgen_ty_1, __wch) - 0usize];
    ["Offset of field: __mbstate_t__bindgen_ty_1::__wchb"]
        [::core::mem::offset_of!(__mbstate_t__bindgen_ty_1, __wchb) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __mbstate_t"][::core::mem::size_of::<__mbstate_t>() - 8usize];
    ["Alignment of __mbstate_t"][::core::mem::align_of::<__mbstate_t>() - 4usize];
    ["Offset of field: __mbstate_t::__count"]
        [::core::mem::offset_of!(__mbstate_t, __count) - 0usize];
    ["Offset of field: __mbstate_t::__value"]
        [::core::mem::offset_of!(__mbstate_t, __value) - 4usize];
};
pub type FILE = __BindgenOpaqueArray<u64, 27usize>;
pub type va_list = __gnuc_va_list;
pub type SkUnichar = i32;
pub type SkGlyphID = u16;
#[repr(C)]
pub struct SkRefCntBase__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct SkRefCntBase {
    pub vtable_: *const SkRefCntBase__bindgen_vtable,
    pub fRefCnt: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRefCntBase"][::core::mem::size_of::<SkRefCntBase>() - 16usize];
    ["Alignment of SkRefCntBase"][::core::mem::align_of::<SkRefCntBase>() - 8usize];
    ["Offset of field: SkRefCntBase::fRefCnt"]
        [::core::mem::offset_of!(SkRefCntBase, fRefCnt) - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkRefCnt {
    pub _base: SkRefCntBase,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRefCnt"][::core::mem::size_of::<SkRefCnt>() - 16usize];
    ["Alignment of SkRefCnt"][::core::mem::align_of::<SkRefCnt>() - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkNVRefCnt {
    pub fRefCnt: u32,
}
#[repr(C)]
#[derive(Debug)]
pub struct sk_sp<T> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<T>>,
    pub fPtr: *mut T,
}
pub type sk_sp_element_type<T> = T;
pub type sk_sp_sk_is_trivially_relocatable = std_true_type;
pub type U8CPU = ::core::ffi::c_uint;
pub type SkScalar = f32;
#[repr(C)]
#[derive(Debug)]
pub struct SkString {
    pub fRec: sk_sp<SkString_Rec>,
}
pub type SkString_sk_is_trivially_relocatable = std_true_type;
#[repr(C)]
#[derive(Debug)]
pub struct SkString_Rec {
    pub fLength: u32,
    pub fRefCnt: u32,
    pub fBeginningOfData: [::core::ffi::c_char; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkString_Rec"][::core::mem::size_of::<SkString_Rec>() - 12usize];
    ["Alignment of SkString_Rec"][::core::mem::align_of::<SkString_Rec>() - 4usize];
    ["Offset of field: SkString_Rec::fLength"]
        [::core::mem::offset_of!(SkString_Rec, fLength) - 0usize];
    ["Offset of field: SkString_Rec::fRefCnt"]
        [::core::mem::offset_of!(SkString_Rec, fRefCnt) - 4usize];
    ["Offset of field: SkString_Rec::fBeginningOfData"]
        [::core::mem::offset_of!(SkString_Rec, fBeginningOfData) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString3Rec4MakeEPKcm"]
    pub fn SkString_Rec_Make(text: *const ::core::ffi::c_char, len: usize) -> sk_sp<SkString_Rec>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString3Rec3refEv"]
    pub fn SkString_Rec_ref(this: *const SkString_Rec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString3Rec5unrefEv"]
    pub fn SkString_Rec_unref(this: *const SkString_Rec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString3Rec6uniqueEv"]
    pub fn SkString_Rec_unique(this: *const SkString_Rec) -> bool;
}
impl SkString_Rec {
    #[inline]
    pub unsafe fn Make(text: *const ::core::ffi::c_char, len: usize) -> sk_sp<SkString_Rec> {
        SkString_Rec_Make(text, len)
    }
    #[inline]
    pub unsafe fn ref_(&self) {
        SkString_Rec_ref(self)
    }
    #[inline]
    pub unsafe fn unref(&self) {
        SkString_Rec_unref(self)
    }
    #[inline]
    pub unsafe fn unique(&self) -> bool {
        SkString_Rec_unique(self)
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9gEmptyRecE"]
    pub static SkString_gEmptyRec: SkString_Rec;
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkString"][::core::mem::size_of::<SkString>() - 8usize];
    ["Alignment of SkString"][::core::mem::align_of::<SkString>() - 8usize];
    ["Offset of field: SkString::fRec"][::core::mem::offset_of!(SkString, fRec) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString6equalsERKS_"]
    pub fn SkString_equals(this: *const SkString, arg1: *const SkString) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString6equalsEPKc"]
    pub fn SkString_equals1(this: *const SkString, text: *const ::core::ffi::c_char) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkString6equalsEPKcm"]
    pub fn SkString_equals2(
        this: *const SkString,
        text: *const ::core::ffi::c_char,
        len: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString4dataEv"]
    pub fn SkString_data(this: *mut SkString) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString5resetEv"]
    pub fn SkString_reset(this: *mut SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString6resizeEm"]
    pub fn SkString_resize(this: *mut SkString, len: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString3setEPKc"]
    pub fn SkString_set(this: *mut SkString, text: *const ::core::ffi::c_char);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString3setEPKcm"]
    pub fn SkString_set1(this: *mut SkString, text: *const ::core::ffi::c_char, len: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString6insertEmPKc"]
    pub fn SkString_insert(this: *mut SkString, offset: usize, text: *const ::core::ffi::c_char);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString6insertEmPKcm"]
    pub fn SkString_insert1(
        this: *mut SkString,
        offset: usize,
        text: *const ::core::ffi::c_char,
        len: usize,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString13insertUnicharEmi"]
    pub fn SkString_insertUnichar(this: *mut SkString, offset: usize, arg1: SkUnichar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9insertS32Emi"]
    pub fn SkString_insertS32(this: *mut SkString, offset: usize, value: i32);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9insertS64Emli"]
    pub fn SkString_insertS64(
        this: *mut SkString,
        offset: usize,
        value: i64,
        minDigits: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9insertU32Emj"]
    pub fn SkString_insertU32(this: *mut SkString, offset: usize, value: u32);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9insertU64Emmi"]
    pub fn SkString_insertU64(
        this: *mut SkString,
        offset: usize,
        value: u64,
        minDigits: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString9insertHexEmji"]
    pub fn SkString_insertHex(
        this: *mut SkString,
        offset: usize,
        value: u32,
        minDigits: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString12insertScalarEmf"]
    pub fn SkString_insertScalar(this: *mut SkString, offset: usize, arg1: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString6printfEPKcz"]
    pub fn SkString_printf(this: *mut SkString, format: *const ::core::ffi::c_char, ...);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString11printVAListEPKcP13__va_list_tag"]
    pub fn SkString_printVAList(
        this: *mut SkString,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString7appendfEPKcz"]
    pub fn SkString_appendf(this: *mut SkString, format: *const ::core::ffi::c_char, ...);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString12appendVAListEPKcP13__va_list_tag"]
    pub fn SkString_appendVAList(
        this: *mut SkString,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString8prependfEPKcz"]
    pub fn SkString_prependf(this: *mut SkString, format: *const ::core::ffi::c_char, ...);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString13prependVAListEPKcP13__va_list_tag"]
    pub fn SkString_prependVAList(
        this: *mut SkString,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString6removeEmm"]
    pub fn SkString_remove(this: *mut SkString, offset: usize, length: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkString4swapERS_"]
    pub fn SkString_swap(this: *mut SkString, other: *mut SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1Ev"]
    pub fn SkString_SkString(this: *mut SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1Em"]
    pub fn SkString_SkString1(this: *mut SkString, len: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1EPKc"]
    pub fn SkString_SkString2(this: *mut SkString, text: *const ::core::ffi::c_char);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1EPKcm"]
    pub fn SkString_SkString3(this: *mut SkString, text: *const ::core::ffi::c_char, len: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1ERKS_"]
    pub fn SkString_SkString4(this: *mut SkString, arg1: *const SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1EOS_"]
    pub fn SkString_SkString5(this: *mut SkString, arg1: *mut SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1ERKNSt7__cxx1112basic_stringIcSt11char_traitsIcESaIcEEE"]
    pub fn SkString_SkString6(this: *mut SkString, arg1: *const std_string);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringC1ESt17basic_string_viewIcSt11char_traitsIcEE"]
    pub fn SkString_SkString7(this: *mut SkString, arg1: std_string_view);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStringD1Ev"]
    pub fn SkString_SkString_destructor(this: *mut SkString);
}
impl SkString {
    #[inline]
    pub unsafe fn equals(&self, arg1: *const SkString) -> bool {
        SkString_equals(self, arg1)
    }
    #[inline]
    pub unsafe fn equals1(&self, text: *const ::core::ffi::c_char) -> bool {
        SkString_equals1(self, text)
    }
    #[inline]
    pub unsafe fn equals2(&self, text: *const ::core::ffi::c_char, len: usize) -> bool {
        SkString_equals2(self, text, len)
    }
    #[inline]
    pub unsafe fn data(&mut self) -> *mut ::core::ffi::c_char {
        SkString_data(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkString_reset(self)
    }
    #[inline]
    pub unsafe fn resize(&mut self, len: usize) {
        SkString_resize(self, len)
    }
    #[inline]
    pub unsafe fn set(&mut self, text: *const ::core::ffi::c_char) {
        SkString_set(self, text)
    }
    #[inline]
    pub unsafe fn set1(&mut self, text: *const ::core::ffi::c_char, len: usize) {
        SkString_set1(self, text, len)
    }
    #[inline]
    pub unsafe fn insert(&mut self, offset: usize, text: *const ::core::ffi::c_char) {
        SkString_insert(self, offset, text)
    }
    #[inline]
    pub unsafe fn insert1(&mut self, offset: usize, text: *const ::core::ffi::c_char, len: usize) {
        SkString_insert1(self, offset, text, len)
    }
    #[inline]
    pub unsafe fn insertUnichar(&mut self, offset: usize, arg1: SkUnichar) {
        SkString_insertUnichar(self, offset, arg1)
    }
    #[inline]
    pub unsafe fn insertS32(&mut self, offset: usize, value: i32) {
        SkString_insertS32(self, offset, value)
    }
    #[inline]
    pub unsafe fn insertS64(&mut self, offset: usize, value: i64, minDigits: ::core::ffi::c_int) {
        SkString_insertS64(self, offset, value, minDigits)
    }
    #[inline]
    pub unsafe fn insertU32(&mut self, offset: usize, value: u32) {
        SkString_insertU32(self, offset, value)
    }
    #[inline]
    pub unsafe fn insertU64(&mut self, offset: usize, value: u64, minDigits: ::core::ffi::c_int) {
        SkString_insertU64(self, offset, value, minDigits)
    }
    #[inline]
    pub unsafe fn insertHex(&mut self, offset: usize, value: u32, minDigits: ::core::ffi::c_int) {
        SkString_insertHex(self, offset, value, minDigits)
    }
    #[inline]
    pub unsafe fn insertScalar(&mut self, offset: usize, arg1: SkScalar) {
        SkString_insertScalar(self, offset, arg1)
    }
    #[inline]
    pub unsafe fn printVAList(
        &mut self,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    ) {
        SkString_printVAList(self, format, arg1)
    }
    #[inline]
    pub unsafe fn appendVAList(
        &mut self,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    ) {
        SkString_appendVAList(self, format, arg1)
    }
    #[inline]
    pub unsafe fn prependVAList(
        &mut self,
        format: *const ::core::ffi::c_char,
        arg1: *mut __va_list_tag,
    ) {
        SkString_prependVAList(self, format, arg1)
    }
    #[inline]
    pub unsafe fn remove(&mut self, offset: usize, length: usize) {
        SkString_remove(self, offset, length)
    }
    #[inline]
    pub unsafe fn swap(&mut self, other: *mut SkString) {
        SkString_swap(self, other)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(len: usize) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString1(__bindgen_tmp.as_mut_ptr(), len);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(text: *const ::core::ffi::c_char) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString2(__bindgen_tmp.as_mut_ptr(), text);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(text: *const ::core::ffi::c_char, len: usize) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString3(__bindgen_tmp.as_mut_ptr(), text, len);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new4(arg1: *const SkString) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString4(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new5(arg1: *mut SkString) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString5(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new6(arg1: *const std_string) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString6(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new7(arg1: std_string_view) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkString_SkString7(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkString_SkString_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TraitObject {
    pub data: *mut ::core::ffi::c_void,
    pub vtable: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of TraitObject"][::core::mem::size_of::<TraitObject>() - 16usize];
    ["Alignment of TraitObject"][::core::mem::align_of::<TraitObject>() - 8usize];
    ["Offset of field: TraitObject::data"][::core::mem::offset_of!(TraitObject, data) - 0usize];
    ["Offset of field: TraitObject::vtable"][::core::mem::offset_of!(TraitObject, vtable) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VecSink<T> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<T>>,
    pub fn_trait: TraitObject,
    pub set_fn:
        ::core::option::Option<unsafe extern "C" fn(arg1: *mut T, arg2: usize, arg3: TraitObject)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sink<T> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<T>>,
    pub fn_trait: TraitObject,
    pub set_fn: ::core::option::Option<unsafe extern "C" fn(arg1: *const T, arg2: TraitObject)>,
}
#[repr(C)]
pub struct SkStrings {
    pub strings: __BindgenOpaqueArray<u64, 3usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkStrings"][::core::mem::size_of::<SkStrings>() - 24usize];
    ["Alignment of SkStrings"][::core::mem::align_of::<SkStrings>() - 8usize];
    ["Offset of field: SkStrings::strings"][::core::mem::offset_of!(SkStrings, strings) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkIPoint {
    pub fX: i32,
    pub fY: i32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkIPoint"][::core::mem::size_of::<SkIPoint>() - 8usize];
    ["Alignment of SkIPoint"][::core::mem::align_of::<SkIPoint>() - 4usize];
    ["Offset of field: SkIPoint::fX"][::core::mem::offset_of!(SkIPoint, fX) - 0usize];
    ["Offset of field: SkIPoint::fY"][::core::mem::offset_of!(SkIPoint, fY) - 4usize];
};
pub type SkVector = SkPoint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPoint {
    pub fX: f32,
    pub fY: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPoint"][::core::mem::size_of::<SkPoint>() - 8usize];
    ["Alignment of SkPoint"][::core::mem::align_of::<SkPoint>() - 4usize];
    ["Offset of field: SkPoint::fX"][::core::mem::offset_of!(SkPoint, fX) - 0usize];
    ["Offset of field: SkPoint::fY"][::core::mem::offset_of!(SkPoint, fY) - 4usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint9normalizeEv"]
    pub fn SkPoint_normalize(this: *mut SkPoint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint12setNormalizeEff"]
    pub fn SkPoint_setNormalize(this: *mut SkPoint, x: f32, y: f32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint9setLengthEf"]
    pub fn SkPoint_setLength(this: *mut SkPoint, length: f32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint9setLengthEfff"]
    pub fn SkPoint_setLength1(this: *mut SkPoint, x: f32, y: f32, length: f32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPoint5scaleEfPS_"]
    pub fn SkPoint_scale(this: *const SkPoint, scale: f32, dst: *mut SkPoint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint6LengthEff"]
    pub fn SkPoint_Length(x: f32, y: f32) -> f32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPoint9NormalizeEPS_"]
    pub fn SkPoint_Normalize(vec: *mut SkVector) -> f32;
}
impl SkPoint {
    #[inline]
    pub unsafe fn normalize(&mut self) -> bool {
        SkPoint_normalize(self)
    }
    #[inline]
    pub unsafe fn setNormalize(&mut self, x: f32, y: f32) -> bool {
        SkPoint_setNormalize(self, x, y)
    }
    #[inline]
    pub unsafe fn setLength(&mut self, length: f32) -> bool {
        SkPoint_setLength(self, length)
    }
    #[inline]
    pub unsafe fn setLength1(&mut self, x: f32, y: f32, length: f32) -> bool {
        SkPoint_setLength1(self, x, y, length)
    }
    #[inline]
    pub unsafe fn scale(&self, scale: f32, dst: *mut SkPoint) {
        SkPoint_scale(self, scale, dst)
    }
    #[inline]
    pub unsafe fn Length(x: f32, y: f32) -> f32 {
        SkPoint_Length(x, y)
    }
    #[inline]
    pub unsafe fn Normalize(vec: *mut SkVector) -> f32 {
        SkPoint_Normalize(vec)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPoint3 {
    pub fX: SkScalar,
    pub fY: SkScalar,
    pub fZ: SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPoint3"][::core::mem::size_of::<SkPoint3>() - 12usize];
    ["Alignment of SkPoint3"][::core::mem::align_of::<SkPoint3>() - 4usize];
    ["Offset of field: SkPoint3::fX"][::core::mem::offset_of!(SkPoint3, fX) - 0usize];
    ["Offset of field: SkPoint3::fY"][::core::mem::offset_of!(SkPoint3, fY) - 4usize];
    ["Offset of field: SkPoint3::fZ"][::core::mem::offset_of!(SkPoint3, fZ) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPoint36LengthEfff"]
    pub fn SkPoint3_Length(x: SkScalar, y: SkScalar, z: SkScalar) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPoint39normalizeEv"]
    pub fn SkPoint3_normalize(this: *mut SkPoint3) -> bool;
}
impl SkPoint3 {
    #[inline]
    pub unsafe fn Length(x: SkScalar, y: SkScalar, z: SkScalar) -> SkScalar {
        SkPoint3_Length(x, y, z)
    }
    #[inline]
    pub unsafe fn normalize(&mut self) -> bool {
        SkPoint3_normalize(self)
    }
}
impl SkPathFillType {
    pub const Default: SkPathFillType = SkPathFillType::Winding;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathFillType {
    Winding = 0,
    EvenOdd = 1,
    InverseWinding = 2,
    InverseEvenOdd = 3,
}
impl SkPathDirection {
    pub const Default: SkPathDirection = SkPathDirection::CW;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathDirection {
    CW = 0,
    CCW = 1,
}
pub const SkPathSegmentMask_kLine_SkPathSegmentMask: SkPathSegmentMask = 1;
pub const SkPathSegmentMask_kQuad_SkPathSegmentMask: SkPathSegmentMask = 2;
pub const SkPathSegmentMask_kConic_SkPathSegmentMask: SkPathSegmentMask = 4;
pub const SkPathSegmentMask_kCubic_SkPathSegmentMask: SkPathSegmentMask = 8;
pub type SkPathSegmentMask = ::core::ffi::c_uint;
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathVerb {
    Move = 0,
    Line = 1,
    Quad = 2,
    Conic = 3,
    Cubic = 4,
    Close = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkISize {
    pub fWidth: i32,
    pub fHeight: i32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkISize"][::core::mem::size_of::<SkISize>() - 8usize];
    ["Alignment of SkISize"][::core::mem::align_of::<SkISize>() - 4usize];
    ["Offset of field: SkISize::fWidth"][::core::mem::offset_of!(SkISize, fWidth) - 0usize];
    ["Offset of field: SkISize::fHeight"][::core::mem::offset_of!(SkISize, fHeight) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSize {
    pub fWidth: SkScalar,
    pub fHeight: SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSize"][::core::mem::size_of::<SkSize>() - 8usize];
    ["Alignment of SkSize"][::core::mem::align_of::<SkSize>() - 4usize];
    ["Offset of field: SkSize::fWidth"][::core::mem::offset_of!(SkSize, fWidth) - 0usize];
    ["Offset of field: SkSize::fHeight"][::core::mem::offset_of!(SkSize, fHeight) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSpan<T> {
    pub _phantom_0: ::core::marker::PhantomData<::core::cell::UnsafeCell<T>>,
    pub fPtr: *mut T,
    pub fSize: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkIRect {
    pub fLeft: i32,
    pub fTop: i32,
    pub fRight: i32,
    pub fBottom: i32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkIRect"][::core::mem::size_of::<SkIRect>() - 16usize];
    ["Alignment of SkIRect"][::core::mem::align_of::<SkIRect>() - 4usize];
    ["Offset of field: SkIRect::fLeft"][::core::mem::offset_of!(SkIRect, fLeft) - 0usize];
    ["Offset of field: SkIRect::fTop"][::core::mem::offset_of!(SkIRect, fTop) - 4usize];
    ["Offset of field: SkIRect::fRight"][::core::mem::offset_of!(SkIRect, fRight) - 8usize];
    ["Offset of field: SkIRect::fBottom"][::core::mem::offset_of!(SkIRect, fBottom) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkIRect9intersectERKS_S1_"]
    pub fn SkIRect_intersect(this: *mut SkIRect, a: *const SkIRect, b: *const SkIRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkIRect4joinERKS_"]
    pub fn SkIRect_join(this: *mut SkIRect, r: *const SkIRect);
}
impl SkIRect {
    #[inline]
    pub unsafe fn intersect(&mut self, a: *const SkIRect, b: *const SkIRect) -> bool {
        SkIRect_intersect(self, a, b)
    }
    #[inline]
    pub unsafe fn join(&mut self, r: *const SkIRect) {
        SkIRect_join(self, r)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRect {
    pub fLeft: f32,
    pub fTop: f32,
    pub fRight: f32,
    pub fBottom: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRect"][::core::mem::size_of::<SkRect>() - 16usize];
    ["Alignment of SkRect"][::core::mem::align_of::<SkRect>() - 4usize];
    ["Offset of field: SkRect::fLeft"][::core::mem::offset_of!(SkRect, fLeft) - 0usize];
    ["Offset of field: SkRect::fTop"][::core::mem::offset_of!(SkRect, fTop) - 4usize];
    ["Offset of field: SkRect::fRight"][::core::mem::offset_of!(SkRect, fRight) - 8usize];
    ["Offset of field: SkRect::fBottom"][::core::mem::offset_of!(SkRect, fBottom) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect6BoundsE6SkSpanIK7SkPointE"]
    pub fn SkRect_Bounds(pts: SkSpan<SkPoint>) -> __BindgenOpaqueArray<u32, 5usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect14setBoundsCheckE6SkSpanIK7SkPointE"]
    pub fn SkRect_setBoundsCheck(this: *mut SkRect, pts: SkSpan<SkPoint>) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect16setBoundsNoCheckE6SkSpanIK7SkPointE"]
    pub fn SkRect_setBoundsNoCheck(this: *mut SkRect, pts: SkSpan<SkPoint>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect9intersectERKS_"]
    pub fn SkRect_intersect(this: *mut SkRect, r: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect9intersectERKS_S1_"]
    pub fn SkRect_intersect1(this: *mut SkRect, a: *const SkRect, b: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkRect4joinERKS_"]
    pub fn SkRect_join(this: *mut SkRect, r: *const SkRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkRect4dumpEb"]
    pub fn SkRect_dump(this: *const SkRect, asHex: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkRect12dumpToStringEb"]
    pub fn SkRect_dumpToString(this: *const SkRect, asHex: bool) -> SkString;
}
impl SkRect {
    #[inline]
    pub unsafe fn Bounds(pts: SkSpan<SkPoint>) -> __BindgenOpaqueArray<u32, 5usize> {
        SkRect_Bounds(pts)
    }
    #[inline]
    pub unsafe fn setBoundsCheck(&mut self, pts: SkSpan<SkPoint>) -> bool {
        SkRect_setBoundsCheck(self, pts)
    }
    #[inline]
    pub unsafe fn setBoundsNoCheck(&mut self, pts: SkSpan<SkPoint>) {
        SkRect_setBoundsNoCheck(self, pts)
    }
    #[inline]
    pub unsafe fn intersect(&mut self, r: *const SkRect) -> bool {
        SkRect_intersect(self, r)
    }
    #[inline]
    pub unsafe fn intersect1(&mut self, a: *const SkRect, b: *const SkRect) -> bool {
        SkRect_intersect1(self, a, b)
    }
    #[inline]
    pub unsafe fn join(&mut self, r: *const SkRect) {
        SkRect_join(self, r)
    }
    #[inline]
    pub unsafe fn dump(&self, asHex: bool) {
        SkRect_dump(self, asHex)
    }
    #[inline]
    pub unsafe fn dumpToString(&self, asHex: bool) -> SkString {
        SkRect_dumpToString(self, asHex)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkMatrix {
    pub fMat: [SkScalar; 9usize],
    pub fTypeMask: i32,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkMatrix_ScaleToFit {
    Fill = 0,
    Start = 1,
    Center = 2,
    End = 3,
}
pub const SkMatrix_TypeMask_kIdentity_Mask: SkMatrix_TypeMask = 0;
pub const SkMatrix_TypeMask_kTranslate_Mask: SkMatrix_TypeMask = 1;
pub const SkMatrix_TypeMask_kScale_Mask: SkMatrix_TypeMask = 2;
pub const SkMatrix_TypeMask_kAffine_Mask: SkMatrix_TypeMask = 4;
pub const SkMatrix_TypeMask_kPerspective_Mask: SkMatrix_TypeMask = 8;
pub type SkMatrix_TypeMask = ::core::ffi::c_uint;
pub type SkMatrix_MapPtsProc = ::core::option::Option<
    unsafe extern "C" fn(
        mat: *const SkMatrix,
        dst: *mut SkPoint,
        src: *const SkPoint,
        count: ::core::ffi::c_int,
    ),
>;
pub const SkMatrix_kMScaleX: ::core::ffi::c_int = 0;
pub const SkMatrix_kMSkewX: ::core::ffi::c_int = 1;
pub const SkMatrix_kMTransX: ::core::ffi::c_int = 2;
pub const SkMatrix_kMSkewY: ::core::ffi::c_int = 3;
pub const SkMatrix_kMScaleY: ::core::ffi::c_int = 4;
pub const SkMatrix_kMTransY: ::core::ffi::c_int = 5;
pub const SkMatrix_kMPersp0: ::core::ffi::c_int = 6;
pub const SkMatrix_kMPersp1: ::core::ffi::c_int = 7;
pub const SkMatrix_kMPersp2: ::core::ffi::c_int = 8;
pub const SkMatrix_kAScaleX: ::core::ffi::c_int = 0;
pub const SkMatrix_kASkewY: ::core::ffi::c_int = 1;
pub const SkMatrix_kASkewX: ::core::ffi::c_int = 2;
pub const SkMatrix_kAScaleY: ::core::ffi::c_int = 3;
pub const SkMatrix_kATransX: ::core::ffi::c_int = 4;
pub const SkMatrix_kATransY: ::core::ffi::c_int = 5;
pub const SkMatrix_kRectStaysRect_Mask: ::core::ffi::c_int = 16;
pub const SkMatrix_kOnlyPerspectiveValid_Mask: ::core::ffi::c_int = 64;
pub const SkMatrix_kUnknown_Mask: ::core::ffi::c_int = 128;
pub const SkMatrix_kORableMasks: ::core::ffi::c_int = 15;
pub const SkMatrix_kAllMasks: ::core::ffi::c_int = 31;
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix12gMapPtsProcsE"]
    pub static SkMatrix_gMapPtsProcs: [SkMatrix_MapPtsProc; 0usize];
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkMatrix"][::core::mem::size_of::<SkMatrix>() - 40usize];
    ["Alignment of SkMatrix"][::core::mem::align_of::<SkMatrix>() - 4usize];
    ["Offset of field: SkMatrix::fMat"][::core::mem::offset_of!(SkMatrix, fMat) - 0usize];
    ["Offset of field: SkMatrix::fTypeMask"]
        [::core::mem::offset_of!(SkMatrix, fTypeMask) - 36usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix14ScaleTranslateEffff"]
    pub fn SkMatrix_ScaleTranslate(sx: f32, sy: f32, tx: f32, ty: f32) -> SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix12isSimilarityEf"]
    pub fn SkMatrix_isSimilarity(this: *const SkMatrix, tol: SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix20preservesRightAnglesEf"]
    pub fn SkMatrix_preservesRightAngles(this: *const SkMatrix, tol: SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix4set9EPKf"]
    pub fn SkMatrix_set9(this: *mut SkMatrix, buffer: *const SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix5resetEv"]
    pub fn SkMatrix_reset(this: *mut SkMatrix) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix12setTranslateEff"]
    pub fn SkMatrix_setTranslate(this: *mut SkMatrix, dx: SkScalar, dy: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8setScaleEffff"]
    pub fn SkMatrix_setScale(
        this: *mut SkMatrix,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8setScaleEff"]
    pub fn SkMatrix_setScale1(this: *mut SkMatrix, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setRotateEfff"]
    pub fn SkMatrix_setRotate(
        this: *mut SkMatrix,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setRotateEf"]
    pub fn SkMatrix_setRotate1(this: *mut SkMatrix, degrees: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setSinCosEffff"]
    pub fn SkMatrix_setSinCos(
        this: *mut SkMatrix,
        sinValue: SkScalar,
        cosValue: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setSinCosEff"]
    pub fn SkMatrix_setSinCos1(
        this: *mut SkMatrix,
        sinValue: SkScalar,
        cosValue: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix10setRSXformERK9SkRSXform"]
    pub fn SkMatrix_setRSXform(this: *mut SkMatrix, rsxForm: *const SkRSXform) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix7setSkewEffff"]
    pub fn SkMatrix_setSkew(
        this: *mut SkMatrix,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix7setSkewEff"]
    pub fn SkMatrix_setSkew1(this: *mut SkMatrix, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setConcatERKS_S1_"]
    pub fn SkMatrix_setConcat(
        this: *mut SkMatrix,
        a: *const SkMatrix,
        b: *const SkMatrix,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix12preTranslateEff"]
    pub fn SkMatrix_preTranslate(this: *mut SkMatrix, dx: SkScalar, dy: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8preScaleEffff"]
    pub fn SkMatrix_preScale(
        this: *mut SkMatrix,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8preScaleEff"]
    pub fn SkMatrix_preScale1(this: *mut SkMatrix, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9preRotateEfff"]
    pub fn SkMatrix_preRotate(
        this: *mut SkMatrix,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9preRotateEf"]
    pub fn SkMatrix_preRotate1(this: *mut SkMatrix, degrees: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix7preSkewEffff"]
    pub fn SkMatrix_preSkew(
        this: *mut SkMatrix,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix7preSkewEff"]
    pub fn SkMatrix_preSkew1(this: *mut SkMatrix, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9preConcatERKS_"]
    pub fn SkMatrix_preConcat(this: *mut SkMatrix, other: *const SkMatrix) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix13postTranslateEff"]
    pub fn SkMatrix_postTranslate(this: *mut SkMatrix, dx: SkScalar, dy: SkScalar)
    -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9postScaleEffff"]
    pub fn SkMatrix_postScale(
        this: *mut SkMatrix,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9postScaleEff"]
    pub fn SkMatrix_postScale1(this: *mut SkMatrix, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix10postRotateEfff"]
    pub fn SkMatrix_postRotate(
        this: *mut SkMatrix,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix10postRotateEf"]
    pub fn SkMatrix_postRotate1(this: *mut SkMatrix, degrees: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8postSkewEffff"]
    pub fn SkMatrix_postSkew(
        this: *mut SkMatrix,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix8postSkewEff"]
    pub fn SkMatrix_postSkew1(this: *mut SkMatrix, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix10postConcatERKS_"]
    pub fn SkMatrix_postConcat(this: *mut SkMatrix, other: *const SkMatrix) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9Rect2RectERK6SkRectS2_NS_10ScaleToFitE"]
    pub fn SkMatrix_Rect2Rect(
        src: *const SkRect,
        dst: *const SkRect,
        arg1: SkMatrix_ScaleToFit,
    ) -> __BindgenOpaqueArray<u32, 11usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix10PolyToPolyE6SkSpanIK7SkPointES3_"]
    pub fn SkMatrix_PolyToPoly(
        src: SkSpan<SkPoint>,
        dst: SkSpan<SkPoint>,
    ) -> __BindgenOpaqueArray<u32, 11usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix6invertEv"]
    pub fn SkMatrix_invert(this: *const SkMatrix) -> __BindgenOpaqueArray<u32, 11usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix17SetAffineIdentityEPf"]
    pub fn SkMatrix_SetAffineIdentity(affine: *mut SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix8asAffineEPf"]
    pub fn SkMatrix_asAffine(this: *const SkMatrix, affine: *mut SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix9setAffineEPKf"]
    pub fn SkMatrix_setAffine(this: *mut SkMatrix, affine: *const SkScalar) -> *mut SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix9mapPointsE6SkSpanI7SkPointES0_IKS1_E"]
    pub fn SkMatrix_mapPoints(this: *const SkMatrix, dst: SkSpan<SkPoint>, src: SkSpan<SkPoint>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix20mapHomogeneousPointsE6SkSpanI8SkPoint3ES0_IKS1_E"]
    pub fn SkMatrix_mapHomogeneousPoints(
        this: *const SkMatrix,
        dst: SkSpan<SkPoint3>,
        src: SkSpan<SkPoint3>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix22mapPointsToHomogeneousE6SkSpanI8SkPoint3ES0_IK7SkPointE"]
    pub fn SkMatrix_mapPointsToHomogeneous(
        this: *const SkMatrix,
        dst: SkSpan<SkPoint3>,
        src: SkSpan<SkPoint>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix10mapVectorsE6SkSpanI7SkPointES0_IKS1_E"]
    pub fn SkMatrix_mapVectors(this: *const SkMatrix, dst: SkSpan<SkVector>, src: SkSpan<SkVector>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix7mapRectEP6SkRectRKS0_"]
    pub fn SkMatrix_mapRect(this: *const SkMatrix, dst: *mut SkRect, src: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix21mapRectScaleTranslateEP6SkRectRKS0_"]
    pub fn SkMatrix_mapRectScaleTranslate(
        this: *const SkMatrix,
        dst: *mut SkRect,
        src: *const SkRect,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix9mapRadiusEf"]
    pub fn SkMatrix_mapRadius(this: *const SkMatrix, radius: SkScalar) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix4dumpEv"]
    pub fn SkMatrix_dump(this: *const SkMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix11getMinScaleEv"]
    pub fn SkMatrix_getMinScale(this: *const SkMatrix) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix11getMaxScaleEv"]
    pub fn SkMatrix_getMaxScale(this: *const SkMatrix) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix15getMinMaxScalesEPf"]
    pub fn SkMatrix_getMinMaxScales(this: *const SkMatrix, scaleFactors: *mut SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkMatrix14decomposeScaleEP6SkSizePS_"]
    pub fn SkMatrix_decomposeScale(
        this: *const SkMatrix,
        scale: *mut SkSize,
        remaining: *mut SkMatrix,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix1IEv"]
    pub fn SkMatrix_I() -> *const SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkMatrix13InvalidMatrixEv"]
    pub fn SkMatrix_InvalidMatrix() -> *const SkMatrix;
}
impl SkMatrix {
    #[inline]
    pub unsafe fn ScaleTranslate(sx: f32, sy: f32, tx: f32, ty: f32) -> SkMatrix {
        SkMatrix_ScaleTranslate(sx, sy, tx, ty)
    }
    #[inline]
    pub unsafe fn isSimilarity(&self, tol: SkScalar) -> bool {
        SkMatrix_isSimilarity(self, tol)
    }
    #[inline]
    pub unsafe fn preservesRightAngles(&self, tol: SkScalar) -> bool {
        SkMatrix_preservesRightAngles(self, tol)
    }
    #[inline]
    pub unsafe fn set9(&mut self, buffer: *const SkScalar) -> *mut SkMatrix {
        SkMatrix_set9(self, buffer)
    }
    #[inline]
    pub unsafe fn reset(&mut self) -> *mut SkMatrix {
        SkMatrix_reset(self)
    }
    #[inline]
    pub unsafe fn setTranslate(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkMatrix {
        SkMatrix_setTranslate(self, dx, dy)
    }
    #[inline]
    pub unsafe fn setScale(
        &mut self,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_setScale(self, sx, sy, px, py)
    }
    #[inline]
    pub unsafe fn setScale1(&mut self, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix {
        SkMatrix_setScale1(self, sx, sy)
    }
    #[inline]
    pub unsafe fn setRotate(
        &mut self,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_setRotate(self, degrees, px, py)
    }
    #[inline]
    pub unsafe fn setRotate1(&mut self, degrees: SkScalar) -> *mut SkMatrix {
        SkMatrix_setRotate1(self, degrees)
    }
    #[inline]
    pub unsafe fn setSinCos(
        &mut self,
        sinValue: SkScalar,
        cosValue: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_setSinCos(self, sinValue, cosValue, px, py)
    }
    #[inline]
    pub unsafe fn setSinCos1(&mut self, sinValue: SkScalar, cosValue: SkScalar) -> *mut SkMatrix {
        SkMatrix_setSinCos1(self, sinValue, cosValue)
    }
    #[inline]
    pub unsafe fn setRSXform(&mut self, rsxForm: *const SkRSXform) -> *mut SkMatrix {
        SkMatrix_setRSXform(self, rsxForm)
    }
    #[inline]
    pub unsafe fn setSkew(
        &mut self,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_setSkew(self, kx, ky, px, py)
    }
    #[inline]
    pub unsafe fn setSkew1(&mut self, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix {
        SkMatrix_setSkew1(self, kx, ky)
    }
    #[inline]
    pub unsafe fn setConcat(&mut self, a: *const SkMatrix, b: *const SkMatrix) -> *mut SkMatrix {
        SkMatrix_setConcat(self, a, b)
    }
    #[inline]
    pub unsafe fn preTranslate(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkMatrix {
        SkMatrix_preTranslate(self, dx, dy)
    }
    #[inline]
    pub unsafe fn preScale(
        &mut self,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_preScale(self, sx, sy, px, py)
    }
    #[inline]
    pub unsafe fn preScale1(&mut self, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix {
        SkMatrix_preScale1(self, sx, sy)
    }
    #[inline]
    pub unsafe fn preRotate(
        &mut self,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_preRotate(self, degrees, px, py)
    }
    #[inline]
    pub unsafe fn preRotate1(&mut self, degrees: SkScalar) -> *mut SkMatrix {
        SkMatrix_preRotate1(self, degrees)
    }
    #[inline]
    pub unsafe fn preSkew(
        &mut self,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_preSkew(self, kx, ky, px, py)
    }
    #[inline]
    pub unsafe fn preSkew1(&mut self, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix {
        SkMatrix_preSkew1(self, kx, ky)
    }
    #[inline]
    pub unsafe fn preConcat(&mut self, other: *const SkMatrix) -> *mut SkMatrix {
        SkMatrix_preConcat(self, other)
    }
    #[inline]
    pub unsafe fn postTranslate(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkMatrix {
        SkMatrix_postTranslate(self, dx, dy)
    }
    #[inline]
    pub unsafe fn postScale(
        &mut self,
        sx: SkScalar,
        sy: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_postScale(self, sx, sy, px, py)
    }
    #[inline]
    pub unsafe fn postScale1(&mut self, sx: SkScalar, sy: SkScalar) -> *mut SkMatrix {
        SkMatrix_postScale1(self, sx, sy)
    }
    #[inline]
    pub unsafe fn postRotate(
        &mut self,
        degrees: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_postRotate(self, degrees, px, py)
    }
    #[inline]
    pub unsafe fn postRotate1(&mut self, degrees: SkScalar) -> *mut SkMatrix {
        SkMatrix_postRotate1(self, degrees)
    }
    #[inline]
    pub unsafe fn postSkew(
        &mut self,
        kx: SkScalar,
        ky: SkScalar,
        px: SkScalar,
        py: SkScalar,
    ) -> *mut SkMatrix {
        SkMatrix_postSkew(self, kx, ky, px, py)
    }
    #[inline]
    pub unsafe fn postSkew1(&mut self, kx: SkScalar, ky: SkScalar) -> *mut SkMatrix {
        SkMatrix_postSkew1(self, kx, ky)
    }
    #[inline]
    pub unsafe fn postConcat(&mut self, other: *const SkMatrix) -> *mut SkMatrix {
        SkMatrix_postConcat(self, other)
    }
    #[inline]
    pub unsafe fn Rect2Rect(
        src: *const SkRect,
        dst: *const SkRect,
        arg1: SkMatrix_ScaleToFit,
    ) -> __BindgenOpaqueArray<u32, 11usize> {
        SkMatrix_Rect2Rect(src, dst, arg1)
    }
    #[inline]
    pub unsafe fn PolyToPoly(
        src: SkSpan<SkPoint>,
        dst: SkSpan<SkPoint>,
    ) -> __BindgenOpaqueArray<u32, 11usize> {
        SkMatrix_PolyToPoly(src, dst)
    }
    #[inline]
    pub unsafe fn invert(&self) -> __BindgenOpaqueArray<u32, 11usize> {
        SkMatrix_invert(self)
    }
    #[inline]
    pub unsafe fn SetAffineIdentity(affine: *mut SkScalar) {
        SkMatrix_SetAffineIdentity(affine)
    }
    #[inline]
    pub unsafe fn asAffine(&self, affine: *mut SkScalar) -> bool {
        SkMatrix_asAffine(self, affine)
    }
    #[inline]
    pub unsafe fn setAffine(&mut self, affine: *const SkScalar) -> *mut SkMatrix {
        SkMatrix_setAffine(self, affine)
    }
    #[inline]
    pub unsafe fn mapPoints(&self, dst: SkSpan<SkPoint>, src: SkSpan<SkPoint>) {
        SkMatrix_mapPoints(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapHomogeneousPoints(&self, dst: SkSpan<SkPoint3>, src: SkSpan<SkPoint3>) {
        SkMatrix_mapHomogeneousPoints(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapPointsToHomogeneous(&self, dst: SkSpan<SkPoint3>, src: SkSpan<SkPoint>) {
        SkMatrix_mapPointsToHomogeneous(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapVectors(&self, dst: SkSpan<SkVector>, src: SkSpan<SkVector>) {
        SkMatrix_mapVectors(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapRect(&self, dst: *mut SkRect, src: *const SkRect) -> bool {
        SkMatrix_mapRect(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapRectScaleTranslate(&self, dst: *mut SkRect, src: *const SkRect) {
        SkMatrix_mapRectScaleTranslate(self, dst, src)
    }
    #[inline]
    pub unsafe fn mapRadius(&self, radius: SkScalar) -> SkScalar {
        SkMatrix_mapRadius(self, radius)
    }
    #[inline]
    pub unsafe fn dump(&self) {
        SkMatrix_dump(self)
    }
    #[inline]
    pub unsafe fn getMinScale(&self) -> SkScalar {
        SkMatrix_getMinScale(self)
    }
    #[inline]
    pub unsafe fn getMaxScale(&self) -> SkScalar {
        SkMatrix_getMaxScale(self)
    }
    #[inline]
    pub unsafe fn getMinMaxScales(&self, scaleFactors: *mut SkScalar) -> bool {
        SkMatrix_getMinMaxScales(self, scaleFactors)
    }
    #[inline]
    pub unsafe fn decomposeScale(&self, scale: *mut SkSize, remaining: *mut SkMatrix) -> bool {
        SkMatrix_decomposeScale(self, scale, remaining)
    }
    #[inline]
    pub unsafe fn I() -> *const SkMatrix {
        SkMatrix_I()
    }
    #[inline]
    pub unsafe fn InvalidMatrix() -> *const SkMatrix {
        SkMatrix_InvalidMatrix()
    }
}
impl SkEncodedOrigin {
    pub const Default: SkEncodedOrigin = SkEncodedOrigin::TopLeft;
}
impl SkEncodedOrigin {
    pub const Last: SkEncodedOrigin = SkEncodedOrigin::LeftBottom;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkEncodedOrigin {
    TopLeft = 1,
    TopRight = 2,
    BottomRight = 3,
    BottomLeft = 4,
    LeftTop = 5,
    RightTop = 6,
    RightBottom = 7,
    LeftBottom = 8,
}
impl SkAlphaType {
    pub const LastEnum: SkAlphaType = SkAlphaType::Unpremul;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkAlphaType {
    Unknown = 0,
    Opaque = 1,
    Premul = 2,
    Unpremul = 3,
}
impl SkColorType {
    pub const kLastEnum_SkColorType: SkColorType = SkColorType::kR8_unorm_SkColorType;
}
impl SkColorType {
    pub const kN32_SkColorType: SkColorType = SkColorType::kBGRA_8888_SkColorType;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkColorType {
    kUnknown_SkColorType = 0,
    kAlpha_8_SkColorType = 1,
    kRGB_565_SkColorType = 2,
    kARGB_4444_SkColorType = 3,
    kRGBA_8888_SkColorType = 4,
    kRGB_888x_SkColorType = 5,
    kBGRA_8888_SkColorType = 6,
    kRGBA_1010102_SkColorType = 7,
    kBGRA_1010102_SkColorType = 8,
    kRGB_101010x_SkColorType = 9,
    kBGR_101010x_SkColorType = 10,
    kBGR_101010x_XR_SkColorType = 11,
    kBGRA_10101010_XR_SkColorType = 12,
    kRGBA_10x6_SkColorType = 13,
    kGray_8_SkColorType = 14,
    kRGBA_F16Norm_SkColorType = 15,
    kRGBA_F16_SkColorType = 16,
    kRGB_F16F16F16x_SkColorType = 17,
    kRGBA_F32_SkColorType = 18,
    kR8G8_unorm_SkColorType = 19,
    kA16_float_SkColorType = 20,
    kR16G16_float_SkColorType = 21,
    kA16_unorm_SkColorType = 22,
    kR16G16_unorm_SkColorType = 23,
    kR16G16B16A16_unorm_SkColorType = 24,
    kSRGBA_8888_SkColorType = 25,
    kR8_unorm_SkColorType = 26,
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z24SkColorTypeBytesPerPixel11SkColorType"]
    pub fn SkColorTypeBytesPerPixel(ct: SkColorType) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z25SkColorTypeIsAlwaysOpaque11SkColorType"]
    pub fn SkColorTypeIsAlwaysOpaque(ct: SkColorType) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z28SkColorTypeValidateAlphaType11SkColorType11SkAlphaTypePS0_"]
    pub fn SkColorTypeValidateAlphaType(
        colorType: SkColorType,
        alphaType: SkAlphaType,
        canonical: *mut SkAlphaType,
    ) -> bool;
}
impl SkYUVColorSpace {
    pub const LastEnum: SkYUVColorSpace = SkYUVColorSpace::Identity;
}
impl SkYUVColorSpace {
    pub const JPEG: SkYUVColorSpace = SkYUVColorSpace::JPEG_Full;
}
impl SkYUVColorSpace {
    pub const Rec601: SkYUVColorSpace = SkYUVColorSpace::Rec601_Limited;
}
impl SkYUVColorSpace {
    pub const Rec709: SkYUVColorSpace = SkYUVColorSpace::Rec709_Limited;
}
impl SkYUVColorSpace {
    pub const BT2020: SkYUVColorSpace = SkYUVColorSpace::BT2020_8bit_Limited;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVColorSpace {
    JPEG_Full = 0,
    Rec601_Limited = 1,
    Rec709_Full = 2,
    Rec709_Limited = 3,
    BT2020_8bit_Full = 4,
    BT2020_8bit_Limited = 5,
    BT2020_10bit_Full = 6,
    BT2020_10bit_Limited = 7,
    BT2020_12bit_Full = 8,
    BT2020_12bit_Limited = 9,
    BT2020_16bit_Full = 10,
    BT2020_16bit_Limited = 11,
    FCC_Full = 12,
    FCC_Limited = 13,
    SMPTE240_Full = 14,
    SMPTE240_Limited = 15,
    YDZDX_Full = 16,
    YDZDX_Limited = 17,
    GBR_Full = 18,
    GBR_Limited = 19,
    YCgCo_8bit_Full = 20,
    YCgCo_8bit_Limited = 21,
    YCgCo_10bit_Full = 22,
    YCgCo_10bit_Limited = 23,
    YCgCo_12bit_Full = 24,
    YCgCo_12bit_Limited = 25,
    YCgCo_16bit_Full = 26,
    YCgCo_16bit_Limited = 27,
    Identity = 28,
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z29SkYUVColorSpaceIsLimitedRange15SkYUVColorSpace"]
    pub fn SkYUVColorSpaceIsLimitedRange(cs: SkYUVColorSpace) -> bool;
}
#[repr(C)]
#[derive(Debug)]
pub struct SkColorInfo {
    pub fColorSpace: sk_sp<SkColorSpace>,
    pub fColorType: SkColorType,
    pub fAlphaType: SkAlphaType,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorInfo"][::core::mem::size_of::<SkColorInfo>() - 16usize];
    ["Alignment of SkColorInfo"][::core::mem::align_of::<SkColorInfo>() - 8usize];
    ["Offset of field: SkColorInfo::fColorSpace"]
        [::core::mem::offset_of!(SkColorInfo, fColorSpace) - 0usize];
    ["Offset of field: SkColorInfo::fColorType"]
        [::core::mem::offset_of!(SkColorInfo, fColorType) - 8usize];
    ["Offset of field: SkColorInfo::fAlphaType"]
        [::core::mem::offset_of!(SkColorInfo, fAlphaType) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo10colorSpaceEv"]
    pub fn SkColorInfo_colorSpace(this: *const SkColorInfo) -> *mut SkColorSpace;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo13refColorSpaceEv"]
    pub fn SkColorInfo_refColorSpace(this: *const SkColorInfo) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo16gammaCloseToSRGBEv"]
    pub fn SkColorInfo_gammaCloseToSRGB(this: *const SkColorInfo) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo13makeAlphaTypeE11SkAlphaType"]
    pub fn SkColorInfo_makeAlphaType(
        this: *const SkColorInfo,
        newAlphaType: SkAlphaType,
    ) -> SkColorInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo13makeColorTypeE11SkColorType"]
    pub fn SkColorInfo_makeColorType(
        this: *const SkColorInfo,
        newColorType: SkColorType,
    ) -> SkColorInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo14makeColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkColorInfo_makeColorSpace(
        this: *const SkColorInfo,
        cs: sk_sp<SkColorSpace>,
    ) -> SkColorInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo13bytesPerPixelEv"]
    pub fn SkColorInfo_bytesPerPixel(this: *const SkColorInfo) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkColorInfo13shiftPerPixelEv"]
    pub fn SkColorInfo_shiftPerPixel(this: *const SkColorInfo) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkColorInfoC1Ev"]
    pub fn SkColorInfo_SkColorInfo(this: *mut SkColorInfo);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkColorInfoC1E11SkColorType11SkAlphaType5sk_spI12SkColorSpaceE"]
    pub fn SkColorInfo_SkColorInfo1(
        this: *mut SkColorInfo,
        ct: SkColorType,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkColorInfoC1ERKS_"]
    pub fn SkColorInfo_SkColorInfo2(this: *mut SkColorInfo, arg1: *const SkColorInfo);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkColorInfoC1EOS_"]
    pub fn SkColorInfo_SkColorInfo3(this: *mut SkColorInfo, arg1: *mut SkColorInfo);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkColorInfoD1Ev"]
    pub fn SkColorInfo_SkColorInfo_destructor(this: *mut SkColorInfo);
}
impl SkColorInfo {
    #[inline]
    pub unsafe fn colorSpace(&self) -> *mut SkColorSpace {
        SkColorInfo_colorSpace(self)
    }
    #[inline]
    pub unsafe fn refColorSpace(&self) -> sk_sp<SkColorSpace> {
        SkColorInfo_refColorSpace(self)
    }
    #[inline]
    pub unsafe fn gammaCloseToSRGB(&self) -> bool {
        SkColorInfo_gammaCloseToSRGB(self)
    }
    #[inline]
    pub unsafe fn makeAlphaType(&self, newAlphaType: SkAlphaType) -> SkColorInfo {
        SkColorInfo_makeAlphaType(self, newAlphaType)
    }
    #[inline]
    pub unsafe fn makeColorType(&self, newColorType: SkColorType) -> SkColorInfo {
        SkColorInfo_makeColorType(self, newColorType)
    }
    #[inline]
    pub unsafe fn makeColorSpace(&self, cs: sk_sp<SkColorSpace>) -> SkColorInfo {
        SkColorInfo_makeColorSpace(self, cs)
    }
    #[inline]
    pub unsafe fn bytesPerPixel(&self) -> ::core::ffi::c_int {
        SkColorInfo_bytesPerPixel(self)
    }
    #[inline]
    pub unsafe fn shiftPerPixel(&self) -> ::core::ffi::c_int {
        SkColorInfo_shiftPerPixel(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkColorInfo_SkColorInfo(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(ct: SkColorType, at: SkAlphaType, cs: sk_sp<SkColorSpace>) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkColorInfo_SkColorInfo1(__bindgen_tmp.as_mut_ptr(), ct, at, cs);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(arg1: *const SkColorInfo) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkColorInfo_SkColorInfo2(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(arg1: *mut SkColorInfo) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkColorInfo_SkColorInfo3(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkColorInfo_SkColorInfo_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkImageInfo {
    pub fColorInfo: SkColorInfo,
    pub fDimensions: SkISize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImageInfo"][::core::mem::size_of::<SkImageInfo>() - 24usize];
    ["Alignment of SkImageInfo"][::core::mem::align_of::<SkImageInfo>() - 8usize];
    ["Offset of field: SkImageInfo::fColorInfo"]
        [::core::mem::offset_of!(SkImageInfo, fColorInfo) - 0usize];
    ["Offset of field: SkImageInfo::fDimensions"]
        [::core::mem::offset_of!(SkImageInfo, fDimensions) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo4MakeEii11SkColorType11SkAlphaType"]
    pub fn SkImageInfo_Make(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        ct: SkColorType,
        at: SkAlphaType,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo4MakeEii11SkColorType11SkAlphaType5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_Make1(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        ct: SkColorType,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo4MakeE7SkISize11SkColorType11SkAlphaType"]
    pub fn SkImageInfo_Make2(dimensions: SkISize, ct: SkColorType, at: SkAlphaType) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo4MakeE7SkISize11SkColorType11SkAlphaType5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_Make3(
        dimensions: SkISize,
        ct: SkColorType,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo7MakeN32Eii11SkAlphaType"]
    pub fn SkImageInfo_MakeN32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo7MakeN32Eii11SkAlphaType5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_MakeN321(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo7MakeS32Eii11SkAlphaType"]
    pub fn SkImageInfo_MakeS32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo13MakeN32PremulEii"]
    pub fn SkImageInfo_MakeN32Premul(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo13MakeN32PremulEii5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_MakeN32Premul1(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo13MakeN32PremulE7SkISize"]
    pub fn SkImageInfo_MakeN32Premul2(dimensions: SkISize) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo13MakeN32PremulE7SkISize5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_MakeN32Premul3(dimensions: SkISize, cs: sk_sp<SkColorSpace>) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo6MakeA8Eii"]
    pub fn SkImageInfo_MakeA8(width: ::core::ffi::c_int, height: ::core::ffi::c_int)
    -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo6MakeA8E7SkISize"]
    pub fn SkImageInfo_MakeA81(dimensions: SkISize) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkImageInfo11MakeUnknownEii"]
    pub fn SkImageInfo_MakeUnknown(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkImageInfo10colorSpaceEv"]
    pub fn SkImageInfo_colorSpace(this: *const SkImageInfo) -> *mut SkColorSpace;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkImageInfo13refColorSpaceEv"]
    pub fn SkImageInfo_refColorSpace(this: *const SkImageInfo) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkImageInfo14makeColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkImageInfo_makeColorSpace(
        this: *const SkImageInfo,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkImageInfo13computeOffsetEiim"]
    pub fn SkImageInfo_computeOffset(
        this: *const SkImageInfo,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
        rowBytes: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkImageInfo15computeByteSizeEm"]
    pub fn SkImageInfo_computeByteSize(this: *const SkImageInfo, rowBytes: usize) -> usize;
}
impl SkImageInfo {
    #[inline]
    pub unsafe fn Make(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        ct: SkColorType,
        at: SkAlphaType,
    ) -> SkImageInfo {
        SkImageInfo_Make(width, height, ct, at)
    }
    #[inline]
    pub unsafe fn Make1(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        ct: SkColorType,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo {
        SkImageInfo_Make1(width, height, ct, at, cs)
    }
    #[inline]
    pub unsafe fn Make2(dimensions: SkISize, ct: SkColorType, at: SkAlphaType) -> SkImageInfo {
        SkImageInfo_Make2(dimensions, ct, at)
    }
    #[inline]
    pub unsafe fn Make3(
        dimensions: SkISize,
        ct: SkColorType,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo {
        SkImageInfo_Make3(dimensions, ct, at, cs)
    }
    #[inline]
    pub unsafe fn MakeN32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
    ) -> SkImageInfo {
        SkImageInfo_MakeN32(width, height, at)
    }
    #[inline]
    pub unsafe fn MakeN321(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo {
        SkImageInfo_MakeN321(width, height, at, cs)
    }
    #[inline]
    pub unsafe fn MakeS32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
    ) -> SkImageInfo {
        SkImageInfo_MakeS32(width, height, at)
    }
    #[inline]
    pub unsafe fn MakeN32Premul(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> SkImageInfo {
        SkImageInfo_MakeN32Premul(width, height)
    }
    #[inline]
    pub unsafe fn MakeN32Premul1(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        cs: sk_sp<SkColorSpace>,
    ) -> SkImageInfo {
        SkImageInfo_MakeN32Premul1(width, height, cs)
    }
    #[inline]
    pub unsafe fn MakeN32Premul2(dimensions: SkISize) -> SkImageInfo {
        SkImageInfo_MakeN32Premul2(dimensions)
    }
    #[inline]
    pub unsafe fn MakeN32Premul3(dimensions: SkISize, cs: sk_sp<SkColorSpace>) -> SkImageInfo {
        SkImageInfo_MakeN32Premul3(dimensions, cs)
    }
    #[inline]
    pub unsafe fn MakeA8(width: ::core::ffi::c_int, height: ::core::ffi::c_int) -> SkImageInfo {
        SkImageInfo_MakeA8(width, height)
    }
    #[inline]
    pub unsafe fn MakeA81(dimensions: SkISize) -> SkImageInfo {
        SkImageInfo_MakeA81(dimensions)
    }
    #[inline]
    pub unsafe fn MakeUnknown(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> SkImageInfo {
        SkImageInfo_MakeUnknown(width, height)
    }
    #[inline]
    pub unsafe fn colorSpace(&self) -> *mut SkColorSpace {
        SkImageInfo_colorSpace(self)
    }
    #[inline]
    pub unsafe fn refColorSpace(&self) -> sk_sp<SkColorSpace> {
        SkImageInfo_refColorSpace(self)
    }
    #[inline]
    pub unsafe fn makeColorSpace(&self, cs: sk_sp<SkColorSpace>) -> SkImageInfo {
        SkImageInfo_makeColorSpace(self, cs)
    }
    #[inline]
    pub unsafe fn computeOffset(
        &self,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
        rowBytes: usize,
    ) -> usize {
        SkImageInfo_computeOffset(self, x, y, rowBytes)
    }
    #[inline]
    pub unsafe fn computeByteSize(&self, rowBytes: usize) -> usize {
        SkImageInfo_computeByteSize(self, rowBytes)
    }
}
pub type SkColor = u32;
pub const SK_ColorTRANSPARENT: SkColor = 0;
pub const SK_ColorBLACK: SkColor = 4278190080;
pub const SK_ColorDKGRAY: SkColor = 4282664004;
pub const SK_ColorGRAY: SkColor = 4287137928;
pub const SK_ColorLTGRAY: SkColor = 4291611852;
pub const SK_ColorWHITE: SkColor = 4294967295;
pub const SK_ColorRED: SkColor = 4294901760;
pub const SK_ColorGREEN: SkColor = 4278255360;
pub const SK_ColorBLUE: SkColor = 4278190335;
pub const SK_ColorYELLOW: SkColor = 4294967040;
pub const SK_ColorCYAN: SkColor = 4278255615;
pub const SK_ColorMAGENTA: SkColor = 4294902015;
unsafe extern "C" {
    #[link_name = "\u{1}_Z10SkRGBToHSVjjjPf"]
    pub fn SkRGBToHSV(red: U8CPU, green: U8CPU, blue: U8CPU, hsv: *mut SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z12SkHSVToColorjPKf"]
    pub fn SkHSVToColor(alpha: U8CPU, hsv: *const SkScalar) -> SkColor;
}
pub type SkPMColor = u32;
unsafe extern "C" {
    #[link_name = "\u{1}_Z17SkPreMultiplyARGBjjjj"]
    pub fn SkPreMultiplyARGB(a: U8CPU, r: U8CPU, g: U8CPU, b: U8CPU) -> SkPMColor;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z18SkPreMultiplyColorj"]
    pub fn SkPreMultiplyColor(c: SkColor) -> SkPMColor;
}
impl SkColorChannel {
    pub const LastEnum: SkColorChannel = SkColorChannel::A;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkColorChannel {
    R = 0,
    G = 1,
    B = 2,
    A = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkColorChannelFlag {
    kRed_SkColorChannelFlag = 1,
    kGreen_SkColorChannelFlag = 2,
    kBlue_SkColorChannelFlag = 4,
    kAlpha_SkColorChannelFlag = 8,
    kGray_SkColorChannelFlag = 16,
    kGrayAlpha_SkColorChannelFlags = 24,
    kRG_SkColorChannelFlags = 3,
    kRGB_SkColorChannelFlags = 7,
    kRGBA_SkColorChannelFlags = 15,
}
unsafe extern "C" {
    #[link_name = "\u{1}FromColor"]
    pub fn SkRGBA4f_FromColor(color: SkColor) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}toSkColor"]
    pub fn SkRGBA4f_toSkColor(this: *const u8) -> SkColor;
}
unsafe extern "C" {
    #[link_name = "\u{1}FromPMColor"]
    pub fn SkRGBA4f_FromPMColor(arg1: SkPMColor) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}toBytes_RGBA"]
    pub fn SkRGBA4f_toBytes_RGBA(this: *const u8) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}FromBytes_RGBA"]
    pub fn SkRGBA4f_FromBytes_RGBA(color: u32) -> u8;
}
pub type SkColor4f = __BindgenOpaqueArray<u32, 4usize>;
impl SkFilterMode {
    pub const Last: SkFilterMode = SkFilterMode::Linear;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFilterMode {
    Nearest = 0,
    Linear = 1,
}
impl SkMipmapMode {
    pub const Last: SkMipmapMode = SkMipmapMode::Linear;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkMipmapMode {
    None = 0,
    Nearest = 1,
    Linear = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCubicResampler {
    pub B: f32,
    pub C: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCubicResampler"][::core::mem::size_of::<SkCubicResampler>() - 8usize];
    ["Alignment of SkCubicResampler"][::core::mem::align_of::<SkCubicResampler>() - 4usize];
    ["Offset of field: SkCubicResampler::B"][::core::mem::offset_of!(SkCubicResampler, B) - 0usize];
    ["Offset of field: SkCubicResampler::C"][::core::mem::offset_of!(SkCubicResampler, C) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSamplingOptions {
    pub maxAniso: ::core::ffi::c_int,
    pub useCubic: bool,
    pub cubic: SkCubicResampler,
    pub filter: SkFilterMode,
    pub mipmap: SkMipmapMode,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSamplingOptions"][::core::mem::size_of::<SkSamplingOptions>() - 24usize];
    ["Alignment of SkSamplingOptions"][::core::mem::align_of::<SkSamplingOptions>() - 4usize];
    ["Offset of field: SkSamplingOptions::maxAniso"]
        [::core::mem::offset_of!(SkSamplingOptions, maxAniso) - 0usize];
    ["Offset of field: SkSamplingOptions::useCubic"]
        [::core::mem::offset_of!(SkSamplingOptions, useCubic) - 4usize];
    ["Offset of field: SkSamplingOptions::cubic"]
        [::core::mem::offset_of!(SkSamplingOptions, cubic) - 8usize];
    ["Offset of field: SkSamplingOptions::filter"]
        [::core::mem::offset_of!(SkSamplingOptions, filter) - 16usize];
    ["Offset of field: SkSamplingOptions::mipmap"]
        [::core::mem::offset_of!(SkSamplingOptions, mipmap) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkMask {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct SkPixmap {
    pub fPixels: *const ::core::ffi::c_void,
    pub fRowBytes: usize,
    pub fInfo: SkImageInfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPixmap"][::core::mem::size_of::<SkPixmap>() - 40usize];
    ["Alignment of SkPixmap"][::core::mem::align_of::<SkPixmap>() - 8usize];
    ["Offset of field: SkPixmap::fPixels"][::core::mem::offset_of!(SkPixmap, fPixels) - 0usize];
    ["Offset of field: SkPixmap::fRowBytes"][::core::mem::offset_of!(SkPixmap, fRowBytes) - 8usize];
    ["Offset of field: SkPixmap::fInfo"][::core::mem::offset_of!(SkPixmap, fInfo) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPixmap5resetEv"]
    pub fn SkPixmap_reset(this: *mut SkPixmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPixmap5resetERK11SkImageInfoPKvm"]
    pub fn SkPixmap_reset1(
        this: *mut SkPixmap,
        info: *const SkImageInfo,
        addr: *const ::core::ffi::c_void,
        rowBytes: usize,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPixmap13setColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkPixmap_setColorSpace(this: *mut SkPixmap, colorSpace: sk_sp<SkColorSpace>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkPixmap5resetERK6SkMask"]
    pub fn SkPixmap_reset2(this: *mut SkPixmap, mask: *const SkMask) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap13extractSubsetEPS_RK7SkIRect"]
    pub fn SkPixmap_extractSubset(
        this: *const SkPixmap,
        subset: *mut SkPixmap,
        area: *const SkIRect,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap10colorSpaceEv"]
    pub fn SkPixmap_colorSpace(this: *const SkPixmap) -> *mut SkColorSpace;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap13refColorSpaceEv"]
    pub fn SkPixmap_refColorSpace(this: *const SkPixmap) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap15computeIsOpaqueEv"]
    pub fn SkPixmap_computeIsOpaque(this: *const SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap8getColorEii"]
    pub fn SkPixmap_getColor(
        this: *const SkPixmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> SkColor;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap10getColor4fEii"]
    pub fn SkPixmap_getColor4f(
        this: *const SkPixmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> SkColor4f;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap9getAlphafEii"]
    pub fn SkPixmap_getAlphaf(
        this: *const SkPixmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> f32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap10readPixelsERK11SkImageInfoPvmii"]
    pub fn SkPixmap_readPixels(
        this: *const SkPixmap,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap11scalePixelsERKS_RK17SkSamplingOptions"]
    pub fn SkPixmap_scalePixels(
        this: *const SkPixmap,
        dst: *const SkPixmap,
        arg1: *const SkSamplingOptions,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap5eraseEjRK7SkIRect"]
    pub fn SkPixmap_erase(this: *const SkPixmap, color: SkColor, subset: *const SkIRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkPixmap5eraseERK8SkRGBA4fIL11SkAlphaType3EEPK7SkIRect"]
    pub fn SkPixmap_erase1(
        this: *const SkPixmap,
        color: *const SkColor4f,
        subset: *const SkIRect,
    ) -> bool;
}
impl SkPixmap {
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkPixmap_reset(self)
    }
    #[inline]
    pub unsafe fn reset1(
        &mut self,
        info: *const SkImageInfo,
        addr: *const ::core::ffi::c_void,
        rowBytes: usize,
    ) {
        SkPixmap_reset1(self, info, addr, rowBytes)
    }
    #[inline]
    pub unsafe fn setColorSpace(&mut self, colorSpace: sk_sp<SkColorSpace>) {
        SkPixmap_setColorSpace(self, colorSpace)
    }
    #[inline]
    pub unsafe fn reset2(&mut self, mask: *const SkMask) -> bool {
        SkPixmap_reset2(self, mask)
    }
    #[inline]
    pub unsafe fn extractSubset(&self, subset: *mut SkPixmap, area: *const SkIRect) -> bool {
        SkPixmap_extractSubset(self, subset, area)
    }
    #[inline]
    pub unsafe fn colorSpace(&self) -> *mut SkColorSpace {
        SkPixmap_colorSpace(self)
    }
    #[inline]
    pub unsafe fn refColorSpace(&self) -> sk_sp<SkColorSpace> {
        SkPixmap_refColorSpace(self)
    }
    #[inline]
    pub unsafe fn computeIsOpaque(&self) -> bool {
        SkPixmap_computeIsOpaque(self)
    }
    #[inline]
    pub unsafe fn getColor(&self, x: ::core::ffi::c_int, y: ::core::ffi::c_int) -> SkColor {
        SkPixmap_getColor(self, x, y)
    }
    #[inline]
    pub unsafe fn getColor4f(&self, x: ::core::ffi::c_int, y: ::core::ffi::c_int) -> SkColor4f {
        SkPixmap_getColor4f(self, x, y)
    }
    #[inline]
    pub unsafe fn getAlphaf(&self, x: ::core::ffi::c_int, y: ::core::ffi::c_int) -> f32 {
        SkPixmap_getAlphaf(self, x, y)
    }
    #[inline]
    pub unsafe fn readPixels(
        &self,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkPixmap_readPixels(self, dstInfo, dstPixels, dstRowBytes, srcX, srcY)
    }
    #[inline]
    pub unsafe fn scalePixels(&self, dst: *const SkPixmap, arg1: *const SkSamplingOptions) -> bool {
        SkPixmap_scalePixels(self, dst, arg1)
    }
    #[inline]
    pub unsafe fn erase(&self, color: SkColor, subset: *const SkIRect) -> bool {
        SkPixmap_erase(self, color, subset)
    }
    #[inline]
    pub unsafe fn erase1(&self, color: *const SkColor4f, subset: *const SkIRect) -> bool {
        SkPixmap_erase1(self, color, subset)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkData {
    pub _base: SkNVRefCnt,
    pub fReleaseProc: SkData_ReleaseProc,
    pub fReleaseProcContext: *mut ::core::ffi::c_void,
    pub fSpan: SkSpan<std_byte>,
}
pub type SkData_ReleaseProc = ::core::option::Option<
    unsafe extern "C" fn(ptr: *const ::core::ffi::c_void, context: *mut ::core::ffi::c_void),
>;
pub type SkData_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkData"][::core::mem::size_of::<SkData>() - 40usize];
    ["Alignment of SkData"][::core::mem::align_of::<SkData>() - 8usize];
    ["Offset of field: SkData::fReleaseProc"]
        [::core::mem::offset_of!(SkData, fReleaseProc) - 8usize];
    ["Offset of field: SkData::fReleaseProcContext"]
        [::core::mem::offset_of!(SkData, fReleaseProcContext) - 16usize];
    ["Offset of field: SkData::fSpan"][::core::mem::offset_of!(SkData, fSpan) - 24usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkData10copySubsetEmm"]
    pub fn SkData_copySubset(this: *const SkData, offset: usize, length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData11shareSubsetEmm"]
    pub fn SkData_shareSubset(this: *mut SkData, offset: usize, length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkData9copyRangeEmmPv"]
    pub fn SkData_copyRange(
        this: *const SkData,
        offset: usize,
        length: usize,
        buffer: *mut ::core::ffi::c_void,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData12MakeWithCopyEPKvm"]
    pub fn SkData_MakeWithCopy(data: *const ::core::ffi::c_void, length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData17MakeUninitializedEm"]
    pub fn SkData_MakeUninitialized(length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData19MakeZeroInitializedEm"]
    pub fn SkData_MakeZeroInitialized(length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData15MakeWithCStringEPKc"]
    pub fn SkData_MakeWithCString(cstr: *const ::core::ffi::c_char) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData12MakeWithProcEPKvmPFvS1_PvES2_"]
    pub fn SkData_MakeWithProc(
        ptr: *const ::core::ffi::c_void,
        length: usize,
        proc_: SkData_ReleaseProc,
        ctx: *mut ::core::ffi::c_void,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData14MakeFromMallocEPKvm"]
    pub fn SkData_MakeFromMalloc(data: *const ::core::ffi::c_void, length: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData16MakeFromFileNameEPKc"]
    pub fn SkData_MakeFromFileName(path: *const ::core::ffi::c_char) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData12MakeFromFILEEP8_IO_FILE"]
    pub fn SkData_MakeFromFILE(f: *mut FILE) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData10MakeFromFDEi"]
    pub fn SkData_MakeFromFD(fd: ::core::ffi::c_int) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData14MakeFromStreamEP8SkStreamm"]
    pub fn SkData_MakeFromStream(arg1: *mut SkStream, size: usize) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkData9MakeEmptyEv"]
    pub fn SkData_MakeEmpty() -> sk_sp<SkData>;
}
impl SkData {
    #[inline]
    pub unsafe fn copySubset(&self, offset: usize, length: usize) -> sk_sp<SkData> {
        SkData_copySubset(self, offset, length)
    }
    #[inline]
    pub unsafe fn shareSubset(&mut self, offset: usize, length: usize) -> sk_sp<SkData> {
        SkData_shareSubset(self, offset, length)
    }
    #[inline]
    pub unsafe fn copyRange(
        &self,
        offset: usize,
        length: usize,
        buffer: *mut ::core::ffi::c_void,
    ) -> usize {
        SkData_copyRange(self, offset, length, buffer)
    }
    #[inline]
    pub unsafe fn MakeWithCopy(data: *const ::core::ffi::c_void, length: usize) -> sk_sp<SkData> {
        SkData_MakeWithCopy(data, length)
    }
    #[inline]
    pub unsafe fn MakeUninitialized(length: usize) -> sk_sp<SkData> {
        SkData_MakeUninitialized(length)
    }
    #[inline]
    pub unsafe fn MakeZeroInitialized(length: usize) -> sk_sp<SkData> {
        SkData_MakeZeroInitialized(length)
    }
    #[inline]
    pub unsafe fn MakeWithCString(cstr: *const ::core::ffi::c_char) -> sk_sp<SkData> {
        SkData_MakeWithCString(cstr)
    }
    #[inline]
    pub unsafe fn MakeWithProc(
        ptr: *const ::core::ffi::c_void,
        length: usize,
        proc_: SkData_ReleaseProc,
        ctx: *mut ::core::ffi::c_void,
    ) -> sk_sp<SkData> {
        SkData_MakeWithProc(ptr, length, proc_, ctx)
    }
    #[inline]
    pub unsafe fn MakeFromMalloc(data: *const ::core::ffi::c_void, length: usize) -> sk_sp<SkData> {
        SkData_MakeFromMalloc(data, length)
    }
    #[inline]
    pub unsafe fn MakeFromFileName(path: *const ::core::ffi::c_char) -> sk_sp<SkData> {
        SkData_MakeFromFileName(path)
    }
    #[inline]
    pub unsafe fn MakeFromFILE(f: *mut FILE) -> sk_sp<SkData> {
        SkData_MakeFromFILE(f)
    }
    #[inline]
    pub unsafe fn MakeFromFD(fd: ::core::ffi::c_int) -> sk_sp<SkData> {
        SkData_MakeFromFD(fd)
    }
    #[inline]
    pub unsafe fn MakeFromStream(arg1: *mut SkStream, size: usize) -> sk_sp<SkData> {
        SkData_MakeFromStream(arg1, size)
    }
    #[inline]
    pub unsafe fn MakeEmpty() -> sk_sp<SkData> {
        SkData_MakeEmpty()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkYUVAInfo {
    pub fDimensions: SkISize,
    pub fPlaneConfig: SkYUVAInfo_PlaneConfig,
    pub fSubsampling: SkYUVAInfo_Subsampling,
    pub fYUVColorSpace: SkYUVColorSpace,
    pub fOrigin: SkEncodedOrigin,
    pub fSitingX: SkYUVAInfo_Siting,
    pub fSitingY: SkYUVAInfo_Siting,
}
impl SkYUVAInfo_YUVAChannels {
    pub const kLast: SkYUVAInfo_YUVAChannels = SkYUVAInfo_YUVAChannels::kA;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVAInfo_YUVAChannels {
    kY = 0,
    kU = 1,
    kV = 2,
    kA = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkYUVAInfo_YUVALocation {
    _unused: [u8; 0],
}
pub type SkYUVAInfo_YUVALocations = u8;
impl SkYUVAInfo_PlaneConfig {
    pub const Last: SkYUVAInfo_PlaneConfig = SkYUVAInfo_PlaneConfig::UYVA;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVAInfo_PlaneConfig {
    Unknown = 0,
    Y_U_V = 1,
    Y_V_U = 2,
    Y_UV = 3,
    Y_VU = 4,
    YUV = 5,
    UYV = 6,
    Y_U_V_A = 7,
    Y_V_U_A = 8,
    Y_UV_A = 9,
    Y_VU_A = 10,
    YUVA = 11,
    UYVA = 12,
}
impl SkYUVAInfo_Subsampling {
    pub const kLast: SkYUVAInfo_Subsampling = SkYUVAInfo_Subsampling::k410;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVAInfo_Subsampling {
    kUnknown = 0,
    k444 = 1,
    k422 = 2,
    k420 = 3,
    k440 = 4,
    k411 = 5,
    k410 = 6,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVAInfo_Siting {
    Centered = 0,
}
pub const SkYUVAInfo_kYUVAChannelCount: ::core::ffi::c_int = 4;
pub const SkYUVAInfo_kMaxPlanes: ::core::ffi::c_int = 4;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkYUVAInfo"][::core::mem::size_of::<SkYUVAInfo>() - 32usize];
    ["Alignment of SkYUVAInfo"][::core::mem::align_of::<SkYUVAInfo>() - 4usize];
    ["Offset of field: SkYUVAInfo::fDimensions"]
        [::core::mem::offset_of!(SkYUVAInfo, fDimensions) - 0usize];
    ["Offset of field: SkYUVAInfo::fPlaneConfig"]
        [::core::mem::offset_of!(SkYUVAInfo, fPlaneConfig) - 8usize];
    ["Offset of field: SkYUVAInfo::fSubsampling"]
        [::core::mem::offset_of!(SkYUVAInfo, fSubsampling) - 12usize];
    ["Offset of field: SkYUVAInfo::fYUVColorSpace"]
        [::core::mem::offset_of!(SkYUVAInfo, fYUVColorSpace) - 16usize];
    ["Offset of field: SkYUVAInfo::fOrigin"]
        [::core::mem::offset_of!(SkYUVAInfo, fOrigin) - 20usize];
    ["Offset of field: SkYUVAInfo::fSitingX"]
        [::core::mem::offset_of!(SkYUVAInfo, fSitingX) - 24usize];
    ["Offset of field: SkYUVAInfo::fSitingY"]
        [::core::mem::offset_of!(SkYUVAInfo, fSitingY) - 28usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfo18SubsamplingFactorsENS_11SubsamplingE"]
    pub fn SkYUVAInfo_SubsamplingFactors(
        arg1: SkYUVAInfo_Subsampling,
    ) -> __BindgenOpaqueArray<u32, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfo23PlaneSubsamplingFactorsENS_11PlaneConfigENS_11SubsamplingEi"]
    pub fn SkYUVAInfo_PlaneSubsamplingFactors(
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        planeIdx: ::core::ffi::c_int,
    ) -> __BindgenOpaqueArray<u32, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfo15PlaneDimensionsE7SkISizeNS_11PlaneConfigENS_11SubsamplingE15SkEncodedOriginPS0_"]
    pub fn SkYUVAInfo_PlaneDimensions(
        imageDimensions: SkISize,
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        arg3: SkEncodedOrigin,
        planeDimensions: *mut SkISize,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfo16GetYUVALocationsENS_11PlaneConfigEPKj"]
    pub fn SkYUVAInfo_GetYUVALocations(
        arg1: SkYUVAInfo_PlaneConfig,
        planeChannelFlags: *const u32,
    ) -> SkYUVAInfo_YUVALocations;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfo8HasAlphaENS_11PlaneConfigE"]
    pub fn SkYUVAInfo_HasAlpha(arg1: SkYUVAInfo_PlaneConfig) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkYUVAInfo17computeTotalBytesEPKmPm"]
    pub fn SkYUVAInfo_computeTotalBytes(
        this: *const SkYUVAInfo,
        rowBytes: *const usize,
        planeSizes: *mut usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkYUVAInfo15toYUVALocationsEPKj"]
    pub fn SkYUVAInfo_toYUVALocations(
        this: *const SkYUVAInfo,
        channelFlags: *const u32,
    ) -> SkYUVAInfo_YUVALocations;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkYUVAInfo15makeSubsamplingENS_11SubsamplingE"]
    pub fn SkYUVAInfo_makeSubsampling(
        this: *const SkYUVAInfo,
        arg1: SkYUVAInfo_Subsampling,
    ) -> SkYUVAInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkYUVAInfo14makeDimensionsE7SkISize"]
    pub fn SkYUVAInfo_makeDimensions(this: *const SkYUVAInfo, arg1: SkISize) -> SkYUVAInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkYUVAInfoC1E7SkISizeNS_11PlaneConfigENS_11SubsamplingE15SkYUVColorSpace15SkEncodedOriginNS_6SitingES5_"]
    pub fn SkYUVAInfo_SkYUVAInfo(
        this: *mut SkYUVAInfo,
        dimensions: SkISize,
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        arg3: SkYUVColorSpace,
        origin: SkEncodedOrigin,
        sitingX: SkYUVAInfo_Siting,
        sitingY: SkYUVAInfo_Siting,
    );
}
impl SkYUVAInfo {
    #[inline]
    pub unsafe fn SubsamplingFactors(
        arg1: SkYUVAInfo_Subsampling,
    ) -> __BindgenOpaqueArray<u32, 2usize> {
        SkYUVAInfo_SubsamplingFactors(arg1)
    }
    #[inline]
    pub unsafe fn PlaneSubsamplingFactors(
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        planeIdx: ::core::ffi::c_int,
    ) -> __BindgenOpaqueArray<u32, 2usize> {
        SkYUVAInfo_PlaneSubsamplingFactors(arg1, arg2, planeIdx)
    }
    #[inline]
    pub unsafe fn PlaneDimensions(
        imageDimensions: SkISize,
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        arg3: SkEncodedOrigin,
        planeDimensions: *mut SkISize,
    ) -> ::core::ffi::c_int {
        SkYUVAInfo_PlaneDimensions(imageDimensions, arg1, arg2, arg3, planeDimensions)
    }
    #[inline]
    pub unsafe fn GetYUVALocations(
        arg1: SkYUVAInfo_PlaneConfig,
        planeChannelFlags: *const u32,
    ) -> SkYUVAInfo_YUVALocations {
        SkYUVAInfo_GetYUVALocations(arg1, planeChannelFlags)
    }
    #[inline]
    pub unsafe fn HasAlpha(arg1: SkYUVAInfo_PlaneConfig) -> bool {
        SkYUVAInfo_HasAlpha(arg1)
    }
    #[inline]
    pub unsafe fn computeTotalBytes(
        &self,
        rowBytes: *const usize,
        planeSizes: *mut usize,
    ) -> usize {
        SkYUVAInfo_computeTotalBytes(self, rowBytes, planeSizes)
    }
    #[inline]
    pub unsafe fn toYUVALocations(&self, channelFlags: *const u32) -> SkYUVAInfo_YUVALocations {
        SkYUVAInfo_toYUVALocations(self, channelFlags)
    }
    #[inline]
    pub unsafe fn makeSubsampling(&self, arg1: SkYUVAInfo_Subsampling) -> SkYUVAInfo {
        SkYUVAInfo_makeSubsampling(self, arg1)
    }
    #[inline]
    pub unsafe fn makeDimensions(&self, arg1: SkISize) -> SkYUVAInfo {
        SkYUVAInfo_makeDimensions(self, arg1)
    }
    #[inline]
    pub unsafe fn new(
        dimensions: SkISize,
        arg1: SkYUVAInfo_PlaneConfig,
        arg2: SkYUVAInfo_Subsampling,
        arg3: SkYUVColorSpace,
        origin: SkEncodedOrigin,
        sitingX: SkYUVAInfo_Siting,
        sitingY: SkYUVAInfo_Siting,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkYUVAInfo_SkYUVAInfo(
            __bindgen_tmp.as_mut_ptr(),
            dimensions,
            arg1,
            arg2,
            arg3,
            origin,
            sitingX,
            sitingY,
        );
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
pub struct SkYUVAPixmapInfo {
    pub fYUVAInfo: SkYUVAInfo,
    pub fPlaneInfos: __BindgenOpaqueArray<u64, 12usize>,
    pub fRowBytes: __BindgenOpaqueArray<u64, 4usize>,
    pub fDataType: SkYUVAPixmapInfo_DataType,
}
pub use self::SkYUVAInfo_PlaneConfig as SkYUVAPixmapInfo_PlaneConfig;
pub use self::SkYUVAInfo_Subsampling as SkYUVAPixmapInfo_Subsampling;
impl SkYUVAPixmapInfo_DataType {
    pub const Last: SkYUVAPixmapInfo_DataType = SkYUVAPixmapInfo_DataType::Unorm10_Unorm2;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkYUVAPixmapInfo_DataType {
    Unorm8 = 0,
    Unorm16 = 1,
    Float16 = 2,
    Unorm10_Unorm2 = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkYUVAPixmapInfo_SupportedDataTypes {
    pub fDataTypeSupport: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkYUVAPixmapInfo_SupportedDataTypes"]
        [::core::mem::size_of::<SkYUVAPixmapInfo_SupportedDataTypes>() - 8usize];
    ["Alignment of SkYUVAPixmapInfo_SupportedDataTypes"]
        [::core::mem::align_of::<SkYUVAPixmapInfo_SupportedDataTypes>() - 8usize];
    ["Offset of field: SkYUVAPixmapInfo_SupportedDataTypes::fDataTypeSupport"]
        [::core::mem::offset_of!(SkYUVAPixmapInfo_SupportedDataTypes, fDataTypeSupport) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkYUVAPixmapInfo18SupportedDataTypes14enableDataTypeENS_8DataTypeEi"]
    pub fn SkYUVAPixmapInfo_SupportedDataTypes_enableDataType(
        this: *mut SkYUVAPixmapInfo_SupportedDataTypes,
        arg1: SkYUVAPixmapInfo_DataType,
        numChannels: ::core::ffi::c_int,
    );
}
impl SkYUVAPixmapInfo_SupportedDataTypes {
    #[inline]
    pub unsafe fn enableDataType(
        &mut self,
        arg1: SkYUVAPixmapInfo_DataType,
        numChannels: ::core::ffi::c_int,
    ) {
        SkYUVAPixmapInfo_SupportedDataTypes_enableDataType(self, arg1, numChannels)
    }
}
pub const SkYUVAPixmapInfo_kMaxPlanes: ::core::ffi::c_int = 4;
pub const SkYUVAPixmapInfo_kDataTypeCnt: ::core::ffi::c_int = 4;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkYUVAPixmapInfo"][::core::mem::size_of::<SkYUVAPixmapInfo>() - 168usize];
    ["Alignment of SkYUVAPixmapInfo"][::core::mem::align_of::<SkYUVAPixmapInfo>() - 8usize];
    ["Offset of field: SkYUVAPixmapInfo::fYUVAInfo"]
        [::core::mem::offset_of!(SkYUVAPixmapInfo, fYUVAInfo) - 0usize];
    ["Offset of field: SkYUVAPixmapInfo::fPlaneInfos"]
        [::core::mem::offset_of!(SkYUVAPixmapInfo, fPlaneInfos) - 32usize];
    ["Offset of field: SkYUVAPixmapInfo::fRowBytes"]
        [::core::mem::offset_of!(SkYUVAPixmapInfo, fRowBytes) - 128usize];
    ["Offset of field: SkYUVAPixmapInfo::fDataType"]
        [::core::mem::offset_of!(SkYUVAPixmapInfo, fDataType) - 160usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkYUVAPixmapInfo22NumChannelsAndDataTypeE11SkColorType"]
    pub fn SkYUVAPixmapInfo_NumChannelsAndDataType(
        arg1: SkColorType,
    ) -> __BindgenOpaqueArray<u32, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkYUVAPixmapInfo17computeTotalBytesEPm"]
    pub fn SkYUVAPixmapInfo_computeTotalBytes(
        this: *const SkYUVAPixmapInfo,
        planeSizes: *mut usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkYUVAPixmapInfo31initPixmapsFromSingleAllocationEPvP8SkPixmap"]
    pub fn SkYUVAPixmapInfo_initPixmapsFromSingleAllocation(
        this: *const SkYUVAPixmapInfo,
        memory: *mut ::core::ffi::c_void,
        pixmaps: *mut SkPixmap,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkYUVAPixmapInfo11isSupportedERKNS_18SupportedDataTypesE"]
    pub fn SkYUVAPixmapInfo_isSupported(
        this: *const SkYUVAPixmapInfo,
        arg1: *const SkYUVAPixmapInfo_SupportedDataTypes,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkYUVAPixmapInfoC1ERK10SkYUVAInfoPK11SkColorTypePKm"]
    pub fn SkYUVAPixmapInfo_SkYUVAPixmapInfo(
        this: *mut SkYUVAPixmapInfo,
        arg1: *const SkYUVAInfo,
        arg2: *const SkColorType,
        rowBytes: *const usize,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkYUVAPixmapInfoC1ERK10SkYUVAInfoNS_8DataTypeEPKm"]
    pub fn SkYUVAPixmapInfo_SkYUVAPixmapInfo1(
        this: *mut SkYUVAPixmapInfo,
        arg1: *const SkYUVAInfo,
        arg2: SkYUVAPixmapInfo_DataType,
        rowBytes: *const usize,
    );
}
impl SkYUVAPixmapInfo {
    #[inline]
    pub unsafe fn NumChannelsAndDataType(arg1: SkColorType) -> __BindgenOpaqueArray<u32, 2usize> {
        SkYUVAPixmapInfo_NumChannelsAndDataType(arg1)
    }
    #[inline]
    pub unsafe fn computeTotalBytes(&self, planeSizes: *mut usize) -> usize {
        SkYUVAPixmapInfo_computeTotalBytes(self, planeSizes)
    }
    #[inline]
    pub unsafe fn initPixmapsFromSingleAllocation(
        &self,
        memory: *mut ::core::ffi::c_void,
        pixmaps: *mut SkPixmap,
    ) -> bool {
        SkYUVAPixmapInfo_initPixmapsFromSingleAllocation(self, memory, pixmaps)
    }
    #[inline]
    pub unsafe fn isSupported(&self, arg1: *const SkYUVAPixmapInfo_SupportedDataTypes) -> bool {
        SkYUVAPixmapInfo_isSupported(self, arg1)
    }
    #[inline]
    pub unsafe fn new(
        arg1: *const SkYUVAInfo,
        arg2: *const SkColorType,
        rowBytes: *const usize,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkYUVAPixmapInfo_SkYUVAPixmapInfo(__bindgen_tmp.as_mut_ptr(), arg1, arg2, rowBytes);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        arg1: *const SkYUVAInfo,
        arg2: SkYUVAPixmapInfo_DataType,
        rowBytes: *const usize,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkYUVAPixmapInfo_SkYUVAPixmapInfo1(__bindgen_tmp.as_mut_ptr(), arg1, arg2, rowBytes);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
pub struct SkYUVAPixmaps {
    pub fPlanes: __BindgenOpaqueArray<u64, 20usize>,
    pub fData: sk_sp<SkData>,
    pub fYUVAInfo: SkYUVAInfo,
    pub fDataType: SkYUVAPixmaps_DataType,
}
pub use self::SkYUVAPixmapInfo_DataType as SkYUVAPixmaps_DataType;
pub const SkYUVAPixmaps_kMaxPlanes: ::core::ffi::c_int = 4;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkYUVAPixmaps"][::core::mem::size_of::<SkYUVAPixmaps>() - 208usize];
    ["Alignment of SkYUVAPixmaps"][::core::mem::align_of::<SkYUVAPixmaps>() - 8usize];
    ["Offset of field: SkYUVAPixmaps::fPlanes"]
        [::core::mem::offset_of!(SkYUVAPixmaps, fPlanes) - 0usize];
    ["Offset of field: SkYUVAPixmaps::fData"]
        [::core::mem::offset_of!(SkYUVAPixmaps, fData) - 160usize];
    ["Offset of field: SkYUVAPixmaps::fYUVAInfo"]
        [::core::mem::offset_of!(SkYUVAPixmaps, fYUVAInfo) - 168usize];
    ["Offset of field: SkYUVAPixmaps::fDataType"]
        [::core::mem::offset_of!(SkYUVAPixmaps, fDataType) - 200usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps24RecommendedRGBAColorTypeEN16SkYUVAPixmapInfo8DataTypeE"]
    pub fn SkYUVAPixmaps_RecommendedRGBAColorType(arg1: SkYUVAPixmaps_DataType) -> SkColorType;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps8AllocateERK16SkYUVAPixmapInfo"]
    pub fn SkYUVAPixmaps_Allocate(yuvaPixmapInfo: *const SkYUVAPixmapInfo) -> SkYUVAPixmaps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps8FromDataERK16SkYUVAPixmapInfo5sk_spI6SkDataE"]
    pub fn SkYUVAPixmaps_FromData(
        arg1: *const SkYUVAPixmapInfo,
        arg2: sk_sp<SkData>,
    ) -> SkYUVAPixmaps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps8MakeCopyERKS_"]
    pub fn SkYUVAPixmaps_MakeCopy(src: *const SkYUVAPixmaps) -> SkYUVAPixmaps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps18FromExternalMemoryERK16SkYUVAPixmapInfoPv"]
    pub fn SkYUVAPixmaps_FromExternalMemory(
        arg1: *const SkYUVAPixmapInfo,
        memory: *mut ::core::ffi::c_void,
    ) -> SkYUVAPixmaps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkYUVAPixmaps19FromExternalPixmapsERK10SkYUVAInfoPK8SkPixmap"]
    pub fn SkYUVAPixmaps_FromExternalPixmaps(
        arg1: *const SkYUVAInfo,
        arg2: *const SkPixmap,
    ) -> SkYUVAPixmaps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkYUVAPixmaps11pixmapsInfoEv"]
    pub fn SkYUVAPixmaps_pixmapsInfo(this: *const SkYUVAPixmaps) -> SkYUVAPixmapInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkYUVAPixmaps15toYUVALocationsEv"]
    pub fn SkYUVAPixmaps_toYUVALocations(this: *const SkYUVAPixmaps) -> SkYUVAInfo_YUVALocations;
}
impl SkYUVAPixmaps {
    #[inline]
    pub unsafe fn RecommendedRGBAColorType(arg1: SkYUVAPixmaps_DataType) -> SkColorType {
        SkYUVAPixmaps_RecommendedRGBAColorType(arg1)
    }
    #[inline]
    pub unsafe fn Allocate(yuvaPixmapInfo: *const SkYUVAPixmapInfo) -> SkYUVAPixmaps {
        SkYUVAPixmaps_Allocate(yuvaPixmapInfo)
    }
    #[inline]
    pub unsafe fn FromData(arg1: *const SkYUVAPixmapInfo, arg2: sk_sp<SkData>) -> SkYUVAPixmaps {
        SkYUVAPixmaps_FromData(arg1, arg2)
    }
    #[inline]
    pub unsafe fn MakeCopy(src: *const SkYUVAPixmaps) -> SkYUVAPixmaps {
        SkYUVAPixmaps_MakeCopy(src)
    }
    #[inline]
    pub unsafe fn FromExternalMemory(
        arg1: *const SkYUVAPixmapInfo,
        memory: *mut ::core::ffi::c_void,
    ) -> SkYUVAPixmaps {
        SkYUVAPixmaps_FromExternalMemory(arg1, memory)
    }
    #[inline]
    pub unsafe fn FromExternalPixmaps(
        arg1: *const SkYUVAInfo,
        arg2: *const SkPixmap,
    ) -> SkYUVAPixmaps {
        SkYUVAPixmaps_FromExternalPixmaps(arg1, arg2)
    }
    #[inline]
    pub unsafe fn pixmapsInfo(&self) -> SkYUVAPixmapInfo {
        SkYUVAPixmaps_pixmapsInfo(self)
    }
    #[inline]
    pub unsafe fn toYUVALocations(&self) -> SkYUVAInfo_YUVALocations {
        SkYUVAPixmaps_toYUVALocations(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkOnce {
    pub fState: u8,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkOnce_State {
    NotStarted = 0,
    Claimed = 1,
    Done = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkOnce"][::core::mem::size_of::<SkOnce>() - 1usize];
    ["Alignment of SkOnce"][::core::mem::align_of::<SkOnce>() - 1usize];
    ["Offset of field: SkOnce::fState"][::core::mem::offset_of!(SkOnce, fState) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_Matrix3x3 {
    pub vals: [[f32; 3usize]; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_Matrix3x3"][::core::mem::size_of::<skcms_Matrix3x3>() - 36usize];
    ["Alignment of skcms_Matrix3x3"][::core::mem::align_of::<skcms_Matrix3x3>() - 4usize];
    ["Offset of field: skcms_Matrix3x3::vals"]
        [::core::mem::offset_of!(skcms_Matrix3x3, vals) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_Matrix3x4 {
    pub vals: [[f32; 4usize]; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_Matrix3x4"][::core::mem::size_of::<skcms_Matrix3x4>() - 48usize];
    ["Alignment of skcms_Matrix3x4"][::core::mem::align_of::<skcms_Matrix3x4>() - 4usize];
    ["Offset of field: skcms_Matrix3x4::vals"]
        [::core::mem::offset_of!(skcms_Matrix3x4, vals) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_TransferFunction {
    pub g: f32,
    pub a: f32,
    pub b: f32,
    pub c: f32,
    pub d: f32,
    pub e: f32,
    pub f: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_TransferFunction"][::core::mem::size_of::<skcms_TransferFunction>() - 28usize];
    ["Alignment of skcms_TransferFunction"]
        [::core::mem::align_of::<skcms_TransferFunction>() - 4usize];
    ["Offset of field: skcms_TransferFunction::g"]
        [::core::mem::offset_of!(skcms_TransferFunction, g) - 0usize];
    ["Offset of field: skcms_TransferFunction::a"]
        [::core::mem::offset_of!(skcms_TransferFunction, a) - 4usize];
    ["Offset of field: skcms_TransferFunction::b"]
        [::core::mem::offset_of!(skcms_TransferFunction, b) - 8usize];
    ["Offset of field: skcms_TransferFunction::c"]
        [::core::mem::offset_of!(skcms_TransferFunction, c) - 12usize];
    ["Offset of field: skcms_TransferFunction::d"]
        [::core::mem::offset_of!(skcms_TransferFunction, d) - 16usize];
    ["Offset of field: skcms_TransferFunction::e"]
        [::core::mem::offset_of!(skcms_TransferFunction, e) - 20usize];
    ["Offset of field: skcms_TransferFunction::f"]
        [::core::mem::offset_of!(skcms_TransferFunction, f) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union skcms_Curve {
    pub __bindgen_anon_1: skcms_Curve__bindgen_ty_1,
    pub __bindgen_anon_2: skcms_Curve__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_Curve__bindgen_ty_1 {
    pub alias_of_table_entries: u32,
    pub parametric: skcms_TransferFunction,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_Curve__bindgen_ty_1"]
        [::core::mem::size_of::<skcms_Curve__bindgen_ty_1>() - 32usize];
    ["Alignment of skcms_Curve__bindgen_ty_1"]
        [::core::mem::align_of::<skcms_Curve__bindgen_ty_1>() - 4usize];
    ["Offset of field: skcms_Curve__bindgen_ty_1::alias_of_table_entries"]
        [::core::mem::offset_of!(skcms_Curve__bindgen_ty_1, alias_of_table_entries) - 0usize];
    ["Offset of field: skcms_Curve__bindgen_ty_1::parametric"]
        [::core::mem::offset_of!(skcms_Curve__bindgen_ty_1, parametric) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_Curve__bindgen_ty_2 {
    pub table_entries: u32,
    pub table_8: *const u8,
    pub table_16: *const u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_Curve__bindgen_ty_2"]
        [::core::mem::size_of::<skcms_Curve__bindgen_ty_2>() - 24usize];
    ["Alignment of skcms_Curve__bindgen_ty_2"]
        [::core::mem::align_of::<skcms_Curve__bindgen_ty_2>() - 8usize];
    ["Offset of field: skcms_Curve__bindgen_ty_2::table_entries"]
        [::core::mem::offset_of!(skcms_Curve__bindgen_ty_2, table_entries) - 0usize];
    ["Offset of field: skcms_Curve__bindgen_ty_2::table_8"]
        [::core::mem::offset_of!(skcms_Curve__bindgen_ty_2, table_8) - 8usize];
    ["Offset of field: skcms_Curve__bindgen_ty_2::table_16"]
        [::core::mem::offset_of!(skcms_Curve__bindgen_ty_2, table_16) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_Curve"][::core::mem::size_of::<skcms_Curve>() - 32usize];
    ["Alignment of skcms_Curve"][::core::mem::align_of::<skcms_Curve>() - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct skcms_A2B {
    pub input_curves: [skcms_Curve; 4usize],
    pub grid_8: *const u8,
    pub grid_16: *const u8,
    pub input_channels: u32,
    pub grid_points: [u8; 4usize],
    pub matrix_curves: [skcms_Curve; 3usize],
    pub matrix: skcms_Matrix3x4,
    pub matrix_channels: u32,
    pub output_channels: u32,
    pub output_curves: [skcms_Curve; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_A2B"][::core::mem::size_of::<skcms_A2B>() - 400usize];
    ["Alignment of skcms_A2B"][::core::mem::align_of::<skcms_A2B>() - 8usize];
    ["Offset of field: skcms_A2B::input_curves"]
        [::core::mem::offset_of!(skcms_A2B, input_curves) - 0usize];
    ["Offset of field: skcms_A2B::grid_8"][::core::mem::offset_of!(skcms_A2B, grid_8) - 128usize];
    ["Offset of field: skcms_A2B::grid_16"][::core::mem::offset_of!(skcms_A2B, grid_16) - 136usize];
    ["Offset of field: skcms_A2B::input_channels"]
        [::core::mem::offset_of!(skcms_A2B, input_channels) - 144usize];
    ["Offset of field: skcms_A2B::grid_points"]
        [::core::mem::offset_of!(skcms_A2B, grid_points) - 148usize];
    ["Offset of field: skcms_A2B::matrix_curves"]
        [::core::mem::offset_of!(skcms_A2B, matrix_curves) - 152usize];
    ["Offset of field: skcms_A2B::matrix"][::core::mem::offset_of!(skcms_A2B, matrix) - 248usize];
    ["Offset of field: skcms_A2B::matrix_channels"]
        [::core::mem::offset_of!(skcms_A2B, matrix_channels) - 296usize];
    ["Offset of field: skcms_A2B::output_channels"]
        [::core::mem::offset_of!(skcms_A2B, output_channels) - 300usize];
    ["Offset of field: skcms_A2B::output_curves"]
        [::core::mem::offset_of!(skcms_A2B, output_curves) - 304usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct skcms_B2A {
    pub input_curves: [skcms_Curve; 3usize],
    pub input_channels: u32,
    pub matrix_channels: u32,
    pub matrix_curves: [skcms_Curve; 3usize],
    pub matrix: skcms_Matrix3x4,
    pub output_curves: [skcms_Curve; 4usize],
    pub grid_8: *const u8,
    pub grid_16: *const u8,
    pub grid_points: [u8; 4usize],
    pub output_channels: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_B2A"][::core::mem::size_of::<skcms_B2A>() - 400usize];
    ["Alignment of skcms_B2A"][::core::mem::align_of::<skcms_B2A>() - 8usize];
    ["Offset of field: skcms_B2A::input_curves"]
        [::core::mem::offset_of!(skcms_B2A, input_curves) - 0usize];
    ["Offset of field: skcms_B2A::input_channels"]
        [::core::mem::offset_of!(skcms_B2A, input_channels) - 96usize];
    ["Offset of field: skcms_B2A::matrix_channels"]
        [::core::mem::offset_of!(skcms_B2A, matrix_channels) - 100usize];
    ["Offset of field: skcms_B2A::matrix_curves"]
        [::core::mem::offset_of!(skcms_B2A, matrix_curves) - 104usize];
    ["Offset of field: skcms_B2A::matrix"][::core::mem::offset_of!(skcms_B2A, matrix) - 200usize];
    ["Offset of field: skcms_B2A::output_curves"]
        [::core::mem::offset_of!(skcms_B2A, output_curves) - 248usize];
    ["Offset of field: skcms_B2A::grid_8"][::core::mem::offset_of!(skcms_B2A, grid_8) - 376usize];
    ["Offset of field: skcms_B2A::grid_16"][::core::mem::offset_of!(skcms_B2A, grid_16) - 384usize];
    ["Offset of field: skcms_B2A::grid_points"]
        [::core::mem::offset_of!(skcms_B2A, grid_points) - 392usize];
    ["Offset of field: skcms_B2A::output_channels"]
        [::core::mem::offset_of!(skcms_B2A, output_channels) - 396usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skcms_CICP {
    pub color_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coefficients: u8,
    pub video_full_range_flag: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_CICP"][::core::mem::size_of::<skcms_CICP>() - 4usize];
    ["Alignment of skcms_CICP"][::core::mem::align_of::<skcms_CICP>() - 1usize];
    ["Offset of field: skcms_CICP::color_primaries"]
        [::core::mem::offset_of!(skcms_CICP, color_primaries) - 0usize];
    ["Offset of field: skcms_CICP::transfer_characteristics"]
        [::core::mem::offset_of!(skcms_CICP, transfer_characteristics) - 1usize];
    ["Offset of field: skcms_CICP::matrix_coefficients"]
        [::core::mem::offset_of!(skcms_CICP, matrix_coefficients) - 2usize];
    ["Offset of field: skcms_CICP::video_full_range_flag"]
        [::core::mem::offset_of!(skcms_CICP, video_full_range_flag) - 3usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct skcms_ICCProfile {
    pub buffer: *const u8,
    pub size: u32,
    pub data_color_space: u32,
    pub pcs: u32,
    pub tag_count: u32,
    pub trc: [skcms_Curve; 3usize],
    pub toXYZD50: skcms_Matrix3x3,
    pub A2B: skcms_A2B,
    pub B2A: skcms_B2A,
    pub CICP: skcms_CICP,
    pub has_trc: bool,
    pub has_toXYZD50: bool,
    pub has_A2B: bool,
    pub has_B2A: bool,
    pub has_CICP: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcms_ICCProfile"][::core::mem::size_of::<skcms_ICCProfile>() - 976usize];
    ["Alignment of skcms_ICCProfile"][::core::mem::align_of::<skcms_ICCProfile>() - 8usize];
    ["Offset of field: skcms_ICCProfile::buffer"]
        [::core::mem::offset_of!(skcms_ICCProfile, buffer) - 0usize];
    ["Offset of field: skcms_ICCProfile::size"]
        [::core::mem::offset_of!(skcms_ICCProfile, size) - 8usize];
    ["Offset of field: skcms_ICCProfile::data_color_space"]
        [::core::mem::offset_of!(skcms_ICCProfile, data_color_space) - 12usize];
    ["Offset of field: skcms_ICCProfile::pcs"]
        [::core::mem::offset_of!(skcms_ICCProfile, pcs) - 16usize];
    ["Offset of field: skcms_ICCProfile::tag_count"]
        [::core::mem::offset_of!(skcms_ICCProfile, tag_count) - 20usize];
    ["Offset of field: skcms_ICCProfile::trc"]
        [::core::mem::offset_of!(skcms_ICCProfile, trc) - 24usize];
    ["Offset of field: skcms_ICCProfile::toXYZD50"]
        [::core::mem::offset_of!(skcms_ICCProfile, toXYZD50) - 120usize];
    ["Offset of field: skcms_ICCProfile::A2B"]
        [::core::mem::offset_of!(skcms_ICCProfile, A2B) - 160usize];
    ["Offset of field: skcms_ICCProfile::B2A"]
        [::core::mem::offset_of!(skcms_ICCProfile, B2A) - 560usize];
    ["Offset of field: skcms_ICCProfile::CICP"]
        [::core::mem::offset_of!(skcms_ICCProfile, CICP) - 960usize];
    ["Offset of field: skcms_ICCProfile::has_trc"]
        [::core::mem::offset_of!(skcms_ICCProfile, has_trc) - 964usize];
    ["Offset of field: skcms_ICCProfile::has_toXYZD50"]
        [::core::mem::offset_of!(skcms_ICCProfile, has_toXYZD50) - 965usize];
    ["Offset of field: skcms_ICCProfile::has_A2B"]
        [::core::mem::offset_of!(skcms_ICCProfile, has_A2B) - 966usize];
    ["Offset of field: skcms_ICCProfile::has_B2A"]
        [::core::mem::offset_of!(skcms_ICCProfile, has_B2A) - 967usize];
    ["Offset of field: skcms_ICCProfile::has_CICP"]
        [::core::mem::offset_of!(skcms_ICCProfile, has_CICP) - 968usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum skcms_PixelFormat {
    skcms_PixelFormat_A_8 = 0,
    skcms_PixelFormat_A_8_ = 1,
    skcms_PixelFormat_G_8 = 2,
    skcms_PixelFormat_G_8_ = 3,
    skcms_PixelFormat_GA_88 = 4,
    skcms_PixelFormat_GA_88_ = 5,
    skcms_PixelFormat_RGB_565 = 6,
    skcms_PixelFormat_BGR_565 = 7,
    skcms_PixelFormat_ABGR_4444 = 8,
    skcms_PixelFormat_ARGB_4444 = 9,
    skcms_PixelFormat_RGB_888 = 10,
    skcms_PixelFormat_BGR_888 = 11,
    skcms_PixelFormat_RGBA_8888 = 12,
    skcms_PixelFormat_BGRA_8888 = 13,
    skcms_PixelFormat_RGBA_8888_sRGB = 14,
    skcms_PixelFormat_BGRA_8888_sRGB = 15,
    skcms_PixelFormat_RGBA_1010102 = 16,
    skcms_PixelFormat_BGRA_1010102 = 17,
    skcms_PixelFormat_RGB_161616LE = 18,
    skcms_PixelFormat_BGR_161616LE = 19,
    skcms_PixelFormat_RGBA_16161616LE = 20,
    skcms_PixelFormat_BGRA_16161616LE = 21,
    skcms_PixelFormat_RGB_161616BE = 22,
    skcms_PixelFormat_BGR_161616BE = 23,
    skcms_PixelFormat_RGBA_16161616BE = 24,
    skcms_PixelFormat_BGRA_16161616BE = 25,
    skcms_PixelFormat_RGB_hhh_Norm = 26,
    skcms_PixelFormat_BGR_hhh_Norm = 27,
    skcms_PixelFormat_RGBA_hhhh_Norm = 28,
    skcms_PixelFormat_BGRA_hhhh_Norm = 29,
    skcms_PixelFormat_RGB_hhh = 30,
    skcms_PixelFormat_BGR_hhh = 31,
    skcms_PixelFormat_RGBA_hhhh = 32,
    skcms_PixelFormat_BGRA_hhhh = 33,
    skcms_PixelFormat_RGB_fff = 34,
    skcms_PixelFormat_BGR_fff = 35,
    skcms_PixelFormat_RGBA_ffff = 36,
    skcms_PixelFormat_BGRA_ffff = 37,
    skcms_PixelFormat_RGB_101010x_XR = 38,
    skcms_PixelFormat_BGR_101010x_XR = 39,
    skcms_PixelFormat_RGBA_10101010_XR = 40,
    skcms_PixelFormat_BGRA_10101010_XR = 41,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum skcms_AlphaFormat {
    skcms_AlphaFormat_Opaque = 0,
    skcms_AlphaFormat_Unpremul = 1,
    skcms_AlphaFormat_PremulAsEncoded = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkColorSpacePrimaries {
    pub fRX: f32,
    pub fRY: f32,
    pub fGX: f32,
    pub fGY: f32,
    pub fBX: f32,
    pub fBY: f32,
    pub fWX: f32,
    pub fWY: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorSpacePrimaries"][::core::mem::size_of::<SkColorSpacePrimaries>() - 32usize];
    ["Alignment of SkColorSpacePrimaries"]
        [::core::mem::align_of::<SkColorSpacePrimaries>() - 4usize];
    ["Offset of field: SkColorSpacePrimaries::fRX"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fRX) - 0usize];
    ["Offset of field: SkColorSpacePrimaries::fRY"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fRY) - 4usize];
    ["Offset of field: SkColorSpacePrimaries::fGX"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fGX) - 8usize];
    ["Offset of field: SkColorSpacePrimaries::fGY"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fGY) - 12usize];
    ["Offset of field: SkColorSpacePrimaries::fBX"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fBX) - 16usize];
    ["Offset of field: SkColorSpacePrimaries::fBY"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fBY) - 20usize];
    ["Offset of field: SkColorSpacePrimaries::fWX"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fWX) - 24usize];
    ["Offset of field: SkColorSpacePrimaries::fWY"]
        [::core::mem::offset_of!(SkColorSpacePrimaries, fWY) - 28usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK21SkColorSpacePrimaries8toXYZD50EP15skcms_Matrix3x3"]
    pub fn SkColorSpacePrimaries_toXYZD50(
        this: *const SkColorSpacePrimaries,
        toXYZD50: *mut skcms_Matrix3x3,
    ) -> bool;
}
impl SkColorSpacePrimaries {
    #[inline]
    pub unsafe fn toXYZD50(&self, toXYZD50: *mut skcms_Matrix3x3) -> bool {
        SkColorSpacePrimaries_toXYZD50(self, toXYZD50)
    }
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkNamedPrimaries_CicpId {
    Rec709 = 1,
    Rec470SystemM = 4,
    Rec470SystemBG = 5,
    Rec601 = 6,
    SMPTE_ST_240 = 7,
    GenericFilm = 8,
    Rec2020 = 9,
    SMPTE_ST_428_1 = 10,
    SMPTE_RP_431_2 = 11,
    SMPTE_EG_432_1 = 12,
    ITU_T_H273_Value22 = 22,
}
impl SkNamedTransferFn_CicpId {
    pub const SRGB: SkNamedTransferFn_CicpId = SkNamedTransferFn_CicpId::IEC61966_2_1;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkNamedTransferFn_CicpId {
    Rec709 = 1,
    Rec470SystemM = 4,
    Rec470SystemBG = 5,
    Rec601 = 6,
    SMPTE_ST_240 = 7,
    Linear = 8,
    IEC61966_2_4 = 11,
    IEC61966_2_1 = 13,
    Rec2020_10bit = 14,
    Rec2020_12bit = 15,
    PQ = 16,
    SMPTE_ST_428_1 = 17,
    HLG = 18,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkColorSpace {
    pub _base: SkNVRefCnt,
    pub fTransferFnHash: u32,
    pub fToXYZD50Hash: u32,
    pub fTransferFn: skcms_TransferFunction,
    pub fToXYZD50: skcms_Matrix3x3,
    pub fInvTransferFn: skcms_TransferFunction,
    pub fFromXYZD50: skcms_Matrix3x3,
    pub fLazyDstFieldsOnce: SkOnce,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorSpace"][::core::mem::size_of::<SkColorSpace>() - 144usize];
    ["Alignment of SkColorSpace"][::core::mem::align_of::<SkColorSpace>() - 4usize];
    ["Offset of field: SkColorSpace::fTransferFnHash"]
        [::core::mem::offset_of!(SkColorSpace, fTransferFnHash) - 4usize];
    ["Offset of field: SkColorSpace::fToXYZD50Hash"]
        [::core::mem::offset_of!(SkColorSpace, fToXYZD50Hash) - 8usize];
    ["Offset of field: SkColorSpace::fTransferFn"]
        [::core::mem::offset_of!(SkColorSpace, fTransferFn) - 12usize];
    ["Offset of field: SkColorSpace::fToXYZD50"]
        [::core::mem::offset_of!(SkColorSpace, fToXYZD50) - 40usize];
    ["Offset of field: SkColorSpace::fInvTransferFn"]
        [::core::mem::offset_of!(SkColorSpace, fInvTransferFn) - 76usize];
    ["Offset of field: SkColorSpace::fFromXYZD50"]
        [::core::mem::offset_of!(SkColorSpace, fFromXYZD50) - 104usize];
    ["Offset of field: SkColorSpace::fLazyDstFieldsOnce"]
        [::core::mem::offset_of!(SkColorSpace, fLazyDstFieldsOnce) - 140usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace8MakeSRGBEv"]
    pub fn SkColorSpace_MakeSRGB() -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace14MakeSRGBLinearEv"]
    pub fn SkColorSpace_MakeSRGBLinear() -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace7MakeRGBERK22skcms_TransferFunctionRK15skcms_Matrix3x3"]
    pub fn SkColorSpace_MakeRGB(
        transferFn: *const skcms_TransferFunction,
        toXYZ: *const skcms_Matrix3x3,
    ) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace8MakeCICPEN16SkNamedPrimaries6CicpIdEN17SkNamedTransferFn6CicpIdE"]
    pub fn SkColorSpace_MakeCICP(
        color_primaries: SkNamedPrimaries_CicpId,
        transfer_characteristics: SkNamedTransferFn_CicpId,
    ) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace4MakeERK16skcms_ICCProfile"]
    pub fn SkColorSpace_Make(arg1: *const skcms_ICCProfile) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace9toProfileEP16skcms_ICCProfile"]
    pub fn SkColorSpace_toProfile(this: *const SkColorSpace, arg1: *mut skcms_ICCProfile);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace16gammaCloseToSRGBEv"]
    pub fn SkColorSpace_gammaCloseToSRGB(this: *const SkColorSpace) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace13gammaIsLinearEv"]
    pub fn SkColorSpace_gammaIsLinear(this: *const SkColorSpace) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace21isNumericalTransferFnEP22skcms_TransferFunction"]
    pub fn SkColorSpace_isNumericalTransferFn(
        this: *const SkColorSpace,
        fn_: *mut skcms_TransferFunction,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace8toXYZD50EP15skcms_Matrix3x3"]
    pub fn SkColorSpace_toXYZD50(this: *const SkColorSpace, toXYZD50: *mut skcms_Matrix3x3)
    -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace15makeLinearGammaEv"]
    pub fn SkColorSpace_makeLinearGamma(this: *const SkColorSpace) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace13makeSRGBGammaEv"]
    pub fn SkColorSpace_makeSRGBGamma(this: *const SkColorSpace) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace13makeColorSpinEv"]
    pub fn SkColorSpace_makeColorSpin(this: *const SkColorSpace) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace6isSRGBEv"]
    pub fn SkColorSpace_isSRGB(this: *const SkColorSpace) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace9serializeEv"]
    pub fn SkColorSpace_serialize(this: *const SkColorSpace) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace13writeToMemoryEPv"]
    pub fn SkColorSpace_writeToMemory(
        this: *const SkColorSpace,
        memory: *mut ::core::ffi::c_void,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace11DeserializeEPKvm"]
    pub fn SkColorSpace_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorSpace6EqualsEPKS_S1_"]
    pub fn SkColorSpace_Equals(arg1: *const SkColorSpace, arg2: *const SkColorSpace) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace10transferFnEPf"]
    pub fn SkColorSpace_transferFn(this: *const SkColorSpace, gabcdef: *mut f32);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace10transferFnEP22skcms_TransferFunction"]
    pub fn SkColorSpace_transferFn1(this: *const SkColorSpace, fn_: *mut skcms_TransferFunction);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace13invTransferFnEP22skcms_TransferFunction"]
    pub fn SkColorSpace_invTransferFn(this: *const SkColorSpace, fn_: *mut skcms_TransferFunction);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorSpace16gamutTransformToEPKS_P15skcms_Matrix3x3"]
    pub fn SkColorSpace_gamutTransformTo(
        this: *const SkColorSpace,
        dst: *const SkColorSpace,
        src_to_dst: *mut skcms_Matrix3x3,
    );
}
impl SkColorSpace {
    #[inline]
    pub unsafe fn MakeSRGB() -> sk_sp<SkColorSpace> {
        SkColorSpace_MakeSRGB()
    }
    #[inline]
    pub unsafe fn MakeSRGBLinear() -> sk_sp<SkColorSpace> {
        SkColorSpace_MakeSRGBLinear()
    }
    #[inline]
    pub unsafe fn MakeRGB(
        transferFn: *const skcms_TransferFunction,
        toXYZ: *const skcms_Matrix3x3,
    ) -> sk_sp<SkColorSpace> {
        SkColorSpace_MakeRGB(transferFn, toXYZ)
    }
    #[inline]
    pub unsafe fn MakeCICP(
        color_primaries: SkNamedPrimaries_CicpId,
        transfer_characteristics: SkNamedTransferFn_CicpId,
    ) -> sk_sp<SkColorSpace> {
        SkColorSpace_MakeCICP(color_primaries, transfer_characteristics)
    }
    #[inline]
    pub unsafe fn Make(arg1: *const skcms_ICCProfile) -> sk_sp<SkColorSpace> {
        SkColorSpace_Make(arg1)
    }
    #[inline]
    pub unsafe fn toProfile(&self, arg1: *mut skcms_ICCProfile) {
        SkColorSpace_toProfile(self, arg1)
    }
    #[inline]
    pub unsafe fn gammaCloseToSRGB(&self) -> bool {
        SkColorSpace_gammaCloseToSRGB(self)
    }
    #[inline]
    pub unsafe fn gammaIsLinear(&self) -> bool {
        SkColorSpace_gammaIsLinear(self)
    }
    #[inline]
    pub unsafe fn isNumericalTransferFn(&self, fn_: *mut skcms_TransferFunction) -> bool {
        SkColorSpace_isNumericalTransferFn(self, fn_)
    }
    #[inline]
    pub unsafe fn toXYZD50(&self, toXYZD50: *mut skcms_Matrix3x3) -> bool {
        SkColorSpace_toXYZD50(self, toXYZD50)
    }
    #[inline]
    pub unsafe fn makeLinearGamma(&self) -> sk_sp<SkColorSpace> {
        SkColorSpace_makeLinearGamma(self)
    }
    #[inline]
    pub unsafe fn makeSRGBGamma(&self) -> sk_sp<SkColorSpace> {
        SkColorSpace_makeSRGBGamma(self)
    }
    #[inline]
    pub unsafe fn makeColorSpin(&self) -> sk_sp<SkColorSpace> {
        SkColorSpace_makeColorSpin(self)
    }
    #[inline]
    pub unsafe fn isSRGB(&self) -> bool {
        SkColorSpace_isSRGB(self)
    }
    #[inline]
    pub unsafe fn serialize(&self) -> sk_sp<SkData> {
        SkColorSpace_serialize(self)
    }
    #[inline]
    pub unsafe fn writeToMemory(&self, memory: *mut ::core::ffi::c_void) -> usize {
        SkColorSpace_writeToMemory(self, memory)
    }
    #[inline]
    pub unsafe fn Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> sk_sp<SkColorSpace> {
        SkColorSpace_Deserialize(data, length)
    }
    #[inline]
    pub unsafe fn Equals(arg1: *const SkColorSpace, arg2: *const SkColorSpace) -> bool {
        SkColorSpace_Equals(arg1, arg2)
    }
    #[inline]
    pub unsafe fn transferFn(&self, gabcdef: *mut f32) {
        SkColorSpace_transferFn(self, gabcdef)
    }
    #[inline]
    pub unsafe fn transferFn1(&self, fn_: *mut skcms_TransferFunction) {
        SkColorSpace_transferFn1(self, fn_)
    }
    #[inline]
    pub unsafe fn invTransferFn(&self, fn_: *mut skcms_TransferFunction) {
        SkColorSpace_invTransferFn(self, fn_)
    }
    #[inline]
    pub unsafe fn gamutTransformTo(
        &self,
        dst: *const SkColorSpace,
        src_to_dst: *mut skcms_Matrix3x3,
    ) {
        SkColorSpace_gamutTransformTo(self, dst, src_to_dst)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkEncodedInfo {
    pub fWidth: ::core::ffi::c_int,
    pub fHeight: ::core::ffi::c_int,
    pub fColor: SkEncodedInfo_Color,
    pub fAlpha: SkEncodedInfo_Alpha,
    pub fBitsPerComponent: u8,
    pub fColorDepth: u8,
    pub fProfile: u64,
}
#[repr(C)]
pub struct SkEncodedInfo_ICCProfile {
    pub fProfile: skcms_ICCProfile,
    pub fData: sk_sp<SkData>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkEncodedInfo_ICCProfile"]
        [::core::mem::size_of::<SkEncodedInfo_ICCProfile>() - 984usize];
    ["Alignment of SkEncodedInfo_ICCProfile"]
        [::core::mem::align_of::<SkEncodedInfo_ICCProfile>() - 8usize];
    ["Offset of field: SkEncodedInfo_ICCProfile::fProfile"]
        [::core::mem::offset_of!(SkEncodedInfo_ICCProfile, fProfile) - 0usize];
    ["Offset of field: SkEncodedInfo_ICCProfile::fData"]
        [::core::mem::offset_of!(SkEncodedInfo_ICCProfile, fData) - 976usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkEncodedInfo10ICCProfile4MakeE5sk_spI6SkDataE"]
    pub fn SkEncodedInfo_ICCProfile_Make(arg1: sk_sp<SkData>) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkEncodedInfo10ICCProfile4MakeERK16skcms_ICCProfile"]
    pub fn SkEncodedInfo_ICCProfile_Make1(arg1: *const skcms_ICCProfile) -> u64;
}
impl SkEncodedInfo_ICCProfile {
    #[inline]
    pub unsafe fn Make(arg1: sk_sp<SkData>) -> u64 {
        SkEncodedInfo_ICCProfile_Make(arg1)
    }
    #[inline]
    pub unsafe fn Make1(arg1: *const skcms_ICCProfile) -> u64 {
        SkEncodedInfo_ICCProfile_Make1(arg1)
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkEncodedInfo_Alpha {
    kOpaque_Alpha = 0,
    kUnpremul_Alpha = 1,
    kBinary_Alpha = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkEncodedInfo_Color {
    kGray_Color = 0,
    kGrayAlpha_Color = 1,
    kXAlpha_Color = 2,
    k565_Color = 3,
    kPalette_Color = 4,
    kRGB_Color = 5,
    kRGBA_Color = 6,
    kBGR_Color = 7,
    kBGRX_Color = 8,
    kBGRA_Color = 9,
    kYUV_Color = 10,
    kYUVA_Color = 11,
    kInvertedCMYK_Color = 12,
    kYCCK_Color = 13,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkEncodedInfo"][::core::mem::size_of::<SkEncodedInfo>() - 32usize];
    ["Alignment of SkEncodedInfo"][::core::mem::align_of::<SkEncodedInfo>() - 8usize];
    ["Offset of field: SkEncodedInfo::fWidth"]
        [::core::mem::offset_of!(SkEncodedInfo, fWidth) - 0usize];
    ["Offset of field: SkEncodedInfo::fHeight"]
        [::core::mem::offset_of!(SkEncodedInfo, fHeight) - 4usize];
    ["Offset of field: SkEncodedInfo::fColor"]
        [::core::mem::offset_of!(SkEncodedInfo, fColor) - 8usize];
    ["Offset of field: SkEncodedInfo::fAlpha"]
        [::core::mem::offset_of!(SkEncodedInfo, fAlpha) - 12usize];
    ["Offset of field: SkEncodedInfo::fBitsPerComponent"]
        [::core::mem::offset_of!(SkEncodedInfo, fBitsPerComponent) - 16usize];
    ["Offset of field: SkEncodedInfo::fColorDepth"]
        [::core::mem::offset_of!(SkEncodedInfo, fColorDepth) - 17usize];
    ["Offset of field: SkEncodedInfo::fProfile"]
        [::core::mem::offset_of!(SkEncodedInfo, fProfile) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkNoncopyable {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkNoncopyable"][::core::mem::size_of::<SkNoncopyable>() - 1usize];
    ["Alignment of SkNoncopyable"][::core::mem::align_of::<SkNoncopyable>() - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPngChunkReader {
    _unused: [u8; 0],
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodecAnimation_DisposalMethod {
    Keep = 1,
    RestoreBGColor = 2,
    RestorePrevious = 3,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodecAnimation_Blend {
    SrcOver = 0,
    Src = 1,
}
pub type SkCodecs_DecodeContext = *mut ::core::ffi::c_void;
pub type SkCodecs_IsFormatCallback = ::core::option::Option<
    unsafe extern "C" fn(data: *const ::core::ffi::c_void, len: usize) -> bool,
>;
pub type SkCodecs_MakeFromStreamCallback = ::core::option::Option<
    unsafe extern "C" fn(arg1: u64, arg2: *mut SkCodec_Result, arg3: SkCodecs_DecodeContext) -> u64,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCodecs_Decoder {
    pub id: std_string_view,
    pub isFormat: SkCodecs_IsFormatCallback,
    pub makeFromStream: SkCodecs_MakeFromStreamCallback,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCodecs_Decoder"][::core::mem::size_of::<SkCodecs_Decoder>() - 32usize];
    ["Alignment of SkCodecs_Decoder"][::core::mem::align_of::<SkCodecs_Decoder>() - 8usize];
    ["Offset of field: SkCodecs_Decoder::id"]
        [::core::mem::offset_of!(SkCodecs_Decoder, id) - 0usize];
    ["Offset of field: SkCodecs_Decoder::isFormat"]
        [::core::mem::offset_of!(SkCodecs_Decoder, isFormat) - 16usize];
    ["Offset of field: SkCodecs_Decoder::makeFromStream"]
        [::core::mem::offset_of!(SkCodecs_Decoder, makeFromStream) - 24usize];
};
#[repr(C)]
pub struct SkCodec__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
pub struct SkCodec {
    pub vtable_: *const SkCodec__bindgen_vtable,
    pub fEncodedInfo: SkEncodedInfo,
    pub fSrcXformFormat: SkCodec_XformFormat,
    pub fStream: u64,
    pub fNeedsRewind: bool,
    pub fOrigin: SkEncodedOrigin,
    pub fDstInfo: SkImageInfo,
    pub fOptions: SkCodec_Options,
    pub fXformTime: SkCodec_XformTime,
    pub fDstXformFormat: SkCodec_XformFormat,
    pub fDstProfileStorage: skcms_ICCProfile,
    pub fDstProfile: *const skcms_ICCProfile,
    pub fDstXformAlphaFormat: skcms_AlphaFormat,
    pub fCurrScanline: ::core::ffi::c_int,
    pub fStartedIncrementalDecode: bool,
    pub fUsingCallbackForHandleFrameIndex: bool,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_Result {
    Success = 0,
    IncompleteInput = 1,
    ErrorInInput = 2,
    InvalidConversion = 3,
    InvalidScale = 4,
    InvalidParameters = 5,
    InvalidInput = 6,
    CouldNotRewind = 7,
    InternalError = 8,
    Unimplemented = 9,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_SelectionPolicy {
    PreferStillImage = 0,
    PreferAnimation = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_ZeroInitialized {
    Yes = 0,
    No = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCodec_Options {
    pub fZeroInitialized: SkCodec_ZeroInitialized,
    pub fSubset: *const SkIRect,
    pub fFrameIndex: ::core::ffi::c_int,
    pub fPriorFrame: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCodec_Options"][::core::mem::size_of::<SkCodec_Options>() - 24usize];
    ["Alignment of SkCodec_Options"][::core::mem::align_of::<SkCodec_Options>() - 8usize];
    ["Offset of field: SkCodec_Options::fZeroInitialized"]
        [::core::mem::offset_of!(SkCodec_Options, fZeroInitialized) - 0usize];
    ["Offset of field: SkCodec_Options::fSubset"]
        [::core::mem::offset_of!(SkCodec_Options, fSubset) - 8usize];
    ["Offset of field: SkCodec_Options::fFrameIndex"]
        [::core::mem::offset_of!(SkCodec_Options, fFrameIndex) - 16usize];
    ["Offset of field: SkCodec_Options::fPriorFrame"]
        [::core::mem::offset_of!(SkCodec_Options, fPriorFrame) - 20usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_SkScanlineOrder {
    TopDown = 0,
    BottomUp = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCodec_FrameInfo {
    pub fRequiredFrame: ::core::ffi::c_int,
    pub fDuration: ::core::ffi::c_int,
    pub fFullyReceived: bool,
    pub fAlphaType: SkAlphaType,
    pub fHasAlphaWithinBounds: bool,
    pub fDisposalMethod: SkCodecAnimation_DisposalMethod,
    pub fBlend: SkCodecAnimation_Blend,
    pub fFrameRect: SkIRect,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCodec_FrameInfo"][::core::mem::size_of::<SkCodec_FrameInfo>() - 44usize];
    ["Alignment of SkCodec_FrameInfo"][::core::mem::align_of::<SkCodec_FrameInfo>() - 4usize];
    ["Offset of field: SkCodec_FrameInfo::fRequiredFrame"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fRequiredFrame) - 0usize];
    ["Offset of field: SkCodec_FrameInfo::fDuration"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fDuration) - 4usize];
    ["Offset of field: SkCodec_FrameInfo::fFullyReceived"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fFullyReceived) - 8usize];
    ["Offset of field: SkCodec_FrameInfo::fAlphaType"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fAlphaType) - 12usize];
    ["Offset of field: SkCodec_FrameInfo::fHasAlphaWithinBounds"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fHasAlphaWithinBounds) - 16usize];
    ["Offset of field: SkCodec_FrameInfo::fDisposalMethod"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fDisposalMethod) - 20usize];
    ["Offset of field: SkCodec_FrameInfo::fBlend"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fBlend) - 24usize];
    ["Offset of field: SkCodec_FrameInfo::fFrameRect"]
        [::core::mem::offset_of!(SkCodec_FrameInfo, fFrameRect) - 28usize];
};
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_IsAnimated {
    Yes = 0,
    No = 1,
    Unknown = 2,
}
pub use self::skcms_PixelFormat as SkCodec_XformFormat;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCodec_XformTime {
    kNo_XformTime = 0,
    kPalette_XformTime = 1,
    kDecodeRow_XformTime = 2,
}
pub type SkCodec_GetPixelsCallback = __BindgenOpaqueArray<u64, 4usize>;
pub const SkCodec_kNoFrame: ::core::ffi::c_int = -1;
pub const SkCodec_kRepetitionCountInfinite: ::core::ffi::c_int = -1;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCodec"][::core::mem::size_of::<SkCodec>() - 1120usize];
    ["Alignment of SkCodec"][::core::mem::align_of::<SkCodec>() - 8usize];
    ["Offset of field: SkCodec::fEncodedInfo"]
        [::core::mem::offset_of!(SkCodec, fEncodedInfo) - 8usize];
    ["Offset of field: SkCodec::fSrcXformFormat"]
        [::core::mem::offset_of!(SkCodec, fSrcXformFormat) - 40usize];
    ["Offset of field: SkCodec::fStream"][::core::mem::offset_of!(SkCodec, fStream) - 48usize];
    ["Offset of field: SkCodec::fNeedsRewind"]
        [::core::mem::offset_of!(SkCodec, fNeedsRewind) - 56usize];
    ["Offset of field: SkCodec::fOrigin"][::core::mem::offset_of!(SkCodec, fOrigin) - 60usize];
    ["Offset of field: SkCodec::fDstInfo"][::core::mem::offset_of!(SkCodec, fDstInfo) - 64usize];
    ["Offset of field: SkCodec::fOptions"][::core::mem::offset_of!(SkCodec, fOptions) - 88usize];
    ["Offset of field: SkCodec::fXformTime"]
        [::core::mem::offset_of!(SkCodec, fXformTime) - 112usize];
    ["Offset of field: SkCodec::fDstXformFormat"]
        [::core::mem::offset_of!(SkCodec, fDstXformFormat) - 116usize];
    ["Offset of field: SkCodec::fDstProfileStorage"]
        [::core::mem::offset_of!(SkCodec, fDstProfileStorage) - 120usize];
    ["Offset of field: SkCodec::fDstProfile"]
        [::core::mem::offset_of!(SkCodec, fDstProfile) - 1096usize];
    ["Offset of field: SkCodec::fDstXformAlphaFormat"]
        [::core::mem::offset_of!(SkCodec, fDstXformAlphaFormat) - 1104usize];
    ["Offset of field: SkCodec::fCurrScanline"]
        [::core::mem::offset_of!(SkCodec, fCurrScanline) - 1108usize];
    ["Offset of field: SkCodec::fStartedIncrementalDecode"]
        [::core::mem::offset_of!(SkCodec, fStartedIncrementalDecode) - 1112usize];
    ["Offset of field: SkCodec::fUsingCallbackForHandleFrameIndex"]
        [::core::mem::offset_of!(SkCodec, fUsingCallbackForHandleFrameIndex) - 1113usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec14ResultToStringENS_6ResultE"]
    pub fn SkCodec_ResultToString(arg1: SkCodec_Result) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec14MakeFromStreamESt10unique_ptrI8SkStreamSt14default_deleteIS1_EE6SkSpanIKN8SkCodecs7DecoderEEPNS_6ResultEP16SkPngChunkReaderNS_15SelectionPolicyE"]
    pub fn SkCodec_MakeFromStream(
        arg1: u64,
        decoders: SkSpan<SkCodecs_Decoder>,
        arg2: *mut SkCodec_Result,
        arg3: *mut SkPngChunkReader,
        selectionPolicy: SkCodec_SelectionPolicy,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec14MakeFromStreamESt10unique_ptrI8SkStreamSt14default_deleteIS1_EEPNS_6ResultEP16SkPngChunkReaderNS_15SelectionPolicyE"]
    pub fn SkCodec_MakeFromStream1(
        arg1: u64,
        arg2: *mut SkCodec_Result,
        arg3: *mut SkPngChunkReader,
        selectionPolicy: SkCodec_SelectionPolicy,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec12MakeFromDataE5sk_spI6SkDataE6SkSpanIKN8SkCodecs7DecoderEEP16SkPngChunkReader"]
    pub fn SkCodec_MakeFromData(
        arg1: sk_sp<SkData>,
        decoders: SkSpan<SkCodecs_Decoder>,
        arg2: *mut SkPngChunkReader,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec12MakeFromDataE5sk_spI6SkDataEP16SkPngChunkReader"]
    pub fn SkCodec_MakeFromData1(arg1: sk_sp<SkData>, arg2: *mut SkPngChunkReader) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec9getPixelsERK11SkImageInfoPvmPKNS_7OptionsE"]
    pub fn SkCodec_getPixels(
        this: *mut SkCodec,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        arg1: *const SkCodec_Options,
    ) -> SkCodec_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec8getImageERK11SkImageInfoPKNS_7OptionsE"]
    pub fn SkCodec_getImage(
        this: *mut SkCodec,
        info: *const SkImageInfo,
        opts: *const SkCodec_Options,
    ) -> __BindgenOpaqueArray<u64, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec8getImageEv"]
    pub fn SkCodec_getImage1(this: *mut SkCodec) -> __BindgenOpaqueArray<u64, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkCodec13queryYUVAInfoERKN16SkYUVAPixmapInfo18SupportedDataTypesEPS0_"]
    pub fn SkCodec_queryYUVAInfo(
        this: *const SkCodec,
        supportedDataTypes: *const SkYUVAPixmapInfo_SupportedDataTypes,
        yuvaPixmapInfo: *mut SkYUVAPixmapInfo,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec13getYUVAPlanesERK13SkYUVAPixmaps"]
    pub fn SkCodec_getYUVAPlanes(
        this: *mut SkCodec,
        yuvaPixmaps: *const SkYUVAPixmaps,
    ) -> SkCodec_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec22startIncrementalDecodeERK11SkImageInfoPvmPKNS_7OptionsE"]
    pub fn SkCodec_startIncrementalDecode(
        this: *mut SkCodec,
        dstInfo: *const SkImageInfo,
        dst: *mut ::core::ffi::c_void,
        rowBytes: usize,
        arg1: *const SkCodec_Options,
    ) -> SkCodec_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec19startScanlineDecodeERK11SkImageInfoPKNS_7OptionsE"]
    pub fn SkCodec_startScanlineDecode(
        this: *mut SkCodec,
        dstInfo: *const SkImageInfo,
        options: *const SkCodec_Options,
    ) -> SkCodec_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec12getScanlinesEPvim"]
    pub fn SkCodec_getScanlines(
        this: *mut SkCodec,
        dst: *mut ::core::ffi::c_void,
        countLines: ::core::ffi::c_int,
        rowBytes: usize,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec13skipScanlinesEi"]
    pub fn SkCodec_skipScanlines(this: *mut SkCodec, countLines: ::core::ffi::c_int) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkCodec14outputScanlineEi"]
    pub fn SkCodec_outputScanline(
        this: *const SkCodec,
        inputScanline: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec12getFrameInfoEv"]
    pub fn SkCodec_getFrameInfo(this: *mut SkCodec) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec17setSrcXformFormatE17skcms_PixelFormat"]
    pub fn SkCodec_setSrcXformFormat(this: *mut SkCodec, pixelFormat: SkCodec_XformFormat);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec14rewindIfNeededEv"]
    pub fn SkCodec_rewindIfNeeded(this: *mut SkCodec) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec12rewindStreamEv"]
    pub fn SkCodec_rewindStream(this: *mut SkCodec) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkCodec15applyColorXformEPvPKvi"]
    pub fn SkCodec_applyColorXform(
        this: *const SkCodec,
        dst: *mut ::core::ffi::c_void,
        src: *const ::core::ffi::c_void,
        count: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodecC2EO13SkEncodedInfo17skcms_PixelFormatSt10unique_ptrI8SkStreamSt14default_deleteIS4_EE15SkEncodedOrigin"]
    pub fn SkCodec_SkCodec(
        this: *mut SkCodec,
        arg1: *mut SkEncodedInfo,
        srcFormat: SkCodec_XformFormat,
        arg2: u64,
        arg3: SkEncodedOrigin,
    );
}
impl SkCodec {
    #[inline]
    pub unsafe fn ResultToString(arg1: SkCodec_Result) -> *const ::core::ffi::c_char {
        SkCodec_ResultToString(arg1)
    }
    #[inline]
    pub unsafe fn MakeFromStream(
        arg1: u64,
        decoders: SkSpan<SkCodecs_Decoder>,
        arg2: *mut SkCodec_Result,
        arg3: *mut SkPngChunkReader,
        selectionPolicy: SkCodec_SelectionPolicy,
    ) -> u64 {
        SkCodec_MakeFromStream(arg1, decoders, arg2, arg3, selectionPolicy)
    }
    #[inline]
    pub unsafe fn MakeFromStream1(
        arg1: u64,
        arg2: *mut SkCodec_Result,
        arg3: *mut SkPngChunkReader,
        selectionPolicy: SkCodec_SelectionPolicy,
    ) -> u64 {
        SkCodec_MakeFromStream1(arg1, arg2, arg3, selectionPolicy)
    }
    #[inline]
    pub unsafe fn MakeFromData(
        arg1: sk_sp<SkData>,
        decoders: SkSpan<SkCodecs_Decoder>,
        arg2: *mut SkPngChunkReader,
    ) -> u64 {
        SkCodec_MakeFromData(arg1, decoders, arg2)
    }
    #[inline]
    pub unsafe fn MakeFromData1(arg1: sk_sp<SkData>, arg2: *mut SkPngChunkReader) -> u64 {
        SkCodec_MakeFromData1(arg1, arg2)
    }
    #[inline]
    pub unsafe fn getPixels(
        &mut self,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        arg1: *const SkCodec_Options,
    ) -> SkCodec_Result {
        SkCodec_getPixels(self, info, pixels, rowBytes, arg1)
    }
    #[inline]
    pub unsafe fn getImage(
        &mut self,
        info: *const SkImageInfo,
        opts: *const SkCodec_Options,
    ) -> __BindgenOpaqueArray<u64, 2usize> {
        SkCodec_getImage(self, info, opts)
    }
    #[inline]
    pub unsafe fn getImage1(&mut self) -> __BindgenOpaqueArray<u64, 2usize> {
        SkCodec_getImage1(self)
    }
    #[inline]
    pub unsafe fn queryYUVAInfo(
        &self,
        supportedDataTypes: *const SkYUVAPixmapInfo_SupportedDataTypes,
        yuvaPixmapInfo: *mut SkYUVAPixmapInfo,
    ) -> bool {
        SkCodec_queryYUVAInfo(self, supportedDataTypes, yuvaPixmapInfo)
    }
    #[inline]
    pub unsafe fn getYUVAPlanes(&mut self, yuvaPixmaps: *const SkYUVAPixmaps) -> SkCodec_Result {
        SkCodec_getYUVAPlanes(self, yuvaPixmaps)
    }
    #[inline]
    pub unsafe fn startIncrementalDecode(
        &mut self,
        dstInfo: *const SkImageInfo,
        dst: *mut ::core::ffi::c_void,
        rowBytes: usize,
        arg1: *const SkCodec_Options,
    ) -> SkCodec_Result {
        SkCodec_startIncrementalDecode(self, dstInfo, dst, rowBytes, arg1)
    }
    #[inline]
    pub unsafe fn startScanlineDecode(
        &mut self,
        dstInfo: *const SkImageInfo,
        options: *const SkCodec_Options,
    ) -> SkCodec_Result {
        SkCodec_startScanlineDecode(self, dstInfo, options)
    }
    #[inline]
    pub unsafe fn getScanlines(
        &mut self,
        dst: *mut ::core::ffi::c_void,
        countLines: ::core::ffi::c_int,
        rowBytes: usize,
    ) -> ::core::ffi::c_int {
        SkCodec_getScanlines(self, dst, countLines, rowBytes)
    }
    #[inline]
    pub unsafe fn skipScanlines(&mut self, countLines: ::core::ffi::c_int) -> bool {
        SkCodec_skipScanlines(self, countLines)
    }
    #[inline]
    pub unsafe fn outputScanline(&self, inputScanline: ::core::ffi::c_int) -> ::core::ffi::c_int {
        SkCodec_outputScanline(self, inputScanline)
    }
    #[inline]
    pub unsafe fn getFrameInfo(&mut self) -> u8 {
        SkCodec_getFrameInfo(self)
    }
    #[inline]
    pub unsafe fn setSrcXformFormat(&mut self, pixelFormat: SkCodec_XformFormat) {
        SkCodec_setSrcXformFormat(self, pixelFormat)
    }
    #[inline]
    pub unsafe fn rewindIfNeeded(&mut self) -> bool {
        SkCodec_rewindIfNeeded(self)
    }
    #[inline]
    pub unsafe fn rewindStream(&mut self) -> bool {
        SkCodec_rewindStream(self)
    }
    #[inline]
    pub unsafe fn applyColorXform(
        &self,
        dst: *mut ::core::ffi::c_void,
        src: *const ::core::ffi::c_void,
        count: ::core::ffi::c_int,
    ) {
        SkCodec_applyColorXform(self, dst, src, count)
    }
    #[inline]
    pub unsafe fn new(
        arg1: *mut SkEncodedInfo,
        srcFormat: SkCodec_XformFormat,
        arg2: u64,
        arg3: SkEncodedOrigin,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCodec_SkCodec(__bindgen_tmp.as_mut_ptr(), arg1, srcFormat, arg2, arg3);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodecD1Ev"]
    pub fn SkCodec_SkCodec_destructor(this: *mut SkCodec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkCodec14getEncodedDataEv"]
    pub fn SkCodec_getEncodedData(this: *mut ::core::ffi::c_void) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkCodec16onOutputScanlineEi"]
    pub fn SkCodec_onOutputScanline(
        this: *mut ::core::ffi::c_void,
        inputScanline: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkCodec19conversionSupportedERK11SkImageInfobb"]
    pub fn SkCodec_conversionSupported(
        this: *mut ::core::ffi::c_void,
        dst: *const SkImageInfo,
        srcIsOpaque: bool,
        needsColorXform: bool,
    ) -> bool;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkEncodedImageFormat {
    BMP = 0,
    GIF = 1,
    ICO = 2,
    JPEG = 3,
    PNG = 4,
    WBMP = 5,
    WEBP = 6,
    PKM = 7,
    KTX = 8,
    ASTC = 9,
    DNG = 10,
    HEIF = 11,
    AVIF = 12,
    JPEGXL = 13,
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z21SkAnnotateRectWithURLP8SkCanvasRK6SkRectP6SkData"]
    pub fn SkAnnotateRectWithURL(arg1: *mut SkCanvas, arg2: *const SkRect, arg3: *mut SkData);
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z26SkAnnotateNamedDestinationP8SkCanvasRK7SkPointP6SkData"]
    pub fn SkAnnotateNamedDestination(arg1: *mut SkCanvas, arg2: *const SkPoint, arg3: *mut SkData);
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z27SkAnnotateLinkToDestinationP8SkCanvasRK6SkRectP6SkData"]
    pub fn SkAnnotateLinkToDestination(arg1: *mut SkCanvas, arg2: *const SkRect, arg3: *mut SkData);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkArc {
    pub fOval: SkRect,
    pub fStartAngle: SkScalar,
    pub fSweepAngle: SkScalar,
    pub fType: SkArc_Type,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkArc_Type {
    Arc = 0,
    Wedge = 1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkArc"][::core::mem::size_of::<SkArc>() - 28usize];
    ["Alignment of SkArc"][::core::mem::align_of::<SkArc>() - 4usize];
    ["Offset of field: SkArc::fOval"][::core::mem::offset_of!(SkArc, fOval) - 0usize];
    ["Offset of field: SkArc::fStartAngle"][::core::mem::offset_of!(SkArc, fStartAngle) - 16usize];
    ["Offset of field: SkArc::fSweepAngle"][::core::mem::offset_of!(SkArc, fSweepAngle) - 20usize];
    ["Offset of field: SkArc::fType"][::core::mem::offset_of!(SkArc, fType) - 24usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkBBoxHierarchy {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkBBoxHierarchy_Metadata {
    pub isDraw: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBBoxHierarchy_Metadata"]
        [::core::mem::size_of::<SkBBoxHierarchy_Metadata>() - 1usize];
    ["Alignment of SkBBoxHierarchy_Metadata"]
        [::core::mem::align_of::<SkBBoxHierarchy_Metadata>() - 1usize];
    ["Offset of field: SkBBoxHierarchy_Metadata::isDraw"]
        [::core::mem::offset_of!(SkBBoxHierarchy_Metadata, isDraw) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBBoxHierarchy"][::core::mem::size_of::<SkBBoxHierarchy>() - 16usize];
    ["Alignment of SkBBoxHierarchy"][::core::mem::align_of::<SkBBoxHierarchy>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkBBoxHierarchy6insertEPK6SkRectPKNS_8MetadataEi"]
    pub fn SkBBoxHierarchy_insert1(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkRect,
        arg2: *const SkBBoxHierarchy_Metadata,
        N: ::core::ffi::c_int,
    );
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkBBHFactory {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBBHFactory"][::core::mem::size_of::<SkBBHFactory>() - 8usize];
    ["Alignment of SkBBHFactory"][::core::mem::align_of::<SkBBHFactory>() - 8usize];
};
impl SkBlendMode {
    pub const LastCoeffMode: SkBlendMode = SkBlendMode::Screen;
}
impl SkBlendMode {
    pub const LastSeparableMode: SkBlendMode = SkBlendMode::Multiply;
}
impl SkBlendMode {
    pub const LastMode: SkBlendMode = SkBlendMode::Luminosity;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkBlendMode {
    Clear = 0,
    Src = 1,
    Dst = 2,
    SrcOver = 3,
    DstOver = 4,
    SrcIn = 5,
    DstIn = 6,
    SrcOut = 7,
    DstOut = 8,
    SrcATop = 9,
    DstATop = 10,
    Xor = 11,
    Plus = 12,
    Modulate = 13,
    Screen = 14,
    Overlay = 15,
    Darken = 16,
    Lighten = 17,
    ColorDodge = 18,
    ColorBurn = 19,
    HardLight = 20,
    SoftLight = 21,
    Difference = 22,
    Exclusion = 23,
    Multiply = 24,
    Hue = 25,
    Saturation = 26,
    Color = 27,
    Luminosity = 28,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkBlendModeCoeff {
    Zero = 0,
    One = 1,
    SC = 2,
    ISC = 3,
    DC = 4,
    IDC = 5,
    SA = 6,
    ISA = 7,
    DA = 8,
    IDA = 9,
    CoeffCount = 10,
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z19SkBlendMode_AsCoeff11SkBlendModeP16SkBlendModeCoeffS1_"]
    pub fn SkBlendMode_AsCoeff(
        mode: SkBlendMode,
        src: *mut SkBlendModeCoeff,
        dst: *mut SkBlendModeCoeff,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z16SkBlendMode_Name11SkBlendMode"]
    pub fn SkBlendMode_Name(blendMode: SkBlendMode) -> *const ::core::ffi::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkMipmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkMaskBuilder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct SkBitmap {
    pub fPixelRef: sk_sp<SkPixelRef>,
    pub fPixmap: SkPixmap,
    pub fMips: sk_sp<SkMipmap>,
}
pub const SkBitmap_AllocFlags_kZeroPixels_AllocFlag: SkBitmap_AllocFlags = 1;
pub type SkBitmap_AllocFlags = ::core::ffi::c_uint;
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkBitmap_Allocator {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
pub type SkBitmap_Allocator_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBitmap_Allocator"][::core::mem::size_of::<SkBitmap_Allocator>() - 16usize];
    ["Alignment of SkBitmap_Allocator"][::core::mem::align_of::<SkBitmap_Allocator>() - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkBitmap_HeapAllocator {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBitmap_HeapAllocator"][::core::mem::size_of::<SkBitmap_HeapAllocator>() - 16usize];
    ["Alignment of SkBitmap_HeapAllocator"]
        [::core::mem::align_of::<SkBitmap_HeapAllocator>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBitmap"][::core::mem::size_of::<SkBitmap>() - 56usize];
    ["Alignment of SkBitmap"][::core::mem::align_of::<SkBitmap>() - 8usize];
    ["Offset of field: SkBitmap::fPixelRef"][::core::mem::offset_of!(SkBitmap, fPixelRef) - 0usize];
    ["Offset of field: SkBitmap::fPixmap"][::core::mem::offset_of!(SkBitmap, fPixmap) - 8usize];
    ["Offset of field: SkBitmap::fMips"][::core::mem::offset_of!(SkBitmap, fMips) - 48usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap4swapERS_"]
    pub fn SkBitmap_swap(this: *mut SkBitmap, other: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10colorSpaceEv"]
    pub fn SkBitmap_colorSpace(this: *const SkBitmap) -> *mut SkColorSpace;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap13refColorSpaceEv"]
    pub fn SkBitmap_refColorSpace(this: *const SkBitmap) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap12setAlphaTypeE11SkAlphaType"]
    pub fn SkBitmap_setAlphaType(this: *mut SkBitmap, alphaType: SkAlphaType) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap13setColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkBitmap_setColorSpace(this: *mut SkBitmap, colorSpace: sk_sp<SkColorSpace>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap11isImmutableEv"]
    pub fn SkBitmap_isImmutable(this: *const SkBitmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap12setImmutableEv"]
    pub fn SkBitmap_setImmutable(this: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap5resetEv"]
    pub fn SkBitmap_reset(this: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap9getBoundsEP6SkRect"]
    pub fn SkBitmap_getBounds(this: *const SkBitmap, bounds: *mut SkRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap9getBoundsEP7SkIRect"]
    pub fn SkBitmap_getBounds1(this: *const SkBitmap, bounds: *mut SkIRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap7setInfoERK11SkImageInfom"]
    pub fn SkBitmap_setInfo(
        this: *mut SkBitmap,
        imageInfo: *const SkImageInfo,
        rowBytes: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap19tryAllocPixelsFlagsERK11SkImageInfoj"]
    pub fn SkBitmap_tryAllocPixelsFlags(
        this: *mut SkBitmap,
        info: *const SkImageInfo,
        flags: u32,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap16allocPixelsFlagsERK11SkImageInfoj"]
    pub fn SkBitmap_allocPixelsFlags(this: *mut SkBitmap, info: *const SkImageInfo, flags: u32);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap14tryAllocPixelsERK11SkImageInfom"]
    pub fn SkBitmap_tryAllocPixels(
        this: *mut SkBitmap,
        info: *const SkImageInfo,
        rowBytes: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11allocPixelsERK11SkImageInfom"]
    pub fn SkBitmap_allocPixels(this: *mut SkBitmap, info: *const SkImageInfo, rowBytes: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11allocPixelsERK11SkImageInfo"]
    pub fn SkBitmap_allocPixels1(this: *mut SkBitmap, info: *const SkImageInfo);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap17tryAllocN32PixelsEiib"]
    pub fn SkBitmap_tryAllocN32Pixels(
        this: *mut SkBitmap,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        isOpaque: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap14allocN32PixelsEiib"]
    pub fn SkBitmap_allocN32Pixels(
        this: *mut SkBitmap,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        isOpaque: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap13installPixelsERK11SkImageInfoPvmPFvS3_S3_ES3_"]
    pub fn SkBitmap_installPixels(
        this: *mut SkBitmap,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        releaseProc: ::core::option::Option<
            unsafe extern "C" fn(addr: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void),
        >,
        context: *mut ::core::ffi::c_void,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap13installPixelsERK8SkPixmap"]
    pub fn SkBitmap_installPixels1(this: *mut SkBitmap, pixmap: *const SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap17installMaskPixelsER13SkMaskBuilder"]
    pub fn SkBitmap_installMaskPixels(this: *mut SkBitmap, mask: *mut SkMaskBuilder) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap9setPixelsEPv"]
    pub fn SkBitmap_setPixels(this: *mut SkBitmap, pixels: *mut ::core::ffi::c_void);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11allocPixelsEv"]
    pub fn SkBitmap_allocPixels2(this: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap14tryAllocPixelsEPNS_9AllocatorE"]
    pub fn SkBitmap_tryAllocPixels1(
        this: *mut SkBitmap,
        allocator: *mut SkBitmap_Allocator,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11allocPixelsEPNS_9AllocatorE"]
    pub fn SkBitmap_allocPixels3(this: *mut SkBitmap, allocator: *mut SkBitmap_Allocator);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap14pixelRefOriginEv"]
    pub fn SkBitmap_pixelRefOrigin(this: *const SkBitmap) -> SkIPoint;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11setPixelRefE5sk_spI10SkPixelRefEii"]
    pub fn SkBitmap_setPixelRef(
        this: *mut SkBitmap,
        pixelRef: sk_sp<SkPixelRef>,
        dx: ::core::ffi::c_int,
        dy: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap15getGenerationIDEv"]
    pub fn SkBitmap_getGenerationID(this: *const SkBitmap) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap19notifyPixelsChangedEv"]
    pub fn SkBitmap_notifyPixelsChanged(this: *const SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10eraseColorE8SkRGBA4fIL11SkAlphaType3EE"]
    pub fn SkBitmap_eraseColor(this: *const SkBitmap, arg1: SkColor4f);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10eraseColorEj"]
    pub fn SkBitmap_eraseColor1(this: *const SkBitmap, c: SkColor);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap5eraseE8SkRGBA4fIL11SkAlphaType3EERK7SkIRect"]
    pub fn SkBitmap_erase(this: *const SkBitmap, c: SkColor4f, area: *const SkIRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap5eraseEjRK7SkIRect"]
    pub fn SkBitmap_erase1(this: *const SkBitmap, c: SkColor, area: *const SkIRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap7getAddrEii"]
    pub fn SkBitmap_getAddr(
        this: *const SkBitmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap13extractSubsetEPS_RK7SkIRect"]
    pub fn SkBitmap_extractSubset(
        this: *const SkBitmap,
        dst: *mut SkBitmap,
        subset: *const SkIRect,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10readPixelsERK11SkImageInfoPvmii"]
    pub fn SkBitmap_readPixels(
        this: *const SkBitmap,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10readPixelsERK8SkPixmapii"]
    pub fn SkBitmap_readPixels1(
        this: *const SkBitmap,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap11writePixelsERK8SkPixmapii"]
    pub fn SkBitmap_writePixels(
        this: *mut SkBitmap,
        src: *const SkPixmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap12extractAlphaEPS_PK7SkPaintPNS_9AllocatorEP8SkIPoint"]
    pub fn SkBitmap_extractAlpha(
        this: *const SkBitmap,
        dst: *mut SkBitmap,
        paint: *const SkPaint,
        allocator: *mut SkBitmap_Allocator,
        offset: *mut SkIPoint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10peekPixelsEP8SkPixmap"]
    pub fn SkBitmap_peekPixels(this: *const SkBitmap, pixmap: *mut SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10makeShaderE10SkTileModeS0_RK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkBitmap_makeShader(
        this: *const SkBitmap,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10makeShaderE10SkTileModeS0_RK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkBitmap_makeShader1(
        this: *const SkBitmap,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10makeShaderERK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkBitmap_makeShader2(
        this: *const SkBitmap,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap10makeShaderERK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkBitmap_makeShader3(
        this: *const SkBitmap,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkBitmap7asImageEv"]
    pub fn SkBitmap_asImage(this: *const SkBitmap) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmapC1Ev"]
    pub fn SkBitmap_SkBitmap(this: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmapC1ERKS_"]
    pub fn SkBitmap_SkBitmap1(this: *mut SkBitmap, src: *const SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmapC1EOS_"]
    pub fn SkBitmap_SkBitmap2(this: *mut SkBitmap, src: *mut SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmapD1Ev"]
    pub fn SkBitmap_SkBitmap_destructor(this: *mut SkBitmap);
}
impl SkBitmap {
    #[inline]
    pub unsafe fn swap(&mut self, other: *mut SkBitmap) {
        SkBitmap_swap(self, other)
    }
    #[inline]
    pub unsafe fn colorSpace(&self) -> *mut SkColorSpace {
        SkBitmap_colorSpace(self)
    }
    #[inline]
    pub unsafe fn refColorSpace(&self) -> sk_sp<SkColorSpace> {
        SkBitmap_refColorSpace(self)
    }
    #[inline]
    pub unsafe fn setAlphaType(&mut self, alphaType: SkAlphaType) -> bool {
        SkBitmap_setAlphaType(self, alphaType)
    }
    #[inline]
    pub unsafe fn setColorSpace(&mut self, colorSpace: sk_sp<SkColorSpace>) {
        SkBitmap_setColorSpace(self, colorSpace)
    }
    #[inline]
    pub unsafe fn isImmutable(&self) -> bool {
        SkBitmap_isImmutable(self)
    }
    #[inline]
    pub unsafe fn setImmutable(&mut self) {
        SkBitmap_setImmutable(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkBitmap_reset(self)
    }
    #[inline]
    pub unsafe fn getBounds(&self, bounds: *mut SkRect) {
        SkBitmap_getBounds(self, bounds)
    }
    #[inline]
    pub unsafe fn getBounds1(&self, bounds: *mut SkIRect) {
        SkBitmap_getBounds1(self, bounds)
    }
    #[inline]
    pub unsafe fn setInfo(&mut self, imageInfo: *const SkImageInfo, rowBytes: usize) -> bool {
        SkBitmap_setInfo(self, imageInfo, rowBytes)
    }
    #[inline]
    pub unsafe fn tryAllocPixelsFlags(&mut self, info: *const SkImageInfo, flags: u32) -> bool {
        SkBitmap_tryAllocPixelsFlags(self, info, flags)
    }
    #[inline]
    pub unsafe fn allocPixelsFlags(&mut self, info: *const SkImageInfo, flags: u32) {
        SkBitmap_allocPixelsFlags(self, info, flags)
    }
    #[inline]
    pub unsafe fn tryAllocPixels(&mut self, info: *const SkImageInfo, rowBytes: usize) -> bool {
        SkBitmap_tryAllocPixels(self, info, rowBytes)
    }
    #[inline]
    pub unsafe fn allocPixels(&mut self, info: *const SkImageInfo, rowBytes: usize) {
        SkBitmap_allocPixels(self, info, rowBytes)
    }
    #[inline]
    pub unsafe fn allocPixels1(&mut self, info: *const SkImageInfo) {
        SkBitmap_allocPixels1(self, info)
    }
    #[inline]
    pub unsafe fn tryAllocN32Pixels(
        &mut self,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        isOpaque: bool,
    ) -> bool {
        SkBitmap_tryAllocN32Pixels(self, width, height, isOpaque)
    }
    #[inline]
    pub unsafe fn allocN32Pixels(
        &mut self,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        isOpaque: bool,
    ) {
        SkBitmap_allocN32Pixels(self, width, height, isOpaque)
    }
    #[inline]
    pub unsafe fn installPixels(
        &mut self,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        releaseProc: ::core::option::Option<
            unsafe extern "C" fn(addr: *mut ::core::ffi::c_void, context: *mut ::core::ffi::c_void),
        >,
        context: *mut ::core::ffi::c_void,
    ) -> bool {
        SkBitmap_installPixels(self, info, pixels, rowBytes, releaseProc, context)
    }
    #[inline]
    pub unsafe fn installPixels1(&mut self, pixmap: *const SkPixmap) -> bool {
        SkBitmap_installPixels1(self, pixmap)
    }
    #[inline]
    pub unsafe fn installMaskPixels(&mut self, mask: *mut SkMaskBuilder) -> bool {
        SkBitmap_installMaskPixels(self, mask)
    }
    #[inline]
    pub unsafe fn setPixels(&mut self, pixels: *mut ::core::ffi::c_void) {
        SkBitmap_setPixels(self, pixels)
    }
    #[inline]
    pub unsafe fn allocPixels2(&mut self) {
        SkBitmap_allocPixels2(self)
    }
    #[inline]
    pub unsafe fn tryAllocPixels1(&mut self, allocator: *mut SkBitmap_Allocator) -> bool {
        SkBitmap_tryAllocPixels1(self, allocator)
    }
    #[inline]
    pub unsafe fn allocPixels3(&mut self, allocator: *mut SkBitmap_Allocator) {
        SkBitmap_allocPixels3(self, allocator)
    }
    #[inline]
    pub unsafe fn pixelRefOrigin(&self) -> SkIPoint {
        SkBitmap_pixelRefOrigin(self)
    }
    #[inline]
    pub unsafe fn setPixelRef(
        &mut self,
        pixelRef: sk_sp<SkPixelRef>,
        dx: ::core::ffi::c_int,
        dy: ::core::ffi::c_int,
    ) {
        SkBitmap_setPixelRef(self, pixelRef, dx, dy)
    }
    #[inline]
    pub unsafe fn getGenerationID(&self) -> u32 {
        SkBitmap_getGenerationID(self)
    }
    #[inline]
    pub unsafe fn notifyPixelsChanged(&self) {
        SkBitmap_notifyPixelsChanged(self)
    }
    #[inline]
    pub unsafe fn eraseColor(&self, arg1: SkColor4f) {
        SkBitmap_eraseColor(self, arg1)
    }
    #[inline]
    pub unsafe fn eraseColor1(&self, c: SkColor) {
        SkBitmap_eraseColor1(self, c)
    }
    #[inline]
    pub unsafe fn erase(&self, c: SkColor4f, area: *const SkIRect) {
        SkBitmap_erase(self, c, area)
    }
    #[inline]
    pub unsafe fn erase1(&self, c: SkColor, area: *const SkIRect) {
        SkBitmap_erase1(self, c, area)
    }
    #[inline]
    pub unsafe fn getAddr(
        &self,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> *mut ::core::ffi::c_void {
        SkBitmap_getAddr(self, x, y)
    }
    #[inline]
    pub unsafe fn extractSubset(&self, dst: *mut SkBitmap, subset: *const SkIRect) -> bool {
        SkBitmap_extractSubset(self, dst, subset)
    }
    #[inline]
    pub unsafe fn readPixels(
        &self,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkBitmap_readPixels(self, dstInfo, dstPixels, dstRowBytes, srcX, srcY)
    }
    #[inline]
    pub unsafe fn readPixels1(
        &self,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkBitmap_readPixels1(self, dst, srcX, srcY)
    }
    #[inline]
    pub unsafe fn writePixels(
        &mut self,
        src: *const SkPixmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    ) -> bool {
        SkBitmap_writePixels(self, src, dstX, dstY)
    }
    #[inline]
    pub unsafe fn extractAlpha(
        &self,
        dst: *mut SkBitmap,
        paint: *const SkPaint,
        allocator: *mut SkBitmap_Allocator,
        offset: *mut SkIPoint,
    ) -> bool {
        SkBitmap_extractAlpha(self, dst, paint, allocator, offset)
    }
    #[inline]
    pub unsafe fn peekPixels(&self, pixmap: *mut SkPixmap) -> bool {
        SkBitmap_peekPixels(self, pixmap)
    }
    #[inline]
    pub unsafe fn makeShader(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkBitmap_makeShader(self, tmx, tmy, arg1, localMatrix)
    }
    #[inline]
    pub unsafe fn makeShader1(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkBitmap_makeShader1(self, tmx, tmy, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeShader2(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkBitmap_makeShader2(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeShader3(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkBitmap_makeShader3(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn asImage(&self) -> sk_sp<SkImage> {
        SkBitmap_asImage(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkBitmap_SkBitmap(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(src: *const SkBitmap) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkBitmap_SkBitmap1(__bindgen_tmp.as_mut_ptr(), src);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(src: *mut SkBitmap) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkBitmap_SkBitmap2(__bindgen_tmp.as_mut_ptr(), src);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkBitmap_SkBitmap_destructor(self)
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkBitmap13HeapAllocator13allocPixelRefEPS_"]
    pub fn SkBitmap_HeapAllocator_allocPixelRef(
        this: *mut ::core::ffi::c_void,
        bitmap: *mut SkBitmap,
    ) -> bool;
}
impl SkBlurStyle {
    pub const LastEnum: SkBlurStyle = SkBlurStyle::Inner;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkBlurStyle {
    Normal = 0,
    Solid = 1,
    Outer = 2,
    Inner = 3,
}
impl SkClipOp {
    pub const Max_EnumValue: SkClipOp = SkClipOp::Intersect;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkClipOp {
    Difference = 0,
    Intersect = 1,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTextEncoding {
    kUTF8 = 0,
    kUTF16 = 1,
    kUTF32 = 2,
    kGlyphID = 3,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFontHinting {
    None = 0,
    Slight = 1,
    Normal = 2,
    Full = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkReadBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkWriteBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDeserialProcs {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSerialProcs {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkFlattenable {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFlattenable_Type {
    SkColorFilter = 0,
    SkBlender = 1,
    SkDrawable = 2,
    SkDrawLooper = 3,
    SkImageFilter = 4,
    SkMaskFilter = 5,
    SkPathEffect = 6,
    SkShader = 7,
}
pub type SkFlattenable_Factory =
    ::core::option::Option<unsafe extern "C" fn(arg1: *mut SkReadBuffer) -> sk_sp<SkFlattenable>>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFlattenable_PrivateInitializer {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFlattenable_PrivateInitializer"]
        [::core::mem::size_of::<SkFlattenable_PrivateInitializer>() - 1usize];
    ["Alignment of SkFlattenable_PrivateInitializer"]
        [::core::mem::align_of::<SkFlattenable_PrivateInitializer>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable18PrivateInitializer11InitEffectsEv"]
    pub fn SkFlattenable_PrivateInitializer_InitEffects();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable18PrivateInitializer16InitImageFiltersEv"]
    pub fn SkFlattenable_PrivateInitializer_InitImageFilters();
}
impl SkFlattenable_PrivateInitializer {
    #[inline]
    pub unsafe fn InitEffects() {
        SkFlattenable_PrivateInitializer_InitEffects()
    }
    #[inline]
    pub unsafe fn InitImageFilters() {
        SkFlattenable_PrivateInitializer_InitImageFilters()
    }
}
pub type SkFlattenable_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFlattenable"][::core::mem::size_of::<SkFlattenable>() - 16usize];
    ["Alignment of SkFlattenable"][::core::mem::align_of::<SkFlattenable>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable13NameToFactoryEPKc"]
    pub fn SkFlattenable_NameToFactory(name: *const ::core::ffi::c_char) -> SkFlattenable_Factory;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable13FactoryToNameEPF5sk_spIS_ER12SkReadBufferE"]
    pub fn SkFlattenable_FactoryToName(arg1: SkFlattenable_Factory) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable8RegisterEPKcPF5sk_spIS_ER12SkReadBufferE"]
    pub fn SkFlattenable_Register(name: *const ::core::ffi::c_char, arg1: SkFlattenable_Factory);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkFlattenable9serializeEPK13SkSerialProcs"]
    pub fn SkFlattenable_serialize(
        this: *const SkFlattenable,
        arg1: *const SkSerialProcs,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkFlattenable9serializeEPvmPK13SkSerialProcs"]
    pub fn SkFlattenable_serialize1(
        this: *const SkFlattenable,
        memory: *mut ::core::ffi::c_void,
        memory_size: usize,
        arg1: *const SkSerialProcs,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkFlattenable11DeserializeENS_4TypeEPKvmPK15SkDeserialProcs"]
    pub fn SkFlattenable_Deserialize(
        arg1: SkFlattenable_Type,
        data: *const ::core::ffi::c_void,
        length: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkFlattenable>;
}
impl SkFlattenable {
    #[inline]
    pub unsafe fn NameToFactory(name: *const ::core::ffi::c_char) -> SkFlattenable_Factory {
        SkFlattenable_NameToFactory(name)
    }
    #[inline]
    pub unsafe fn FactoryToName(arg1: SkFlattenable_Factory) -> *const ::core::ffi::c_char {
        SkFlattenable_FactoryToName(arg1)
    }
    #[inline]
    pub unsafe fn Register(name: *const ::core::ffi::c_char, arg1: SkFlattenable_Factory) {
        SkFlattenable_Register(name, arg1)
    }
    #[inline]
    pub unsafe fn serialize(&self, arg1: *const SkSerialProcs) -> sk_sp<SkData> {
        SkFlattenable_serialize(self, arg1)
    }
    #[inline]
    pub unsafe fn serialize1(
        &self,
        memory: *mut ::core::ffi::c_void,
        memory_size: usize,
        arg1: *const SkSerialProcs,
    ) -> usize {
        SkFlattenable_serialize1(self, memory, memory_size, arg1)
    }
    #[inline]
    pub unsafe fn Deserialize(
        arg1: SkFlattenable_Type,
        data: *const ::core::ffi::c_void,
        length: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkFlattenable> {
        SkFlattenable_Deserialize(arg1, data, length, procs)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkImageFilter {
    pub _base: SkFlattenable,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImageFilter_MapDirection {
    Forward = 0,
    Reverse = 1,
}
pub type SkImageFilter_INHERITED = SkFlattenable;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImageFilter"][::core::mem::size_of::<SkImageFilter>() - 16usize];
    ["Alignment of SkImageFilter"][::core::mem::align_of::<SkImageFilter>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter12filterBoundsERK7SkIRectRK8SkMatrixNS_12MapDirectionEPS1_"]
    pub fn SkImageFilter_filterBounds(
        this: *const SkImageFilter,
        src: *const SkIRect,
        ctm: *const SkMatrix,
        arg1: SkImageFilter_MapDirection,
        inputRect: *const SkIRect,
    ) -> SkIRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter17isColorFilterNodeEPP13SkColorFilter"]
    pub fn SkImageFilter_isColorFilterNode(
        this: *const SkImageFilter,
        filterPtr: *mut *mut SkColorFilter,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter14asAColorFilterEPP13SkColorFilter"]
    pub fn SkImageFilter_asAColorFilter(
        this: *const SkImageFilter,
        filterPtr: *mut *mut SkColorFilter,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter11countInputsEv"]
    pub fn SkImageFilter_countInputs(this: *const SkImageFilter) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter8getInputEi"]
    pub fn SkImageFilter_getInput(
        this: *const SkImageFilter,
        i: ::core::ffi::c_int,
    ) -> *const SkImageFilter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter20canComputeFastBoundsEv"]
    pub fn SkImageFilter_canComputeFastBounds(this: *const SkImageFilter) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter19makeWithLocalMatrixERK8SkMatrix"]
    pub fn SkImageFilter_makeWithLocalMatrix(
        this: *const SkImageFilter,
        matrix: *const SkMatrix,
    ) -> sk_sp<SkImageFilter>;
}
impl SkImageFilter {
    #[inline]
    pub unsafe fn filterBounds(
        &self,
        src: *const SkIRect,
        ctm: *const SkMatrix,
        arg1: SkImageFilter_MapDirection,
        inputRect: *const SkIRect,
    ) -> SkIRect {
        SkImageFilter_filterBounds(self, src, ctm, arg1, inputRect)
    }
    #[inline]
    pub unsafe fn isColorFilterNode(&self, filterPtr: *mut *mut SkColorFilter) -> bool {
        SkImageFilter_isColorFilterNode(self, filterPtr)
    }
    #[inline]
    pub unsafe fn asAColorFilter(&self, filterPtr: *mut *mut SkColorFilter) -> bool {
        SkImageFilter_asAColorFilter(self, filterPtr)
    }
    #[inline]
    pub unsafe fn countInputs(&self) -> ::core::ffi::c_int {
        SkImageFilter_countInputs(self)
    }
    #[inline]
    pub unsafe fn getInput(&self, i: ::core::ffi::c_int) -> *const SkImageFilter {
        SkImageFilter_getInput(self, i)
    }
    #[inline]
    pub unsafe fn canComputeFastBounds(&self) -> bool {
        SkImageFilter_canComputeFastBounds(self)
    }
    #[inline]
    pub unsafe fn makeWithLocalMatrix(&self, matrix: *const SkMatrix) -> sk_sp<SkImageFilter> {
        SkImageFilter_makeWithLocalMatrix(self, matrix)
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkImageFilter17computeFastBoundsERK6SkRect"]
    pub fn SkImageFilter_computeFastBounds(
        this: *mut ::core::ffi::c_void,
        bounds: *const SkRect,
    ) -> SkRect;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkV2 {
    pub x: f32,
    pub y: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkV2"][::core::mem::size_of::<SkV2>() - 8usize];
    ["Alignment of SkV2"][::core::mem::align_of::<SkV2>() - 4usize];
    ["Offset of field: SkV2::x"][::core::mem::offset_of!(SkV2, x) - 0usize];
    ["Offset of field: SkV2::y"][::core::mem::offset_of!(SkV2, y) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkV3 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkV3"][::core::mem::size_of::<SkV3>() - 12usize];
    ["Alignment of SkV3"][::core::mem::align_of::<SkV3>() - 4usize];
    ["Offset of field: SkV3::x"][::core::mem::offset_of!(SkV3, x) - 0usize];
    ["Offset of field: SkV3::y"][::core::mem::offset_of!(SkV3, y) - 4usize];
    ["Offset of field: SkV3::z"][::core::mem::offset_of!(SkV3, z) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkV4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkV4"][::core::mem::size_of::<SkV4>() - 16usize];
    ["Alignment of SkV4"][::core::mem::align_of::<SkV4>() - 4usize];
    ["Offset of field: SkV4::x"][::core::mem::offset_of!(SkV4, x) - 0usize];
    ["Offset of field: SkV4::y"][::core::mem::offset_of!(SkV4, y) - 4usize];
    ["Offset of field: SkV4::z"][::core::mem::offset_of!(SkV4, z) - 8usize];
    ["Offset of field: SkV4::w"][::core::mem::offset_of!(SkV4, w) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkM44 {
    pub fMat: [SkScalar; 16usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkM44_Uninitialized_Constructor {
    kUninitialized_Constructor = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkM44_NaN_Constructor {
    kNaN_Constructor = 0,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkM44"][::core::mem::size_of::<SkM44>() - 64usize];
    ["Alignment of SkM44"][::core::mem::align_of::<SkM44>() - 4usize];
    ["Offset of field: SkM44::fMat"][::core::mem::offset_of!(SkM44, fMat) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4410RectToRectERK6SkRectS2_"]
    pub fn SkM44_RectToRect(src: *const SkRect, dst: *const SkRect) -> SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM446LookAtERK4SkV3S2_S2_"]
    pub fn SkM44_LookAt(eye: *const SkV3, center: *const SkV3, up: *const SkV3) -> SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4411PerspectiveEfff"]
    pub fn SkM44_Perspective(near: f32, far: f32, angle: f32) -> SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkM4411getRowMajorEPf"]
    pub fn SkM44_getRowMajor(this: *const SkM44, v: *mut SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4419setRotateUnitSinCosE4SkV3ff"]
    pub fn SkM44_setRotateUnitSinCos(
        this: *mut SkM44,
        axis: SkV3,
        sinAngle: SkScalar,
        cosAngle: SkScalar,
    ) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM449setRotateE4SkV3f"]
    pub fn SkM44_setRotate(this: *mut SkM44, axis: SkV3, radians: SkScalar) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM449setConcatERKS_S1_"]
    pub fn SkM44_setConcat(this: *mut SkM44, a: *const SkM44, b: *const SkM44) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4420normalizePerspectiveEv"]
    pub fn SkM44_normalizePerspective(this: *mut SkM44);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkM446invertEPS_"]
    pub fn SkM44_invert(this: *const SkM44, inverse: *mut SkM44) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkM449transposeEv"]
    pub fn SkM44_transpose(this: *const SkM44) -> SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkM444dumpEv"]
    pub fn SkM44_dump(this: *const SkM44);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkM443mapEffff"]
    pub fn SkM44_map(this: *const SkM44, x: f32, y: f32, z: f32, w: f32) -> SkV4;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4412preTranslateEfff"]
    pub fn SkM44_preTranslate(
        this: *mut SkM44,
        x: SkScalar,
        y: SkScalar,
        z: SkScalar,
    ) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM4413postTranslateEfff"]
    pub fn SkM44_postTranslate(
        this: *mut SkM44,
        x: SkScalar,
        y: SkScalar,
        z: SkScalar,
    ) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM448preScaleEff"]
    pub fn SkM44_preScale(this: *mut SkM44, x: SkScalar, y: SkScalar) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM448preScaleEfff"]
    pub fn SkM44_preScale1(this: *mut SkM44, x: SkScalar, y: SkScalar, z: SkScalar) -> *mut SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkM449preConcatERK8SkMatrix"]
    pub fn SkM44_preConcat(this: *mut SkM44, arg1: *const SkMatrix) -> *mut SkM44;
}
impl SkM44 {
    #[inline]
    pub unsafe fn RectToRect(src: *const SkRect, dst: *const SkRect) -> SkM44 {
        SkM44_RectToRect(src, dst)
    }
    #[inline]
    pub unsafe fn LookAt(eye: *const SkV3, center: *const SkV3, up: *const SkV3) -> SkM44 {
        SkM44_LookAt(eye, center, up)
    }
    #[inline]
    pub unsafe fn Perspective(near: f32, far: f32, angle: f32) -> SkM44 {
        SkM44_Perspective(near, far, angle)
    }
    #[inline]
    pub unsafe fn getRowMajor(&self, v: *mut SkScalar) {
        SkM44_getRowMajor(self, v)
    }
    #[inline]
    pub unsafe fn setRotateUnitSinCos(
        &mut self,
        axis: SkV3,
        sinAngle: SkScalar,
        cosAngle: SkScalar,
    ) -> *mut SkM44 {
        SkM44_setRotateUnitSinCos(self, axis, sinAngle, cosAngle)
    }
    #[inline]
    pub unsafe fn setRotate(&mut self, axis: SkV3, radians: SkScalar) -> *mut SkM44 {
        SkM44_setRotate(self, axis, radians)
    }
    #[inline]
    pub unsafe fn setConcat(&mut self, a: *const SkM44, b: *const SkM44) -> *mut SkM44 {
        SkM44_setConcat(self, a, b)
    }
    #[inline]
    pub unsafe fn normalizePerspective(&mut self) {
        SkM44_normalizePerspective(self)
    }
    #[inline]
    pub unsafe fn invert(&self, inverse: *mut SkM44) -> bool {
        SkM44_invert(self, inverse)
    }
    #[inline]
    pub unsafe fn transpose(&self) -> SkM44 {
        SkM44_transpose(self)
    }
    #[inline]
    pub unsafe fn dump(&self) {
        SkM44_dump(self)
    }
    #[inline]
    pub unsafe fn map(&self, x: f32, y: f32, z: f32, w: f32) -> SkV4 {
        SkM44_map(self, x, y, z, w)
    }
    #[inline]
    pub unsafe fn preTranslate(&mut self, x: SkScalar, y: SkScalar, z: SkScalar) -> *mut SkM44 {
        SkM44_preTranslate(self, x, y, z)
    }
    #[inline]
    pub unsafe fn postTranslate(&mut self, x: SkScalar, y: SkScalar, z: SkScalar) -> *mut SkM44 {
        SkM44_postTranslate(self, x, y, z)
    }
    #[inline]
    pub unsafe fn preScale(&mut self, x: SkScalar, y: SkScalar) -> *mut SkM44 {
        SkM44_preScale(self, x, y)
    }
    #[inline]
    pub unsafe fn preScale1(&mut self, x: SkScalar, y: SkScalar, z: SkScalar) -> *mut SkM44 {
        SkM44_preScale1(self, x, y, z)
    }
    #[inline]
    pub unsafe fn preConcat(&mut self, arg1: *const SkMatrix) -> *mut SkM44 {
        SkM44_preConcat(self, arg1)
    }
}
#[repr(C)]
pub struct SkPaint {
    pub fPathEffect: sk_sp<SkPathEffect>,
    pub fShader: sk_sp<SkShader>,
    pub fMaskFilter: sk_sp<SkMaskFilter>,
    pub fColorFilter: sk_sp<SkColorFilter>,
    pub fImageFilter: sk_sp<SkImageFilter>,
    pub fBlender: sk_sp<SkBlender>,
    pub fColor4f: SkColor4f,
    pub fWidth: SkScalar,
    pub fMiterLimit: SkScalar,
    pub __bindgen_anon_1: SkPaint__bindgen_ty_1,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPaint_Style {
    Fill = 0,
    Stroke = 1,
    StrokeAndFill = 2,
}
impl SkPaint_Cap {
    pub const Last: SkPaint_Cap = SkPaint_Cap::Square;
}
impl SkPaint_Cap {
    pub const Default: SkPaint_Cap = SkPaint_Cap::Butt;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPaint_Cap {
    Butt = 0,
    Round = 1,
    Square = 2,
}
impl SkPaint_Join {
    pub const Last: SkPaint_Join = SkPaint_Join::Bevel;
}
impl SkPaint_Join {
    pub const Default: SkPaint_Join = SkPaint_Join::Miter;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPaint_Join {
    Miter = 0,
    Round = 1,
    Bevel = 2,
}
pub type SkPaint_sk_is_trivially_relocatable = std_true_type;
#[repr(C)]
#[derive(Copy, Clone)]
pub union SkPaint__bindgen_ty_1 {
    pub fBitfields: SkPaint__bindgen_ty_1__bindgen_ty_1,
    pub fBitfieldsUInt: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPaint__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPaint__bindgen_ty_1__bindgen_ty_1"]
        [::core::mem::size_of::<SkPaint__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Alignment of SkPaint__bindgen_ty_1__bindgen_ty_1"]
        [::core::mem::align_of::<SkPaint__bindgen_ty_1__bindgen_ty_1>() - 4usize];
};
impl SkPaint__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn fAntiAlias(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fAntiAlias(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fAntiAlias_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fAntiAlias_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fDither(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fDither(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fDither_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fDither_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fCapType(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fCapType(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fCapType_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fCapType_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fJoinType(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fJoinType(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fJoinType_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fJoinType_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fStyle(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fStyle(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fStyle_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fStyle_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fPadding(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_fPadding(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fPadding_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fPadding_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fAntiAlias: ::core::ffi::c_uint,
        fDither: ::core::ffi::c_uint,
        fCapType: ::core::ffi::c_uint,
        fJoinType: ::core::ffi::c_uint,
        fStyle: ::core::ffi::c_uint,
        fPadding: ::core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fAntiAlias: u32 = unsafe { ::core::mem::transmute(fAntiAlias) };
            fAntiAlias as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fDither: u32 = unsafe { ::core::mem::transmute(fDither) };
            fDither as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let fCapType: u32 = unsafe { ::core::mem::transmute(fCapType) };
            fCapType as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let fJoinType: u32 = unsafe { ::core::mem::transmute(fJoinType) };
            fJoinType as u64
        });
        __bindgen_bitfield_unit.set(6usize, 2u8, {
            let fStyle: u32 = unsafe { ::core::mem::transmute(fStyle) };
            fStyle as u64
        });
        __bindgen_bitfield_unit.set(8usize, 24u8, {
            let fPadding: u32 = unsafe { ::core::mem::transmute(fPadding) };
            fPadding as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPaint__bindgen_ty_1"][::core::mem::size_of::<SkPaint__bindgen_ty_1>() - 4usize];
    ["Alignment of SkPaint__bindgen_ty_1"]
        [::core::mem::align_of::<SkPaint__bindgen_ty_1>() - 4usize];
    ["Offset of field: SkPaint__bindgen_ty_1::fBitfields"]
        [::core::mem::offset_of!(SkPaint__bindgen_ty_1, fBitfields) - 0usize];
    ["Offset of field: SkPaint__bindgen_ty_1::fBitfieldsUInt"]
        [::core::mem::offset_of!(SkPaint__bindgen_ty_1, fBitfieldsUInt) - 0usize];
};
pub const SkPaint_kStyleCount: ::core::ffi::c_int = 3;
pub const SkPaint_kCapCount: ::core::ffi::c_int = 3;
pub const SkPaint_kJoinCount: ::core::ffi::c_int = 3;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPaint"][::core::mem::size_of::<SkPaint>() - 80usize];
    ["Alignment of SkPaint"][::core::mem::align_of::<SkPaint>() - 8usize];
    ["Offset of field: SkPaint::fPathEffect"]
        [::core::mem::offset_of!(SkPaint, fPathEffect) - 0usize];
    ["Offset of field: SkPaint::fShader"][::core::mem::offset_of!(SkPaint, fShader) - 8usize];
    ["Offset of field: SkPaint::fMaskFilter"]
        [::core::mem::offset_of!(SkPaint, fMaskFilter) - 16usize];
    ["Offset of field: SkPaint::fColorFilter"]
        [::core::mem::offset_of!(SkPaint, fColorFilter) - 24usize];
    ["Offset of field: SkPaint::fImageFilter"]
        [::core::mem::offset_of!(SkPaint, fImageFilter) - 32usize];
    ["Offset of field: SkPaint::fBlender"][::core::mem::offset_of!(SkPaint, fBlender) - 40usize];
    ["Offset of field: SkPaint::fColor4f"][::core::mem::offset_of!(SkPaint, fColor4f) - 48usize];
    ["Offset of field: SkPaint::fWidth"][::core::mem::offset_of!(SkPaint, fWidth) - 64usize];
    ["Offset of field: SkPaint::fMiterLimit"]
        [::core::mem::offset_of!(SkPaint, fMiterLimit) - 68usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint5resetEv"]
    pub fn SkPaint_reset(this: *mut SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint8setStyleENS_5StyleE"]
    pub fn SkPaint_setStyle(this: *mut SkPaint, style: SkPaint_Style);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint9setStrokeEb"]
    pub fn SkPaint_setStroke(this: *mut SkPaint, arg1: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint8setColorEj"]
    pub fn SkPaint_setColor(this: *mut SkPaint, color: SkColor);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint8setColorERK8SkRGBA4fIL11SkAlphaType3EEP12SkColorSpace"]
    pub fn SkPaint_setColor1(
        this: *mut SkPaint,
        color: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint9setAlphafEf"]
    pub fn SkPaint_setAlphaf(this: *mut SkPaint, a: f32);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint7setARGBEjjjj"]
    pub fn SkPaint_setARGB(this: *mut SkPaint, a: U8CPU, r: U8CPU, g: U8CPU, b: U8CPU);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint14setStrokeWidthEf"]
    pub fn SkPaint_setStrokeWidth(this: *mut SkPaint, width: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint14setStrokeMiterEf"]
    pub fn SkPaint_setStrokeMiter(this: *mut SkPaint, miterLimit: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint12setStrokeCapENS_3CapE"]
    pub fn SkPaint_setStrokeCap(this: *mut SkPaint, cap: SkPaint_Cap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint13setStrokeJoinENS_4JoinE"]
    pub fn SkPaint_setStrokeJoin(this: *mut SkPaint, join: SkPaint_Join);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint9refShaderEv"]
    pub fn SkPaint_refShader(this: *const SkPaint) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint9setShaderE5sk_spI8SkShaderE"]
    pub fn SkPaint_setShader(this: *mut SkPaint, shader: sk_sp<SkShader>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint14refColorFilterEv"]
    pub fn SkPaint_refColorFilter(this: *const SkPaint) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint14setColorFilterE5sk_spI13SkColorFilterE"]
    pub fn SkPaint_setColorFilter(this: *mut SkPaint, colorFilter: sk_sp<SkColorFilter>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint11asBlendModeEv"]
    pub fn SkPaint_asBlendMode(this: *const SkPaint) -> __BindgenOpaqueArray<u32, 2usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint15getBlendMode_orE11SkBlendMode"]
    pub fn SkPaint_getBlendMode_or(this: *const SkPaint, defaultMode: SkBlendMode) -> SkBlendMode;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint9isSrcOverEv"]
    pub fn SkPaint_isSrcOver(this: *const SkPaint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint12setBlendModeE11SkBlendMode"]
    pub fn SkPaint_setBlendMode(this: *mut SkPaint, mode: SkBlendMode);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint10refBlenderEv"]
    pub fn SkPaint_refBlender(this: *const SkPaint) -> sk_sp<SkBlender>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint10setBlenderE5sk_spI9SkBlenderE"]
    pub fn SkPaint_setBlender(this: *mut SkPaint, blender: sk_sp<SkBlender>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint13refPathEffectEv"]
    pub fn SkPaint_refPathEffect(this: *const SkPaint) -> sk_sp<SkPathEffect>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint13setPathEffectE5sk_spI12SkPathEffectE"]
    pub fn SkPaint_setPathEffect(this: *mut SkPaint, pathEffect: sk_sp<SkPathEffect>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint13refMaskFilterEv"]
    pub fn SkPaint_refMaskFilter(this: *const SkPaint) -> sk_sp<SkMaskFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint13setMaskFilterE5sk_spI12SkMaskFilterE"]
    pub fn SkPaint_setMaskFilter(this: *mut SkPaint, maskFilter: sk_sp<SkMaskFilter>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint14refImageFilterEv"]
    pub fn SkPaint_refImageFilter(this: *const SkPaint) -> sk_sp<SkImageFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaint14setImageFilterE5sk_spI13SkImageFilterE"]
    pub fn SkPaint_setImageFilter(this: *mut SkPaint, imageFilter: sk_sp<SkImageFilter>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint13nothingToDrawEv"]
    pub fn SkPaint_nothingToDraw(this: *const SkPaint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint20canComputeFastBoundsEv"]
    pub fn SkPaint_canComputeFastBounds(this: *const SkPaint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint17computeFastBoundsERK6SkRectPS0_"]
    pub fn SkPaint_computeFastBounds(
        this: *const SkPaint,
        orig: *const SkRect,
        storage: *mut SkRect,
    ) -> *const SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkPaint19doComputeFastBoundsERK6SkRectPS0_NS_5StyleE"]
    pub fn SkPaint_doComputeFastBounds(
        this: *const SkPaint,
        orig: *const SkRect,
        storage: *mut SkRect,
        style: SkPaint_Style,
    ) -> *const SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaintC1Ev"]
    pub fn SkPaint_SkPaint(this: *mut SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaintC1ERK8SkRGBA4fIL11SkAlphaType3EEP12SkColorSpace"]
    pub fn SkPaint_SkPaint1(
        this: *mut SkPaint,
        color: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaintC1ERKS_"]
    pub fn SkPaint_SkPaint2(this: *mut SkPaint, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaintC1EOS_"]
    pub fn SkPaint_SkPaint3(this: *mut SkPaint, paint: *mut SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkPaintD1Ev"]
    pub fn SkPaint_SkPaint_destructor(this: *mut SkPaint);
}
impl SkPaint {
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkPaint_reset(self)
    }
    #[inline]
    pub unsafe fn setStyle(&mut self, style: SkPaint_Style) {
        SkPaint_setStyle(self, style)
    }
    #[inline]
    pub unsafe fn setStroke(&mut self, arg1: bool) {
        SkPaint_setStroke(self, arg1)
    }
    #[inline]
    pub unsafe fn setColor(&mut self, color: SkColor) {
        SkPaint_setColor(self, color)
    }
    #[inline]
    pub unsafe fn setColor1(&mut self, color: *const SkColor4f, colorSpace: *mut SkColorSpace) {
        SkPaint_setColor1(self, color, colorSpace)
    }
    #[inline]
    pub unsafe fn setAlphaf(&mut self, a: f32) {
        SkPaint_setAlphaf(self, a)
    }
    #[inline]
    pub unsafe fn setARGB(&mut self, a: U8CPU, r: U8CPU, g: U8CPU, b: U8CPU) {
        SkPaint_setARGB(self, a, r, g, b)
    }
    #[inline]
    pub unsafe fn setStrokeWidth(&mut self, width: SkScalar) {
        SkPaint_setStrokeWidth(self, width)
    }
    #[inline]
    pub unsafe fn setStrokeMiter(&mut self, miterLimit: SkScalar) {
        SkPaint_setStrokeMiter(self, miterLimit)
    }
    #[inline]
    pub unsafe fn setStrokeCap(&mut self, cap: SkPaint_Cap) {
        SkPaint_setStrokeCap(self, cap)
    }
    #[inline]
    pub unsafe fn setStrokeJoin(&mut self, join: SkPaint_Join) {
        SkPaint_setStrokeJoin(self, join)
    }
    #[inline]
    pub unsafe fn refShader(&self) -> sk_sp<SkShader> {
        SkPaint_refShader(self)
    }
    #[inline]
    pub unsafe fn setShader(&mut self, shader: sk_sp<SkShader>) {
        SkPaint_setShader(self, shader)
    }
    #[inline]
    pub unsafe fn refColorFilter(&self) -> sk_sp<SkColorFilter> {
        SkPaint_refColorFilter(self)
    }
    #[inline]
    pub unsafe fn setColorFilter(&mut self, colorFilter: sk_sp<SkColorFilter>) {
        SkPaint_setColorFilter(self, colorFilter)
    }
    #[inline]
    pub unsafe fn asBlendMode(&self) -> __BindgenOpaqueArray<u32, 2usize> {
        SkPaint_asBlendMode(self)
    }
    #[inline]
    pub unsafe fn getBlendMode_or(&self, defaultMode: SkBlendMode) -> SkBlendMode {
        SkPaint_getBlendMode_or(self, defaultMode)
    }
    #[inline]
    pub unsafe fn isSrcOver(&self) -> bool {
        SkPaint_isSrcOver(self)
    }
    #[inline]
    pub unsafe fn setBlendMode(&mut self, mode: SkBlendMode) {
        SkPaint_setBlendMode(self, mode)
    }
    #[inline]
    pub unsafe fn refBlender(&self) -> sk_sp<SkBlender> {
        SkPaint_refBlender(self)
    }
    #[inline]
    pub unsafe fn setBlender(&mut self, blender: sk_sp<SkBlender>) {
        SkPaint_setBlender(self, blender)
    }
    #[inline]
    pub unsafe fn refPathEffect(&self) -> sk_sp<SkPathEffect> {
        SkPaint_refPathEffect(self)
    }
    #[inline]
    pub unsafe fn setPathEffect(&mut self, pathEffect: sk_sp<SkPathEffect>) {
        SkPaint_setPathEffect(self, pathEffect)
    }
    #[inline]
    pub unsafe fn refMaskFilter(&self) -> sk_sp<SkMaskFilter> {
        SkPaint_refMaskFilter(self)
    }
    #[inline]
    pub unsafe fn setMaskFilter(&mut self, maskFilter: sk_sp<SkMaskFilter>) {
        SkPaint_setMaskFilter(self, maskFilter)
    }
    #[inline]
    pub unsafe fn refImageFilter(&self) -> sk_sp<SkImageFilter> {
        SkPaint_refImageFilter(self)
    }
    #[inline]
    pub unsafe fn setImageFilter(&mut self, imageFilter: sk_sp<SkImageFilter>) {
        SkPaint_setImageFilter(self, imageFilter)
    }
    #[inline]
    pub unsafe fn nothingToDraw(&self) -> bool {
        SkPaint_nothingToDraw(self)
    }
    #[inline]
    pub unsafe fn canComputeFastBounds(&self) -> bool {
        SkPaint_canComputeFastBounds(self)
    }
    #[inline]
    pub unsafe fn computeFastBounds(
        &self,
        orig: *const SkRect,
        storage: *mut SkRect,
    ) -> *const SkRect {
        SkPaint_computeFastBounds(self, orig, storage)
    }
    #[inline]
    pub unsafe fn doComputeFastBounds(
        &self,
        orig: *const SkRect,
        storage: *mut SkRect,
        style: SkPaint_Style,
    ) -> *const SkRect {
        SkPaint_doComputeFastBounds(self, orig, storage, style)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPaint_SkPaint(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(color: *const SkColor4f, colorSpace: *mut SkColorSpace) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPaint_SkPaint1(__bindgen_tmp.as_mut_ptr(), color, colorSpace);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(paint: *const SkPaint) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPaint_SkPaint2(__bindgen_tmp.as_mut_ptr(), paint);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(paint: *mut SkPaint) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPaint_SkPaint3(__bindgen_tmp.as_mut_ptr(), paint);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPaint_SkPaint_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRSXform {
    pub fSCos: SkScalar,
    pub fSSin: SkScalar,
    pub fTx: SkScalar,
    pub fTy: SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRSXform"][::core::mem::size_of::<SkRSXform>() - 16usize];
    ["Alignment of SkRSXform"][::core::mem::align_of::<SkRSXform>() - 4usize];
    ["Offset of field: SkRSXform::fSCos"][::core::mem::offset_of!(SkRSXform, fSCos) - 0usize];
    ["Offset of field: SkRSXform::fSSin"][::core::mem::offset_of!(SkRSXform, fSSin) - 4usize];
    ["Offset of field: SkRSXform::fTx"][::core::mem::offset_of!(SkRSXform, fTx) - 8usize];
    ["Offset of field: SkRSXform::fTy"][::core::mem::offset_of!(SkRSXform, fTy) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkRSXform6toQuadEffP7SkPoint"]
    pub fn SkRSXform_toQuad(
        this: *const SkRSXform,
        width: SkScalar,
        height: SkScalar,
        quad: *mut SkPoint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkRSXform10toTriStripEffP7SkPoint"]
    pub fn SkRSXform_toTriStrip(
        this: *const SkRSXform,
        width: SkScalar,
        height: SkScalar,
        strip: *mut SkPoint,
    );
}
impl SkRSXform {
    #[inline]
    pub unsafe fn toQuad(&self, width: SkScalar, height: SkScalar, quad: *mut SkPoint) {
        SkRSXform_toQuad(self, width, height, quad)
    }
    #[inline]
    pub unsafe fn toTriStrip(&self, width: SkScalar, height: SkScalar, strip: *mut SkPoint) {
        SkRSXform_toTriStrip(self, width, height, strip)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkRasterHandleAllocator {
    pub _bindgen_opaque_blob: u64,
}
pub type SkRasterHandleAllocator_Handle = *mut ::core::ffi::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRasterHandleAllocator_Rec {
    pub fReleaseProc: ::core::option::Option<
        unsafe extern "C" fn(pixels: *mut ::core::ffi::c_void, ctx: *mut ::core::ffi::c_void),
    >,
    pub fReleaseCtx: *mut ::core::ffi::c_void,
    pub fPixels: *mut ::core::ffi::c_void,
    pub fRowBytes: usize,
    pub fHandle: SkRasterHandleAllocator_Handle,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRasterHandleAllocator_Rec"]
        [::core::mem::size_of::<SkRasterHandleAllocator_Rec>() - 40usize];
    ["Alignment of SkRasterHandleAllocator_Rec"]
        [::core::mem::align_of::<SkRasterHandleAllocator_Rec>() - 8usize];
    ["Offset of field: SkRasterHandleAllocator_Rec::fReleaseProc"]
        [::core::mem::offset_of!(SkRasterHandleAllocator_Rec, fReleaseProc) - 0usize];
    ["Offset of field: SkRasterHandleAllocator_Rec::fReleaseCtx"]
        [::core::mem::offset_of!(SkRasterHandleAllocator_Rec, fReleaseCtx) - 8usize];
    ["Offset of field: SkRasterHandleAllocator_Rec::fPixels"]
        [::core::mem::offset_of!(SkRasterHandleAllocator_Rec, fPixels) - 16usize];
    ["Offset of field: SkRasterHandleAllocator_Rec::fRowBytes"]
        [::core::mem::offset_of!(SkRasterHandleAllocator_Rec, fRowBytes) - 24usize];
    ["Offset of field: SkRasterHandleAllocator_Rec::fHandle"]
        [::core::mem::offset_of!(SkRasterHandleAllocator_Rec, fHandle) - 32usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRasterHandleAllocator"][::core::mem::size_of::<SkRasterHandleAllocator>() - 8usize];
    ["Alignment of SkRasterHandleAllocator"]
        [::core::mem::align_of::<SkRasterHandleAllocator>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkRasterHandleAllocator10MakeCanvasESt10unique_ptrIS_St14default_deleteIS_EERK11SkImageInfoPKNS_3RecEPK14SkSurfaceProps"]
    pub fn SkRasterHandleAllocator_MakeCanvas(
        arg1: u64,
        arg2: *const SkImageInfo,
        rec: *const SkRasterHandleAllocator_Rec,
        props: *const SkSurfaceProps,
    ) -> u64;
}
impl SkRasterHandleAllocator {
    #[inline]
    pub unsafe fn MakeCanvas(
        arg1: u64,
        arg2: *const SkImageInfo,
        rec: *const SkRasterHandleAllocator_Rec,
        props: *const SkSurfaceProps,
    ) -> u64 {
        SkRasterHandleAllocator_MakeCanvas(arg1, arg2, rec, props)
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPixelGeometry {
    kUnknown_SkPixelGeometry = 0,
    kRGB_H_SkPixelGeometry = 1,
    kBGR_H_SkPixelGeometry = 2,
    kRGB_V_SkPixelGeometry = 3,
    kBGR_V_SkPixelGeometry = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSurfaceProps {
    pub fFlags: u32,
    pub fPixelGeometry: SkPixelGeometry,
    pub fTextContrast: SkScalar,
    pub fTextGamma: SkScalar,
}
pub const SkSurfaceProps_Flags_kDefault_Flag: SkSurfaceProps_Flags = 0;
pub const SkSurfaceProps_Flags_kUseDeviceIndependentFonts_Flag: SkSurfaceProps_Flags = 1;
pub const SkSurfaceProps_Flags_kDynamicMSAA_Flag: SkSurfaceProps_Flags = 2;
pub const SkSurfaceProps_Flags_kAlwaysDither_Flag: SkSurfaceProps_Flags = 4;
pub type SkSurfaceProps_Flags = ::core::ffi::c_uint;
pub const SkSurfaceProps_kMaxContrastInclusive: SkScalar = 1.0;
pub const SkSurfaceProps_kMinContrastInclusive: SkScalar = 0.0;
pub const SkSurfaceProps_kMaxGammaExclusive: SkScalar = 4.0;
pub const SkSurfaceProps_kMinGammaInclusive: SkScalar = 0.0;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSurfaceProps"][::core::mem::size_of::<SkSurfaceProps>() - 16usize];
    ["Alignment of SkSurfaceProps"][::core::mem::align_of::<SkSurfaceProps>() - 4usize];
    ["Offset of field: SkSurfaceProps::fFlags"]
        [::core::mem::offset_of!(SkSurfaceProps, fFlags) - 0usize];
    ["Offset of field: SkSurfaceProps::fPixelGeometry"]
        [::core::mem::offset_of!(SkSurfaceProps, fPixelGeometry) - 4usize];
    ["Offset of field: SkSurfaceProps::fTextContrast"]
        [::core::mem::offset_of!(SkSurfaceProps, fTextContrast) - 8usize];
    ["Offset of field: SkSurfaceProps::fTextGamma"]
        [::core::mem::offset_of!(SkSurfaceProps, fTextGamma) - 12usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkSurfacePropsC1Ev"]
    pub fn SkSurfaceProps_SkSurfaceProps(this: *mut SkSurfaceProps);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkSurfacePropsC1Ej15SkPixelGeometry"]
    pub fn SkSurfaceProps_SkSurfaceProps1(
        this: *mut SkSurfaceProps,
        flags: u32,
        arg1: SkPixelGeometry,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkSurfacePropsC1Ej15SkPixelGeometryff"]
    pub fn SkSurfaceProps_SkSurfaceProps2(
        this: *mut SkSurfaceProps,
        flags: u32,
        arg1: SkPixelGeometry,
        textContrast: SkScalar,
        textGamma: SkScalar,
    );
}
impl SkSurfaceProps {
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkSurfaceProps_SkSurfaceProps(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(flags: u32, arg1: SkPixelGeometry) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkSurfaceProps_SkSurfaceProps1(__bindgen_tmp.as_mut_ptr(), flags, arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(
        flags: u32,
        arg1: SkPixelGeometry,
        textContrast: SkScalar,
        textGamma: SkScalar,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkSurfaceProps_SkSurfaceProps2(
            __bindgen_tmp.as_mut_ptr(),
            flags,
            arg1,
            textContrast,
            textGamma,
        );
        __bindgen_tmp.assume_init()
    }
}
impl SkTileMode {
    pub const LastTileMode: SkTileMode = SkTileMode::Decal;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTileMode {
    Clamp = 0,
    Repeat = 1,
    Mirror = 2,
    Decal = 3,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDeque {
    pub _bindgen_opaque_blob: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDeque_Block {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDeque_Iter {
    pub _bindgen_opaque_blob: [u64; 3usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkDeque_Iter_IterStart {
    kFront_IterStart = 0,
    kBack_IterStart = 1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDeque_Iter"][::core::mem::size_of::<SkDeque_Iter>() - 24usize];
    ["Alignment of SkDeque_Iter"][::core::mem::align_of::<SkDeque_Iter>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque4Iter4nextEv"]
    pub fn SkDeque_Iter_next(this: *mut SkDeque_Iter) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque4Iter4prevEv"]
    pub fn SkDeque_Iter_prev(this: *mut SkDeque_Iter) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque4Iter5resetERKS_NS0_9IterStartE"]
    pub fn SkDeque_Iter_reset(
        this: *mut SkDeque_Iter,
        d: *const SkDeque,
        startLoc: SkDeque_Iter_IterStart,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque4IterC1Ev"]
    pub fn SkDeque_Iter_Iter(this: *mut SkDeque_Iter);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque4IterC1ERKS_NS0_9IterStartE"]
    pub fn SkDeque_Iter_Iter1(
        this: *mut SkDeque_Iter,
        d: *const SkDeque,
        startLoc: SkDeque_Iter_IterStart,
    );
}
impl SkDeque_Iter {
    #[inline]
    pub unsafe fn next(&mut self) -> *mut ::core::ffi::c_void {
        SkDeque_Iter_next(self)
    }
    #[inline]
    pub unsafe fn prev(&mut self) -> *mut ::core::ffi::c_void {
        SkDeque_Iter_prev(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self, d: *const SkDeque, startLoc: SkDeque_Iter_IterStart) {
        SkDeque_Iter_reset(self, d, startLoc)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDeque_Iter_Iter(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(d: *const SkDeque, startLoc: SkDeque_Iter_IterStart) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDeque_Iter_Iter1(__bindgen_tmp.as_mut_ptr(), d, startLoc);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDeque_F2BIter {
    pub _bindgen_opaque_blob: [u64; 3usize],
}
pub type SkDeque_F2BIter_INHERITED = SkDeque_Iter;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDeque_F2BIter"][::core::mem::size_of::<SkDeque_F2BIter>() - 24usize];
    ["Alignment of SkDeque_F2BIter"][::core::mem::align_of::<SkDeque_F2BIter>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDeque"][::core::mem::size_of::<SkDeque>() - 56usize];
    ["Alignment of SkDeque"][::core::mem::align_of::<SkDeque>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque10push_frontEv"]
    pub fn SkDeque_push_front(this: *mut SkDeque) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque9push_backEv"]
    pub fn SkDeque_push_back(this: *mut SkDeque) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque9pop_frontEv"]
    pub fn SkDeque_pop_front(this: *mut SkDeque);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDeque8pop_backEv"]
    pub fn SkDeque_pop_back(this: *mut SkDeque);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDequeC1Emi"]
    pub fn SkDeque_SkDeque(this: *mut SkDeque, elemSize: usize, allocCount: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDequeC1EmPvmi"]
    pub fn SkDeque_SkDeque1(
        this: *mut SkDeque,
        elemSize: usize,
        storage: *mut ::core::ffi::c_void,
        storageSize: usize,
        allocCount: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkDequeD1Ev"]
    pub fn SkDeque_SkDeque_destructor(this: *mut SkDeque);
}
impl SkDeque {
    #[inline]
    pub unsafe fn push_front(&mut self) -> *mut ::core::ffi::c_void {
        SkDeque_push_front(self)
    }
    #[inline]
    pub unsafe fn push_back(&mut self) -> *mut ::core::ffi::c_void {
        SkDeque_push_back(self)
    }
    #[inline]
    pub unsafe fn pop_front(&mut self) {
        SkDeque_pop_front(self)
    }
    #[inline]
    pub unsafe fn pop_back(&mut self) {
        SkDeque_pop_back(self)
    }
    #[inline]
    pub unsafe fn new(elemSize: usize, allocCount: ::core::ffi::c_int) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDeque_SkDeque(__bindgen_tmp.as_mut_ptr(), elemSize, allocCount);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        elemSize: usize,
        storage: *mut ::core::ffi::c_void,
        storageSize: usize,
        allocCount: ::core::ffi::c_int,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDeque_SkDeque1(
            __bindgen_tmp.as_mut_ptr(),
            elemSize,
            storage,
            storageSize,
            allocCount,
        );
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkDeque_SkDeque_destructor(self)
    }
}
pub type skia_private_TArray_value_type<T> = T;
pub type skia_private_STArray_Storage = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skia_private_AutoTMalloc {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sktext_GlyphRunBuilder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sktext_GlyphRunList {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sktext_gpu_Slug {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrRecordingContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkMesh {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSpecialImage {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSurface_Base {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDrawShadowRec {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct skgpu_graphite_Recorder {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct SkCanvas__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct SkCanvas {
    pub vtable_: *const SkCanvas__bindgen_vtable,
    pub fMCRecStorage: [std_byte; 3072usize],
    pub fMCStack: SkDeque,
    pub fMCRec: *mut SkCanvas_MCRec,
    pub fRootDevice: sk_sp<SkDevice>,
    pub fProps: SkSurfaceProps,
    pub fSaveCount: ::core::ffi::c_int,
    pub fAllocator: u64,
    pub fSurfaceBase: *mut SkSurface_Base,
    pub fClipRestrictionRect: SkIRect,
    pub fClipRestrictionSaveCount: ::core::ffi::c_int,
    pub fQuickRejectBounds: SkRect,
    pub fScratchGlyphRunBuilder: u64,
}
pub const SkCanvas_SaveLayerFlagsSet_kPreserveLCDText_SaveLayerFlag: SkCanvas_SaveLayerFlagsSet = 2;
pub const SkCanvas_SaveLayerFlagsSet_kInitWithPrevious_SaveLayerFlag: SkCanvas_SaveLayerFlagsSet =
    4;
pub const SkCanvas_SaveLayerFlagsSet_kF16ColorType: SkCanvas_SaveLayerFlagsSet = 16;
pub type SkCanvas_SaveLayerFlagsSet = ::core::ffi::c_uint;
pub type SkCanvas_SaveLayerFlags = u32;
pub type SkCanvas_FilterSpan = SkSpan<sk_sp<SkImageFilter>>;
#[repr(C)]
#[derive(Debug)]
pub struct SkCanvas_SaveLayerRec {
    pub fBounds: *const SkRect,
    pub fPaint: *const SkPaint,
    pub fFilters: SkCanvas_FilterSpan,
    pub fBackdrop: *const SkImageFilter,
    pub fBackdropTileMode: SkTileMode,
    pub fColorSpace: *const SkColorSpace,
    pub fSaveLayerFlags: SkCanvas_SaveLayerFlags,
    pub fExperimentalBackdropScale: SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_SaveLayerRec"][::core::mem::size_of::<SkCanvas_SaveLayerRec>() - 64usize];
    ["Alignment of SkCanvas_SaveLayerRec"]
        [::core::mem::align_of::<SkCanvas_SaveLayerRec>() - 8usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fBounds"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fBounds) - 0usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fPaint"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fPaint) - 8usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fFilters"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fFilters) - 16usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fBackdrop"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fBackdrop) - 32usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fBackdropTileMode"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fBackdropTileMode) - 40usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fColorSpace"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fColorSpace) - 48usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fSaveLayerFlags"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fSaveLayerFlags) - 56usize];
    ["Offset of field: SkCanvas_SaveLayerRec::fExperimentalBackdropScale"]
        [::core::mem::offset_of!(SkCanvas_SaveLayerRec, fExperimentalBackdropScale) - 60usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_PointMode {
    Points = 0,
    Lines = 1,
    Polygon = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_SrcRectConstraint {
    Strict = 0,
    Fast = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCanvas_Lattice {
    pub fXDivs: *const ::core::ffi::c_int,
    pub fYDivs: *const ::core::ffi::c_int,
    pub fRectTypes: *const SkCanvas_Lattice_RectType,
    pub fXCount: ::core::ffi::c_int,
    pub fYCount: ::core::ffi::c_int,
    pub fBounds: *const SkIRect,
    pub fColors: *const SkColor,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_Lattice_RectType {
    Default = 0,
    Transparent = 1,
    FixedColor = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_Lattice"][::core::mem::size_of::<SkCanvas_Lattice>() - 48usize];
    ["Alignment of SkCanvas_Lattice"][::core::mem::align_of::<SkCanvas_Lattice>() - 8usize];
    ["Offset of field: SkCanvas_Lattice::fXDivs"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fXDivs) - 0usize];
    ["Offset of field: SkCanvas_Lattice::fYDivs"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fYDivs) - 8usize];
    ["Offset of field: SkCanvas_Lattice::fRectTypes"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fRectTypes) - 16usize];
    ["Offset of field: SkCanvas_Lattice::fXCount"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fXCount) - 24usize];
    ["Offset of field: SkCanvas_Lattice::fYCount"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fYCount) - 28usize];
    ["Offset of field: SkCanvas_Lattice::fBounds"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fBounds) - 32usize];
    ["Offset of field: SkCanvas_Lattice::fColors"]
        [::core::mem::offset_of!(SkCanvas_Lattice, fColors) - 40usize];
};
pub const SkCanvas_QuadAAFlags_kLeft_QuadAAFlag: SkCanvas_QuadAAFlags = 1;
pub const SkCanvas_QuadAAFlags_kTop_QuadAAFlag: SkCanvas_QuadAAFlags = 2;
pub const SkCanvas_QuadAAFlags_kRight_QuadAAFlag: SkCanvas_QuadAAFlags = 4;
pub const SkCanvas_QuadAAFlags_kBottom_QuadAAFlag: SkCanvas_QuadAAFlags = 8;
pub const SkCanvas_QuadAAFlags_kNone_QuadAAFlags: SkCanvas_QuadAAFlags = 0;
pub const SkCanvas_QuadAAFlags_kAll_QuadAAFlags: SkCanvas_QuadAAFlags = 15;
pub type SkCanvas_QuadAAFlags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct SkCanvas_ImageSetEntry {
    pub fImage: sk_sp<SkImage>,
    pub fSrcRect: SkRect,
    pub fDstRect: SkRect,
    pub fMatrixIndex: ::core::ffi::c_int,
    pub fAlpha: f32,
    pub fAAFlags: ::core::ffi::c_uint,
    pub fHasClip: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_ImageSetEntry"][::core::mem::size_of::<SkCanvas_ImageSetEntry>() - 56usize];
    ["Alignment of SkCanvas_ImageSetEntry"]
        [::core::mem::align_of::<SkCanvas_ImageSetEntry>() - 8usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fImage"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fImage) - 0usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fSrcRect"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fSrcRect) - 8usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fDstRect"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fDstRect) - 24usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fMatrixIndex"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fMatrixIndex) - 40usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fAlpha"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fAlpha) - 44usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fAAFlags"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fAAFlags) - 48usize];
    ["Offset of field: SkCanvas_ImageSetEntry::fHasClip"]
        [::core::mem::offset_of!(SkCanvas_ImageSetEntry, fHasClip) - 52usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13ImageSetEntryC1E5sk_spIK7SkImageERK6SkRectS7_ifjb"]
    pub fn SkCanvas_ImageSetEntry_ImageSetEntry(
        this: *mut SkCanvas_ImageSetEntry,
        image: sk_sp<SkImage>,
        srcRect: *const SkRect,
        dstRect: *const SkRect,
        matrixIndex: ::core::ffi::c_int,
        alpha: f32,
        aaFlags: ::core::ffi::c_uint,
        hasClip: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13ImageSetEntryC1E5sk_spIK7SkImageERK6SkRectS7_fj"]
    pub fn SkCanvas_ImageSetEntry_ImageSetEntry1(
        this: *mut SkCanvas_ImageSetEntry,
        image: sk_sp<SkImage>,
        srcRect: *const SkRect,
        dstRect: *const SkRect,
        alpha: f32,
        aaFlags: ::core::ffi::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13ImageSetEntryC1Ev"]
    pub fn SkCanvas_ImageSetEntry_ImageSetEntry2(this: *mut SkCanvas_ImageSetEntry);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13ImageSetEntryC1ERKS0_"]
    pub fn SkCanvas_ImageSetEntry_ImageSetEntry3(
        this: *mut SkCanvas_ImageSetEntry,
        arg1: *const SkCanvas_ImageSetEntry,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13ImageSetEntryD1Ev"]
    pub fn SkCanvas_ImageSetEntry_ImageSetEntry_destructor(this: *mut SkCanvas_ImageSetEntry);
}
impl SkCanvas_ImageSetEntry {
    #[inline]
    pub unsafe fn new(
        image: sk_sp<SkImage>,
        srcRect: *const SkRect,
        dstRect: *const SkRect,
        matrixIndex: ::core::ffi::c_int,
        alpha: f32,
        aaFlags: ::core::ffi::c_uint,
        hasClip: bool,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_ImageSetEntry_ImageSetEntry(
            __bindgen_tmp.as_mut_ptr(),
            image,
            srcRect,
            dstRect,
            matrixIndex,
            alpha,
            aaFlags,
            hasClip,
        );
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        image: sk_sp<SkImage>,
        srcRect: *const SkRect,
        dstRect: *const SkRect,
        alpha: f32,
        aaFlags: ::core::ffi::c_uint,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_ImageSetEntry_ImageSetEntry1(
            __bindgen_tmp.as_mut_ptr(),
            image,
            srcRect,
            dstRect,
            alpha,
            aaFlags,
        );
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_ImageSetEntry_ImageSetEntry2(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(arg1: *const SkCanvas_ImageSetEntry) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_ImageSetEntry_ImageSetEntry3(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkCanvas_ImageSetEntry_ImageSetEntry_destructor(self)
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_SaveLayerStrategy {
    kFullLayer_SaveLayerStrategy = 0,
    kNoLayer_SaveLayerStrategy = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_ClipEdgeStyle {
    kHard_ClipEdgeStyle = 0,
    kSoft_ClipEdgeStyle = 1,
}
pub const SkCanvas_PredrawFlags_kNone: SkCanvas_PredrawFlags = 0;
pub const SkCanvas_PredrawFlags_kOpaqueShaderOverride: SkCanvas_PredrawFlags = 1;
pub const SkCanvas_PredrawFlags_kNonOpaqueShaderOverride: SkCanvas_PredrawFlags = 2;
pub const SkCanvas_PredrawFlags_kCheckForOverwrite: SkCanvas_PredrawFlags = 4;
pub const SkCanvas_PredrawFlags_kSkipMaskFilterAutoLayer: SkCanvas_PredrawFlags = 8;
pub type SkCanvas_PredrawFlags = ::core::ffi::c_uint;
#[repr(C)]
pub struct SkCanvas_Layer {
    pub fDevice: sk_sp<SkDevice>,
    pub fImageFilters: __BindgenOpaqueArray<u64, 3usize>,
    pub fPaint: SkPaint,
    pub fIsCoverage: bool,
    pub fDiscard: bool,
    pub fIncludesPadding: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_Layer"][::core::mem::size_of::<SkCanvas_Layer>() - 120usize];
    ["Alignment of SkCanvas_Layer"][::core::mem::align_of::<SkCanvas_Layer>() - 8usize];
    ["Offset of field: SkCanvas_Layer::fDevice"]
        [::core::mem::offset_of!(SkCanvas_Layer, fDevice) - 0usize];
    ["Offset of field: SkCanvas_Layer::fImageFilters"]
        [::core::mem::offset_of!(SkCanvas_Layer, fImageFilters) - 8usize];
    ["Offset of field: SkCanvas_Layer::fPaint"]
        [::core::mem::offset_of!(SkCanvas_Layer, fPaint) - 32usize];
    ["Offset of field: SkCanvas_Layer::fIsCoverage"]
        [::core::mem::offset_of!(SkCanvas_Layer, fIsCoverage) - 112usize];
    ["Offset of field: SkCanvas_Layer::fDiscard"]
        [::core::mem::offset_of!(SkCanvas_Layer, fDiscard) - 113usize];
    ["Offset of field: SkCanvas_Layer::fIncludesPadding"]
        [::core::mem::offset_of!(SkCanvas_Layer, fIncludesPadding) - 114usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5LayerC1E5sk_spI8SkDeviceE6SkSpanIS1_I13SkImageFilterEERK7SkPaintbb"]
    pub fn SkCanvas_Layer_Layer(
        this: *mut SkCanvas_Layer,
        device: sk_sp<SkDevice>,
        imageFilters: SkCanvas_FilterSpan,
        paint: *const SkPaint,
        isCoverage: bool,
        includesPadding: bool,
    );
}
impl SkCanvas_Layer {
    #[inline]
    pub unsafe fn new(
        device: sk_sp<SkDevice>,
        imageFilters: SkCanvas_FilterSpan,
        paint: *const SkPaint,
        isCoverage: bool,
        includesPadding: bool,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_Layer_Layer(
            __bindgen_tmp.as_mut_ptr(),
            device,
            imageFilters,
            paint,
            isCoverage,
            includesPadding,
        );
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkCanvas_BackImage {
    pub fImage: sk_sp<SkSpecialImage>,
    pub fLoc: SkIPoint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_BackImage"][::core::mem::size_of::<SkCanvas_BackImage>() - 16usize];
    ["Alignment of SkCanvas_BackImage"][::core::mem::align_of::<SkCanvas_BackImage>() - 8usize];
    ["Offset of field: SkCanvas_BackImage::fImage"]
        [::core::mem::offset_of!(SkCanvas_BackImage, fImage) - 0usize];
    ["Offset of field: SkCanvas_BackImage::fLoc"]
        [::core::mem::offset_of!(SkCanvas_BackImage, fLoc) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9BackImageC1E5sk_spI14SkSpecialImageE8SkIPoint"]
    pub fn SkCanvas_BackImage_BackImage(
        this: *mut SkCanvas_BackImage,
        arg1: sk_sp<SkSpecialImage>,
        arg2: SkIPoint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9BackImageC1ERKS0_"]
    pub fn SkCanvas_BackImage_BackImage1(
        this: *mut SkCanvas_BackImage,
        arg1: *const SkCanvas_BackImage,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9BackImageC1EOS0_"]
    pub fn SkCanvas_BackImage_BackImage2(
        this: *mut SkCanvas_BackImage,
        arg1: *mut SkCanvas_BackImage,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9BackImageD1Ev"]
    pub fn SkCanvas_BackImage_BackImage_destructor(this: *mut SkCanvas_BackImage);
}
impl SkCanvas_BackImage {
    #[inline]
    pub unsafe fn new(arg1: sk_sp<SkSpecialImage>, arg2: SkIPoint) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_BackImage_BackImage(__bindgen_tmp.as_mut_ptr(), arg1, arg2);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(arg1: *const SkCanvas_BackImage) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_BackImage_BackImage1(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(arg1: *mut SkCanvas_BackImage) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_BackImage_BackImage2(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkCanvas_BackImage_BackImage_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkCanvas_MCRec {
    pub fLayer: u64,
    pub fDevice: *mut SkDevice,
    pub fBackImage: u64,
    pub fMatrix: SkM44,
    pub fDeferredSaveCount: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas_MCRec"][::core::mem::size_of::<SkCanvas_MCRec>() - 96usize];
    ["Alignment of SkCanvas_MCRec"][::core::mem::align_of::<SkCanvas_MCRec>() - 8usize];
    ["Offset of field: SkCanvas_MCRec::fLayer"]
        [::core::mem::offset_of!(SkCanvas_MCRec, fLayer) - 0usize];
    ["Offset of field: SkCanvas_MCRec::fDevice"]
        [::core::mem::offset_of!(SkCanvas_MCRec, fDevice) - 8usize];
    ["Offset of field: SkCanvas_MCRec::fBackImage"]
        [::core::mem::offset_of!(SkCanvas_MCRec, fBackImage) - 16usize];
    ["Offset of field: SkCanvas_MCRec::fMatrix"]
        [::core::mem::offset_of!(SkCanvas_MCRec, fMatrix) - 24usize];
    ["Offset of field: SkCanvas_MCRec::fDeferredSaveCount"]
        [::core::mem::offset_of!(SkCanvas_MCRec, fDeferredSaveCount) - 88usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5MCRec8newLayerE5sk_spI8SkDeviceE6SkSpanIS1_I13SkImageFilterEERK7SkPaintbb"]
    pub fn SkCanvas_MCRec_newLayer(
        this: *mut SkCanvas_MCRec,
        layerDevice: sk_sp<SkDevice>,
        filters: SkCanvas_FilterSpan,
        restorePaint: *const SkPaint,
        layerIsCoverage: bool,
        includesPadding: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5MCRec5resetEP8SkDevice"]
    pub fn SkCanvas_MCRec_reset(this: *mut SkCanvas_MCRec, device: *mut SkDevice);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5MCRecC1EP8SkDevice"]
    pub fn SkCanvas_MCRec_MCRec(this: *mut SkCanvas_MCRec, device: *mut SkDevice);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5MCRecC1EPKS0_"]
    pub fn SkCanvas_MCRec_MCRec1(this: *mut SkCanvas_MCRec, prev: *const SkCanvas_MCRec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5MCRecD1Ev"]
    pub fn SkCanvas_MCRec_MCRec_destructor(this: *mut SkCanvas_MCRec);
}
impl SkCanvas_MCRec {
    #[inline]
    pub unsafe fn newLayer(
        &mut self,
        layerDevice: sk_sp<SkDevice>,
        filters: SkCanvas_FilterSpan,
        restorePaint: *const SkPaint,
        layerIsCoverage: bool,
        includesPadding: bool,
    ) {
        SkCanvas_MCRec_newLayer(
            self,
            layerDevice,
            filters,
            restorePaint,
            layerIsCoverage,
            includesPadding,
        )
    }
    #[inline]
    pub unsafe fn reset(&mut self, device: *mut SkDevice) {
        SkCanvas_MCRec_reset(self, device)
    }
    #[inline]
    pub unsafe fn new(device: *mut SkDevice) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_MCRec_MCRec(__bindgen_tmp.as_mut_ptr(), device);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(prev: *const SkCanvas_MCRec) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_MCRec_MCRec1(__bindgen_tmp.as_mut_ptr(), prev);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkCanvas_MCRec_MCRec_destructor(self)
    }
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCanvas_DeviceCompatibleWithFilter {
    kUnknown = 0,
    kYes = 1,
    kYesWithPadding = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCanvas_AutoUpdateQRBounds {
    _unused: [u8; 0],
}
pub const SkCanvas_kMaxFiltersPerLayer: ::core::ffi::c_int = 16;
pub const SkCanvas_kMCRecCount: ::core::ffi::c_int = 32;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCanvas"][::core::mem::size_of::<SkCanvas>() - 3240usize];
    ["Alignment of SkCanvas"][::core::mem::align_of::<SkCanvas>() - 8usize];
    ["Offset of field: SkCanvas::fMCRecStorage"]
        [::core::mem::offset_of!(SkCanvas, fMCRecStorage) - 8usize];
    ["Offset of field: SkCanvas::fMCStack"]
        [::core::mem::offset_of!(SkCanvas, fMCStack) - 3080usize];
    ["Offset of field: SkCanvas::fMCRec"][::core::mem::offset_of!(SkCanvas, fMCRec) - 3136usize];
    ["Offset of field: SkCanvas::fRootDevice"]
        [::core::mem::offset_of!(SkCanvas, fRootDevice) - 3144usize];
    ["Offset of field: SkCanvas::fProps"][::core::mem::offset_of!(SkCanvas, fProps) - 3152usize];
    ["Offset of field: SkCanvas::fSaveCount"]
        [::core::mem::offset_of!(SkCanvas, fSaveCount) - 3168usize];
    ["Offset of field: SkCanvas::fAllocator"]
        [::core::mem::offset_of!(SkCanvas, fAllocator) - 3176usize];
    ["Offset of field: SkCanvas::fSurfaceBase"]
        [::core::mem::offset_of!(SkCanvas, fSurfaceBase) - 3184usize];
    ["Offset of field: SkCanvas::fClipRestrictionRect"]
        [::core::mem::offset_of!(SkCanvas, fClipRestrictionRect) - 3192usize];
    ["Offset of field: SkCanvas::fClipRestrictionSaveCount"]
        [::core::mem::offset_of!(SkCanvas, fClipRestrictionSaveCount) - 3208usize];
    ["Offset of field: SkCanvas::fQuickRejectBounds"]
        [::core::mem::offset_of!(SkCanvas, fQuickRejectBounds) - 3212usize];
    ["Offset of field: SkCanvas::fScratchGlyphRunBuilder"]
        [::core::mem::offset_of!(SkCanvas, fScratchGlyphRunBuilder) - 3232usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas16MakeRasterDirectERK11SkImageInfoPvmPK14SkSurfaceProps"]
    pub fn SkCanvas_MakeRasterDirect(
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        props: *const SkSurfaceProps,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas9imageInfoEv"]
    pub fn SkCanvas_imageInfo(this: *const SkCanvas) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas8getPropsEP14SkSurfaceProps"]
    pub fn SkCanvas_getProps(this: *const SkCanvas, props: *mut SkSurfaceProps) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas12getBasePropsEv"]
    pub fn SkCanvas_getBaseProps(this: *const SkCanvas) -> SkSurfaceProps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas11getTopPropsEv"]
    pub fn SkCanvas_getTopProps(this: *const SkCanvas) -> SkSurfaceProps;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11makeSurfaceERK11SkImageInfoPK14SkSurfaceProps"]
    pub fn SkCanvas_makeSurface(
        this: *mut SkCanvas,
        info: *const SkImageInfo,
        props: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas10getSurfaceEv"]
    pub fn SkCanvas_getSurface(this: *const SkCanvas) -> *mut SkSurface;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas20accessTopLayerPixelsEP11SkImageInfoPmP8SkIPoint"]
    pub fn SkCanvas_accessTopLayerPixels(
        this: *mut SkCanvas,
        info: *mut SkImageInfo,
        rowBytes: *mut usize,
        origin: *mut SkIPoint,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas21accessTopRasterHandleEv"]
    pub fn SkCanvas_accessTopRasterHandle(this: *const SkCanvas) -> SkRasterHandleAllocator_Handle;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10peekPixelsEP8SkPixmap"]
    pub fn SkCanvas_peekPixels(this: *mut SkCanvas, pixmap: *mut SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10readPixelsERK11SkImageInfoPvmii"]
    pub fn SkCanvas_readPixels(
        this: *mut SkCanvas,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10readPixelsERK8SkPixmapii"]
    pub fn SkCanvas_readPixels1(
        this: *mut SkCanvas,
        pixmap: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10readPixelsERK8SkBitmapii"]
    pub fn SkCanvas_readPixels2(
        this: *mut SkCanvas,
        bitmap: *const SkBitmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11writePixelsERK11SkImageInfoPKvmii"]
    pub fn SkCanvas_writePixels(
        this: *mut SkCanvas,
        info: *const SkImageInfo,
        pixels: *const ::core::ffi::c_void,
        rowBytes: usize,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11writePixelsERK8SkBitmapii"]
    pub fn SkCanvas_writePixels1(
        this: *mut SkCanvas,
        bitmap: *const SkBitmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas4saveEv"]
    pub fn SkCanvas_save(this: *mut SkCanvas) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9saveLayerEPK6SkRectPK7SkPaint"]
    pub fn SkCanvas_saveLayer(
        this: *mut SkCanvas,
        bounds: *const SkRect,
        paint: *const SkPaint,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas15saveLayerAlphafEPK6SkRectf"]
    pub fn SkCanvas_saveLayerAlphaf(
        this: *mut SkCanvas,
        bounds: *const SkRect,
        alpha: f32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9saveLayerERKNS_12SaveLayerRecE"]
    pub fn SkCanvas_saveLayer1(
        this: *mut SkCanvas,
        layerRec: *const SkCanvas_SaveLayerRec,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas7restoreEv"]
    pub fn SkCanvas_restore(this: *mut SkCanvas);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas12getSaveCountEv"]
    pub fn SkCanvas_getSaveCount(this: *const SkCanvas) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas14restoreToCountEi"]
    pub fn SkCanvas_restoreToCount(this: *mut SkCanvas, saveCount: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9translateEff"]
    pub fn SkCanvas_translate(this: *mut SkCanvas, dx: SkScalar, dy: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas5scaleEff"]
    pub fn SkCanvas_scale(this: *mut SkCanvas, sx: SkScalar, sy: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas6rotateEf"]
    pub fn SkCanvas_rotate(this: *mut SkCanvas, degrees: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas6rotateEfff"]
    pub fn SkCanvas_rotate1(this: *mut SkCanvas, degrees: SkScalar, px: SkScalar, py: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas4skewEff"]
    pub fn SkCanvas_skew(this: *mut SkCanvas, sx: SkScalar, sy: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas6concatERK8SkMatrix"]
    pub fn SkCanvas_concat(this: *mut SkCanvas, matrix: *const SkMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas6concatERK5SkM44"]
    pub fn SkCanvas_concat1(this: *mut SkCanvas, arg1: *const SkM44);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9setMatrixERK5SkM44"]
    pub fn SkCanvas_setMatrix(this: *mut SkCanvas, matrix: *const SkM44);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9setMatrixERK8SkMatrix"]
    pub fn SkCanvas_setMatrix1(this: *mut SkCanvas, matrix: *const SkMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11resetMatrixEv"]
    pub fn SkCanvas_resetMatrix(this: *mut SkCanvas);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8clipRectERK6SkRect8SkClipOpb"]
    pub fn SkCanvas_clipRect(
        this: *mut SkCanvas,
        rect: *const SkRect,
        op: SkClipOp,
        doAntiAlias: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas41androidFramework_setDeviceClipRestrictionERK7SkIRect"]
    pub fn SkCanvas_androidFramework_setDeviceClipRestriction(
        this: *mut SkCanvas,
        rect: *const SkIRect,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9clipRRectERK7SkRRect8SkClipOpb"]
    pub fn SkCanvas_clipRRect(
        this: *mut SkCanvas,
        rrect: *const SkRRect,
        op: SkClipOp,
        doAntiAlias: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8clipPathERK6SkPath8SkClipOpb"]
    pub fn SkCanvas_clipPath(
        this: *mut SkCanvas,
        path: *const SkPath,
        op: SkClipOp,
        doAntiAlias: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10clipShaderE5sk_spI8SkShaderE8SkClipOp"]
    pub fn SkCanvas_clipShader(this: *mut SkCanvas, arg1: sk_sp<SkShader>, arg2: SkClipOp);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10clipRegionERK8SkRegion8SkClipOp"]
    pub fn SkCanvas_clipRegion(this: *mut SkCanvas, deviceRgn: *const SkRegion, op: SkClipOp);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas11quickRejectERK6SkRect"]
    pub fn SkCanvas_quickReject(this: *const SkCanvas, rect: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas11quickRejectERK6SkPath"]
    pub fn SkCanvas_quickReject1(this: *const SkCanvas, path: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas18getLocalClipBoundsEv"]
    pub fn SkCanvas_getLocalClipBounds(this: *const SkCanvas) -> SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas19getDeviceClipBoundsEv"]
    pub fn SkCanvas_getDeviceClipBounds(this: *const SkCanvas) -> SkIRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawColorERK8SkRGBA4fIL11SkAlphaType3EE11SkBlendMode"]
    pub fn SkCanvas_drawColor(this: *mut SkCanvas, color: *const SkColor4f, mode: SkBlendMode);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawPaintERK7SkPaint"]
    pub fn SkCanvas_drawPaint(this: *mut SkCanvas, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawPointsENS_9PointModeE6SkSpanIK7SkPointERK7SkPaint"]
    pub fn SkCanvas_drawPoints(
        this: *mut SkCanvas,
        mode: SkCanvas_PointMode,
        arg1: SkSpan<SkPoint>,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawPointEffRK7SkPaint"]
    pub fn SkCanvas_drawPoint(this: *mut SkCanvas, x: SkScalar, y: SkScalar, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8drawLineEffffRK7SkPaint"]
    pub fn SkCanvas_drawLine(
        this: *mut SkCanvas,
        x0: SkScalar,
        y0: SkScalar,
        x1: SkScalar,
        y1: SkScalar,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8drawRectERK6SkRectRK7SkPaint"]
    pub fn SkCanvas_drawRect(this: *mut SkCanvas, rect: *const SkRect, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawRegionERK8SkRegionRK7SkPaint"]
    pub fn SkCanvas_drawRegion(this: *mut SkCanvas, region: *const SkRegion, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8drawOvalERK6SkRectRK7SkPaint"]
    pub fn SkCanvas_drawOval(this: *mut SkCanvas, oval: *const SkRect, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawRRectERK7SkRRectRK7SkPaint"]
    pub fn SkCanvas_drawRRect(this: *mut SkCanvas, rrect: *const SkRRect, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawDRRectERK7SkRRectS2_RK7SkPaint"]
    pub fn SkCanvas_drawDRRect(
        this: *mut SkCanvas,
        outer: *const SkRRect,
        inner: *const SkRRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawCircleEfffRK7SkPaint"]
    pub fn SkCanvas_drawCircle(
        this: *mut SkCanvas,
        cx: SkScalar,
        cy: SkScalar,
        radius: SkScalar,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas7drawArcERK6SkRectffbRK7SkPaint"]
    pub fn SkCanvas_drawArc(
        this: *mut SkCanvas,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
        useCenter: bool,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13drawRoundRectERK6SkRectffRK7SkPaint"]
    pub fn SkCanvas_drawRoundRect(
        this: *mut SkCanvas,
        rect: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8drawPathERK6SkPathRK7SkPaint"]
    pub fn SkCanvas_drawPath(this: *mut SkCanvas, path: *const SkPath, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawImageEPK7SkImageffRK17SkSamplingOptionsPK7SkPaint"]
    pub fn SkCanvas_drawImage(
        this: *mut SkCanvas,
        arg1: *const SkImage,
        x: SkScalar,
        y: SkScalar,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13drawImageRectEPK7SkImageRK6SkRectS5_RK17SkSamplingOptionsPK7SkPaintNS_17SrcRectConstraintE"]
    pub fn SkCanvas_drawImageRect(
        this: *mut SkCanvas,
        arg1: *const SkImage,
        src: *const SkRect,
        dst: *const SkRect,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
        arg4: SkCanvas_SrcRectConstraint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13drawImageRectEPK7SkImageRK6SkRectRK17SkSamplingOptionsPK7SkPaint"]
    pub fn SkCanvas_drawImageRect1(
        this: *mut SkCanvas,
        arg1: *const SkImage,
        dst: *const SkRect,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13drawImageNineEPK7SkImageRK7SkIRectRK6SkRect12SkFilterModePK7SkPaint"]
    pub fn SkCanvas_drawImageNine(
        this: *mut SkCanvas,
        image: *const SkImage,
        center: *const SkIRect,
        dst: *const SkRect,
        filter: SkFilterMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas16drawImageLatticeEPK7SkImageRKNS_7LatticeERK6SkRect12SkFilterModePK7SkPaint"]
    pub fn SkCanvas_drawImageLattice(
        this: *mut SkCanvas,
        image: *const SkImage,
        lattice: *const SkCanvas_Lattice,
        dst: *const SkRect,
        filter: SkFilterMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas27experimental_DrawEdgeAAQuadERK6SkRectPK7SkPointNS_11QuadAAFlagsERK8SkRGBA4fIL11SkAlphaType3EE11SkBlendMode"]
    pub fn SkCanvas_experimental_DrawEdgeAAQuad(
        this: *mut SkCanvas,
        rect: *const SkRect,
        clip: *const SkPoint,
        aaFlags: SkCanvas_QuadAAFlags,
        color: *const SkColor4f,
        mode: SkBlendMode,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas31experimental_DrawEdgeAAImageSetEPKNS_13ImageSetEntryEiPK7SkPointPK8SkMatrixRK17SkSamplingOptionsPK7SkPaintNS_17SrcRectConstraintE"]
    pub fn SkCanvas_experimental_DrawEdgeAAImageSet(
        this: *mut SkCanvas,
        imageSet: *const SkCanvas_ImageSetEntry,
        cnt: ::core::ffi::c_int,
        dstClips: *const SkPoint,
        preViewMatrices: *const SkMatrix,
        arg1: *const SkSamplingOptions,
        paint: *const SkPaint,
        constraint: SkCanvas_SrcRectConstraint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas14drawSimpleTextEPKvm14SkTextEncodingffRK6SkFontRK7SkPaint"]
    pub fn SkCanvas_drawSimpleText(
        this: *mut SkCanvas,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawGlyphsE6SkSpanIKtES0_IK7SkPointES0_IKjES0_IKcES3_RK6SkFontRK7SkPaint"]
    pub fn SkCanvas_drawGlyphs(
        this: *mut SkCanvas,
        glyphs: SkSpan<SkGlyphID>,
        positions: SkSpan<SkPoint>,
        clusters: SkSpan<u32>,
        utf8text: SkSpan<::core::ffi::c_char>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10drawGlyphsE6SkSpanIKtES0_IK7SkPointES3_RK6SkFontRK7SkPaint"]
    pub fn SkCanvas_drawGlyphs1(
        this: *mut SkCanvas,
        glyphs: SkSpan<SkGlyphID>,
        positions: SkSpan<SkPoint>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas17drawGlyphsRSXformE6SkSpanIKtES0_IK9SkRSXformE7SkPointRK6SkFontRK7SkPaint"]
    pub fn SkCanvas_drawGlyphsRSXform(
        this: *mut SkCanvas,
        glyphs: SkSpan<SkGlyphID>,
        xforms: SkSpan<SkRSXform>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12drawTextBlobEPK10SkTextBlobffRK7SkPaint"]
    pub fn SkCanvas_drawTextBlob(
        this: *mut SkCanvas,
        blob: *const SkTextBlob,
        x: SkScalar,
        y: SkScalar,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11drawPictureEPK9SkPicturePK8SkMatrixPK7SkPaint"]
    pub fn SkCanvas_drawPicture(
        this: *mut SkCanvas,
        picture: *const SkPicture,
        matrix: *const SkMatrix,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12drawVerticesEPK10SkVertices11SkBlendModeRK7SkPaint"]
    pub fn SkCanvas_drawVertices(
        this: *mut SkCanvas,
        vertices: *const SkVertices,
        mode: SkBlendMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12drawVerticesERK5sk_spI10SkVerticesE11SkBlendModeRK7SkPaint"]
    pub fn SkCanvas_drawVertices1(
        this: *mut SkCanvas,
        vertices: *const sk_sp<SkVertices>,
        mode: SkBlendMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas8drawMeshERK6SkMesh5sk_spI9SkBlenderERK7SkPaint"]
    pub fn SkCanvas_drawMesh(
        this: *mut SkCanvas,
        mesh: *const SkMesh,
        blender: sk_sp<SkBlender>,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawPatchEPK7SkPointPKjS2_11SkBlendModeRK7SkPaint"]
    pub fn SkCanvas_drawPatch(
        this: *mut SkCanvas,
        cubics: *const SkPoint,
        colors: *const SkColor,
        texCoords: *const SkPoint,
        mode: SkBlendMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9drawAtlasEPK7SkImage6SkSpanIK9SkRSXformES3_IK6SkRectES3_IKjE11SkBlendModeRK17SkSamplingOptionsPS8_PK7SkPaint"]
    pub fn SkCanvas_drawAtlas(
        this: *mut SkCanvas,
        atlas: *const SkImage,
        xform: SkSpan<SkRSXform>,
        tex: SkSpan<SkRect>,
        colors: SkSpan<SkColor>,
        mode: SkBlendMode,
        sampling: *const SkSamplingOptions,
        cullRect: *const SkRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12drawDrawableEP10SkDrawablePK8SkMatrix"]
    pub fn SkCanvas_drawDrawable(
        this: *mut SkCanvas,
        drawable: *mut SkDrawable,
        matrix: *const SkMatrix,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12drawDrawableEP10SkDrawableff"]
    pub fn SkCanvas_drawDrawable1(
        this: *mut SkCanvas,
        drawable: *mut SkDrawable,
        x: SkScalar,
        y: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas14drawAnnotationERK6SkRectPKcP6SkData"]
    pub fn SkCanvas_drawAnnotation(
        this: *mut SkCanvas,
        rect: *const SkRect,
        key: *const ::core::ffi::c_char,
        value: *mut SkData,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas16getLocalToDeviceEv"]
    pub fn SkCanvas_getLocalToDevice(this: *const SkCanvas) -> SkM44;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas14getTotalMatrixEv"]
    pub fn SkCanvas_getTotalMatrix(this: *const SkCanvas) -> SkMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas29temporary_internal_getRgnClipEP8SkRegion"]
    pub fn SkCanvas_temporary_internal_getRgnClip(this: *mut SkCanvas, region: *mut SkRegion);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas23private_draw_shadow_recERK6SkPathRK15SkDrawShadowRec"]
    pub fn SkCanvas_private_draw_shadow_rec(
        this: *mut SkCanvas,
        arg1: *const SkPath,
        arg2: *const SkDrawShadowRec,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1Ev"]
    pub fn SkCanvas_SkCanvas(this: *mut SkCanvas);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1EiiPK14SkSurfaceProps"]
    pub fn SkCanvas_SkCanvas1(
        this: *mut SkCanvas,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        props: *const SkSurfaceProps,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1E5sk_spI8SkDeviceE"]
    pub fn SkCanvas_SkCanvas2(this: *mut SkCanvas, device: sk_sp<SkDevice>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1ERK8SkBitmap"]
    pub fn SkCanvas_SkCanvas3(this: *mut SkCanvas, bitmap: *const SkBitmap);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1ERK8SkBitmapRK14SkSurfaceProps"]
    pub fn SkCanvas_SkCanvas4(
        this: *mut SkCanvas,
        bitmap: *const SkBitmap,
        props: *const SkSurfaceProps,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasC1ERK7SkIRect"]
    pub fn SkCanvas_SkCanvas5(this: *mut SkCanvas, bounds: *const SkIRect);
}
impl SkCanvas {
    #[inline]
    pub unsafe fn MakeRasterDirect(
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        props: *const SkSurfaceProps,
    ) -> u64 {
        SkCanvas_MakeRasterDirect(info, pixels, rowBytes, props)
    }
    #[inline]
    pub unsafe fn imageInfo(&self) -> SkImageInfo {
        SkCanvas_imageInfo(self)
    }
    #[inline]
    pub unsafe fn getProps(&self, props: *mut SkSurfaceProps) -> bool {
        SkCanvas_getProps(self, props)
    }
    #[inline]
    pub unsafe fn getBaseProps(&self) -> SkSurfaceProps {
        SkCanvas_getBaseProps(self)
    }
    #[inline]
    pub unsafe fn getTopProps(&self) -> SkSurfaceProps {
        SkCanvas_getTopProps(self)
    }
    #[inline]
    pub unsafe fn makeSurface(
        &mut self,
        info: *const SkImageInfo,
        props: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface> {
        SkCanvas_makeSurface(self, info, props)
    }
    #[inline]
    pub unsafe fn getSurface(&self) -> *mut SkSurface {
        SkCanvas_getSurface(self)
    }
    #[inline]
    pub unsafe fn accessTopLayerPixels(
        &mut self,
        info: *mut SkImageInfo,
        rowBytes: *mut usize,
        origin: *mut SkIPoint,
    ) -> *mut ::core::ffi::c_void {
        SkCanvas_accessTopLayerPixels(self, info, rowBytes, origin)
    }
    #[inline]
    pub unsafe fn accessTopRasterHandle(&self) -> SkRasterHandleAllocator_Handle {
        SkCanvas_accessTopRasterHandle(self)
    }
    #[inline]
    pub unsafe fn peekPixels(&mut self, pixmap: *mut SkPixmap) -> bool {
        SkCanvas_peekPixels(self, pixmap)
    }
    #[inline]
    pub unsafe fn readPixels(
        &mut self,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkCanvas_readPixels(self, dstInfo, dstPixels, dstRowBytes, srcX, srcY)
    }
    #[inline]
    pub unsafe fn readPixels1(
        &mut self,
        pixmap: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkCanvas_readPixels1(self, pixmap, srcX, srcY)
    }
    #[inline]
    pub unsafe fn readPixels2(
        &mut self,
        bitmap: *const SkBitmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkCanvas_readPixels2(self, bitmap, srcX, srcY)
    }
    #[inline]
    pub unsafe fn writePixels(
        &mut self,
        info: *const SkImageInfo,
        pixels: *const ::core::ffi::c_void,
        rowBytes: usize,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> bool {
        SkCanvas_writePixels(self, info, pixels, rowBytes, x, y)
    }
    #[inline]
    pub unsafe fn writePixels1(
        &mut self,
        bitmap: *const SkBitmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> bool {
        SkCanvas_writePixels1(self, bitmap, x, y)
    }
    #[inline]
    pub unsafe fn save(&mut self) -> ::core::ffi::c_int {
        SkCanvas_save(self)
    }
    #[inline]
    pub unsafe fn saveLayer(
        &mut self,
        bounds: *const SkRect,
        paint: *const SkPaint,
    ) -> ::core::ffi::c_int {
        SkCanvas_saveLayer(self, bounds, paint)
    }
    #[inline]
    pub unsafe fn saveLayerAlphaf(
        &mut self,
        bounds: *const SkRect,
        alpha: f32,
    ) -> ::core::ffi::c_int {
        SkCanvas_saveLayerAlphaf(self, bounds, alpha)
    }
    #[inline]
    pub unsafe fn saveLayer1(
        &mut self,
        layerRec: *const SkCanvas_SaveLayerRec,
    ) -> ::core::ffi::c_int {
        SkCanvas_saveLayer1(self, layerRec)
    }
    #[inline]
    pub unsafe fn restore(&mut self) {
        SkCanvas_restore(self)
    }
    #[inline]
    pub unsafe fn getSaveCount(&self) -> ::core::ffi::c_int {
        SkCanvas_getSaveCount(self)
    }
    #[inline]
    pub unsafe fn restoreToCount(&mut self, saveCount: ::core::ffi::c_int) {
        SkCanvas_restoreToCount(self, saveCount)
    }
    #[inline]
    pub unsafe fn translate(&mut self, dx: SkScalar, dy: SkScalar) {
        SkCanvas_translate(self, dx, dy)
    }
    #[inline]
    pub unsafe fn scale(&mut self, sx: SkScalar, sy: SkScalar) {
        SkCanvas_scale(self, sx, sy)
    }
    #[inline]
    pub unsafe fn rotate(&mut self, degrees: SkScalar) {
        SkCanvas_rotate(self, degrees)
    }
    #[inline]
    pub unsafe fn rotate1(&mut self, degrees: SkScalar, px: SkScalar, py: SkScalar) {
        SkCanvas_rotate1(self, degrees, px, py)
    }
    #[inline]
    pub unsafe fn skew(&mut self, sx: SkScalar, sy: SkScalar) {
        SkCanvas_skew(self, sx, sy)
    }
    #[inline]
    pub unsafe fn concat(&mut self, matrix: *const SkMatrix) {
        SkCanvas_concat(self, matrix)
    }
    #[inline]
    pub unsafe fn concat1(&mut self, arg1: *const SkM44) {
        SkCanvas_concat1(self, arg1)
    }
    #[inline]
    pub unsafe fn setMatrix(&mut self, matrix: *const SkM44) {
        SkCanvas_setMatrix(self, matrix)
    }
    #[inline]
    pub unsafe fn setMatrix1(&mut self, matrix: *const SkMatrix) {
        SkCanvas_setMatrix1(self, matrix)
    }
    #[inline]
    pub unsafe fn resetMatrix(&mut self) {
        SkCanvas_resetMatrix(self)
    }
    #[inline]
    pub unsafe fn clipRect(&mut self, rect: *const SkRect, op: SkClipOp, doAntiAlias: bool) {
        SkCanvas_clipRect(self, rect, op, doAntiAlias)
    }
    #[inline]
    pub unsafe fn androidFramework_setDeviceClipRestriction(&mut self, rect: *const SkIRect) {
        SkCanvas_androidFramework_setDeviceClipRestriction(self, rect)
    }
    #[inline]
    pub unsafe fn clipRRect(&mut self, rrect: *const SkRRect, op: SkClipOp, doAntiAlias: bool) {
        SkCanvas_clipRRect(self, rrect, op, doAntiAlias)
    }
    #[inline]
    pub unsafe fn clipPath(&mut self, path: *const SkPath, op: SkClipOp, doAntiAlias: bool) {
        SkCanvas_clipPath(self, path, op, doAntiAlias)
    }
    #[inline]
    pub unsafe fn clipShader(&mut self, arg1: sk_sp<SkShader>, arg2: SkClipOp) {
        SkCanvas_clipShader(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn clipRegion(&mut self, deviceRgn: *const SkRegion, op: SkClipOp) {
        SkCanvas_clipRegion(self, deviceRgn, op)
    }
    #[inline]
    pub unsafe fn quickReject(&self, rect: *const SkRect) -> bool {
        SkCanvas_quickReject(self, rect)
    }
    #[inline]
    pub unsafe fn quickReject1(&self, path: *const SkPath) -> bool {
        SkCanvas_quickReject1(self, path)
    }
    #[inline]
    pub unsafe fn getLocalClipBounds(&self) -> SkRect {
        SkCanvas_getLocalClipBounds(self)
    }
    #[inline]
    pub unsafe fn getDeviceClipBounds(&self) -> SkIRect {
        SkCanvas_getDeviceClipBounds(self)
    }
    #[inline]
    pub unsafe fn drawColor(&mut self, color: *const SkColor4f, mode: SkBlendMode) {
        SkCanvas_drawColor(self, color, mode)
    }
    #[inline]
    pub unsafe fn drawPaint(&mut self, paint: *const SkPaint) {
        SkCanvas_drawPaint(self, paint)
    }
    #[inline]
    pub unsafe fn drawPoints(
        &mut self,
        mode: SkCanvas_PointMode,
        arg1: SkSpan<SkPoint>,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawPoints(self, mode, arg1, paint)
    }
    #[inline]
    pub unsafe fn drawPoint(&mut self, x: SkScalar, y: SkScalar, paint: *const SkPaint) {
        SkCanvas_drawPoint(self, x, y, paint)
    }
    #[inline]
    pub unsafe fn drawLine(
        &mut self,
        x0: SkScalar,
        y0: SkScalar,
        x1: SkScalar,
        y1: SkScalar,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawLine(self, x0, y0, x1, y1, paint)
    }
    #[inline]
    pub unsafe fn drawRect(&mut self, rect: *const SkRect, paint: *const SkPaint) {
        SkCanvas_drawRect(self, rect, paint)
    }
    #[inline]
    pub unsafe fn drawRegion(&mut self, region: *const SkRegion, paint: *const SkPaint) {
        SkCanvas_drawRegion(self, region, paint)
    }
    #[inline]
    pub unsafe fn drawOval(&mut self, oval: *const SkRect, paint: *const SkPaint) {
        SkCanvas_drawOval(self, oval, paint)
    }
    #[inline]
    pub unsafe fn drawRRect(&mut self, rrect: *const SkRRect, paint: *const SkPaint) {
        SkCanvas_drawRRect(self, rrect, paint)
    }
    #[inline]
    pub unsafe fn drawDRRect(
        &mut self,
        outer: *const SkRRect,
        inner: *const SkRRect,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawDRRect(self, outer, inner, paint)
    }
    #[inline]
    pub unsafe fn drawCircle(
        &mut self,
        cx: SkScalar,
        cy: SkScalar,
        radius: SkScalar,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawCircle(self, cx, cy, radius, paint)
    }
    #[inline]
    pub unsafe fn drawArc(
        &mut self,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
        useCenter: bool,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawArc(self, oval, startAngle, sweepAngle, useCenter, paint)
    }
    #[inline]
    pub unsafe fn drawRoundRect(
        &mut self,
        rect: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawRoundRect(self, rect, rx, ry, paint)
    }
    #[inline]
    pub unsafe fn drawPath(&mut self, path: *const SkPath, paint: *const SkPaint) {
        SkCanvas_drawPath(self, path, paint)
    }
    #[inline]
    pub unsafe fn drawImage(
        &mut self,
        arg1: *const SkImage,
        x: SkScalar,
        y: SkScalar,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
    ) {
        SkCanvas_drawImage(self, arg1, x, y, arg2, arg3)
    }
    #[inline]
    pub unsafe fn drawImageRect(
        &mut self,
        arg1: *const SkImage,
        src: *const SkRect,
        dst: *const SkRect,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
        arg4: SkCanvas_SrcRectConstraint,
    ) {
        SkCanvas_drawImageRect(self, arg1, src, dst, arg2, arg3, arg4)
    }
    #[inline]
    pub unsafe fn drawImageRect1(
        &mut self,
        arg1: *const SkImage,
        dst: *const SkRect,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
    ) {
        SkCanvas_drawImageRect1(self, arg1, dst, arg2, arg3)
    }
    #[inline]
    pub unsafe fn drawImageNine(
        &mut self,
        image: *const SkImage,
        center: *const SkIRect,
        dst: *const SkRect,
        filter: SkFilterMode,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawImageNine(self, image, center, dst, filter, paint)
    }
    #[inline]
    pub unsafe fn drawImageLattice(
        &mut self,
        image: *const SkImage,
        lattice: *const SkCanvas_Lattice,
        dst: *const SkRect,
        filter: SkFilterMode,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawImageLattice(self, image, lattice, dst, filter, paint)
    }
    #[inline]
    pub unsafe fn experimental_DrawEdgeAAQuad(
        &mut self,
        rect: *const SkRect,
        clip: *const SkPoint,
        aaFlags: SkCanvas_QuadAAFlags,
        color: *const SkColor4f,
        mode: SkBlendMode,
    ) {
        SkCanvas_experimental_DrawEdgeAAQuad(self, rect, clip, aaFlags, color, mode)
    }
    #[inline]
    pub unsafe fn experimental_DrawEdgeAAImageSet(
        &mut self,
        imageSet: *const SkCanvas_ImageSetEntry,
        cnt: ::core::ffi::c_int,
        dstClips: *const SkPoint,
        preViewMatrices: *const SkMatrix,
        arg1: *const SkSamplingOptions,
        paint: *const SkPaint,
        constraint: SkCanvas_SrcRectConstraint,
    ) {
        SkCanvas_experimental_DrawEdgeAAImageSet(
            self,
            imageSet,
            cnt,
            dstClips,
            preViewMatrices,
            arg1,
            paint,
            constraint,
        )
    }
    #[inline]
    pub unsafe fn drawSimpleText(
        &mut self,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        font: *const SkFont,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawSimpleText(self, text, byteLength, encoding, x, y, font, paint)
    }
    #[inline]
    pub unsafe fn drawGlyphs(
        &mut self,
        glyphs: SkSpan<SkGlyphID>,
        positions: SkSpan<SkPoint>,
        clusters: SkSpan<u32>,
        utf8text: SkSpan<::core::ffi::c_char>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawGlyphs(
            self, glyphs, positions, clusters, utf8text, origin, font, paint,
        )
    }
    #[inline]
    pub unsafe fn drawGlyphs1(
        &mut self,
        glyphs: SkSpan<SkGlyphID>,
        positions: SkSpan<SkPoint>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawGlyphs1(self, glyphs, positions, origin, font, paint)
    }
    #[inline]
    pub unsafe fn drawGlyphsRSXform(
        &mut self,
        glyphs: SkSpan<SkGlyphID>,
        xforms: SkSpan<SkRSXform>,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawGlyphsRSXform(self, glyphs, xforms, origin, font, paint)
    }
    #[inline]
    pub unsafe fn drawTextBlob(
        &mut self,
        blob: *const SkTextBlob,
        x: SkScalar,
        y: SkScalar,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawTextBlob(self, blob, x, y, paint)
    }
    #[inline]
    pub unsafe fn drawPicture(
        &mut self,
        picture: *const SkPicture,
        matrix: *const SkMatrix,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawPicture(self, picture, matrix, paint)
    }
    #[inline]
    pub unsafe fn drawVertices(
        &mut self,
        vertices: *const SkVertices,
        mode: SkBlendMode,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawVertices(self, vertices, mode, paint)
    }
    #[inline]
    pub unsafe fn drawVertices1(
        &mut self,
        vertices: *const sk_sp<SkVertices>,
        mode: SkBlendMode,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawVertices1(self, vertices, mode, paint)
    }
    #[inline]
    pub unsafe fn drawMesh(
        &mut self,
        mesh: *const SkMesh,
        blender: sk_sp<SkBlender>,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawMesh(self, mesh, blender, paint)
    }
    #[inline]
    pub unsafe fn drawPatch(
        &mut self,
        cubics: *const SkPoint,
        colors: *const SkColor,
        texCoords: *const SkPoint,
        mode: SkBlendMode,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawPatch(self, cubics, colors, texCoords, mode, paint)
    }
    #[inline]
    pub unsafe fn drawAtlas(
        &mut self,
        atlas: *const SkImage,
        xform: SkSpan<SkRSXform>,
        tex: SkSpan<SkRect>,
        colors: SkSpan<SkColor>,
        mode: SkBlendMode,
        sampling: *const SkSamplingOptions,
        cullRect: *const SkRect,
        paint: *const SkPaint,
    ) {
        SkCanvas_drawAtlas(
            self, atlas, xform, tex, colors, mode, sampling, cullRect, paint,
        )
    }
    #[inline]
    pub unsafe fn drawDrawable(&mut self, drawable: *mut SkDrawable, matrix: *const SkMatrix) {
        SkCanvas_drawDrawable(self, drawable, matrix)
    }
    #[inline]
    pub unsafe fn drawDrawable1(&mut self, drawable: *mut SkDrawable, x: SkScalar, y: SkScalar) {
        SkCanvas_drawDrawable1(self, drawable, x, y)
    }
    #[inline]
    pub unsafe fn drawAnnotation(
        &mut self,
        rect: *const SkRect,
        key: *const ::core::ffi::c_char,
        value: *mut SkData,
    ) {
        SkCanvas_drawAnnotation(self, rect, key, value)
    }
    #[inline]
    pub unsafe fn getLocalToDevice(&self) -> SkM44 {
        SkCanvas_getLocalToDevice(self)
    }
    #[inline]
    pub unsafe fn getTotalMatrix(&self) -> SkMatrix {
        SkCanvas_getTotalMatrix(self)
    }
    #[inline]
    pub unsafe fn temporary_internal_getRgnClip(&mut self, region: *mut SkRegion) {
        SkCanvas_temporary_internal_getRgnClip(self, region)
    }
    #[inline]
    pub unsafe fn private_draw_shadow_rec(
        &mut self,
        arg1: *const SkPath,
        arg2: *const SkDrawShadowRec,
    ) {
        SkCanvas_private_draw_shadow_rec(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        props: *const SkSurfaceProps,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas1(__bindgen_tmp.as_mut_ptr(), width, height, props);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(device: sk_sp<SkDevice>) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas2(__bindgen_tmp.as_mut_ptr(), device);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(bitmap: *const SkBitmap) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas3(__bindgen_tmp.as_mut_ptr(), bitmap);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new4(bitmap: *const SkBitmap, props: *const SkSurfaceProps) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas4(__bindgen_tmp.as_mut_ptr(), bitmap, props);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new5(bounds: *const SkIRect) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCanvas_SkCanvas5(__bindgen_tmp.as_mut_ptr(), bounds);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvasD1Ev"]
    pub fn SkCanvas_SkCanvas_destructor(this: *mut SkCanvas);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas16getBaseLayerSizeEv"]
    pub fn SkCanvas_getBaseLayerSize(this: *mut ::core::ffi::c_void) -> SkISize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas16recordingContextEv"]
    pub fn SkCanvas_recordingContext(this: *mut ::core::ffi::c_void) -> *mut GrRecordingContext;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas8recorderEv"]
    pub fn SkCanvas_recorder(this: *mut ::core::ffi::c_void) -> *mut skgpu_graphite_Recorder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas12baseRecorderEv"]
    pub fn SkCanvas_baseRecorder(this: *mut ::core::ffi::c_void) -> *mut SkRecorder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas11isClipEmptyEv"]
    pub fn SkCanvas_isClipEmpty(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas10isClipRectEv"]
    pub fn SkCanvas_isClipRect(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onNewSurfaceERK11SkImageInfoRK14SkSurfaceProps"]
    pub fn SkCanvas_onNewSurface(
        this: *mut ::core::ffi::c_void,
        info: *const SkImageInfo,
        props: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onPeekPixelsEP8SkPixmap"]
    pub fn SkCanvas_onPeekPixels(this: *mut ::core::ffi::c_void, pixmap: *mut SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas22onAccessTopLayerPixelsEP8SkPixmap"]
    pub fn SkCanvas_onAccessTopLayerPixels(
        this: *mut ::core::ffi::c_void,
        pixmap: *mut SkPixmap,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas11onImageInfoEv"]
    pub fn SkCanvas_onImageInfo(this: *mut ::core::ffi::c_void) -> SkImageInfo;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkCanvas10onGetPropsEP14SkSurfacePropsb"]
    pub fn SkCanvas_onGetProps(
        this: *mut ::core::ffi::c_void,
        props: *mut SkSurfaceProps,
        top: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11onDrawPaintERK7SkPaint"]
    pub fn SkCanvas_onDrawPaint(this: *mut ::core::ffi::c_void, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawBehindERK7SkPaint"]
    pub fn SkCanvas_onDrawBehind(this: *mut ::core::ffi::c_void, paint: *const SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onDrawRectERK6SkRectRK7SkPaint"]
    pub fn SkCanvas_onDrawRect(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11onDrawRRectERK7SkRRectRK7SkPaint"]
    pub fn SkCanvas_onDrawRRect(
        this: *mut ::core::ffi::c_void,
        rrect: *const SkRRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawDRRectERK7SkRRectS2_RK7SkPaint"]
    pub fn SkCanvas_onDrawDRRect(
        this: *mut ::core::ffi::c_void,
        outer: *const SkRRect,
        inner: *const SkRRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onDrawOvalERK6SkRectRK7SkPaint"]
    pub fn SkCanvas_onDrawOval(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9onDrawArcERK6SkRectffbRK7SkPaint"]
    pub fn SkCanvas_onDrawArc(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
        useCenter: bool,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onDrawPathERK6SkPathRK7SkPaint"]
    pub fn SkCanvas_onDrawPath(
        this: *mut ::core::ffi::c_void,
        path: *const SkPath,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawRegionERK8SkRegionRK7SkPaint"]
    pub fn SkCanvas_onDrawRegion(
        this: *mut ::core::ffi::c_void,
        region: *const SkRegion,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas14onDrawTextBlobEPK10SkTextBlobffRK7SkPaint"]
    pub fn SkCanvas_onDrawTextBlob(
        this: *mut ::core::ffi::c_void,
        blob: *const SkTextBlob,
        x: SkScalar,
        y: SkScalar,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas18onDrawGlyphRunListERKN6sktext12GlyphRunListERK7SkPaint"]
    pub fn SkCanvas_onDrawGlyphRunList(
        this: *mut ::core::ffi::c_void,
        glyphRunList: *const sktext_GlyphRunList,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11onDrawPatchEPK7SkPointPKjS2_11SkBlendModeRK7SkPaint"]
    pub fn SkCanvas_onDrawPatch(
        this: *mut ::core::ffi::c_void,
        cubics: *const SkPoint,
        colors: *const SkColor,
        texCoords: *const SkPoint,
        mode: SkBlendMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawPointsENS_9PointModeEmPK7SkPointRK7SkPaint"]
    pub fn SkCanvas_onDrawPoints(
        this: *mut ::core::ffi::c_void,
        mode: SkCanvas_PointMode,
        count: usize,
        pts: *const SkPoint,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawImage2EPK7SkImageffRK17SkSamplingOptionsPK7SkPaint"]
    pub fn SkCanvas_onDrawImage2(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkImage,
        dx: SkScalar,
        dy: SkScalar,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas16onDrawImageRect2EPK7SkImageRK6SkRectS5_RK17SkSamplingOptionsPK7SkPaintNS_17SrcRectConstraintE"]
    pub fn SkCanvas_onDrawImageRect2(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkImage,
        src: *const SkRect,
        dst: *const SkRect,
        arg2: *const SkSamplingOptions,
        arg3: *const SkPaint,
        arg4: SkCanvas_SrcRectConstraint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas19onDrawImageLattice2EPK7SkImageRKNS_7LatticeERK6SkRect12SkFilterModePK7SkPaint"]
    pub fn SkCanvas_onDrawImageLattice2(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkImage,
        arg2: *const SkCanvas_Lattice,
        dst: *const SkRect,
        arg3: SkFilterMode,
        arg4: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onDrawAtlas2EPK7SkImagePK9SkRSXformPK6SkRectPKji11SkBlendModeRK17SkSamplingOptionsS8_PK7SkPaint"]
    pub fn SkCanvas_onDrawAtlas2(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkImage,
        arg2: *const SkRSXform,
        src: *const SkRect,
        arg3: *const SkColor,
        count: ::core::ffi::c_int,
        arg4: SkBlendMode,
        arg5: *const SkSamplingOptions,
        cull: *const SkRect,
        arg6: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas21onDrawEdgeAAImageSet2EPKNS_13ImageSetEntryEiPK7SkPointPK8SkMatrixRK17SkSamplingOptionsPK7SkPaintNS_17SrcRectConstraintE"]
    pub fn SkCanvas_onDrawEdgeAAImageSet2(
        this: *mut ::core::ffi::c_void,
        imageSet: *const SkCanvas_ImageSetEntry,
        count: ::core::ffi::c_int,
        dstClips: *const SkPoint,
        preViewMatrices: *const SkMatrix,
        arg1: *const SkSamplingOptions,
        arg2: *const SkPaint,
        arg3: SkCanvas_SrcRectConstraint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas20onDrawVerticesObjectEPK10SkVertices11SkBlendModeRK7SkPaint"]
    pub fn SkCanvas_onDrawVerticesObject(
        this: *mut ::core::ffi::c_void,
        vertices: *const SkVertices,
        mode: SkBlendMode,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onDrawMeshERK6SkMesh5sk_spI9SkBlenderERK7SkPaint"]
    pub fn SkCanvas_onDrawMesh(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkMesh,
        arg2: sk_sp<SkBlender>,
        arg3: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas16onDrawAnnotationERK6SkRectPKcP6SkData"]
    pub fn SkCanvas_onDrawAnnotation(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        key: *const ::core::ffi::c_char,
        value: *mut SkData,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas15onDrawShadowRecERK6SkPathRK15SkDrawShadowRec"]
    pub fn SkCanvas_onDrawShadowRec(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkPath,
        arg2: *const SkDrawShadowRec,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas14onDrawDrawableEP10SkDrawablePK8SkMatrix"]
    pub fn SkCanvas_onDrawDrawable(
        this: *mut ::core::ffi::c_void,
        drawable: *mut SkDrawable,
        matrix: *const SkMatrix,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas13onDrawPictureEPK9SkPicturePK8SkMatrixPK7SkPaint"]
    pub fn SkCanvas_onDrawPicture(
        this: *mut ::core::ffi::c_void,
        picture: *const SkPicture,
        matrix: *const SkMatrix,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas16onDrawEdgeAAQuadERK6SkRectPK7SkPointNS_11QuadAAFlagsERK8SkRGBA4fIL11SkAlphaType3EE11SkBlendMode"]
    pub fn SkCanvas_onDrawEdgeAAQuad(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        clip: *const SkPoint,
        aaFlags: SkCanvas_QuadAAFlags,
        color: *const SkColor4f,
        mode: SkBlendMode,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onClipRectERK6SkRect8SkClipOpNS_13ClipEdgeStyleE"]
    pub fn SkCanvas_onClipRect(
        this: *mut ::core::ffi::c_void,
        rect: *const SkRect,
        op: SkClipOp,
        edgeStyle: SkCanvas_ClipEdgeStyle,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11onClipRRectERK7SkRRect8SkClipOpNS_13ClipEdgeStyleE"]
    pub fn SkCanvas_onClipRRect(
        this: *mut ::core::ffi::c_void,
        rrect: *const SkRRect,
        op: SkClipOp,
        edgeStyle: SkCanvas_ClipEdgeStyle,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onClipPathERK6SkPath8SkClipOpNS_13ClipEdgeStyleE"]
    pub fn SkCanvas_onClipPath(
        this: *mut ::core::ffi::c_void,
        path: *const SkPath,
        op: SkClipOp,
        edgeStyle: SkCanvas_ClipEdgeStyle,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onClipShaderE5sk_spI8SkShaderE8SkClipOp"]
    pub fn SkCanvas_onClipShader(
        this: *mut ::core::ffi::c_void,
        arg1: sk_sp<SkShader>,
        arg2: SkClipOp,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas12onClipRegionERK8SkRegion8SkClipOp"]
    pub fn SkCanvas_onClipRegion(
        this: *mut ::core::ffi::c_void,
        deviceRgn: *const SkRegion,
        op: SkClipOp,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas11onResetClipEv"]
    pub fn SkCanvas_onResetClip(this: *mut ::core::ffi::c_void);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas9onDiscardEv"]
    pub fn SkCanvas_onDiscard(this: *mut ::core::ffi::c_void);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas27onConvertGlyphRunListToSlugERKN6sktext12GlyphRunListERK7SkPaint"]
    pub fn SkCanvas_onConvertGlyphRunListToSlug(
        this: *mut ::core::ffi::c_void,
        glyphRunList: *const sktext_GlyphRunList,
        paint: *const SkPaint,
    ) -> sk_sp<sktext_gpu_Slug>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkCanvas10onDrawSlugEPKN6sktext3gpu4SlugERK7SkPaint"]
    pub fn SkCanvas_onDrawSlug(
        this: *mut ::core::ffi::c_void,
        slug: *const sktext_gpu_Slug,
        paint: *const SkPaint,
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct SkAutoCanvasRestore {
    pub fCanvas: *mut SkCanvas,
    pub fSaveCount: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkAutoCanvasRestore"][::core::mem::size_of::<SkAutoCanvasRestore>() - 16usize];
    ["Alignment of SkAutoCanvasRestore"][::core::mem::align_of::<SkAutoCanvasRestore>() - 8usize];
    ["Offset of field: SkAutoCanvasRestore::fCanvas"]
        [::core::mem::offset_of!(SkAutoCanvasRestore, fCanvas) - 0usize];
    ["Offset of field: SkAutoCanvasRestore::fSaveCount"]
        [::core::mem::offset_of!(SkAutoCanvasRestore, fSaveCount) - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkColorFilter {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
pub type SkColorFilter_INHERITED = SkFlattenable;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorFilter"][::core::mem::size_of::<SkColorFilter>() - 16usize];
    ["Alignment of SkColorFilter"][::core::mem::align_of::<SkColorFilter>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter12asAColorModeEPjP11SkBlendMode"]
    pub fn SkColorFilter_asAColorMode(
        this: *const SkColorFilter,
        color: *mut SkColor,
        mode: *mut SkBlendMode,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter14asAColorMatrixEPf"]
    pub fn SkColorFilter_asAColorMatrix(this: *const SkColorFilter, matrix: *mut f32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter16isAlphaUnchangedEv"]
    pub fn SkColorFilter_isAlphaUnchanged(this: *const SkColorFilter) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter13filterColor4fERK8SkRGBA4fIL11SkAlphaType3EEP12SkColorSpaceS6_"]
    pub fn SkColorFilter_filterColor4f(
        this: *const SkColorFilter,
        srcColor: *const SkColor4f,
        srcCS: *mut SkColorSpace,
        dstCS: *mut SkColorSpace,
    ) -> SkColor4f;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter12makeComposedE5sk_spIS_E"]
    pub fn SkColorFilter_makeComposed(
        this: *const SkColorFilter,
        inner: sk_sp<SkColorFilter>,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkColorFilter25makeWithWorkingColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkColorFilter_makeWithWorkingColorSpace(
        this: *const SkColorFilter,
        arg1: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorFilter11DeserializeEPKvmPK15SkDeserialProcs"]
    pub fn SkColorFilter_Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkColorFilter>;
}
impl SkColorFilter {
    #[inline]
    pub unsafe fn asAColorMode(&self, color: *mut SkColor, mode: *mut SkBlendMode) -> bool {
        SkColorFilter_asAColorMode(self, color, mode)
    }
    #[inline]
    pub unsafe fn asAColorMatrix(&self, matrix: *mut f32) -> bool {
        SkColorFilter_asAColorMatrix(self, matrix)
    }
    #[inline]
    pub unsafe fn isAlphaUnchanged(&self) -> bool {
        SkColorFilter_isAlphaUnchanged(self)
    }
    #[inline]
    pub unsafe fn filterColor4f(
        &self,
        srcColor: *const SkColor4f,
        srcCS: *mut SkColorSpace,
        dstCS: *mut SkColorSpace,
    ) -> SkColor4f {
        SkColorFilter_filterColor4f(self, srcColor, srcCS, dstCS)
    }
    #[inline]
    pub unsafe fn makeComposed(&self, inner: sk_sp<SkColorFilter>) -> sk_sp<SkColorFilter> {
        SkColorFilter_makeComposed(self, inner)
    }
    #[inline]
    pub unsafe fn makeWithWorkingColorSpace(
        &self,
        arg1: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkColorFilter> {
        SkColorFilter_makeWithWorkingColorSpace(self, arg1)
    }
    #[inline]
    pub unsafe fn Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkColorFilter> {
        SkColorFilter_Deserialize(data, size, procs)
    }
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkColorFilters_Clamp {
    No = 0,
    Yes = 1,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkColorTable {
    pub _base: SkRefCnt,
    pub fTable: SkBitmap,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorTable"][::core::mem::size_of::<SkColorTable>() - 72usize];
    ["Alignment of SkColorTable"][::core::mem::align_of::<SkColorTable>() - 8usize];
    ["Offset of field: SkColorTable::fTable"]
        [::core::mem::offset_of!(SkColorTable, fTable) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorTable4MakeEPKhS1_S1_S1_"]
    pub fn SkColorTable_Make(
        tableA: *const u8,
        tableR: *const u8,
        tableG: *const u8,
        tableB: *const u8,
    ) -> sk_sp<SkColorTable>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkColorTable7flattenER13SkWriteBuffer"]
    pub fn SkColorTable_flatten(this: *const SkColorTable, buffer: *mut SkWriteBuffer);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkColorTable11DeserializeER12SkReadBuffer"]
    pub fn SkColorTable_Deserialize(buffer: *mut SkReadBuffer) -> sk_sp<SkColorTable>;
}
impl SkColorTable {
    #[inline]
    pub unsafe fn Make(
        tableA: *const u8,
        tableR: *const u8,
        tableG: *const u8,
        tableB: *const u8,
    ) -> sk_sp<SkColorTable> {
        SkColorTable_Make(tableA, tableR, tableG, tableB)
    }
    #[inline]
    pub unsafe fn flatten(&self, buffer: *mut SkWriteBuffer) {
        SkColorTable_flatten(self, buffer)
    }
    #[inline]
    pub unsafe fn Deserialize(buffer: *mut SkReadBuffer) -> sk_sp<SkColorTable> {
        SkColorTable_Deserialize(buffer)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct skcpu_Recorder {
    pub _base: SkRecorder,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of skcpu_Recorder"][::core::mem::size_of::<skcpu_Recorder>() - 8usize];
    ["Alignment of skcpu_Recorder"][::core::mem::align_of::<skcpu_Recorder>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5skcpu8Recorder4TODOEv"]
    pub fn skcpu_Recorder_TODO() -> *mut skcpu_Recorder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5skcpu8Recorder17makeBitmapSurfaceERK11SkImageInfomPK14SkSurfaceProps"]
    pub fn skcpu_Recorder_makeBitmapSurface(
        this: *mut skcpu_Recorder,
        imageInfo: *const SkImageInfo,
        rowBytes: usize,
        surfaceProps: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5skcpu8Recorder17makeBitmapSurfaceERK11SkImageInfoPK14SkSurfaceProps"]
    pub fn skcpu_Recorder_makeBitmapSurface1(
        this: *mut skcpu_Recorder,
        imageInfo: *const SkImageInfo,
        surfaceProps: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface>;
}
impl skcpu_Recorder {
    #[inline]
    pub unsafe fn TODO() -> *mut skcpu_Recorder {
        skcpu_Recorder_TODO()
    }
    #[inline]
    pub unsafe fn makeBitmapSurface(
        &mut self,
        imageInfo: *const SkImageInfo,
        rowBytes: usize,
        surfaceProps: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface> {
        skcpu_Recorder_makeBitmapSurface(self, imageInfo, rowBytes, surfaceProps)
    }
    #[inline]
    pub unsafe fn makeBitmapSurface1(
        &mut self,
        imageInfo: *const SkImageInfo,
        surfaceProps: *const SkSurfaceProps,
    ) -> sk_sp<SkSurface> {
        skcpu_Recorder_makeBitmapSurface1(self, imageInfo, surfaceProps)
    }
}
#[repr(C)]
pub struct SkRecorder__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct SkRecorder {
    pub vtable_: *const SkRecorder__bindgen_vtable,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRecorder_Type {
    CPU = 0,
    Ganesh = 1,
    Graphite = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRecorder"][::core::mem::size_of::<SkRecorder>() - 8usize];
    ["Alignment of SkRecorder"][::core::mem::align_of::<SkRecorder>() - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkTDStorage {
    pub fSizeOfT: ::core::ffi::c_int,
    pub fStorage: *mut std_byte,
    pub fCapacity: ::core::ffi::c_int,
    pub fSize: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTDStorage"][::core::mem::size_of::<SkTDStorage>() - 24usize];
    ["Alignment of SkTDStorage"][::core::mem::align_of::<SkTDStorage>() - 8usize];
    ["Offset of field: SkTDStorage::fSizeOfT"]
        [::core::mem::offset_of!(SkTDStorage, fSizeOfT) - 0usize];
    ["Offset of field: SkTDStorage::fStorage"]
        [::core::mem::offset_of!(SkTDStorage, fStorage) - 8usize];
    ["Offset of field: SkTDStorage::fCapacity"]
        [::core::mem::offset_of!(SkTDStorage, fCapacity) - 16usize];
    ["Offset of field: SkTDStorage::fSize"][::core::mem::offset_of!(SkTDStorage, fSize) - 20usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage5resetEv"]
    pub fn SkTDStorage_reset(this: *mut SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage4swapERS_"]
    pub fn SkTDStorage_swap(this: *mut SkTDStorage, that: *mut SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6resizeEi"]
    pub fn SkTDStorage_resize(this: *mut SkTDStorage, newSize: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage7reserveEi"]
    pub fn SkTDStorage_reserve(this: *mut SkTDStorage, newCapacity: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage13shrink_to_fitEv"]
    pub fn SkTDStorage_shrink_to_fit(this: *mut SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage5eraseEii"]
    pub fn SkTDStorage_erase(
        this: *mut SkTDStorage,
        index: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage13removeShuffleEi"]
    pub fn SkTDStorage_removeShuffle(this: *mut SkTDStorage, index: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage7prependEv"]
    pub fn SkTDStorage_prepend(this: *mut SkTDStorage) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6appendEv"]
    pub fn SkTDStorage_append(this: *mut SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6appendEi"]
    pub fn SkTDStorage_append1(this: *mut SkTDStorage, count: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6appendEPKvi"]
    pub fn SkTDStorage_append2(
        this: *mut SkTDStorage,
        src: *const ::core::ffi::c_void,
        count: ::core::ffi::c_int,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6insertEi"]
    pub fn SkTDStorage_insert(
        this: *mut SkTDStorage,
        index: ::core::ffi::c_int,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorage6insertEiiPKv"]
    pub fn SkTDStorage_insert1(
        this: *mut SkTDStorage,
        index: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        src: *const ::core::ffi::c_void,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorageC1Ei"]
    pub fn SkTDStorage_SkTDStorage(this: *mut SkTDStorage, sizeOfT: ::core::ffi::c_int);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorageC1EPKvii"]
    pub fn SkTDStorage_SkTDStorage1(
        this: *mut SkTDStorage,
        src: *const ::core::ffi::c_void,
        size: ::core::ffi::c_int,
        sizeOfT: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorageC1ERKS_"]
    pub fn SkTDStorage_SkTDStorage2(this: *mut SkTDStorage, that: *const SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorageC1EOS_"]
    pub fn SkTDStorage_SkTDStorage3(this: *mut SkTDStorage, that: *mut SkTDStorage);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTDStorageD1Ev"]
    pub fn SkTDStorage_SkTDStorage_destructor(this: *mut SkTDStorage);
}
impl SkTDStorage {
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkTDStorage_reset(self)
    }
    #[inline]
    pub unsafe fn swap(&mut self, that: *mut SkTDStorage) {
        SkTDStorage_swap(self, that)
    }
    #[inline]
    pub unsafe fn resize(&mut self, newSize: ::core::ffi::c_int) {
        SkTDStorage_resize(self, newSize)
    }
    #[inline]
    pub unsafe fn reserve(&mut self, newCapacity: ::core::ffi::c_int) {
        SkTDStorage_reserve(self, newCapacity)
    }
    #[inline]
    pub unsafe fn shrink_to_fit(&mut self) {
        SkTDStorage_shrink_to_fit(self)
    }
    #[inline]
    pub unsafe fn erase(&mut self, index: ::core::ffi::c_int, count: ::core::ffi::c_int) {
        SkTDStorage_erase(self, index, count)
    }
    #[inline]
    pub unsafe fn removeShuffle(&mut self, index: ::core::ffi::c_int) {
        SkTDStorage_removeShuffle(self, index)
    }
    #[inline]
    pub unsafe fn prepend(&mut self) -> *mut ::core::ffi::c_void {
        SkTDStorage_prepend(self)
    }
    #[inline]
    pub unsafe fn append(&mut self) {
        SkTDStorage_append(self)
    }
    #[inline]
    pub unsafe fn append1(&mut self, count: ::core::ffi::c_int) {
        SkTDStorage_append1(self, count)
    }
    #[inline]
    pub unsafe fn append2(
        &mut self,
        src: *const ::core::ffi::c_void,
        count: ::core::ffi::c_int,
    ) -> *mut ::core::ffi::c_void {
        SkTDStorage_append2(self, src, count)
    }
    #[inline]
    pub unsafe fn insert(&mut self, index: ::core::ffi::c_int) -> *mut ::core::ffi::c_void {
        SkTDStorage_insert(self, index)
    }
    #[inline]
    pub unsafe fn insert1(
        &mut self,
        index: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        src: *const ::core::ffi::c_void,
    ) -> *mut ::core::ffi::c_void {
        SkTDStorage_insert1(self, index, count, src)
    }
    #[inline]
    pub unsafe fn new(sizeOfT: ::core::ffi::c_int) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTDStorage_SkTDStorage(__bindgen_tmp.as_mut_ptr(), sizeOfT);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        src: *const ::core::ffi::c_void,
        size: ::core::ffi::c_int,
        sizeOfT: ::core::ffi::c_int,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTDStorage_SkTDStorage1(__bindgen_tmp.as_mut_ptr(), src, size, sizeOfT);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(that: *const SkTDStorage) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTDStorage_SkTDStorage2(__bindgen_tmp.as_mut_ptr(), that);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(that: *mut SkTDStorage) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTDStorage_SkTDStorage3(__bindgen_tmp.as_mut_ptr(), that);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkTDStorage_SkTDStorage_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkTDArray {
    pub fStorage: SkTDStorage,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkContourMeasure {
    pub _bindgen_opaque_blob: [u64; 9usize],
}
pub const SkContourMeasure_MatrixFlags_kGetPosition_MatrixFlag: SkContourMeasure_MatrixFlags = 1;
pub const SkContourMeasure_MatrixFlags_kGetTangent_MatrixFlag: SkContourMeasure_MatrixFlags = 2;
pub const SkContourMeasure_MatrixFlags_kGetPosAndTan_MatrixFlag: SkContourMeasure_MatrixFlags = 3;
pub type SkContourMeasure_MatrixFlags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkContourMeasure_VerbMeasure {
    pub fDistance: SkScalar,
    pub fVerb: SkPathVerb,
    pub fPts: SkSpan<SkPoint>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkContourMeasure_VerbMeasure"]
        [::core::mem::size_of::<SkContourMeasure_VerbMeasure>() - 24usize];
    ["Alignment of SkContourMeasure_VerbMeasure"]
        [::core::mem::align_of::<SkContourMeasure_VerbMeasure>() - 8usize];
    ["Offset of field: SkContourMeasure_VerbMeasure::fDistance"]
        [::core::mem::offset_of!(SkContourMeasure_VerbMeasure, fDistance) - 0usize];
    ["Offset of field: SkContourMeasure_VerbMeasure::fVerb"]
        [::core::mem::offset_of!(SkContourMeasure_VerbMeasure, fVerb) - 4usize];
    ["Offset of field: SkContourMeasure_VerbMeasure::fPts"]
        [::core::mem::offset_of!(SkContourMeasure_VerbMeasure, fPts) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkContourMeasure_ForwardVerbIterator {
    pub fSegments: SkSpan<SkContourMeasure_Segment>,
    pub fPts: SkSpan<SkPoint>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkContourMeasure_ForwardVerbIterator"]
        [::core::mem::size_of::<SkContourMeasure_ForwardVerbIterator>() - 32usize];
    ["Alignment of SkContourMeasure_ForwardVerbIterator"]
        [::core::mem::align_of::<SkContourMeasure_ForwardVerbIterator>() - 8usize];
    ["Offset of field: SkContourMeasure_ForwardVerbIterator::fSegments"]
        [::core::mem::offset_of!(SkContourMeasure_ForwardVerbIterator, fSegments) - 0usize];
    ["Offset of field: SkContourMeasure_ForwardVerbIterator::fPts"]
        [::core::mem::offset_of!(SkContourMeasure_ForwardVerbIterator, fPts) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkContourMeasure_Segment {
    pub fDistance: SkScalar,
    pub fPtIndex: ::core::ffi::c_uint,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkContourMeasure_Segment"]
        [::core::mem::size_of::<SkContourMeasure_Segment>() - 12usize];
    ["Alignment of SkContourMeasure_Segment"]
        [::core::mem::align_of::<SkContourMeasure_Segment>() - 4usize];
    ["Offset of field: SkContourMeasure_Segment::fDistance"]
        [::core::mem::offset_of!(SkContourMeasure_Segment, fDistance) - 0usize];
    ["Offset of field: SkContourMeasure_Segment::fPtIndex"]
        [::core::mem::offset_of!(SkContourMeasure_Segment, fPtIndex) - 4usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkContourMeasure7Segment10getScalarTEv"]
    pub fn SkContourMeasure_Segment_getScalarT(this: *const SkContourMeasure_Segment) -> SkScalar;
}
impl SkContourMeasure_Segment {
    #[inline]
    pub fn fTValue(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_fTValue(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fTValue_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                30u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fTValue_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                30u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fType(&self) -> ::core::ffi::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(30usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fType(&mut self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(30usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fType_raw(this: *const Self) -> ::core::ffi::c_uint {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fType_raw(this: *mut Self, val: ::core::ffi::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fTValue: ::core::ffi::c_uint,
        fType: ::core::ffi::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 30u8, {
            let fTValue: u32 = unsafe { ::core::mem::transmute(fTValue) };
            fTValue as u64
        });
        __bindgen_bitfield_unit.set(30usize, 2u8, {
            let fType: u32 = unsafe { ::core::mem::transmute(fType) };
            fType as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub unsafe fn getScalarT(&self) -> SkScalar {
        SkContourMeasure_Segment_getScalarT(self)
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkContourMeasure"][::core::mem::size_of::<SkContourMeasure>() - 72usize];
    ["Alignment of SkContourMeasure"][::core::mem::align_of::<SkContourMeasure>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkContourMeasure9getPosTanEfP7SkPointS1_"]
    pub fn SkContourMeasure_getPosTan(
        this: *const SkContourMeasure,
        distance: SkScalar,
        position: *mut SkPoint,
        tangent: *mut SkVector,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkContourMeasure9getMatrixEfP8SkMatrixNS_11MatrixFlagsE"]
    pub fn SkContourMeasure_getMatrix(
        this: *const SkContourMeasure,
        distance: SkScalar,
        matrix: *mut SkMatrix,
        flags: SkContourMeasure_MatrixFlags,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkContourMeasure10getSegmentEffP13SkPathBuilderb"]
    pub fn SkContourMeasure_getSegment(
        this: *const SkContourMeasure,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPathBuilder,
        startWithMoveTo: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkContourMeasure10getSegmentEffP6SkPathb"]
    pub fn SkContourMeasure_getSegment1(
        this: *const SkContourMeasure,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPath,
        startWithMoveTo: bool,
    ) -> bool;
}
impl SkContourMeasure {
    #[inline]
    pub unsafe fn getPosTan(
        &self,
        distance: SkScalar,
        position: *mut SkPoint,
        tangent: *mut SkVector,
    ) -> bool {
        SkContourMeasure_getPosTan(self, distance, position, tangent)
    }
    #[inline]
    pub unsafe fn getMatrix(
        &self,
        distance: SkScalar,
        matrix: *mut SkMatrix,
        flags: SkContourMeasure_MatrixFlags,
    ) -> bool {
        SkContourMeasure_getMatrix(self, distance, matrix, flags)
    }
    #[inline]
    pub unsafe fn getSegment(
        &self,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPathBuilder,
        startWithMoveTo: bool,
    ) -> bool {
        SkContourMeasure_getSegment(self, startD, stopD, dst, startWithMoveTo)
    }
    #[inline]
    pub unsafe fn getSegment1(
        &self,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPath,
        startWithMoveTo: bool,
    ) -> bool {
        SkContourMeasure_getSegment1(self, startD, stopD, dst, startWithMoveTo)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkContourMeasureIter {
    pub fImpl: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkContourMeasureIter_Impl {
    _unused: [u8; 0],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkContourMeasureIter"][::core::mem::size_of::<SkContourMeasureIter>() - 8usize];
    ["Alignment of SkContourMeasureIter"][::core::mem::align_of::<SkContourMeasureIter>() - 8usize];
    ["Offset of field: SkContourMeasureIter::fImpl"]
        [::core::mem::offset_of!(SkContourMeasureIter, fImpl) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIter5resetERK6SkPathbf"]
    pub fn SkContourMeasureIter_reset(
        this: *mut SkContourMeasureIter,
        path: *const SkPath,
        forceClosed: bool,
        resScale: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIter4nextEv"]
    pub fn SkContourMeasureIter_next(this: *mut SkContourMeasureIter) -> sk_sp<SkContourMeasure>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIterC1Ev"]
    pub fn SkContourMeasureIter_SkContourMeasureIter(this: *mut SkContourMeasureIter);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIterC1ERK6SkPathbf"]
    pub fn SkContourMeasureIter_SkContourMeasureIter1(
        this: *mut SkContourMeasureIter,
        path: *const SkPath,
        forceClosed: bool,
        resScale: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIterC1EOS_"]
    pub fn SkContourMeasureIter_SkContourMeasureIter2(
        this: *mut SkContourMeasureIter,
        arg1: *mut SkContourMeasureIter,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN20SkContourMeasureIterD1Ev"]
    pub fn SkContourMeasureIter_SkContourMeasureIter_destructor(this: *mut SkContourMeasureIter);
}
impl SkContourMeasureIter {
    #[inline]
    pub unsafe fn reset(&mut self, path: *const SkPath, forceClosed: bool, resScale: SkScalar) {
        SkContourMeasureIter_reset(self, path, forceClosed, resScale)
    }
    #[inline]
    pub unsafe fn next(&mut self) -> sk_sp<SkContourMeasure> {
        SkContourMeasureIter_next(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkContourMeasureIter_SkContourMeasureIter(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(path: *const SkPath, forceClosed: bool, resScale: SkScalar) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkContourMeasureIter_SkContourMeasureIter1(
            __bindgen_tmp.as_mut_ptr(),
            path,
            forceClosed,
            resScale,
        );
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(arg1: *mut SkContourMeasureIter) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkContourMeasureIter_SkContourMeasureIter2(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkContourMeasureIter_SkContourMeasureIter_destructor(self)
    }
}
impl SkCoverageMode {
    pub const Last: SkCoverageMode = SkCoverageMode::Xor;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCoverageMode {
    Union = 0,
    Intersect = 1,
    Difference = 2,
    ReverseDifference = 3,
    Xor = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCubicMap {
    pub fCoeff: [SkPoint; 3usize],
    pub fType: SkCubicMap_Type,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkCubicMap_Type {
    Line = 0,
    CubeRoot = 1,
    Solver = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCubicMap"][::core::mem::size_of::<SkCubicMap>() - 28usize];
    ["Alignment of SkCubicMap"][::core::mem::align_of::<SkCubicMap>() - 4usize];
    ["Offset of field: SkCubicMap::fCoeff"][::core::mem::offset_of!(SkCubicMap, fCoeff) - 0usize];
    ["Offset of field: SkCubicMap::fType"][::core::mem::offset_of!(SkCubicMap, fType) - 24usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkCubicMap13computeYFromXEf"]
    pub fn SkCubicMap_computeYFromX(this: *const SkCubicMap, x: f32) -> f32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkCubicMap12computeFromTEf"]
    pub fn SkCubicMap_computeFromT(this: *const SkCubicMap, t: f32) -> SkPoint;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkCubicMapC1E7SkPointS0_"]
    pub fn SkCubicMap_SkCubicMap(this: *mut SkCubicMap, p1: SkPoint, p2: SkPoint);
}
impl SkCubicMap {
    #[inline]
    pub unsafe fn computeYFromX(&self, x: f32) -> f32 {
        SkCubicMap_computeYFromX(self, x)
    }
    #[inline]
    pub unsafe fn computeFromT(&self, t: f32) -> SkPoint {
        SkCubicMap_computeFromT(self, t)
    }
    #[inline]
    pub unsafe fn new(p1: SkPoint, p2: SkPoint) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCubicMap_SkCubicMap(__bindgen_tmp.as_mut_ptr(), p1, p2);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDataTable {
    pub _bindgen_opaque_blob: [u64; 6usize],
}
pub type SkDataTable_FreeProc =
    ::core::option::Option<unsafe extern "C" fn(context: *mut ::core::ffi::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDataTable_Dir {
    pub fPtr: *const ::core::ffi::c_void,
    pub fSize: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDataTable_Dir"][::core::mem::size_of::<SkDataTable_Dir>() - 16usize];
    ["Alignment of SkDataTable_Dir"][::core::mem::align_of::<SkDataTable_Dir>() - 8usize];
    ["Offset of field: SkDataTable_Dir::fPtr"]
        [::core::mem::offset_of!(SkDataTable_Dir, fPtr) - 0usize];
    ["Offset of field: SkDataTable_Dir::fSize"]
        [::core::mem::offset_of!(SkDataTable_Dir, fSize) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union SkDataTable__bindgen_ty_1 {
    pub fDir: *const SkDataTable_Dir,
    pub fElems: *const ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDataTable__bindgen_ty_1"]
        [::core::mem::size_of::<SkDataTable__bindgen_ty_1>() - 8usize];
    ["Alignment of SkDataTable__bindgen_ty_1"]
        [::core::mem::align_of::<SkDataTable__bindgen_ty_1>() - 8usize];
    ["Offset of field: SkDataTable__bindgen_ty_1::fDir"]
        [::core::mem::offset_of!(SkDataTable__bindgen_ty_1, fDir) - 0usize];
    ["Offset of field: SkDataTable__bindgen_ty_1::fElems"]
        [::core::mem::offset_of!(SkDataTable__bindgen_ty_1, fElems) - 0usize];
};
pub type SkDataTable_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDataTable"][::core::mem::size_of::<SkDataTable>() - 48usize];
    ["Alignment of SkDataTable"][::core::mem::align_of::<SkDataTable>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkDataTable6atSizeEi"]
    pub fn SkDataTable_atSize(this: *const SkDataTable, index: ::core::ffi::c_int) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkDataTable2atEiPm"]
    pub fn SkDataTable_at(
        this: *const SkDataTable,
        index: ::core::ffi::c_int,
        size: *mut usize,
    ) -> *const ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkDataTable9MakeEmptyEv"]
    pub fn SkDataTable_MakeEmpty() -> sk_sp<SkDataTable>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkDataTable14MakeCopyArraysEPKPKvPKmi"]
    pub fn SkDataTable_MakeCopyArrays(
        ptrs: *const *const ::core::ffi::c_void,
        sizes: *const usize,
        count: ::core::ffi::c_int,
    ) -> sk_sp<SkDataTable>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkDataTable13MakeCopyArrayEPKvmi"]
    pub fn SkDataTable_MakeCopyArray(
        array: *const ::core::ffi::c_void,
        elemSize: usize,
        count: ::core::ffi::c_int,
    ) -> sk_sp<SkDataTable>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkDataTable13MakeArrayProcEPKvmiPFvPvES2_"]
    pub fn SkDataTable_MakeArrayProc(
        array: *const ::core::ffi::c_void,
        elemSize: usize,
        count: ::core::ffi::c_int,
        proc_: SkDataTable_FreeProc,
        context: *mut ::core::ffi::c_void,
    ) -> sk_sp<SkDataTable>;
}
impl SkDataTable {
    #[inline]
    pub unsafe fn atSize(&self, index: ::core::ffi::c_int) -> usize {
        SkDataTable_atSize(self, index)
    }
    #[inline]
    pub unsafe fn at(
        &self,
        index: ::core::ffi::c_int,
        size: *mut usize,
    ) -> *const ::core::ffi::c_void {
        SkDataTable_at(self, index, size)
    }
    #[inline]
    pub unsafe fn MakeEmpty() -> sk_sp<SkDataTable> {
        SkDataTable_MakeEmpty()
    }
    #[inline]
    pub unsafe fn MakeCopyArrays(
        ptrs: *const *const ::core::ffi::c_void,
        sizes: *const usize,
        count: ::core::ffi::c_int,
    ) -> sk_sp<SkDataTable> {
        SkDataTable_MakeCopyArrays(ptrs, sizes, count)
    }
    #[inline]
    pub unsafe fn MakeCopyArray(
        array: *const ::core::ffi::c_void,
        elemSize: usize,
        count: ::core::ffi::c_int,
    ) -> sk_sp<SkDataTable> {
        SkDataTable_MakeCopyArray(array, elemSize, count)
    }
    #[inline]
    pub unsafe fn MakeArrayProc(
        array: *const ::core::ffi::c_void,
        elemSize: usize,
        count: ::core::ffi::c_int,
        proc_: SkDataTable_FreeProc,
        context: *mut ::core::ffi::c_void,
    ) -> sk_sp<SkDataTable> {
        SkDataTable_MakeArrayProc(array, elemSize, count, proc_, context)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDrawable {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDrawable_GpuDrawHandler {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDrawable_GpuDrawHandler"]
        [::core::mem::size_of::<SkDrawable_GpuDrawHandler>() - 8usize];
    ["Alignment of SkDrawable_GpuDrawHandler"]
        [::core::mem::align_of::<SkDrawable_GpuDrawHandler>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDrawable"][::core::mem::size_of::<SkDrawable>() - 16usize];
    ["Alignment of SkDrawable"][::core::mem::align_of::<SkDrawable>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable4drawEP8SkCanvasPK8SkMatrix"]
    pub fn SkDrawable_draw(this: *mut SkDrawable, arg1: *mut SkCanvas, arg2: *const SkMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable4drawEP8SkCanvasff"]
    pub fn SkDrawable_draw1(this: *mut SkDrawable, arg1: *mut SkCanvas, x: SkScalar, y: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable19makePictureSnapshotEv"]
    pub fn SkDrawable_makePictureSnapshot(this: *mut SkDrawable) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable15getGenerationIDEv"]
    pub fn SkDrawable_getGenerationID(this: *mut SkDrawable) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable9getBoundsEv"]
    pub fn SkDrawable_getBounds(this: *mut SkDrawable) -> SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable20approximateBytesUsedEv"]
    pub fn SkDrawable_approximateBytesUsed(this: *mut SkDrawable) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable20notifyDrawingChangedEv"]
    pub fn SkDrawable_notifyDrawingChanged(this: *mut SkDrawable);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawableC2Ev"]
    pub fn SkDrawable_SkDrawable(this: *mut SkDrawable);
}
impl SkDrawable {
    #[inline]
    pub unsafe fn draw(&mut self, arg1: *mut SkCanvas, arg2: *const SkMatrix) {
        SkDrawable_draw(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn draw1(&mut self, arg1: *mut SkCanvas, x: SkScalar, y: SkScalar) {
        SkDrawable_draw1(self, arg1, x, y)
    }
    #[inline]
    pub unsafe fn makePictureSnapshot(&mut self) -> sk_sp<SkPicture> {
        SkDrawable_makePictureSnapshot(self)
    }
    #[inline]
    pub unsafe fn getGenerationID(&mut self) -> u32 {
        SkDrawable_getGenerationID(self)
    }
    #[inline]
    pub unsafe fn getBounds(&mut self) -> SkRect {
        SkDrawable_getBounds(self)
    }
    #[inline]
    pub unsafe fn approximateBytesUsed(&mut self) -> usize {
        SkDrawable_approximateBytesUsed(self)
    }
    #[inline]
    pub unsafe fn notifyDrawingChanged(&mut self) {
        SkDrawable_notifyDrawingChanged(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDrawable_SkDrawable(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable22onApproximateBytesUsedEv"]
    pub fn SkDrawable_onApproximateBytesUsed(this: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDrawable21onMakePictureSnapshotEv"]
    pub fn SkDrawable_onMakePictureSnapshot(this: *mut ::core::ffi::c_void) -> sk_sp<SkPicture>;
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkDocument {
    pub _bindgen_opaque_blob: [u64; 4usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkDocument_State {
    kBetweenPages_State = 0,
    kInPage_State = 1,
    kClosed_State = 2,
}
pub type SkDocument_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDocument"][::core::mem::size_of::<SkDocument>() - 32usize];
    ["Alignment of SkDocument"][::core::mem::align_of::<SkDocument>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocument9beginPageEffPK6SkRect"]
    pub fn SkDocument_beginPage(
        this: *mut SkDocument,
        width: SkScalar,
        height: SkScalar,
        content: *const SkRect,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocument7endPageEv"]
    pub fn SkDocument_endPage(this: *mut SkDocument);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocument5closeEv"]
    pub fn SkDocument_close(this: *mut SkDocument);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocument5abortEv"]
    pub fn SkDocument_abort(this: *mut SkDocument);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocumentC2EP9SkWStream"]
    pub fn SkDocument_SkDocument(this: *mut SkDocument, arg1: *mut SkWStream);
}
impl SkDocument {
    #[inline]
    pub unsafe fn beginPage(
        &mut self,
        width: SkScalar,
        height: SkScalar,
        content: *const SkRect,
    ) -> *mut SkCanvas {
        SkDocument_beginPage(self, width, height, content)
    }
    #[inline]
    pub unsafe fn endPage(&mut self) {
        SkDocument_endPage(self)
    }
    #[inline]
    pub unsafe fn close(&mut self) {
        SkDocument_close(self)
    }
    #[inline]
    pub unsafe fn abort(&mut self) {
        SkDocument_abort(self)
    }
    #[inline]
    pub unsafe fn new(arg1: *mut SkWStream) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDocument_SkDocument(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkDocumentD1Ev"]
    pub fn SkDocument_SkDocument_destructor(this: *mut SkDocument);
}
#[repr(C)]
pub struct SkPathIter {
    pub pIndex: usize,
    pub vIndex: usize,
    pub cIndex: usize,
    pub fPoints: SkSpan<SkPoint>,
    pub fVerbs: SkSpan<SkPathVerb>,
    pub fConics: SkSpan<f32>,
    pub fClosePointStorage: __BindgenOpaqueArray<u32, 4usize>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathIter_Rec {
    pub fPoints: SkSpan<SkPoint>,
    pub fConicWeight: f32,
    pub fVerb: SkPathVerb,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathIter_Rec"][::core::mem::size_of::<SkPathIter_Rec>() - 24usize];
    ["Alignment of SkPathIter_Rec"][::core::mem::align_of::<SkPathIter_Rec>() - 8usize];
    ["Offset of field: SkPathIter_Rec::fPoints"]
        [::core::mem::offset_of!(SkPathIter_Rec, fPoints) - 0usize];
    ["Offset of field: SkPathIter_Rec::fConicWeight"]
        [::core::mem::offset_of!(SkPathIter_Rec, fConicWeight) - 16usize];
    ["Offset of field: SkPathIter_Rec::fVerb"]
        [::core::mem::offset_of!(SkPathIter_Rec, fVerb) - 20usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathIter"][::core::mem::size_of::<SkPathIter>() - 88usize];
    ["Alignment of SkPathIter"][::core::mem::align_of::<SkPathIter>() - 8usize];
    ["Offset of field: SkPathIter::pIndex"][::core::mem::offset_of!(SkPathIter, pIndex) - 0usize];
    ["Offset of field: SkPathIter::vIndex"][::core::mem::offset_of!(SkPathIter, vIndex) - 8usize];
    ["Offset of field: SkPathIter::cIndex"][::core::mem::offset_of!(SkPathIter, cIndex) - 16usize];
    ["Offset of field: SkPathIter::fPoints"]
        [::core::mem::offset_of!(SkPathIter, fPoints) - 24usize];
    ["Offset of field: SkPathIter::fVerbs"][::core::mem::offset_of!(SkPathIter, fVerbs) - 40usize];
    ["Offset of field: SkPathIter::fConics"]
        [::core::mem::offset_of!(SkPathIter, fConics) - 56usize];
    ["Offset of field: SkPathIter::fClosePointStorage"]
        [::core::mem::offset_of!(SkPathIter, fClosePointStorage) - 72usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPathIter4nextEv"]
    pub fn SkPathIter_next(this: *mut SkPathIter) -> __BindgenOpaqueArray<u64, 4usize>;
}
impl SkPathIter {
    #[inline]
    pub unsafe fn next(&mut self) -> __BindgenOpaqueArray<u64, 4usize> {
        SkPathIter_next(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathContourIter {
    pub fPoints: SkSpan<SkPoint>,
    pub fVerbs: SkSpan<SkPathVerb>,
    pub fConics: SkSpan<f32>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathContourIter_Rec {
    pub fPoints: SkSpan<SkPoint>,
    pub fVerbs: SkSpan<SkPathVerb>,
    pub fConics: SkSpan<f32>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathContourIter_Rec"][::core::mem::size_of::<SkPathContourIter_Rec>() - 48usize];
    ["Alignment of SkPathContourIter_Rec"]
        [::core::mem::align_of::<SkPathContourIter_Rec>() - 8usize];
    ["Offset of field: SkPathContourIter_Rec::fPoints"]
        [::core::mem::offset_of!(SkPathContourIter_Rec, fPoints) - 0usize];
    ["Offset of field: SkPathContourIter_Rec::fVerbs"]
        [::core::mem::offset_of!(SkPathContourIter_Rec, fVerbs) - 16usize];
    ["Offset of field: SkPathContourIter_Rec::fConics"]
        [::core::mem::offset_of!(SkPathContourIter_Rec, fConics) - 32usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathContourIter"][::core::mem::size_of::<SkPathContourIter>() - 48usize];
    ["Alignment of SkPathContourIter"][::core::mem::align_of::<SkPathContourIter>() - 8usize];
    ["Offset of field: SkPathContourIter::fPoints"]
        [::core::mem::offset_of!(SkPathContourIter, fPoints) - 0usize];
    ["Offset of field: SkPathContourIter::fVerbs"]
        [::core::mem::offset_of!(SkPathContourIter, fVerbs) - 16usize];
    ["Offset of field: SkPathContourIter::fConics"]
        [::core::mem::offset_of!(SkPathContourIter, fConics) - 32usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPathContourIter4nextEv"]
    pub fn SkPathContourIter_next(
        this: *mut SkPathContourIter,
    ) -> __BindgenOpaqueArray<u64, 7usize>;
}
impl SkPathContourIter {
    #[inline]
    pub unsafe fn next(&mut self) -> __BindgenOpaqueArray<u64, 7usize> {
        SkPathContourIter_next(self)
    }
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathConvexity {
    __bindgen_cannot_repr_c_on_empty_enum = 0,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathRaw {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct SkPath {
    pub fPathRef: sk_sp<SkPathRef>,
    pub fLastMoveToIndex: ::core::ffi::c_int,
    pub fConvexity: u8,
    pub fFirstDirection: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPath_ArcSize {
    Small = 0,
    Large = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPath_AddPathMode {
    Append = 0,
    Extend = 1,
}
pub const SkPath_SegmentMask_kLine_SegmentMask: SkPath_SegmentMask = 1;
pub const SkPath_SegmentMask_kQuad_SegmentMask: SkPath_SegmentMask = 2;
pub const SkPath_SegmentMask_kConic_SegmentMask: SkPath_SegmentMask = 4;
pub const SkPath_SegmentMask_kCubic_SegmentMask: SkPath_SegmentMask = 8;
pub type SkPath_SegmentMask = ::core::ffi::c_uint;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPath_Verb {
    Move = 0,
    Line = 1,
    Quad = 2,
    Conic = 3,
    Cubic = 4,
    Close = 5,
    Done = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPath_IterRec {
    pub fVerb: SkPathVerb,
    pub fPoints: SkSpan<SkPoint>,
    pub fConicWeight: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPath_IterRec"][::core::mem::size_of::<SkPath_IterRec>() - 32usize];
    ["Alignment of SkPath_IterRec"][::core::mem::align_of::<SkPath_IterRec>() - 8usize];
    ["Offset of field: SkPath_IterRec::fVerb"]
        [::core::mem::offset_of!(SkPath_IterRec, fVerb) - 0usize];
    ["Offset of field: SkPath_IterRec::fPoints"]
        [::core::mem::offset_of!(SkPath_IterRec, fPoints) - 8usize];
    ["Offset of field: SkPath_IterRec::fConicWeight"]
        [::core::mem::offset_of!(SkPath_IterRec, fConicWeight) - 24usize];
};
#[repr(C)]
pub struct SkPath_Iter {
    pub fPts: *const SkPoint,
    pub fVerbs: *const SkPathVerb,
    pub fVerbStop: *const SkPathVerb,
    pub fConicWeights: *const SkScalar,
    pub fMoveTo: SkPoint,
    pub fLastPt: SkPoint,
    pub fStorage: __BindgenOpaqueArray<u32, 8usize>,
    pub fForceClose: bool,
    pub fNeedClose: bool,
    pub fCloseLine: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPath_Iter"][::core::mem::size_of::<SkPath_Iter>() - 88usize];
    ["Alignment of SkPath_Iter"][::core::mem::align_of::<SkPath_Iter>() - 8usize];
    ["Offset of field: SkPath_Iter::fPts"][::core::mem::offset_of!(SkPath_Iter, fPts) - 0usize];
    ["Offset of field: SkPath_Iter::fVerbs"][::core::mem::offset_of!(SkPath_Iter, fVerbs) - 8usize];
    ["Offset of field: SkPath_Iter::fVerbStop"]
        [::core::mem::offset_of!(SkPath_Iter, fVerbStop) - 16usize];
    ["Offset of field: SkPath_Iter::fConicWeights"]
        [::core::mem::offset_of!(SkPath_Iter, fConicWeights) - 24usize];
    ["Offset of field: SkPath_Iter::fMoveTo"]
        [::core::mem::offset_of!(SkPath_Iter, fMoveTo) - 32usize];
    ["Offset of field: SkPath_Iter::fLastPt"]
        [::core::mem::offset_of!(SkPath_Iter, fLastPt) - 40usize];
    ["Offset of field: SkPath_Iter::fStorage"]
        [::core::mem::offset_of!(SkPath_Iter, fStorage) - 48usize];
    ["Offset of field: SkPath_Iter::fForceClose"]
        [::core::mem::offset_of!(SkPath_Iter, fForceClose) - 80usize];
    ["Offset of field: SkPath_Iter::fNeedClose"]
        [::core::mem::offset_of!(SkPath_Iter, fNeedClose) - 81usize];
    ["Offset of field: SkPath_Iter::fCloseLine"]
        [::core::mem::offset_of!(SkPath_Iter, fCloseLine) - 82usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4Iter7setPathERKS_b"]
    pub fn SkPath_Iter_setPath(this: *mut SkPath_Iter, path: *const SkPath, forceClose: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4Iter4nextEP7SkPoint"]
    pub fn SkPath_Iter_next(this: *mut SkPath_Iter, pts: *mut SkPoint) -> SkPath_Verb;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4Iter4nextEv"]
    pub fn SkPath_Iter_next1(this: *mut SkPath_Iter) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath4Iter15isClosedContourEv"]
    pub fn SkPath_Iter_isClosedContour(this: *const SkPath_Iter) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4IterC1Ev"]
    pub fn SkPath_Iter_Iter(this: *mut SkPath_Iter);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4IterC1ERKS_b"]
    pub fn SkPath_Iter_Iter1(this: *mut SkPath_Iter, path: *const SkPath, forceClose: bool);
}
impl SkPath_Iter {
    #[inline]
    pub unsafe fn setPath(&mut self, path: *const SkPath, forceClose: bool) {
        SkPath_Iter_setPath(self, path, forceClose)
    }
    #[inline]
    pub unsafe fn next(&mut self, pts: *mut SkPoint) -> SkPath_Verb {
        SkPath_Iter_next(self, pts)
    }
    #[inline]
    pub unsafe fn next1(&mut self) -> u8 {
        SkPath_Iter_next1(self)
    }
    #[inline]
    pub unsafe fn isClosedContour(&self) -> bool {
        SkPath_Iter_isClosedContour(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPath_Iter_Iter(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(path: *const SkPath, forceClose: bool) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPath_Iter_Iter1(__bindgen_tmp.as_mut_ptr(), path, forceClose);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPath_RangeIter {
    pub fVerb: *const SkPathVerb,
    pub fPoints: *const SkPoint,
    pub fWeights: *const SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPath_RangeIter"][::core::mem::size_of::<SkPath_RangeIter>() - 24usize];
    ["Alignment of SkPath_RangeIter"][::core::mem::align_of::<SkPath_RangeIter>() - 8usize];
    ["Offset of field: SkPath_RangeIter::fVerb"]
        [::core::mem::offset_of!(SkPath_RangeIter, fVerb) - 0usize];
    ["Offset of field: SkPath_RangeIter::fPoints"]
        [::core::mem::offset_of!(SkPath_RangeIter, fPoints) - 8usize];
    ["Offset of field: SkPath_RangeIter::fWeights"]
        [::core::mem::offset_of!(SkPath_RangeIter, fWeights) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPath_RawIter {
    pub fIter: SkPath_RangeIter,
    pub fEnd: SkPath_RangeIter,
    pub fConicWeight: SkScalar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPath_RawIter"][::core::mem::size_of::<SkPath_RawIter>() - 56usize];
    ["Alignment of SkPath_RawIter"][::core::mem::align_of::<SkPath_RawIter>() - 8usize];
    ["Offset of field: SkPath_RawIter::fIter"]
        [::core::mem::offset_of!(SkPath_RawIter, fIter) - 0usize];
    ["Offset of field: SkPath_RawIter::fEnd"]
        [::core::mem::offset_of!(SkPath_RawIter, fEnd) - 24usize];
    ["Offset of field: SkPath_RawIter::fConicWeight"]
        [::core::mem::offset_of!(SkPath_RawIter, fConicWeight) - 48usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7RawIter7setPathERKS_"]
    pub fn SkPath_RawIter_setPath(this: *mut SkPath_RawIter, arg1: *const SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7RawIter4nextEP7SkPoint"]
    pub fn SkPath_RawIter_next(this: *mut SkPath_RawIter, arg1: *mut SkPoint) -> SkPath_Verb;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7RawIter4nextEv"]
    pub fn SkPath_RawIter_next1(this: *mut SkPath_RawIter) -> u8;
}
impl SkPath_RawIter {
    #[inline]
    pub unsafe fn setPath(&mut self, arg1: *const SkPath) {
        SkPath_RawIter_setPath(self, arg1)
    }
    #[inline]
    pub unsafe fn next(&mut self, arg1: *mut SkPoint) -> SkPath_Verb {
        SkPath_RawIter_next(self, arg1)
    }
    #[inline]
    pub unsafe fn next1(&mut self) -> u8 {
        SkPath_RawIter_next1(self)
    }
}
pub type SkPath_sk_is_trivially_relocatable = std_true_type;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPath"][::core::mem::size_of::<SkPath>() - 16usize];
    ["Alignment of SkPath"][::core::mem::align_of::<SkPath>() - 8usize];
    ["Offset of field: SkPath::fPathRef"][::core::mem::offset_of!(SkPath, fPathRef) - 0usize];
    ["Offset of field: SkPath::fLastMoveToIndex"]
        [::core::mem::offset_of!(SkPath, fLastMoveToIndex) - 8usize];
    ["Offset of field: SkPath::fConvexity"][::core::mem::offset_of!(SkPath, fConvexity) - 12usize];
    ["Offset of field: SkPath::fFirstDirection"]
        [::core::mem::offset_of!(SkPath, fFirstDirection) - 13usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath3RawE6SkSpanIK7SkPointES0_IK10SkPathVerbES0_IKfE14SkPathFillTypeb"]
    pub fn SkPath_Raw(
        pts: SkSpan<SkPoint>,
        verbs: SkSpan<SkPathVerb>,
        conics: SkSpan<SkScalar>,
        arg1: SkPathFillType,
        isVolatile: bool,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4RectERK6SkRect15SkPathDirectionj"]
    pub fn SkPath_Rect(
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4OvalERK6SkRect15SkPathDirection"]
    pub fn SkPath_Oval(arg1: *const SkRect, arg2: SkPathDirection) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4OvalERK6SkRect15SkPathDirectionj"]
    pub fn SkPath_Oval1(
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6CircleEfff15SkPathDirection"]
    pub fn SkPath_Circle(
        center_x: SkScalar,
        center_y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5RRectERK7SkRRect15SkPathDirection"]
    pub fn SkPath_RRect(arg1: *const SkRRect, dir: SkPathDirection) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5RRectERK7SkRRect15SkPathDirectionj"]
    pub fn SkPath_RRect1(
        arg1: *const SkRRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5RRectERK6SkRectff15SkPathDirection"]
    pub fn SkPath_RRect2(
        bounds: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        dir: SkPathDirection,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7PolygonE6SkSpanIK7SkPointEb14SkPathFillTypeb"]
    pub fn SkPath_Polygon(
        pts: SkSpan<SkPoint>,
        isClosed: bool,
        fillType: SkPathFillType,
        isVolatile: bool,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath16isInterpolatableERKS_"]
    pub fn SkPath_isInterpolatable(this: *const SkPath, compare: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath15makeInterpolateERKS_f"]
    pub fn SkPath_makeInterpolate(
        this: *const SkPath,
        ending: *const SkPath,
        weight: SkScalar,
    ) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath12makeFillTypeE14SkPathFillType"]
    pub fn SkPath_makeFillType(this: *const SkPath, newFillType: SkPathFillType) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath25makeToggleInverseFillTypeEv"]
    pub fn SkPath_makeToggleInverseFillType(this: *const SkPath) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath8isConvexEv"]
    pub fn SkPath_isConvex(this: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath6isOvalEP6SkRect"]
    pub fn SkPath_isOval(this: *const SkPath, bounds: *mut SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath7isRRectEP7SkRRect"]
    pub fn SkPath_isRRect(this: *const SkPath, rrect: *mut SkRRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath7isEmptyEv"]
    pub fn SkPath_isEmpty(this: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath19isLastContourClosedEv"]
    pub fn SkPath_isLastContourClosed(this: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath8isFiniteEv"]
    pub fn SkPath_isFinite(this: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath14makeIsVolatileEb"]
    pub fn SkPath_makeIsVolatile(this: *const SkPath, isVolatile: bool) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath16IsLineDegenerateERK7SkPointS2_b"]
    pub fn SkPath_IsLineDegenerate(p1: *const SkPoint, p2: *const SkPoint, exact: bool) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath16IsQuadDegenerateERK7SkPointS2_S2_b"]
    pub fn SkPath_IsQuadDegenerate(
        p1: *const SkPoint,
        p2: *const SkPoint,
        p3: *const SkPoint,
        exact: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath17IsCubicDegenerateERK7SkPointS2_S2_S2_b"]
    pub fn SkPath_IsCubicDegenerate(
        p1: *const SkPoint,
        p2: *const SkPoint,
        p3: *const SkPoint,
        p4: *const SkPoint,
        exact: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath6isLineEP7SkPoint"]
    pub fn SkPath_isLine(this: *const SkPath, line: *mut SkPoint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath11countPointsEv"]
    pub fn SkPath_countPoints(this: *const SkPath) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath8getPointEi"]
    pub fn SkPath_getPoint(this: *const SkPath, index: ::core::ffi::c_int) -> SkPoint;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath9getPointsE6SkSpanI7SkPointE"]
    pub fn SkPath_getPoints(this: *const SkPath, points: SkSpan<SkPoint>) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath10countVerbsEv"]
    pub fn SkPath_countVerbs(this: *const SkPath) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath8getVerbsE6SkSpanIhE"]
    pub fn SkPath_getVerbs(this: *const SkPath, verbs: SkSpan<u8>) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath20approximateBytesUsedEv"]
    pub fn SkPath_approximateBytesUsed(this: *const SkPath) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath9getBoundsEv"]
    pub fn SkPath_getBounds(this: *const SkPath) -> *const SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath18computeTightBoundsEv"]
    pub fn SkPath_computeTightBounds(this: *const SkPath) -> SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath26conservativelyContainsRectERK6SkRect"]
    pub fn SkPath_conservativelyContainsRect(this: *const SkPath, rect: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath19ConvertConicToQuadsERK7SkPointS2_S2_fPS0_i"]
    pub fn SkPath_ConvertConicToQuads(
        p0: *const SkPoint,
        p1: *const SkPoint,
        p2: *const SkPoint,
        w: SkScalar,
        pts: *mut SkPoint,
        pow2: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath6isRectEP6SkRectPbP15SkPathDirection"]
    pub fn SkPath_isRect(
        this: *const SkPath,
        rect: *mut SkRect,
        isClosed: *mut bool,
        direction: *mut SkPathDirection,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath9getLastPtEP7SkPoint"]
    pub fn SkPath_getLastPt(this: *const SkPath, lastPt: *mut SkPoint) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath15getSegmentMasksEv"]
    pub fn SkPath_getSegmentMasks(this: *const SkPath) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath4swapERS_"]
    pub fn SkPath_swap(this: *mut SkPath, other: *mut SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath11interpolateERKS_fPS_"]
    pub fn SkPath_interpolate(
        this: *const SkPath,
        ending: *const SkPath,
        weight: SkScalar,
        out: *mut SkPath,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5resetEv"]
    pub fn SkPath_reset(this: *mut SkPath) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6rewindEv"]
    pub fn SkPath_rewind(this: *mut SkPath) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath10incReserveEiii"]
    pub fn SkPath_incReserve(
        this: *mut SkPath,
        extraPtCount: ::core::ffi::c_int,
        extraVerbCount: ::core::ffi::c_int,
        extraConicCount: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6moveToEff"]
    pub fn SkPath_moveTo(this: *mut SkPath, x: SkScalar, y: SkScalar) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7rMoveToEff"]
    pub fn SkPath_rMoveTo(this: *mut SkPath, dx: SkScalar, dy: SkScalar) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6lineToEff"]
    pub fn SkPath_lineTo(this: *mut SkPath, x: SkScalar, y: SkScalar) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7rLineToEff"]
    pub fn SkPath_rLineTo(this: *mut SkPath, dx: SkScalar, dy: SkScalar) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6quadToEffff"]
    pub fn SkPath_quadTo(
        this: *mut SkPath,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7rQuadToEffff"]
    pub fn SkPath_rQuadTo(
        this: *mut SkPath,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7conicToEfffff"]
    pub fn SkPath_conicTo(
        this: *mut SkPath,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        w: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath8rConicToEfffff"]
    pub fn SkPath_rConicTo(
        this: *mut SkPath,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
        w: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7cubicToEffffff"]
    pub fn SkPath_cubicTo(
        this: *mut SkPath,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        x3: SkScalar,
        y3: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath8rCubicToEffffff"]
    pub fn SkPath_rCubicTo(
        this: *mut SkPath,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
        dx3: SkScalar,
        dy3: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5arcToERK6SkRectffb"]
    pub fn SkPath_arcTo(
        this: *mut SkPath,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
        forceMoveTo: bool,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5arcToEfffff"]
    pub fn SkPath_arcTo1(
        this: *mut SkPath,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        radius: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5arcToEfffNS_7ArcSizeE15SkPathDirectionff"]
    pub fn SkPath_arcTo2(
        this: *mut SkPath,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPath_ArcSize,
        sweep: SkPathDirection,
        x: SkScalar,
        y: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6rArcToEfffNS_7ArcSizeE15SkPathDirectionff"]
    pub fn SkPath_rArcTo(
        this: *mut SkPath,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPath_ArcSize,
        sweep: SkPathDirection,
        dx: SkScalar,
        dy: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath5closeEv"]
    pub fn SkPath_close(this: *mut SkPath) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addRectERK6SkRect15SkPathDirectionj"]
    pub fn SkPath_addRect(
        this: *mut SkPath,
        rect: *const SkRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addOvalERK6SkRect15SkPathDirection"]
    pub fn SkPath_addOval(
        this: *mut SkPath,
        oval: *const SkRect,
        dir: SkPathDirection,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addOvalERK6SkRect15SkPathDirectionj"]
    pub fn SkPath_addOval1(
        this: *mut SkPath,
        oval: *const SkRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath9addCircleEfff15SkPathDirection"]
    pub fn SkPath_addCircle(
        this: *mut SkPath,
        x: SkScalar,
        y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath6addArcERK6SkRectff"]
    pub fn SkPath_addArc(
        this: *mut SkPath,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath12addRoundRectERK6SkRectff15SkPathDirection"]
    pub fn SkPath_addRoundRect(
        this: *mut SkPath,
        rect: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath12addRoundRectERK6SkRect6SkSpanIKfE15SkPathDirection"]
    pub fn SkPath_addRoundRect1(
        this: *mut SkPath,
        rect: *const SkRect,
        radii: SkSpan<SkScalar>,
        dir: SkPathDirection,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath8addRRectERK7SkRRect15SkPathDirection"]
    pub fn SkPath_addRRect(
        this: *mut SkPath,
        rrect: *const SkRRect,
        dir: SkPathDirection,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath8addRRectERK7SkRRect15SkPathDirectionj"]
    pub fn SkPath_addRRect1(
        this: *mut SkPath,
        rrect: *const SkRRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addPolyE6SkSpanIK7SkPointEb"]
    pub fn SkPath_addPoly(this: *mut SkPath, pts: SkSpan<SkPoint>, close: bool) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addPathERKS_ffNS_11AddPathModeE"]
    pub fn SkPath_addPath(
        this: *mut SkPath,
        src: *const SkPath,
        dx: SkScalar,
        dy: SkScalar,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath7addPathERKS_RK8SkMatrixNS_11AddPathModeE"]
    pub fn SkPath_addPath1(
        this: *mut SkPath,
        src: *const SkPath,
        matrix: *const SkMatrix,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath14reverseAddPathERKS_"]
    pub fn SkPath_reverseAddPath(this: *mut SkPath, src: *const SkPath) -> *mut SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath6offsetEffPS_"]
    pub fn SkPath_offset(this: *const SkPath, dx: SkScalar, dy: SkScalar, dst: *mut SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath9transformERK8SkMatrixPS_"]
    pub fn SkPath_transform(this: *const SkPath, matrix: *const SkMatrix, dst: *mut SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath9setLastPtEff"]
    pub fn SkPath_setLastPt(this: *mut SkPath, x: SkScalar, y: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath4iterEv"]
    pub fn SkPath_iter(this: *const SkPath) -> SkPathIter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath8containsEff"]
    pub fn SkPath_contains(this: *const SkPath, x: SkScalar, y: SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath4dumpEP9SkWStreamb"]
    pub fn SkPath_dump(this: *const SkPath, stream: *mut SkWStream, dumpAsHex: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath10dumpArraysEP9SkWStreamb"]
    pub fn SkPath_dumpArrays(this: *const SkPath, stream: *mut SkWStream, dumpAsHex: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath13writeToMemoryEPv"]
    pub fn SkPath_writeToMemory(this: *const SkPath, buffer: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath9serializeEv"]
    pub fn SkPath_serialize(this: *const SkPath) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath14ReadFromMemoryEPKvmPm"]
    pub fn SkPath_ReadFromMemory(
        buffer: *const ::core::ffi::c_void,
        length: usize,
        bytesRead: *mut usize,
    ) -> __BindgenOpaqueArray<u64, 3usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPath14readFromMemoryEPKvm"]
    pub fn SkPath_readFromMemory(
        this: *mut SkPath,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath15getGenerationIDEv"]
    pub fn SkPath_getGenerationID(this: *const SkPath) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkPath7isValidEv"]
    pub fn SkPath_isValid(this: *const SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPathC1Ev"]
    pub fn SkPath_SkPath(this: *mut SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPathC1ERKS_"]
    pub fn SkPath_SkPath1(this: *mut SkPath, path: *const SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkPathD1Ev"]
    pub fn SkPath_SkPath_destructor(this: *mut SkPath);
}
impl SkPath {
    #[inline]
    pub fn fFillType(&self) -> u8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u8) }
    }
    #[inline]
    pub fn set_fFillType(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fFillType_raw(this: *const Self) -> u8 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fFillType_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fIsVolatile(&self) -> u8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fIsVolatile(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fIsVolatile_raw(this: *const Self) -> u8 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fIsVolatile_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(fFillType: u8, fIsVolatile: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let fFillType: u8 = unsafe { ::core::mem::transmute(fFillType) };
            fFillType as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fIsVolatile: u8 = unsafe { ::core::mem::transmute(fIsVolatile) };
            fIsVolatile as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub unsafe fn Raw(
        pts: SkSpan<SkPoint>,
        verbs: SkSpan<SkPathVerb>,
        conics: SkSpan<SkScalar>,
        arg1: SkPathFillType,
        isVolatile: bool,
    ) -> SkPath {
        SkPath_Raw(pts, verbs, conics, arg1, isVolatile)
    }
    #[inline]
    pub unsafe fn Rect(
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath {
        SkPath_Rect(arg1, arg2, startIndex)
    }
    #[inline]
    pub unsafe fn Oval(arg1: *const SkRect, arg2: SkPathDirection) -> SkPath {
        SkPath_Oval(arg1, arg2)
    }
    #[inline]
    pub unsafe fn Oval1(
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath {
        SkPath_Oval1(arg1, arg2, startIndex)
    }
    #[inline]
    pub unsafe fn Circle(
        center_x: SkScalar,
        center_y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> SkPath {
        SkPath_Circle(center_x, center_y, radius, dir)
    }
    #[inline]
    pub unsafe fn RRect(arg1: *const SkRRect, dir: SkPathDirection) -> SkPath {
        SkPath_RRect(arg1, dir)
    }
    #[inline]
    pub unsafe fn RRect1(
        arg1: *const SkRRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> SkPath {
        SkPath_RRect1(arg1, arg2, startIndex)
    }
    #[inline]
    pub unsafe fn RRect2(
        bounds: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        dir: SkPathDirection,
    ) -> SkPath {
        SkPath_RRect2(bounds, rx, ry, dir)
    }
    #[inline]
    pub unsafe fn Polygon(
        pts: SkSpan<SkPoint>,
        isClosed: bool,
        fillType: SkPathFillType,
        isVolatile: bool,
    ) -> SkPath {
        SkPath_Polygon(pts, isClosed, fillType, isVolatile)
    }
    #[inline]
    pub unsafe fn isInterpolatable(&self, compare: *const SkPath) -> bool {
        SkPath_isInterpolatable(self, compare)
    }
    #[inline]
    pub unsafe fn makeInterpolate(&self, ending: *const SkPath, weight: SkScalar) -> SkPath {
        SkPath_makeInterpolate(self, ending, weight)
    }
    #[inline]
    pub unsafe fn makeFillType(&self, newFillType: SkPathFillType) -> SkPath {
        SkPath_makeFillType(self, newFillType)
    }
    #[inline]
    pub unsafe fn makeToggleInverseFillType(&self) -> SkPath {
        SkPath_makeToggleInverseFillType(self)
    }
    #[inline]
    pub unsafe fn isConvex(&self) -> bool {
        SkPath_isConvex(self)
    }
    #[inline]
    pub unsafe fn isOval(&self, bounds: *mut SkRect) -> bool {
        SkPath_isOval(self, bounds)
    }
    #[inline]
    pub unsafe fn isRRect(&self, rrect: *mut SkRRect) -> bool {
        SkPath_isRRect(self, rrect)
    }
    #[inline]
    pub unsafe fn isEmpty(&self) -> bool {
        SkPath_isEmpty(self)
    }
    #[inline]
    pub unsafe fn isLastContourClosed(&self) -> bool {
        SkPath_isLastContourClosed(self)
    }
    #[inline]
    pub unsafe fn isFinite(&self) -> bool {
        SkPath_isFinite(self)
    }
    #[inline]
    pub unsafe fn makeIsVolatile(&self, isVolatile: bool) -> SkPath {
        SkPath_makeIsVolatile(self, isVolatile)
    }
    #[inline]
    pub unsafe fn IsLineDegenerate(p1: *const SkPoint, p2: *const SkPoint, exact: bool) -> bool {
        SkPath_IsLineDegenerate(p1, p2, exact)
    }
    #[inline]
    pub unsafe fn IsQuadDegenerate(
        p1: *const SkPoint,
        p2: *const SkPoint,
        p3: *const SkPoint,
        exact: bool,
    ) -> bool {
        SkPath_IsQuadDegenerate(p1, p2, p3, exact)
    }
    #[inline]
    pub unsafe fn IsCubicDegenerate(
        p1: *const SkPoint,
        p2: *const SkPoint,
        p3: *const SkPoint,
        p4: *const SkPoint,
        exact: bool,
    ) -> bool {
        SkPath_IsCubicDegenerate(p1, p2, p3, p4, exact)
    }
    #[inline]
    pub unsafe fn isLine(&self, line: *mut SkPoint) -> bool {
        SkPath_isLine(self, line)
    }
    #[inline]
    pub unsafe fn countPoints(&self) -> ::core::ffi::c_int {
        SkPath_countPoints(self)
    }
    #[inline]
    pub unsafe fn getPoint(&self, index: ::core::ffi::c_int) -> SkPoint {
        SkPath_getPoint(self, index)
    }
    #[inline]
    pub unsafe fn getPoints(&self, points: SkSpan<SkPoint>) -> usize {
        SkPath_getPoints(self, points)
    }
    #[inline]
    pub unsafe fn countVerbs(&self) -> ::core::ffi::c_int {
        SkPath_countVerbs(self)
    }
    #[inline]
    pub unsafe fn getVerbs(&self, verbs: SkSpan<u8>) -> usize {
        SkPath_getVerbs(self, verbs)
    }
    #[inline]
    pub unsafe fn approximateBytesUsed(&self) -> usize {
        SkPath_approximateBytesUsed(self)
    }
    #[inline]
    pub unsafe fn getBounds(&self) -> *const SkRect {
        SkPath_getBounds(self)
    }
    #[inline]
    pub unsafe fn computeTightBounds(&self) -> SkRect {
        SkPath_computeTightBounds(self)
    }
    #[inline]
    pub unsafe fn conservativelyContainsRect(&self, rect: *const SkRect) -> bool {
        SkPath_conservativelyContainsRect(self, rect)
    }
    #[inline]
    pub unsafe fn ConvertConicToQuads(
        p0: *const SkPoint,
        p1: *const SkPoint,
        p2: *const SkPoint,
        w: SkScalar,
        pts: *mut SkPoint,
        pow2: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int {
        SkPath_ConvertConicToQuads(p0, p1, p2, w, pts, pow2)
    }
    #[inline]
    pub unsafe fn isRect(
        &self,
        rect: *mut SkRect,
        isClosed: *mut bool,
        direction: *mut SkPathDirection,
    ) -> bool {
        SkPath_isRect(self, rect, isClosed, direction)
    }
    #[inline]
    pub unsafe fn getLastPt(&self, lastPt: *mut SkPoint) -> bool {
        SkPath_getLastPt(self, lastPt)
    }
    #[inline]
    pub unsafe fn getSegmentMasks(&self) -> u32 {
        SkPath_getSegmentMasks(self)
    }
    #[inline]
    pub unsafe fn swap(&mut self, other: *mut SkPath) {
        SkPath_swap(self, other)
    }
    #[inline]
    pub unsafe fn interpolate(
        &self,
        ending: *const SkPath,
        weight: SkScalar,
        out: *mut SkPath,
    ) -> bool {
        SkPath_interpolate(self, ending, weight, out)
    }
    #[inline]
    pub unsafe fn reset(&mut self) -> *mut SkPath {
        SkPath_reset(self)
    }
    #[inline]
    pub unsafe fn rewind(&mut self) -> *mut SkPath {
        SkPath_rewind(self)
    }
    #[inline]
    pub unsafe fn incReserve(
        &mut self,
        extraPtCount: ::core::ffi::c_int,
        extraVerbCount: ::core::ffi::c_int,
        extraConicCount: ::core::ffi::c_int,
    ) {
        SkPath_incReserve(self, extraPtCount, extraVerbCount, extraConicCount)
    }
    #[inline]
    pub unsafe fn moveTo(&mut self, x: SkScalar, y: SkScalar) -> *mut SkPath {
        SkPath_moveTo(self, x, y)
    }
    #[inline]
    pub unsafe fn rMoveTo(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkPath {
        SkPath_rMoveTo(self, dx, dy)
    }
    #[inline]
    pub unsafe fn lineTo(&mut self, x: SkScalar, y: SkScalar) -> *mut SkPath {
        SkPath_lineTo(self, x, y)
    }
    #[inline]
    pub unsafe fn rLineTo(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkPath {
        SkPath_rLineTo(self, dx, dy)
    }
    #[inline]
    pub unsafe fn quadTo(
        &mut self,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
    ) -> *mut SkPath {
        SkPath_quadTo(self, x1, y1, x2, y2)
    }
    #[inline]
    pub unsafe fn rQuadTo(
        &mut self,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
    ) -> *mut SkPath {
        SkPath_rQuadTo(self, dx1, dy1, dx2, dy2)
    }
    #[inline]
    pub unsafe fn conicTo(
        &mut self,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        w: SkScalar,
    ) -> *mut SkPath {
        SkPath_conicTo(self, x1, y1, x2, y2, w)
    }
    #[inline]
    pub unsafe fn rConicTo(
        &mut self,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
        w: SkScalar,
    ) -> *mut SkPath {
        SkPath_rConicTo(self, dx1, dy1, dx2, dy2, w)
    }
    #[inline]
    pub unsafe fn cubicTo(
        &mut self,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        x3: SkScalar,
        y3: SkScalar,
    ) -> *mut SkPath {
        SkPath_cubicTo(self, x1, y1, x2, y2, x3, y3)
    }
    #[inline]
    pub unsafe fn rCubicTo(
        &mut self,
        dx1: SkScalar,
        dy1: SkScalar,
        dx2: SkScalar,
        dy2: SkScalar,
        dx3: SkScalar,
        dy3: SkScalar,
    ) -> *mut SkPath {
        SkPath_rCubicTo(self, dx1, dy1, dx2, dy2, dx3, dy3)
    }
    #[inline]
    pub unsafe fn arcTo(
        &mut self,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
        forceMoveTo: bool,
    ) -> *mut SkPath {
        SkPath_arcTo(self, oval, startAngle, sweepAngle, forceMoveTo)
    }
    #[inline]
    pub unsafe fn arcTo1(
        &mut self,
        x1: SkScalar,
        y1: SkScalar,
        x2: SkScalar,
        y2: SkScalar,
        radius: SkScalar,
    ) -> *mut SkPath {
        SkPath_arcTo1(self, x1, y1, x2, y2, radius)
    }
    #[inline]
    pub unsafe fn arcTo2(
        &mut self,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPath_ArcSize,
        sweep: SkPathDirection,
        x: SkScalar,
        y: SkScalar,
    ) -> *mut SkPath {
        SkPath_arcTo2(self, rx, ry, xAxisRotate, largeArc, sweep, x, y)
    }
    #[inline]
    pub unsafe fn rArcTo(
        &mut self,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPath_ArcSize,
        sweep: SkPathDirection,
        dx: SkScalar,
        dy: SkScalar,
    ) -> *mut SkPath {
        SkPath_rArcTo(self, rx, ry, xAxisRotate, largeArc, sweep, dx, dy)
    }
    #[inline]
    pub unsafe fn close(&mut self) -> *mut SkPath {
        SkPath_close(self)
    }
    #[inline]
    pub unsafe fn addRect(
        &mut self,
        rect: *const SkRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath {
        SkPath_addRect(self, rect, dir, start)
    }
    #[inline]
    pub unsafe fn addOval(&mut self, oval: *const SkRect, dir: SkPathDirection) -> *mut SkPath {
        SkPath_addOval(self, oval, dir)
    }
    #[inline]
    pub unsafe fn addOval1(
        &mut self,
        oval: *const SkRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath {
        SkPath_addOval1(self, oval, dir, start)
    }
    #[inline]
    pub unsafe fn addCircle(
        &mut self,
        x: SkScalar,
        y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPath {
        SkPath_addCircle(self, x, y, radius, dir)
    }
    #[inline]
    pub unsafe fn addArc(
        &mut self,
        oval: *const SkRect,
        startAngle: SkScalar,
        sweepAngle: SkScalar,
    ) -> *mut SkPath {
        SkPath_addArc(self, oval, startAngle, sweepAngle)
    }
    #[inline]
    pub unsafe fn addRoundRect(
        &mut self,
        rect: *const SkRect,
        rx: SkScalar,
        ry: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPath {
        SkPath_addRoundRect(self, rect, rx, ry, dir)
    }
    #[inline]
    pub unsafe fn addRoundRect1(
        &mut self,
        rect: *const SkRect,
        radii: SkSpan<SkScalar>,
        dir: SkPathDirection,
    ) -> *mut SkPath {
        SkPath_addRoundRect1(self, rect, radii, dir)
    }
    #[inline]
    pub unsafe fn addRRect(&mut self, rrect: *const SkRRect, dir: SkPathDirection) -> *mut SkPath {
        SkPath_addRRect(self, rrect, dir)
    }
    #[inline]
    pub unsafe fn addRRect1(
        &mut self,
        rrect: *const SkRRect,
        dir: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPath {
        SkPath_addRRect1(self, rrect, dir, start)
    }
    #[inline]
    pub unsafe fn addPoly(&mut self, pts: SkSpan<SkPoint>, close: bool) -> *mut SkPath {
        SkPath_addPoly(self, pts, close)
    }
    #[inline]
    pub unsafe fn addPath(
        &mut self,
        src: *const SkPath,
        dx: SkScalar,
        dy: SkScalar,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPath {
        SkPath_addPath(self, src, dx, dy, mode)
    }
    #[inline]
    pub unsafe fn addPath1(
        &mut self,
        src: *const SkPath,
        matrix: *const SkMatrix,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPath {
        SkPath_addPath1(self, src, matrix, mode)
    }
    #[inline]
    pub unsafe fn reverseAddPath(&mut self, src: *const SkPath) -> *mut SkPath {
        SkPath_reverseAddPath(self, src)
    }
    #[inline]
    pub unsafe fn offset(&self, dx: SkScalar, dy: SkScalar, dst: *mut SkPath) {
        SkPath_offset(self, dx, dy, dst)
    }
    #[inline]
    pub unsafe fn transform(&self, matrix: *const SkMatrix, dst: *mut SkPath) {
        SkPath_transform(self, matrix, dst)
    }
    #[inline]
    pub unsafe fn setLastPt(&mut self, x: SkScalar, y: SkScalar) {
        SkPath_setLastPt(self, x, y)
    }
    #[inline]
    pub unsafe fn iter(&self) -> SkPathIter {
        SkPath_iter(self)
    }
    #[inline]
    pub unsafe fn contains(&self, x: SkScalar, y: SkScalar) -> bool {
        SkPath_contains(self, x, y)
    }
    #[inline]
    pub unsafe fn dump(&self, stream: *mut SkWStream, dumpAsHex: bool) {
        SkPath_dump(self, stream, dumpAsHex)
    }
    #[inline]
    pub unsafe fn dumpArrays(&self, stream: *mut SkWStream, dumpAsHex: bool) {
        SkPath_dumpArrays(self, stream, dumpAsHex)
    }
    #[inline]
    pub unsafe fn writeToMemory(&self, buffer: *mut ::core::ffi::c_void) -> usize {
        SkPath_writeToMemory(self, buffer)
    }
    #[inline]
    pub unsafe fn serialize(&self) -> sk_sp<SkData> {
        SkPath_serialize(self)
    }
    #[inline]
    pub unsafe fn ReadFromMemory(
        buffer: *const ::core::ffi::c_void,
        length: usize,
        bytesRead: *mut usize,
    ) -> __BindgenOpaqueArray<u64, 3usize> {
        SkPath_ReadFromMemory(buffer, length, bytesRead)
    }
    #[inline]
    pub unsafe fn readFromMemory(
        &mut self,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize {
        SkPath_readFromMemory(self, buffer, length)
    }
    #[inline]
    pub unsafe fn getGenerationID(&self) -> u32 {
        SkPath_getGenerationID(self)
    }
    #[inline]
    pub unsafe fn isValid(&self) -> bool {
        SkPath_isValid(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPath_SkPath(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(path: *const SkPath) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPath_SkPath1(__bindgen_tmp.as_mut_ptr(), path);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPath_SkPath_destructor(self)
    }
}
pub type SkFourByteTag = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontArguments {
    pub fCollectionIndex: ::core::ffi::c_int,
    pub fVariationDesignPosition: SkFontArguments_VariationPosition,
    pub fPalette: SkFontArguments_Palette,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontArguments_VariationPosition {
    pub coordinates: *const SkFontArguments_VariationPosition_Coordinate,
    pub coordinateCount: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontArguments_VariationPosition_Coordinate {
    pub axis: SkFourByteTag,
    pub value: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontArguments_VariationPosition_Coordinate"]
        [::core::mem::size_of::<SkFontArguments_VariationPosition_Coordinate>() - 8usize];
    ["Alignment of SkFontArguments_VariationPosition_Coordinate"]
        [::core::mem::align_of::<SkFontArguments_VariationPosition_Coordinate>() - 4usize];
    ["Offset of field: SkFontArguments_VariationPosition_Coordinate::axis"]
        [::core::mem::offset_of!(SkFontArguments_VariationPosition_Coordinate, axis) - 0usize];
    ["Offset of field: SkFontArguments_VariationPosition_Coordinate::value"]
        [::core::mem::offset_of!(SkFontArguments_VariationPosition_Coordinate, value) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontArguments_VariationPosition"]
        [::core::mem::size_of::<SkFontArguments_VariationPosition>() - 16usize];
    ["Alignment of SkFontArguments_VariationPosition"]
        [::core::mem::align_of::<SkFontArguments_VariationPosition>() - 8usize];
    ["Offset of field: SkFontArguments_VariationPosition::coordinates"]
        [::core::mem::offset_of!(SkFontArguments_VariationPosition, coordinates) - 0usize];
    ["Offset of field: SkFontArguments_VariationPosition::coordinateCount"]
        [::core::mem::offset_of!(SkFontArguments_VariationPosition, coordinateCount) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontArguments_Palette {
    pub index: ::core::ffi::c_int,
    pub overrides: *const SkFontArguments_Palette_Override,
    pub overrideCount: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontArguments_Palette_Override {
    pub index: u16,
    pub color: SkColor,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontArguments_Palette_Override"]
        [::core::mem::size_of::<SkFontArguments_Palette_Override>() - 8usize];
    ["Alignment of SkFontArguments_Palette_Override"]
        [::core::mem::align_of::<SkFontArguments_Palette_Override>() - 4usize];
    ["Offset of field: SkFontArguments_Palette_Override::index"]
        [::core::mem::offset_of!(SkFontArguments_Palette_Override, index) - 0usize];
    ["Offset of field: SkFontArguments_Palette_Override::color"]
        [::core::mem::offset_of!(SkFontArguments_Palette_Override, color) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontArguments_Palette"]
        [::core::mem::size_of::<SkFontArguments_Palette>() - 24usize];
    ["Alignment of SkFontArguments_Palette"]
        [::core::mem::align_of::<SkFontArguments_Palette>() - 8usize];
    ["Offset of field: SkFontArguments_Palette::index"]
        [::core::mem::offset_of!(SkFontArguments_Palette, index) - 0usize];
    ["Offset of field: SkFontArguments_Palette::overrides"]
        [::core::mem::offset_of!(SkFontArguments_Palette, overrides) - 8usize];
    ["Offset of field: SkFontArguments_Palette::overrideCount"]
        [::core::mem::offset_of!(SkFontArguments_Palette, overrideCount) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontArguments"][::core::mem::size_of::<SkFontArguments>() - 48usize];
    ["Alignment of SkFontArguments"][::core::mem::align_of::<SkFontArguments>() - 8usize];
    ["Offset of field: SkFontArguments::fCollectionIndex"]
        [::core::mem::offset_of!(SkFontArguments, fCollectionIndex) - 0usize];
    ["Offset of field: SkFontArguments::fVariationDesignPosition"]
        [::core::mem::offset_of!(SkFontArguments, fVariationDesignPosition) - 8usize];
    ["Offset of field: SkFontArguments::fPalette"]
        [::core::mem::offset_of!(SkFontArguments, fPalette) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontParameters_Variation_Axis {
    pub tag: SkFourByteTag,
    pub min: f32,
    pub def: f32,
    pub max: f32,
    pub flags: u16,
}
pub const SkFontParameters_Variation_Axis_HIDDEN: u16 = 1;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontParameters_Variation_Axis"]
        [::core::mem::size_of::<SkFontParameters_Variation_Axis>() - 20usize];
    ["Alignment of SkFontParameters_Variation_Axis"]
        [::core::mem::align_of::<SkFontParameters_Variation_Axis>() - 4usize];
    ["Offset of field: SkFontParameters_Variation_Axis::tag"]
        [::core::mem::offset_of!(SkFontParameters_Variation_Axis, tag) - 0usize];
    ["Offset of field: SkFontParameters_Variation_Axis::min"]
        [::core::mem::offset_of!(SkFontParameters_Variation_Axis, min) - 4usize];
    ["Offset of field: SkFontParameters_Variation_Axis::def"]
        [::core::mem::offset_of!(SkFontParameters_Variation_Axis, def) - 8usize];
    ["Offset of field: SkFontParameters_Variation_Axis::max"]
        [::core::mem::offset_of!(SkFontParameters_Variation_Axis, max) - 12usize];
    ["Offset of field: SkFontParameters_Variation_Axis::flags"]
        [::core::mem::offset_of!(SkFontParameters_Variation_Axis, flags) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontStyle {
    pub fValue: i32,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFontStyle_Weight {
    kInvisible_Weight = 0,
    kThin_Weight = 100,
    kExtraLight_Weight = 200,
    kLight_Weight = 300,
    kNormal_Weight = 400,
    kMedium_Weight = 500,
    kSemiBold_Weight = 600,
    kBold_Weight = 700,
    kExtraBold_Weight = 800,
    kBlack_Weight = 900,
    kExtraBlack_Weight = 1000,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFontStyle_Width {
    kUltraCondensed_Width = 1,
    kExtraCondensed_Width = 2,
    kCondensed_Width = 3,
    kSemiCondensed_Width = 4,
    kNormal_Width = 5,
    kSemiExpanded_Width = 6,
    kExpanded_Width = 7,
    kExtraExpanded_Width = 8,
    kUltraExpanded_Width = 9,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFontStyle_Slant {
    Upright = 0,
    Italic = 1,
    Oblique = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontStyle"][::core::mem::size_of::<SkFontStyle>() - 4usize];
    ["Alignment of SkFontStyle"][::core::mem::align_of::<SkFontStyle>() - 4usize];
    ["Offset of field: SkFontStyle::fValue"][::core::mem::offset_of!(SkFontStyle, fValue) - 0usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkWeakRefCnt {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
pub type SkWeakRefCnt_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkWeakRefCnt"][::core::mem::size_of::<SkWeakRefCnt>() - 16usize];
    ["Alignment of SkWeakRefCnt"][::core::mem::align_of::<SkWeakRefCnt>() - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDescriptor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontDescriptor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkScalerContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkAdvancedTypefaceMetrics {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkScalerContextEffects {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkScalerContextRec {
    _unused: [u8; 0],
}
pub type SkTypefaceID = u32;
pub type SkFontTableTag = u32;
#[repr(C)]
#[derive(Debug)]
pub struct SkTypeface {
    pub _base: SkWeakRefCnt,
    pub fUniqueID: SkTypefaceID,
    pub fStyle: SkFontStyle,
    pub fBounds: SkRect,
    pub fBoundsOnce: SkOnce,
    pub fIsFixedPitch: bool,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTypeface_SerializeBehavior {
    DoIncludeData = 0,
    DontIncludeData = 1,
    IncludeDataIfLocal = 2,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkTypeface_LocalizedString {
    pub fString: SkString,
    pub fLanguage: SkString,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTypeface_LocalizedString"]
        [::core::mem::size_of::<SkTypeface_LocalizedString>() - 16usize];
    ["Alignment of SkTypeface_LocalizedString"]
        [::core::mem::align_of::<SkTypeface_LocalizedString>() - 8usize];
    ["Offset of field: SkTypeface_LocalizedString::fString"]
        [::core::mem::offset_of!(SkTypeface_LocalizedString, fString) - 0usize];
    ["Offset of field: SkTypeface_LocalizedString::fLanguage"]
        [::core::mem::offset_of!(SkTypeface_LocalizedString, fLanguage) - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkTypeface_LocalizedStrings {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTypeface_LocalizedStrings"]
        [::core::mem::size_of::<SkTypeface_LocalizedStrings>() - 8usize];
    ["Alignment of SkTypeface_LocalizedStrings"]
        [::core::mem::align_of::<SkTypeface_LocalizedStrings>() - 8usize];
};
pub type SkTypeface_FactoryId = SkFourByteTag;
pub const SkTypeface_MAX_REASONABLE_TABLE_COUNT: SkTypeface__bindgen_ty_1 =
    SkTypeface__bindgen_ty_1::MAX_REASONABLE_TABLE_COUNT;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTypeface__bindgen_ty_1 {
    MAX_REASONABLE_TABLE_COUNT = 65535,
}
pub type SkTypeface_INHERITED = SkWeakRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTypeface"][::core::mem::size_of::<SkTypeface>() - 48usize];
    ["Alignment of SkTypeface"][::core::mem::align_of::<SkTypeface>() - 8usize];
    ["Offset of field: SkTypeface::fUniqueID"]
        [::core::mem::offset_of!(SkTypeface, fUniqueID) - 16usize];
    ["Offset of field: SkTypeface::fStyle"][::core::mem::offset_of!(SkTypeface, fStyle) - 20usize];
    ["Offset of field: SkTypeface::fBounds"]
        [::core::mem::offset_of!(SkTypeface, fBounds) - 24usize];
    ["Offset of field: SkTypeface::fBoundsOnce"]
        [::core::mem::offset_of!(SkTypeface, fBoundsOnce) - 40usize];
    ["Offset of field: SkTypeface::fIsFixedPitch"]
        [::core::mem::offset_of!(SkTypeface, fIsFixedPitch) - 41usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface9fontStyleEv"]
    pub fn SkTypeface_fontStyle(this: *const SkTypeface) -> SkFontStyle;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface6isBoldEv"]
    pub fn SkTypeface_isBold(this: *const SkTypeface) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface8isItalicEv"]
    pub fn SkTypeface_isItalic(this: *const SkTypeface) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface12isFixedPitchEv"]
    pub fn SkTypeface_isFixedPitch(this: *const SkTypeface) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface26getVariationDesignPositionE6SkSpanIN15SkFontArguments17VariationPosition10CoordinateEE"]
    pub fn SkTypeface_getVariationDesignPosition(
        this: *const SkTypeface,
        coordinates: SkSpan<SkFontArguments_VariationPosition_Coordinate>,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface28getVariationDesignParametersE6SkSpanIN16SkFontParameters9Variation4AxisEE"]
    pub fn SkTypeface_getVariationDesignParameters(
        this: *const SkTypeface,
        parameters: SkSpan<SkFontParameters_Variation_Axis>,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypeface5EqualEPKS_S1_"]
    pub fn SkTypeface_Equal(facea: *const SkTypeface, faceb: *const SkTypeface) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypeface9MakeEmptyEv"]
    pub fn SkTypeface_MakeEmpty() -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface9makeCloneERK15SkFontArguments"]
    pub fn SkTypeface_makeClone(
        this: *const SkTypeface,
        arg1: *const SkFontArguments,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface9serializeEP9SkWStreamNS_17SerializeBehaviorE"]
    pub fn SkTypeface_serialize(
        this: *const SkTypeface,
        arg1: *mut SkWStream,
        arg2: SkTypeface_SerializeBehavior,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface9serializeENS_17SerializeBehaviorE"]
    pub fn SkTypeface_serialize1(
        this: *const SkTypeface,
        arg1: SkTypeface_SerializeBehavior,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypeface15MakeDeserializeEP8SkStream5sk_spI9SkFontMgrE"]
    pub fn SkTypeface_MakeDeserialize(
        arg1: *mut SkStream,
        lastResortMgr: sk_sp<SkFontMgr>,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface16unicharsToGlyphsE6SkSpanIKiES0_ItE"]
    pub fn SkTypeface_unicharsToGlyphs(
        this: *const SkTypeface,
        unis: SkSpan<SkUnichar>,
        glyphs: SkSpan<SkGlyphID>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface12textToGlyphsEPKvm14SkTextEncoding6SkSpanItE"]
    pub fn SkTypeface_textToGlyphs(
        this: *const SkTypeface,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: SkSpan<SkGlyphID>,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface14unicharToGlyphEi"]
    pub fn SkTypeface_unicharToGlyph(this: *const SkTypeface, unichar: SkUnichar) -> SkGlyphID;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface11countGlyphsEv"]
    pub fn SkTypeface_countGlyphs(this: *const SkTypeface) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface11countTablesEv"]
    pub fn SkTypeface_countTables(this: *const SkTypeface) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface13readTableTagsE6SkSpanIjE"]
    pub fn SkTypeface_readTableTags(
        this: *const SkTypeface,
        tags: SkSpan<SkFontTableTag>,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface12getTableSizeEj"]
    pub fn SkTypeface_getTableSize(this: *const SkTypeface, arg1: SkFontTableTag) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface12getTableDataEjmmPv"]
    pub fn SkTypeface_getTableData(
        this: *const SkTypeface,
        tag: SkFontTableTag,
        offset: usize,
        length: usize,
        data: *mut ::core::ffi::c_void,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface13copyTableDataEj"]
    pub fn SkTypeface_copyTableData(this: *const SkTypeface, tag: SkFontTableTag) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface13getUnitsPerEmEv"]
    pub fn SkTypeface_getUnitsPerEm(this: *const SkTypeface) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface25getKerningPairAdjustmentsE6SkSpanIKtES0_IiE"]
    pub fn SkTypeface_getKerningPairAdjustments(
        this: *const SkTypeface,
        glyphs: SkSpan<SkGlyphID>,
        adjustments: SkSpan<i32>,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface24createFamilyNameIteratorEv"]
    pub fn SkTypeface_createFamilyNameIterator(
        this: *const SkTypeface,
    ) -> *mut SkTypeface_LocalizedStrings;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface13getFamilyNameEP8SkString"]
    pub fn SkTypeface_getFamilyName(this: *const SkTypeface, name: *mut SkString);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface17getPostScriptNameEP8SkString"]
    pub fn SkTypeface_getPostScriptName(this: *const SkTypeface, name: *mut SkString) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface15getResourceNameEP8SkString"]
    pub fn SkTypeface_getResourceName(
        this: *const SkTypeface,
        resourceName: *mut SkString,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface10openStreamEPi"]
    pub fn SkTypeface_openStream(this: *const SkTypeface, ttcIndex: *mut ::core::ffi::c_int)
    -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface18openExistingStreamEPi"]
    pub fn SkTypeface_openExistingStream(
        this: *const SkTypeface,
        ttcIndex: *mut ::core::ffi::c_int,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface19createScalerContextERK22SkScalerContextEffectsPK12SkDescriptor"]
    pub fn SkTypeface_createScalerContext(
        this: *const SkTypeface,
        arg1: *const SkScalerContextEffects,
        arg2: *const SkDescriptor,
    ) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface9getBoundsEv"]
    pub fn SkTypeface_getBounds(this: *const SkTypeface) -> SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypeface8RegisterEjPF5sk_spIS_ESt10unique_ptrI13SkStreamAssetSt14default_deleteIS3_EERK15SkFontArgumentsE"]
    pub fn SkTypeface_Register(
        id: SkTypeface_FactoryId,
        make: ::core::option::Option<
            unsafe extern "C" fn(arg1: u64, arg2: *const SkFontArguments) -> sk_sp<SkTypeface>,
        >,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypefaceC2ERK11SkFontStyleb"]
    pub fn SkTypeface_SkTypeface(
        this: *mut SkTypeface,
        style: *const SkFontStyle,
        isFixedPitch: bool,
    );
}
impl SkTypeface {
    #[inline]
    pub unsafe fn fontStyle(&self) -> SkFontStyle {
        SkTypeface_fontStyle(self)
    }
    #[inline]
    pub unsafe fn isBold(&self) -> bool {
        SkTypeface_isBold(self)
    }
    #[inline]
    pub unsafe fn isItalic(&self) -> bool {
        SkTypeface_isItalic(self)
    }
    #[inline]
    pub unsafe fn isFixedPitch(&self) -> bool {
        SkTypeface_isFixedPitch(self)
    }
    #[inline]
    pub unsafe fn getVariationDesignPosition(
        &self,
        coordinates: SkSpan<SkFontArguments_VariationPosition_Coordinate>,
    ) -> ::core::ffi::c_int {
        SkTypeface_getVariationDesignPosition(self, coordinates)
    }
    #[inline]
    pub unsafe fn getVariationDesignParameters(
        &self,
        parameters: SkSpan<SkFontParameters_Variation_Axis>,
    ) -> ::core::ffi::c_int {
        SkTypeface_getVariationDesignParameters(self, parameters)
    }
    #[inline]
    pub unsafe fn Equal(facea: *const SkTypeface, faceb: *const SkTypeface) -> bool {
        SkTypeface_Equal(facea, faceb)
    }
    #[inline]
    pub unsafe fn MakeEmpty() -> sk_sp<SkTypeface> {
        SkTypeface_MakeEmpty()
    }
    #[inline]
    pub unsafe fn makeClone(&self, arg1: *const SkFontArguments) -> sk_sp<SkTypeface> {
        SkTypeface_makeClone(self, arg1)
    }
    #[inline]
    pub unsafe fn serialize(&self, arg1: *mut SkWStream, arg2: SkTypeface_SerializeBehavior) {
        SkTypeface_serialize(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn serialize1(&self, arg1: SkTypeface_SerializeBehavior) -> sk_sp<SkData> {
        SkTypeface_serialize1(self, arg1)
    }
    #[inline]
    pub unsafe fn MakeDeserialize(
        arg1: *mut SkStream,
        lastResortMgr: sk_sp<SkFontMgr>,
    ) -> sk_sp<SkTypeface> {
        SkTypeface_MakeDeserialize(arg1, lastResortMgr)
    }
    #[inline]
    pub unsafe fn unicharsToGlyphs(&self, unis: SkSpan<SkUnichar>, glyphs: SkSpan<SkGlyphID>) {
        SkTypeface_unicharsToGlyphs(self, unis, glyphs)
    }
    #[inline]
    pub unsafe fn textToGlyphs(
        &self,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: SkSpan<SkGlyphID>,
    ) -> usize {
        SkTypeface_textToGlyphs(self, text, byteLength, encoding, glyphs)
    }
    #[inline]
    pub unsafe fn unicharToGlyph(&self, unichar: SkUnichar) -> SkGlyphID {
        SkTypeface_unicharToGlyph(self, unichar)
    }
    #[inline]
    pub unsafe fn countGlyphs(&self) -> ::core::ffi::c_int {
        SkTypeface_countGlyphs(self)
    }
    #[inline]
    pub unsafe fn countTables(&self) -> ::core::ffi::c_int {
        SkTypeface_countTables(self)
    }
    #[inline]
    pub unsafe fn readTableTags(&self, tags: SkSpan<SkFontTableTag>) -> ::core::ffi::c_int {
        SkTypeface_readTableTags(self, tags)
    }
    #[inline]
    pub unsafe fn getTableSize(&self, arg1: SkFontTableTag) -> usize {
        SkTypeface_getTableSize(self, arg1)
    }
    #[inline]
    pub unsafe fn getTableData(
        &self,
        tag: SkFontTableTag,
        offset: usize,
        length: usize,
        data: *mut ::core::ffi::c_void,
    ) -> usize {
        SkTypeface_getTableData(self, tag, offset, length, data)
    }
    #[inline]
    pub unsafe fn copyTableData(&self, tag: SkFontTableTag) -> sk_sp<SkData> {
        SkTypeface_copyTableData(self, tag)
    }
    #[inline]
    pub unsafe fn getUnitsPerEm(&self) -> ::core::ffi::c_int {
        SkTypeface_getUnitsPerEm(self)
    }
    #[inline]
    pub unsafe fn getKerningPairAdjustments(
        &self,
        glyphs: SkSpan<SkGlyphID>,
        adjustments: SkSpan<i32>,
    ) -> bool {
        SkTypeface_getKerningPairAdjustments(self, glyphs, adjustments)
    }
    #[inline]
    pub unsafe fn createFamilyNameIterator(&self) -> *mut SkTypeface_LocalizedStrings {
        SkTypeface_createFamilyNameIterator(self)
    }
    #[inline]
    pub unsafe fn getFamilyName(&self, name: *mut SkString) {
        SkTypeface_getFamilyName(self, name)
    }
    #[inline]
    pub unsafe fn getPostScriptName(&self, name: *mut SkString) -> bool {
        SkTypeface_getPostScriptName(self, name)
    }
    #[inline]
    pub unsafe fn getResourceName(&self, resourceName: *mut SkString) -> ::core::ffi::c_int {
        SkTypeface_getResourceName(self, resourceName)
    }
    #[inline]
    pub unsafe fn openStream(&self, ttcIndex: *mut ::core::ffi::c_int) -> u64 {
        SkTypeface_openStream(self, ttcIndex)
    }
    #[inline]
    pub unsafe fn openExistingStream(&self, ttcIndex: *mut ::core::ffi::c_int) -> u64 {
        SkTypeface_openExistingStream(self, ttcIndex)
    }
    #[inline]
    pub unsafe fn createScalerContext(
        &self,
        arg1: *const SkScalerContextEffects,
        arg2: *const SkDescriptor,
    ) -> u8 {
        SkTypeface_createScalerContext(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn getBounds(&self) -> SkRect {
        SkTypeface_getBounds(self)
    }
    #[inline]
    pub unsafe fn Register(
        id: SkTypeface_FactoryId,
        make: ::core::option::Option<
            unsafe extern "C" fn(arg1: u64, arg2: *const SkFontArguments) -> sk_sp<SkTypeface>,
        >,
    ) {
        SkTypeface_Register(id, make)
    }
    #[inline]
    pub unsafe fn new(style: *const SkFontStyle, isFixedPitch: bool) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTypeface_SkTypeface(__bindgen_tmp.as_mut_ptr(), style, isFixedPitch);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTypefaceD1Ev"]
    pub fn SkTypeface_SkTypeface_destructor(this: *mut SkTypeface);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface14onGetFontStyleEv"]
    pub fn SkTypeface_onGetFontStyle(this: *mut ::core::ffi::c_void) -> SkFontStyle;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface15onGetFixedPitchEv"]
    pub fn SkTypeface_onGetFixedPitch(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface36onCreateScalerContextAsProxyTypefaceERK22SkScalerContextEffectsPK12SkDescriptorPS_"]
    pub fn SkTypeface_onCreateScalerContextAsProxyTypeface(
        this: *mut ::core::ffi::c_void,
        arg1: *const SkScalerContextEffects,
        arg2: *const SkDescriptor,
        proxyTypeface: *mut SkTypeface,
    ) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface20onOpenExistingStreamEPi"]
    pub fn SkTypeface_onOpenExistingStream(
        this: *mut ::core::ffi::c_void,
        ttcIndex: *mut ::core::ffi::c_int,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface27onGetKerningPairAdjustmentsE6SkSpanIKtES0_IiE"]
    pub fn SkTypeface_onGetKerningPairAdjustments(
        this: *mut ::core::ffi::c_void,
        arg1: SkSpan<SkGlyphID>,
        adjustments: SkSpan<i32>,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface17onGetResourceNameEP8SkString"]
    pub fn SkTypeface_onGetResourceName(
        this: *mut ::core::ffi::c_void,
        resourceName: *mut SkString,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface15onCopyTableDataEj"]
    pub fn SkTypeface_onCopyTableData(
        this: *mut ::core::ffi::c_void,
        arg1: SkFontTableTag,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTypeface15onComputeBoundsEP6SkRect"]
    pub fn SkTypeface_onComputeBounds(this: *mut ::core::ffi::c_void, arg1: *mut SkRect) -> bool;
}
#[repr(C)]
#[derive(Debug)]
pub struct SkFont {
    pub fTypeface: sk_sp<SkTypeface>,
    pub fSize: SkScalar,
    pub fScaleX: SkScalar,
    pub fSkewX: SkScalar,
    pub fFlags: u8,
    pub fEdging: u8,
    pub fHinting: u8,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkFont_Edging {
    Alias = 0,
    AntiAlias = 1,
    SubpixelAntiAlias = 2,
}
pub type SkFont_sk_is_trivially_relocatable = std_true_type;
pub const SkFont_PrivFlags_kForceAutoHinting_PrivFlag: SkFont_PrivFlags = 1;
pub const SkFont_PrivFlags_kEmbeddedBitmaps_PrivFlag: SkFont_PrivFlags = 2;
pub const SkFont_PrivFlags_kSubpixel_PrivFlag: SkFont_PrivFlags = 4;
pub const SkFont_PrivFlags_kLinearMetrics_PrivFlag: SkFont_PrivFlags = 8;
pub const SkFont_PrivFlags_kEmbolden_PrivFlag: SkFont_PrivFlags = 16;
pub const SkFont_PrivFlags_kBaselineSnap_PrivFlag: SkFont_PrivFlags = 32;
pub type SkFont_PrivFlags = ::core::ffi::c_uint;
pub const SkFont_kAllFlags: ::core::ffi::c_uint = 63;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFont"][::core::mem::size_of::<SkFont>() - 24usize];
    ["Alignment of SkFont"][::core::mem::align_of::<SkFont>() - 8usize];
    ["Offset of field: SkFont::fTypeface"][::core::mem::offset_of!(SkFont, fTypeface) - 0usize];
    ["Offset of field: SkFont::fSize"][::core::mem::offset_of!(SkFont, fSize) - 8usize];
    ["Offset of field: SkFont::fScaleX"][::core::mem::offset_of!(SkFont, fScaleX) - 12usize];
    ["Offset of field: SkFont::fSkewX"][::core::mem::offset_of!(SkFont, fSkewX) - 16usize];
    ["Offset of field: SkFont::fFlags"][::core::mem::offset_of!(SkFont, fFlags) - 20usize];
    ["Offset of field: SkFont::fEdging"][::core::mem::offset_of!(SkFont, fEdging) - 21usize];
    ["Offset of field: SkFont::fHinting"][::core::mem::offset_of!(SkFont, fHinting) - 22usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont19setForceAutoHintingEb"]
    pub fn SkFont_setForceAutoHinting(this: *mut SkFont, forceAutoHinting: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont18setEmbeddedBitmapsEb"]
    pub fn SkFont_setEmbeddedBitmaps(this: *mut SkFont, embeddedBitmaps: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont11setSubpixelEb"]
    pub fn SkFont_setSubpixel(this: *mut SkFont, subpixel: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont16setLinearMetricsEb"]
    pub fn SkFont_setLinearMetrics(this: *mut SkFont, linearMetrics: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont11setEmboldenEb"]
    pub fn SkFont_setEmbolden(this: *mut SkFont, embolden: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont15setBaselineSnapEb"]
    pub fn SkFont_setBaselineSnap(this: *mut SkFont, baselineSnap: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont9setEdgingENS_6EdgingE"]
    pub fn SkFont_setEdging(this: *mut SkFont, edging: SkFont_Edging);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont10setHintingE13SkFontHinting"]
    pub fn SkFont_setHinting(this: *mut SkFont, hintingLevel: SkFontHinting);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont12makeWithSizeEf"]
    pub fn SkFont_makeWithSize(this: *const SkFont, size: SkScalar) -> SkFont;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont11setTypefaceE5sk_spI10SkTypefaceE"]
    pub fn SkFont_setTypeface(this: *mut SkFont, tf: sk_sp<SkTypeface>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont7setSizeEf"]
    pub fn SkFont_setSize(this: *mut SkFont, textSize: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont9setScaleXEf"]
    pub fn SkFont_setScaleX(this: *mut SkFont, scaleX: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFont8setSkewXEf"]
    pub fn SkFont_setSkewX(this: *mut SkFont, skewX: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont12textToGlyphsEPKvm14SkTextEncoding6SkSpanItE"]
    pub fn SkFont_textToGlyphs(
        this: *const SkFont,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: SkSpan<SkGlyphID>,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont14unicharToGlyphEi"]
    pub fn SkFont_unicharToGlyph(this: *const SkFont, uni: SkUnichar) -> SkGlyphID;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont16unicharsToGlyphsE6SkSpanIKiES0_ItE"]
    pub fn SkFont_unicharsToGlyphs(
        this: *const SkFont,
        src: SkSpan<SkUnichar>,
        dst: SkSpan<SkGlyphID>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont11measureTextEPKvm14SkTextEncodingP6SkRectPK7SkPaint"]
    pub fn SkFont_measureText(
        this: *const SkFont,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        bounds: *mut SkRect,
        paint: *const SkPaint,
    ) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont15getWidthsBoundsE6SkSpanIKtES0_IfES0_I6SkRectEPK7SkPaint"]
    pub fn SkFont_getWidthsBounds(
        this: *const SkFont,
        glyphs: SkSpan<SkGlyphID>,
        widths: SkSpan<SkScalar>,
        bounds: SkSpan<SkRect>,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont6getPosE6SkSpanIKtES0_I7SkPointES3_"]
    pub fn SkFont_getPos(
        this: *const SkFont,
        glyphs: SkSpan<SkGlyphID>,
        pos: SkSpan<SkPoint>,
        origin: SkPoint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont7getXPosE6SkSpanIKtES0_IfEf"]
    pub fn SkFont_getXPos(
        this: *const SkFont,
        glyphs: SkSpan<SkGlyphID>,
        xpos: SkSpan<SkScalar>,
        origin: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont13getInterceptsE6SkSpanIKtES0_IK7SkPointEffPK7SkPaint"]
    pub fn SkFont_getIntercepts(
        this: *const SkFont,
        glyphs: SkSpan<SkGlyphID>,
        pos: SkSpan<SkPoint>,
        top: SkScalar,
        bottom: SkScalar,
        arg1: *const SkPaint,
    ) -> __BindgenOpaqueArray<u64, 3usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont7getPathEt"]
    pub fn SkFont_getPath(
        this: *const SkFont,
        glyphID: SkGlyphID,
    ) -> __BindgenOpaqueArray<u64, 3usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont7getPathEtP6SkPath"]
    pub fn SkFont_getPath1(this: *const SkFont, glyphID: SkGlyphID, path: *mut SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont8getPathsE6SkSpanIKtEPFvPK6SkPathRK8SkMatrixPvES9_"]
    pub fn SkFont_getPaths(
        this: *const SkFont,
        glyphIDs: SkSpan<SkGlyphID>,
        glyphPathProc: ::core::option::Option<
            unsafe extern "C" fn(
                pathOrNull: *const SkPath,
                mx: *const SkMatrix,
                ctx: *mut ::core::ffi::c_void,
            ),
        >,
        ctx: *mut ::core::ffi::c_void,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont10getMetricsEP13SkFontMetrics"]
    pub fn SkFont_getMetrics(this: *const SkFont, metrics: *mut SkFontMetrics) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK6SkFont4dumpEv"]
    pub fn SkFont_dump(this: *const SkFont);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFontC1Ev"]
    pub fn SkFont_SkFont(this: *mut SkFont);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFontC1E5sk_spI10SkTypefaceEf"]
    pub fn SkFont_SkFont1(this: *mut SkFont, typeface: sk_sp<SkTypeface>, size: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFontC1E5sk_spI10SkTypefaceE"]
    pub fn SkFont_SkFont2(this: *mut SkFont, typeface: sk_sp<SkTypeface>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN6SkFontC1E5sk_spI10SkTypefaceEfff"]
    pub fn SkFont_SkFont3(
        this: *mut SkFont,
        typeface: sk_sp<SkTypeface>,
        size: SkScalar,
        scaleX: SkScalar,
        skewX: SkScalar,
    );
}
impl SkFont {
    #[inline]
    pub unsafe fn setForceAutoHinting(&mut self, forceAutoHinting: bool) {
        SkFont_setForceAutoHinting(self, forceAutoHinting)
    }
    #[inline]
    pub unsafe fn setEmbeddedBitmaps(&mut self, embeddedBitmaps: bool) {
        SkFont_setEmbeddedBitmaps(self, embeddedBitmaps)
    }
    #[inline]
    pub unsafe fn setSubpixel(&mut self, subpixel: bool) {
        SkFont_setSubpixel(self, subpixel)
    }
    #[inline]
    pub unsafe fn setLinearMetrics(&mut self, linearMetrics: bool) {
        SkFont_setLinearMetrics(self, linearMetrics)
    }
    #[inline]
    pub unsafe fn setEmbolden(&mut self, embolden: bool) {
        SkFont_setEmbolden(self, embolden)
    }
    #[inline]
    pub unsafe fn setBaselineSnap(&mut self, baselineSnap: bool) {
        SkFont_setBaselineSnap(self, baselineSnap)
    }
    #[inline]
    pub unsafe fn setEdging(&mut self, edging: SkFont_Edging) {
        SkFont_setEdging(self, edging)
    }
    #[inline]
    pub unsafe fn setHinting(&mut self, hintingLevel: SkFontHinting) {
        SkFont_setHinting(self, hintingLevel)
    }
    #[inline]
    pub unsafe fn makeWithSize(&self, size: SkScalar) -> SkFont {
        SkFont_makeWithSize(self, size)
    }
    #[inline]
    pub unsafe fn setTypeface(&mut self, tf: sk_sp<SkTypeface>) {
        SkFont_setTypeface(self, tf)
    }
    #[inline]
    pub unsafe fn setSize(&mut self, textSize: SkScalar) {
        SkFont_setSize(self, textSize)
    }
    #[inline]
    pub unsafe fn setScaleX(&mut self, scaleX: SkScalar) {
        SkFont_setScaleX(self, scaleX)
    }
    #[inline]
    pub unsafe fn setSkewX(&mut self, skewX: SkScalar) {
        SkFont_setSkewX(self, skewX)
    }
    #[inline]
    pub unsafe fn textToGlyphs(
        &self,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: SkSpan<SkGlyphID>,
    ) -> usize {
        SkFont_textToGlyphs(self, text, byteLength, encoding, glyphs)
    }
    #[inline]
    pub unsafe fn unicharToGlyph(&self, uni: SkUnichar) -> SkGlyphID {
        SkFont_unicharToGlyph(self, uni)
    }
    #[inline]
    pub unsafe fn unicharsToGlyphs(&self, src: SkSpan<SkUnichar>, dst: SkSpan<SkGlyphID>) {
        SkFont_unicharsToGlyphs(self, src, dst)
    }
    #[inline]
    pub unsafe fn measureText(
        &self,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        bounds: *mut SkRect,
        paint: *const SkPaint,
    ) -> SkScalar {
        SkFont_measureText(self, text, byteLength, encoding, bounds, paint)
    }
    #[inline]
    pub unsafe fn getWidthsBounds(
        &self,
        glyphs: SkSpan<SkGlyphID>,
        widths: SkSpan<SkScalar>,
        bounds: SkSpan<SkRect>,
        paint: *const SkPaint,
    ) {
        SkFont_getWidthsBounds(self, glyphs, widths, bounds, paint)
    }
    #[inline]
    pub unsafe fn getPos(&self, glyphs: SkSpan<SkGlyphID>, pos: SkSpan<SkPoint>, origin: SkPoint) {
        SkFont_getPos(self, glyphs, pos, origin)
    }
    #[inline]
    pub unsafe fn getXPos(
        &self,
        glyphs: SkSpan<SkGlyphID>,
        xpos: SkSpan<SkScalar>,
        origin: SkScalar,
    ) {
        SkFont_getXPos(self, glyphs, xpos, origin)
    }
    #[inline]
    pub unsafe fn getIntercepts(
        &self,
        glyphs: SkSpan<SkGlyphID>,
        pos: SkSpan<SkPoint>,
        top: SkScalar,
        bottom: SkScalar,
        arg1: *const SkPaint,
    ) -> __BindgenOpaqueArray<u64, 3usize> {
        SkFont_getIntercepts(self, glyphs, pos, top, bottom, arg1)
    }
    #[inline]
    pub unsafe fn getPath(&self, glyphID: SkGlyphID) -> __BindgenOpaqueArray<u64, 3usize> {
        SkFont_getPath(self, glyphID)
    }
    #[inline]
    pub unsafe fn getPath1(&self, glyphID: SkGlyphID, path: *mut SkPath) -> bool {
        SkFont_getPath1(self, glyphID, path)
    }
    #[inline]
    pub unsafe fn getPaths(
        &self,
        glyphIDs: SkSpan<SkGlyphID>,
        glyphPathProc: ::core::option::Option<
            unsafe extern "C" fn(
                pathOrNull: *const SkPath,
                mx: *const SkMatrix,
                ctx: *mut ::core::ffi::c_void,
            ),
        >,
        ctx: *mut ::core::ffi::c_void,
    ) {
        SkFont_getPaths(self, glyphIDs, glyphPathProc, ctx)
    }
    #[inline]
    pub unsafe fn getMetrics(&self, metrics: *mut SkFontMetrics) -> SkScalar {
        SkFont_getMetrics(self, metrics)
    }
    #[inline]
    pub unsafe fn dump(&self) {
        SkFont_dump(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkFont_SkFont(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(typeface: sk_sp<SkTypeface>, size: SkScalar) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkFont_SkFont1(__bindgen_tmp.as_mut_ptr(), typeface, size);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(typeface: sk_sp<SkTypeface>) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkFont_SkFont2(__bindgen_tmp.as_mut_ptr(), typeface);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(
        typeface: sk_sp<SkTypeface>,
        size: SkScalar,
        scaleX: SkScalar,
        skewX: SkScalar,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkFont_SkFont3(__bindgen_tmp.as_mut_ptr(), typeface, size, scaleX, skewX);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkFontMetrics {
    pub fFlags: u32,
    pub fTop: SkScalar,
    pub fAscent: SkScalar,
    pub fDescent: SkScalar,
    pub fBottom: SkScalar,
    pub fLeading: SkScalar,
    pub fAvgCharWidth: SkScalar,
    pub fMaxCharWidth: SkScalar,
    pub fXMin: SkScalar,
    pub fXMax: SkScalar,
    pub fXHeight: SkScalar,
    pub fCapHeight: SkScalar,
    pub fUnderlineThickness: SkScalar,
    pub fUnderlinePosition: SkScalar,
    pub fStrikeoutThickness: SkScalar,
    pub fStrikeoutPosition: SkScalar,
}
pub const SkFontMetrics_FontMetricsFlags_kUnderlineThicknessIsValid_Flag:
    SkFontMetrics_FontMetricsFlags = 1;
pub const SkFontMetrics_FontMetricsFlags_kUnderlinePositionIsValid_Flag:
    SkFontMetrics_FontMetricsFlags = 2;
pub const SkFontMetrics_FontMetricsFlags_kStrikeoutThicknessIsValid_Flag:
    SkFontMetrics_FontMetricsFlags = 4;
pub const SkFontMetrics_FontMetricsFlags_kStrikeoutPositionIsValid_Flag:
    SkFontMetrics_FontMetricsFlags = 8;
pub const SkFontMetrics_FontMetricsFlags_kBoundsInvalid_Flag: SkFontMetrics_FontMetricsFlags = 16;
pub type SkFontMetrics_FontMetricsFlags = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontMetrics"][::core::mem::size_of::<SkFontMetrics>() - 64usize];
    ["Alignment of SkFontMetrics"][::core::mem::align_of::<SkFontMetrics>() - 4usize];
    ["Offset of field: SkFontMetrics::fFlags"]
        [::core::mem::offset_of!(SkFontMetrics, fFlags) - 0usize];
    ["Offset of field: SkFontMetrics::fTop"][::core::mem::offset_of!(SkFontMetrics, fTop) - 4usize];
    ["Offset of field: SkFontMetrics::fAscent"]
        [::core::mem::offset_of!(SkFontMetrics, fAscent) - 8usize];
    ["Offset of field: SkFontMetrics::fDescent"]
        [::core::mem::offset_of!(SkFontMetrics, fDescent) - 12usize];
    ["Offset of field: SkFontMetrics::fBottom"]
        [::core::mem::offset_of!(SkFontMetrics, fBottom) - 16usize];
    ["Offset of field: SkFontMetrics::fLeading"]
        [::core::mem::offset_of!(SkFontMetrics, fLeading) - 20usize];
    ["Offset of field: SkFontMetrics::fAvgCharWidth"]
        [::core::mem::offset_of!(SkFontMetrics, fAvgCharWidth) - 24usize];
    ["Offset of field: SkFontMetrics::fMaxCharWidth"]
        [::core::mem::offset_of!(SkFontMetrics, fMaxCharWidth) - 28usize];
    ["Offset of field: SkFontMetrics::fXMin"]
        [::core::mem::offset_of!(SkFontMetrics, fXMin) - 32usize];
    ["Offset of field: SkFontMetrics::fXMax"]
        [::core::mem::offset_of!(SkFontMetrics, fXMax) - 36usize];
    ["Offset of field: SkFontMetrics::fXHeight"]
        [::core::mem::offset_of!(SkFontMetrics, fXHeight) - 40usize];
    ["Offset of field: SkFontMetrics::fCapHeight"]
        [::core::mem::offset_of!(SkFontMetrics, fCapHeight) - 44usize];
    ["Offset of field: SkFontMetrics::fUnderlineThickness"]
        [::core::mem::offset_of!(SkFontMetrics, fUnderlineThickness) - 48usize];
    ["Offset of field: SkFontMetrics::fUnderlinePosition"]
        [::core::mem::offset_of!(SkFontMetrics, fUnderlinePosition) - 52usize];
    ["Offset of field: SkFontMetrics::fStrikeoutThickness"]
        [::core::mem::offset_of!(SkFontMetrics, fStrikeoutThickness) - 56usize];
    ["Offset of field: SkFontMetrics::fStrikeoutPosition"]
        [::core::mem::offset_of!(SkFontMetrics, fStrikeoutPosition) - 60usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkFontStyleSet {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontStyleSet"][::core::mem::size_of::<SkFontStyleSet>() - 16usize];
    ["Alignment of SkFontStyleSet"][::core::mem::align_of::<SkFontStyleSet>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkFontStyleSet11CreateEmptyEv"]
    pub fn SkFontStyleSet_CreateEmpty() -> sk_sp<SkFontStyleSet>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkFontStyleSet14matchStyleCSS3ERK11SkFontStyle"]
    pub fn SkFontStyleSet_matchStyleCSS3(
        this: *mut SkFontStyleSet,
        pattern: *const SkFontStyle,
    ) -> sk_sp<SkTypeface>;
}
impl SkFontStyleSet {
    #[inline]
    pub unsafe fn CreateEmpty() -> sk_sp<SkFontStyleSet> {
        SkFontStyleSet_CreateEmpty()
    }
    #[inline]
    pub unsafe fn matchStyleCSS3(&mut self, pattern: *const SkFontStyle) -> sk_sp<SkTypeface> {
        SkFontStyleSet_matchStyleCSS3(self, pattern)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkFontMgr {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkFontMgr"][::core::mem::size_of::<SkFontMgr>() - 16usize];
    ["Alignment of SkFontMgr"][::core::mem::align_of::<SkFontMgr>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr13countFamiliesEv"]
    pub fn SkFontMgr_countFamilies(this: *const SkFontMgr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr13getFamilyNameEiP8SkString"]
    pub fn SkFontMgr_getFamilyName(
        this: *const SkFontMgr,
        index: ::core::ffi::c_int,
        familyName: *mut SkString,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr14createStyleSetEi"]
    pub fn SkFontMgr_createStyleSet(
        this: *const SkFontMgr,
        index: ::core::ffi::c_int,
    ) -> sk_sp<SkFontStyleSet>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr11matchFamilyEPKc"]
    pub fn SkFontMgr_matchFamily(
        this: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
    ) -> sk_sp<SkFontStyleSet>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr16matchFamilyStyleEPKcRK11SkFontStyle"]
    pub fn SkFontMgr_matchFamilyStyle(
        this: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr25matchFamilyStyleCharacterEPKcRK11SkFontStylePS1_ii"]
    pub fn SkFontMgr_matchFamilyStyleCharacter(
        this: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
        bcp47: *mut *const ::core::ffi::c_char,
        bcp47Count: ::core::ffi::c_int,
        character: SkUnichar,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr12makeFromDataE5sk_spI6SkDataEi"]
    pub fn SkFontMgr_makeFromData(
        this: *const SkFontMgr,
        arg1: sk_sp<SkData>,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr14makeFromStreamESt10unique_ptrI13SkStreamAssetSt14default_deleteIS1_EEi"]
    pub fn SkFontMgr_makeFromStream(
        this: *const SkFontMgr,
        arg1: u64,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr14makeFromStreamESt10unique_ptrI13SkStreamAssetSt14default_deleteIS1_EERK15SkFontArguments"]
    pub fn SkFontMgr_makeFromStream1(
        this: *const SkFontMgr,
        arg1: u64,
        arg2: *const SkFontArguments,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr12makeFromFileEPKci"]
    pub fn SkFontMgr_makeFromFile(
        this: *const SkFontMgr,
        path: *const ::core::ffi::c_char,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkFontMgr18legacyMakeTypefaceEPKc11SkFontStyle"]
    pub fn SkFontMgr_legacyMakeTypeface(
        this: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        style: SkFontStyle,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkFontMgr8RefEmptyEv"]
    pub fn SkFontMgr_RefEmpty() -> sk_sp<SkFontMgr>;
}
impl SkFontMgr {
    #[inline]
    pub unsafe fn countFamilies(&self) -> ::core::ffi::c_int {
        SkFontMgr_countFamilies(self)
    }
    #[inline]
    pub unsafe fn getFamilyName(&self, index: ::core::ffi::c_int, familyName: *mut SkString) {
        SkFontMgr_getFamilyName(self, index, familyName)
    }
    #[inline]
    pub unsafe fn createStyleSet(&self, index: ::core::ffi::c_int) -> sk_sp<SkFontStyleSet> {
        SkFontMgr_createStyleSet(self, index)
    }
    #[inline]
    pub unsafe fn matchFamily(
        &self,
        familyName: *const ::core::ffi::c_char,
    ) -> sk_sp<SkFontStyleSet> {
        SkFontMgr_matchFamily(self, familyName)
    }
    #[inline]
    pub unsafe fn matchFamilyStyle(
        &self,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_matchFamilyStyle(self, familyName, arg1)
    }
    #[inline]
    pub unsafe fn matchFamilyStyleCharacter(
        &self,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
        bcp47: *mut *const ::core::ffi::c_char,
        bcp47Count: ::core::ffi::c_int,
        character: SkUnichar,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_matchFamilyStyleCharacter(self, familyName, arg1, bcp47, bcp47Count, character)
    }
    #[inline]
    pub unsafe fn makeFromData(
        &self,
        arg1: sk_sp<SkData>,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_makeFromData(self, arg1, ttcIndex)
    }
    #[inline]
    pub unsafe fn makeFromStream(
        &self,
        arg1: u64,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_makeFromStream(self, arg1, ttcIndex)
    }
    #[inline]
    pub unsafe fn makeFromStream1(
        &self,
        arg1: u64,
        arg2: *const SkFontArguments,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_makeFromStream1(self, arg1, arg2)
    }
    #[inline]
    pub unsafe fn makeFromFile(
        &self,
        path: *const ::core::ffi::c_char,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_makeFromFile(self, path, ttcIndex)
    }
    #[inline]
    pub unsafe fn legacyMakeTypeface(
        &self,
        familyName: *const ::core::ffi::c_char,
        style: SkFontStyle,
    ) -> sk_sp<SkTypeface> {
        SkFontMgr_legacyMakeTypeface(self, familyName, style)
    }
    #[inline]
    pub unsafe fn RefEmpty() -> sk_sp<SkFontMgr> {
        SkFontMgr_RefEmpty()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkOpenTypeSVGDecoder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTraceMemoryDump {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkGraphics {
    pub _address: u8,
}
pub type SkGraphics_ImageGeneratorFromEncodedDataFactory =
    ::core::option::Option<unsafe extern "C" fn(arg1: sk_sp<SkData>) -> u64>;
pub type SkGraphics_OpenTypeSVGDecoderFactory =
    ::core::option::Option<unsafe extern "C" fn(svg: *const u8, length: usize) -> u8>;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkGraphics"][::core::mem::size_of::<SkGraphics>() - 1usize];
    ["Alignment of SkGraphics"][::core::mem::align_of::<SkGraphics>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics4InitEv"]
    pub fn SkGraphics_Init();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics17GetFontCacheLimitEv"]
    pub fn SkGraphics_GetFontCacheLimit() -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics17SetFontCacheLimitEm"]
    pub fn SkGraphics_SetFontCacheLimit(bytes: usize) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics16GetFontCacheUsedEv"]
    pub fn SkGraphics_GetFontCacheUsed() -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics21GetFontCacheCountUsedEv"]
    pub fn SkGraphics_GetFontCacheCountUsed() -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics22GetFontCacheCountLimitEv"]
    pub fn SkGraphics_GetFontCacheCountLimit() -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics22SetFontCacheCountLimitEi"]
    pub fn SkGraphics_SetFontCacheCountLimit(count: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics26GetTypefaceCacheCountLimitEv"]
    pub fn SkGraphics_GetTypefaceCacheCountLimit() -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics26SetTypefaceCacheCountLimitEi"]
    pub fn SkGraphics_SetTypefaceCacheCountLimit(count: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics14PurgeFontCacheEv"]
    pub fn SkGraphics_PurgeFontCache();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics20PurgePinnedFontCacheEv"]
    pub fn SkGraphics_PurgePinnedFontCache();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics30GetResourceCacheTotalBytesUsedEv"]
    pub fn SkGraphics_GetResourceCacheTotalBytesUsed() -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics30GetResourceCacheTotalByteLimitEv"]
    pub fn SkGraphics_GetResourceCacheTotalByteLimit() -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics30SetResourceCacheTotalByteLimitEm"]
    pub fn SkGraphics_SetResourceCacheTotalByteLimit(newLimit: usize) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics18PurgeResourceCacheEv"]
    pub fn SkGraphics_PurgeResourceCache();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics41GetResourceCacheSingleAllocationByteLimitEv"]
    pub fn SkGraphics_GetResourceCacheSingleAllocationByteLimit() -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics41SetResourceCacheSingleAllocationByteLimitEm"]
    pub fn SkGraphics_SetResourceCacheSingleAllocationByteLimit(newLimit: usize) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics20DumpMemoryStatisticsEP17SkTraceMemoryDump"]
    pub fn SkGraphics_DumpMemoryStatistics(dump: *mut SkTraceMemoryDump);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics14PurgeAllCachesEv"]
    pub fn SkGraphics_PurgeAllCaches();
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics39SetImageGeneratorFromEncodedDataFactoryEPFSt10unique_ptrI16SkImageGeneratorSt14default_deleteIS1_EE5sk_spI6SkDataEE"]
    pub fn SkGraphics_SetImageGeneratorFromEncodedDataFactory(
        arg1: SkGraphics_ImageGeneratorFromEncodedDataFactory,
    ) -> SkGraphics_ImageGeneratorFromEncodedDataFactory;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics28SetOpenTypeSVGDecoderFactoryEPFSt10unique_ptrI20SkOpenTypeSVGDecoderSt14default_deleteIS1_EEPKhmE"]
    pub fn SkGraphics_SetOpenTypeSVGDecoderFactory(
        arg1: SkGraphics_OpenTypeSVGDecoderFactory,
    ) -> SkGraphics_OpenTypeSVGDecoderFactory;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkGraphics28GetOpenTypeSVGDecoderFactoryEv"]
    pub fn SkGraphics_GetOpenTypeSVGDecoderFactory() -> SkGraphics_OpenTypeSVGDecoderFactory;
}
impl SkGraphics {
    #[inline]
    pub unsafe fn Init() {
        SkGraphics_Init()
    }
    #[inline]
    pub unsafe fn GetFontCacheLimit() -> usize {
        SkGraphics_GetFontCacheLimit()
    }
    #[inline]
    pub unsafe fn SetFontCacheLimit(bytes: usize) -> usize {
        SkGraphics_SetFontCacheLimit(bytes)
    }
    #[inline]
    pub unsafe fn GetFontCacheUsed() -> usize {
        SkGraphics_GetFontCacheUsed()
    }
    #[inline]
    pub unsafe fn GetFontCacheCountUsed() -> ::core::ffi::c_int {
        SkGraphics_GetFontCacheCountUsed()
    }
    #[inline]
    pub unsafe fn GetFontCacheCountLimit() -> ::core::ffi::c_int {
        SkGraphics_GetFontCacheCountLimit()
    }
    #[inline]
    pub unsafe fn SetFontCacheCountLimit(count: ::core::ffi::c_int) -> ::core::ffi::c_int {
        SkGraphics_SetFontCacheCountLimit(count)
    }
    #[inline]
    pub unsafe fn GetTypefaceCacheCountLimit() -> ::core::ffi::c_int {
        SkGraphics_GetTypefaceCacheCountLimit()
    }
    #[inline]
    pub unsafe fn SetTypefaceCacheCountLimit(count: ::core::ffi::c_int) -> ::core::ffi::c_int {
        SkGraphics_SetTypefaceCacheCountLimit(count)
    }
    #[inline]
    pub unsafe fn PurgeFontCache() {
        SkGraphics_PurgeFontCache()
    }
    #[inline]
    pub unsafe fn PurgePinnedFontCache() {
        SkGraphics_PurgePinnedFontCache()
    }
    #[inline]
    pub unsafe fn GetResourceCacheTotalBytesUsed() -> usize {
        SkGraphics_GetResourceCacheTotalBytesUsed()
    }
    #[inline]
    pub unsafe fn GetResourceCacheTotalByteLimit() -> usize {
        SkGraphics_GetResourceCacheTotalByteLimit()
    }
    #[inline]
    pub unsafe fn SetResourceCacheTotalByteLimit(newLimit: usize) -> usize {
        SkGraphics_SetResourceCacheTotalByteLimit(newLimit)
    }
    #[inline]
    pub unsafe fn PurgeResourceCache() {
        SkGraphics_PurgeResourceCache()
    }
    #[inline]
    pub unsafe fn GetResourceCacheSingleAllocationByteLimit() -> usize {
        SkGraphics_GetResourceCacheSingleAllocationByteLimit()
    }
    #[inline]
    pub unsafe fn SetResourceCacheSingleAllocationByteLimit(newLimit: usize) -> usize {
        SkGraphics_SetResourceCacheSingleAllocationByteLimit(newLimit)
    }
    #[inline]
    pub unsafe fn DumpMemoryStatistics(dump: *mut SkTraceMemoryDump) {
        SkGraphics_DumpMemoryStatistics(dump)
    }
    #[inline]
    pub unsafe fn PurgeAllCaches() {
        SkGraphics_PurgeAllCaches()
    }
    #[inline]
    pub unsafe fn SetImageGeneratorFromEncodedDataFactory(
        arg1: SkGraphics_ImageGeneratorFromEncodedDataFactory,
    ) -> SkGraphics_ImageGeneratorFromEncodedDataFactory {
        SkGraphics_SetImageGeneratorFromEncodedDataFactory(arg1)
    }
    #[inline]
    pub unsafe fn SetOpenTypeSVGDecoderFactory(
        arg1: SkGraphics_OpenTypeSVGDecoderFactory,
    ) -> SkGraphics_OpenTypeSVGDecoderFactory {
        SkGraphics_SetOpenTypeSVGDecoderFactory(arg1)
    }
    #[inline]
    pub unsafe fn GetOpenTypeSVGDecoderFactory() -> SkGraphics_OpenTypeSVGDecoderFactory {
        SkGraphics_GetOpenTypeSVGDecoderFactory()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrDirectContext {
    _unused: [u8; 0],
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImages_BitDepth {
    U8 = 0,
    F16 = 1,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkImage {
    pub _base: SkRefCnt,
    pub fInfo: SkImageInfo,
    pub fUniqueID: u32,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImage_CachingHint {
    Allow = 0,
    Disallow = 1,
}
#[repr(C)]
pub struct SkImage_AsyncReadResult__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct SkImage_AsyncReadResult {
    pub vtable_: *const SkImage_AsyncReadResult__bindgen_vtable,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImage_AsyncReadResult"][::core::mem::size_of::<SkImage_AsyncReadResult>() - 8usize];
    ["Alignment of SkImage_AsyncReadResult"]
        [::core::mem::align_of::<SkImage_AsyncReadResult>() - 8usize];
};
pub type SkImage_ReadPixelsContext = *mut ::core::ffi::c_void;
pub type SkImage_ReadPixelsCallback =
    ::core::option::Option<unsafe extern "C" fn(arg1: SkImage_ReadPixelsContext, arg2: u8)>;
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImage_RescaleGamma {
    kSrc = 0,
    kLinear = 1,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImage_RescaleMode {
    kNearest = 0,
    kLinear = 1,
    kRepeatedLinear = 2,
    kRepeatedCubic = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkImage_RequiredProperties {
    pub fMipmapped: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImage_RequiredProperties"]
        [::core::mem::size_of::<SkImage_RequiredProperties>() - 1usize];
    ["Alignment of SkImage_RequiredProperties"]
        [::core::mem::align_of::<SkImage_RequiredProperties>() - 1usize];
    ["Offset of field: SkImage_RequiredProperties::fMipmapped"]
        [::core::mem::offset_of!(SkImage_RequiredProperties, fMipmapped) - 0usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImage_LegacyBitmapMode {
    kRO_LegacyBitmapMode = 0,
}
pub type SkImage_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImage"][::core::mem::size_of::<SkImage>() - 48usize];
    ["Alignment of SkImage"][::core::mem::align_of::<SkImage>() - 8usize];
    ["Offset of field: SkImage::fInfo"][::core::mem::offset_of!(SkImage, fInfo) - 16usize];
    ["Offset of field: SkImage::fUniqueID"][::core::mem::offset_of!(SkImage, fUniqueID) - 40usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage9alphaTypeEv"]
    pub fn SkImage_alphaType(this: *const SkImage) -> SkAlphaType;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage9colorTypeEv"]
    pub fn SkImage_colorType(this: *const SkImage) -> SkColorType;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10colorSpaceEv"]
    pub fn SkImage_colorSpace(this: *const SkImage) -> *mut SkColorSpace;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage13refColorSpaceEv"]
    pub fn SkImage_refColorSpace(this: *const SkImage) -> sk_sp<SkColorSpace>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage11isAlphaOnlyEv"]
    pub fn SkImage_isAlphaOnly(this: *const SkImage) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeShaderE10SkTileModeS0_RK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkImage_makeShader(
        this: *const SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeShaderE10SkTileModeS0_RK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkImage_makeShader1(
        this: *const SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeShaderERK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkImage_makeShader2(
        this: *const SkImage,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeShaderERK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkImage_makeShader3(
        this: *const SkImage,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage13makeRawShaderE10SkTileModeS0_RK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkImage_makeRawShader(
        this: *const SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage13makeRawShaderE10SkTileModeS0_RK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkImage_makeRawShader1(
        this: *const SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage13makeRawShaderERK17SkSamplingOptionsRK8SkMatrix"]
    pub fn SkImage_makeRawShader2(
        this: *const SkImage,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage13makeRawShaderERK17SkSamplingOptionsPK8SkMatrix"]
    pub fn SkImage_makeRawShader3(
        this: *const SkImage,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10peekPixelsEP8SkPixmap"]
    pub fn SkImage_peekPixels(this: *const SkImage, pixmap: *mut SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10readPixelsEP15GrDirectContextRK11SkImageInfoPvmiiNS_11CachingHintE"]
    pub fn SkImage_readPixels(
        this: *const SkImage,
        context: *mut GrDirectContext,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10readPixelsEP15GrDirectContextRK8SkPixmapiiNS_11CachingHintE"]
    pub fn SkImage_readPixels1(
        this: *const SkImage,
        context: *mut GrDirectContext,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10readPixelsERK11SkImageInfoPvmiiNS_11CachingHintE"]
    pub fn SkImage_readPixels2(
        this: *const SkImage,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10readPixelsERK8SkPixmapiiNS_11CachingHintE"]
    pub fn SkImage_readPixels3(
        this: *const SkImage,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage25asyncRescaleAndReadPixelsERK11SkImageInfoRK7SkIRectNS_12RescaleGammaENS_11RescaleModeEPFvPvSt10unique_ptrIKNS_15AsyncReadResultESt14default_deleteISB_EEES8_"]
    pub fn SkImage_asyncRescaleAndReadPixels(
        this: *const SkImage,
        info: *const SkImageInfo,
        srcRect: *const SkIRect,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage31asyncRescaleAndReadPixelsYUV420E15SkYUVColorSpace5sk_spI12SkColorSpaceERK7SkIRectRK7SkISizeNS_12RescaleGammaENS_11RescaleModeEPFvPvSt10unique_ptrIKNS_15AsyncReadResultESt14default_deleteISF_EEESC_"]
    pub fn SkImage_asyncRescaleAndReadPixelsYUV420(
        this: *const SkImage,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage32asyncRescaleAndReadPixelsYUVA420E15SkYUVColorSpace5sk_spI12SkColorSpaceERK7SkIRectRK7SkISizeNS_12RescaleGammaENS_11RescaleModeEPFvPvSt10unique_ptrIKNS_15AsyncReadResultESt14default_deleteISF_EEESC_"]
    pub fn SkImage_asyncRescaleAndReadPixelsYUVA420(
        this: *const SkImage,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage11scalePixelsERK8SkPixmapRK17SkSamplingOptionsNS_11CachingHintE"]
    pub fn SkImage_scalePixels(
        this: *const SkImage,
        dst: *const SkPixmap,
        arg1: *const SkSamplingOptions,
        cachingHint: SkImage_CachingHint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeScaledEP10SkRecorderRK11SkImageInfoRK17SkSamplingOptions"]
    pub fn SkImage_makeScaled(
        this: *const SkImage,
        arg1: *mut SkRecorder,
        arg2: *const SkImageInfo,
        arg3: *const SkSamplingOptions,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeScaledEP10SkRecorderRK11SkImageInfoRK17SkSamplingOptionsRK14SkSurfaceProps"]
    pub fn SkImage_makeScaled1(
        this: *const SkImage,
        arg1: *mut SkRecorder,
        arg2: *const SkImageInfo,
        arg3: *const SkSamplingOptions,
        arg4: *const SkSurfaceProps,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10makeScaledERK11SkImageInfoRK17SkSamplingOptions"]
    pub fn SkImage_makeScaled2(
        this: *const SkImage,
        info: *const SkImageInfo,
        sampling: *const SkSamplingOptions,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage14refEncodedDataEv"]
    pub fn SkImage_refEncodedData(this: *const SkImage) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage10hasMipmapsEv"]
    pub fn SkImage_hasMipmaps(this: *const SkImage) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage11isProtectedEv"]
    pub fn SkImage_isProtected(this: *const SkImage) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage18withDefaultMipmapsEv"]
    pub fn SkImage_withDefaultMipmaps(this: *const SkImage) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage19makeNonTextureImageEP15GrDirectContext"]
    pub fn SkImage_makeNonTextureImage(
        this: *const SkImage,
        arg1: *mut GrDirectContext,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage15makeRasterImageEP15GrDirectContextNS_11CachingHintE"]
    pub fn SkImage_makeRasterImage(
        this: *const SkImage,
        arg1: *mut GrDirectContext,
        cachingHint: SkImage_CachingHint,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage14asLegacyBitmapEP8SkBitmapNS_16LegacyBitmapModeE"]
    pub fn SkImage_asLegacyBitmap(
        this: *const SkImage,
        bitmap: *mut SkBitmap,
        legacyBitmapMode: SkImage_LegacyBitmapMode,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkImage21reinterpretColorSpaceE5sk_spI12SkColorSpaceE"]
    pub fn SkImage_reinterpretColorSpace(
        this: *const SkImage,
        newColorSpace: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkImage>;
}
impl SkImage {
    #[inline]
    pub unsafe fn alphaType(&self) -> SkAlphaType {
        SkImage_alphaType(self)
    }
    #[inline]
    pub unsafe fn colorType(&self) -> SkColorType {
        SkImage_colorType(self)
    }
    #[inline]
    pub unsafe fn colorSpace(&self) -> *mut SkColorSpace {
        SkImage_colorSpace(self)
    }
    #[inline]
    pub unsafe fn refColorSpace(&self) -> sk_sp<SkColorSpace> {
        SkImage_refColorSpace(self)
    }
    #[inline]
    pub unsafe fn isAlphaOnly(&self) -> bool {
        SkImage_isAlphaOnly(self)
    }
    #[inline]
    pub unsafe fn makeShader(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeShader(self, tmx, tmy, arg1, localMatrix)
    }
    #[inline]
    pub unsafe fn makeShader1(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeShader1(self, tmx, tmy, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeShader2(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeShader2(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeShader3(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeShader3(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeRawShader(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        arg1: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeRawShader(self, tmx, tmy, arg1, localMatrix)
    }
    #[inline]
    pub unsafe fn makeRawShader1(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeRawShader1(self, tmx, tmy, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeRawShader2(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeRawShader2(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn makeRawShader3(
        &self,
        sampling: *const SkSamplingOptions,
        lm: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkImage_makeRawShader3(self, sampling, lm)
    }
    #[inline]
    pub unsafe fn peekPixels(&self, pixmap: *mut SkPixmap) -> bool {
        SkImage_peekPixels(self, pixmap)
    }
    #[inline]
    pub unsafe fn readPixels(
        &self,
        context: *mut GrDirectContext,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool {
        SkImage_readPixels(
            self,
            context,
            dstInfo,
            dstPixels,
            dstRowBytes,
            srcX,
            srcY,
            cachingHint,
        )
    }
    #[inline]
    pub unsafe fn readPixels1(
        &self,
        context: *mut GrDirectContext,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool {
        SkImage_readPixels1(self, context, dst, srcX, srcY, cachingHint)
    }
    #[inline]
    pub unsafe fn readPixels2(
        &self,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool {
        SkImage_readPixels2(
            self,
            dstInfo,
            dstPixels,
            dstRowBytes,
            srcX,
            srcY,
            cachingHint,
        )
    }
    #[inline]
    pub unsafe fn readPixels3(
        &self,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
        cachingHint: SkImage_CachingHint,
    ) -> bool {
        SkImage_readPixels3(self, dst, srcX, srcY, cachingHint)
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixels(
        &self,
        info: *const SkImageInfo,
        srcRect: *const SkIRect,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    ) {
        SkImage_asyncRescaleAndReadPixels(
            self,
            info,
            srcRect,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixelsYUV420(
        &self,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    ) {
        SkImage_asyncRescaleAndReadPixelsYUV420(
            self,
            yuvColorSpace,
            dstColorSpace,
            srcRect,
            dstSize,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixelsYUVA420(
        &self,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkImage_RescaleGamma,
        rescaleMode: SkImage_RescaleMode,
        callback: SkImage_ReadPixelsCallback,
        context: SkImage_ReadPixelsContext,
    ) {
        SkImage_asyncRescaleAndReadPixelsYUVA420(
            self,
            yuvColorSpace,
            dstColorSpace,
            srcRect,
            dstSize,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn scalePixels(
        &self,
        dst: *const SkPixmap,
        arg1: *const SkSamplingOptions,
        cachingHint: SkImage_CachingHint,
    ) -> bool {
        SkImage_scalePixels(self, dst, arg1, cachingHint)
    }
    #[inline]
    pub unsafe fn makeScaled(
        &self,
        arg1: *mut SkRecorder,
        arg2: *const SkImageInfo,
        arg3: *const SkSamplingOptions,
    ) -> sk_sp<SkImage> {
        SkImage_makeScaled(self, arg1, arg2, arg3)
    }
    #[inline]
    pub unsafe fn makeScaled1(
        &self,
        arg1: *mut SkRecorder,
        arg2: *const SkImageInfo,
        arg3: *const SkSamplingOptions,
        arg4: *const SkSurfaceProps,
    ) -> sk_sp<SkImage> {
        SkImage_makeScaled1(self, arg1, arg2, arg3, arg4)
    }
    #[inline]
    pub unsafe fn makeScaled2(
        &self,
        info: *const SkImageInfo,
        sampling: *const SkSamplingOptions,
    ) -> sk_sp<SkImage> {
        SkImage_makeScaled2(self, info, sampling)
    }
    #[inline]
    pub unsafe fn refEncodedData(&self) -> sk_sp<SkData> {
        SkImage_refEncodedData(self)
    }
    #[inline]
    pub unsafe fn hasMipmaps(&self) -> bool {
        SkImage_hasMipmaps(self)
    }
    #[inline]
    pub unsafe fn isProtected(&self) -> bool {
        SkImage_isProtected(self)
    }
    #[inline]
    pub unsafe fn withDefaultMipmaps(&self) -> sk_sp<SkImage> {
        SkImage_withDefaultMipmaps(self)
    }
    #[inline]
    pub unsafe fn makeNonTextureImage(&self, arg1: *mut GrDirectContext) -> sk_sp<SkImage> {
        SkImage_makeNonTextureImage(self, arg1)
    }
    #[inline]
    pub unsafe fn makeRasterImage(
        &self,
        arg1: *mut GrDirectContext,
        cachingHint: SkImage_CachingHint,
    ) -> sk_sp<SkImage> {
        SkImage_makeRasterImage(self, arg1, cachingHint)
    }
    #[inline]
    pub unsafe fn asLegacyBitmap(
        &self,
        bitmap: *mut SkBitmap,
        legacyBitmapMode: SkImage_LegacyBitmapMode,
    ) -> bool {
        SkImage_asLegacyBitmap(self, bitmap, legacyBitmapMode)
    }
    #[inline]
    pub unsafe fn reinterpretColorSpace(
        &self,
        newColorSpace: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkImage> {
        SkImage_reinterpretColorSpace(self, newColorSpace)
    }
}
#[repr(C)]
pub struct SkImageGenerator__bindgen_vtable(::core::ffi::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct SkImageGenerator {
    pub vtable_: *const SkImageGenerator__bindgen_vtable,
    pub fInfo: SkImageInfo,
    pub fUniqueID: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkImageGenerator_Options {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImageGenerator_Options"]
        [::core::mem::size_of::<SkImageGenerator_Options>() - 1usize];
    ["Alignment of SkImageGenerator_Options"]
        [::core::mem::align_of::<SkImageGenerator_Options>() - 1usize];
};
pub const SkImageGenerator_kNeedNewImageUniqueID: ::core::ffi::c_int = 0;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkImageGenerator"][::core::mem::size_of::<SkImageGenerator>() - 40usize];
    ["Alignment of SkImageGenerator"][::core::mem::align_of::<SkImageGenerator>() - 8usize];
    ["Offset of field: SkImageGenerator::fInfo"]
        [::core::mem::offset_of!(SkImageGenerator, fInfo) - 8usize];
    ["Offset of field: SkImageGenerator::fUniqueID"]
        [::core::mem::offset_of!(SkImageGenerator, fUniqueID) - 32usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkImageGenerator9getPixelsERK11SkImageInfoPvm"]
    pub fn SkImageGenerator_getPixels(
        this: *mut SkImageGenerator,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkImageGenerator13queryYUVAInfoERKN16SkYUVAPixmapInfo18SupportedDataTypesEPS0_"]
    pub fn SkImageGenerator_queryYUVAInfo(
        this: *const SkImageGenerator,
        supportedDataTypes: *const SkYUVAPixmapInfo_SupportedDataTypes,
        yuvaPixmapInfo: *mut SkYUVAPixmapInfo,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkImageGenerator13getYUVAPlanesERK13SkYUVAPixmaps"]
    pub fn SkImageGenerator_getYUVAPlanes(
        this: *mut SkImageGenerator,
        yuvaPixmaps: *const SkYUVAPixmaps,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkImageGeneratorC1ERK11SkImageInfoj"]
    pub fn SkImageGenerator_SkImageGenerator(
        this: *mut SkImageGenerator,
        info: *const SkImageInfo,
        uniqueId: u32,
    );
}
impl SkImageGenerator {
    #[inline]
    pub unsafe fn getPixels(
        &mut self,
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
    ) -> bool {
        SkImageGenerator_getPixels(self, info, pixels, rowBytes)
    }
    #[inline]
    pub unsafe fn queryYUVAInfo(
        &self,
        supportedDataTypes: *const SkYUVAPixmapInfo_SupportedDataTypes,
        yuvaPixmapInfo: *mut SkYUVAPixmapInfo,
    ) -> bool {
        SkImageGenerator_queryYUVAInfo(self, supportedDataTypes, yuvaPixmapInfo)
    }
    #[inline]
    pub unsafe fn getYUVAPlanes(&mut self, yuvaPixmaps: *const SkYUVAPixmaps) -> bool {
        SkImageGenerator_getYUVAPlanes(self, yuvaPixmaps)
    }
    #[inline]
    pub unsafe fn new(info: *const SkImageInfo, uniqueId: u32) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkImageGenerator_SkImageGenerator(__bindgen_tmp.as_mut_ptr(), info, uniqueId);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkMaskFilter {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkMaskFilter"][::core::mem::size_of::<SkMaskFilter>() - 16usize];
    ["Alignment of SkMaskFilter"][::core::mem::align_of::<SkMaskFilter>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkMaskFilter8MakeBlurE11SkBlurStylefb"]
    pub fn SkMaskFilter_MakeBlur(
        style: SkBlurStyle,
        sigma: SkScalar,
        respectCTM: bool,
    ) -> sk_sp<SkMaskFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkMaskFilter11DeserializeEPKvmPK15SkDeserialProcs"]
    pub fn SkMaskFilter_Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkMaskFilter>;
}
impl SkMaskFilter {
    #[inline]
    pub unsafe fn MakeBlur(
        style: SkBlurStyle,
        sigma: SkScalar,
        respectCTM: bool,
    ) -> sk_sp<SkMaskFilter> {
        SkMaskFilter_MakeBlur(style, sigma, respectCTM)
    }
    #[inline]
    pub unsafe fn Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkMaskFilter> {
        SkMaskFilter_Deserialize(data, size, procs)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRRect {
    pub fRect: SkRect,
    pub fRadii: [SkVector; 4usize],
    pub fType: i32,
}
impl SkRRect_Type {
    pub const LastType: SkRRect_Type = SkRRect_Type::Complex;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRRect_Type {
    Empty = 0,
    Rect = 1,
    Oval = 2,
    Simple = 3,
    NinePatch = 4,
    Complex = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRRect_Corner {
    UpperLeft = 0,
    UpperRight = 1,
    LowerRight = 2,
    LowerLeft = 3,
}
pub const SkRRect_kSizeInMemory: usize = 48;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRRect"][::core::mem::size_of::<SkRRect>() - 52usize];
    ["Alignment of SkRRect"][::core::mem::align_of::<SkRRect>() - 4usize];
    ["Offset of field: SkRRect::fRect"][::core::mem::offset_of!(SkRRect, fRect) - 0usize];
    ["Offset of field: SkRRect::fRadii"][::core::mem::offset_of!(SkRRect, fRadii) - 16usize];
    ["Offset of field: SkRRect::fType"][::core::mem::offset_of!(SkRRect, fType) - 48usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkRRect7setOvalERK6SkRect"]
    pub fn SkRRect_setOval(this: *mut SkRRect, oval: *const SkRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkRRect9setRectXYERK6SkRectff"]
    pub fn SkRRect_setRectXY(
        this: *mut SkRRect,
        rect: *const SkRect,
        xRad: SkScalar,
        yRad: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkRRect12setNinePatchERK6SkRectffff"]
    pub fn SkRRect_setNinePatch(
        this: *mut SkRRect,
        rect: *const SkRect,
        leftRad: SkScalar,
        topRad: SkScalar,
        rightRad: SkScalar,
        bottomRad: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkRRect12setRectRadiiERK6SkRectPK7SkPoint"]
    pub fn SkRRect_setRectRadii(this: *mut SkRRect, rect: *const SkRect, radii: *const SkVector);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect5insetEffPS_"]
    pub fn SkRRect_inset(this: *const SkRRect, dx: SkScalar, dy: SkScalar, dst: *mut SkRRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect8containsERK6SkRect"]
    pub fn SkRRect_contains(this: *const SkRRect, rect: *const SkRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect7isValidEv"]
    pub fn SkRRect_isValid(this: *const SkRRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect13writeToMemoryEPv"]
    pub fn SkRRect_writeToMemory(this: *const SkRRect, buffer: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN7SkRRect14readFromMemoryEPKvm"]
    pub fn SkRRect_readFromMemory(
        this: *mut SkRRect,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect9transformERK8SkMatrix"]
    pub fn SkRRect_transform(this: *const SkRRect, arg1: *const SkMatrix) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect9transformERK8SkMatrixPS_"]
    pub fn SkRRect_transform1(
        this: *const SkRRect,
        matrix: *const SkMatrix,
        dst: *mut SkRRect,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect4dumpEb"]
    pub fn SkRRect_dump(this: *const SkRRect, asHex: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK7SkRRect12dumpToStringEb"]
    pub fn SkRRect_dumpToString(this: *const SkRRect, asHex: bool) -> SkString;
}
impl SkRRect {
    #[inline]
    pub unsafe fn setOval(&mut self, oval: *const SkRect) {
        SkRRect_setOval(self, oval)
    }
    #[inline]
    pub unsafe fn setRectXY(&mut self, rect: *const SkRect, xRad: SkScalar, yRad: SkScalar) {
        SkRRect_setRectXY(self, rect, xRad, yRad)
    }
    #[inline]
    pub unsafe fn setNinePatch(
        &mut self,
        rect: *const SkRect,
        leftRad: SkScalar,
        topRad: SkScalar,
        rightRad: SkScalar,
        bottomRad: SkScalar,
    ) {
        SkRRect_setNinePatch(self, rect, leftRad, topRad, rightRad, bottomRad)
    }
    #[inline]
    pub unsafe fn setRectRadii(&mut self, rect: *const SkRect, radii: *const SkVector) {
        SkRRect_setRectRadii(self, rect, radii)
    }
    #[inline]
    pub unsafe fn inset(&self, dx: SkScalar, dy: SkScalar, dst: *mut SkRRect) {
        SkRRect_inset(self, dx, dy, dst)
    }
    #[inline]
    pub unsafe fn contains(&self, rect: *const SkRect) -> bool {
        SkRRect_contains(self, rect)
    }
    #[inline]
    pub unsafe fn isValid(&self) -> bool {
        SkRRect_isValid(self)
    }
    #[inline]
    pub unsafe fn writeToMemory(&self, buffer: *mut ::core::ffi::c_void) -> usize {
        SkRRect_writeToMemory(self, buffer)
    }
    #[inline]
    pub unsafe fn readFromMemory(
        &mut self,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize {
        SkRRect_readFromMemory(self, buffer, length)
    }
    #[inline]
    pub unsafe fn transform(&self, arg1: *const SkMatrix) -> u8 {
        SkRRect_transform(self, arg1)
    }
    #[inline]
    pub unsafe fn transform1(&self, matrix: *const SkMatrix, dst: *mut SkRRect) -> bool {
        SkRRect_transform1(self, matrix, dst)
    }
    #[inline]
    pub unsafe fn dump(&self, asHex: bool) {
        SkRRect_dump(self, asHex)
    }
    #[inline]
    pub unsafe fn dumpToString(&self, asHex: bool) -> SkString {
        SkRRect_dumpToString(self, asHex)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkMutex {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkMutex"][::core::mem::size_of::<SkMutex>() - 16usize];
    ["Alignment of SkMutex"][::core::mem::align_of::<SkMutex>() - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkIDChangeListener {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug)]
pub struct SkIDChangeListener_List {
    pub fMutex: SkMutex,
    pub fListeners: __BindgenOpaqueArray<u64, 3usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkIDChangeListener_List"]
        [::core::mem::size_of::<SkIDChangeListener_List>() - 40usize];
    ["Alignment of SkIDChangeListener_List"]
        [::core::mem::align_of::<SkIDChangeListener_List>() - 8usize];
    ["Offset of field: SkIDChangeListener_List::fMutex"]
        [::core::mem::offset_of!(SkIDChangeListener_List, fMutex) - 0usize];
    ["Offset of field: SkIDChangeListener_List::fListeners"]
        [::core::mem::offset_of!(SkIDChangeListener_List, fListeners) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListener4List3addE5sk_spIS_E"]
    pub fn SkIDChangeListener_List_add(
        this: *mut SkIDChangeListener_List,
        listener: sk_sp<SkIDChangeListener>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK18SkIDChangeListener4List5countEv"]
    pub fn SkIDChangeListener_List_count(
        this: *const SkIDChangeListener_List,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListener4List7changedEv"]
    pub fn SkIDChangeListener_List_changed(this: *mut SkIDChangeListener_List);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListener4List5resetEv"]
    pub fn SkIDChangeListener_List_reset(this: *mut SkIDChangeListener_List);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListener4ListC1Ev"]
    pub fn SkIDChangeListener_List_List(this: *mut SkIDChangeListener_List);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListener4ListD1Ev"]
    pub fn SkIDChangeListener_List_List_destructor(this: *mut SkIDChangeListener_List);
}
impl SkIDChangeListener_List {
    #[inline]
    pub unsafe fn add(&mut self, listener: sk_sp<SkIDChangeListener>) {
        SkIDChangeListener_List_add(self, listener)
    }
    #[inline]
    pub unsafe fn count(&self) -> ::core::ffi::c_int {
        SkIDChangeListener_List_count(self)
    }
    #[inline]
    pub unsafe fn changed(&mut self) {
        SkIDChangeListener_List_changed(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkIDChangeListener_List_reset(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkIDChangeListener_List_List(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkIDChangeListener_List_List_destructor(self)
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkIDChangeListener"][::core::mem::size_of::<SkIDChangeListener>() - 16usize];
    ["Alignment of SkIDChangeListener"][::core::mem::align_of::<SkIDChangeListener>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListenerC2Ev"]
    pub fn SkIDChangeListener_SkIDChangeListener(this: *mut SkIDChangeListener);
}
impl SkIDChangeListener {
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkIDChangeListener_SkIDChangeListener(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN18SkIDChangeListenerD1Ev"]
    pub fn SkIDChangeListener_SkIDChangeListener_destructor(this: *mut SkIDChangeListener);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathRRectInfo {
    pub fRRect: SkRRect,
    pub fDirection: SkPathDirection,
    pub fStartIndex: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathRRectInfo"][::core::mem::size_of::<SkPathRRectInfo>() - 56usize];
    ["Alignment of SkPathRRectInfo"][::core::mem::align_of::<SkPathRRectInfo>() - 4usize];
    ["Offset of field: SkPathRRectInfo::fRRect"]
        [::core::mem::offset_of!(SkPathRRectInfo, fRRect) - 0usize];
    ["Offset of field: SkPathRRectInfo::fDirection"]
        [::core::mem::offset_of!(SkPathRRectInfo, fDirection) - 52usize];
    ["Offset of field: SkPathRRectInfo::fStartIndex"]
        [::core::mem::offset_of!(SkPathRRectInfo, fStartIndex) - 53usize];
};
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathIsAType {
    kGeneral = 0,
    kOval = 1,
    kRRect = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPathIsAData {
    pub fStartIndex: u8,
    pub fDirection: SkPathDirection,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathIsAData"][::core::mem::size_of::<SkPathIsAData>() - 2usize];
    ["Alignment of SkPathIsAData"][::core::mem::align_of::<SkPathIsAData>() - 1usize];
    ["Offset of field: SkPathIsAData::fStartIndex"]
        [::core::mem::offset_of!(SkPathIsAData, fStartIndex) - 0usize];
    ["Offset of field: SkPathIsAData::fDirection"]
        [::core::mem::offset_of!(SkPathIsAData, fDirection) - 1usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkPathRef {
    pub _bindgen_opaque_blob: [u64; 22usize],
}
pub type SkPathRef_PointsArray = __BindgenOpaqueArray<u64, 6usize>;
pub type SkPathRef_VerbsArray = __BindgenOpaqueArray<u64, 3usize>;
pub type SkPathRef_ConicWeightsArray = __BindgenOpaqueArray<u64, 3usize>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathRef_SerializationOffsets {
    kLegacyRRectOrOvalStartIdx_SerializationShift = 28,
    kLegacyRRectOrOvalIsCCW_SerializationShift = 27,
    kLegacyIsRRect_SerializationShift = 26,
    kIsFinite_SerializationShift = 25,
    kLegacyIsOval_SerializationShift = 24,
    kSegmentMask_SerializationShift = 0,
}
pub const SkPathRef_kEmptyGenID: SkPathRef__bindgen_ty_1 = SkPathRef__bindgen_ty_1::kEmptyGenID;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathRef__bindgen_ty_1 {
    kEmptyGenID = 1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathRef"][::core::mem::size_of::<SkPathRef>() - 176usize];
    ["Alignment of SkPathRef"][::core::mem::align_of::<SkPathRef>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef11CreateEmptyEv"]
    pub fn SkPathRef_CreateEmpty() -> *mut SkPathRef;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef7isRRectEv"]
    pub fn SkPathRef_isRRect(this: *const SkPathRef) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef21CreateTransformedCopyEP5sk_spIS_ERKS_RK8SkMatrix"]
    pub fn SkPathRef_CreateTransformedCopy(
        dst: *mut sk_sp<SkPathRef>,
        src: *const SkPathRef,
        matrix: *const SkMatrix,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef6RewindEP5sk_spIS_E"]
    pub fn SkPathRef_Rewind(pathRef: *mut sk_sp<SkPathRef>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef20approximateBytesUsedEv"]
    pub fn SkPathRef_approximateBytesUsed(this: *const SkPathRef) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef11interpolateERKS_fPS_"]
    pub fn SkPathRef_interpolate(
        this: *const SkPathRef,
        ending: *const SkPathRef,
        weight: SkScalar,
        out: *mut SkPathRef,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef5genIDEh"]
    pub fn SkPathRef_genID(this: *const SkPathRef, fillType: u8) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef22addGenIDChangeListenerE5sk_spI18SkIDChangeListenerE"]
    pub fn SkPathRef_addGenIDChangeListener(this: *mut SkPathRef, arg1: sk_sp<SkIDChangeListener>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef24genIDChangeListenerCountEv"]
    pub fn SkPathRef_genIDChangeListenerCount(this: *mut SkPathRef) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef16dataMatchesVerbsEv"]
    pub fn SkPathRef_dataMatchesVerbs(this: *const SkPathRef) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPathRef7isValidEv"]
    pub fn SkPathRef_isValid(this: *const SkPathRef) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRef5resetEv"]
    pub fn SkPathRef_reset(this: *mut SkPathRef);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPathRefD1Ev"]
    pub fn SkPathRef_SkPathRef_destructor(this: *mut SkPathRef);
}
impl SkPathRef {
    #[inline]
    pub unsafe fn CreateEmpty() -> *mut SkPathRef {
        SkPathRef_CreateEmpty()
    }
    #[inline]
    pub unsafe fn isRRect(&self) -> u8 {
        SkPathRef_isRRect(self)
    }
    #[inline]
    pub unsafe fn CreateTransformedCopy(
        dst: *mut sk_sp<SkPathRef>,
        src: *const SkPathRef,
        matrix: *const SkMatrix,
    ) {
        SkPathRef_CreateTransformedCopy(dst, src, matrix)
    }
    #[inline]
    pub unsafe fn Rewind(pathRef: *mut sk_sp<SkPathRef>) {
        SkPathRef_Rewind(pathRef)
    }
    #[inline]
    pub unsafe fn approximateBytesUsed(&self) -> usize {
        SkPathRef_approximateBytesUsed(self)
    }
    #[inline]
    pub unsafe fn interpolate(
        &self,
        ending: *const SkPathRef,
        weight: SkScalar,
        out: *mut SkPathRef,
    ) {
        SkPathRef_interpolate(self, ending, weight, out)
    }
    #[inline]
    pub unsafe fn genID(&self, fillType: u8) -> u32 {
        SkPathRef_genID(self, fillType)
    }
    #[inline]
    pub unsafe fn addGenIDChangeListener(&mut self, arg1: sk_sp<SkIDChangeListener>) {
        SkPathRef_addGenIDChangeListener(self, arg1)
    }
    #[inline]
    pub unsafe fn genIDChangeListenerCount(&mut self) -> ::core::ffi::c_int {
        SkPathRef_genIDChangeListenerCount(self)
    }
    #[inline]
    pub unsafe fn dataMatchesVerbs(&self) -> bool {
        SkPathRef_dataMatchesVerbs(self)
    }
    #[inline]
    pub unsafe fn isValid(&self) -> bool {
        SkPathRef_isValid(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkPathRef_reset(self)
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPathRef_SkPathRef_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkPathBuilder {
    pub fPts: SkPathRef_PointsArray,
    pub fVerbs: SkPathRef_VerbsArray,
    pub fConicWeights: SkPathRef_ConicWeightsArray,
    pub fFillType: SkPathFillType,
    pub fIsVolatile: bool,
    pub fConvexity: SkPathConvexity,
    pub fSegmentMask: ::core::ffi::c_uint,
    pub fLastMovePoint: SkPoint,
    pub fLastMoveIndex: ::core::ffi::c_int,
    pub fNeedsMoveVerb: bool,
    pub fType: SkPathIsAType,
    pub fIsA: SkPathIsAData,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathBuilder_ArcSize {
    Small = 0,
    Large = 1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathBuilder"][::core::mem::size_of::<SkPathBuilder>() - 128usize];
    ["Alignment of SkPathBuilder"][::core::mem::align_of::<SkPathBuilder>() - 8usize];
    ["Offset of field: SkPathBuilder::fPts"][::core::mem::offset_of!(SkPathBuilder, fPts) - 0usize];
    ["Offset of field: SkPathBuilder::fVerbs"]
        [::core::mem::offset_of!(SkPathBuilder, fVerbs) - 48usize];
    ["Offset of field: SkPathBuilder::fConicWeights"]
        [::core::mem::offset_of!(SkPathBuilder, fConicWeights) - 72usize];
    ["Offset of field: SkPathBuilder::fFillType"]
        [::core::mem::offset_of!(SkPathBuilder, fFillType) - 96usize];
    ["Offset of field: SkPathBuilder::fIsVolatile"]
        [::core::mem::offset_of!(SkPathBuilder, fIsVolatile) - 97usize];
    ["Offset of field: SkPathBuilder::fConvexity"]
        [::core::mem::offset_of!(SkPathBuilder, fConvexity) - 100usize];
    ["Offset of field: SkPathBuilder::fSegmentMask"]
        [::core::mem::offset_of!(SkPathBuilder, fSegmentMask) - 104usize];
    ["Offset of field: SkPathBuilder::fLastMovePoint"]
        [::core::mem::offset_of!(SkPathBuilder, fLastMovePoint) - 108usize];
    ["Offset of field: SkPathBuilder::fLastMoveIndex"]
        [::core::mem::offset_of!(SkPathBuilder, fLastMoveIndex) - 116usize];
    ["Offset of field: SkPathBuilder::fNeedsMoveVerb"]
        [::core::mem::offset_of!(SkPathBuilder, fNeedsMoveVerb) - 120usize];
    ["Offset of field: SkPathBuilder::fType"]
        [::core::mem::offset_of!(SkPathBuilder, fType) - 121usize];
    ["Offset of field: SkPathBuilder::fIsA"]
        [::core::mem::offset_of!(SkPathBuilder, fIsA) - 122usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkPathBuilder13computeBoundsEv"]
    pub fn SkPathBuilder_computeBounds(this: *const SkPathBuilder) -> SkRect;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkPathBuilder8snapshotEv"]
    pub fn SkPathBuilder_snapshot(this: *const SkPathBuilder) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6detachEv"]
    pub fn SkPathBuilder_detach(this: *mut SkPathBuilder) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder5resetEv"]
    pub fn SkPathBuilder_reset(this: *mut SkPathBuilder) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6moveToE7SkPoint"]
    pub fn SkPathBuilder_moveTo(this: *mut SkPathBuilder, point: SkPoint) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6lineToE7SkPoint"]
    pub fn SkPathBuilder_lineTo(this: *mut SkPathBuilder, pt: SkPoint) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6quadToE7SkPointS0_"]
    pub fn SkPathBuilder_quadTo(
        this: *mut SkPathBuilder,
        pt1: SkPoint,
        pt2: SkPoint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7conicToE7SkPointS0_f"]
    pub fn SkPathBuilder_conicTo(
        this: *mut SkPathBuilder,
        pt1: SkPoint,
        pt2: SkPoint,
        w: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7cubicToE7SkPointS0_S0_"]
    pub fn SkPathBuilder_cubicTo(
        this: *mut SkPathBuilder,
        pt1: SkPoint,
        pt2: SkPoint,
        pt3: SkPoint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder5closeEv"]
    pub fn SkPathBuilder_close(this: *mut SkPathBuilder) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder10polylineToE6SkSpanIK7SkPointE"]
    pub fn SkPathBuilder_polylineTo(
        this: *mut SkPathBuilder,
        pts: SkSpan<SkPoint>,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7rMoveToE7SkPoint"]
    pub fn SkPathBuilder_rMoveTo(this: *mut SkPathBuilder, pt: SkPoint) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7rLineToE7SkPoint"]
    pub fn SkPathBuilder_rLineTo(this: *mut SkPathBuilder, pt: SkPoint) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7rQuadToE7SkPointS0_"]
    pub fn SkPathBuilder_rQuadTo(
        this: *mut SkPathBuilder,
        pt1: SkPoint,
        pt2: SkPoint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder8rConicToE7SkPointS0_f"]
    pub fn SkPathBuilder_rConicTo(
        this: *mut SkPathBuilder,
        p1: SkPoint,
        p2: SkPoint,
        w: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder8rCubicToE7SkPointS0_S0_"]
    pub fn SkPathBuilder_rCubicTo(
        this: *mut SkPathBuilder,
        pt1: SkPoint,
        pt2: SkPoint,
        pt3: SkPoint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6rArcToEfffNS_7ArcSizeE15SkPathDirectionff"]
    pub fn SkPathBuilder_rArcTo(
        this: *mut SkPathBuilder,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPathBuilder_ArcSize,
        sweep: SkPathDirection,
        dx: SkScalar,
        dy: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder5arcToERK6SkRectffb"]
    pub fn SkPathBuilder_arcTo(
        this: *mut SkPathBuilder,
        oval: *const SkRect,
        startAngleDeg: SkScalar,
        sweepAngleDeg: SkScalar,
        forceMoveTo: bool,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder5arcToE7SkPointS0_f"]
    pub fn SkPathBuilder_arcTo1(
        this: *mut SkPathBuilder,
        p1: SkPoint,
        p2: SkPoint,
        radius: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder5arcToE7SkPointfNS_7ArcSizeE15SkPathDirectionS0_"]
    pub fn SkPathBuilder_arcTo2(
        this: *mut SkPathBuilder,
        r: SkPoint,
        xAxisRotate: SkScalar,
        largeArc: SkPathBuilder_ArcSize,
        sweep: SkPathDirection,
        xy: SkPoint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6addArcERK6SkRectff"]
    pub fn SkPathBuilder_addArc(
        this: *mut SkPathBuilder,
        oval: *const SkRect,
        startAngleDeg: SkScalar,
        sweepAngleDeg: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7addRectERK6SkRect15SkPathDirectionj"]
    pub fn SkPathBuilder_addRect(
        this: *mut SkPathBuilder,
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7addOvalERK6SkRect15SkPathDirectionj"]
    pub fn SkPathBuilder_addOval(
        this: *mut SkPathBuilder,
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder8addRRectERK7SkRRect15SkPathDirectionj"]
    pub fn SkPathBuilder_addRRect(
        this: *mut SkPathBuilder,
        rrect: *const SkRRect,
        arg1: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder9addCircleEfff15SkPathDirection"]
    pub fn SkPathBuilder_addCircle(
        this: *mut SkPathBuilder,
        x: SkScalar,
        y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder10addPolygonE6SkSpanIK7SkPointEb"]
    pub fn SkPathBuilder_addPolygon(
        this: *mut SkPathBuilder,
        pts: SkSpan<SkPoint>,
        close: bool,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7addPathERK6SkPathffNS0_11AddPathModeE"]
    pub fn SkPathBuilder_addPath(
        this: *mut SkPathBuilder,
        src: *const SkPath,
        dx: SkScalar,
        dy: SkScalar,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder7addPathERK6SkPathRK8SkMatrixNS0_11AddPathModeE"]
    pub fn SkPathBuilder_addPath1(
        this: *mut SkPathBuilder,
        src: *const SkPath,
        matrix: *const SkMatrix,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder10incReserveEii"]
    pub fn SkPathBuilder_incReserve(
        this: *mut SkPathBuilder,
        extraPtCount: ::core::ffi::c_int,
        extraVerbCount: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6offsetEff"]
    pub fn SkPathBuilder_offset(
        this: *mut SkPathBuilder,
        dx: SkScalar,
        dy: SkScalar,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder9transformERK8SkMatrix"]
    pub fn SkPathBuilder_transform(
        this: *mut SkPathBuilder,
        matrix: *const SkMatrix,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkPathBuilder8isFiniteEv"]
    pub fn SkPathBuilder_isFinite(this: *const SkPathBuilder) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkPathBuilder9getLastPtEv"]
    pub fn SkPathBuilder_getLastPt(this: *const SkPathBuilder)
    -> __BindgenOpaqueArray<u32, 3usize>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder9setLastPtEff"]
    pub fn SkPathBuilder_setLastPt(this: *mut SkPathBuilder, x: SkScalar, y: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilder6addRawERK9SkPathRaw"]
    pub fn SkPathBuilder_addRaw(
        this: *mut SkPathBuilder,
        arg1: *const SkPathRaw,
    ) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK13SkPathBuilder4iterEv"]
    pub fn SkPathBuilder_iter(this: *const SkPathBuilder) -> SkPathIter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilderC1Ev"]
    pub fn SkPathBuilder_SkPathBuilder(this: *mut SkPathBuilder);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilderC1E14SkPathFillType"]
    pub fn SkPathBuilder_SkPathBuilder1(this: *mut SkPathBuilder, fillType: SkPathFillType);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilderC1ERK6SkPath"]
    pub fn SkPathBuilder_SkPathBuilder2(this: *mut SkPathBuilder, path: *const SkPath);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathBuilderD1Ev"]
    pub fn SkPathBuilder_SkPathBuilder_destructor(this: *mut SkPathBuilder);
}
impl SkPathBuilder {
    #[inline]
    pub unsafe fn computeBounds(&self) -> SkRect {
        SkPathBuilder_computeBounds(self)
    }
    #[inline]
    pub unsafe fn snapshot(&self) -> SkPath {
        SkPathBuilder_snapshot(self)
    }
    #[inline]
    pub unsafe fn detach(&mut self) -> SkPath {
        SkPathBuilder_detach(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) -> *mut SkPathBuilder {
        SkPathBuilder_reset(self)
    }
    #[inline]
    pub unsafe fn moveTo(&mut self, point: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_moveTo(self, point)
    }
    #[inline]
    pub unsafe fn lineTo(&mut self, pt: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_lineTo(self, pt)
    }
    #[inline]
    pub unsafe fn quadTo(&mut self, pt1: SkPoint, pt2: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_quadTo(self, pt1, pt2)
    }
    #[inline]
    pub unsafe fn conicTo(
        &mut self,
        pt1: SkPoint,
        pt2: SkPoint,
        w: SkScalar,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_conicTo(self, pt1, pt2, w)
    }
    #[inline]
    pub unsafe fn cubicTo(
        &mut self,
        pt1: SkPoint,
        pt2: SkPoint,
        pt3: SkPoint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_cubicTo(self, pt1, pt2, pt3)
    }
    #[inline]
    pub unsafe fn close(&mut self) -> *mut SkPathBuilder {
        SkPathBuilder_close(self)
    }
    #[inline]
    pub unsafe fn polylineTo(&mut self, pts: SkSpan<SkPoint>) -> *mut SkPathBuilder {
        SkPathBuilder_polylineTo(self, pts)
    }
    #[inline]
    pub unsafe fn rMoveTo(&mut self, pt: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_rMoveTo(self, pt)
    }
    #[inline]
    pub unsafe fn rLineTo(&mut self, pt: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_rLineTo(self, pt)
    }
    #[inline]
    pub unsafe fn rQuadTo(&mut self, pt1: SkPoint, pt2: SkPoint) -> *mut SkPathBuilder {
        SkPathBuilder_rQuadTo(self, pt1, pt2)
    }
    #[inline]
    pub unsafe fn rConicTo(&mut self, p1: SkPoint, p2: SkPoint, w: SkScalar) -> *mut SkPathBuilder {
        SkPathBuilder_rConicTo(self, p1, p2, w)
    }
    #[inline]
    pub unsafe fn rCubicTo(
        &mut self,
        pt1: SkPoint,
        pt2: SkPoint,
        pt3: SkPoint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_rCubicTo(self, pt1, pt2, pt3)
    }
    #[inline]
    pub unsafe fn rArcTo(
        &mut self,
        rx: SkScalar,
        ry: SkScalar,
        xAxisRotate: SkScalar,
        largeArc: SkPathBuilder_ArcSize,
        sweep: SkPathDirection,
        dx: SkScalar,
        dy: SkScalar,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_rArcTo(self, rx, ry, xAxisRotate, largeArc, sweep, dx, dy)
    }
    #[inline]
    pub unsafe fn arcTo(
        &mut self,
        oval: *const SkRect,
        startAngleDeg: SkScalar,
        sweepAngleDeg: SkScalar,
        forceMoveTo: bool,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_arcTo(self, oval, startAngleDeg, sweepAngleDeg, forceMoveTo)
    }
    #[inline]
    pub unsafe fn arcTo1(
        &mut self,
        p1: SkPoint,
        p2: SkPoint,
        radius: SkScalar,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_arcTo1(self, p1, p2, radius)
    }
    #[inline]
    pub unsafe fn arcTo2(
        &mut self,
        r: SkPoint,
        xAxisRotate: SkScalar,
        largeArc: SkPathBuilder_ArcSize,
        sweep: SkPathDirection,
        xy: SkPoint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_arcTo2(self, r, xAxisRotate, largeArc, sweep, xy)
    }
    #[inline]
    pub unsafe fn addArc(
        &mut self,
        oval: *const SkRect,
        startAngleDeg: SkScalar,
        sweepAngleDeg: SkScalar,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addArc(self, oval, startAngleDeg, sweepAngleDeg)
    }
    #[inline]
    pub unsafe fn addRect(
        &mut self,
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addRect(self, arg1, arg2, startIndex)
    }
    #[inline]
    pub unsafe fn addOval(
        &mut self,
        arg1: *const SkRect,
        arg2: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addOval(self, arg1, arg2, startIndex)
    }
    #[inline]
    pub unsafe fn addRRect(
        &mut self,
        rrect: *const SkRRect,
        arg1: SkPathDirection,
        start: ::core::ffi::c_uint,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addRRect(self, rrect, arg1, start)
    }
    #[inline]
    pub unsafe fn addCircle(
        &mut self,
        x: SkScalar,
        y: SkScalar,
        radius: SkScalar,
        dir: SkPathDirection,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addCircle(self, x, y, radius, dir)
    }
    #[inline]
    pub unsafe fn addPolygon(&mut self, pts: SkSpan<SkPoint>, close: bool) -> *mut SkPathBuilder {
        SkPathBuilder_addPolygon(self, pts, close)
    }
    #[inline]
    pub unsafe fn addPath(
        &mut self,
        src: *const SkPath,
        dx: SkScalar,
        dy: SkScalar,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addPath(self, src, dx, dy, mode)
    }
    #[inline]
    pub unsafe fn addPath1(
        &mut self,
        src: *const SkPath,
        matrix: *const SkMatrix,
        mode: SkPath_AddPathMode,
    ) -> *mut SkPathBuilder {
        SkPathBuilder_addPath1(self, src, matrix, mode)
    }
    #[inline]
    pub unsafe fn incReserve(
        &mut self,
        extraPtCount: ::core::ffi::c_int,
        extraVerbCount: ::core::ffi::c_int,
    ) {
        SkPathBuilder_incReserve(self, extraPtCount, extraVerbCount)
    }
    #[inline]
    pub unsafe fn offset(&mut self, dx: SkScalar, dy: SkScalar) -> *mut SkPathBuilder {
        SkPathBuilder_offset(self, dx, dy)
    }
    #[inline]
    pub unsafe fn transform(&mut self, matrix: *const SkMatrix) -> *mut SkPathBuilder {
        SkPathBuilder_transform(self, matrix)
    }
    #[inline]
    pub unsafe fn isFinite(&self) -> bool {
        SkPathBuilder_isFinite(self)
    }
    #[inline]
    pub unsafe fn getLastPt(&self) -> __BindgenOpaqueArray<u32, 3usize> {
        SkPathBuilder_getLastPt(self)
    }
    #[inline]
    pub unsafe fn setLastPt(&mut self, x: SkScalar, y: SkScalar) {
        SkPathBuilder_setLastPt(self, x, y)
    }
    #[inline]
    pub unsafe fn addRaw(&mut self, arg1: *const SkPathRaw) -> *mut SkPathBuilder {
        SkPathBuilder_addRaw(self, arg1)
    }
    #[inline]
    pub unsafe fn iter(&self) -> SkPathIter {
        SkPathBuilder_iter(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPathBuilder_SkPathBuilder(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(fillType: SkPathFillType) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPathBuilder_SkPathBuilder1(__bindgen_tmp.as_mut_ptr(), fillType);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(path: *const SkPath) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPathBuilder_SkPathBuilder2(__bindgen_tmp.as_mut_ptr(), path);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPathBuilder_SkPathBuilder_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkPathMeasure {
    pub fIter: SkContourMeasureIter,
    pub fContour: sk_sp<SkContourMeasure>,
}
pub const SkPathMeasure_MatrixFlags_kGetPosition_MatrixFlag: SkPathMeasure_MatrixFlags = 1;
pub const SkPathMeasure_MatrixFlags_kGetTangent_MatrixFlag: SkPathMeasure_MatrixFlags = 2;
pub const SkPathMeasure_MatrixFlags_kGetPosAndTan_MatrixFlag: SkPathMeasure_MatrixFlags = 3;
pub type SkPathMeasure_MatrixFlags = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathMeasure"][::core::mem::size_of::<SkPathMeasure>() - 16usize];
    ["Alignment of SkPathMeasure"][::core::mem::align_of::<SkPathMeasure>() - 8usize];
    ["Offset of field: SkPathMeasure::fIter"]
        [::core::mem::offset_of!(SkPathMeasure, fIter) - 0usize];
    ["Offset of field: SkPathMeasure::fContour"]
        [::core::mem::offset_of!(SkPathMeasure, fContour) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure7setPathEPK6SkPathb"]
    pub fn SkPathMeasure_setPath(this: *mut SkPathMeasure, arg1: *const SkPath, forceClosed: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure9getLengthEv"]
    pub fn SkPathMeasure_getLength(this: *mut SkPathMeasure) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure9getPosTanEfP7SkPointS1_"]
    pub fn SkPathMeasure_getPosTan(
        this: *mut SkPathMeasure,
        distance: SkScalar,
        position: *mut SkPoint,
        tangent: *mut SkVector,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure9getMatrixEfP8SkMatrixNS_11MatrixFlagsE"]
    pub fn SkPathMeasure_getMatrix(
        this: *mut SkPathMeasure,
        distance: SkScalar,
        matrix: *mut SkMatrix,
        flags: SkPathMeasure_MatrixFlags,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure10getSegmentEffP13SkPathBuilderb"]
    pub fn SkPathMeasure_getSegment(
        this: *mut SkPathMeasure,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPathBuilder,
        startWithMoveTo: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure10getSegmentEffP6SkPathb"]
    pub fn SkPathMeasure_getSegment1(
        this: *mut SkPathMeasure,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPath,
        startWithMoveTo: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure8isClosedEv"]
    pub fn SkPathMeasure_isClosed(this: *mut SkPathMeasure) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasure11nextContourEv"]
    pub fn SkPathMeasure_nextContour(this: *mut SkPathMeasure) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasureC1Ev"]
    pub fn SkPathMeasure_SkPathMeasure(this: *mut SkPathMeasure);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasureC1ERK6SkPathbf"]
    pub fn SkPathMeasure_SkPathMeasure1(
        this: *mut SkPathMeasure,
        path: *const SkPath,
        forceClosed: bool,
        resScale: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkPathMeasureD1Ev"]
    pub fn SkPathMeasure_SkPathMeasure_destructor(this: *mut SkPathMeasure);
}
impl SkPathMeasure {
    #[inline]
    pub unsafe fn setPath(&mut self, arg1: *const SkPath, forceClosed: bool) {
        SkPathMeasure_setPath(self, arg1, forceClosed)
    }
    #[inline]
    pub unsafe fn getLength(&mut self) -> SkScalar {
        SkPathMeasure_getLength(self)
    }
    #[inline]
    pub unsafe fn getPosTan(
        &mut self,
        distance: SkScalar,
        position: *mut SkPoint,
        tangent: *mut SkVector,
    ) -> bool {
        SkPathMeasure_getPosTan(self, distance, position, tangent)
    }
    #[inline]
    pub unsafe fn getMatrix(
        &mut self,
        distance: SkScalar,
        matrix: *mut SkMatrix,
        flags: SkPathMeasure_MatrixFlags,
    ) -> bool {
        SkPathMeasure_getMatrix(self, distance, matrix, flags)
    }
    #[inline]
    pub unsafe fn getSegment(
        &mut self,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPathBuilder,
        startWithMoveTo: bool,
    ) -> bool {
        SkPathMeasure_getSegment(self, startD, stopD, dst, startWithMoveTo)
    }
    #[inline]
    pub unsafe fn getSegment1(
        &mut self,
        startD: SkScalar,
        stopD: SkScalar,
        dst: *mut SkPath,
        startWithMoveTo: bool,
    ) -> bool {
        SkPathMeasure_getSegment1(self, startD, stopD, dst, startWithMoveTo)
    }
    #[inline]
    pub unsafe fn isClosed(&mut self) -> bool {
        SkPathMeasure_isClosed(self)
    }
    #[inline]
    pub unsafe fn nextContour(&mut self) -> bool {
        SkPathMeasure_nextContour(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPathMeasure_SkPathMeasure(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(path: *const SkPath, forceClosed: bool, resScale: SkScalar) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPathMeasure_SkPathMeasure1(__bindgen_tmp.as_mut_ptr(), path, forceClosed, resScale);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPathMeasure_SkPathMeasure_destructor(self)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkShader {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
pub type SkShader_INHERITED = SkFlattenable;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkShader"][::core::mem::size_of::<SkShader>() - 16usize];
    ["Alignment of SkShader"][::core::mem::align_of::<SkShader>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkShader8isAImageEP8SkMatrixP10SkTileMode"]
    pub fn SkShader_isAImage(
        this: *const SkShader,
        localMatrix: *mut SkMatrix,
        xy: *mut SkTileMode,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkShader19makeWithLocalMatrixERK8SkMatrix"]
    pub fn SkShader_makeWithLocalMatrix(
        this: *const SkShader,
        arg1: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkShader19makeWithColorFilterE5sk_spI13SkColorFilterE"]
    pub fn SkShader_makeWithColorFilter(
        this: *const SkShader,
        arg1: sk_sp<SkColorFilter>,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkShader25makeWithWorkingColorSpaceE5sk_spI12SkColorSpaceES2_"]
    pub fn SkShader_makeWithWorkingColorSpace(
        this: *const SkShader,
        inputCS: sk_sp<SkColorSpace>,
        outputCS: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkShader>;
}
impl SkShader {
    #[inline]
    pub unsafe fn isAImage(&self, localMatrix: *mut SkMatrix, xy: *mut SkTileMode) -> *mut SkImage {
        SkShader_isAImage(self, localMatrix, xy)
    }
    #[inline]
    pub unsafe fn makeWithLocalMatrix(&self, arg1: *const SkMatrix) -> sk_sp<SkShader> {
        SkShader_makeWithLocalMatrix(self, arg1)
    }
    #[inline]
    pub unsafe fn makeWithColorFilter(&self, arg1: sk_sp<SkColorFilter>) -> sk_sp<SkShader> {
        SkShader_makeWithColorFilter(self, arg1)
    }
    #[inline]
    pub unsafe fn makeWithWorkingColorSpace(
        &self,
        inputCS: sk_sp<SkColorSpace>,
        outputCS: sk_sp<SkColorSpace>,
    ) -> sk_sp<SkShader> {
        SkShader_makeWithWorkingColorSpace(self, inputCS, outputCS)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkPicture {
    pub _bindgen_opaque_blob: [u64; 3usize],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkPicture_AbortCallback {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPicture_AbortCallback"][::core::mem::size_of::<SkPicture_AbortCallback>() - 8usize];
    ["Alignment of SkPicture_AbortCallback"]
        [::core::mem::align_of::<SkPicture_AbortCallback>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPicture"][::core::mem::size_of::<SkPicture>() - 24usize];
    ["Alignment of SkPicture"][::core::mem::align_of::<SkPicture>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPicture14MakeFromStreamEP8SkStreamPK15SkDeserialProcs"]
    pub fn SkPicture_MakeFromStream(
        stream: *mut SkStream,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPicture12MakeFromDataEPK6SkDataPK15SkDeserialProcs"]
    pub fn SkPicture_MakeFromData(
        data: *const SkData,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPicture12MakeFromDataEPKvmPK15SkDeserialProcs"]
    pub fn SkPicture_MakeFromData1(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPicture9serializeEPK13SkSerialProcs"]
    pub fn SkPicture_serialize(
        this: *const SkPicture,
        procs: *const SkSerialProcs,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPicture9serializeEP9SkWStreamPK13SkSerialProcs"]
    pub fn SkPicture_serialize1(
        this: *const SkPicture,
        stream: *mut SkWStream,
        procs: *const SkSerialProcs,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPicture15MakePlaceholderE6SkRect"]
    pub fn SkPicture_MakePlaceholder(cull: SkRect) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPicture10makeShaderE10SkTileModeS0_12SkFilterModePK8SkMatrixPK6SkRect"]
    pub fn SkPicture_makeShader(
        this: *const SkPicture,
        tmx: SkTileMode,
        tmy: SkTileMode,
        mode: SkFilterMode,
        localMatrix: *const SkMatrix,
        tileRect: *const SkRect,
    ) -> sk_sp<SkShader>;
}
impl SkPicture {
    #[inline]
    pub unsafe fn MakeFromStream(
        stream: *mut SkStream,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture> {
        SkPicture_MakeFromStream(stream, procs)
    }
    #[inline]
    pub unsafe fn MakeFromData(
        data: *const SkData,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture> {
        SkPicture_MakeFromData(data, procs)
    }
    #[inline]
    pub unsafe fn MakeFromData1(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPicture> {
        SkPicture_MakeFromData1(data, size, procs)
    }
    #[inline]
    pub unsafe fn serialize(&self, procs: *const SkSerialProcs) -> sk_sp<SkData> {
        SkPicture_serialize(self, procs)
    }
    #[inline]
    pub unsafe fn serialize1(&self, stream: *mut SkWStream, procs: *const SkSerialProcs) {
        SkPicture_serialize1(self, stream, procs)
    }
    #[inline]
    pub unsafe fn MakePlaceholder(cull: SkRect) -> sk_sp<SkPicture> {
        SkPicture_MakePlaceholder(cull)
    }
    #[inline]
    pub unsafe fn makeShader(
        &self,
        tmx: SkTileMode,
        tmy: SkTileMode,
        mode: SkFilterMode,
        localMatrix: *const SkMatrix,
        tileRect: *const SkRect,
    ) -> sk_sp<SkShader> {
        SkPicture_makeShader(self, tmx, tmy, mode, localMatrix, tileRect)
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPictureD1Ev"]
    pub fn SkPicture_SkPicture_destructor(this: *mut SkPicture);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRecord {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRecordCanvas {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct SkPictureRecorder {
    pub fBBH: sk_sp<SkBBoxHierarchy>,
    pub fRecorder: u64,
    pub fRecord: sk_sp<SkRecord>,
    pub fCullRect: SkRect,
    pub fActivelyRecording: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPictureRecorder"][::core::mem::size_of::<SkPictureRecorder>() - 48usize];
    ["Alignment of SkPictureRecorder"][::core::mem::align_of::<SkPictureRecorder>() - 8usize];
    ["Offset of field: SkPictureRecorder::fBBH"]
        [::core::mem::offset_of!(SkPictureRecorder, fBBH) - 0usize];
    ["Offset of field: SkPictureRecorder::fRecorder"]
        [::core::mem::offset_of!(SkPictureRecorder, fRecorder) - 8usize];
    ["Offset of field: SkPictureRecorder::fRecord"]
        [::core::mem::offset_of!(SkPictureRecorder, fRecord) - 16usize];
    ["Offset of field: SkPictureRecorder::fCullRect"]
        [::core::mem::offset_of!(SkPictureRecorder, fCullRect) - 24usize];
    ["Offset of field: SkPictureRecorder::fActivelyRecording"]
        [::core::mem::offset_of!(SkPictureRecorder, fActivelyRecording) - 40usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder14beginRecordingERK6SkRect5sk_spI15SkBBoxHierarchyE"]
    pub fn SkPictureRecorder_beginRecording(
        this: *mut SkPictureRecorder,
        bounds: *const SkRect,
        bbh: sk_sp<SkBBoxHierarchy>,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder14beginRecordingERK6SkRectP12SkBBHFactory"]
    pub fn SkPictureRecorder_beginRecording1(
        this: *mut SkPictureRecorder,
        bounds: *const SkRect,
        bbhFactory: *mut SkBBHFactory,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder18getRecordingCanvasEv"]
    pub fn SkPictureRecorder_getRecordingCanvas(this: *mut SkPictureRecorder) -> *mut SkCanvas;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder24finishRecordingAsPictureEv"]
    pub fn SkPictureRecorder_finishRecordingAsPicture(
        this: *mut SkPictureRecorder,
    ) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder32finishRecordingAsPictureWithCullERK6SkRect"]
    pub fn SkPictureRecorder_finishRecordingAsPictureWithCull(
        this: *mut SkPictureRecorder,
        cullRect: *const SkRect,
    ) -> sk_sp<SkPicture>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorder25finishRecordingAsDrawableEv"]
    pub fn SkPictureRecorder_finishRecordingAsDrawable(
        this: *mut SkPictureRecorder,
    ) -> sk_sp<SkDrawable>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorderC1Ev"]
    pub fn SkPictureRecorder_SkPictureRecorder(this: *mut SkPictureRecorder);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkPictureRecorderD1Ev"]
    pub fn SkPictureRecorder_SkPictureRecorder_destructor(this: *mut SkPictureRecorder);
}
impl SkPictureRecorder {
    #[inline]
    pub unsafe fn beginRecording(
        &mut self,
        bounds: *const SkRect,
        bbh: sk_sp<SkBBoxHierarchy>,
    ) -> *mut SkCanvas {
        SkPictureRecorder_beginRecording(self, bounds, bbh)
    }
    #[inline]
    pub unsafe fn beginRecording1(
        &mut self,
        bounds: *const SkRect,
        bbhFactory: *mut SkBBHFactory,
    ) -> *mut SkCanvas {
        SkPictureRecorder_beginRecording1(self, bounds, bbhFactory)
    }
    #[inline]
    pub unsafe fn getRecordingCanvas(&mut self) -> *mut SkCanvas {
        SkPictureRecorder_getRecordingCanvas(self)
    }
    #[inline]
    pub unsafe fn finishRecordingAsPicture(&mut self) -> sk_sp<SkPicture> {
        SkPictureRecorder_finishRecordingAsPicture(self)
    }
    #[inline]
    pub unsafe fn finishRecordingAsPictureWithCull(
        &mut self,
        cullRect: *const SkRect,
    ) -> sk_sp<SkPicture> {
        SkPictureRecorder_finishRecordingAsPictureWithCull(self, cullRect)
    }
    #[inline]
    pub unsafe fn finishRecordingAsDrawable(&mut self) -> sk_sp<SkDrawable> {
        SkPictureRecorder_finishRecordingAsDrawable(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPictureRecorder_SkPictureRecorder(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPictureRecorder_SkPictureRecorder_destructor(self)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkPixelRef {
    pub _bindgen_opaque_blob: [u64; 12usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPixelRef_Mutability {
    kMutable = 0,
    kTemporarilyImmutable = 1,
    kImmutable = 2,
}
pub type SkPixelRef_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPixelRef"][::core::mem::size_of::<SkPixelRef>() - 96usize];
    ["Alignment of SkPixelRef"][::core::mem::align_of::<SkPixelRef>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkPixelRef15getGenerationIDEv"]
    pub fn SkPixelRef_getGenerationID(this: *const SkPixelRef) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRef19notifyPixelsChangedEv"]
    pub fn SkPixelRef_notifyPixelsChanged(this: *mut SkPixelRef);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRef12setImmutableEv"]
    pub fn SkPixelRef_setImmutable(this: *mut SkPixelRef);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRef22addGenIDChangeListenerE5sk_spI18SkIDChangeListenerE"]
    pub fn SkPixelRef_addGenIDChangeListener(
        this: *mut SkPixelRef,
        listener: sk_sp<SkIDChangeListener>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRef18android_only_resetEiim"]
    pub fn SkPixelRef_android_only_reset(
        this: *mut SkPixelRef,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        rowBytes: usize,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRefC1EiiPvm"]
    pub fn SkPixelRef_SkPixelRef(
        this: *mut SkPixelRef,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        addr: *mut ::core::ffi::c_void,
        rowBytes: usize,
    );
}
impl SkPixelRef {
    #[inline]
    pub unsafe fn getGenerationID(&self) -> u32 {
        SkPixelRef_getGenerationID(self)
    }
    #[inline]
    pub unsafe fn notifyPixelsChanged(&mut self) {
        SkPixelRef_notifyPixelsChanged(self)
    }
    #[inline]
    pub unsafe fn setImmutable(&mut self) {
        SkPixelRef_setImmutable(self)
    }
    #[inline]
    pub unsafe fn addGenIDChangeListener(&mut self, listener: sk_sp<SkIDChangeListener>) {
        SkPixelRef_addGenIDChangeListener(self, listener)
    }
    #[inline]
    pub unsafe fn android_only_reset(
        &mut self,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        rowBytes: usize,
    ) {
        SkPixelRef_android_only_reset(self, width, height, rowBytes)
    }
    #[inline]
    pub unsafe fn new(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        addr: *mut ::core::ffi::c_void,
        rowBytes: usize,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPixelRef_SkPixelRef(__bindgen_tmp.as_mut_ptr(), width, height, addr, rowBytes);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkPixelRefD1Ev"]
    pub fn SkPixelRef_SkPixelRef_destructor(this: *mut SkPixelRef);
}
#[repr(C)]
#[derive(Debug)]
pub struct SkRegion {
    pub fBounds: SkIRect,
    pub fRunHead: *mut SkRegion_RunHead,
}
pub type SkRegion_RunType = i32;
impl SkRegion_Op {
    pub const LastOp: SkRegion_Op = SkRegion_Op::Replace;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRegion_Op {
    Difference = 0,
    Intersect = 1,
    Union = 2,
    XOR = 3,
    ReverseDifference = 4,
    Replace = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRegion_Iterator {
    pub fRgn: *const SkRegion,
    pub fRuns: *const SkRegion_RunType,
    pub fRect: SkIRect,
    pub fDone: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRegion_Iterator"][::core::mem::size_of::<SkRegion_Iterator>() - 40usize];
    ["Alignment of SkRegion_Iterator"][::core::mem::align_of::<SkRegion_Iterator>() - 8usize];
    ["Offset of field: SkRegion_Iterator::fRgn"]
        [::core::mem::offset_of!(SkRegion_Iterator, fRgn) - 0usize];
    ["Offset of field: SkRegion_Iterator::fRuns"]
        [::core::mem::offset_of!(SkRegion_Iterator, fRuns) - 8usize];
    ["Offset of field: SkRegion_Iterator::fRect"]
        [::core::mem::offset_of!(SkRegion_Iterator, fRect) - 16usize];
    ["Offset of field: SkRegion_Iterator::fDone"]
        [::core::mem::offset_of!(SkRegion_Iterator, fDone) - 32usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8Iterator6rewindEv"]
    pub fn SkRegion_Iterator_rewind(this: *mut SkRegion_Iterator) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8Iterator5resetERKS_"]
    pub fn SkRegion_Iterator_reset(this: *mut SkRegion_Iterator, region: *const SkRegion);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8Iterator4nextEv"]
    pub fn SkRegion_Iterator_next(this: *mut SkRegion_Iterator);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8IteratorC1ERKS_"]
    pub fn SkRegion_Iterator_Iterator(this: *mut SkRegion_Iterator, region: *const SkRegion);
}
impl SkRegion_Iterator {
    #[inline]
    pub unsafe fn rewind(&mut self) -> bool {
        SkRegion_Iterator_rewind(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self, region: *const SkRegion) {
        SkRegion_Iterator_reset(self, region)
    }
    #[inline]
    pub unsafe fn next(&mut self) {
        SkRegion_Iterator_next(self)
    }
    #[inline]
    pub unsafe fn new(region: *const SkRegion) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_Iterator_Iterator(__bindgen_tmp.as_mut_ptr(), region);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRegion_Cliperator {
    pub fIter: SkRegion_Iterator,
    pub fClip: SkIRect,
    pub fRect: SkIRect,
    pub fDone: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRegion_Cliperator"][::core::mem::size_of::<SkRegion_Cliperator>() - 80usize];
    ["Alignment of SkRegion_Cliperator"][::core::mem::align_of::<SkRegion_Cliperator>() - 8usize];
    ["Offset of field: SkRegion_Cliperator::fIter"]
        [::core::mem::offset_of!(SkRegion_Cliperator, fIter) - 0usize];
    ["Offset of field: SkRegion_Cliperator::fClip"]
        [::core::mem::offset_of!(SkRegion_Cliperator, fClip) - 40usize];
    ["Offset of field: SkRegion_Cliperator::fRect"]
        [::core::mem::offset_of!(SkRegion_Cliperator, fRect) - 56usize];
    ["Offset of field: SkRegion_Cliperator::fDone"]
        [::core::mem::offset_of!(SkRegion_Cliperator, fDone) - 72usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion10Cliperator4nextEv"]
    pub fn SkRegion_Cliperator_next(this: *mut SkRegion_Cliperator);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion10CliperatorC1ERKS_RK7SkIRect"]
    pub fn SkRegion_Cliperator_Cliperator(
        this: *mut SkRegion_Cliperator,
        region: *const SkRegion,
        clip: *const SkIRect,
    );
}
impl SkRegion_Cliperator {
    #[inline]
    pub unsafe fn next(&mut self) {
        SkRegion_Cliperator_next(self)
    }
    #[inline]
    pub unsafe fn new(region: *const SkRegion, clip: *const SkIRect) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_Cliperator_Cliperator(__bindgen_tmp.as_mut_ptr(), region, clip);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRegion_Spanerator {
    pub fRuns: *const SkRegion_RunType,
    pub fLeft: ::core::ffi::c_int,
    pub fRight: ::core::ffi::c_int,
    pub fDone: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRegion_Spanerator"][::core::mem::size_of::<SkRegion_Spanerator>() - 24usize];
    ["Alignment of SkRegion_Spanerator"][::core::mem::align_of::<SkRegion_Spanerator>() - 8usize];
    ["Offset of field: SkRegion_Spanerator::fRuns"]
        [::core::mem::offset_of!(SkRegion_Spanerator, fRuns) - 0usize];
    ["Offset of field: SkRegion_Spanerator::fLeft"]
        [::core::mem::offset_of!(SkRegion_Spanerator, fLeft) - 8usize];
    ["Offset of field: SkRegion_Spanerator::fRight"]
        [::core::mem::offset_of!(SkRegion_Spanerator, fRight) - 12usize];
    ["Offset of field: SkRegion_Spanerator::fDone"]
        [::core::mem::offset_of!(SkRegion_Spanerator, fDone) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion10Spanerator4nextEPiS1_"]
    pub fn SkRegion_Spanerator_next(
        this: *mut SkRegion_Spanerator,
        left: *mut ::core::ffi::c_int,
        right: *mut ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion10SpaneratorC1ERKS_iii"]
    pub fn SkRegion_Spanerator_Spanerator(
        this: *mut SkRegion_Spanerator,
        region: *const SkRegion,
        y: ::core::ffi::c_int,
        left: ::core::ffi::c_int,
        right: ::core::ffi::c_int,
    );
}
impl SkRegion_Spanerator {
    #[inline]
    pub unsafe fn next(
        &mut self,
        left: *mut ::core::ffi::c_int,
        right: *mut ::core::ffi::c_int,
    ) -> bool {
        SkRegion_Spanerator_next(self, left, right)
    }
    #[inline]
    pub unsafe fn new(
        region: *const SkRegion,
        y: ::core::ffi::c_int,
        left: ::core::ffi::c_int,
        right: ::core::ffi::c_int,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_Spanerator_Spanerator(__bindgen_tmp.as_mut_ptr(), region, y, left, right);
        __bindgen_tmp.assume_init()
    }
}
pub type SkRegion_sk_is_trivially_relocatable = std_true_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRegion_RunHead {
    _unused: [u8; 0],
}
pub const SkRegion_kOpCnt: ::core::ffi::c_int = 6;
pub const SkRegion_kOpCount: ::core::ffi::c_int = 6;
pub const SkRegion_kRectRegionRuns: ::core::ffi::c_int = 7;
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion15kRectRunHeadPtrE"]
    pub static SkRegion_kRectRunHeadPtr: *const SkRegion_RunHead;
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRegion"][::core::mem::size_of::<SkRegion>() - 24usize];
    ["Alignment of SkRegion"][::core::mem::align_of::<SkRegion>() - 8usize];
    ["Offset of field: SkRegion::fBounds"][::core::mem::offset_of!(SkRegion, fBounds) - 0usize];
    ["Offset of field: SkRegion::fRunHead"][::core::mem::offset_of!(SkRegion, fRunHead) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion4swapERS_"]
    pub fn SkRegion_swap(this: *mut SkRegion, other: *mut SkRegion);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion23computeRegionComplexityEv"]
    pub fn SkRegion_computeRegionComplexity(this: *const SkRegion) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion15addBoundaryPathEP13SkPathBuilder"]
    pub fn SkRegion_addBoundaryPath(this: *const SkRegion, arg1: *mut SkPathBuilder) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion15getBoundaryPathEv"]
    pub fn SkRegion_getBoundaryPath(this: *const SkRegion) -> SkPath;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion15getBoundaryPathEP6SkPath"]
    pub fn SkRegion_getBoundaryPath1(this: *const SkRegion, path: *mut SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8setEmptyEv"]
    pub fn SkRegion_setEmpty(this: *mut SkRegion) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion7setRectERK7SkIRect"]
    pub fn SkRegion_setRect(this: *mut SkRegion, rect: *const SkIRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion8setRectsEPK7SkIRecti"]
    pub fn SkRegion_setRects(
        this: *mut SkRegion,
        rects: *const SkIRect,
        count: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion9setRegionERKS_"]
    pub fn SkRegion_setRegion(this: *mut SkRegion, region: *const SkRegion) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion7setPathERK6SkPathRKS_"]
    pub fn SkRegion_setPath(
        this: *mut SkRegion,
        path: *const SkPath,
        clip: *const SkRegion,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion10intersectsERK7SkIRect"]
    pub fn SkRegion_intersects(this: *const SkRegion, rect: *const SkIRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion10intersectsERKS_"]
    pub fn SkRegion_intersects1(this: *const SkRegion, other: *const SkRegion) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion8containsEii"]
    pub fn SkRegion_contains(this: *const SkRegion, x: i32, y: i32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion8containsERK7SkIRect"]
    pub fn SkRegion_contains1(this: *const SkRegion, other: *const SkIRect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion8containsERKS_"]
    pub fn SkRegion_contains2(this: *const SkRegion, other: *const SkRegion) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion9translateEiiPS_"]
    pub fn SkRegion_translate(
        this: *const SkRegion,
        dx: ::core::ffi::c_int,
        dy: ::core::ffi::c_int,
        dst: *mut SkRegion,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion2opERK7SkIRectRKS_NS_2OpE"]
    pub fn SkRegion_op(
        this: *mut SkRegion,
        rect: *const SkIRect,
        rgn: *const SkRegion,
        op: SkRegion_Op,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion2opERKS_RK7SkIRectNS_2OpE"]
    pub fn SkRegion_op1(
        this: *mut SkRegion,
        rgn: *const SkRegion,
        rect: *const SkIRect,
        op: SkRegion_Op,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion2opERKS_S1_NS_2OpE"]
    pub fn SkRegion_op2(
        this: *mut SkRegion,
        rgna: *const SkRegion,
        rgnb: *const SkRegion,
        op: SkRegion_Op,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8SkRegion13writeToMemoryEPv"]
    pub fn SkRegion_writeToMemory(this: *const SkRegion, buffer: *mut ::core::ffi::c_void)
    -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegion14readFromMemoryEPKvm"]
    pub fn SkRegion_readFromMemory(
        this: *mut SkRegion,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegionC1Ev"]
    pub fn SkRegion_SkRegion(this: *mut SkRegion);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegionC1ERKS_"]
    pub fn SkRegion_SkRegion1(this: *mut SkRegion, region: *const SkRegion);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegionC1ERK7SkIRect"]
    pub fn SkRegion_SkRegion2(this: *mut SkRegion, rect: *const SkIRect);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkRegionD1Ev"]
    pub fn SkRegion_SkRegion_destructor(this: *mut SkRegion);
}
impl SkRegion {
    #[inline]
    pub unsafe fn swap(&mut self, other: *mut SkRegion) {
        SkRegion_swap(self, other)
    }
    #[inline]
    pub unsafe fn computeRegionComplexity(&self) -> ::core::ffi::c_int {
        SkRegion_computeRegionComplexity(self)
    }
    #[inline]
    pub unsafe fn addBoundaryPath(&self, arg1: *mut SkPathBuilder) -> bool {
        SkRegion_addBoundaryPath(self, arg1)
    }
    #[inline]
    pub unsafe fn getBoundaryPath(&self) -> SkPath {
        SkRegion_getBoundaryPath(self)
    }
    #[inline]
    pub unsafe fn getBoundaryPath1(&self, path: *mut SkPath) -> bool {
        SkRegion_getBoundaryPath1(self, path)
    }
    #[inline]
    pub unsafe fn setEmpty(&mut self) -> bool {
        SkRegion_setEmpty(self)
    }
    #[inline]
    pub unsafe fn setRect(&mut self, rect: *const SkIRect) -> bool {
        SkRegion_setRect(self, rect)
    }
    #[inline]
    pub unsafe fn setRects(&mut self, rects: *const SkIRect, count: ::core::ffi::c_int) -> bool {
        SkRegion_setRects(self, rects, count)
    }
    #[inline]
    pub unsafe fn setRegion(&mut self, region: *const SkRegion) -> bool {
        SkRegion_setRegion(self, region)
    }
    #[inline]
    pub unsafe fn setPath(&mut self, path: *const SkPath, clip: *const SkRegion) -> bool {
        SkRegion_setPath(self, path, clip)
    }
    #[inline]
    pub unsafe fn intersects(&self, rect: *const SkIRect) -> bool {
        SkRegion_intersects(self, rect)
    }
    #[inline]
    pub unsafe fn intersects1(&self, other: *const SkRegion) -> bool {
        SkRegion_intersects1(self, other)
    }
    #[inline]
    pub unsafe fn contains(&self, x: i32, y: i32) -> bool {
        SkRegion_contains(self, x, y)
    }
    #[inline]
    pub unsafe fn contains1(&self, other: *const SkIRect) -> bool {
        SkRegion_contains1(self, other)
    }
    #[inline]
    pub unsafe fn contains2(&self, other: *const SkRegion) -> bool {
        SkRegion_contains2(self, other)
    }
    #[inline]
    pub unsafe fn translate(
        &self,
        dx: ::core::ffi::c_int,
        dy: ::core::ffi::c_int,
        dst: *mut SkRegion,
    ) {
        SkRegion_translate(self, dx, dy, dst)
    }
    #[inline]
    pub unsafe fn op(
        &mut self,
        rect: *const SkIRect,
        rgn: *const SkRegion,
        op: SkRegion_Op,
    ) -> bool {
        SkRegion_op(self, rect, rgn, op)
    }
    #[inline]
    pub unsafe fn op1(
        &mut self,
        rgn: *const SkRegion,
        rect: *const SkIRect,
        op: SkRegion_Op,
    ) -> bool {
        SkRegion_op1(self, rgn, rect, op)
    }
    #[inline]
    pub unsafe fn op2(
        &mut self,
        rgna: *const SkRegion,
        rgnb: *const SkRegion,
        op: SkRegion_Op,
    ) -> bool {
        SkRegion_op2(self, rgna, rgnb, op)
    }
    #[inline]
    pub unsafe fn writeToMemory(&self, buffer: *mut ::core::ffi::c_void) -> usize {
        SkRegion_writeToMemory(self, buffer)
    }
    #[inline]
    pub unsafe fn readFromMemory(
        &mut self,
        buffer: *const ::core::ffi::c_void,
        length: usize,
    ) -> usize {
        SkRegion_readFromMemory(self, buffer, length)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_SkRegion(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(region: *const SkRegion) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_SkRegion1(__bindgen_tmp.as_mut_ptr(), region);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(rect: *const SkIRect) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRegion_SkRegion2(__bindgen_tmp.as_mut_ptr(), rect);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkRegion_SkRegion_destructor(self)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkStream {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkStream"][::core::mem::size_of::<SkStream>() - 8usize];
    ["Alignment of SkStream"][::core::mem::align_of::<SkStream>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream12MakeFromFileEPKc"]
    pub fn SkStream_MakeFromFile(path: *const ::core::ffi::c_char) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream6readS8EPa"]
    pub fn SkStream_readS8(this: *mut SkStream, arg1: *mut i8) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream7readS16EPs"]
    pub fn SkStream_readS16(this: *mut SkStream, arg1: *mut i16) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream7readS32EPi"]
    pub fn SkStream_readS32(this: *mut SkStream, arg1: *mut i32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream7readS64EPl"]
    pub fn SkStream_readS64(this: *mut SkStream, arg1: *mut i64) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream10readScalarEPf"]
    pub fn SkStream_readScalar(this: *mut SkStream, arg1: *mut SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8SkStream14readPackedUIntEPm"]
    pub fn SkStream_readPackedUInt(this: *mut SkStream, arg1: *mut usize) -> bool;
}
impl SkStream {
    #[inline]
    pub unsafe fn MakeFromFile(path: *const ::core::ffi::c_char) -> u64 {
        SkStream_MakeFromFile(path)
    }
    #[inline]
    pub unsafe fn readS8(&mut self, arg1: *mut i8) -> bool {
        SkStream_readS8(self, arg1)
    }
    #[inline]
    pub unsafe fn readS16(&mut self, arg1: *mut i16) -> bool {
        SkStream_readS16(self, arg1)
    }
    #[inline]
    pub unsafe fn readS32(&mut self, arg1: *mut i32) -> bool {
        SkStream_readS32(self, arg1)
    }
    #[inline]
    pub unsafe fn readS64(&mut self, arg1: *mut i64) -> bool {
        SkStream_readS64(self, arg1)
    }
    #[inline]
    pub unsafe fn readScalar(&mut self, arg1: *mut SkScalar) -> bool {
        SkStream_readScalar(self, arg1)
    }
    #[inline]
    pub unsafe fn readPackedUInt(&mut self, arg1: *mut usize) -> bool {
        SkStream_readPackedUInt(self, arg1)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkStreamAsset {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkStreamAsset"][::core::mem::size_of::<SkStreamAsset>() - 8usize];
    ["Alignment of SkStreamAsset"][::core::mem::align_of::<SkStreamAsset>() - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkStreamMemory {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkStreamMemory"][::core::mem::size_of::<SkStreamMemory>() - 8usize];
    ["Alignment of SkStreamMemory"][::core::mem::align_of::<SkStreamMemory>() - 8usize];
};
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkWStream {
    pub _bindgen_opaque_blob: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkWStream"][::core::mem::size_of::<SkWStream>() - 8usize];
    ["Alignment of SkWStream"][::core::mem::align_of::<SkWStream>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream14writeDecAsTextEi"]
    pub fn SkWStream_writeDecAsText(this: *mut SkWStream, arg1: i32) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream17writeBigDecAsTextEli"]
    pub fn SkWStream_writeBigDecAsText(
        this: *mut SkWStream,
        arg1: i64,
        minDigits: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream14writeHexAsTextEji"]
    pub fn SkWStream_writeHexAsText(
        this: *mut SkWStream,
        arg1: u32,
        minDigits: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream17writeScalarAsTextEf"]
    pub fn SkWStream_writeScalarAsText(this: *mut SkWStream, arg1: SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream11writeScalarEf"]
    pub fn SkWStream_writeScalar(this: *mut SkWStream, arg1: SkScalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream15writePackedUIntEm"]
    pub fn SkWStream_writePackedUInt(this: *mut SkWStream, arg1: usize) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream11writeStreamEP8SkStreamm"]
    pub fn SkWStream_writeStream(this: *mut SkWStream, input: *mut SkStream, length: usize)
    -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream16SizeOfPackedUIntEm"]
    pub fn SkWStream_SizeOfPackedUInt(value: usize) -> ::core::ffi::c_int;
}
impl SkWStream {
    #[inline]
    pub unsafe fn writeDecAsText(&mut self, arg1: i32) -> bool {
        SkWStream_writeDecAsText(self, arg1)
    }
    #[inline]
    pub unsafe fn writeBigDecAsText(&mut self, arg1: i64, minDigits: ::core::ffi::c_int) -> bool {
        SkWStream_writeBigDecAsText(self, arg1, minDigits)
    }
    #[inline]
    pub unsafe fn writeHexAsText(&mut self, arg1: u32, minDigits: ::core::ffi::c_int) -> bool {
        SkWStream_writeHexAsText(self, arg1, minDigits)
    }
    #[inline]
    pub unsafe fn writeScalarAsText(&mut self, arg1: SkScalar) -> bool {
        SkWStream_writeScalarAsText(self, arg1)
    }
    #[inline]
    pub unsafe fn writeScalar(&mut self, arg1: SkScalar) -> bool {
        SkWStream_writeScalar(self, arg1)
    }
    #[inline]
    pub unsafe fn writePackedUInt(&mut self, arg1: usize) -> bool {
        SkWStream_writePackedUInt(self, arg1)
    }
    #[inline]
    pub unsafe fn writeStream(&mut self, input: *mut SkStream, length: usize) -> bool {
        SkWStream_writeStream(self, input, length)
    }
    #[inline]
    pub unsafe fn SizeOfPackedUInt(value: usize) -> ::core::ffi::c_int {
        SkWStream_SizeOfPackedUInt(value)
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStreamD1Ev"]
    pub fn SkWStream_SkWStream_destructor(this: *mut SkWStream);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkWStream5flushEv"]
    pub fn SkWStream_flush(this: *mut ::core::ffi::c_void);
}
#[repr(C)]
#[derive(Debug)]
pub struct SkMemoryStream {
    pub _base: SkStreamMemory,
    pub fData: sk_sp<SkData>,
    pub fOffset: usize,
}
pub type SkMemoryStream_INHERITED = SkStreamMemory;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkMemoryStream"][::core::mem::size_of::<SkMemoryStream>() - 24usize];
    ["Alignment of SkMemoryStream"][::core::mem::align_of::<SkMemoryStream>() - 8usize];
    ["Offset of field: SkMemoryStream::fData"]
        [::core::mem::offset_of!(SkMemoryStream, fData) - 8usize];
    ["Offset of field: SkMemoryStream::fOffset"]
        [::core::mem::offset_of!(SkMemoryStream, fOffset) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream8MakeCopyEPKvm"]
    pub fn SkMemoryStream_MakeCopy(data: *const ::core::ffi::c_void, length: usize) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream10MakeDirectEPKvm"]
    pub fn SkMemoryStream_MakeDirect(data: *const ::core::ffi::c_void, length: usize) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream4MakeE5sk_spI6SkDataE"]
    pub fn SkMemoryStream_Make(data: sk_sp<SkData>) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream14setMemoryOwnedEPKvm"]
    pub fn SkMemoryStream_setMemoryOwned(
        this: *mut SkMemoryStream,
        data: *const ::core::ffi::c_void,
        length: usize,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream7setDataE5sk_spI6SkDataE"]
    pub fn SkMemoryStream_setData(this: *mut SkMemoryStream, data: sk_sp<SkData>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream8getAtPosEv"]
    pub fn SkMemoryStream_getAtPos(this: *mut SkMemoryStream) -> *const ::core::ffi::c_void;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStreamC1Ev"]
    pub fn SkMemoryStream_SkMemoryStream(this: *mut SkMemoryStream);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStreamC1Em"]
    pub fn SkMemoryStream_SkMemoryStream1(this: *mut SkMemoryStream, length: usize);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStreamC1EPKvmb"]
    pub fn SkMemoryStream_SkMemoryStream2(
        this: *mut SkMemoryStream,
        data: *const ::core::ffi::c_void,
        length: usize,
        copyData: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStreamC1E5sk_spI6SkDataE"]
    pub fn SkMemoryStream_SkMemoryStream3(this: *mut SkMemoryStream, data: sk_sp<SkData>);
}
impl SkMemoryStream {
    #[inline]
    pub unsafe fn MakeCopy(data: *const ::core::ffi::c_void, length: usize) -> u64 {
        SkMemoryStream_MakeCopy(data, length)
    }
    #[inline]
    pub unsafe fn MakeDirect(data: *const ::core::ffi::c_void, length: usize) -> u64 {
        SkMemoryStream_MakeDirect(data, length)
    }
    #[inline]
    pub unsafe fn Make(data: sk_sp<SkData>) -> u64 {
        SkMemoryStream_Make(data)
    }
    #[inline]
    pub unsafe fn setMemoryOwned(&mut self, data: *const ::core::ffi::c_void, length: usize) {
        SkMemoryStream_setMemoryOwned(self, data, length)
    }
    #[inline]
    pub unsafe fn setData(&mut self, data: sk_sp<SkData>) {
        SkMemoryStream_setData(self, data)
    }
    #[inline]
    pub unsafe fn getAtPos(&mut self) -> *const ::core::ffi::c_void {
        SkMemoryStream_getAtPos(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkMemoryStream_SkMemoryStream(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(length: usize) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkMemoryStream_SkMemoryStream1(__bindgen_tmp.as_mut_ptr(), length);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(data: *const ::core::ffi::c_void, length: usize, copyData: bool) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkMemoryStream_SkMemoryStream2(__bindgen_tmp.as_mut_ptr(), data, length, copyData);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(data: sk_sp<SkData>) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkMemoryStream_SkMemoryStream3(__bindgen_tmp.as_mut_ptr(), data);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream9setMemoryEPKvmb"]
    pub fn SkMemoryStream_setMemory(
        this: *mut ::core::ffi::c_void,
        data: *const ::core::ffi::c_void,
        length: usize,
        copyData: bool,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream4readEPvm"]
    pub fn SkMemoryStream_read(
        this: *mut ::core::ffi::c_void,
        buffer: *mut ::core::ffi::c_void,
        size: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK14SkMemoryStream7isAtEndEv"]
    pub fn SkMemoryStream_isAtEnd(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK14SkMemoryStream4peekEPvm"]
    pub fn SkMemoryStream_peek(
        this: *mut ::core::ffi::c_void,
        buffer: *mut ::core::ffi::c_void,
        size: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream6rewindEv"]
    pub fn SkMemoryStream_rewind(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK14SkMemoryStream11getPositionEv"]
    pub fn SkMemoryStream_getPosition(this: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream4seekEm"]
    pub fn SkMemoryStream_seek(this: *mut ::core::ffi::c_void, position: usize) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream4moveEl"]
    pub fn SkMemoryStream_move(this: *mut ::core::ffi::c_void, offset: ::core::ffi::c_long)
    -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK14SkMemoryStream9getLengthEv"]
    pub fn SkMemoryStream_getLength(this: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN14SkMemoryStream13getMemoryBaseEv"]
    pub fn SkMemoryStream_getMemoryBase(
        this: *mut ::core::ffi::c_void,
    ) -> *const ::core::ffi::c_void;
}
#[repr(C)]
#[derive(Debug)]
pub struct SkDynamicMemoryWStream {
    pub _base: SkWStream,
    pub fHead: *mut SkDynamicMemoryWStream_Block,
    pub fTail: *mut SkDynamicMemoryWStream_Block,
    pub fBytesWrittenBeforeTail: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkDynamicMemoryWStream_Block {
    _unused: [u8; 0],
}
pub type SkDynamicMemoryWStream_INHERITED = SkWStream;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkDynamicMemoryWStream"][::core::mem::size_of::<SkDynamicMemoryWStream>() - 32usize];
    ["Alignment of SkDynamicMemoryWStream"]
        [::core::mem::align_of::<SkDynamicMemoryWStream>() - 8usize];
    ["Offset of field: SkDynamicMemoryWStream::fHead"]
        [::core::mem::offset_of!(SkDynamicMemoryWStream, fHead) - 8usize];
    ["Offset of field: SkDynamicMemoryWStream::fTail"]
        [::core::mem::offset_of!(SkDynamicMemoryWStream, fTail) - 16usize];
    ["Offset of field: SkDynamicMemoryWStream::fBytesWrittenBeforeTail"]
        [::core::mem::offset_of!(SkDynamicMemoryWStream, fBytesWrittenBeforeTail) - 24usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream4readEPvmm"]
    pub fn SkDynamicMemoryWStream_read(
        this: *mut SkDynamicMemoryWStream,
        buffer: *mut ::core::ffi::c_void,
        offset: usize,
        size: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkDynamicMemoryWStream6copyToEPv"]
    pub fn SkDynamicMemoryWStream_copyTo(
        this: *const SkDynamicMemoryWStream,
        dst: *mut ::core::ffi::c_void,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkDynamicMemoryWStream13writeToStreamEP9SkWStream"]
    pub fn SkDynamicMemoryWStream_writeToStream(
        this: *const SkDynamicMemoryWStream,
        dst: *mut SkWStream,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream14copyToAndResetEPv"]
    pub fn SkDynamicMemoryWStream_copyToAndReset(
        this: *mut SkDynamicMemoryWStream,
        dst: *mut ::core::ffi::c_void,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream15writeToAndResetEP9SkWStream"]
    pub fn SkDynamicMemoryWStream_writeToAndReset(
        this: *mut SkDynamicMemoryWStream,
        dst: *mut SkWStream,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream15writeToAndResetEPS_"]
    pub fn SkDynamicMemoryWStream_writeToAndReset1(
        this: *mut SkDynamicMemoryWStream,
        dst: *mut SkDynamicMemoryWStream,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream17prependToAndResetEPS_"]
    pub fn SkDynamicMemoryWStream_prependToAndReset(
        this: *mut SkDynamicMemoryWStream,
        dst: *mut SkDynamicMemoryWStream,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream12detachAsDataEv"]
    pub fn SkDynamicMemoryWStream_detachAsData(this: *mut SkDynamicMemoryWStream) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream14detachAsStreamEv"]
    pub fn SkDynamicMemoryWStream_detachAsStream(this: *mut SkDynamicMemoryWStream) -> u64;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream5resetEv"]
    pub fn SkDynamicMemoryWStream_reset(this: *mut SkDynamicMemoryWStream);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream11padToAlign4Ev"]
    pub fn SkDynamicMemoryWStream_padToAlign4(this: *mut SkDynamicMemoryWStream);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStreamC1EOS_"]
    pub fn SkDynamicMemoryWStream_SkDynamicMemoryWStream(
        this: *mut SkDynamicMemoryWStream,
        arg1: *mut SkDynamicMemoryWStream,
    );
}
impl SkDynamicMemoryWStream {
    #[inline]
    pub unsafe fn read(
        &mut self,
        buffer: *mut ::core::ffi::c_void,
        offset: usize,
        size: usize,
    ) -> bool {
        SkDynamicMemoryWStream_read(self, buffer, offset, size)
    }
    #[inline]
    pub unsafe fn copyTo(&self, dst: *mut ::core::ffi::c_void) {
        SkDynamicMemoryWStream_copyTo(self, dst)
    }
    #[inline]
    pub unsafe fn writeToStream(&self, dst: *mut SkWStream) -> bool {
        SkDynamicMemoryWStream_writeToStream(self, dst)
    }
    #[inline]
    pub unsafe fn copyToAndReset(&mut self, dst: *mut ::core::ffi::c_void) {
        SkDynamicMemoryWStream_copyToAndReset(self, dst)
    }
    #[inline]
    pub unsafe fn writeToAndReset(&mut self, dst: *mut SkWStream) -> bool {
        SkDynamicMemoryWStream_writeToAndReset(self, dst)
    }
    #[inline]
    pub unsafe fn writeToAndReset1(&mut self, dst: *mut SkDynamicMemoryWStream) -> bool {
        SkDynamicMemoryWStream_writeToAndReset1(self, dst)
    }
    #[inline]
    pub unsafe fn prependToAndReset(&mut self, dst: *mut SkDynamicMemoryWStream) {
        SkDynamicMemoryWStream_prependToAndReset(self, dst)
    }
    #[inline]
    pub unsafe fn detachAsData(&mut self) -> sk_sp<SkData> {
        SkDynamicMemoryWStream_detachAsData(self)
    }
    #[inline]
    pub unsafe fn detachAsStream(&mut self) -> u64 {
        SkDynamicMemoryWStream_detachAsStream(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkDynamicMemoryWStream_reset(self)
    }
    #[inline]
    pub unsafe fn padToAlign4(&mut self) {
        SkDynamicMemoryWStream_padToAlign4(self)
    }
    #[inline]
    pub unsafe fn new(arg1: *mut SkDynamicMemoryWStream) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkDynamicMemoryWStream_SkDynamicMemoryWStream(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStreamD1Ev"]
    pub fn SkDynamicMemoryWStream_SkDynamicMemoryWStream_destructor(
        this: *mut SkDynamicMemoryWStream,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN22SkDynamicMemoryWStream5writeEPKvm"]
    pub fn SkDynamicMemoryWStream_write(
        this: *mut ::core::ffi::c_void,
        buffer: *const ::core::ffi::c_void,
        size: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkDynamicMemoryWStream12bytesWrittenEv"]
    pub fn SkDynamicMemoryWStream_bytesWritten(this: *mut ::core::ffi::c_void) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkStrokeRec {
    pub fResScale: SkScalar,
    pub fWidth: SkScalar,
    pub fMiterLimit: SkScalar,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkStrokeRec_InitStyle {
    Hairline = 0,
    Fill = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkStrokeRec_Style {
    Hairline = 0,
    Fill = 1,
    Stroke = 2,
    StrokeAndFill = 3,
}
pub const SkStrokeRec_kStyleCount: ::core::ffi::c_int = 4;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkStrokeRec"][::core::mem::size_of::<SkStrokeRec>() - 16usize];
    ["Alignment of SkStrokeRec"][::core::mem::align_of::<SkStrokeRec>() - 4usize];
    ["Offset of field: SkStrokeRec::fResScale"]
        [::core::mem::offset_of!(SkStrokeRec, fResScale) - 0usize];
    ["Offset of field: SkStrokeRec::fWidth"][::core::mem::offset_of!(SkStrokeRec, fWidth) - 4usize];
    ["Offset of field: SkStrokeRec::fMiterLimit"]
        [::core::mem::offset_of!(SkStrokeRec, fMiterLimit) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkStrokeRec8getStyleEv"]
    pub fn SkStrokeRec_getStyle(this: *const SkStrokeRec) -> SkStrokeRec_Style;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRec12setFillStyleEv"]
    pub fn SkStrokeRec_setFillStyle(this: *mut SkStrokeRec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRec16setHairlineStyleEv"]
    pub fn SkStrokeRec_setHairlineStyle(this: *mut SkStrokeRec);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRec14setStrokeStyleEfb"]
    pub fn SkStrokeRec_setStrokeStyle(this: *mut SkStrokeRec, width: SkScalar, strokeAndFill: bool);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkStrokeRec11applyToPathEP13SkPathBuilderRK6SkPath"]
    pub fn SkStrokeRec_applyToPath(
        this: *const SkStrokeRec,
        dst: *mut SkPathBuilder,
        src: *const SkPath,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkStrokeRec12applyToPaintEP7SkPaint"]
    pub fn SkStrokeRec_applyToPaint(this: *const SkStrokeRec, paint: *mut SkPaint);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK11SkStrokeRec18getInflationRadiusEv"]
    pub fn SkStrokeRec_getInflationRadius(this: *const SkStrokeRec) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRec18GetInflationRadiusERK7SkPaintNS0_5StyleE"]
    pub fn SkStrokeRec_GetInflationRadius(arg1: *const SkPaint, arg2: SkPaint_Style) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRec18GetInflationRadiusEN7SkPaint4JoinEfNS0_3CapEf"]
    pub fn SkStrokeRec_GetInflationRadius1(
        arg1: SkPaint_Join,
        miterLimit: SkScalar,
        arg2: SkPaint_Cap,
        strokeWidth: SkScalar,
    ) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRecC1ENS_9InitStyleE"]
    pub fn SkStrokeRec_SkStrokeRec(this: *mut SkStrokeRec, style: SkStrokeRec_InitStyle);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRecC1ERK7SkPaintNS0_5StyleEf"]
    pub fn SkStrokeRec_SkStrokeRec1(
        this: *mut SkStrokeRec,
        arg1: *const SkPaint,
        arg2: SkPaint_Style,
        resScale: SkScalar,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkStrokeRecC1ERK7SkPaintf"]
    pub fn SkStrokeRec_SkStrokeRec2(
        this: *mut SkStrokeRec,
        arg1: *const SkPaint,
        resScale: SkScalar,
    );
}
impl SkStrokeRec {
    #[inline]
    pub fn fCap(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_fCap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fCap_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                16u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fCap_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                16u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fJoin(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_fJoin(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fJoin_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                15u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fJoin_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                15u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fStrokeAndFill(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fStrokeAndFill(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fStrokeAndFill_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fStrokeAndFill_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fCap: u32,
        fJoin: u32,
        fStrokeAndFill: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let fCap: u32 = unsafe { ::core::mem::transmute(fCap) };
            fCap as u64
        });
        __bindgen_bitfield_unit.set(16usize, 15u8, {
            let fJoin: u32 = unsafe { ::core::mem::transmute(fJoin) };
            fJoin as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let fStrokeAndFill: u32 = unsafe { ::core::mem::transmute(fStrokeAndFill) };
            fStrokeAndFill as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub unsafe fn getStyle(&self) -> SkStrokeRec_Style {
        SkStrokeRec_getStyle(self)
    }
    #[inline]
    pub unsafe fn setFillStyle(&mut self) {
        SkStrokeRec_setFillStyle(self)
    }
    #[inline]
    pub unsafe fn setHairlineStyle(&mut self) {
        SkStrokeRec_setHairlineStyle(self)
    }
    #[inline]
    pub unsafe fn setStrokeStyle(&mut self, width: SkScalar, strokeAndFill: bool) {
        SkStrokeRec_setStrokeStyle(self, width, strokeAndFill)
    }
    #[inline]
    pub unsafe fn applyToPath(&self, dst: *mut SkPathBuilder, src: *const SkPath) -> bool {
        SkStrokeRec_applyToPath(self, dst, src)
    }
    #[inline]
    pub unsafe fn applyToPaint(&self, paint: *mut SkPaint) {
        SkStrokeRec_applyToPaint(self, paint)
    }
    #[inline]
    pub unsafe fn getInflationRadius(&self) -> SkScalar {
        SkStrokeRec_getInflationRadius(self)
    }
    #[inline]
    pub unsafe fn GetInflationRadius(arg1: *const SkPaint, arg2: SkPaint_Style) -> SkScalar {
        SkStrokeRec_GetInflationRadius(arg1, arg2)
    }
    #[inline]
    pub unsafe fn GetInflationRadius1(
        arg1: SkPaint_Join,
        miterLimit: SkScalar,
        arg2: SkPaint_Cap,
        strokeWidth: SkScalar,
    ) -> SkScalar {
        SkStrokeRec_GetInflationRadius1(arg1, miterLimit, arg2, strokeWidth)
    }
    #[inline]
    pub unsafe fn new(style: SkStrokeRec_InitStyle) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkStrokeRec_SkStrokeRec(__bindgen_tmp.as_mut_ptr(), style);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(arg1: *const SkPaint, arg2: SkPaint_Style, resScale: SkScalar) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkStrokeRec_SkStrokeRec1(__bindgen_tmp.as_mut_ptr(), arg1, arg2, resScale);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(arg1: *const SkPaint, resScale: SkScalar) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkStrokeRec_SkStrokeRec2(__bindgen_tmp.as_mut_ptr(), arg1, resScale);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrBackendSemaphore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrBackendTexture {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrSurfaceCharacterization {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCapabilities {
    _unused: [u8; 0],
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GrSurfaceOrigin {
    __bindgen_cannot_repr_c_on_empty_enum = 0,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkSurfaces_BackendSurfaceAccess {
    NoAccess = 0,
    Present = 1,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkSurface {
    pub _bindgen_opaque_blob: [u64; 5usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkSurface_ContentChangeMode {
    Discard = 0,
    Retain = 1,
}
impl SkSurface_BackendHandleAccess {
    pub const FlushRead_BackendHandleAccess: SkSurface_BackendHandleAccess =
        SkSurface_BackendHandleAccess::FlushRead;
}
impl SkSurface_BackendHandleAccess {
    pub const FlushWrite_BackendHandleAccess: SkSurface_BackendHandleAccess =
        SkSurface_BackendHandleAccess::FlushWrite;
}
impl SkSurface_BackendHandleAccess {
    pub const DiscardWrite_BackendHandleAccess: SkSurface_BackendHandleAccess =
        SkSurface_BackendHandleAccess::DiscardWrite;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkSurface_BackendHandleAccess {
    FlushRead = 0,
    FlushWrite = 1,
    DiscardWrite = 2,
}
pub type SkSurface_ReleaseContext = *mut ::core::ffi::c_void;
pub type SkSurface_TextureReleaseProc =
    ::core::option::Option<unsafe extern "C" fn(arg1: SkSurface_ReleaseContext)>;
pub type SkSurface_AsyncReadResult = SkImage_AsyncReadResult;
pub type SkSurface_ReadPixelsContext = *mut ::core::ffi::c_void;
pub type SkSurface_ReadPixelsCallback =
    ::core::option::Option<unsafe extern "C" fn(arg1: SkSurface_ReadPixelsContext, arg2: u8)>;
pub use self::SkImage_RescaleGamma as SkSurface_RescaleGamma;
pub use self::SkImage_RescaleMode as SkSurface_RescaleMode;
pub type SkSurface_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSurface"][::core::mem::size_of::<SkSurface>() - 40usize];
    ["Alignment of SkSurface"][::core::mem::align_of::<SkSurface>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkSurface12isCompatibleERK25GrSurfaceCharacterization"]
    pub fn SkSurface_isCompatible(
        this: *const SkSurface,
        characterization: *const GrSurfaceCharacterization,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface12generationIDEv"]
    pub fn SkSurface_generationID(this: *mut SkSurface) -> u32;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface23notifyContentWillChangeENS_17ContentChangeModeE"]
    pub fn SkSurface_notifyContentWillChange(
        this: *mut SkSurface,
        mode: SkSurface_ContentChangeMode,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkSurface16recordingContextEv"]
    pub fn SkSurface_recordingContext(this: *const SkSurface) -> *mut GrRecordingContext;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkSurface8recorderEv"]
    pub fn SkSurface_recorder(this: *const SkSurface) -> *mut skgpu_graphite_Recorder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkSurface12baseRecorderEv"]
    pub fn SkSurface_baseRecorder(this: *const SkSurface) -> *mut SkRecorder;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface9getCanvasEv"]
    pub fn SkSurface_getCanvas(this: *mut SkSurface) -> *mut SkCanvas;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface12capabilitiesEv"]
    pub fn SkSurface_capabilities(this: *mut SkSurface) -> sk_sp<SkCapabilities>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface11makeSurfaceERK11SkImageInfo"]
    pub fn SkSurface_makeSurface(
        this: *mut SkSurface,
        imageInfo: *const SkImageInfo,
    ) -> sk_sp<SkSurface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface11makeSurfaceEii"]
    pub fn SkSurface_makeSurface1(
        this: *mut SkSurface,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> sk_sp<SkSurface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface17makeImageSnapshotEv"]
    pub fn SkSurface_makeImageSnapshot(this: *mut SkSurface) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface17makeImageSnapshotERK7SkIRect"]
    pub fn SkSurface_makeImageSnapshot1(
        this: *mut SkSurface,
        bounds: *const SkIRect,
    ) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface18makeTemporaryImageEv"]
    pub fn SkSurface_makeTemporaryImage(this: *mut SkSurface) -> sk_sp<SkImage>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface4drawEP8SkCanvasffRK17SkSamplingOptionsPK7SkPaint"]
    pub fn SkSurface_draw(
        this: *mut SkSurface,
        canvas: *mut SkCanvas,
        x: SkScalar,
        y: SkScalar,
        sampling: *const SkSamplingOptions,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface10peekPixelsEP8SkPixmap"]
    pub fn SkSurface_peekPixels(this: *mut SkSurface, pixmap: *mut SkPixmap) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface10readPixelsERK8SkPixmapii"]
    pub fn SkSurface_readPixels(
        this: *mut SkSurface,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface10readPixelsERK11SkImageInfoPvmii"]
    pub fn SkSurface_readPixels1(
        this: *mut SkSurface,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface10readPixelsERK8SkBitmapii"]
    pub fn SkSurface_readPixels2(
        this: *mut SkSurface,
        dst: *const SkBitmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface25asyncRescaleAndReadPixelsERK11SkImageInfoRK7SkIRectN7SkImage12RescaleGammaENS6_11RescaleModeEPFvPvSt10unique_ptrIKNS6_15AsyncReadResultESt14default_deleteISC_EEES9_"]
    pub fn SkSurface_asyncRescaleAndReadPixels(
        this: *mut SkSurface,
        info: *const SkImageInfo,
        srcRect: *const SkIRect,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface31asyncRescaleAndReadPixelsYUV420E15SkYUVColorSpace5sk_spI12SkColorSpaceERK7SkIRectRK7SkISizeN7SkImage12RescaleGammaENSA_11RescaleModeEPFvPvSt10unique_ptrIKNSA_15AsyncReadResultESt14default_deleteISG_EEESD_"]
    pub fn SkSurface_asyncRescaleAndReadPixelsYUV420(
        this: *mut SkSurface,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface32asyncRescaleAndReadPixelsYUVA420E15SkYUVColorSpace5sk_spI12SkColorSpaceERK7SkIRectRK7SkISizeN7SkImage12RescaleGammaENSA_11RescaleModeEPFvPvSt10unique_ptrIKNSA_15AsyncReadResultESt14default_deleteISG_EEESD_"]
    pub fn SkSurface_asyncRescaleAndReadPixelsYUVA420(
        this: *mut SkSurface,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface11writePixelsERK8SkPixmapii"]
    pub fn SkSurface_writePixels(
        this: *mut SkSurface,
        src: *const SkPixmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface11writePixelsERK8SkBitmapii"]
    pub fn SkSurface_writePixels1(
        this: *mut SkSurface,
        src: *const SkBitmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface4waitEiPK18GrBackendSemaphoreb"]
    pub fn SkSurface_wait(
        this: *mut SkSurface,
        numSemaphores: ::core::ffi::c_int,
        waitSemaphores: *const GrBackendSemaphore,
        deleteSemaphoresAfterWait: bool,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkSurface12characterizeEP25GrSurfaceCharacterization"]
    pub fn SkSurface_characterize(
        this: *const SkSurface,
        characterization: *mut GrSurfaceCharacterization,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurfaceC2EiiPK14SkSurfaceProps"]
    pub fn SkSurface_SkSurface(
        this: *mut SkSurface,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        surfaceProps: *const SkSurfaceProps,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurfaceC2ERK11SkImageInfoPK14SkSurfaceProps"]
    pub fn SkSurface_SkSurface1(
        this: *mut SkSurface,
        imageInfo: *const SkImageInfo,
        surfaceProps: *const SkSurfaceProps,
    );
}
impl SkSurface {
    #[inline]
    pub unsafe fn isCompatible(&self, characterization: *const GrSurfaceCharacterization) -> bool {
        SkSurface_isCompatible(self, characterization)
    }
    #[inline]
    pub unsafe fn generationID(&mut self) -> u32 {
        SkSurface_generationID(self)
    }
    #[inline]
    pub unsafe fn notifyContentWillChange(&mut self, mode: SkSurface_ContentChangeMode) {
        SkSurface_notifyContentWillChange(self, mode)
    }
    #[inline]
    pub unsafe fn recordingContext(&self) -> *mut GrRecordingContext {
        SkSurface_recordingContext(self)
    }
    #[inline]
    pub unsafe fn recorder(&self) -> *mut skgpu_graphite_Recorder {
        SkSurface_recorder(self)
    }
    #[inline]
    pub unsafe fn baseRecorder(&self) -> *mut SkRecorder {
        SkSurface_baseRecorder(self)
    }
    #[inline]
    pub unsafe fn getCanvas(&mut self) -> *mut SkCanvas {
        SkSurface_getCanvas(self)
    }
    #[inline]
    pub unsafe fn capabilities(&mut self) -> sk_sp<SkCapabilities> {
        SkSurface_capabilities(self)
    }
    #[inline]
    pub unsafe fn makeSurface(&mut self, imageInfo: *const SkImageInfo) -> sk_sp<SkSurface> {
        SkSurface_makeSurface(self, imageInfo)
    }
    #[inline]
    pub unsafe fn makeSurface1(
        &mut self,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> sk_sp<SkSurface> {
        SkSurface_makeSurface1(self, width, height)
    }
    #[inline]
    pub unsafe fn makeImageSnapshot(&mut self) -> sk_sp<SkImage> {
        SkSurface_makeImageSnapshot(self)
    }
    #[inline]
    pub unsafe fn makeImageSnapshot1(&mut self, bounds: *const SkIRect) -> sk_sp<SkImage> {
        SkSurface_makeImageSnapshot1(self, bounds)
    }
    #[inline]
    pub unsafe fn makeTemporaryImage(&mut self) -> sk_sp<SkImage> {
        SkSurface_makeTemporaryImage(self)
    }
    #[inline]
    pub unsafe fn draw(
        &mut self,
        canvas: *mut SkCanvas,
        x: SkScalar,
        y: SkScalar,
        sampling: *const SkSamplingOptions,
        paint: *const SkPaint,
    ) {
        SkSurface_draw(self, canvas, x, y, sampling, paint)
    }
    #[inline]
    pub unsafe fn peekPixels(&mut self, pixmap: *mut SkPixmap) -> bool {
        SkSurface_peekPixels(self, pixmap)
    }
    #[inline]
    pub unsafe fn readPixels(
        &mut self,
        dst: *const SkPixmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkSurface_readPixels(self, dst, srcX, srcY)
    }
    #[inline]
    pub unsafe fn readPixels1(
        &mut self,
        dstInfo: *const SkImageInfo,
        dstPixels: *mut ::core::ffi::c_void,
        dstRowBytes: usize,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkSurface_readPixels1(self, dstInfo, dstPixels, dstRowBytes, srcX, srcY)
    }
    #[inline]
    pub unsafe fn readPixels2(
        &mut self,
        dst: *const SkBitmap,
        srcX: ::core::ffi::c_int,
        srcY: ::core::ffi::c_int,
    ) -> bool {
        SkSurface_readPixels2(self, dst, srcX, srcY)
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixels(
        &mut self,
        info: *const SkImageInfo,
        srcRect: *const SkIRect,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    ) {
        SkSurface_asyncRescaleAndReadPixels(
            self,
            info,
            srcRect,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixelsYUV420(
        &mut self,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    ) {
        SkSurface_asyncRescaleAndReadPixelsYUV420(
            self,
            yuvColorSpace,
            dstColorSpace,
            srcRect,
            dstSize,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn asyncRescaleAndReadPixelsYUVA420(
        &mut self,
        yuvColorSpace: SkYUVColorSpace,
        dstColorSpace: sk_sp<SkColorSpace>,
        srcRect: *const SkIRect,
        dstSize: *const SkISize,
        rescaleGamma: SkSurface_RescaleGamma,
        rescaleMode: SkSurface_RescaleMode,
        callback: SkSurface_ReadPixelsCallback,
        context: SkSurface_ReadPixelsContext,
    ) {
        SkSurface_asyncRescaleAndReadPixelsYUVA420(
            self,
            yuvColorSpace,
            dstColorSpace,
            srcRect,
            dstSize,
            rescaleGamma,
            rescaleMode,
            callback,
            context,
        )
    }
    #[inline]
    pub unsafe fn writePixels(
        &mut self,
        src: *const SkPixmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    ) {
        SkSurface_writePixels(self, src, dstX, dstY)
    }
    #[inline]
    pub unsafe fn writePixels1(
        &mut self,
        src: *const SkBitmap,
        dstX: ::core::ffi::c_int,
        dstY: ::core::ffi::c_int,
    ) {
        SkSurface_writePixels1(self, src, dstX, dstY)
    }
    #[inline]
    pub unsafe fn wait(
        &mut self,
        numSemaphores: ::core::ffi::c_int,
        waitSemaphores: *const GrBackendSemaphore,
        deleteSemaphoresAfterWait: bool,
    ) -> bool {
        SkSurface_wait(
            self,
            numSemaphores,
            waitSemaphores,
            deleteSemaphoresAfterWait,
        )
    }
    #[inline]
    pub unsafe fn characterize(&self, characterization: *mut GrSurfaceCharacterization) -> bool {
        SkSurface_characterize(self, characterization)
    }
    #[inline]
    pub unsafe fn new(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        surfaceProps: *const SkSurfaceProps,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkSurface_SkSurface(__bindgen_tmp.as_mut_ptr(), width, height, surfaceProps);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(imageInfo: *const SkImageInfo, surfaceProps: *const SkSurfaceProps) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkSurface_SkSurface1(__bindgen_tmp.as_mut_ptr(), imageInfo, surfaceProps);
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface30kFlushRead_BackendHandleAccessE"]
    pub static SkSurface_kFlushRead_BackendHandleAccess: SkSurface_BackendHandleAccess;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface31kFlushWrite_BackendHandleAccessE"]
    pub static SkSurface_kFlushWrite_BackendHandleAccess: SkSurface_BackendHandleAccess;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkSurface33kDiscardWrite_BackendHandleAccessE"]
    pub static SkSurface_kDiscardWrite_BackendHandleAccess: SkSurface_BackendHandleAccess;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z8SkSwapRBPjPKji"]
    pub fn SkSwapRB(dest: *mut u32, src: *const u32, count: ::core::ffi::c_int);
}
#[repr(C)]
#[derive(Debug)]
pub struct SkTextBlob {
    pub _base: SkNVRefCnt,
    pub fBounds: SkRect,
    pub fUniqueID: u32,
    pub fCacheID: u32,
    pub fPurgeDelegate: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTextBlob_RunRecord {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTextBlob_Iter {
    pub fRunRecord: *const SkTextBlob_RunRecord,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTextBlob_Iter_Run {
    pub fTypeface: *mut SkTypeface,
    pub fGlyphCount: ::core::ffi::c_int,
    pub fGlyphIndices: *const SkGlyphID,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlob_Iter_Run"][::core::mem::size_of::<SkTextBlob_Iter_Run>() - 24usize];
    ["Alignment of SkTextBlob_Iter_Run"][::core::mem::align_of::<SkTextBlob_Iter_Run>() - 8usize];
    ["Offset of field: SkTextBlob_Iter_Run::fTypeface"]
        [::core::mem::offset_of!(SkTextBlob_Iter_Run, fTypeface) - 0usize];
    ["Offset of field: SkTextBlob_Iter_Run::fGlyphCount"]
        [::core::mem::offset_of!(SkTextBlob_Iter_Run, fGlyphCount) - 8usize];
    ["Offset of field: SkTextBlob_Iter_Run::fGlyphIndices"]
        [::core::mem::offset_of!(SkTextBlob_Iter_Run, fGlyphIndices) - 16usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkTextBlob_Iter_ExperimentalRun {
    pub font: SkFont,
    pub count: ::core::ffi::c_int,
    pub glyphs: *const SkGlyphID,
    pub positions: *const SkPoint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlob_Iter_ExperimentalRun"]
        [::core::mem::size_of::<SkTextBlob_Iter_ExperimentalRun>() - 48usize];
    ["Alignment of SkTextBlob_Iter_ExperimentalRun"]
        [::core::mem::align_of::<SkTextBlob_Iter_ExperimentalRun>() - 8usize];
    ["Offset of field: SkTextBlob_Iter_ExperimentalRun::font"]
        [::core::mem::offset_of!(SkTextBlob_Iter_ExperimentalRun, font) - 0usize];
    ["Offset of field: SkTextBlob_Iter_ExperimentalRun::count"]
        [::core::mem::offset_of!(SkTextBlob_Iter_ExperimentalRun, count) - 24usize];
    ["Offset of field: SkTextBlob_Iter_ExperimentalRun::glyphs"]
        [::core::mem::offset_of!(SkTextBlob_Iter_ExperimentalRun, glyphs) - 32usize];
    ["Offset of field: SkTextBlob_Iter_ExperimentalRun::positions"]
        [::core::mem::offset_of!(SkTextBlob_Iter_ExperimentalRun, positions) - 40usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlob_Iter"][::core::mem::size_of::<SkTextBlob_Iter>() - 8usize];
    ["Alignment of SkTextBlob_Iter"][::core::mem::align_of::<SkTextBlob_Iter>() - 8usize];
    ["Offset of field: SkTextBlob_Iter::fRunRecord"]
        [::core::mem::offset_of!(SkTextBlob_Iter, fRunRecord) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob4Iter4nextEPNS0_3RunE"]
    pub fn SkTextBlob_Iter_next(this: *mut SkTextBlob_Iter, arg1: *mut SkTextBlob_Iter_Run)
    -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob4Iter16experimentalNextEPNS0_15ExperimentalRunE"]
    pub fn SkTextBlob_Iter_experimentalNext(
        this: *mut SkTextBlob_Iter,
        arg1: *mut SkTextBlob_Iter_ExperimentalRun,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob4IterC1ERKS_"]
    pub fn SkTextBlob_Iter_Iter(this: *mut SkTextBlob_Iter, arg1: *const SkTextBlob);
}
impl SkTextBlob_Iter {
    #[inline]
    pub unsafe fn next(&mut self, arg1: *mut SkTextBlob_Iter_Run) -> bool {
        SkTextBlob_Iter_next(self, arg1)
    }
    #[inline]
    pub unsafe fn experimentalNext(&mut self, arg1: *mut SkTextBlob_Iter_ExperimentalRun) -> bool {
        SkTextBlob_Iter_experimentalNext(self, arg1)
    }
    #[inline]
    pub unsafe fn new(arg1: *const SkTextBlob) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTextBlob_Iter_Iter(__bindgen_tmp.as_mut_ptr(), arg1);
        __bindgen_tmp.assume_init()
    }
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTextBlob_GlyphPositioning {
    __bindgen_cannot_repr_c_on_empty_enum = 0,
}
pub type SkTextBlob_PurgeDelegate =
    ::core::option::Option<unsafe extern "C" fn(blobID: u32, cacheID: u32)>;
pub type SkTextBlob_INHERITED = SkRefCnt;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlob"][::core::mem::size_of::<SkTextBlob>() - 40usize];
    ["Alignment of SkTextBlob"][::core::mem::align_of::<SkTextBlob>() - 8usize];
    ["Offset of field: SkTextBlob::fBounds"][::core::mem::offset_of!(SkTextBlob, fBounds) - 4usize];
    ["Offset of field: SkTextBlob::fUniqueID"]
        [::core::mem::offset_of!(SkTextBlob, fUniqueID) - 20usize];
    ["Offset of field: SkTextBlob::fCacheID"]
        [::core::mem::offset_of!(SkTextBlob, fCacheID) - 24usize];
    ["Offset of field: SkTextBlob::fPurgeDelegate"]
        [::core::mem::offset_of!(SkTextBlob, fPurgeDelegate) - 32usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTextBlob13getInterceptsEPKfPfPK7SkPaint"]
    pub fn SkTextBlob_getIntercepts(
        this: *const SkTextBlob,
        bounds: *const SkScalar,
        intervals: *mut SkScalar,
        paint: *const SkPaint,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob12MakeFromTextEPKvmRK6SkFont14SkTextEncoding"]
    pub fn SkTextBlob_MakeFromText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob16MakeFromPosTextHEPKvm6SkSpanIKfEfRK6SkFont14SkTextEncoding"]
    pub fn SkTextBlob_MakeFromPosTextH(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xpos: SkSpan<SkScalar>,
        constY: SkScalar,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob15MakeFromPosTextEPKvm6SkSpanIK7SkPointERK6SkFont14SkTextEncoding"]
    pub fn SkTextBlob_MakeFromPosText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        pos: SkSpan<SkPoint>,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob15MakeFromRSXformEPKvm6SkSpanIK9SkRSXformERK6SkFont14SkTextEncoding"]
    pub fn SkTextBlob_MakeFromRSXform(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xform: SkSpan<SkRSXform>,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTextBlob9serializeERK13SkSerialProcsPvm"]
    pub fn SkTextBlob_serialize(
        this: *const SkTextBlob,
        procs: *const SkSerialProcs,
        memory: *mut ::core::ffi::c_void,
        memory_size: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkTextBlob9serializeERK13SkSerialProcs"]
    pub fn SkTextBlob_serialize1(
        this: *const SkTextBlob,
        procs: *const SkSerialProcs,
    ) -> sk_sp<SkData>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkTextBlob11DeserializeEPKvmRK15SkDeserialProcs"]
    pub fn SkTextBlob_Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkTextBlob>;
}
impl SkTextBlob {
    #[inline]
    pub unsafe fn getIntercepts(
        &self,
        bounds: *const SkScalar,
        intervals: *mut SkScalar,
        paint: *const SkPaint,
    ) -> ::core::ffi::c_int {
        SkTextBlob_getIntercepts(self, bounds, intervals, paint)
    }
    #[inline]
    pub unsafe fn MakeFromText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob> {
        SkTextBlob_MakeFromText(text, byteLength, font, encoding)
    }
    #[inline]
    pub unsafe fn MakeFromPosTextH(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xpos: SkSpan<SkScalar>,
        constY: SkScalar,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob> {
        SkTextBlob_MakeFromPosTextH(text, byteLength, xpos, constY, font, encoding)
    }
    #[inline]
    pub unsafe fn MakeFromPosText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        pos: SkSpan<SkPoint>,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob> {
        SkTextBlob_MakeFromPosText(text, byteLength, pos, font, encoding)
    }
    #[inline]
    pub unsafe fn MakeFromRSXform(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xform: SkSpan<SkRSXform>,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> sk_sp<SkTextBlob> {
        SkTextBlob_MakeFromRSXform(text, byteLength, xform, font, encoding)
    }
    #[inline]
    pub unsafe fn serialize(
        &self,
        procs: *const SkSerialProcs,
        memory: *mut ::core::ffi::c_void,
        memory_size: usize,
    ) -> usize {
        SkTextBlob_serialize(self, procs, memory, memory_size)
    }
    #[inline]
    pub unsafe fn serialize1(&self, procs: *const SkSerialProcs) -> sk_sp<SkData> {
        SkTextBlob_serialize1(self, procs)
    }
    #[inline]
    pub unsafe fn Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkTextBlob> {
        SkTextBlob_Deserialize(data, size, procs)
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkTextBlobBuilder {
    pub fStorage: u64,
    pub fStorageSize: usize,
    pub fStorageUsed: usize,
    pub fBounds: SkRect,
    pub fRunCount: ::core::ffi::c_int,
    pub fDeferredBounds: bool,
    pub fLastRun: usize,
    pub fCurrentRunBuffer: SkTextBlobBuilder_RunBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTextBlobBuilder_RunBuffer {
    pub glyphs: *mut SkGlyphID,
    pub pos: *mut SkScalar,
    pub utf8text: *mut ::core::ffi::c_char,
    pub clusters: *mut u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlobBuilder_RunBuffer"]
        [::core::mem::size_of::<SkTextBlobBuilder_RunBuffer>() - 32usize];
    ["Alignment of SkTextBlobBuilder_RunBuffer"]
        [::core::mem::align_of::<SkTextBlobBuilder_RunBuffer>() - 8usize];
    ["Offset of field: SkTextBlobBuilder_RunBuffer::glyphs"]
        [::core::mem::offset_of!(SkTextBlobBuilder_RunBuffer, glyphs) - 0usize];
    ["Offset of field: SkTextBlobBuilder_RunBuffer::pos"]
        [::core::mem::offset_of!(SkTextBlobBuilder_RunBuffer, pos) - 8usize];
    ["Offset of field: SkTextBlobBuilder_RunBuffer::utf8text"]
        [::core::mem::offset_of!(SkTextBlobBuilder_RunBuffer, utf8text) - 16usize];
    ["Offset of field: SkTextBlobBuilder_RunBuffer::clusters"]
        [::core::mem::offset_of!(SkTextBlobBuilder_RunBuffer, clusters) - 24usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextBlobBuilder"][::core::mem::size_of::<SkTextBlobBuilder>() - 88usize];
    ["Alignment of SkTextBlobBuilder"][::core::mem::align_of::<SkTextBlobBuilder>() - 8usize];
    ["Offset of field: SkTextBlobBuilder::fStorage"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fStorage) - 0usize];
    ["Offset of field: SkTextBlobBuilder::fStorageSize"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fStorageSize) - 8usize];
    ["Offset of field: SkTextBlobBuilder::fStorageUsed"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fStorageUsed) - 16usize];
    ["Offset of field: SkTextBlobBuilder::fBounds"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fBounds) - 24usize];
    ["Offset of field: SkTextBlobBuilder::fRunCount"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fRunCount) - 40usize];
    ["Offset of field: SkTextBlobBuilder::fDeferredBounds"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fDeferredBounds) - 44usize];
    ["Offset of field: SkTextBlobBuilder::fLastRun"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fLastRun) - 48usize];
    ["Offset of field: SkTextBlobBuilder::fCurrentRunBuffer"]
        [::core::mem::offset_of!(SkTextBlobBuilder, fCurrentRunBuffer) - 56usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder4makeEv"]
    pub fn SkTextBlobBuilder_make(this: *mut SkTextBlobBuilder) -> sk_sp<SkTextBlob>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder8allocRunERK6SkFontiffPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRun(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        x: SkScalar,
        y: SkScalar,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder12allocRunPosHERK6SkFontifPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunPosH(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        y: SkScalar,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder11allocRunPosERK6SkFontiPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunPos(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder15allocRunRSXformERK6SkFonti"]
    pub fn SkTextBlobBuilder_allocRunRSXform(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder12allocRunTextERK6SkFontiffiPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunText(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        x: SkScalar,
        y: SkScalar,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder16allocRunTextPosHERK6SkFontifiPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunTextPosH(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        y: SkScalar,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder15allocRunTextPosERK6SkFontiiPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunTextPos(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilder19allocRunTextRSXformERK6SkFontiiPK6SkRect"]
    pub fn SkTextBlobBuilder_allocRunTextRSXform(
        this: *mut SkTextBlobBuilder,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilderC1Ev"]
    pub fn SkTextBlobBuilder_SkTextBlobBuilder(this: *mut SkTextBlobBuilder);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTextBlobBuilderD1Ev"]
    pub fn SkTextBlobBuilder_SkTextBlobBuilder_destructor(this: *mut SkTextBlobBuilder);
}
impl SkTextBlobBuilder {
    #[inline]
    pub unsafe fn make(&mut self) -> sk_sp<SkTextBlob> {
        SkTextBlobBuilder_make(self)
    }
    #[inline]
    pub unsafe fn allocRun(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        x: SkScalar,
        y: SkScalar,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRun(self, font, count, x, y, bounds)
    }
    #[inline]
    pub unsafe fn allocRunPosH(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        y: SkScalar,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunPosH(self, font, count, y, bounds)
    }
    #[inline]
    pub unsafe fn allocRunPos(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunPos(self, font, count, bounds)
    }
    #[inline]
    pub unsafe fn allocRunRSXform(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunRSXform(self, font, count)
    }
    #[inline]
    pub unsafe fn allocRunText(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        x: SkScalar,
        y: SkScalar,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunText(self, font, count, x, y, textByteCount, bounds)
    }
    #[inline]
    pub unsafe fn allocRunTextPosH(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        y: SkScalar,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunTextPosH(self, font, count, y, textByteCount, bounds)
    }
    #[inline]
    pub unsafe fn allocRunTextPos(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunTextPos(self, font, count, textByteCount, bounds)
    }
    #[inline]
    pub unsafe fn allocRunTextRSXform(
        &mut self,
        font: *const SkFont,
        count: ::core::ffi::c_int,
        textByteCount: ::core::ffi::c_int,
        bounds: *const SkRect,
    ) -> *const SkTextBlobBuilder_RunBuffer {
        SkTextBlobBuilder_allocRunTextRSXform(self, font, count, textByteCount, bounds)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkTextBlobBuilder_SkTextBlobBuilder(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkTextBlobBuilder_SkTextBlobBuilder_destructor(self)
    }
}
impl SkTextureCompressionType {
    pub const Last: SkTextureCompressionType = SkTextureCompressionType::BC1_RGBA8_UNORM;
}
impl SkTextureCompressionType {
    pub const ETC1_RGB8: SkTextureCompressionType = SkTextureCompressionType::ETC2_RGB8_UNORM;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTextureCompressionType {
    None = 0,
    ETC2_RGB8_UNORM = 1,
    BC1_RGB8_UNORM = 2,
    BC1_RGBA8_UNORM = 3,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkVertices {
    pub _base: SkNVRefCnt,
    pub fUniqueID: u32,
    pub fPositions: *mut SkPoint,
    pub fIndices: *mut u16,
    pub fTexs: *mut SkPoint,
    pub fColors: *mut SkColor,
    pub fBounds: SkRect,
    pub fVertexCount: ::core::ffi::c_int,
    pub fIndexCount: ::core::ffi::c_int,
    pub fMode: SkVertices_VertexMode,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkVertices_Desc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkVertices_Sizes {
    _unused: [u8; 0],
}
impl SkVertices_VertexMode {
    pub const Last: SkVertices_VertexMode = SkVertices_VertexMode::TriangleFan;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkVertices_VertexMode {
    Triangles = 0,
    TriangleStrip = 1,
    TriangleFan = 2,
}
pub const SkVertices_BuilderFlags_kHasTexCoords_BuilderFlag: SkVertices_BuilderFlags = 1;
pub const SkVertices_BuilderFlags_kHasColors_BuilderFlag: SkVertices_BuilderFlags = 2;
pub type SkVertices_BuilderFlags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct SkVertices_Builder {
    pub fVertices: sk_sp<SkVertices>,
    pub fIntermediateFanIndices: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkVertices_Builder"][::core::mem::size_of::<SkVertices_Builder>() - 16usize];
    ["Alignment of SkVertices_Builder"][::core::mem::align_of::<SkVertices_Builder>() - 8usize];
    ["Offset of field: SkVertices_Builder::fVertices"]
        [::core::mem::offset_of!(SkVertices_Builder, fVertices) - 0usize];
    ["Offset of field: SkVertices_Builder::fIntermediateFanIndices"]
        [::core::mem::offset_of!(SkVertices_Builder, fIntermediateFanIndices) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7Builder9positionsEv"]
    pub fn SkVertices_Builder_positions(this: *mut SkVertices_Builder) -> *mut SkPoint;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7Builder7indicesEv"]
    pub fn SkVertices_Builder_indices(this: *mut SkVertices_Builder) -> *mut u16;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7Builder9texCoordsEv"]
    pub fn SkVertices_Builder_texCoords(this: *mut SkVertices_Builder) -> *mut SkPoint;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7Builder6colorsEv"]
    pub fn SkVertices_Builder_colors(this: *mut SkVertices_Builder) -> *mut SkColor;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7Builder6detachEv"]
    pub fn SkVertices_Builder_detach(this: *mut SkVertices_Builder) -> sk_sp<SkVertices>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices7BuilderC1ENS_10VertexModeEiij"]
    pub fn SkVertices_Builder_Builder(
        this: *mut SkVertices_Builder,
        mode: SkVertices_VertexMode,
        vertexCount: ::core::ffi::c_int,
        indexCount: ::core::ffi::c_int,
        flags: u32,
    );
}
impl SkVertices_Builder {
    #[inline]
    pub unsafe fn positions(&mut self) -> *mut SkPoint {
        SkVertices_Builder_positions(self)
    }
    #[inline]
    pub unsafe fn indices(&mut self) -> *mut u16 {
        SkVertices_Builder_indices(self)
    }
    #[inline]
    pub unsafe fn texCoords(&mut self) -> *mut SkPoint {
        SkVertices_Builder_texCoords(self)
    }
    #[inline]
    pub unsafe fn colors(&mut self) -> *mut SkColor {
        SkVertices_Builder_colors(self)
    }
    #[inline]
    pub unsafe fn detach(&mut self) -> sk_sp<SkVertices> {
        SkVertices_Builder_detach(self)
    }
    #[inline]
    pub unsafe fn new(
        mode: SkVertices_VertexMode,
        vertexCount: ::core::ffi::c_int,
        indexCount: ::core::ffi::c_int,
        flags: u32,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkVertices_Builder_Builder(
            __bindgen_tmp.as_mut_ptr(),
            mode,
            vertexCount,
            indexCount,
            flags,
        );
        __bindgen_tmp.assume_init()
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkVertices"][::core::mem::size_of::<SkVertices>() - 72usize];
    ["Alignment of SkVertices"][::core::mem::align_of::<SkVertices>() - 8usize];
    ["Offset of field: SkVertices::fUniqueID"]
        [::core::mem::offset_of!(SkVertices, fUniqueID) - 4usize];
    ["Offset of field: SkVertices::fPositions"]
        [::core::mem::offset_of!(SkVertices, fPositions) - 8usize];
    ["Offset of field: SkVertices::fIndices"]
        [::core::mem::offset_of!(SkVertices, fIndices) - 16usize];
    ["Offset of field: SkVertices::fTexs"][::core::mem::offset_of!(SkVertices, fTexs) - 24usize];
    ["Offset of field: SkVertices::fColors"]
        [::core::mem::offset_of!(SkVertices, fColors) - 32usize];
    ["Offset of field: SkVertices::fBounds"]
        [::core::mem::offset_of!(SkVertices, fBounds) - 40usize];
    ["Offset of field: SkVertices::fVertexCount"]
        [::core::mem::offset_of!(SkVertices, fVertexCount) - 56usize];
    ["Offset of field: SkVertices::fIndexCount"]
        [::core::mem::offset_of!(SkVertices, fIndexCount) - 60usize];
    ["Offset of field: SkVertices::fMode"][::core::mem::offset_of!(SkVertices, fMode) - 64usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkVertices8MakeCopyENS_10VertexModeEiPK7SkPointS3_PKjiPKt"]
    pub fn SkVertices_MakeCopy(
        mode: SkVertices_VertexMode,
        vertexCount: ::core::ffi::c_int,
        positions: *const SkPoint,
        texs: *const SkPoint,
        colors: *const SkColor,
        indexCount: ::core::ffi::c_int,
        indices: *const u16,
    ) -> sk_sp<SkVertices>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkVertices15approximateSizeEv"]
    pub fn SkVertices_approximateSize(this: *const SkVertices) -> usize;
}
impl SkVertices {
    #[inline]
    pub unsafe fn MakeCopy(
        mode: SkVertices_VertexMode,
        vertexCount: ::core::ffi::c_int,
        positions: *const SkPoint,
        texs: *const SkPoint,
        colors: *const SkColor,
        indexCount: ::core::ffi::c_int,
        indices: *const u16,
    ) -> sk_sp<SkVertices> {
        SkVertices_MakeCopy(
            mode,
            vertexCount,
            positions,
            texs,
            colors,
            indexCount,
            indices,
        )
    }
    #[inline]
    pub unsafe fn approximateSize(&self) -> usize {
        SkVertices_approximateSize(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkExecutor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPDFArray {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct SkPDF_AttributeList {
    pub fAttrs: u64,
    pub fElemIds: __BindgenOpaqueArray<u64, 3usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPDF_AttributeList"][::core::mem::size_of::<SkPDF_AttributeList>() - 32usize];
    ["Alignment of SkPDF_AttributeList"][::core::mem::align_of::<SkPDF_AttributeList>() - 8usize];
    ["Offset of field: SkPDF_AttributeList::fAttrs"]
        [::core::mem::offset_of!(SkPDF_AttributeList, fAttrs) - 0usize];
    ["Offset of field: SkPDF_AttributeList::fElemIds"]
        [::core::mem::offset_of!(SkPDF_AttributeList, fElemIds) - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeList9appendIntEPKcS2_i"]
    pub fn SkPDF_AttributeList_appendInt(
        this: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeList11appendFloatEPKcS2_f"]
    pub fn SkPDF_AttributeList_appendFloat(
        this: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: f32,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeList10appendNameEPKcS2_S2_"]
    pub fn SkPDF_AttributeList_appendName(
        this: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        attrName: *const ::core::ffi::c_char,
        value: *const ::core::ffi::c_char,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeList16appendFloatArrayEPKcS2_RKSt6vectorIfSaIfEE"]
    pub fn SkPDF_AttributeList_appendFloatArray(
        this: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: *const __BindgenOpaqueArray<u64, 3usize>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeList17appendNodeIdArrayEPKcS2_RKSt6vectorIiSaIiEE"]
    pub fn SkPDF_AttributeList_appendNodeIdArray(
        this: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        attrName: *const ::core::ffi::c_char,
        nodeIds: *const __BindgenOpaqueArray<u64, 3usize>,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeListC1Ev"]
    pub fn SkPDF_AttributeList_AttributeList(this: *mut SkPDF_AttributeList);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN5SkPDF13AttributeListD1Ev"]
    pub fn SkPDF_AttributeList_AttributeList_destructor(this: *mut SkPDF_AttributeList);
}
impl SkPDF_AttributeList {
    #[inline]
    pub unsafe fn appendInt(
        &mut self,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: ::core::ffi::c_int,
    ) {
        SkPDF_AttributeList_appendInt(self, owner, name, value)
    }
    #[inline]
    pub unsafe fn appendFloat(
        &mut self,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: f32,
    ) {
        SkPDF_AttributeList_appendFloat(self, owner, name, value)
    }
    #[inline]
    pub unsafe fn appendName(
        &mut self,
        owner: *const ::core::ffi::c_char,
        attrName: *const ::core::ffi::c_char,
        value: *const ::core::ffi::c_char,
    ) {
        SkPDF_AttributeList_appendName(self, owner, attrName, value)
    }
    #[inline]
    pub unsafe fn appendFloatArray(
        &mut self,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: *const __BindgenOpaqueArray<u64, 3usize>,
    ) {
        SkPDF_AttributeList_appendFloatArray(self, owner, name, value)
    }
    #[inline]
    pub unsafe fn appendNodeIdArray(
        &mut self,
        owner: *const ::core::ffi::c_char,
        attrName: *const ::core::ffi::c_char,
        nodeIds: *const __BindgenOpaqueArray<u64, 3usize>,
    ) {
        SkPDF_AttributeList_appendNodeIdArray(self, owner, attrName, nodeIds)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPDF_AttributeList_AttributeList(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        SkPDF_AttributeList_AttributeList_destructor(self)
    }
}
#[repr(C)]
pub struct SkPDF_StructureElementNode {
    pub fTypeString: SkString,
    pub fChildVector: __BindgenOpaqueArray<u64, 3usize>,
    pub fNodeId: ::core::ffi::c_int,
    pub fAttributes: SkPDF_AttributeList,
    pub fAlt: SkString,
    pub fLang: SkString,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPDF_StructureElementNode"]
        [::core::mem::size_of::<SkPDF_StructureElementNode>() - 88usize];
    ["Alignment of SkPDF_StructureElementNode"]
        [::core::mem::align_of::<SkPDF_StructureElementNode>() - 8usize];
    ["Offset of field: SkPDF_StructureElementNode::fTypeString"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fTypeString) - 0usize];
    ["Offset of field: SkPDF_StructureElementNode::fChildVector"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fChildVector) - 8usize];
    ["Offset of field: SkPDF_StructureElementNode::fNodeId"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fNodeId) - 32usize];
    ["Offset of field: SkPDF_StructureElementNode::fAttributes"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fAttributes) - 40usize];
    ["Offset of field: SkPDF_StructureElementNode::fAlt"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fAlt) - 72usize];
    ["Offset of field: SkPDF_StructureElementNode::fLang"]
        [::core::mem::offset_of!(SkPDF_StructureElementNode, fLang) - 80usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPDF_DateTime {
    pub fTimeZoneMinutes: i16,
    pub fYear: u16,
    pub fMonth: u8,
    pub fDayOfWeek: u8,
    pub fDay: u8,
    pub fHour: u8,
    pub fMinute: u8,
    pub fSecond: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPDF_DateTime"][::core::mem::size_of::<SkPDF_DateTime>() - 10usize];
    ["Alignment of SkPDF_DateTime"][::core::mem::align_of::<SkPDF_DateTime>() - 2usize];
    ["Offset of field: SkPDF_DateTime::fTimeZoneMinutes"]
        [::core::mem::offset_of!(SkPDF_DateTime, fTimeZoneMinutes) - 0usize];
    ["Offset of field: SkPDF_DateTime::fYear"]
        [::core::mem::offset_of!(SkPDF_DateTime, fYear) - 2usize];
    ["Offset of field: SkPDF_DateTime::fMonth"]
        [::core::mem::offset_of!(SkPDF_DateTime, fMonth) - 4usize];
    ["Offset of field: SkPDF_DateTime::fDayOfWeek"]
        [::core::mem::offset_of!(SkPDF_DateTime, fDayOfWeek) - 5usize];
    ["Offset of field: SkPDF_DateTime::fDay"]
        [::core::mem::offset_of!(SkPDF_DateTime, fDay) - 6usize];
    ["Offset of field: SkPDF_DateTime::fHour"]
        [::core::mem::offset_of!(SkPDF_DateTime, fHour) - 7usize];
    ["Offset of field: SkPDF_DateTime::fMinute"]
        [::core::mem::offset_of!(SkPDF_DateTime, fMinute) - 8usize];
    ["Offset of field: SkPDF_DateTime::fSecond"]
        [::core::mem::offset_of!(SkPDF_DateTime, fSecond) - 9usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK5SkPDF8DateTime9toISO8601EP8SkString"]
    pub fn SkPDF_DateTime_toISO8601(this: *const SkPDF_DateTime, dst: *mut SkString);
}
impl SkPDF_DateTime {
    #[inline]
    pub unsafe fn toISO8601(&self, dst: *mut SkString) {
        SkPDF_DateTime_toISO8601(self, dst)
    }
}
pub type SkPDF_DecodeJpegCallback =
    ::core::option::Option<unsafe extern "C" fn(arg1: sk_sp<SkData>) -> u64>;
pub type SkPDF_EncodeJpegCallback = ::core::option::Option<
    unsafe extern "C" fn(
        dst: *mut SkWStream,
        src: *const SkPixmap,
        quality: ::core::ffi::c_int,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug)]
pub struct SkPDF_Metadata {
    pub fTitle: SkString,
    pub fAuthor: SkString,
    pub fSubject: SkString,
    pub fKeywords: SkString,
    pub fCreator: SkString,
    pub fProducer: SkString,
    pub fCreation: SkPDF_DateTime,
    pub fModified: SkPDF_DateTime,
    pub fLang: SkString,
    pub fRasterDPI: SkScalar,
    pub fPDFA: bool,
    pub fEncodingQuality: ::core::ffi::c_int,
    pub fStructureElementTreeRoot: *mut SkPDF_StructureElementNode,
    pub fOutline: SkPDF_Metadata_Outline,
    pub fExecutor: *mut SkExecutor,
    pub fCompressionLevel: SkPDF_Metadata_CompressionLevel,
    pub fSubsetter: SkPDF_Metadata_Subsetter,
    pub jpegDecoder: SkPDF_DecodeJpegCallback,
    pub jpegEncoder: SkPDF_EncodeJpegCallback,
    pub allowNoJpegs: bool,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPDF_Metadata_Outline {
    None = 0,
    StructureElementHeaders = 1,
    StructureElements = 2,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPDF_Metadata_CompressionLevel {
    Default = -1,
    None = 0,
    LowButFast = 1,
    Average = 6,
    HighButSlow = 9,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPDF_Metadata_Subsetter {
    kHarfbuzz_Subsetter = 0,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPDF_Metadata"][::core::mem::size_of::<SkPDF_Metadata>() - 152usize];
    ["Alignment of SkPDF_Metadata"][::core::mem::align_of::<SkPDF_Metadata>() - 8usize];
    ["Offset of field: SkPDF_Metadata::fTitle"]
        [::core::mem::offset_of!(SkPDF_Metadata, fTitle) - 0usize];
    ["Offset of field: SkPDF_Metadata::fAuthor"]
        [::core::mem::offset_of!(SkPDF_Metadata, fAuthor) - 8usize];
    ["Offset of field: SkPDF_Metadata::fSubject"]
        [::core::mem::offset_of!(SkPDF_Metadata, fSubject) - 16usize];
    ["Offset of field: SkPDF_Metadata::fKeywords"]
        [::core::mem::offset_of!(SkPDF_Metadata, fKeywords) - 24usize];
    ["Offset of field: SkPDF_Metadata::fCreator"]
        [::core::mem::offset_of!(SkPDF_Metadata, fCreator) - 32usize];
    ["Offset of field: SkPDF_Metadata::fProducer"]
        [::core::mem::offset_of!(SkPDF_Metadata, fProducer) - 40usize];
    ["Offset of field: SkPDF_Metadata::fCreation"]
        [::core::mem::offset_of!(SkPDF_Metadata, fCreation) - 48usize];
    ["Offset of field: SkPDF_Metadata::fModified"]
        [::core::mem::offset_of!(SkPDF_Metadata, fModified) - 58usize];
    ["Offset of field: SkPDF_Metadata::fLang"]
        [::core::mem::offset_of!(SkPDF_Metadata, fLang) - 72usize];
    ["Offset of field: SkPDF_Metadata::fRasterDPI"]
        [::core::mem::offset_of!(SkPDF_Metadata, fRasterDPI) - 80usize];
    ["Offset of field: SkPDF_Metadata::fPDFA"]
        [::core::mem::offset_of!(SkPDF_Metadata, fPDFA) - 84usize];
    ["Offset of field: SkPDF_Metadata::fEncodingQuality"]
        [::core::mem::offset_of!(SkPDF_Metadata, fEncodingQuality) - 88usize];
    ["Offset of field: SkPDF_Metadata::fStructureElementTreeRoot"]
        [::core::mem::offset_of!(SkPDF_Metadata, fStructureElementTreeRoot) - 96usize];
    ["Offset of field: SkPDF_Metadata::fOutline"]
        [::core::mem::offset_of!(SkPDF_Metadata, fOutline) - 104usize];
    ["Offset of field: SkPDF_Metadata::fExecutor"]
        [::core::mem::offset_of!(SkPDF_Metadata, fExecutor) - 112usize];
    ["Offset of field: SkPDF_Metadata::fCompressionLevel"]
        [::core::mem::offset_of!(SkPDF_Metadata, fCompressionLevel) - 120usize];
    ["Offset of field: SkPDF_Metadata::fSubsetter"]
        [::core::mem::offset_of!(SkPDF_Metadata, fSubsetter) - 124usize];
    ["Offset of field: SkPDF_Metadata::jpegDecoder"]
        [::core::mem::offset_of!(SkPDF_Metadata, jpegDecoder) - 128usize];
    ["Offset of field: SkPDF_Metadata::jpegEncoder"]
        [::core::mem::offset_of!(SkPDF_Metadata, jpegEncoder) - 136usize];
    ["Offset of field: SkPDF_Metadata::allowNoJpegs"]
        [::core::mem::offset_of!(SkPDF_Metadata, allowNoJpegs) - 144usize];
};
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkJpegEncoder_AlphaOption {
    Ignore = 0,
    BlendOnBlack = 1,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkJpegEncoder_Downsample {
    k420 = 0,
    k422 = 1,
    k444 = 2,
}
impl SkPath1DPathEffect_Style {
    pub const LastEnum: SkPath1DPathEffect_Style = SkPath1DPathEffect_Style::Morph;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPath1DPathEffect_Style {
    Translate = 0,
    Rotate = 1,
    Morph = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkBlender {
    pub _base: SkFlattenable,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkBlender"][::core::mem::size_of::<SkBlender>() - 16usize];
    ["Alignment of SkBlender"][::core::mem::align_of::<SkBlender>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkBlender4ModeE11SkBlendMode"]
    pub fn SkBlender_Mode(mode: SkBlendMode) -> sk_sp<SkBlender>;
}
impl SkBlender {
    #[inline]
    pub unsafe fn Mode(mode: SkBlendMode) -> sk_sp<SkBlender> {
        SkBlender_Mode(mode)
    }
}
#[repr(C)]
pub struct SkColorMatrix {
    pub fMat: __BindgenOpaqueArray<u32, 20usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkColorMatrix"][::core::mem::size_of::<SkColorMatrix>() - 80usize];
    ["Alignment of SkColorMatrix"][::core::mem::align_of::<SkColorMatrix>() - 4usize];
    ["Offset of field: SkColorMatrix::fMat"][::core::mem::offset_of!(SkColorMatrix, fMat) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix8RGBtoYUVE15SkYUVColorSpace"]
    pub fn SkColorMatrix_RGBtoYUV(arg1: SkYUVColorSpace) -> SkColorMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix8YUVtoRGBE15SkYUVColorSpace"]
    pub fn SkColorMatrix_YUVtoRGB(arg1: SkYUVColorSpace) -> SkColorMatrix;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix11setIdentityEv"]
    pub fn SkColorMatrix_setIdentity(this: *mut SkColorMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix8setScaleEffff"]
    pub fn SkColorMatrix_setScale(
        this: *mut SkColorMatrix,
        rScale: f32,
        gScale: f32,
        bScale: f32,
        aScale: f32,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix13postTranslateEffff"]
    pub fn SkColorMatrix_postTranslate(
        this: *mut SkColorMatrix,
        dr: f32,
        dg: f32,
        db: f32,
        da: f32,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix9setConcatERKS_S1_"]
    pub fn SkColorMatrix_setConcat(
        this: *mut SkColorMatrix,
        a: *const SkColorMatrix,
        b: *const SkColorMatrix,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkColorMatrix13setSaturationEf"]
    pub fn SkColorMatrix_setSaturation(this: *mut SkColorMatrix, sat: f32);
}
impl SkColorMatrix {
    #[inline]
    pub unsafe fn RGBtoYUV(arg1: SkYUVColorSpace) -> SkColorMatrix {
        SkColorMatrix_RGBtoYUV(arg1)
    }
    #[inline]
    pub unsafe fn YUVtoRGB(arg1: SkYUVColorSpace) -> SkColorMatrix {
        SkColorMatrix_YUVtoRGB(arg1)
    }
    #[inline]
    pub unsafe fn setIdentity(&mut self) {
        SkColorMatrix_setIdentity(self)
    }
    #[inline]
    pub unsafe fn setScale(&mut self, rScale: f32, gScale: f32, bScale: f32, aScale: f32) {
        SkColorMatrix_setScale(self, rScale, gScale, bScale, aScale)
    }
    #[inline]
    pub unsafe fn postTranslate(&mut self, dr: f32, dg: f32, db: f32, da: f32) {
        SkColorMatrix_postTranslate(self, dr, dg, db, da)
    }
    #[inline]
    pub unsafe fn setConcat(&mut self, a: *const SkColorMatrix, b: *const SkColorMatrix) {
        SkColorMatrix_setConcat(self, a, b)
    }
    #[inline]
    pub unsafe fn setSaturation(&mut self, sat: f32) {
        SkColorMatrix_setSaturation(self, sat)
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkPathEffect {
    pub _bindgen_opaque_blob: [u64; 2usize],
}
pub type SkPathEffect_INHERITED = SkFlattenable;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPathEffect"][::core::mem::size_of::<SkPathEffect>() - 16usize];
    ["Alignment of SkPathEffect"][::core::mem::align_of::<SkPathEffect>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkPathEffect7MakeSumE5sk_spIS_ES1_"]
    pub fn SkPathEffect_MakeSum(
        first: sk_sp<SkPathEffect>,
        second: sk_sp<SkPathEffect>,
    ) -> sk_sp<SkPathEffect>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkPathEffect11MakeComposeE5sk_spIS_ES1_"]
    pub fn SkPathEffect_MakeCompose(
        outer: sk_sp<SkPathEffect>,
        inner: sk_sp<SkPathEffect>,
    ) -> sk_sp<SkPathEffect>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkPathEffect10filterPathEP13SkPathBuilderRK6SkPathP11SkStrokeRecPK6SkRectRK8SkMatrix"]
    pub fn SkPathEffect_filterPath(
        this: *const SkPathEffect,
        dst: *mut SkPathBuilder,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
        ctm: *const SkMatrix,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkPathEffect10filterPathEP13SkPathBuilderRK6SkPathP11SkStrokeRec"]
    pub fn SkPathEffect_filterPath1(
        this: *const SkPathEffect,
        dst: *mut SkPathBuilder,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkPathEffect8needsCTMEv"]
    pub fn SkPathEffect_needsCTM(this: *const SkPathEffect) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN12SkPathEffect11DeserializeEPKvmPK15SkDeserialProcs"]
    pub fn SkPathEffect_Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPathEffect>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkPathEffect10filterPathEP6SkPathRKS0_P11SkStrokeRecPK6SkRect"]
    pub fn SkPathEffect_filterPath2(
        this: *const SkPathEffect,
        dst: *mut SkPath,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK12SkPathEffect10filterPathEP6SkPathRKS0_P11SkStrokeRecPK6SkRectRK8SkMatrix"]
    pub fn SkPathEffect_filterPath3(
        this: *const SkPathEffect,
        dst: *mut SkPath,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
        ctm: *const SkMatrix,
    ) -> bool;
}
impl SkPathEffect {
    #[inline]
    pub unsafe fn MakeSum(
        first: sk_sp<SkPathEffect>,
        second: sk_sp<SkPathEffect>,
    ) -> sk_sp<SkPathEffect> {
        SkPathEffect_MakeSum(first, second)
    }
    #[inline]
    pub unsafe fn MakeCompose(
        outer: sk_sp<SkPathEffect>,
        inner: sk_sp<SkPathEffect>,
    ) -> sk_sp<SkPathEffect> {
        SkPathEffect_MakeCompose(outer, inner)
    }
    #[inline]
    pub unsafe fn filterPath(
        &self,
        dst: *mut SkPathBuilder,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
        ctm: *const SkMatrix,
    ) -> bool {
        SkPathEffect_filterPath(self, dst, src, arg1, cullR, ctm)
    }
    #[inline]
    pub unsafe fn filterPath1(
        &self,
        dst: *mut SkPathBuilder,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
    ) -> bool {
        SkPathEffect_filterPath1(self, dst, src, arg1)
    }
    #[inline]
    pub unsafe fn needsCTM(&self) -> bool {
        SkPathEffect_needsCTM(self)
    }
    #[inline]
    pub unsafe fn Deserialize(
        data: *const ::core::ffi::c_void,
        size: usize,
        procs: *const SkDeserialProcs,
    ) -> sk_sp<SkPathEffect> {
        SkPathEffect_Deserialize(data, size, procs)
    }
    #[inline]
    pub unsafe fn filterPath2(
        &self,
        dst: *mut SkPath,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
    ) -> bool {
        SkPathEffect_filterPath2(self, dst, src, arg1, cullR)
    }
    #[inline]
    pub unsafe fn filterPath3(
        &self,
        dst: *mut SkPath,
        src: *const SkPath,
        arg1: *mut SkStrokeRec,
        cullR: *const SkRect,
        ctm: *const SkMatrix,
    ) -> bool {
        SkPathEffect_filterPath3(self, dst, src, arg1, cullR, ctm)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkGradientShader {
    pub _address: u8,
}
pub const SkGradientShader_Flags_kInterpolateColorsInPremul_Flag: SkGradientShader_Flags = 1;
pub type SkGradientShader_Flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkGradientShader_Interpolation {
    pub fInPremul: SkGradientShader_Interpolation_InPremul,
    pub fColorSpace: SkGradientShader_Interpolation_ColorSpace,
    pub fHueMethod: SkGradientShader_Interpolation_HueMethod,
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkGradientShader_Interpolation_InPremul {
    No = 0,
    Yes = 1,
}
impl SkGradientShader_Interpolation_ColorSpace {
    pub const LastColorSpace: SkGradientShader_Interpolation_ColorSpace =
        SkGradientShader_Interpolation_ColorSpace::A98RGB;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkGradientShader_Interpolation_ColorSpace {
    Destination = 0,
    SRGBLinear = 1,
    Lab = 2,
    OKLab = 3,
    OKLabGamutMap = 4,
    LCH = 5,
    OKLCH = 6,
    OKLCHGamutMap = 7,
    SRGB = 8,
    HSL = 9,
    HWB = 10,
    DisplayP3 = 11,
    Rec2020 = 12,
    ProphotoRGB = 13,
    A98RGB = 14,
}
impl SkGradientShader_Interpolation_HueMethod {
    pub const LastHueMethod: SkGradientShader_Interpolation_HueMethod =
        SkGradientShader_Interpolation_HueMethod::Decreasing;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkGradientShader_Interpolation_HueMethod {
    Shorter = 0,
    Longer = 1,
    Increasing = 2,
    Decreasing = 3,
}
pub const SkGradientShader_Interpolation_kColorSpaceCount: ::core::ffi::c_int = 15;
pub const SkGradientShader_Interpolation_kHueMethodCount: ::core::ffi::c_int = 4;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkGradientShader_Interpolation"]
        [::core::mem::size_of::<SkGradientShader_Interpolation>() - 3usize];
    ["Alignment of SkGradientShader_Interpolation"]
        [::core::mem::align_of::<SkGradientShader_Interpolation>() - 1usize];
    ["Offset of field: SkGradientShader_Interpolation::fInPremul"]
        [::core::mem::offset_of!(SkGradientShader_Interpolation, fInPremul) - 0usize];
    ["Offset of field: SkGradientShader_Interpolation::fColorSpace"]
        [::core::mem::offset_of!(SkGradientShader_Interpolation, fColorSpace) - 1usize];
    ["Offset of field: SkGradientShader_Interpolation::fHueMethod"]
        [::core::mem::offset_of!(SkGradientShader_Interpolation, fHueMethod) - 2usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkGradientShader"][::core::mem::size_of::<SkGradientShader>() - 1usize];
    ["Alignment of SkGradientShader"][::core::mem::align_of::<SkGradientShader>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader10MakeLinearEPK7SkPointPKjPKfi10SkTileModejPK8SkMatrix"]
    pub fn SkGradientShader_MakeLinear(
        pts: *const SkPoint,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader10MakeLinearEPK7SkPointPK8SkRGBA4fIL11SkAlphaType3EE5sk_spI12SkColorSpaceEPKfi10SkTileModeRKNS_13InterpolationEPK8SkMatrix"]
    pub fn SkGradientShader_MakeLinear1(
        pts: *const SkPoint,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader10MakeRadialERK7SkPointfPKjPKfi10SkTileModejPK8SkMatrix"]
    pub fn SkGradientShader_MakeRadial(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader10MakeRadialERK7SkPointfPK8SkRGBA4fIL11SkAlphaType3EE5sk_spI12SkColorSpaceEPKfi10SkTileModeRKNS_13InterpolationEPK8SkMatrix"]
    pub fn SkGradientShader_MakeRadial1(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader19MakeTwoPointConicalERK7SkPointfS2_fPKjPKfi10SkTileModejPK8SkMatrix"]
    pub fn SkGradientShader_MakeTwoPointConical(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader19MakeTwoPointConicalERK7SkPointfS2_fPK8SkRGBA4fIL11SkAlphaType3EE5sk_spI12SkColorSpaceEPKfi10SkTileModeRKNS_13InterpolationEPK8SkMatrix"]
    pub fn SkGradientShader_MakeTwoPointConical1(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader9MakeSweepEffPKjPKfi10SkTileModeffjPK8SkMatrix"]
    pub fn SkGradientShader_MakeSweep(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkGradientShader9MakeSweepEffPK8SkRGBA4fIL11SkAlphaType3EE5sk_spI12SkColorSpaceEPKfi10SkTileModeffRKNS_13InterpolationEPK8SkMatrix"]
    pub fn SkGradientShader_MakeSweep1(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
impl SkGradientShader {
    #[inline]
    pub unsafe fn MakeLinear(
        pts: *const SkPoint,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeLinear(pts, colors, pos, count, mode, flags, localMatrix)
    }
    #[inline]
    pub unsafe fn MakeLinear1(
        pts: *const SkPoint,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeLinear1(
            pts,
            colors,
            colorSpace,
            pos,
            count,
            mode,
            interpolation,
            localMatrix,
        )
    }
    #[inline]
    pub unsafe fn MakeRadial(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeRadial(center, radius, colors, pos, count, mode, flags, localMatrix)
    }
    #[inline]
    pub unsafe fn MakeRadial1(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeRadial1(
            center,
            radius,
            colors,
            colorSpace,
            pos,
            count,
            mode,
            interpolation,
            localMatrix,
        )
    }
    #[inline]
    pub unsafe fn MakeTwoPointConical(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeTwoPointConical(
            start,
            startRadius,
            end,
            endRadius,
            colors,
            pos,
            count,
            mode,
            flags,
            localMatrix,
        )
    }
    #[inline]
    pub unsafe fn MakeTwoPointConical1(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeTwoPointConical1(
            start,
            startRadius,
            end,
            endRadius,
            colors,
            colorSpace,
            pos,
            count,
            mode,
            interpolation,
            localMatrix,
        )
    }
    #[inline]
    pub unsafe fn MakeSweep(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeSweep(
            cx,
            cy,
            colors,
            pos,
            count,
            mode,
            startAngle,
            endAngle,
            flags,
            localMatrix,
        )
    }
    #[inline]
    pub unsafe fn MakeSweep1(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor4f,
        colorSpace: sk_sp<SkColorSpace>,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkGradientShader_MakeSweep1(
            cx,
            cy,
            colors,
            colorSpace,
            pos,
            count,
            mode,
            startAngle,
            endAngle,
            interpolation,
            localMatrix,
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkHighContrastConfig {
    pub fGrayscale: bool,
    pub fInvertStyle: SkHighContrastConfig_InvertStyle,
    pub fContrast: SkScalar,
}
impl SkHighContrastConfig_InvertStyle {
    pub const Last: SkHighContrastConfig_InvertStyle =
        SkHighContrastConfig_InvertStyle::InvertLightness;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkHighContrastConfig_InvertStyle {
    NoInvert = 0,
    InvertBrightness = 1,
    InvertLightness = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkHighContrastConfig"][::core::mem::size_of::<SkHighContrastConfig>() - 12usize];
    ["Alignment of SkHighContrastConfig"][::core::mem::align_of::<SkHighContrastConfig>() - 4usize];
    ["Offset of field: SkHighContrastConfig::fGrayscale"]
        [::core::mem::offset_of!(SkHighContrastConfig, fGrayscale) - 0usize];
    ["Offset of field: SkHighContrastConfig::fInvertStyle"]
        [::core::mem::offset_of!(SkHighContrastConfig, fInvertStyle) - 4usize];
    ["Offset of field: SkHighContrastConfig::fContrast"]
        [::core::mem::offset_of!(SkHighContrastConfig, fContrast) - 8usize];
};
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkImageFilters_Dither {
    No = 0,
    Yes = 1,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkSL_DebugTrace {
    pub _base: SkRefCnt,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSL_DebugTrace"][::core::mem::size_of::<SkSL_DebugTrace>() - 16usize];
    ["Alignment of SkSL_DebugTrace"][::core::mem::align_of::<SkSL_DebugTrace>() - 8usize];
};
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkSL_Version {
    k100 = 0,
    k300 = 1,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffect {
    pub _bindgen_opaque_blob: [u64; 18usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffect_Uniform {
    pub name: std_string_view,
    pub offset: usize,
    pub type_: SkRuntimeEffect_Uniform_Type,
    pub count: ::core::ffi::c_int,
    pub flags: u32,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRuntimeEffect_Uniform_Type {
    Float = 0,
    Float2 = 1,
    Float3 = 2,
    Float4 = 3,
    Float2x2 = 4,
    Float3x3 = 5,
    Float4x4 = 6,
    Int = 7,
    Int2 = 8,
    Int3 = 9,
    Int4 = 10,
}
pub const SkRuntimeEffect_Uniform_Flags_kArray_Flag: SkRuntimeEffect_Uniform_Flags = 1;
pub const SkRuntimeEffect_Uniform_Flags_kColor_Flag: SkRuntimeEffect_Uniform_Flags = 2;
pub const SkRuntimeEffect_Uniform_Flags_kVertex_Flag: SkRuntimeEffect_Uniform_Flags = 4;
pub const SkRuntimeEffect_Uniform_Flags_kFragment_Flag: SkRuntimeEffect_Uniform_Flags = 8;
pub const SkRuntimeEffect_Uniform_Flags_kHalfPrecision_Flag: SkRuntimeEffect_Uniform_Flags = 16;
pub type SkRuntimeEffect_Uniform_Flags = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_Uniform"]
        [::core::mem::size_of::<SkRuntimeEffect_Uniform>() - 40usize];
    ["Alignment of SkRuntimeEffect_Uniform"]
        [::core::mem::align_of::<SkRuntimeEffect_Uniform>() - 8usize];
    ["Offset of field: SkRuntimeEffect_Uniform::name"]
        [::core::mem::offset_of!(SkRuntimeEffect_Uniform, name) - 0usize];
    ["Offset of field: SkRuntimeEffect_Uniform::offset"]
        [::core::mem::offset_of!(SkRuntimeEffect_Uniform, offset) - 16usize];
    ["Offset of field: SkRuntimeEffect_Uniform::type_"]
        [::core::mem::offset_of!(SkRuntimeEffect_Uniform, type_) - 24usize];
    ["Offset of field: SkRuntimeEffect_Uniform::count"]
        [::core::mem::offset_of!(SkRuntimeEffect_Uniform, count) - 28usize];
    ["Offset of field: SkRuntimeEffect_Uniform::flags"]
        [::core::mem::offset_of!(SkRuntimeEffect_Uniform, flags) - 32usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect7Uniform11sizeInBytesEv"]
    pub fn SkRuntimeEffect_Uniform_sizeInBytes(this: *const SkRuntimeEffect_Uniform) -> usize;
}
impl SkRuntimeEffect_Uniform {
    #[inline]
    pub unsafe fn sizeInBytes(&self) -> usize {
        SkRuntimeEffect_Uniform_sizeInBytes(self)
    }
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkRuntimeEffect_ChildType {
    Shader = 0,
    ColorFilter = 1,
    Blender = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffect_Child {
    pub name: std_string_view,
    pub type_: SkRuntimeEffect_ChildType,
    pub index: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_Child"][::core::mem::size_of::<SkRuntimeEffect_Child>() - 24usize];
    ["Alignment of SkRuntimeEffect_Child"]
        [::core::mem::align_of::<SkRuntimeEffect_Child>() - 8usize];
    ["Offset of field: SkRuntimeEffect_Child::name"]
        [::core::mem::offset_of!(SkRuntimeEffect_Child, name) - 0usize];
    ["Offset of field: SkRuntimeEffect_Child::type_"]
        [::core::mem::offset_of!(SkRuntimeEffect_Child, type_) - 16usize];
    ["Offset of field: SkRuntimeEffect_Child::index"]
        [::core::mem::offset_of!(SkRuntimeEffect_Child, index) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffect_Options {
    pub forceUnoptimized: bool,
    pub fName: std_string_view,
    pub allowPrivateAccess: bool,
    pub fStableKey: u32,
    pub maxVersionAllowed: SkSL_Version,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_Options"]
        [::core::mem::size_of::<SkRuntimeEffect_Options>() - 40usize];
    ["Alignment of SkRuntimeEffect_Options"]
        [::core::mem::align_of::<SkRuntimeEffect_Options>() - 8usize];
    ["Offset of field: SkRuntimeEffect_Options::forceUnoptimized"]
        [::core::mem::offset_of!(SkRuntimeEffect_Options, forceUnoptimized) - 0usize];
    ["Offset of field: SkRuntimeEffect_Options::fName"]
        [::core::mem::offset_of!(SkRuntimeEffect_Options, fName) - 8usize];
    ["Offset of field: SkRuntimeEffect_Options::allowPrivateAccess"]
        [::core::mem::offset_of!(SkRuntimeEffect_Options, allowPrivateAccess) - 24usize];
    ["Offset of field: SkRuntimeEffect_Options::fStableKey"]
        [::core::mem::offset_of!(SkRuntimeEffect_Options, fStableKey) - 28usize];
    ["Offset of field: SkRuntimeEffect_Options::maxVersionAllowed"]
        [::core::mem::offset_of!(SkRuntimeEffect_Options, maxVersionAllowed) - 32usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkRuntimeEffect_Result {
    pub effect: sk_sp<SkRuntimeEffect>,
    pub errorText: SkString,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_Result"][::core::mem::size_of::<SkRuntimeEffect_Result>() - 16usize];
    ["Alignment of SkRuntimeEffect_Result"]
        [::core::mem::align_of::<SkRuntimeEffect_Result>() - 8usize];
    ["Offset of field: SkRuntimeEffect_Result::effect"]
        [::core::mem::offset_of!(SkRuntimeEffect_Result, effect) - 0usize];
    ["Offset of field: SkRuntimeEffect_Result::errorText"]
        [::core::mem::offset_of!(SkRuntimeEffect_Result, errorText) - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct SkRuntimeEffect_ChildPtr {
    pub fChild: sk_sp<SkFlattenable>,
}
pub type SkRuntimeEffect_ChildPtr_sk_is_trivially_relocatable = std_true_type;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_ChildPtr"]
        [::core::mem::size_of::<SkRuntimeEffect_ChildPtr>() - 8usize];
    ["Alignment of SkRuntimeEffect_ChildPtr"]
        [::core::mem::align_of::<SkRuntimeEffect_ChildPtr>() - 8usize];
    ["Offset of field: SkRuntimeEffect_ChildPtr::fChild"]
        [::core::mem::offset_of!(SkRuntimeEffect_ChildPtr, fChild) - 0usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect8ChildPtr4typeEv"]
    pub fn SkRuntimeEffect_ChildPtr_type(this: *const SkRuntimeEffect_ChildPtr) -> u8;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect8ChildPtr6shaderEv"]
    pub fn SkRuntimeEffect_ChildPtr_shader(this: *const SkRuntimeEffect_ChildPtr) -> *mut SkShader;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect8ChildPtr11colorFilterEv"]
    pub fn SkRuntimeEffect_ChildPtr_colorFilter(
        this: *const SkRuntimeEffect_ChildPtr,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect8ChildPtr7blenderEv"]
    pub fn SkRuntimeEffect_ChildPtr_blender(
        this: *const SkRuntimeEffect_ChildPtr,
    ) -> *mut SkBlender;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect8ChildPtrC1E5sk_spI13SkFlattenableE"]
    pub fn SkRuntimeEffect_ChildPtr_ChildPtr(
        this: *mut SkRuntimeEffect_ChildPtr,
        f: sk_sp<SkFlattenable>,
    );
}
impl SkRuntimeEffect_ChildPtr {
    #[inline]
    pub unsafe fn type_(&self) -> u8 {
        SkRuntimeEffect_ChildPtr_type(self)
    }
    #[inline]
    pub unsafe fn shader(&self) -> *mut SkShader {
        SkRuntimeEffect_ChildPtr_shader(self)
    }
    #[inline]
    pub unsafe fn colorFilter(&self) -> *mut SkColorFilter {
        SkRuntimeEffect_ChildPtr_colorFilter(self)
    }
    #[inline]
    pub unsafe fn blender(&self) -> *mut SkBlender {
        SkRuntimeEffect_ChildPtr_blender(self)
    }
    #[inline]
    pub unsafe fn new(f: sk_sp<SkFlattenable>) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkRuntimeEffect_ChildPtr_ChildPtr(__bindgen_tmp.as_mut_ptr(), f);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SkRuntimeEffect_TracedShader {
    pub shader: sk_sp<SkShader>,
    pub debugTrace: sk_sp<SkSL_DebugTrace>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect_TracedShader"]
        [::core::mem::size_of::<SkRuntimeEffect_TracedShader>() - 16usize];
    ["Alignment of SkRuntimeEffect_TracedShader"]
        [::core::mem::align_of::<SkRuntimeEffect_TracedShader>() - 8usize];
    ["Offset of field: SkRuntimeEffect_TracedShader::shader"]
        [::core::mem::offset_of!(SkRuntimeEffect_TracedShader, shader) - 0usize];
    ["Offset of field: SkRuntimeEffect_TracedShader::debugTrace"]
        [::core::mem::offset_of!(SkRuntimeEffect_TracedShader, debugTrace) - 8usize];
};
pub const SkRuntimeEffect_Flags_kUsesSampleCoords_Flag: SkRuntimeEffect_Flags = 1;
pub const SkRuntimeEffect_Flags_kAllowColorFilter_Flag: SkRuntimeEffect_Flags = 2;
pub const SkRuntimeEffect_Flags_kAllowShader_Flag: SkRuntimeEffect_Flags = 4;
pub const SkRuntimeEffect_Flags_kAllowBlender_Flag: SkRuntimeEffect_Flags = 8;
pub const SkRuntimeEffect_Flags_kSamplesOutsideMain_Flag: SkRuntimeEffect_Flags = 16;
pub const SkRuntimeEffect_Flags_kUsesColorTransform_Flag: SkRuntimeEffect_Flags = 32;
pub const SkRuntimeEffect_Flags_kAlwaysOpaque_Flag: SkRuntimeEffect_Flags = 64;
pub const SkRuntimeEffect_Flags_kAlphaUnchanged_Flag: SkRuntimeEffect_Flags = 128;
pub const SkRuntimeEffect_Flags_kDisableOptimization_Flag: SkRuntimeEffect_Flags = 256;
pub type SkRuntimeEffect_Flags = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffect"][::core::mem::size_of::<SkRuntimeEffect>() - 144usize];
    ["Alignment of SkRuntimeEffect"][::core::mem::align_of::<SkRuntimeEffect>() - 8usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect18MakeForColorFilterE8SkStringRKNS_7OptionsE"]
    pub fn SkRuntimeEffect_MakeForColorFilter(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect13MakeForShaderE8SkStringRKNS_7OptionsE"]
    pub fn SkRuntimeEffect_MakeForShader(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect14MakeForBlenderE8SkStringRKNS_7OptionsE"]
    pub fn SkRuntimeEffect_MakeForBlender(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect10makeShaderE5sk_spIK6SkDataEPS0_I8SkShaderEmPK8SkMatrix"]
    pub fn SkRuntimeEffect_makeShader(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
        children: *mut sk_sp<SkShader>,
        childCount: usize,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect10makeShaderE5sk_spIK6SkDataE6SkSpanIKNS_8ChildPtrEEPK8SkMatrix"]
    pub fn SkRuntimeEffect_makeShader1(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect15makeColorFilterE5sk_spIK6SkDataE"]
    pub fn SkRuntimeEffect_makeColorFilter(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect15makeColorFilterE5sk_spIK6SkDataEPS0_I13SkColorFilterEm"]
    pub fn SkRuntimeEffect_makeColorFilter1(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
        children: *mut sk_sp<SkColorFilter>,
        childCount: usize,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect15makeColorFilterE5sk_spIK6SkDataE6SkSpanIKNS_8ChildPtrEE"]
    pub fn SkRuntimeEffect_makeColorFilter2(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect11makeBlenderE5sk_spIK6SkDataE6SkSpanIKNS_8ChildPtrEE"]
    pub fn SkRuntimeEffect_makeBlender(
        this: *const SkRuntimeEffect,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
    ) -> sk_sp<SkBlender>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect10MakeTracedE5sk_spI8SkShaderERK8SkIPoint"]
    pub fn SkRuntimeEffect_MakeTraced(
        shader: sk_sp<SkShader>,
        traceCoord: *const SkIPoint,
    ) -> SkRuntimeEffect_TracedShader;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect6sourceB5cxx11Ev"]
    pub fn SkRuntimeEffect_source(this: *const SkRuntimeEffect) -> *const std_string;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect11uniformSizeEv"]
    pub fn SkRuntimeEffect_uniformSize(this: *const SkRuntimeEffect) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect11findUniformESt17basic_string_viewIcSt11char_traitsIcEE"]
    pub fn SkRuntimeEffect_findUniform(
        this: *const SkRuntimeEffect,
        name: std_string_view,
    ) -> *const SkRuntimeEffect_Uniform;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK15SkRuntimeEffect9findChildESt17basic_string_viewIcSt11char_traitsIcEE"]
    pub fn SkRuntimeEffect_findChild(
        this: *const SkRuntimeEffect,
        name: std_string_view,
    ) -> *const SkRuntimeEffect_Child;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffect20RegisterFlattenablesEv"]
    pub fn SkRuntimeEffect_RegisterFlattenables();
}
impl SkRuntimeEffect {
    #[inline]
    pub unsafe fn MakeForColorFilter(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result {
        SkRuntimeEffect_MakeForColorFilter(sksl, arg1)
    }
    #[inline]
    pub unsafe fn MakeForShader(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result {
        SkRuntimeEffect_MakeForShader(sksl, arg1)
    }
    #[inline]
    pub unsafe fn MakeForBlender(
        sksl: SkString,
        arg1: *const SkRuntimeEffect_Options,
    ) -> SkRuntimeEffect_Result {
        SkRuntimeEffect_MakeForBlender(sksl, arg1)
    }
    #[inline]
    pub unsafe fn makeShader(
        &self,
        uniforms: sk_sp<SkData>,
        children: *mut sk_sp<SkShader>,
        childCount: usize,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkRuntimeEffect_makeShader(self, uniforms, children, childCount, localMatrix)
    }
    #[inline]
    pub unsafe fn makeShader1(
        &self,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader> {
        SkRuntimeEffect_makeShader1(self, uniforms, children, localMatrix)
    }
    #[inline]
    pub unsafe fn makeColorFilter(&self, uniforms: sk_sp<SkData>) -> sk_sp<SkColorFilter> {
        SkRuntimeEffect_makeColorFilter(self, uniforms)
    }
    #[inline]
    pub unsafe fn makeColorFilter1(
        &self,
        uniforms: sk_sp<SkData>,
        children: *mut sk_sp<SkColorFilter>,
        childCount: usize,
    ) -> sk_sp<SkColorFilter> {
        SkRuntimeEffect_makeColorFilter1(self, uniforms, children, childCount)
    }
    #[inline]
    pub unsafe fn makeColorFilter2(
        &self,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
    ) -> sk_sp<SkColorFilter> {
        SkRuntimeEffect_makeColorFilter2(self, uniforms, children)
    }
    #[inline]
    pub unsafe fn makeBlender(
        &self,
        uniforms: sk_sp<SkData>,
        children: SkSpan<SkRuntimeEffect_ChildPtr>,
    ) -> sk_sp<SkBlender> {
        SkRuntimeEffect_makeBlender(self, uniforms, children)
    }
    #[inline]
    pub unsafe fn MakeTraced(
        shader: sk_sp<SkShader>,
        traceCoord: *const SkIPoint,
    ) -> SkRuntimeEffect_TracedShader {
        SkRuntimeEffect_MakeTraced(shader, traceCoord)
    }
    #[inline]
    pub unsafe fn source(&self) -> *const std_string {
        SkRuntimeEffect_source(self)
    }
    #[inline]
    pub unsafe fn uniformSize(&self) -> usize {
        SkRuntimeEffect_uniformSize(self)
    }
    #[inline]
    pub unsafe fn findUniform(&self, name: std_string_view) -> *const SkRuntimeEffect_Uniform {
        SkRuntimeEffect_findUniform(self, name)
    }
    #[inline]
    pub unsafe fn findChild(&self, name: std_string_view) -> *const SkRuntimeEffect_Child {
        SkRuntimeEffect_findChild(self, name)
    }
    #[inline]
    pub unsafe fn RegisterFlattenables() {
        SkRuntimeEffect_RegisterFlattenables()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN15SkRuntimeEffectD1Ev"]
    pub fn SkRuntimeEffect_SkRuntimeEffect_destructor(this: *mut SkRuntimeEffect);
}
#[repr(C)]
pub struct SkRuntimeEffectBuilder {
    pub fEffect: sk_sp<SkRuntimeEffect>,
    pub fUniforms: sk_sp<SkData>,
    pub fChildren: __BindgenOpaqueArray<u64, 3usize>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffectBuilder_BuilderUniform {
    pub fOwner: *mut SkRuntimeEffectBuilder,
    pub fVar: *const SkRuntimeEffect_Uniform,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffectBuilder_BuilderUniform"]
        [::core::mem::size_of::<SkRuntimeEffectBuilder_BuilderUniform>() - 16usize];
    ["Alignment of SkRuntimeEffectBuilder_BuilderUniform"]
        [::core::mem::align_of::<SkRuntimeEffectBuilder_BuilderUniform>() - 8usize];
    ["Offset of field: SkRuntimeEffectBuilder_BuilderUniform::fOwner"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder_BuilderUniform, fOwner) - 0usize];
    ["Offset of field: SkRuntimeEffectBuilder_BuilderUniform::fVar"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder_BuilderUniform, fVar) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkRuntimeEffectBuilder_BuilderChild {
    pub fOwner: *mut SkRuntimeEffectBuilder,
    pub fChild: *const SkRuntimeEffect_Child,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffectBuilder_BuilderChild"]
        [::core::mem::size_of::<SkRuntimeEffectBuilder_BuilderChild>() - 16usize];
    ["Alignment of SkRuntimeEffectBuilder_BuilderChild"]
        [::core::mem::align_of::<SkRuntimeEffectBuilder_BuilderChild>() - 8usize];
    ["Offset of field: SkRuntimeEffectBuilder_BuilderChild::fOwner"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder_BuilderChild, fOwner) - 0usize];
    ["Offset of field: SkRuntimeEffectBuilder_BuilderChild::fChild"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder_BuilderChild, fChild) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkRuntimeEffectBuilder"][::core::mem::size_of::<SkRuntimeEffectBuilder>() - 40usize];
    ["Alignment of SkRuntimeEffectBuilder"]
        [::core::mem::align_of::<SkRuntimeEffectBuilder>() - 8usize];
    ["Offset of field: SkRuntimeEffectBuilder::fEffect"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder, fEffect) - 0usize];
    ["Offset of field: SkRuntimeEffectBuilder::fUniforms"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder, fUniforms) - 8usize];
    ["Offset of field: SkRuntimeEffectBuilder::fChildren"]
        [::core::mem::offset_of!(SkRuntimeEffectBuilder, fChildren) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkRuntimeEffectBuilder10makeShaderEPK8SkMatrix"]
    pub fn SkRuntimeEffectBuilder_makeShader(
        this: *const SkRuntimeEffectBuilder,
        localMatrix: *const SkMatrix,
    ) -> sk_sp<SkShader>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkRuntimeEffectBuilder15makeColorFilterEv"]
    pub fn SkRuntimeEffectBuilder_makeColorFilter(
        this: *const SkRuntimeEffectBuilder,
    ) -> sk_sp<SkColorFilter>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK22SkRuntimeEffectBuilder11makeBlenderEv"]
    pub fn SkRuntimeEffectBuilder_makeBlender(
        this: *const SkRuntimeEffectBuilder,
    ) -> sk_sp<SkBlender>;
}
impl SkRuntimeEffectBuilder {
    #[inline]
    pub unsafe fn makeShader(&self, localMatrix: *const SkMatrix) -> sk_sp<SkShader> {
        SkRuntimeEffectBuilder_makeShader(self, localMatrix)
    }
    #[inline]
    pub unsafe fn makeColorFilter(&self) -> sk_sp<SkColorFilter> {
        SkRuntimeEffectBuilder_makeColorFilter(self)
    }
    #[inline]
    pub unsafe fn makeBlender(&self) -> sk_sp<SkBlender> {
        SkRuntimeEffectBuilder_makeBlender(self)
    }
}
pub type SkRuntimeShaderBuilder = SkRuntimeEffectBuilder;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTableMaskFilter {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTableMaskFilter"][::core::mem::size_of::<SkTableMaskFilter>() - 1usize];
    ["Alignment of SkTableMaskFilter"][::core::mem::align_of::<SkTableMaskFilter>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTableMaskFilter14MakeGammaTableEPhf"]
    pub fn SkTableMaskFilter_MakeGammaTable(table: *mut u8, gamma: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTableMaskFilter13MakeClipTableEPhhh"]
    pub fn SkTableMaskFilter_MakeClipTable(table: *mut u8, min: u8, max: u8);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTableMaskFilter6CreateEPKh"]
    pub fn SkTableMaskFilter_Create(table: *const u8) -> *mut SkMaskFilter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTableMaskFilter11CreateGammaEf"]
    pub fn SkTableMaskFilter_CreateGamma(gamma: SkScalar) -> *mut SkMaskFilter;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN17SkTableMaskFilter10CreateClipEhh"]
    pub fn SkTableMaskFilter_CreateClip(min: u8, max: u8) -> *mut SkMaskFilter;
}
impl SkTableMaskFilter {
    #[inline]
    pub unsafe fn MakeGammaTable(table: *mut u8, gamma: SkScalar) {
        SkTableMaskFilter_MakeGammaTable(table, gamma)
    }
    #[inline]
    pub unsafe fn MakeClipTable(table: *mut u8, min: u8, max: u8) {
        SkTableMaskFilter_MakeClipTable(table, min, max)
    }
    #[inline]
    pub unsafe fn Create(table: *const u8) -> *mut SkMaskFilter {
        SkTableMaskFilter_Create(table)
    }
    #[inline]
    pub unsafe fn CreateGamma(gamma: SkScalar) -> *mut SkMaskFilter {
        SkTableMaskFilter_CreateGamma(gamma)
    }
    #[inline]
    pub unsafe fn CreateClip(min: u8, max: u8) -> *mut SkMaskFilter {
        SkTableMaskFilter_CreateClip(min, max)
    }
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTrimPathEffect_Mode {
    Normal = 0,
    Inverted = 1,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPngEncoder_FilterFlag {
    kZero = 0,
    kNone = 8,
    kSub = 16,
    kUp = 32,
    kAvg = 64,
    kPaeth = 128,
    kAll = 248,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkPathOp {
    Difference = 0,
    Intersect = 1,
    Union = 2,
    XOR = 3,
    ReverseDifference = 4,
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z2OpRK6SkPathS1_8SkPathOpPS_"]
    pub fn Op(one: *const SkPath, two: *const SkPath, op: SkPathOp, result: *mut SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z8SimplifyRK6SkPathPS_"]
    pub fn Simplify(path: *const SkPath, result: *mut SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_Z9AsWindingRK6SkPathPS_"]
    pub fn AsWinding(path: *const SkPath, result: *mut SkPath) -> bool;
}
#[repr(C)]
#[derive(Debug)]
pub struct SkOpBuilder {
    pub fPathRefs: __BindgenOpaqueArray<u64, 2usize>,
    pub fOps: SkTDArray,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkOpBuilder"][::core::mem::size_of::<SkOpBuilder>() - 40usize];
    ["Alignment of SkOpBuilder"][::core::mem::align_of::<SkOpBuilder>() - 8usize];
    ["Offset of field: SkOpBuilder::fPathRefs"]
        [::core::mem::offset_of!(SkOpBuilder, fPathRefs) - 0usize];
    ["Offset of field: SkOpBuilder::fOps"][::core::mem::offset_of!(SkOpBuilder, fOps) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkOpBuilder3addERK6SkPath8SkPathOp"]
    pub fn SkOpBuilder_add(this: *mut SkOpBuilder, path: *const SkPath, _operator: SkPathOp);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkOpBuilder7resolveEP6SkPath"]
    pub fn SkOpBuilder_resolve(this: *mut SkOpBuilder, result: *mut SkPath) -> bool;
}
impl SkOpBuilder {
    #[inline]
    pub unsafe fn add(&mut self, path: *const SkPath, _operator: SkPathOp) {
        SkOpBuilder_add(self, path, _operator)
    }
    #[inline]
    pub unsafe fn resolve(&mut self, result: *mut SkPath) -> bool {
        SkOpBuilder_resolve(self, result)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkSVGCanvas {
    pub _address: u8,
}
pub const SkSVGCanvas_kConvertTextToPaths_Flag: SkSVGCanvas__bindgen_ty_1 =
    SkSVGCanvas__bindgen_ty_1::kConvertTextToPaths_Flag;
pub const SkSVGCanvas_kNoPrettyXML_Flag: SkSVGCanvas__bindgen_ty_1 =
    SkSVGCanvas__bindgen_ty_1::kNoPrettyXML_Flag;
pub const SkSVGCanvas_kRelativePathEncoding_Flag: SkSVGCanvas__bindgen_ty_1 =
    SkSVGCanvas__bindgen_ty_1::kRelativePathEncoding_Flag;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkSVGCanvas__bindgen_ty_1 {
    kConvertTextToPaths_Flag = 1,
    kNoPrettyXML_Flag = 2,
    kRelativePathEncoding_Flag = 4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkSVGCanvas"][::core::mem::size_of::<SkSVGCanvas>() - 1usize];
    ["Alignment of SkSVGCanvas"][::core::mem::align_of::<SkSVGCanvas>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkSVGCanvas4MakeERK6SkRectP9SkWStreamj"]
    pub fn SkSVGCanvas_Make(bounds: *const SkRect, arg1: *mut SkWStream, flags: u32) -> u64;
}
impl SkSVGCanvas {
    #[inline]
    pub unsafe fn Make(bounds: *const SkRect, arg1: *mut SkWStream, flags: u32) -> u64 {
        SkSVGCanvas_Make(bounds, arg1, flags)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkPatch3D {
    pub fU: SkV3,
    pub fV: SkV3,
    pub fOrigin: SkV3,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkPatch3D"][::core::mem::size_of::<SkPatch3D>() - 36usize];
    ["Alignment of SkPatch3D"][::core::mem::align_of::<SkPatch3D>() - 4usize];
    ["Offset of field: SkPatch3D::fU"][::core::mem::offset_of!(SkPatch3D, fU) - 0usize];
    ["Offset of field: SkPatch3D::fV"][::core::mem::offset_of!(SkPatch3D, fV) - 12usize];
    ["Offset of field: SkPatch3D::fOrigin"][::core::mem::offset_of!(SkPatch3D, fOrigin) - 24usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPatch3D5resetEv"]
    pub fn SkPatch3D_reset(this: *mut SkPatch3D);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPatch3D9transformERK5SkM44PS_"]
    pub fn SkPatch3D_transform(this: *const SkPatch3D, arg1: *const SkM44, dst: *mut SkPatch3D);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK9SkPatch3D7dotWithEfff"]
    pub fn SkPatch3D_dotWith(
        this: *const SkPatch3D,
        dx: SkScalar,
        dy: SkScalar,
        dz: SkScalar,
    ) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN9SkPatch3DC1Ev"]
    pub fn SkPatch3D_SkPatch3D(this: *mut SkPatch3D);
}
impl SkPatch3D {
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkPatch3D_reset(self)
    }
    #[inline]
    pub unsafe fn transform(&self, arg1: *const SkM44, dst: *mut SkPatch3D) {
        SkPatch3D_transform(self, arg1, dst)
    }
    #[inline]
    pub unsafe fn dotWith(&self, dx: SkScalar, dy: SkScalar, dz: SkScalar) -> SkScalar {
        SkPatch3D_dotWith(self, dx, dy, dz)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkPatch3D_SkPatch3D(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkCamera3D {
    pub fLocation: SkV3,
    pub fAxis: SkV3,
    pub fZenith: SkV3,
    pub fObserver: SkV3,
    pub fOrientation: SkMatrix,
    pub fNeedToUpdate: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCamera3D"][::core::mem::size_of::<SkCamera3D>() - 92usize];
    ["Alignment of SkCamera3D"][::core::mem::align_of::<SkCamera3D>() - 4usize];
    ["Offset of field: SkCamera3D::fLocation"]
        [::core::mem::offset_of!(SkCamera3D, fLocation) - 0usize];
    ["Offset of field: SkCamera3D::fAxis"][::core::mem::offset_of!(SkCamera3D, fAxis) - 12usize];
    ["Offset of field: SkCamera3D::fZenith"]
        [::core::mem::offset_of!(SkCamera3D, fZenith) - 24usize];
    ["Offset of field: SkCamera3D::fObserver"]
        [::core::mem::offset_of!(SkCamera3D, fObserver) - 36usize];
    ["Offset of field: SkCamera3D::fOrientation"]
        [::core::mem::offset_of!(SkCamera3D, fOrientation) - 48usize];
    ["Offset of field: SkCamera3D::fNeedToUpdate"]
        [::core::mem::offset_of!(SkCamera3D, fNeedToUpdate) - 88usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkCamera3D5resetEv"]
    pub fn SkCamera3D_reset(this: *mut SkCamera3D);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkCamera3D6updateEv"]
    pub fn SkCamera3D_update(this: *mut SkCamera3D);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10SkCamera3D13patchToMatrixERK9SkPatch3DP8SkMatrix"]
    pub fn SkCamera3D_patchToMatrix(
        this: *const SkCamera3D,
        arg1: *const SkPatch3D,
        matrix: *mut SkMatrix,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10SkCamera3DC1Ev"]
    pub fn SkCamera3D_SkCamera3D(this: *mut SkCamera3D);
}
impl SkCamera3D {
    #[inline]
    pub unsafe fn reset(&mut self) {
        SkCamera3D_reset(self)
    }
    #[inline]
    pub unsafe fn update(&mut self) {
        SkCamera3D_update(self)
    }
    #[inline]
    pub unsafe fn patchToMatrix(&self, arg1: *const SkPatch3D, matrix: *mut SkMatrix) {
        SkCamera3D_patchToMatrix(self, arg1, matrix)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCamera3D_SkCamera3D(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct Sk3DView {
    pub fRec: *mut Sk3DView_Rec,
    pub fInitialRec: Sk3DView_Rec,
    pub fCamera: SkCamera3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sk3DView_Rec {
    pub fNext: *mut Sk3DView_Rec,
    pub fMatrix: SkM44,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of Sk3DView_Rec"][::core::mem::size_of::<Sk3DView_Rec>() - 72usize];
    ["Alignment of Sk3DView_Rec"][::core::mem::align_of::<Sk3DView_Rec>() - 8usize];
    ["Offset of field: Sk3DView_Rec::fNext"][::core::mem::offset_of!(Sk3DView_Rec, fNext) - 0usize];
    ["Offset of field: Sk3DView_Rec::fMatrix"]
        [::core::mem::offset_of!(Sk3DView_Rec, fMatrix) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of Sk3DView"][::core::mem::size_of::<Sk3DView>() - 176usize];
    ["Alignment of Sk3DView"][::core::mem::align_of::<Sk3DView>() - 8usize];
    ["Offset of field: Sk3DView::fRec"][::core::mem::offset_of!(Sk3DView, fRec) - 0usize];
    ["Offset of field: Sk3DView::fInitialRec"]
        [::core::mem::offset_of!(Sk3DView, fInitialRec) - 8usize];
    ["Offset of field: Sk3DView::fCamera"][::core::mem::offset_of!(Sk3DView, fCamera) - 80usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView4saveEv"]
    pub fn Sk3DView_save(this: *mut Sk3DView);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView7restoreEv"]
    pub fn Sk3DView_restore(this: *mut Sk3DView);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView9translateEfff"]
    pub fn Sk3DView_translate(this: *mut Sk3DView, x: SkScalar, y: SkScalar, z: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView7rotateXEf"]
    pub fn Sk3DView_rotateX(this: *mut Sk3DView, deg: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView7rotateYEf"]
    pub fn Sk3DView_rotateY(this: *mut Sk3DView, deg: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DView7rotateZEf"]
    pub fn Sk3DView_rotateZ(this: *mut Sk3DView, deg: SkScalar);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8Sk3DView9getMatrixEP8SkMatrix"]
    pub fn Sk3DView_getMatrix(this: *const Sk3DView, arg1: *mut SkMatrix);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8Sk3DView13applyToCanvasEP8SkCanvas"]
    pub fn Sk3DView_applyToCanvas(this: *const Sk3DView, arg1: *mut SkCanvas);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK8Sk3DView13dotWithNormalEfff"]
    pub fn Sk3DView_dotWithNormal(
        this: *const Sk3DView,
        dx: SkScalar,
        dy: SkScalar,
        dz: SkScalar,
    ) -> SkScalar;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DViewC1Ev"]
    pub fn Sk3DView_Sk3DView(this: *mut Sk3DView);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN8Sk3DViewD1Ev"]
    pub fn Sk3DView_Sk3DView_destructor(this: *mut Sk3DView);
}
impl Sk3DView {
    #[inline]
    pub unsafe fn save(&mut self) {
        Sk3DView_save(self)
    }
    #[inline]
    pub unsafe fn restore(&mut self) {
        Sk3DView_restore(self)
    }
    #[inline]
    pub unsafe fn translate(&mut self, x: SkScalar, y: SkScalar, z: SkScalar) {
        Sk3DView_translate(self, x, y, z)
    }
    #[inline]
    pub unsafe fn rotateX(&mut self, deg: SkScalar) {
        Sk3DView_rotateX(self, deg)
    }
    #[inline]
    pub unsafe fn rotateY(&mut self, deg: SkScalar) {
        Sk3DView_rotateY(self, deg)
    }
    #[inline]
    pub unsafe fn rotateZ(&mut self, deg: SkScalar) {
        Sk3DView_rotateZ(self, deg)
    }
    #[inline]
    pub unsafe fn getMatrix(&self, arg1: *mut SkMatrix) {
        Sk3DView_getMatrix(self, arg1)
    }
    #[inline]
    pub unsafe fn applyToCanvas(&self, arg1: *mut SkCanvas) {
        Sk3DView_applyToCanvas(self, arg1)
    }
    #[inline]
    pub unsafe fn dotWithNormal(&self, dx: SkScalar, dy: SkScalar, dz: SkScalar) -> SkScalar {
        Sk3DView_dotWithNormal(self, dx, dy, dz)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        Sk3DView_Sk3DView(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        Sk3DView_Sk3DView_destructor(self)
    }
}
#[repr(C)]
pub struct SkCustomTypefaceBuilder {
    pub fGlyphRecs: __BindgenOpaqueArray<u64, 3usize>,
    pub fMetrics: SkFontMetrics,
    pub fStyle: SkFontStyle,
}
#[repr(C)]
#[derive(Debug)]
pub struct SkCustomTypefaceBuilder_GlyphRec {
    pub fPath: SkPath,
    pub fDrawable: sk_sp<SkDrawable>,
    pub fBounds: SkRect,
    pub fAdvance: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCustomTypefaceBuilder_GlyphRec"]
        [::core::mem::size_of::<SkCustomTypefaceBuilder_GlyphRec>() - 48usize];
    ["Alignment of SkCustomTypefaceBuilder_GlyphRec"]
        [::core::mem::align_of::<SkCustomTypefaceBuilder_GlyphRec>() - 8usize];
    ["Offset of field: SkCustomTypefaceBuilder_GlyphRec::fPath"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder_GlyphRec, fPath) - 0usize];
    ["Offset of field: SkCustomTypefaceBuilder_GlyphRec::fDrawable"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder_GlyphRec, fDrawable) - 16usize];
    ["Offset of field: SkCustomTypefaceBuilder_GlyphRec::fBounds"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder_GlyphRec, fBounds) - 24usize];
    ["Offset of field: SkCustomTypefaceBuilder_GlyphRec::fAdvance"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder_GlyphRec, fAdvance) - 40usize];
};
pub const SkCustomTypefaceBuilder_FactoryId: SkTypeface_FactoryId = 1970496882;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkCustomTypefaceBuilder"]
        [::core::mem::size_of::<SkCustomTypefaceBuilder>() - 96usize];
    ["Alignment of SkCustomTypefaceBuilder"]
        [::core::mem::align_of::<SkCustomTypefaceBuilder>() - 8usize];
    ["Offset of field: SkCustomTypefaceBuilder::fGlyphRecs"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder, fGlyphRecs) - 0usize];
    ["Offset of field: SkCustomTypefaceBuilder::fMetrics"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder, fMetrics) - 24usize];
    ["Offset of field: SkCustomTypefaceBuilder::fStyle"]
        [::core::mem::offset_of!(SkCustomTypefaceBuilder, fStyle) - 88usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilder8setGlyphEtfRK6SkPath"]
    pub fn SkCustomTypefaceBuilder_setGlyph(
        this: *mut SkCustomTypefaceBuilder,
        arg1: SkGlyphID,
        advance: f32,
        arg2: *const SkPath,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilder10setMetricsERK13SkFontMetricsf"]
    pub fn SkCustomTypefaceBuilder_setMetrics(
        this: *mut SkCustomTypefaceBuilder,
        fm: *const SkFontMetrics,
        scale: f32,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilder12setFontStyleE11SkFontStyle"]
    pub fn SkCustomTypefaceBuilder_setFontStyle(
        this: *mut SkCustomTypefaceBuilder,
        arg1: SkFontStyle,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilder6detachEv"]
    pub fn SkCustomTypefaceBuilder_detach(this: *mut SkCustomTypefaceBuilder) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilder14MakeFromStreamESt10unique_ptrI13SkStreamAssetSt14default_deleteIS1_EERK15SkFontArguments"]
    pub fn SkCustomTypefaceBuilder_MakeFromStream(
        arg1: u64,
        arg2: *const SkFontArguments,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN23SkCustomTypefaceBuilderC1Ev"]
    pub fn SkCustomTypefaceBuilder_SkCustomTypefaceBuilder(this: *mut SkCustomTypefaceBuilder);
}
impl SkCustomTypefaceBuilder {
    #[inline]
    pub unsafe fn setGlyph(&mut self, arg1: SkGlyphID, advance: f32, arg2: *const SkPath) {
        SkCustomTypefaceBuilder_setGlyph(self, arg1, advance, arg2)
    }
    #[inline]
    pub unsafe fn setMetrics(&mut self, fm: *const SkFontMetrics, scale: f32) {
        SkCustomTypefaceBuilder_setMetrics(self, fm, scale)
    }
    #[inline]
    pub unsafe fn setFontStyle(&mut self, arg1: SkFontStyle) {
        SkCustomTypefaceBuilder_setFontStyle(self, arg1)
    }
    #[inline]
    pub unsafe fn detach(&mut self) -> sk_sp<SkTypeface> {
        SkCustomTypefaceBuilder_detach(self)
    }
    #[inline]
    pub unsafe fn MakeFromStream(arg1: u64, arg2: *const SkFontArguments) -> sk_sp<SkTypeface> {
        SkCustomTypefaceBuilder_MakeFromStream(arg1, arg2)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkCustomTypefaceBuilder_SkCustomTypefaceBuilder(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
pub struct SkOrderedFontMgr {
    pub _base: SkFontMgr,
    pub fList: __BindgenOpaqueArray<u64, 3usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkOrderedFontMgr"][::core::mem::size_of::<SkOrderedFontMgr>() - 40usize];
    ["Alignment of SkOrderedFontMgr"][::core::mem::align_of::<SkOrderedFontMgr>() - 8usize];
    ["Offset of field: SkOrderedFontMgr::fList"]
        [::core::mem::offset_of!(SkOrderedFontMgr, fList) - 16usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkOrderedFontMgr6appendE5sk_spI9SkFontMgrE"]
    pub fn SkOrderedFontMgr_append(this: *mut SkOrderedFontMgr, arg1: sk_sp<SkFontMgr>);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkOrderedFontMgrC1Ev"]
    pub fn SkOrderedFontMgr_SkOrderedFontMgr(this: *mut SkOrderedFontMgr);
}
impl SkOrderedFontMgr {
    #[inline]
    pub unsafe fn append(&mut self, arg1: sk_sp<SkFontMgr>) {
        SkOrderedFontMgr_append(self, arg1)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        SkOrderedFontMgr_SkOrderedFontMgr(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN16SkOrderedFontMgrD1Ev"]
    pub fn SkOrderedFontMgr_SkOrderedFontMgr_destructor(this: *mut SkOrderedFontMgr);
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr15onCountFamiliesEv"]
    pub fn SkOrderedFontMgr_onCountFamilies(this: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr15onGetFamilyNameEiP8SkString"]
    pub fn SkOrderedFontMgr_onGetFamilyName(
        this: *mut ::core::ffi::c_void,
        index: ::core::ffi::c_int,
        familyName: *mut SkString,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr16onCreateStyleSetEi"]
    pub fn SkOrderedFontMgr_onCreateStyleSet(
        this: *mut ::core::ffi::c_void,
        index: ::core::ffi::c_int,
    ) -> sk_sp<SkFontStyleSet>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr13onMatchFamilyEPKc"]
    pub fn SkOrderedFontMgr_onMatchFamily(
        this: *mut ::core::ffi::c_void,
        familyName: *const ::core::ffi::c_char,
    ) -> sk_sp<SkFontStyleSet>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr18onMatchFamilyStyleEPKcRK11SkFontStyle"]
    pub fn SkOrderedFontMgr_onMatchFamilyStyle(
        this: *mut ::core::ffi::c_void,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr27onMatchFamilyStyleCharacterEPKcRK11SkFontStylePS1_ii"]
    pub fn SkOrderedFontMgr_onMatchFamilyStyleCharacter(
        this: *mut ::core::ffi::c_void,
        familyName: *const ::core::ffi::c_char,
        arg1: *const SkFontStyle,
        bcp47: *mut *const ::core::ffi::c_char,
        bcp47Count: ::core::ffi::c_int,
        character: SkUnichar,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr14onMakeFromDataE5sk_spI6SkDataEi"]
    pub fn SkOrderedFontMgr_onMakeFromData(
        this: *mut ::core::ffi::c_void,
        arg1: sk_sp<SkData>,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr21onMakeFromStreamIndexESt10unique_ptrI13SkStreamAssetSt14default_deleteIS1_EEi"]
    pub fn SkOrderedFontMgr_onMakeFromStreamIndex(
        this: *mut ::core::ffi::c_void,
        arg1: u64,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr20onMakeFromStreamArgsESt10unique_ptrI13SkStreamAssetSt14default_deleteIS1_EERK15SkFontArguments"]
    pub fn SkOrderedFontMgr_onMakeFromStreamArgs(
        this: *mut ::core::ffi::c_void,
        arg1: u64,
        arg2: *const SkFontArguments,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr14onMakeFromFileEPKci"]
    pub fn SkOrderedFontMgr_onMakeFromFile(
        this: *mut ::core::ffi::c_void,
        path: *const ::core::ffi::c_char,
        ttcIndex: ::core::ffi::c_int,
    ) -> sk_sp<SkTypeface>;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK16SkOrderedFontMgr20onLegacyMakeTypefaceEPKc11SkFontStyle"]
    pub fn SkOrderedFontMgr_onLegacyMakeTypeface(
        this: *mut ::core::ffi::c_void,
        familyName: *const ::core::ffi::c_char,
        arg1: SkFontStyle,
    ) -> sk_sp<SkTypeface>;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkParsePath {
    pub _address: u8,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkParsePath_PathEncoding {
    Absolute = 0,
    Relative = 1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkParsePath"][::core::mem::size_of::<SkParsePath>() - 1usize];
    ["Alignment of SkParsePath"][::core::mem::align_of::<SkParsePath>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkParsePath13FromSVGStringEPKcP6SkPath"]
    pub fn SkParsePath_FromSVGString(str_: *const ::core::ffi::c_char, arg1: *mut SkPath) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkParsePath11ToSVGStringERK6SkPathNS_12PathEncodingE"]
    pub fn SkParsePath_ToSVGString(arg1: *const SkPath, arg2: SkParsePath_PathEncoding)
    -> SkString;
}
impl SkParsePath {
    #[inline]
    pub unsafe fn FromSVGString(str_: *const ::core::ffi::c_char, arg1: *mut SkPath) -> bool {
        SkParsePath_FromSVGString(str_, arg1)
    }
    #[inline]
    pub unsafe fn ToSVGString(arg1: *const SkPath, arg2: SkParsePath_PathEncoding) -> SkString {
        SkParsePath_ToSVGString(arg1, arg2)
    }
}
pub const SkShadowFlags_kNone_ShadowFlag: SkShadowFlags = 0;
pub const SkShadowFlags_kTransparentOccluder_ShadowFlag: SkShadowFlags = 1;
pub const SkShadowFlags_kGeometricOnly_ShadowFlag: SkShadowFlags = 2;
pub const SkShadowFlags_kDirectionalLight_ShadowFlag: SkShadowFlags = 4;
pub const SkShadowFlags_kConcaveBlurOnly_ShadowFlag: SkShadowFlags = 8;
pub const SkShadowFlags_kAll_ShadowFlag: SkShadowFlags = 15;
pub type SkShadowFlags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkShadowUtils {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkShadowUtils"][::core::mem::size_of::<SkShadowUtils>() - 1usize];
    ["Alignment of SkShadowUtils"][::core::mem::align_of::<SkShadowUtils>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkShadowUtils10DrawShadowEP8SkCanvasRK6SkPathRK8SkPoint3S7_fjjj"]
    pub fn SkShadowUtils_DrawShadow(
        canvas: *mut SkCanvas,
        path: *const SkPath,
        zPlaneParams: *const SkPoint3,
        lightPos: *const SkPoint3,
        lightRadius: SkScalar,
        ambientColor: SkColor,
        spotColor: SkColor,
        flags: u32,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkShadowUtils14GetLocalBoundsERK8SkMatrixRK6SkPathRK8SkPoint3S8_fjP6SkRect"]
    pub fn SkShadowUtils_GetLocalBounds(
        ctm: *const SkMatrix,
        path: *const SkPath,
        zPlaneParams: *const SkPoint3,
        lightPos: *const SkPoint3,
        lightRadius: SkScalar,
        flags: u32,
        bounds: *mut SkRect,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN13SkShadowUtils18ComputeTonalColorsEjjPjS0_"]
    pub fn SkShadowUtils_ComputeTonalColors(
        inAmbientColor: SkColor,
        inSpotColor: SkColor,
        outAmbientColor: *mut SkColor,
        outSpotColor: *mut SkColor,
    );
}
impl SkShadowUtils {
    #[inline]
    pub unsafe fn DrawShadow(
        canvas: *mut SkCanvas,
        path: *const SkPath,
        zPlaneParams: *const SkPoint3,
        lightPos: *const SkPoint3,
        lightRadius: SkScalar,
        ambientColor: SkColor,
        spotColor: SkColor,
        flags: u32,
    ) {
        SkShadowUtils_DrawShadow(
            canvas,
            path,
            zPlaneParams,
            lightPos,
            lightRadius,
            ambientColor,
            spotColor,
            flags,
        )
    }
    #[inline]
    pub unsafe fn GetLocalBounds(
        ctm: *const SkMatrix,
        path: *const SkPath,
        zPlaneParams: *const SkPoint3,
        lightPos: *const SkPoint3,
        lightRadius: SkScalar,
        flags: u32,
        bounds: *mut SkRect,
    ) -> bool {
        SkShadowUtils_GetLocalBounds(
            ctm,
            path,
            zPlaneParams,
            lightPos,
            lightRadius,
            flags,
            bounds,
        )
    }
    #[inline]
    pub unsafe fn ComputeTonalColors(
        inAmbientColor: SkColor,
        inSpotColor: SkColor,
        outAmbientColor: *mut SkColor,
        outSpotColor: *mut SkColor,
    ) {
        SkShadowUtils_ComputeTonalColors(inAmbientColor, inSpotColor, outAmbientColor, outSpotColor)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SkTextUtils {
    pub _address: u8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SkTextUtils_Align {
    Left = 0,
    Center = 1,
    Right = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SkTextUtils"][::core::mem::size_of::<SkTextUtils>() - 1usize];
    ["Alignment of SkTextUtils"][::core::mem::align_of::<SkTextUtils>() - 1usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTextUtils4DrawEP8SkCanvasPKvm14SkTextEncodingffRK6SkFontRK7SkPaintNS_5AlignE"]
    pub fn SkTextUtils_Draw(
        arg1: *mut SkCanvas,
        text: *const ::core::ffi::c_void,
        size: usize,
        arg2: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        arg3: *const SkFont,
        arg4: *const SkPaint,
        arg5: SkTextUtils_Align,
    );
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN11SkTextUtils7GetPathEPKvm14SkTextEncodingffRK6SkFontP6SkPath"]
    pub fn SkTextUtils_GetPath(
        text: *const ::core::ffi::c_void,
        length: usize,
        arg1: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        arg2: *const SkFont,
        arg3: *mut SkPath,
    );
}
impl SkTextUtils {
    #[inline]
    pub unsafe fn Draw(
        arg1: *mut SkCanvas,
        text: *const ::core::ffi::c_void,
        size: usize,
        arg2: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        arg3: *const SkFont,
        arg4: *const SkPaint,
        arg5: SkTextUtils_Align,
    ) {
        SkTextUtils_Draw(arg1, text, size, arg2, x, y, arg3, arg4, arg5)
    }
    #[inline]
    pub unsafe fn GetPath(
        text: *const ::core::ffi::c_void,
        length: usize,
        arg1: SkTextEncoding,
        x: SkScalar,
        y: SkScalar,
        arg2: *const SkFont,
        arg3: *mut SkPath,
    ) {
        SkTextUtils_GetPath(text, length, arg1, x, y, arg2, arg3)
    }
}
unsafe extern "C" {
    pub fn C_Bindings_Types(arg1: Sink<bool>);
}
unsafe extern "C" {
    pub fn C_SkCodec_MakeFromStream(
        stream: *mut SkStream,
        decoders: *const SkCodecs_Decoder,
        decodersCount: usize,
        result: *mut SkCodec_Result,
        selectionPolicy: SkCodec_SelectionPolicy,
    ) -> *mut SkCodec;
}
unsafe extern "C" {
    pub fn C_SkCodec_MakeFromData(data: *mut SkData) -> *mut SkCodec;
}
unsafe extern "C" {
    pub fn C_SkCodec_MakeFromData2(
        data: *mut SkData,
        decoders: *const SkCodecs_Decoder,
        decodersCount: usize,
    ) -> *mut SkCodec;
}
unsafe extern "C" {
    pub fn C_SkCodec_delete(self_: *mut SkCodec);
}
unsafe extern "C" {
    pub fn C_SkCodec_getInfo(self_: *const SkCodec, info: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkCodec_dimensions(self_: *const SkCodec) -> SkISize;
}
unsafe extern "C" {
    pub fn C_SkCodec_bounds(self_: *const SkCodec, uninitialized: *mut SkIRect);
}
unsafe extern "C" {
    pub fn C_SkCodec_getOrigin(self_: *const SkCodec) -> SkEncodedOrigin;
}
unsafe extern "C" {
    pub fn C_SkCodec_getScaledDimensions(self_: *const SkCodec, desiredScale: f32) -> SkISize;
}
unsafe extern "C" {
    pub fn C_SkCodec_hasHighBitDepthEncodedData(self_: *const SkCodec) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCodec_getValidSubset(self_: *const SkCodec, desiredSubset: *mut SkIRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCodec_getEncodedFormat(self_: *const SkCodec) -> SkEncodedImageFormat;
}
unsafe extern "C" {
    pub fn C_SkCodec_getImage(
        self_: *mut SkCodec,
        info: *const SkImageInfo,
        opts: *const SkCodec_Options,
        result: *mut SkCodec_Result,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkCodec_incrementalDecode(
        self_: *mut SkCodec,
        rowsDecoded: *mut ::core::ffi::c_int,
    ) -> SkCodec_Result;
}
unsafe extern "C" {
    pub fn C_SkCodec_getScanlineOrder(self_: *const SkCodec) -> SkCodec_SkScanlineOrder;
}
unsafe extern "C" {
    pub fn C_SkCodec_nextScanline(self_: *const SkCodec) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkCodec_getFrameCount(self_: *mut SkCodec) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkFrameInfo_Construct(uninitialized: *mut SkCodec_FrameInfo);
}
unsafe extern "C" {
    pub fn C_SkCodec_getFrameInfo(
        self_: *mut SkCodec,
        index: ::core::ffi::c_int,
        info: *mut SkCodec_FrameInfo,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCodec_getRepetitionCount(self_: *mut SkCodec) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkCodec_isAnimated(self_: *mut SkCodec) -> SkCodec_IsAnimated;
}
unsafe extern "C" {
    pub fn C_SkCodecs_Decoder_CopyConstruct(
        uninitialized: *mut SkCodecs_Decoder,
        decoder: *const SkCodecs_Decoder,
    );
}
unsafe extern "C" {
    pub fn C_SkCodecs_Decoder_getId(
        decoder: *const SkCodecs_Decoder,
        len: *mut usize,
    ) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn C_SkCodecs_Decoder_MakeFromStream(
        decoder: *const SkCodecs_Decoder,
        stream: *mut SkStream,
        result: *mut SkCodec_Result,
        context: SkCodecs_DecodeContext,
    ) -> *mut SkCodec;
}
unsafe extern "C" {
    pub fn C_SkCodecs_Decoder_destruct(decoder: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkCodecs_DeferredImage(
        codec: *mut SkCodec,
        alphaType: *const SkAlphaType,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkBmpDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkGifDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkIcoDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkJpegDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkPngDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkWbmpDecoder_Decoder(uninitialized: *mut SkCodecs_Decoder);
}
unsafe extern "C" {
    pub fn C_SkEncodedOriginToMatrix(
        origin: SkEncodedOrigin,
        w: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        matrix: *mut SkMatrix,
    );
}
unsafe extern "C" {
    pub fn C_SkPixmapUtils_Orient(
        dst: *mut SkPixmap,
        src: *const SkPixmap,
        origin: SkEncodedOrigin,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPixmapUtils_SwapWidthHeight(
        uninitialized: *mut SkImageInfo,
        info: *const SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_Core_Types(
        arg1: *mut SkArc,
        arg2: *mut SkGraphics,
        arg3: *mut SkCoverageMode,
        arg4: *mut SkColorChannelFlag,
        arg5: SkSurfaces_BackendSurfaceAccess,
    );
}
unsafe extern "C" {
    pub fn C_SkBlender_Mode(mode: SkBlendMode) -> *mut SkBlender;
}
unsafe extern "C" {
    pub fn C_SkBlender_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkBlender;
}
unsafe extern "C" {
    pub fn C_SkColor4f_toBytes_RGBA(color: *const SkColor4f) -> u32;
}
unsafe extern "C" {
    pub fn C_SkColor4f_FromBytes_RGBA(bytes: u32) -> SkColor4f;
}
unsafe extern "C" {
    pub fn C_SkCubicMap_computeFromT(self_: *const SkCubicMap, t: f32) -> SkPoint;
}
unsafe extern "C" {
    pub fn C_SkSurfaces_Null(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkSurfaces_Raster(
        imageInfo: *const SkImageInfo,
        rowBytes: usize,
        surfaceProps: *const SkSurfaceProps,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkSurfaces_WrapPixels(
        imageInfo: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        rowBytes: usize,
        surfaceProps: *const SkSurfaceProps,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkSurface_width(self_: *const SkSurface) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkSurface_height(self_: *const SkSurface) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkSurface_imageInfo(self_: *const SkSurface, info: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkSurface_makeImageSnapshot(
        self_: *mut SkSurface,
        bounds: *const SkIRect,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkSurface_makeTemporaryImage(self_: *mut SkSurface) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkSurface_makeSurface(
        self_: *mut SkSurface,
        imageInfo: *const SkImageInfo,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkSurface_makeSurface2(
        self_: *mut SkSurface,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkSurface_props(self_: *const SkSurface) -> *const SkSurfaceProps;
}
unsafe extern "C" {
    pub fn C_SkImages_RasterFromBitmap(bitmap: *const SkBitmap) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_RasterFromCompressedTextureData(
        data: *mut SkData,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        type_: SkTextureCompressionType,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_DeferredFromEncodedData(
        encoded: *mut SkData,
        alphaType: *const SkAlphaType,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_DeferredFromGenerator(imageGenerator: *mut SkImageGenerator) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_DeferredFromPicture(
        picture: *mut SkPicture,
        dimensions: *const SkISize,
        matrix: *const SkMatrix,
        paint: *const SkPaint,
        bitDepth: SkImages_BitDepth,
        colorSpace: *mut SkColorSpace,
        props: *const SkSurfaceProps,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_RasterFromData(
        info: *const SkImageInfo,
        pixels: *mut SkData,
        rowBytes: usize,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImages_MakeWithFilter(
        image: *mut SkImage,
        imageFilter: *const SkImageFilter,
        subset: *const SkIRect,
        clipBounds: *const SkIRect,
        outSubset: *mut SkIRect,
        offset: *mut SkIPoint,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_makeShader(
        self_: *const SkImage,
        tileMode1: SkTileMode,
        tileMode2: SkTileMode,
        samplingOptions: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkImage_makeRawShader(
        self_: *const SkImage,
        tileMode1: SkTileMode,
        tileMode2: SkTileMode,
        samplingOptions: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkImage_isTextureBacked(self_: *const SkImage) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImage_textureSize(self_: *const SkImage) -> usize;
}
unsafe extern "C" {
    pub fn C_SkImage_isValid(self_: *const SkImage, recorder: *mut SkRecorder) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImage_makeScaled(
        self_: *const SkImage,
        info: *const SkImageInfo,
        sampling: *const SkSamplingOptions,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_refEncodedData(self_: *const SkImage) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkImage_makeSubset(
        self_: *const SkImage,
        recorder: *mut SkRecorder,
        subset: *const SkIRect,
        properties: *const SkImage_RequiredProperties,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_withDefaultMipmaps(self_: *const SkImage) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_makeNonTextureImage(
        self_: *const SkImage,
        context: *mut GrDirectContext,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_makeRasterImage(
        self_: *const SkImage,
        context: *mut GrDirectContext,
        cachingHint: SkImage_CachingHint,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_isLazyGenerated(self_: *const SkImage) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImage_makeColorSpace(
        self_: *const SkImage,
        recorder: *mut SkRecorder,
        target: *mut SkColorSpace,
        properties: *const SkImage_RequiredProperties,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkImage_reinterpretColorSpace(
        self_: *const SkImage,
        newColorSpace: *mut SkColorSpace,
    ) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkData_ref(self_: *const SkData);
}
unsafe extern "C" {
    pub fn C_SkData_unref(self_: *const SkData);
}
unsafe extern "C" {
    pub fn C_SkData_unique(self_: *const SkData) -> bool;
}
unsafe extern "C" {
    pub fn C_SkData_MakeWithCopy(data: *const ::core::ffi::c_void, length: usize) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeSubset(src: *const SkData, offset: usize, length: usize) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeUninitialized(length: usize) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeZeroInitialized(length: usize) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeWithCString(cstr: *const ::core::ffi::c_char) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeWithoutCopy(data: *const ::core::ffi::c_void, length: usize)
    -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeFromFileName(cstr: *const ::core::ffi::c_char) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeFromStream(stream: *mut SkStream, size: usize) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkData_MakeEmpty() -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkPaint_destruct(self_: *mut SkPaint);
}
unsafe extern "C" {
    pub fn C_SkPaint_copy(self_: *mut SkPaint, rhs: *const SkPaint);
}
unsafe extern "C" {
    pub fn C_SkPaint_Equals(lhs: *const SkPaint, rhs: *const SkPaint) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPaint_getStyle(self_: *const SkPaint) -> SkPaint_Style;
}
unsafe extern "C" {
    pub fn C_SkPaint_getAlpha(self_: *const SkPaint) -> u8;
}
unsafe extern "C" {
    pub fn C_SkPaint_getStrokeCap(self_: *const SkPaint) -> SkPaint_Cap;
}
unsafe extern "C" {
    pub fn C_SkPaint_getStrokeJoin(self_: *const SkPaint) -> SkPaint_Join;
}
unsafe extern "C" {
    pub fn C_SkPaint_setShader(self_: *mut SkPaint, shader: *mut SkShader);
}
unsafe extern "C" {
    pub fn C_SkPaint_setColorFilter(self_: *mut SkPaint, colorFilter: *mut SkColorFilter);
}
unsafe extern "C" {
    pub fn C_SkPaint_asBlendMode(self_: *const SkPaint, mode: *mut SkBlendMode) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPaint_setBlender(self_: *mut SkPaint, blender: *mut SkBlender);
}
unsafe extern "C" {
    pub fn C_SkPaint_setPathEffect(self_: *mut SkPaint, pathEffect: *mut SkPathEffect);
}
unsafe extern "C" {
    pub fn C_SkPaint_setMaskFilter(self_: *mut SkPaint, maskFilter: *mut SkMaskFilter);
}
unsafe extern "C" {
    pub fn C_SkPaint_setImageFilter(self_: *mut SkPaint, imageFilter: *mut SkImageFilter);
}
unsafe extern "C" {
    pub fn C_SkPathIter_Construct(
        points: *const SkPoint,
        pointsCount: usize,
        verbs: *const SkPathVerb,
        verbsCount: usize,
        conics: *const f32,
        conicsCount: usize,
        uninitialized: *mut SkPathIter,
    );
}
unsafe extern "C" {
    pub fn C_SkPathIter_destruct(self_: *mut SkPathIter);
}
unsafe extern "C" {
    pub fn C_SkPathIter_next(self_: *mut SkPathIter, unitialized: *mut SkPathIter_Rec) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPathIter_peekNextVerb(self_: *mut SkPathIter, verb: *mut SkPathVerb) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPathContourIter_Construct(
        points: *const SkPoint,
        pointsCount: usize,
        verbs: *const SkPathVerb,
        verbsCount: usize,
        conics: *const f32,
        conicsCount: usize,
        uninitialized: *mut SkPathContourIter,
    );
}
unsafe extern "C" {
    pub fn C_SkPathContourIter_destruct(self_: *mut SkPathContourIter);
}
unsafe extern "C" {
    pub fn C_SkPathContourIter_next(
        self_: *mut SkPathContourIter,
        unitialized: *mut SkPathContourIter_Rec,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPath_Construct(uninitialized: *mut SkPath);
}
unsafe extern "C" {
    pub fn C_SkPath_Raw(
        uninitialized: *mut SkPath,
        pts: *const SkPoint,
        pointCount: usize,
        vbs: *const SkPathVerb,
        verbCount: usize,
        ws: *const SkScalar,
        wCount: usize,
        ft: SkPathFillType,
        isVolatile: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_Make(
        uninitialized: *mut SkPath,
        pts: *const SkPoint,
        pointCount: usize,
        vbs: *const u8,
        verbCount: usize,
        ws: *const SkScalar,
        wCount: usize,
        ft: SkPathFillType,
        isVolatile: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_Rect(uninitialized: *mut SkPath, r: *const SkRect, dir: SkPathDirection);
}
unsafe extern "C" {
    pub fn C_SkPath_Oval(uninitialized: *mut SkPath, r: *const SkRect, dir: SkPathDirection);
}
unsafe extern "C" {
    pub fn C_SkPath_OvalWithStartIndex(
        uninitialized: *mut SkPath,
        r: *const SkRect,
        dir: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_Circle(
        uninitialized: *mut SkPath,
        x: SkScalar,
        y: SkScalar,
        r: SkScalar,
        dir: SkPathDirection,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_RRect(uninitialized: *mut SkPath, rr: *const SkRRect, dir: SkPathDirection);
}
unsafe extern "C" {
    pub fn C_SkPath_RRectWithStartIndex(
        uninitialized: *mut SkPath,
        r: *const SkRRect,
        dir: SkPathDirection,
        startIndex: ::core::ffi::c_uint,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_Polygon(
        uninitialized: *mut SkPath,
        pts: *const SkPoint,
        count: usize,
        isClosed: bool,
        ft: SkPathFillType,
        isVolatile: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_destruct(self_: *const SkPath);
}
unsafe extern "C" {
    pub fn C_SkPath_Equals(lhs: *const SkPath, rhs: *const SkPath) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPath_serialize(self_: *const SkPath) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkPath_Iter_destruct(self_: *mut SkPath_Iter);
}
unsafe extern "C" {
    pub fn C_SkPath_Iter_isCloseLine(self_: *const SkPath_Iter) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPath_RawIter_Construct(uninitialized: *mut SkPath_RawIter);
}
unsafe extern "C" {
    pub fn C_SkPath_RawIter_destruct(self_: *mut SkPath_RawIter);
}
unsafe extern "C" {
    pub fn C_SkPath_RawIter_peek(self_: *const SkPath_RawIter) -> SkPath_Verb;
}
unsafe extern "C" {
    pub fn C_SkPath_getFillType(self_: *const SkPath) -> SkPathFillType;
}
unsafe extern "C" {
    pub fn C_SkPath_makeFillType(
        self_: *const SkPath,
        newFillType: SkPathFillType,
        uninitialized: *mut SkPath,
    );
}
unsafe extern "C" {
    pub fn C_SkPath_getPoint(self_: *const SkPath, index: ::core::ffi::c_int) -> SkPoint;
}
unsafe extern "C" {
    pub fn C_SkPath_getPoints(self_: *const SkPath, points: *mut SkPoint, count: usize) -> usize;
}
unsafe extern "C" {
    pub fn C_SkPath_getVerbs(self_: *const SkPath, verbs: *mut u8, count: usize) -> usize;
}
unsafe extern "C" {
    pub fn C_SkPath_addPoly(self_: *mut SkPath, points: *const SkPoint, count: usize, close: bool);
}
unsafe extern "C" {
    pub fn C_SkPath_iter(self_: *const SkPath, uninitialized: *mut SkPathIter);
}
unsafe extern "C" {
    pub fn C_SkPath_getBounds(self_: *const SkPath) -> *const SkRect;
}
unsafe extern "C" {
    pub fn C_SkPath_computeTightBounds(self_: *const SkPath, uninitialized: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_new() -> *mut SkPathBuilder;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_newFromPath(path: *const SkPath) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_computeBounds(self_: *const SkPathBuilder, uninitialized: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_clone(pathBuilder: *const SkPathBuilder) -> *mut SkPathBuilder;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_delete(self_: *mut SkPathBuilder);
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_snapshot(self_: *const SkPathBuilder, uninitialized: *mut SkPath);
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_detach(self_: *mut SkPathBuilder, uninitialized: *mut SkPath);
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_polylineTo(
        self_: *mut SkPathBuilder,
        points: *const SkPoint,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_addPolygon(
        self_: *mut SkPathBuilder,
        points: *const SkPoint,
        count: usize,
        close: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_isEmpty(self_: *const SkPathBuilder) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_getLastPt(self_: *const SkPathBuilder, point: *mut SkPoint) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_countPoints(self_: *const SkPathBuilder) -> usize;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_points(self_: *const SkPathBuilder, count: *mut usize)
    -> *const SkPoint;
}
unsafe extern "C" {
    pub fn C_SkPathBuilder_verbs(
        self_: *const SkPathBuilder,
        count: *mut usize,
    ) -> *const SkPathVerb;
}
unsafe extern "C" {
    pub fn C_SkPathMeasure_destruct(self_: *const SkPathMeasure);
}
unsafe extern "C" {
    pub fn C_SkPathTypes_Types(
        arg1: *mut SkPathFillType,
        arg2: *mut SkPathDirection,
        arg3: *mut SkPathSegmentMask,
        arg4: *mut SkPathVerb,
    );
}
unsafe extern "C" {
    pub fn C_PathUtils_FillPathWithPaint(
        src: *const SkPath,
        paint: *const SkPaint,
        dst: *mut SkPath,
        cullRect: *const SkRect,
        matrix: *const SkMatrix,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCanvas_SaveLayerRec_Construct(uninitialized: *mut SkCanvas_SaveLayerRec);
}
unsafe extern "C" {
    pub fn C_SkCanvas_SaveLayerRec_destruct(self_: *mut SkCanvas_SaveLayerRec);
}
unsafe extern "C" {
    pub fn C_SkCanvas_newEmpty() -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkCanvas_newWidthHeightAndProps(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        props: *const SkSurfaceProps,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkCanvas_newFromBitmap(bitmap: *const SkBitmap) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkCanvas_newFromBitmapAndProps(
        bitmap: *const SkBitmap,
        props: *const SkSurfaceProps,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkCanvas_delete(self_: *const SkCanvas);
}
unsafe extern "C" {
    pub fn C_SkCanvas_MakeRasterDirect(
        info: *const SkImageInfo,
        pixels: *mut ::core::ffi::c_void,
        row_bytes: usize,
        props: *const SkSurfaceProps,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkCanvas_imageInfo(self_: *const SkCanvas, info: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkCanvas_getBaseLayerSize(self_: *const SkCanvas, size: *mut SkISize);
}
unsafe extern "C" {
    pub fn C_SkCanvas_makeSurface(
        self_: *mut SkCanvas,
        info: *const SkImageInfo,
        props: *const SkSurfaceProps,
    ) -> *mut SkSurface;
}
unsafe extern "C" {
    pub fn C_SkCanvas_clipShader(self_: *mut SkCanvas, shader: *mut SkShader, op: SkClipOp);
}
unsafe extern "C" {
    pub fn C_SkCanvas_getLocalClipBounds(self_: *const SkCanvas, uninitialized: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkCanvas_getDeviceClipBounds(self_: *const SkCanvas, result: *mut SkIRect);
}
unsafe extern "C" {
    pub fn C_SkCanvas_isClipEmpty(self_: *const SkCanvas) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCanvas_isClipRect(self_: *const SkCanvas) -> bool;
}
unsafe extern "C" {
    pub fn C_SkCanvas_getLocalToDevice(self_: *const SkCanvas, uninitialized: *mut SkM44);
}
unsafe extern "C" {
    pub fn C_SkCanvas_getTotalMatrix(self_: *const SkCanvas, matrix: *mut SkMatrix);
}
unsafe extern "C" {
    pub fn C_SkCanvas_discard(self_: *mut SkCanvas);
}
unsafe extern "C" {
    pub fn C_SkCanvas_drawPoints(
        self_: *mut SkCanvas,
        mode: SkCanvas_PointMode,
        points: *const SkPoint,
        pointCount: usize,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkCanvas_drawGlyphs(
        self_: *mut SkCanvas,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        positions: *const SkPoint,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkCanvas_drawGlyphs2(
        self_: *mut SkCanvas,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        positions: *const SkPoint,
        clusters: *const u32,
        utf8Text: *const ::core::ffi::c_char,
        textSize: usize,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkCanvas_drawGlyphsRSXform(
        self_: *mut SkCanvas,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        xforms: *const SkRSXform,
        origin: SkPoint,
        font: *const SkFont,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkCanvas_drawAtlas(
        self_: *mut SkCanvas,
        atlas: *const SkImage,
        xform: *const SkRSXform,
        xformCount: usize,
        tex: *const SkRect,
        colors: *const SkColor,
        mode: SkBlendMode,
        sampling: *const SkSamplingOptions,
        cullRect: *const SkRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkAutoCanvasRestore_Construct(
        uninitialized: *mut SkAutoCanvasRestore,
        canvas: *mut SkCanvas,
        doSave: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkAutoCanvasRestore_destruct(self_: *const SkAutoCanvasRestore);
}
unsafe extern "C" {
    pub fn C_SkAutoCanvasRestore_restore(self_: *mut SkAutoCanvasRestore);
}
unsafe extern "C" {
    pub fn C_SkColorInfo_Construct(uninitialized: *mut SkColorInfo);
}
unsafe extern "C" {
    pub fn C_SkColorInfo_Construct2(
        uninitialized: *mut SkColorInfo,
        ct: SkColorType,
        at: SkAlphaType,
        cs: *mut SkColorSpace,
    );
}
unsafe extern "C" {
    pub fn C_SkColorInfo_destruct(self_: *mut SkColorInfo);
}
unsafe extern "C" {
    pub fn C_SkColorInfo_Copy(from: *const SkColorInfo, to: *mut SkColorInfo);
}
unsafe extern "C" {
    pub fn C_SkColorInfo_Equals(lhs: *const SkColorInfo, rhs: *const SkColorInfo) -> bool;
}
unsafe extern "C" {
    pub fn C_SkColorInfo_makeAlphaType(
        self_: *const SkColorInfo,
        newAlphaType: SkAlphaType,
        uninitialized: *mut SkColorInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkColorInfo_makeColorType(
        self_: *const SkColorInfo,
        newColorType: SkColorType,
        uninitialized: *mut SkColorInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkColorInfo_makeColorSpace(
        self_: *const SkColorInfo,
        newColorSpace: *mut SkColorSpace,
        uninitialized: *mut SkColorInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_Construct(uninitialized: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkImageInfo_destruct(self_: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkImageInfo_Copy(from: *const SkImageInfo, to: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkImageInfo_Equals(lhs: *const SkImageInfo, rhs: *const SkImageInfo) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImageInfo_Make(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        ct: SkColorType,
        at: SkAlphaType,
        cs: *mut SkColorSpace,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_MakeN32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
        cs: *mut SkColorSpace,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_MakeS32(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        at: SkAlphaType,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_MakeN32Premul(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        cs: *mut SkColorSpace,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_MakeA8(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_MakeUnknown(
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_makeColorSpace(
        self_: *const SkImageInfo,
        cs: *mut SkColorSpace,
        uninitialized: *mut SkImageInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkImageInfo_reset(self_: *mut SkImageInfo);
}
unsafe extern "C" {
    pub fn C_SkColorSpace_Types(arg1: *mut SkColorSpacePrimaries);
}
unsafe extern "C" {
    pub fn C_SkColorSpace_ref(self_: *const SkColorSpace);
}
unsafe extern "C" {
    pub fn C_SkColorSpace_unref(self_: *const SkColorSpace);
}
unsafe extern "C" {
    pub fn C_SkColorSpace_unique(self_: *const SkColorSpace) -> bool;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_MakeICC(
        buffer: *const ::core::ffi::c_void,
        size: usize,
    ) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_MakeSRGB() -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_MakeSRGBLinear() -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_MakeCICP(
        colorPrimaries: SkNamedPrimaries_CicpId,
        transferCharacteristics: SkNamedTransferFn_CicpId,
    ) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_makeLinearGamma(self_: *const SkColorSpace) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_makeSRGBGamma(self_: *const SkColorSpace) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_makeColorSpin(self_: *const SkColorSpace) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_serialize(self_: *const SkColorSpace) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkColorSpace;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_transferFnHash(self_: *const SkColorSpace) -> u32;
}
unsafe extern "C" {
    pub fn C_SkColorSpace_hash(self_: *const SkColorSpace) -> u64;
}
unsafe extern "C" {
    pub fn C_SkM44_Types(arg1: *mut SkV2);
}
unsafe extern "C" {
    pub fn C_SkM44_equals(self_: *const SkM44, other: *const SkM44) -> bool;
}
unsafe extern "C" {
    pub fn C_SkM44_RectToRect(src: *const SkRect, dst: *const SkRect, uninitialized: *mut SkM44);
}
unsafe extern "C" {
    pub fn C_SkM44_LookAt(
        eye: *const SkV3,
        center: *const SkV3,
        up: *const SkV3,
        uninitialized: *mut SkM44,
    );
}
unsafe extern "C" {
    pub fn C_SkM44_Perspective(near: f32, far: f32, angle: f32, uninitialized: *mut SkM44);
}
unsafe extern "C" {
    pub fn C_SkM44_transpose(self_: *const SkM44, uninitialized: *mut SkM44);
}
unsafe extern "C" {
    pub fn C_SkM44_map(self_: *const SkM44, x: f32, y: f32, z: f32, w: f32) -> SkV4;
}
unsafe extern "C" {
    pub fn C_SkMatrix_ScaleTranslate(
        sx: SkScalar,
        sy: SkScalar,
        tx: SkScalar,
        ty: SkScalar,
        uninitialized: *mut SkMatrix,
    );
}
unsafe extern "C" {
    pub fn C_SkMatrix_Equals(self_: *const SkMatrix, rhs: *const SkMatrix) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_SubscriptMut(self_: *mut SkMatrix, index: usize) -> *mut SkScalar;
}
unsafe extern "C" {
    pub fn C_SkMatrix_getType(self_: *const SkMatrix) -> SkMatrix_TypeMask;
}
unsafe extern "C" {
    pub fn C_SkMatrix_rectStaysRect(self_: *const SkMatrix) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_hasPerspective(self_: *const SkMatrix) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_Rect2Rect(
        src: *const SkRect,
        dst: *const SkRect,
        scaleToFit: SkMatrix_ScaleToFit,
        m: *mut SkMatrix,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_setPolyToPoly(
        self_: *mut SkMatrix,
        src: *const SkPoint,
        srcLen: usize,
        dst: *const SkPoint,
        dstLen: usize,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_invert(self_: *const SkMatrix, inverse: *mut SkMatrix) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_isFinite(self_: *const SkMatrix) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMatrix_InvalidMatrix() -> *const SkMatrix;
}
unsafe extern "C" {
    pub fn C_SkMatrix_normalizePerspective(self_: *mut SkMatrix);
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapPoints(
        self_: *const SkMatrix,
        dst: *mut SkPoint,
        src: *const SkPoint,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapHomogeneousPoints(
        self_: *const SkMatrix,
        dst: *mut SkPoint3,
        src: *const SkPoint3,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapPointsToHomogeneous(
        self_: *const SkMatrix,
        dst: *mut SkPoint3,
        src: *const SkPoint,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapPoint(self_: *const SkMatrix, p: SkPoint) -> SkPoint;
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapPointAffine(self_: *const SkMatrix, p: SkPoint) -> SkPoint;
}
unsafe extern "C" {
    pub fn C_SkMatrix_mapVectors(
        self_: *const SkMatrix,
        dst: *mut SkVector,
        src: *const SkVector,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkSurfaceProps_Equals(
        self_: *const SkSurfaceProps,
        rhs: *const SkSurfaceProps,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_Construct(uninitialized: *mut SkBitmap);
}
unsafe extern "C" {
    pub fn C_SkBitmap_destruct(self_: *mut SkBitmap);
}
unsafe extern "C" {
    pub fn C_SkBitmap_Copy(from: *const SkBitmap, to: *mut SkBitmap);
}
unsafe extern "C" {
    pub fn C_SkBitmap_ComputeIsOpaque(self_: *const SkBitmap) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_setColorSpace(self_: *mut SkBitmap, colorSpace: *mut SkColorSpace);
}
unsafe extern "C" {
    pub fn C_SkBitmap_tryAllocN32Pixels(
        self_: *mut SkBitmap,
        width: ::core::ffi::c_int,
        height: ::core::ffi::c_int,
        isOpaque: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_tryAllocPixels(self_: *mut SkBitmap) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_pixelRefOrigin(self_: *const SkBitmap) -> SkIPoint;
}
unsafe extern "C" {
    pub fn C_SkBitmap_setPixelRef(
        self_: *mut SkBitmap,
        pixelRef: *mut SkPixelRef,
        dx: ::core::ffi::c_int,
        dy: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    pub fn C_SkBitmap_readyToDraw(self_: *const SkBitmap) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_eraseARGB(self_: *const SkBitmap, a: U8CPU, r: U8CPU, g: U8CPU, b: U8CPU);
}
unsafe extern "C" {
    pub fn C_SkBitmap_getAlphaf(
        self_: *const SkBitmap,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> f32;
}
unsafe extern "C" {
    pub fn C_SkBitmap_extractAlpha(
        self_: *const SkBitmap,
        dst: *mut SkBitmap,
        paint: *const SkPaint,
        offset: *mut SkIPoint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkBitmap_makeShader(
        self_: *const SkBitmap,
        tmx: SkTileMode,
        tmy: SkTileMode,
        sampling: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkBitmap_asImage(self_: *const SkBitmap) -> *mut SkImage;
}
unsafe extern "C" {
    pub fn C_SkPicture_MakeFromData(data: *const SkData) -> *mut SkPicture;
}
unsafe extern "C" {
    pub fn C_SkPicture_MakeFromData2(
        data: *const ::core::ffi::c_void,
        size: usize,
    ) -> *mut SkPicture;
}
unsafe extern "C" {
    pub fn C_SkPicture_serialize(self_: *const SkPicture) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkPicture_MakePlaceholder(cull: *const SkRect) -> *mut SkPicture;
}
unsafe extern "C" {
    pub fn C_SkPicture_playback(self_: *const SkPicture, canvas: *mut SkCanvas);
}
unsafe extern "C" {
    pub fn C_SkPicture_cullRect(self_: *const SkPicture, uninitialized: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkPicture_uniqueID(self_: *const SkPicture) -> u32;
}
unsafe extern "C" {
    pub fn C_SkPicture_approximateOpCount(
        self_: *const SkPicture,
        nested: bool,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkPicture_approximateBytesUsed(self_: *const SkPicture, out: *mut usize);
}
unsafe extern "C" {
    pub fn C_SkPicture_makeShader(
        self_: *const SkPicture,
        tmx: SkTileMode,
        tmy: SkTileMode,
        mode: SkFilterMode,
        localMatrix: *const SkMatrix,
        tileRect: *const SkRect,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkRRect_Construct(uninitialized: *mut SkRRect);
}
unsafe extern "C" {
    pub fn C_SkRRect_getType(self_: *const SkRRect) -> SkRRect_Type;
}
unsafe extern "C" {
    pub fn C_SkRRect_setRect(self_: *mut SkRRect, rect: *const SkRect);
}
unsafe extern "C" {
    pub fn C_SkRRect_dumpToString(self_: *const SkRRect, asHex: bool, str_: *mut SkString);
}
unsafe extern "C" {
    pub fn C_SkRRect_Equals(lhs: *const SkRRect, rhs: *const SkRRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRegion_destruct(region: *mut SkRegion);
}
unsafe extern "C" {
    pub fn C_SkRegion_Equals(lhs: *const SkRegion, rhs: *const SkRegion) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRegion_set(self_: *mut SkRegion, region: *const SkRegion) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRegion_quickContains(self_: *const SkRegion, r: *const SkIRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRegion_Iterator_Construct(uninitialized: *mut SkRegion_Iterator);
}
unsafe extern "C" {
    pub fn C_SkRegion_Iterator_destruct(self_: *mut SkRegion_Iterator);
}
unsafe extern "C" {
    pub fn C_SkRegion_Iterator_rgn(self_: *const SkRegion_Iterator) -> *const SkRegion;
}
unsafe extern "C" {
    pub fn C_SkRegion_Cliperator_destruct(self_: *mut SkRegion_Cliperator);
}
unsafe extern "C" {
    pub fn C_SkRegion_Spanerator_destruct(self_: *mut SkRegion_Spanerator);
}
unsafe extern "C" {
    pub fn C_SkFontStyle_Construct(uninitialized: *mut SkFontStyle);
}
unsafe extern "C" {
    pub fn C_SkFontStyle_Construct2(
        uninitialized: *mut SkFontStyle,
        weight: ::core::ffi::c_int,
        width: ::core::ffi::c_int,
        slant: SkFontStyle_Slant,
    );
}
unsafe extern "C" {
    pub fn C_SkFontStyle_Equals(lhs: *const SkFontStyle, rhs: *const SkFontStyle) -> bool;
}
unsafe extern "C" {
    pub fn C_SkFontStyle_weight(self_: *const SkFontStyle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkFontStyle_width(self_: *const SkFontStyle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkFontStyle_slant(self_: *const SkFontStyle) -> SkFontStyle_Slant;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_ref(self_: *const SkTextBlob);
}
unsafe extern "C" {
    pub fn C_SkTextBlob_unref(self_: *const SkTextBlob);
}
unsafe extern "C" {
    pub fn C_SkTextBlob_unique(self_: *const SkTextBlob) -> bool;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_MakeFromText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> *mut SkTextBlob;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_MakeFromPosTextH(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xPos: *const SkScalar,
        characterCount: usize,
        constY: SkScalar,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> *mut SkTextBlob;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_MakeFromPosText(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        pos: *const SkPoint,
        characterCount: usize,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> *mut SkTextBlob;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_MakeFromRSXform(
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        xform: *const SkRSXform,
        characterCount: usize,
        font: *const SkFont,
        encoding: SkTextEncoding,
    ) -> *mut SkTextBlob;
}
unsafe extern "C" {
    pub fn C_SkTextBlob_Iter_destruct(self_: *mut SkTextBlob_Iter);
}
unsafe extern "C" {
    pub fn C_SkTextBlobBuilder_destruct(self_: *mut SkTextBlobBuilder);
}
unsafe extern "C" {
    pub fn C_SkTextBlobBuilder_make(self_: *mut SkTextBlobBuilder) -> *mut SkTextBlob;
}
unsafe extern "C" {
    pub fn C_SkTypeface_fontStyle(self_: *const SkTypeface, uninitialized: *mut SkFontStyle);
}
unsafe extern "C" {
    pub fn C_SkTypeface_getVariationDesignPosition(
        self_: *const SkTypeface,
        coordinates: *mut SkFontArguments_VariationPosition_Coordinate,
        count: usize,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkTypeface_getVariationDesignParameters(
        self_: *const SkTypeface,
        parameters: *mut SkFontParameters_Variation_Axis,
        count: usize,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkTypeface_makeClone(
        self_: *const SkTypeface,
        arguments: *const SkFontArguments,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkTypeface_serialize(
        self_: *const SkTypeface,
        behavior: SkTypeface_SerializeBehavior,
    ) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkTypeface_serialize2(
        self_: *const SkTypeface,
        stream: *mut SkWStream,
        behavior: SkTypeface_SerializeBehavior,
    );
}
unsafe extern "C" {
    pub fn C_SkTypeface_MakeDeserialize(
        stream: *mut SkStream,
        lastResortFontMgr: *mut SkFontMgr,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkTypeface_unicharsToGlyphs(
        self_: *const SkTypeface,
        uni: *const SkUnichar,
        uniCount: usize,
        glyphs: *mut SkGlyphID,
        glyphsCount: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkTypeface_textToGlyphs(
        self_: *const SkTypeface,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: *mut SkGlyphID,
        glyphsCount: usize,
    ) -> usize;
}
unsafe extern "C" {
    pub fn C_SkTypeface_readTableTags(
        self_: *const SkTypeface,
        tags: *mut SkFontTableTag,
        count: usize,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkTypeface_copyTableData(self_: *const SkTypeface, tag: SkFontTableTag)
    -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkTypeface_getKerningPairAdjustments(
        self_: *const SkTypeface,
        glyphs: *const SkGlyphID,
        glyphsCount: usize,
        adjustments: *mut i32,
        adjustmentsCount: usize,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkTypeface_openStream(
        self_: *const SkTypeface,
        ttcIndex: *mut ::core::ffi::c_int,
    ) -> *mut SkStreamAsset;
}
unsafe extern "C" {
    pub fn C_SkTypeface_getBounds(self_: *const SkTypeface, uninitialized: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkTypeface_LocalizedStrings_unref(self_: *mut SkTypeface_LocalizedStrings);
}
unsafe extern "C" {
    pub fn C_SkTypeface_LocalizedStrings_next(
        self_: *mut SkTypeface_LocalizedStrings,
        string: *mut SkString,
        language: *mut SkString,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkFlattenable_getTypeName(self_: *const SkFlattenable) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn C_SkFlattenable_serialize(self_: *const SkFlattenable) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkFont_ConstructFromTypeface(uninitialized: *mut SkFont, typeface_: *mut SkTypeface);
}
unsafe extern "C" {
    pub fn C_SkFont_ConstructFromTypefaceWithSize(
        uninitialized: *mut SkFont,
        typeface_: *mut SkTypeface,
        size: SkScalar,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_ConstructFromTypefaceWithSizeScaleAndSkew(
        uninitialized: *mut SkFont,
        typeface_: *mut SkTypeface,
        size: SkScalar,
        scaleX: SkScalar,
        skewX: SkScalar,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_CopyConstruct(uninitialized: *mut SkFont, font: *const SkFont);
}
unsafe extern "C" {
    pub fn C_SkFont_destruct(self_: *mut SkFont);
}
unsafe extern "C" {
    pub fn C_SkFont_Equals(self_: *const SkFont, other: *const SkFont) -> bool;
}
unsafe extern "C" {
    pub fn C_SkFont_getEdging(self_: *const SkFont) -> SkFont_Edging;
}
unsafe extern "C" {
    pub fn C_SkFont_getHinting(self_: *const SkFont) -> SkFontHinting;
}
unsafe extern "C" {
    pub fn C_SkFont_makeWithSize(self_: *const SkFont, size: SkScalar, result: *mut SkFont);
}
unsafe extern "C" {
    pub fn C_SkFont_getTypeface(self_: *mut SkFont) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFont_setTypeface(self_: *mut SkFont, tf: *mut SkTypeface);
}
unsafe extern "C" {
    pub fn C_SkFont_textToGlyphs(
        self_: *const SkFont,
        text: *const ::core::ffi::c_void,
        byteLength: usize,
        encoding: SkTextEncoding,
        glyphs: *mut SkGlyphID,
        glyphsCount: usize,
    ) -> usize;
}
unsafe extern "C" {
    pub fn C_SkFont_unicharsToGlyphs(
        self_: *const SkFont,
        src: *const SkUnichar,
        charsCount: usize,
        dst: *mut SkGlyphID,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_getWidthBounds(
        self_: *const SkFont,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        widths: *mut SkScalar,
        bounds: *mut SkRect,
        paint: *const SkPaint,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_getPos(
        self_: *const SkFont,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        pos: *mut SkPoint,
        origin: SkPoint,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_getXPos(
        self_: *const SkFont,
        glyphs: *const SkGlyphID,
        glyphCount: usize,
        xPos: *mut SkScalar,
        origin: SkScalar,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_getIntercepts(
        self_: *const SkFont,
        glyphs: *const SkGlyphID,
        count: usize,
        pos: *const SkPoint,
        top: SkScalar,
        bottom: SkScalar,
        paint: *const SkPaint,
        vs: *mut VecSink<SkScalar>,
    );
}
unsafe extern "C" {
    pub fn C_SkFont_getPath(self_: *const SkFont, glyphID: SkGlyphID, pathR: *mut SkPath) -> bool;
}
unsafe extern "C" {
    pub fn C_SkFontArguments_construct(uninitialized: *mut SkFontArguments);
}
unsafe extern "C" {
    pub fn C_SkFontArguments_destruct(self_: *mut SkFontArguments);
}
unsafe extern "C" {
    pub fn C_SkFontArguments_setCollectionIndex(
        self_: *mut SkFontArguments,
        collectionIndex: ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    pub fn C_SkFontArguments_setVariationDesignPosition(
        self_: *mut SkFontArguments,
        position: SkFontArguments_VariationPosition,
    );
}
unsafe extern "C" {
    pub fn C_SkFontArguments_setPalette(
        self_: *mut SkFontArguments,
        palette: SkFontArguments_Palette,
    );
}
unsafe extern "C" {
    pub fn C_SkFontArguments_getVariationDesignPosition(
        self_: *const SkFontArguments,
    ) -> SkFontArguments_VariationPosition;
}
unsafe extern "C" {
    pub fn C_SkFontArguments_getPalette(self_: *const SkFontArguments) -> SkFontArguments_Palette;
}
unsafe extern "C" {
    pub fn C_SkFontStyleSet_count(self_: *mut SkFontStyleSet) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkFontStyleSet_getStyle(
        self_: *mut SkFontStyleSet,
        index: ::core::ffi::c_int,
        fontStyle: *mut SkFontStyle,
        style: *mut SkString,
    );
}
unsafe extern "C" {
    pub fn C_SkFontStyleSet_createTypeface(
        self_: *mut SkFontStyleSet,
        index: ::core::ffi::c_int,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontStyleSet_matchStyle(
        self_: *mut SkFontStyleSet,
        pattern: *const SkFontStyle,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontStyleSet_CreateEmpty() -> *mut SkFontStyleSet;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_createStyleSet(
        self_: *const SkFontMgr,
        index: ::core::ffi::c_int,
    ) -> *mut SkFontStyleSet;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_matchFamily(
        self_: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
    ) -> *mut SkFontStyleSet;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_matchFamilyStyle(
        self_: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        style: *const SkFontStyle,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_matchFamilyStyleCharacter(
        self_: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        style: *const SkFontStyle,
        bcp47: *mut *const ::core::ffi::c_char,
        bcp47Count: ::core::ffi::c_int,
        character: SkUnichar,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_makeFromData(
        self_: *const SkFontMgr,
        data: *mut SkData,
        ttcIndex: ::core::ffi::c_int,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_makeFromStream(
        self_: *const SkFontMgr,
        stream: *mut SkStreamAsset,
        ttcIndex: ::core::ffi::c_int,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_legacyMakeTypeface(
        self_: *const SkFontMgr,
        familyName: *const ::core::ffi::c_char,
        style: SkFontStyle,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_NewSystem() -> *mut SkFontMgr;
}
unsafe extern "C" {
    pub fn C_SkFontMgr_RefEmpty() -> *mut SkFontMgr;
}
unsafe extern "C" {
    pub fn C_SkFontParameters_Variation_Axis_isHidden(
        self_: *const SkFontParameters_Variation_Axis,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkFontParameters_Variation_Axis_setHidden(
        self_: *mut SkFontParameters_Variation_Axis,
        hidden: bool,
    );
}
unsafe extern "C" {
    pub fn C_SkVertices_ref(self_: *const SkVertices);
}
unsafe extern "C" {
    pub fn C_SkVertices_unref(self_: *const SkVertices);
}
unsafe extern "C" {
    pub fn C_SkVertices_unique(self_: *const SkVertices) -> bool;
}
unsafe extern "C" {
    pub fn C_SkVertices_MakeCopy(
        mode: SkVertices_VertexMode,
        vertexCount: ::core::ffi::c_int,
        positions: *const SkPoint,
        texs: *const SkPoint,
        colors: *const SkColor,
        indexCount: ::core::ffi::c_int,
        indices: *const u16,
    ) -> *mut SkVertices;
}
unsafe extern "C" {
    pub fn C_SkVertices_Builder_destruct(builder: *mut SkVertices_Builder);
}
unsafe extern "C" {
    pub fn C_SkVertices_Builder_detach(builder: *mut SkVertices_Builder) -> *mut SkVertices;
}
unsafe extern "C" {
    pub fn C_SkPictureRecorder_Construct(uninitialized: *mut SkPictureRecorder);
}
unsafe extern "C" {
    pub fn C_SkPictureRecorder_destruct(self_: *mut SkPictureRecorder);
}
unsafe extern "C" {
    pub fn C_SkPictureRecorder_beginRecording(
        self_: *mut SkPictureRecorder,
        bounds: *const SkRect,
        useBBH: bool,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkPictureRecorder_finishRecordingAsPicture(
        self_: *mut SkPictureRecorder,
        cullRect: *const SkRect,
    ) -> *mut SkPicture;
}
unsafe extern "C" {
    pub fn C_SkPictureRecorder_finishRecordingAsDrawable(
        self_: *mut SkPictureRecorder,
    ) -> *mut SkDrawable;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_width(self_: *const SkPixelRef) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_height(self_: *const SkPixelRef) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_pixels(self_: *const SkPixelRef) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_rowBytes(self_: *const SkPixelRef) -> usize;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_isImmutable(self_: *const SkPixelRef) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPixelRef_notifyAddedToCache(self_: *mut SkPixelRef);
}
unsafe extern "C" {
    pub fn C_SkPoint_isFinite(self_: *const SkPoint) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRecorder_delete(self_: *mut SkRecorder);
}
unsafe extern "C" {
    pub fn C_SkRecorder_type(self_: *const SkRecorder, ty: *mut SkRecorder_Type);
}
unsafe extern "C" {
    pub fn C_SkRecorder_cpuRecorder(self_: *mut SkRecorder) -> *mut skcpu_Recorder;
}
unsafe extern "C" {
    pub fn C_SkIRect_isEmpty(self_: *const SkIRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkIRect_contains(self_: *const SkIRect, rect: *const SkRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRect_Bounds(pts: *const SkPoint, count: usize, bounds: *mut SkRect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRect_setBoundsCheck(self_: *mut SkRect, pts: *const SkPoint, count: usize) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRect_setBoundsNoCheck(self_: *mut SkRect, pts: *const SkPoint, count: usize);
}
unsafe extern "C" {
    pub fn C_SkRect_round(self_: *const SkRect, dst: *mut SkIRect);
}
unsafe extern "C" {
    pub fn C_SkRect_roundIn(self_: *const SkRect, dst: *mut SkIRect);
}
unsafe extern "C" {
    pub fn C_SkRect_dumpToString(self_: *const SkRect, asHex: bool, str_: *mut SkString);
}
unsafe extern "C" {
    pub fn C_SkRect_roundOut(self_: *const SkRect, dst: *mut SkIRect);
}
unsafe extern "C" {
    pub fn C_SkRefCntBase_ref(self_: *const SkRefCntBase);
}
unsafe extern "C" {
    pub fn C_SkRefCntBase_unref(self_: *const SkRefCntBase);
}
unsafe extern "C" {
    pub fn C_SkRefCntBase_unique(self_: *const SkRefCntBase) -> bool;
}
unsafe extern "C" {
    pub fn C_SkColorFilter_makeComposed(
        self_: *const SkColorFilter,
        inner: *mut SkColorFilter,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilter_withWorkingColorSpace(
        self_: *const SkColorFilter,
        colorSpace: *mut SkColorSpace,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilter_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilter_filterColor4f(
        self_: *const SkColorFilter,
        srcColor: *const SkColor4f,
        srcCS: *mut SkColorSpace,
        dstCS: *mut SkColorSpace,
    ) -> SkColor4f;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Compose(
        outer: *mut SkColorFilter,
        inner: *mut SkColorFilter,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Blend2(
        c: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        blendMode: SkBlendMode,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Blend(c: SkColor, blendMode: SkBlendMode) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Matrix(
        colorMatrix: *const SkColorMatrix,
        clamp: SkColorFilters_Clamp,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_MatrixRowMajor(
        array: *const SkScalar,
        clamp: SkColorFilters_Clamp,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_HSLAMatrixOfColorMatrix(
        colorMatrix: *const SkColorMatrix,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_HSLAMatrix(rowMajor: *const f32) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_LinearToSRGBGamma() -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_SRGBToLinearGamma() -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Lerp(
        t: f32,
        dst: *mut SkColorFilter,
        src: *mut SkColorFilter,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Table(table: *const u8) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_TableARGB(
        tableA: *const u8,
        tableR: *const u8,
        tableG: *const u8,
        tableB: *const u8,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Table2(table: *mut SkColorTable) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkColorFilters_Lighting(mul: SkColor, add: SkColor) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkContourMeasureIter_destruct(self_: *mut SkContourMeasureIter);
}
unsafe extern "C" {
    pub fn C_SkContourMeasureIter_next(self_: *mut SkContourMeasureIter) -> *mut SkContourMeasure;
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_length(self_: *const SkContourMeasure) -> SkScalar;
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_isClosed(self_: *const SkContourMeasure) -> bool;
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_begin(
        self_: *const SkContourMeasure,
        uninitialized: *mut SkContourMeasure_ForwardVerbIterator,
    );
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_end(
        self_: *const SkContourMeasure,
        uninitialized: *mut SkContourMeasure_ForwardVerbIterator,
    );
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_ForwardVerbIterator_Equals(
        a: *const SkContourMeasure_ForwardVerbIterator,
        b: *const SkContourMeasure_ForwardVerbIterator,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_ForwardVerbIterator_item(
        self_: *const SkContourMeasure_ForwardVerbIterator,
        uninitialized: *mut SkContourMeasure_VerbMeasure,
    );
}
unsafe extern "C" {
    pub fn C_SkContourMeasure_ForwardVerbIterator_next(
        self_: *mut SkContourMeasure_ForwardVerbIterator,
    );
}
unsafe extern "C" {
    pub fn C_SkDataTable_count(self_: *const SkDataTable) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkDataTable_MakeEmpty() -> *mut SkDataTable;
}
unsafe extern "C" {
    pub fn C_SkDataTable_MakeCopyArrays(
        ptrs: *const *const ::core::ffi::c_void,
        sizes: *const usize,
        count: ::core::ffi::c_int,
    ) -> *mut SkDataTable;
}
unsafe extern "C" {
    pub fn C_SkDataTable_MakeCopyArray(
        array: *const ::core::ffi::c_void,
        elemSize: usize,
        count: ::core::ffi::c_int,
    ) -> *mut SkDataTable;
}
unsafe extern "C" {
    pub fn C_SkColorTable_Make(
        tableA: *const u8,
        tableR: *const u8,
        tableG: *const u8,
        tableB: *const u8,
    ) -> *mut SkColorTable;
}
unsafe extern "C" {
    pub fn C_SkColorTable_getTable(self_: *const SkColorTable, index: usize) -> *const u8;
}
unsafe extern "C" {
    pub fn C_SkDrawable_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkDrawable;
}
unsafe extern "C" {
    pub fn C_SkDrawable_makePictureSnapshot(self_: *mut SkDrawable) -> *mut SkPicture;
}
unsafe extern "C" {
    pub fn C_SkDrawable_getBounds(self_: *mut SkDrawable, result: *mut SkRect);
}
unsafe extern "C" {
    pub fn C_SkImageFilter_computeFastBounds(
        self_: *const SkImageFilter,
        bounds: *const SkRect,
        uninitialized: *mut SkRect,
    );
}
unsafe extern "C" {
    pub fn C_SkImageFilter_makeWithLocalMatrix(
        self_: *const SkImageFilter,
        matrix: *const SkMatrix,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilter_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilter_filterBounds(
        self_: *const SkImageFilter,
        src: *const SkIRect,
        ctm: *const SkMatrix,
        mapDirection: SkImageFilter_MapDirection,
        inputRect: *const SkIRect,
        result: *mut SkIRect,
    );
}
unsafe extern "C" {
    pub fn C_SkImageFilter_isColorFilterNode(
        self_: *const SkImageFilter,
        filterPtr: *mut *mut SkColorFilter,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImageFilter_countInputs(self_: *const SkImageFilter) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkImageFilter_getInput(
        self_: *const SkImageFilter,
        i: ::core::ffi::c_int,
    ) -> *const SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageGenerator_delete(self_: *mut SkImageGenerator);
}
unsafe extern "C" {
    pub fn C_SkImageGenerator_refEncodedData(self_: *mut SkImageGenerator) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkImageGenerator_isValid(
        self_: *const SkImageGenerator,
        recorder: *mut SkRecorder,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImageGenerator_isProtected(self_: *const SkImageGenerator) -> bool;
}
unsafe extern "C" {
    pub fn C_SkImageGenerator_isTextureGenerator(self_: *const SkImageGenerator) -> bool;
}
unsafe extern "C" {
    pub fn C_SkString_destruct(self_: *mut SkString);
}
unsafe extern "C" {
    pub fn C_SkString_CopyConstruct(uninitialized: *mut SkString, str_: *const SkString);
}
unsafe extern "C" {
    pub fn C_SkString_c_str_size(
        self_: *const SkString,
        size: *mut usize,
    ) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn C_SkStrings_construct(
        uninitialized: *mut SkStrings,
        string: *mut SkString,
        count: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkStrings_destruct(self_: *mut SkStrings);
}
unsafe extern "C" {
    pub fn C_SkStrings_ptr_count(self_: *const SkStrings, count: *mut usize) -> *const SkString;
}
unsafe extern "C" {
    pub fn C_string_view_ptr_size(
        self_: *const std_string_view,
        size: *mut usize,
    ) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn C_string_ptr_size(
        self_: *const std_string,
        size: *mut usize,
    ) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn C_SkStrokeRec_destruct(self_: *mut SkStrokeRec);
}
unsafe extern "C" {
    pub fn C_SkStrokeRec_copy(self_: *const SkStrokeRec, other: *mut SkStrokeRec);
}
unsafe extern "C" {
    pub fn C_SkStrokeRec_getCap(self_: *const SkStrokeRec) -> SkPaint_Cap;
}
unsafe extern "C" {
    pub fn C_SkStrokeRec_getJoin(self_: *const SkStrokeRec) -> SkPaint_Join;
}
unsafe extern "C" {
    pub fn C_SkStrokeRec_hasEqualEffect(
        self_: *const SkStrokeRec,
        other: *const SkStrokeRec,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPathEffect_MakeSum(
        first: *mut SkPathEffect,
        second: *mut SkPathEffect,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkPathEffect_MakeCompose(
        outer: *mut SkPathEffect,
        inner: *mut SkPathEffect,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkPathEffect_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkPixmap_destruct(self_: *mut SkPixmap);
}
unsafe extern "C" {
    pub fn C_SkPixmap_setColorSpace(self_: *mut SkPixmap, colorSpace: *mut SkColorSpace);
}
unsafe extern "C" {
    pub fn C_SkMaskFilter_MakeBlur(
        style: SkBlurStyle,
        sigma: SkScalar,
        respectCTM: bool,
    ) -> *mut SkMaskFilter;
}
unsafe extern "C" {
    pub fn C_SkMaskFilter_Deserialize(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkMaskFilter;
}
unsafe extern "C" {
    pub fn C_SkSize_toRound(size: *const SkSize) -> SkISize;
}
unsafe extern "C" {
    pub fn C_SkSize_toCeil(size: *const SkSize) -> SkISize;
}
unsafe extern "C" {
    pub fn C_SkSize_toFloor(size: *const SkSize) -> SkISize;
}
unsafe extern "C" {
    pub fn C_SkShader_isOpaque(self_: *const SkShader) -> bool;
}
unsafe extern "C" {
    pub fn C_SkShader_isAImage(self_: *const SkShader) -> bool;
}
unsafe extern "C" {
    pub fn C_SkShader_makeWithLocalMatrix(
        self_: *const SkShader,
        matrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShader_makeWithColorFilter(
        self_: *const SkShader,
        colorFilter: *mut SkColorFilter,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShader_makeWithWorkingColorSpace(
        self_: *const SkShader,
        inputCS: *mut SkColorSpace,
        outputCS: *mut SkColorSpace,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_Empty() -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_Color(color: SkColor) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_Color2(
        color: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_Blend(
        blender: *mut SkBlender,
        dst: *mut SkShader,
        src: *mut SkShader,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_CoordClamp(shader: *mut SkShader, subset: *const SkRect) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_Image(
        image: *mut SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        options: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_RawImage(
        image: *mut SkImage,
        tmx: SkTileMode,
        tmy: SkTileMode,
        options: *const SkSamplingOptions,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShader_Deserialize(data: *const ::core::ffi::c_void, length: usize)
    -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkStream_delete(stream: *mut SkStream);
}
unsafe extern "C" {
    pub fn C_SkStream_read(
        stream: *mut SkStream,
        buffer: *mut ::core::ffi::c_void,
        len: usize,
    ) -> usize;
}
unsafe extern "C" {
    pub fn C_SkStreamAsset_getLength(self_: *const SkStreamAsset) -> usize;
}
unsafe extern "C" {
    pub fn C_SkWStream_destruct(self_: *mut SkWStream);
}
unsafe extern "C" {
    pub fn C_SkWStream_write(
        self_: *mut SkWStream,
        buffer: *const ::core::ffi::c_void,
        size: usize,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkMemoryStream_MakeDirect(
        data: *const ::core::ffi::c_void,
        length: usize,
    ) -> *mut SkMemoryStream;
}
unsafe extern "C" {
    pub fn C_SkDynamicMemoryWStream_Construct(uninitialized: *mut SkDynamicMemoryWStream);
}
unsafe extern "C" {
    pub fn C_SkDynamicMemoryWStream_detachAsData(self_: *mut SkDynamicMemoryWStream)
    -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkDynamicMemoryWStream_detachAsStream(
        self_: *mut SkDynamicMemoryWStream,
    ) -> *mut SkStreamAsset;
}
unsafe extern "C" {
    pub fn C_SkTiledImageUtils_DrawImageRect(
        canvas: *mut SkCanvas,
        image: *const SkImage,
        src: *const SkRect,
        dst: *const SkRect,
        sampling: *const SkSamplingOptions,
        paint: *const SkPaint,
        constraint: SkCanvas_SrcRectConstraint,
    );
}
unsafe extern "C" {
    pub fn C_SkTiledImageUtils_GetImageKeyValues(image: *const SkImage, keyValues: *mut u32);
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_Construct(uninitialized: *mut SkYUVAInfo);
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_destruct(self_: *mut SkYUVAInfo);
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_SubsamplingFactors(
        subsampling: SkYUVAInfo_Subsampling,
        factors: *mut ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_PlaneSubsamplingFactors(
        planeConfig: SkYUVAInfo_PlaneConfig,
        subsampling: SkYUVAInfo_Subsampling,
        planeIdx: ::core::ffi::c_int,
        factors: *mut ::core::ffi::c_int,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_NumPlanes(planeConfig: SkYUVAInfo_PlaneConfig) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_NumChannelsInPlane(
        planarConfig: SkYUVAInfo_PlaneConfig,
        i: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_equals(a: *const SkYUVAInfo, b: *const SkYUVAInfo) -> bool;
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_makeSubsampling(
        self_: *const SkYUVAInfo,
        subsampling: SkYUVAInfo_Subsampling,
        uninitialized: *mut SkYUVAInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAInfo_makeDimensions(
        self_: *const SkYUVAInfo,
        dimensions: *const SkISize,
        uninitialized: *mut SkYUVAInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_Construct(uninitialized: *mut SkYUVAPixmapInfo);
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_destruct(self_: *mut SkYUVAPixmapInfo);
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_equals(
        a: *const SkYUVAPixmapInfo,
        b: *const SkYUVAPixmapInfo,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_rowBytes(
        self_: *const SkYUVAPixmapInfo,
        i: ::core::ffi::c_int,
    ) -> usize;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_planeInfo(
        self_: *const SkYUVAPixmapInfo,
        i: ::core::ffi::c_int,
    ) -> *const SkImageInfo;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_isValid(self_: *const SkYUVAPixmapInfo) -> bool;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_SupportedDataTypes_Construct(
        uninitialized: *mut SkYUVAPixmapInfo_SupportedDataTypes,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_SupportedDataTypes_destruct(
        self_: *mut SkYUVAPixmapInfo_SupportedDataTypes,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_SupportedDataTypes_All(
        uninitialized: *mut SkYUVAPixmapInfo_SupportedDataTypes,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_SupportedDataTypes_supported(
        self_: *const SkYUVAPixmapInfo_SupportedDataTypes,
        pc: SkYUVAPixmapInfo_PlaneConfig,
        dt: SkYUVAPixmapInfo_DataType,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_DefaultColorTypeForDataType(
        dt: SkYUVAPixmapInfo_DataType,
        numChannels: ::core::ffi::c_int,
    ) -> SkColorType;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmapInfo_NumChannelsAndDataType(
        colorType: SkColorType,
        dataType: *mut SkYUVAPixmapInfo_DataType,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_Construct(uninitialized: *mut SkYUVAPixmaps);
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_destruct(self_: *mut SkYUVAPixmaps);
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_MakeCopy(self_: *const SkYUVAPixmaps, uninitialized: *mut SkYUVAPixmaps);
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_Allocate(
        uninitialized: *mut SkYUVAPixmaps,
        yuvaPixmapInfo: *const SkYUVAPixmapInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_FromData(
        uninitialized: *mut SkYUVAPixmaps,
        yuvaPixmapInfo: *const SkYUVAPixmapInfo,
        data: *mut SkData,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_FromExternalMemory(
        uninitialized: *mut SkYUVAPixmaps,
        yuvaPixmapInfo: *const SkYUVAPixmapInfo,
        memory: *mut ::core::ffi::c_void,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_FromExternalPixmaps(
        uninitialized: *mut SkYUVAPixmaps,
        yuvaInfo: *const SkYUVAInfo,
        pixmaps: *const SkPixmap,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_pixmapsInfo(
        self_: *const SkYUVAPixmaps,
        uninitialized: *mut SkYUVAPixmapInfo,
    );
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_planes(self_: *const SkYUVAPixmaps) -> *const SkPixmap;
}
unsafe extern "C" {
    pub fn C_SkYUVAPixmaps_isValid(self_: *const SkYUVAPixmaps) -> bool;
}
unsafe extern "C" {
    pub fn C_Effects_Types(arg1: *mut SkTableMaskFilter);
}
unsafe extern "C" {
    pub fn C_SkBlenders_Arithmetic(
        k1: f32,
        k2: f32,
        k3: f32,
        k4: f32,
        enforcePremul: bool,
    ) -> *mut SkBlender;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_Types(arg1: *mut SkGradientShader);
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeLinear(
        pts: *const SkPoint,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeLinearWithInterpolation(
        pts: *const SkPoint,
        colors: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeRadial(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeRadialWithInterpolation(
        center: *const SkPoint,
        radius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeTwoPointConical(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeTwoPointConicalWithInterpolation(
        start: *const SkPoint,
        startRadius: SkScalar,
        end: *const SkPoint,
        endRadius: SkScalar,
        colors: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeSweep(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        flags: u32,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkGradientShader_MakeSweepWithInterpolation(
        cx: SkScalar,
        cy: SkScalar,
        colors: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        pos: *const SkScalar,
        count: ::core::ffi::c_int,
        mode: SkTileMode,
        startAngle: SkScalar,
        endAngle: SkScalar,
        interpolation: *const SkGradientShader_Interpolation,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_MakeFractalNoise(
        baseFrequencyX: SkScalar,
        baseFrequencyY: SkScalar,
        numOctaves: ::core::ffi::c_int,
        seed: SkScalar,
        tileSize: *const SkISize,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkShaders_MakeTurbulence(
        baseFrequencyX: SkScalar,
        baseFrequencyY: SkScalar,
        numOctaves: ::core::ffi::c_int,
        seed: SkScalar,
        tileSize: *const SkISize,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkPath1DPathEffect_Make(
        path: *const SkPath,
        advance: SkScalar,
        phase: SkScalar,
        style: SkPath1DPathEffect_Style,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkLine2DPathEffect_Make(width: SkScalar, matrix: *const SkMatrix)
    -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkPath2DPathEffect_Make(
        matrix: *const SkMatrix,
        path: *const SkPath,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkColorMatrix_Construct(uninitialized: *mut SkColorMatrix);
}
unsafe extern "C" {
    pub fn C_SkColorMatrix_Construct2(
        uninitialized: *mut SkColorMatrix,
        m00: f32,
        m01: f32,
        m02: f32,
        m03: f32,
        m04: f32,
        m10: f32,
        m11: f32,
        m12: f32,
        m13: f32,
        m14: f32,
        m20: f32,
        m21: f32,
        m22: f32,
        m23: f32,
        m24: f32,
        m30: f32,
        m31: f32,
        m32: f32,
        m33: f32,
        m34: f32,
    );
}
unsafe extern "C" {
    pub fn C_SkColorMatrix_setRowMajor(self_: *mut SkColorMatrix, src: *const f32);
}
unsafe extern "C" {
    pub fn C_SkColorMatrix_getRowMajor(self_: *const SkColorMatrix, dst: *mut f32);
}
unsafe extern "C" {
    pub fn C_SkCornerPathEffect_Make(radius: SkScalar) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkDashPathEffect_Make(
        intervals: *const SkScalar,
        count: usize,
        phase: SkScalar,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkDiscretePathEffect_Make(
        segLength: SkScalar,
        dev: SkScalar,
        seedAssist: u32,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkHighContrastFilter_Make(config: *const SkHighContrastConfig) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkLumaColorFilter_Make() -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkOverdrawColorFilter_MakeWithSkColors(colors: *const SkColor) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_Options_Construct(
        uninitialized: *mut SkRuntimeEffect_Options,
        forceUnoptimized: bool,
        name: *const ::core::ffi::c_char,
        length: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_MakeForColorFilter(
        sksl: *const SkString,
        options: *const SkRuntimeEffect_Options,
        error: *mut SkString,
    ) -> *mut SkRuntimeEffect;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_MakeForShader(
        sksl: *const SkString,
        options: *const SkRuntimeEffect_Options,
        error: *mut SkString,
    ) -> *mut SkRuntimeEffect;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_MakeForBlender(
        sksl: *const SkString,
        options: *const SkRuntimeEffect_Options,
        error: *mut SkString,
    ) -> *mut SkRuntimeEffect;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_makeShader(
        self_: *const SkRuntimeEffect,
        uniforms: *const SkData,
        children: *mut SkRuntimeEffect_ChildPtr,
        childCount: usize,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_makeColorFilter(
        self_: *const SkRuntimeEffect,
        inputs: *const SkData,
        children: *mut SkRuntimeEffect_ChildPtr,
        childCount: usize,
    ) -> *mut SkColorFilter;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_makeBlender(
        self_: *const SkRuntimeEffect,
        uniforms: *const SkData,
        children: *mut SkRuntimeEffect_ChildPtr,
        childCount: usize,
    ) -> *mut SkBlender;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_source(
        self_: *const SkRuntimeEffect,
        len: *mut usize,
    ) -> *const ::core::ffi::c_uchar;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_uniforms(
        self_: *const SkRuntimeEffect,
        count: *mut usize,
    ) -> *const SkRuntimeEffect_Uniform;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_children(
        self_: *const SkRuntimeEffect,
        count: *mut usize,
    ) -> *const SkRuntimeEffect_Child;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_findUniform(
        self_: *const SkRuntimeEffect,
        name: *const ::core::ffi::c_char,
        count: usize,
    ) -> *const SkRuntimeEffect_Uniform;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_findChild(
        self_: *const SkRuntimeEffect,
        name: *const ::core::ffi::c_char,
        count: usize,
    ) -> *const SkRuntimeEffect_Child;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_allowShader(self_: *const SkRuntimeEffect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_allowColorFilter(self_: *const SkRuntimeEffect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRuntimeEffect_allowBlender(self_: *const SkRuntimeEffect) -> bool;
}
unsafe extern "C" {
    pub fn C_SkRuntimeShaderBuilder_Construct(
        uninitialized: *mut SkRuntimeShaderBuilder,
        effect: *mut SkRuntimeEffect,
    );
}
unsafe extern "C" {
    pub fn C_SkRuntimeShaderBuilder_destruct(self_: *mut SkRuntimeShaderBuilder);
}
unsafe extern "C" {
    pub fn C_SkRuntimeShaderBuilder_makeShader(
        self_: *const SkRuntimeShaderBuilder,
        localMatrix: *const SkMatrix,
    ) -> *mut SkShader;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ShaderBuilderUniformResult {
    Ok = 0,
    Error = 1,
}
unsafe extern "C" {
    pub fn C_SkRuntimeShaderBuilder_setUniformFloat(
        self_: *mut SkRuntimeShaderBuilder,
        name: *const ::core::ffi::c_char,
        count: usize,
        values: *const f32,
        len: usize,
    ) -> ShaderBuilderUniformResult;
}
unsafe extern "C" {
    pub fn C_SkRuntimeShaderBuilder_setUniformInt(
        self_: *mut SkRuntimeShaderBuilder,
        name: *const ::core::ffi::c_char,
        count: usize,
        values: *const ::core::ffi::c_int,
        len: usize,
    ) -> ShaderBuilderUniformResult;
}
unsafe extern "C" {
    pub fn C_SkShaderMaskFilter_Make(shader: *mut SkShader) -> *mut SkMaskFilter;
}
unsafe extern "C" {
    pub fn C_SkTrimPathEffect_Make(
        startT: SkScalar,
        stopT: SkScalar,
        mode: SkTrimPathEffect_Mode,
    ) -> *mut SkPathEffect;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Arithmetic(
        k1: f32,
        k2: f32,
        k3: f32,
        k4: f32,
        enforcePMColor: bool,
        background: *mut SkImageFilter,
        foreground: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Blend(
        blender: *mut SkBlender,
        background: *mut SkImageFilter,
        foreground: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Blur(
        sigmaX: SkScalar,
        sigmaY: SkScalar,
        tileMode: SkTileMode,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_ColorFilter(
        cf: *mut SkColorFilter,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Compose(
        outer: *mut SkImageFilter,
        inner: *mut SkImageFilter,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Crop(
        rect: *const SkRect,
        tileMode: SkTileMode,
        input: *mut SkImageFilter,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_DisplacementMap(
        xChannelSelector: SkColorChannel,
        yChannelSelector: SkColorChannel,
        scale: SkScalar,
        displacement: *mut SkImageFilter,
        color: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_DropShadow(
        dx: SkScalar,
        dy: SkScalar,
        sigmaX: SkScalar,
        sigmaY: SkScalar,
        color: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_DropShadowOnly(
        dx: SkScalar,
        dy: SkScalar,
        sigmaX: SkScalar,
        sigmaY: SkScalar,
        color: *const SkColor4f,
        colorSpace: *mut SkColorSpace,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Empty() -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Image(
        image: *mut SkImage,
        srcRect: *const SkRect,
        dstRect: *const SkRect,
        sampling: *const SkSamplingOptions,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Magnifier(
        lensBounds: *const SkRect,
        zoomAmount: SkScalar,
        inset: SkScalar,
        sampling: *const SkSamplingOptions,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_MatrixConvolution(
        kernelSize: *const SkISize,
        kernel: *const SkScalar,
        gain: SkScalar,
        bias: SkScalar,
        kernelOffset: *const SkIPoint,
        tileMode: SkTileMode,
        convolveAlpha: bool,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_MatrixTransform(
        matrix: *const SkMatrix,
        sampling: *const SkSamplingOptions,
        input: *mut SkImageFilter,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Merge(
        filters: *const *mut SkImageFilter,
        count: ::core::ffi::c_int,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Offset(
        dx: SkScalar,
        dy: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Picture(
        pic: *mut SkPicture,
        targetRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Shader(
        shader: *mut SkShader,
        dither: SkImageFilters_Dither,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Tile(
        src: *const SkRect,
        dst: *const SkRect,
        input: *mut SkImageFilter,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Dilate(
        radiusX: SkScalar,
        radiusY: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_Erode(
        radiusX: SkScalar,
        radiusY: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_DistantLitDiffuse(
        direction: *const SkPoint3,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        kd: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_PointLitDiffuse(
        direction: *const SkPoint3,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        kd: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_SpotLitDiffuse(
        location: *const SkPoint3,
        target: *const SkPoint3,
        specularExponent: SkScalar,
        cutoffAngle: SkScalar,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        kd: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_ImageFilters_DistantLitSpecular(
        direction: *const SkPoint3,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        ks: SkScalar,
        shininess: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_PointLitSpecular(
        location: *const SkPoint3,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        ks: SkScalar,
        shininess: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_SpotLitSpecular(
        location: *const SkPoint3,
        target: *const SkPoint3,
        specularExponent: SkScalar,
        cutoffAngle: SkScalar,
        lightColor: SkColor,
        surfaceScale: SkScalar,
        ks: SkScalar,
        shininess: SkScalar,
        input: *mut SkImageFilter,
        cropRect: *const SkRect,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkImageFilters_RuntimeShader(
        builder: *const SkRuntimeShaderBuilder,
        childShaderName: *const ::core::ffi::c_char,
        childShaderNameCount: usize,
        input: *mut SkImageFilter,
    ) -> *mut SkImageFilter;
}
unsafe extern "C" {
    pub fn C_SkPngEncoder_Encode(
        stream: *mut SkWStream,
        pixmap: *const SkPixmap,
        comments: *mut SkDataTable,
        filterFlags: SkPngEncoder_FilterFlag,
        zLibLevel: ::core::ffi::c_int,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkPngEncoder_EncodeImage(
        ctx: *mut GrDirectContext,
        img: *const SkImage,
        comments: *mut SkDataTable,
        filterFlags: SkPngEncoder_FilterFlag,
        zLibLevel: ::core::ffi::c_int,
    ) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkJpegEncoder_Encode(
        stream: *mut SkWStream,
        pixmap: *const SkPixmap,
        quality: ::core::ffi::c_int,
        downsample: SkJpegEncoder_Downsample,
        alphaOption: SkJpegEncoder_AlphaOption,
        xmpMetadata: *const SkData,
        origin: *const SkEncodedOrigin,
    ) -> bool;
}
unsafe extern "C" {
    pub fn C_SkJpegEncoder_EncodeImage(
        ctx: *mut GrDirectContext,
        img: *const SkImage,
        quality: ::core::ffi::c_int,
        downsample: SkJpegEncoder_Downsample,
        alphaOption: SkJpegEncoder_AlphaOption,
        xmpMetadata: *const SkData,
        origin: *const SkEncodedOrigin,
    ) -> *mut SkData;
}
unsafe extern "C" {
    pub fn C_SkPDF_AttributeList_destruct(self_: *mut SkPDF_AttributeList);
}
unsafe extern "C" {
    pub fn C_SkPDF_AttributeList_appendFloatArray(
        self_: *mut SkPDF_AttributeList,
        owner: *const ::core::ffi::c_char,
        name: *const ::core::ffi::c_char,
        value: *const f32,
        len: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkPDF_StructureElementNode_new() -> *mut SkPDF_StructureElementNode;
}
unsafe extern "C" {
    pub fn C_SkPDF_StructureElementNode_delete(self_: *mut SkPDF_StructureElementNode);
}
unsafe extern "C" {
    pub fn C_SkPDF_StructureElementNode_setChildVector(
        self_: *mut SkPDF_StructureElementNode,
        nodes: *mut *mut SkPDF_StructureElementNode,
        len: usize,
    );
}
unsafe extern "C" {
    pub fn C_SkPDF_StructElementNode_appendChild(
        self_: *mut SkPDF_StructureElementNode,
        node: *mut SkPDF_StructureElementNode,
    );
}
unsafe extern "C" {
    pub fn C_SkPDF_StructureElementNode_getChildVector(
        self_: *const SkPDF_StructureElementNode,
        nodes: *mut *const SkPDF_StructureElementNode,
    ) -> usize;
}
unsafe extern "C" {
    pub fn C_SkPDF_Metadata_Construct(uninitialized: *mut SkPDF_Metadata);
}
unsafe extern "C" {
    pub fn C_SkPDF_Metadata_destruct(self_: *mut SkPDF_Metadata);
}
unsafe extern "C" {
    pub fn C_SkPDF_MakeDocument(
        stream: *mut SkWStream,
        metadata: *const SkPDF_Metadata,
    ) -> *mut SkDocument;
}
unsafe extern "C" {
    pub fn C_SkPDF_SetNodeId(dst: *mut SkCanvas, nodeID: ::core::ffi::c_int);
}
unsafe extern "C" {
    pub fn C_SkOpBuilder_Construct(uninitialized: *mut SkOpBuilder);
}
unsafe extern "C" {
    pub fn C_SkOpBuilder_destruct(self_: *mut SkOpBuilder);
}
unsafe extern "C" {
    pub fn C_SVG_Types(arg1: *mut SkSVGCanvas);
}
unsafe extern "C" {
    pub fn C_SkSVGCanvas_Make(
        bounds: *const SkRect,
        writer: *mut SkWStream,
        flags: u32,
    ) -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_Utils_Types(
        arg1: *mut SkShadowFlags,
        arg2: *mut SkShadowUtils,
        arg3: *mut SkTextUtils,
        arg4: *mut SkParsePath,
        arg5: *mut SkCustomTypefaceBuilder,
    );
}
unsafe extern "C" {
    pub fn C_Sk3DView_new() -> *mut Sk3DView;
}
unsafe extern "C" {
    pub fn C_Sk3DView_delete(self_: *mut Sk3DView);
}
unsafe extern "C" {
    pub fn C_SkCustomTypefaceBuilder_destruct(self_: *mut SkCustomTypefaceBuilder);
}
unsafe extern "C" {
    pub fn C_SkCustomTypefaceBuilder_detach(self_: *mut SkCustomTypefaceBuilder)
    -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkCustomTypefaceBuilder_setGlyph(
        self_: *mut SkCustomTypefaceBuilder,
        glyph: SkGlyphID,
        advance: f32,
        drawable: *mut SkDrawable,
        bounds: *const SkRect,
    );
}
unsafe extern "C" {
    pub fn C_SkCustomTypefaceBuilder_FromData(
        data: *mut SkData,
        fontArguments: *const SkFontArguments,
    ) -> *mut SkTypeface;
}
unsafe extern "C" {
    pub fn C_SkMakeNullCanvas() -> *mut SkCanvas;
}
unsafe extern "C" {
    pub fn C_SkOrderedFontMgr_new() -> *mut SkOrderedFontMgr;
}
unsafe extern "C" {
    pub fn C_SkOrderedFontMgr_append(self_: *mut SkOrderedFontMgr, fontMgr: *mut SkFontMgr);
}
unsafe extern "C" {
    pub fn C_SkParsePath_ToSVGString(
        self_: *const SkPath,
        uninitialized: *mut SkString,
        encoding: SkParsePath_PathEncoding,
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct RustStream {
    pub _base: SkStream,
    pub m_data: *mut ::core::ffi::c_void,
    pub m_length: usize,
    pub m_isEof: bool,
    pub m_read: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::core::ffi::c_void,
            arg2: *mut ::core::ffi::c_void,
            arg3: usize,
        ) -> usize,
    >,
    pub m_seekAbsolute: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: usize) -> bool,
    >,
    pub m_seekRelative: ::core::option::Option<
        unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: ::core::ffi::c_long) -> bool,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of RustStream"][::core::mem::size_of::<RustStream>() - 56usize];
    ["Alignment of RustStream"][::core::mem::align_of::<RustStream>() - 8usize];
    ["Offset of field: RustStream::m_data"][::core::mem::offset_of!(RustStream, m_data) - 8usize];
    ["Offset of field: RustStream::m_length"]
        [::core::mem::offset_of!(RustStream, m_length) - 16usize];
    ["Offset of field: RustStream::m_isEof"]
        [::core::mem::offset_of!(RustStream, m_isEof) - 24usize];
    ["Offset of field: RustStream::m_read"][::core::mem::offset_of!(RustStream, m_read) - 32usize];
    ["Offset of field: RustStream::m_seekAbsolute"]
        [::core::mem::offset_of!(RustStream, m_seekAbsolute) - 40usize];
    ["Offset of field: RustStream::m_seekRelative"]
        [::core::mem::offset_of!(RustStream, m_seekRelative) - 48usize];
};
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10RustStreamC1EPvmPFmS0_S0_mEPFbS0_mEPFbS0_lE"]
    pub fn RustStream_RustStream(
        this: *mut RustStream,
        data: *mut ::core::ffi::c_void,
        length: usize,
        read: ::core::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::core::ffi::c_void,
                arg2: *mut ::core::ffi::c_void,
                arg3: usize,
            ) -> usize,
        >,
        seekAbsolute: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: usize) -> bool,
        >,
        seekRelative: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: ::core::ffi::c_long) -> bool,
        >,
    );
}
impl RustStream {
    #[inline]
    pub unsafe fn new(
        data: *mut ::core::ffi::c_void,
        length: usize,
        read: ::core::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::core::ffi::c_void,
                arg2: *mut ::core::ffi::c_void,
                arg3: usize,
            ) -> usize,
        >,
        seekAbsolute: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: usize) -> bool,
        >,
        seekRelative: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: ::core::ffi::c_long) -> bool,
        >,
    ) -> Self {
        let mut __bindgen_tmp = ::core::mem::MaybeUninit::uninit();
        RustStream_RustStream(
            __bindgen_tmp.as_mut_ptr(),
            data,
            length,
            read,
            seekAbsolute,
            seekRelative,
        );
        __bindgen_tmp.assume_init()
    }
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10RustStream4readEPvm"]
    pub fn RustStream_read(
        this: *mut ::core::ffi::c_void,
        buffer: *mut ::core::ffi::c_void,
        count: usize,
    ) -> usize;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10RustStream6rewindEv"]
    pub fn RustStream_rewind(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10RustStream4seekEm"]
    pub fn RustStream_seek(this: *mut ::core::ffi::c_void, pos: usize) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZN10RustStream4moveEl"]
    pub fn RustStream_move(this: *mut ::core::ffi::c_void, offset: ::core::ffi::c_long) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10RustStream7isAtEndEv"]
    pub fn RustStream_isAtEnd(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10RustStream9hasLengthEv"]
    pub fn RustStream_hasLength(this: *mut ::core::ffi::c_void) -> bool;
}
unsafe extern "C" {
    #[link_name = "\u{1}_ZNK10RustStream9getLengthEv"]
    pub fn RustStream_getLength(this: *mut ::core::ffi::c_void) -> usize;
}
unsafe extern "C" {
    pub fn C_RustStream_new(
        data: *mut ::core::ffi::c_void,
        length: usize,
        read: ::core::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::core::ffi::c_void,
                arg2: *mut ::core::ffi::c_void,
                arg3: usize,
            ) -> usize,
        >,
        seekAbsolute: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: usize) -> bool,
        >,
        seekRelative: ::core::option::Option<
            unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void, arg2: ::core::ffi::c_long) -> bool,
        >,
    ) -> *mut RustStream;
}
unsafe extern "C" {
    pub fn C_RustStream_delete(stream: *mut RustStream);
}
#[repr(C)]
#[derive(Debug)]
pub struct RustWStream {
    pub _base: SkWStream,
    pub m_data: *mut ::core::ffi::c_void,
    pub m_length: usize,
    pub m_write: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::core::ffi::c_void,
            arg2: *const ::core::ffi::c_void,
            arg3: usize,
        ) -> bool,
    >,
    pub m_flush: ::core::option::Option<unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of RustWStream"][::core::mem::size_of::<RustWStream>() - 40usize];
    ["Alignment of RustWStream"][::core::mem::align_of::<RustWStream>() - 8usize];
    ["Offset of field: RustWStream::m_data"][::core::mem::offset_of!(RustWStream, m_data) - 8usize];
    ["Offset of field: RustWStream::m_length"]
        [::core::mem::offset_of!(RustWStream, m_length) - 16usize];
    ["Offset of field: RustWStream::m_write"]
        [::core::mem::offset_of!(RustWStream, m_write) - 24usize];
    ["Offset of field: RustWStream::m_flush"]
        [::core::mem::offset_of!(RustWStream, m_flush) - 32usize];
};
unsafe extern "C" {
    pub fn C_RustWStream_construct(
        out: *mut RustWStream,
        data: *mut ::core::ffi::c_void,
        write: ::core::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::core::ffi::c_void,
                arg2: *const ::core::ffi::c_void,
                arg3: usize,
            ) -> bool,
        >,
        flush: ::core::option::Option<unsafe extern "C" fn(arg1: *mut ::core::ffi::c_void)>,
    );
}
unsafe extern "C" {
    pub fn C_RustWStream_destruct(stream: *mut RustWStream);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _bindgen_ty_27 {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _bindgen_ty_28 {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_char_traits_open0_char_close0"]
        [::core::mem::size_of::<std_char_traits>() - 1usize];
    ["Align of template specialization: std_char_traits_open0_char_close0"]
        [::core::mem::align_of::<std_char_traits>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_char_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_char_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::core::ffi::c_uint,
    pub fp_offset: ::core::ffi::c_uint,
    pub overflow_arg_area: *mut ::core::ffi::c_void,
    pub reg_save_area: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __va_list_tag"][::core::mem::size_of::<__va_list_tag>() - 24usize];
    ["Alignment of __va_list_tag"][::core::mem::align_of::<__va_list_tag>() - 8usize];
    ["Offset of field: __va_list_tag::gp_offset"]
        [::core::mem::offset_of!(__va_list_tag, gp_offset) - 0usize];
    ["Offset of field: __va_list_tag::fp_offset"]
        [::core::mem::offset_of!(__va_list_tag, fp_offset) - 4usize];
    ["Offset of field: __va_list_tag::overflow_arg_area"]
        [::core::mem::offset_of!(__va_list_tag, overflow_arg_area) - 8usize];
    ["Offset of field: __va_list_tag::reg_save_area"]
        [::core::mem::offset_of!(__va_list_tag, reg_save_area) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_char_traits_open0_char_close0"]
        [::core::mem::size_of::<std_char_traits>() - 1usize];
    ["Align of template specialization: std_char_traits_open0_char_close0"]
        [::core::mem::align_of::<std_char_traits>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkString_Rec_close0"]
        [::core::mem::size_of::<sk_sp<SkString_Rec>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkString_Rec_close0"]
        [::core::mem::align_of::<sk_sp<SkString_Rec>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkString_Rec_close0"]
        [::core::mem::size_of::<sk_sp<SkString_Rec>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkString_Rec_close0"]
        [::core::mem::align_of::<sk_sp<SkString_Rec>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_SkString_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_SkString_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint3>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint3>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint3>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint3>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint3>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint3_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint3>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkVector_close0"]
        [::core::mem::size_of::<SkSpan<SkVector>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkVector_close0"]
        [::core::mem::align_of::<SkSpan<SkVector>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkVector_close0"]
        [::core::mem::size_of::<SkSpan<SkVector>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkVector_close0"]
        [::core::mem::align_of::<SkSpan<SkVector>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkNVRefCnt_open0_SkData_close0"]
        [::core::mem::size_of::<SkNVRefCnt>() - 4usize];
    ["Align of template specialization: SkNVRefCnt_open0_SkData_close0"]
        [::core::mem::align_of::<SkNVRefCnt>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_std_byte_close0"]
        [::core::mem::size_of::<SkSpan<std_byte>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_std_byte_close0"]
        [::core::mem::align_of::<SkSpan<std_byte>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkNVRefCnt_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<SkNVRefCnt>() - 4usize];
    ["Align of template specialization: SkNVRefCnt_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<SkNVRefCnt>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkEncodedInfo_ICCProfile_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkCodecs_Decoder_close0"]
        [::core::mem::size_of::<SkSpan<SkCodecs_Decoder>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkCodecs_Decoder_close0"]
        [::core::mem::align_of::<SkSpan<SkCodecs_Decoder>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkCodecs_Decoder_close0"]
        [::core::mem::size_of::<SkSpan<SkCodecs_Decoder>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkCodecs_Decoder_close0"]
        [::core::mem::align_of::<SkSpan<SkCodecs_Decoder>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPixelRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPixelRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPixelRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPixelRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPixelRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPixelRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPixelRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPixelRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMipmap_close0"]
        [::core::mem::size_of::<sk_sp<SkMipmap>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMipmap_close0"]
        [::core::mem::align_of::<sk_sp<SkMipmap>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::size_of::<sk_sp<SkFlattenable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::align_of::<sk_sp<SkFlattenable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::size_of::<sk_sp<SkFlattenable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::align_of::<sk_sp<SkFlattenable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkMaskFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkMaskFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkMaskFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkMaskFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkMaskFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkMaskFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkRasterHandleAllocator_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkRasterHandleAllocator_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::size_of::<sk_sp<SkDevice>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::align_of::<sk_sp<SkDevice>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_sk_sp_open1_SkImageFilter_close1_close0"]
        [::core::mem::size_of::<SkSpan<sk_sp<SkImageFilter>>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_sk_sp_open1_SkImageFilter_close1_close0"]
        [::core::mem::align_of::<SkSpan<sk_sp<SkImageFilter>>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_uint32_t_close0"]
        [::core::mem::size_of::<SkSpan<u32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_uint32_t_close0"]
        [::core::mem::align_of::<SkSpan<u32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_const_char_close0"]
        [::core::mem::size_of::<SkSpan<::core::ffi::c_char>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_const_char_close0"]
        [::core::mem::align_of::<SkSpan<::core::ffi::c_char>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::size_of::<SkSpan<SkRSXform>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::align_of::<SkSpan<SkRSXform>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::size_of::<sk_sp<SkVertices>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::align_of::<sk_sp<SkVertices>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::size_of::<SkSpan<SkRSXform>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::align_of::<SkSpan<SkRSXform>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRect_close0"]
        [::core::mem::size_of::<SkSpan<SkRect>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRect_close0"]
        [::core::mem::align_of::<SkSpan<SkRect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkColor_close0"]
        [::core::mem::size_of::<SkSpan<SkColor>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkColor_close0"]
        [::core::mem::align_of::<SkSpan<SkColor>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::size_of::<sk_sp<SkDevice>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::align_of::<sk_sp<SkDevice>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkImageFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImageFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkImageFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::size_of::<sk_sp<SkDevice>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::align_of::<sk_sp<SkDevice>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSpecialImage_close0"]
        [::core::mem::size_of::<sk_sp<SkSpecialImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSpecialImage_close0"]
        [::core::mem::align_of::<sk_sp<SkSpecialImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSpecialImage_close0"]
        [::core::mem::size_of::<sk_sp<SkSpecialImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSpecialImage_close0"]
        [::core::mem::align_of::<sk_sp<SkSpecialImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCanvas_Layer_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCanvas_Layer_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCanvas_BackImage_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCanvas_BackImage_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::size_of::<sk_sp<SkDevice>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::align_of::<sk_sp<SkDevice>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::size_of::<sk_sp<SkDevice>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDevice_close0"]
        [::core::mem::align_of::<sk_sp<SkDevice>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkRasterHandleAllocator_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkRasterHandleAllocator_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_sktext_GlyphRunBuilder_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_sktext_GlyphRunBuilder_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorTable_close0"]
        [::core::mem::size_of::<sk_sp<SkColorTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorTable_close0"]
        [::core::mem::align_of::<sk_sp<SkColorTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorTable_close0"]
        [::core::mem::size_of::<sk_sp<SkColorTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorTable_close0"]
        [::core::mem::align_of::<sk_sp<SkColorTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkContourMeasure_Segment_close0"]
        [::core::mem::size_of::<SkSpan<SkContourMeasure_Segment>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkContourMeasure_Segment_close0"]
        [::core::mem::align_of::<SkSpan<SkContourMeasure_Segment>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkContourMeasure_close0"]
        [::core::mem::size_of::<sk_sp<SkContourMeasure>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkContourMeasure_close0"]
        [::core::mem::align_of::<sk_sp<SkContourMeasure>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkContourMeasureIter_Impl_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkContourMeasureIter_Impl_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::size_of::<sk_sp<SkDataTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::align_of::<sk_sp<SkDataTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::size_of::<sk_sp<SkDataTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::align_of::<sk_sp<SkDataTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::size_of::<sk_sp<SkDataTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::align_of::<sk_sp<SkDataTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::size_of::<sk_sp<SkDataTable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDataTable_close0"]
        [::core::mem::align_of::<sk_sp<SkDataTable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::size_of::<SkSpan<SkPathVerb>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::align_of::<SkSpan<SkPathVerb>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::size_of::<SkSpan<f32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::align_of::<SkSpan<f32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::size_of::<SkSpan<SkPathVerb>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::align_of::<SkSpan<SkPathVerb>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::size_of::<SkSpan<f32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::align_of::<SkSpan<f32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::size_of::<SkSpan<SkPathVerb>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::align_of::<SkSpan<SkPathVerb>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::size_of::<SkSpan<f32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_const_float_close0"]
        [::core::mem::align_of::<SkSpan<f32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::size_of::<SkSpan<SkPathVerb>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPathVerb_close0"]
        [::core::mem::align_of::<SkSpan<SkPathVerb>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::size_of::<SkSpan<SkScalar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::align_of::<SkSpan<SkScalar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_uint8_t_close0"]
        [::core::mem::size_of::<SkSpan<u8>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_uint8_t_close0"]
        [::core::mem::align_of::<SkSpan<u8>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::size_of::<SkSpan<SkScalar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::align_of::<SkSpan<SkScalar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPathRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPathRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    [
        "Size of template specialization: SkSpan_open0_SkFontArguments_VariationPosition_Coordinate_close0",
    ][::core::mem::size_of::<SkSpan<SkFontArguments_VariationPosition_Coordinate>>() - 16usize];
    [
        "Align of template specialization: SkSpan_open0_SkFontArguments_VariationPosition_Coordinate_close0",
    ][::core::mem::align_of::<SkSpan<SkFontArguments_VariationPosition_Coordinate>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkFontParameters_Variation_Axis_close0"]
        [::core::mem::size_of::<SkSpan<SkFontParameters_Variation_Axis>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkFontParameters_Variation_Axis_close0"]
        [::core::mem::align_of::<SkSpan<SkFontParameters_Variation_Axis>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::size_of::<sk_sp<SkFontMgr>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::align_of::<sk_sp<SkFontMgr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::size_of::<SkSpan<SkUnichar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::align_of::<SkSpan<SkUnichar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkFontTableTag_close0"]
        [::core::mem::size_of::<SkSpan<SkFontTableTag>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkFontTableTag_close0"]
        [::core::mem::align_of::<SkSpan<SkFontTableTag>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_int32_t_close0"]
        [::core::mem::size_of::<SkSpan<i32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_int32_t_close0"]
        [::core::mem::align_of::<SkSpan<i32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::size_of::<SkSpan<SkUnichar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::align_of::<SkSpan<SkUnichar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    [
        "Size of template specialization: SkSpan_open0_SkFontArguments_VariationPosition_Coordinate_close0",
    ][::core::mem::size_of::<SkSpan<SkFontArguments_VariationPosition_Coordinate>>() - 16usize];
    [
        "Align of template specialization: SkSpan_open0_SkFontArguments_VariationPosition_Coordinate_close0",
    ][::core::mem::align_of::<SkSpan<SkFontArguments_VariationPosition_Coordinate>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkFontParameters_Variation_Axis_close0"]
        [::core::mem::size_of::<SkSpan<SkFontParameters_Variation_Axis>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkFontParameters_Variation_Axis_close0"]
        [::core::mem::align_of::<SkSpan<SkFontParameters_Variation_Axis>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::size_of::<SkSpan<SkUnichar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::align_of::<SkSpan<SkUnichar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_int32_t_close0"]
        [::core::mem::size_of::<SkSpan<i32>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_int32_t_close0"]
        [::core::mem::align_of::<SkSpan<i32>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkFontTableTag_close0"]
        [::core::mem::size_of::<SkSpan<SkFontTableTag>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkFontTableTag_close0"]
        [::core::mem::align_of::<SkSpan<SkFontTableTag>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::size_of::<SkSpan<SkUnichar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkUnichar_close0"]
        [::core::mem::align_of::<SkSpan<SkUnichar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::size_of::<SkSpan<SkScalar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::align_of::<SkSpan<SkScalar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRect_close0"]
        [::core::mem::size_of::<SkSpan<SkRect>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRect_close0"]
        [::core::mem::align_of::<SkSpan<SkRect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::size_of::<SkSpan<SkScalar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::align_of::<SkSpan<SkScalar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_float_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_float_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::size_of::<SkSpan<SkGlyphID>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkGlyphID_close0"]
        [::core::mem::align_of::<SkSpan<SkGlyphID>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::size_of::<sk_sp<SkFontMgr>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::align_of::<sk_sp<SkFontMgr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkImageGenerator_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkImageGenerator_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkMaskFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkMaskFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkMaskFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkMaskFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkMaskFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::size_of::<sk_sp<SkIDChangeListener>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::align_of::<sk_sp<SkIDChangeListener>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::size_of::<sk_sp<SkIDChangeListener>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::align_of::<sk_sp<SkIDChangeListener>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPathRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPathRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPathRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPathRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::size_of::<sk_sp<SkPathRef>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathRef_close0"]
        [::core::mem::align_of::<sk_sp<SkPathRef>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::size_of::<sk_sp<SkIDChangeListener>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::align_of::<sk_sp<SkIDChangeListener>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkContourMeasure_close0"]
        [::core::mem::size_of::<sk_sp<SkContourMeasure>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkContourMeasure_close0"]
        [::core::mem::align_of::<sk_sp<SkContourMeasure>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBBoxHierarchy_close0"]
        [::core::mem::size_of::<sk_sp<SkBBoxHierarchy>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBBoxHierarchy_close0"]
        [::core::mem::align_of::<sk_sp<SkBBoxHierarchy>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::size_of::<sk_sp<SkPicture>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPicture_close0"]
        [::core::mem::align_of::<sk_sp<SkPicture>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::size_of::<sk_sp<SkDrawable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::align_of::<sk_sp<SkDrawable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBBoxHierarchy_close0"]
        [::core::mem::size_of::<sk_sp<SkBBoxHierarchy>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBBoxHierarchy_close0"]
        [::core::mem::align_of::<sk_sp<SkBBoxHierarchy>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkRecordCanvas_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkRecordCanvas_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkRecord_close0"]
        [::core::mem::size_of::<sk_sp<SkRecord>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkRecord_close0"]
        [::core::mem::align_of::<sk_sp<SkRecord>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::size_of::<sk_sp<SkIDChangeListener>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkIDChangeListener_close0"]
        [::core::mem::align_of::<sk_sp<SkIDChangeListener>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkMemoryStream_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::size_of::<sk_sp<SkSurface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSurface_close0"]
        [::core::mem::align_of::<sk_sp<SkSurface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::size_of::<sk_sp<SkImage>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkImage_close0"]
        [::core::mem::align_of::<sk_sp<SkImage>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkNVRefCnt_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<SkNVRefCnt>() - 4usize];
    ["Align of template specialization: SkNVRefCnt_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<SkNVRefCnt>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::size_of::<SkSpan<SkScalar>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkScalar_close0"]
        [::core::mem::align_of::<SkSpan<SkScalar>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::size_of::<SkSpan<SkPoint>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkPoint_close0"]
        [::core::mem::align_of::<SkSpan<SkPoint>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::size_of::<SkSpan<SkRSXform>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRSXform_close0"]
        [::core::mem::align_of::<SkSpan<SkRSXform>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::size_of::<sk_sp<SkTextBlob>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTextBlob_close0"]
        [::core::mem::align_of::<sk_sp<SkTextBlob>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkNVRefCnt_open0_SkVertices_close0"]
        [::core::mem::size_of::<SkNVRefCnt>() - 4usize];
    ["Align of template specialization: SkNVRefCnt_open0_SkVertices_close0"]
        [::core::mem::align_of::<SkNVRefCnt>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::size_of::<sk_sp<SkVertices>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::align_of::<sk_sp<SkVertices>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::size_of::<sk_sp<SkVertices>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::align_of::<sk_sp<SkVertices>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::size_of::<sk_sp<SkVertices>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkVertices_close0"]
        [::core::mem::align_of::<sk_sp<SkVertices>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_float_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_float_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkPDFArray_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkPDFArray_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_int_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkPDF_StructureElementNode_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    [
        "Align of template specialization: std_default_delete_open0_SkPDF_StructureElementNode_close0",
    ][::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    [
        "Size of template specialization: std_allocator_open0_std_unique_ptr_open1_SkPDF_StructureElementNode_std_default_delete_open2_SkPDF_StructureElementNode_close2_close1_close0",
    ][::core::mem::size_of::<std_allocator>() - 1usize];
    [
        "Align of template specialization: std_allocator_open0_std_unique_ptr_open1_SkPDF_StructureElementNode_std_default_delete_open2_SkPDF_StructureElementNode_close2_close1_close0",
    ][::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkPDF_StructureElementNode_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    [
        "Align of template specialization: std_default_delete_open0_SkPDF_StructureElementNode_close0",
    ][::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCodec_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkPathEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkPathEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkPathEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::size_of::<sk_sp<SkColorSpace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorSpace_close0"]
        [::core::mem::align_of::<sk_sp<SkColorSpace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkRuntimeEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkRuntimeEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkRuntimeEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkRuntimeEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::size_of::<sk_sp<SkFlattenable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::align_of::<sk_sp<SkFlattenable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::size_of::<sk_sp<SkFlattenable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFlattenable_close0"]
        [::core::mem::align_of::<sk_sp<SkFlattenable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::size_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::align_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::size_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::align_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::size_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 16usize];
    ["Align of template specialization: SkSpan_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::align_of::<SkSpan<SkRuntimeEffect_ChildPtr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkSL_DebugTrace_close0"]
        [::core::mem::size_of::<sk_sp<SkSL_DebugTrace>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkSL_DebugTrace_close0"]
        [::core::mem::align_of::<sk_sp<SkSL_DebugTrace>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::size_of::<sk_sp<SkShader>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkShader_close0"]
        [::core::mem::align_of::<sk_sp<SkShader>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::size_of::<sk_sp<SkColorFilter>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkColorFilter_close0"]
        [::core::mem::align_of::<sk_sp<SkColorFilter>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::size_of::<sk_sp<SkBlender>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkBlender_close0"]
        [::core::mem::align_of::<sk_sp<SkBlender>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkRuntimeEffect_close0"]
        [::core::mem::size_of::<sk_sp<SkRuntimeEffect>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkRuntimeEffect_close0"]
        [::core::mem::align_of::<sk_sp<SkRuntimeEffect>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_SkRuntimeEffect_ChildPtr_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: SkTDArray_open0_SkPathOp_close0"]
        [::core::mem::size_of::<SkTDArray>() - 24usize];
    ["Align of template specialization: SkTDArray_open0_SkPathOp_close0"]
        [::core::mem::align_of::<SkTDArray>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkCanvas_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::size_of::<sk_sp<SkDrawable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::align_of::<sk_sp<SkDrawable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::size_of::<sk_sp<SkDrawable>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkDrawable_close0"]
        [::core::mem::align_of::<sk_sp<SkDrawable>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    [
        "Size of template specialization: std_allocator_open0_SkCustomTypefaceBuilder_GlyphRec_close0",
    ][::core::mem::size_of::<std_allocator>() - 1usize];
    [
        "Align of template specialization: std_allocator_open0_SkCustomTypefaceBuilder_GlyphRec_close0",
    ][::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::size_of::<sk_sp<SkFontMgr>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::align_of::<sk_sp<SkFontMgr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::size_of::<sk_sp<SkFontStyleSet>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontStyleSet_close0"]
        [::core::mem::align_of::<sk_sp<SkFontStyleSet>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::size_of::<sk_sp<SkData>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkData_close0"]
        [::core::mem::align_of::<sk_sp<SkData>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::size_of::<std_default_delete>() - 1usize];
    ["Align of template specialization: std_default_delete_open0_SkStreamAsset_close0"]
        [::core::mem::align_of::<std_default_delete>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::size_of::<sk_sp<SkTypeface>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkTypeface_close0"]
        [::core::mem::align_of::<sk_sp<SkTypeface>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::size_of::<sk_sp<SkFontMgr>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::align_of::<sk_sp<SkFontMgr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_allocator_open0_sk_sp_open1_SkFontMgr_close1_close0"]
        [::core::mem::size_of::<std_allocator>() - 1usize];
    ["Align of template specialization: std_allocator_open0_sk_sp_open1_SkFontMgr_close1_close0"]
        [::core::mem::align_of::<std_allocator>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::size_of::<sk_sp<SkFontMgr>>() - 8usize];
    ["Align of template specialization: sk_sp_open0_SkFontMgr_close0"]
        [::core::mem::align_of::<sk_sp<SkFontMgr>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: Sink_open0_bool__close0"]
        [::core::mem::size_of::<Sink<bool>>() - 24usize];
    ["Align of template specialization: Sink_open0_bool__close0"]
        [::core::mem::align_of::<Sink<bool>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: VecSink_open0_SkScalar_close0"]
        [::core::mem::size_of::<VecSink<SkScalar>>() - 24usize];
    ["Align of template specialization: VecSink_open0_SkScalar_close0"]
        [::core::mem::align_of::<VecSink<SkScalar>>() - 8usize];
};
