/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import com.plantuml.api.cheerpj.WasmLog;
import smetana.core.UnsupportedC;
import smetana.core.ZType;

public final class CArrayOfStar<O>
extends UnsupportedC {
    private final Object[] data;
    private final int offset;

    public String toString() {
        return "*Array offset=" + this.offset + " [" + this.data.length + "]" + this.data;
    }

    private CArrayOfStar(Object[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public static <O> CArrayOfStar<O> ALLOC(int size, ZType type) {
        CArrayOfStar<O> result = new CArrayOfStar<O>(new Object[size], 0);
        return result;
    }

    public static <O> CArrayOfStar<O> REALLOC(int size, CArrayOfStar<O> old, ZType type) {
        if (old == null) {
            return CArrayOfStar.ALLOC(size, type);
        }
        if (size <= old.data.length) {
            return old;
        }
        if (old.offset != 0) {
            throw new IllegalStateException();
        }
        WasmLog.log("Realloc* from " + old.data.length + " to " + size);
        CArrayOfStar<O> result = CArrayOfStar.ALLOC(size, type);
        System.arraycopy(old.data, 0, result.data, 0, old.data.length);
        return result;
    }

    public int comparePointer_(CArrayOfStar<O> other) {
        if (this.data != other.data) {
            throw new IllegalArgumentException();
        }
        return this.offset - other.offset;
    }

    public O get_(int i) {
        return (O)this.data[i + this.offset];
    }

    public void set_(int i, O value) {
        this.data[i + this.offset] = value;
    }

    public CArrayOfStar<O> plus_(int delta) {
        return new CArrayOfStar<O>(this.data, this.offset + delta);
    }

    public void _swap(int i, int j) {
        if (this.offset != 0) {
            throw new IllegalStateException();
        }
        Object tmp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = tmp;
    }
}

