/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.dom.DOMException;

class PropertyDescriptorStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private boolean hasSyntax;
    private boolean isUniversalSyntax;
    private boolean hasInherits;

    public PropertyDescriptorStyleDeclaration(BaseCSSDeclarationRule parentRule) {
        super(parentRule);
    }

    public PropertyDescriptorStyleDeclaration() {
    }

    public PropertyDescriptorStyleDeclaration(PropertyDescriptorStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    @Override
    public void addStyle(BaseCSSStyleDeclaration style) {
        super.addStyle(style);
        this.updateValidity();
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit lunit, boolean important) throws DOMException {
        if ("syntax".equals(propertyName = this.getCanonicalPropertyName(propertyName))) {
            CSSValueSyntax syn;
            if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                throw new DOMException(17, "'syntax' descriptor in @property rule must be a string.");
            }
            String def = lunit.getStringValue();
            try {
                syn = new SyntaxParser().parseSyntax(def);
            }
            catch (CSSException e) {
                DOMException ex = new DOMException(12, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            this.isUniversalSyntax = syn.getName().equals("*");
            this.hasSyntax = true;
        } else if ("inherits".equals(propertyName)) {
            String s;
            if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || !"true".equalsIgnoreCase(s = lunit.getStringValue().toLowerCase(Locale.ROOT)) && !"false".equalsIgnoreCase(s)) {
                throw new DOMException(17, "'inherits' descriptor in @property rule must be either 'true' or 'false'.");
            }
            this.hasInherits = true;
        } else if ("initial-value".equals(propertyName)) {
            StyleValue cssvalue;
            ValueFactory factory = this.getValueFactory();
            try {
                cssvalue = factory.createCSSValue(lunit, this);
            }
            catch (DOMException e) {
                StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for " + propertyName, e);
                    ex.setValueText(PropertyDescriptorStyleDeclaration.lexicalUnitToString(lunit));
                    errHandler.wrongValue(propertyName, ex);
                }
                throw e;
            }
            if (cssvalue.getCssValueType() != CSSValue.CssType.TYPED) {
                CSSPropertyValueException ex = null;
                StyleDeclarationErrorHandler errHandler = this.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    ex = new CSSPropertyValueException("Wrong type for 'initial-value'." + propertyName);
                    ex.setValueText(PropertyDescriptorStyleDeclaration.lexicalUnitToString(lunit));
                    errHandler.wrongValue(propertyName, ex);
                }
                DOMException exception = new DOMException(17, "Wrong type for 'initial-value'.");
                if (ex != null) {
                    exception.initCause(ex);
                }
                throw exception;
            }
            LexicalValue lexicalValue = new LexicalValue();
            lexicalValue.setLexicalUnit(lunit);
            this.setProperty(propertyName, lexicalValue, important);
            return;
        }
        super.setProperty(propertyName, lunit, important);
    }

    @Override
    public String removeProperty(String propertyName) {
        if (!("syntax".equals(propertyName = this.getCanonicalPropertyName(propertyName)) || "inherits".equals(propertyName) || !this.isUniversalSyntax && "initial-value".equals(propertyName))) {
            return super.removeProperty(propertyName);
        }
        return "";
    }

    void updateValidity() {
        this.hasSyntax = false;
        this.isUniversalSyntax = false;
        this.hasInherits = false;
        for (int i = 0; i < this.getLength(); ++i) {
            String property = this.item(i);
            StyleValue value = this.getPropertyCSSValue(property);
            if ("syntax".equalsIgnoreCase(property)) {
                if (value.getPrimitiveType() != CSSValue.Type.STRING) continue;
                this.hasSyntax = true;
                this.isUniversalSyntax = ((CSSTypedValue)((Object)value)).getStringValue().trim().equals("*");
                continue;
            }
            if (!"inherits".equalsIgnoreCase(property) || value.getPrimitiveType() != CSSValue.Type.IDENT) continue;
            String s = ((CSSTypedValue)((Object)value)).getStringValue().trim();
            this.hasInherits = "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
        }
    }

    boolean isValidDeclaration() {
        return this.hasSyntax && this.hasInherits && (this.isUniversalSyntax || this.hasInitial());
    }

    private boolean hasInitial() {
        PropertyRule rule = (PropertyRule)this.getParentRule();
        CSSValueSyntax syntax = rule.getSyntax();
        StyleValue value = this.getPropertyCSSValue("initial-value");
        return value != null && value.matches(syntax) == CSSValueSyntax.Match.TRUE;
    }
}

